/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.provider.java.security;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.BIT_STRING;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.crypto.SignatureAlgorithm;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.crypto.TokenSupplierManager;
import org.mozilla.jss.pkcs11.PK11PrivKey;
import org.mozilla.jss.pkcs11.PK11PubKey;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;
import org.mozilla.jss.pkix.primitive.PrivateKeyInfo;
import org.mozilla.jss.pkix.primitive.SubjectPublicKeyInfo;
import org.mozilla.jss.util.Assert;

public class KeyFactorySpi1_2
extends KeyFactorySpi {
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof RSAPublicKeySpec) {
            RSAPublicKeySpec rSAPublicKeySpec = (RSAPublicKeySpec)keySpec;
            SEQUENCE sEQUENCE = new SEQUENCE();
            sEQUENCE.addElement(new INTEGER(rSAPublicKeySpec.getModulus()));
            sEQUENCE.addElement(new INTEGER(rSAPublicKeySpec.getPublicExponent()));
            return PK11PubKey.fromRaw(org.mozilla.jss.crypto.PrivateKey.RSA, ASN1Util.encode(sEQUENCE));
        }
        if (keySpec instanceof DSAPublicKeySpec) {
            DSAPublicKeySpec dSAPublicKeySpec = (DSAPublicKeySpec)keySpec;
            SEQUENCE sEQUENCE = new SEQUENCE();
            sEQUENCE.addElement(new INTEGER(dSAPublicKeySpec.getP()));
            sEQUENCE.addElement(new INTEGER(dSAPublicKeySpec.getQ()));
            sEQUENCE.addElement(new INTEGER(dSAPublicKeySpec.getG()));
            OBJECT_IDENTIFIER oBJECT_IDENTIFIER = null;
            try {
                oBJECT_IDENTIFIER = SignatureAlgorithm.DSASignature.toOID();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                Assert.notReached("no such algorithm as DSA?");
            }
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(oBJECT_IDENTIFIER, sEQUENCE);
            INTEGER iNTEGER = new INTEGER(dSAPublicKeySpec.getY());
            byte[] byArray = ASN1Util.encode(iNTEGER);
            SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(algorithmIdentifier, new BIT_STRING(byArray, 0));
            return PK11PubKey.fromSPKI(ASN1Util.encode(subjectPublicKeyInfo));
        }
        if (keySpec instanceof X509EncodedKeySpec) {
            X509EncodedKeySpec x509EncodedKeySpec = (X509EncodedKeySpec)keySpec;
            return PK11PubKey.fromSPKI(x509EncodedKeySpec.getEncoded());
        }
        throw new InvalidKeySpecException("Unsupported KeySpec type: " + keySpec.getClass().getName());
    }

    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            if (keySpec instanceof RSAPrivateCrtKeySpec) {
                RSAPrivateCrtKeySpec rSAPrivateCrtKeySpec = (RSAPrivateCrtKeySpec)keySpec;
                SEQUENCE sEQUENCE = new SEQUENCE();
                sEQUENCE.addElement(new INTEGER(0L));
                sEQUENCE.addElement(new INTEGER(rSAPrivateCrtKeySpec.getModulus()));
                sEQUENCE.addElement(new INTEGER(rSAPrivateCrtKeySpec.getPublicExponent()));
                sEQUENCE.addElement(new INTEGER(rSAPrivateCrtKeySpec.getPrivateExponent()));
                sEQUENCE.addElement(new INTEGER(rSAPrivateCrtKeySpec.getPrimeP()));
                sEQUENCE.addElement(new INTEGER(rSAPrivateCrtKeySpec.getPrimeQ()));
                sEQUENCE.addElement(new INTEGER(rSAPrivateCrtKeySpec.getPrimeExponentP()));
                sEQUENCE.addElement(new INTEGER(rSAPrivateCrtKeySpec.getPrimeExponentQ()));
                sEQUENCE.addElement(new INTEGER(rSAPrivateCrtKeySpec.getCrtCoefficient()));
                AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(org.mozilla.jss.crypto.PrivateKey.RSA.toOID(), null);
                OCTET_STRING oCTET_STRING = new OCTET_STRING(ASN1Util.encode(sEQUENCE));
                PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo(new INTEGER(0L), algorithmIdentifier, oCTET_STRING, null);
                return PK11PrivKey.fromPrivateKeyInfo(ASN1Util.encode(privateKeyInfo), TokenSupplierManager.getTokenSupplier().getThreadToken());
            }
            if (keySpec instanceof DSAPrivateKeySpec) {
                DSAPrivateKeySpec dSAPrivateKeySpec = (DSAPrivateKeySpec)keySpec;
                SEQUENCE sEQUENCE = new SEQUENCE();
                sEQUENCE.addElement(new INTEGER(dSAPrivateKeySpec.getP()));
                sEQUENCE.addElement(new INTEGER(dSAPrivateKeySpec.getQ()));
                sEQUENCE.addElement(new INTEGER(dSAPrivateKeySpec.getG()));
                AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(org.mozilla.jss.crypto.PrivateKey.DSA.toOID(), sEQUENCE);
                OCTET_STRING oCTET_STRING = new OCTET_STRING(ASN1Util.encode(new INTEGER(dSAPrivateKeySpec.getX())));
                PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo(new INTEGER(0L), algorithmIdentifier, oCTET_STRING, null);
                BigInteger bigInteger = dSAPrivateKeySpec.getG().modPow(dSAPrivateKeySpec.getX(), dSAPrivateKeySpec.getP());
                byte[] byArray = bigInteger.toByteArray();
                if (bigInteger.bitLength() % 8 == 0) {
                    byte[] byArray2 = new byte[byArray.length - 1];
                    Assert._assert(byArray2.length >= 0);
                    System.arraycopy(byArray, 1, byArray2, 0, byArray2.length);
                    byArray = byArray2;
                }
                return PK11PrivKey.fromPrivateKeyInfo(ASN1Util.encode(privateKeyInfo), TokenSupplierManager.getTokenSupplier().getThreadToken(), byArray);
            }
            if (keySpec instanceof PKCS8EncodedKeySpec) {
                return PK11PrivKey.fromPrivateKeyInfo((PKCS8EncodedKeySpec)keySpec, TokenSupplierManager.getTokenSupplier().getThreadToken());
            }
            throw new InvalidKeySpecException("Unsupported KeySpec type: " + keySpec.getClass().getName());
        }
        catch (TokenException tokenException) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            tokenException.printStackTrace(printWriter);
            throw new InvalidKeySpecException("TokenException: " + stringWriter.toString());
        }
    }

    protected KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        throw new InvalidKeySpecException("Exporting raw key data is not supported. Wrap the key instead.");
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        byte[] byArray = key.getEncoded();
        String string = key.getFormat();
        try {
            if (string.equals("SubjectPublicKeyInfo") || string.equalsIgnoreCase("X.509")) {
                X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray);
                return this.engineGeneratePublic(x509EncodedKeySpec);
            }
            if (string.equals("PrivateKeyInfo") || string.equalsIgnoreCase("PKCS#8")) {
                PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray);
                return this.engineGeneratePrivate(pKCS8EncodedKeySpec);
            }
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new InvalidKeyException(invalidKeySpecException.getMessage());
        }
        throw new InvalidKeyException("Unsupported encoding format: " + string);
    }
}

