/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.jmq.jmsclient.ExceptionHandler;
import com.sun.messaging.jmq.jmsclient.MessageImpl;
import com.sun.messaging.jms.MessageFormatException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OptionalDataException;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import javax.jms.JMSException;
import javax.jms.ObjectMessage;

public class ObjectMessageImpl
extends MessageImpl
implements ObjectMessage {
    private ByteArrayOutputStream byteArrayOutputStream = null;
    private ObjectOutputStream objectOutputStream = null;
    private ByteArrayInputStream byteArrayInputStream = null;
    private ObjectInputStream objectInputStream = null;
    private byte[] messageBody = null;

    protected ObjectMessageImpl() throws JMSException {
        this.setPacketType(5);
    }

    @Override
    public void clearBody() throws JMSException {
        this.messageBody = null;
        this.setMessageReadMode(false);
    }

    @Override
    protected void setMessageBodyToPacket() throws JMSException {
        if (this.messageBody == null) {
            return;
        }
        try {
            this.setMessageBody(this.messageBody);
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, "C4014");
        }
    }

    @Override
    protected void getMessageBodyFromPacket() throws JMSException {
        try {
            this.messageBody = this.getMessageBody();
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, "C4015");
        }
    }

    @Override
    public void setObject(Serializable object) throws JMSException {
        this.checkMessageAccess();
        try {
            this.byteArrayOutputStream = new ByteArrayOutputStream();
            this.objectOutputStream = new ObjectOutputStream(this.byteArrayOutputStream);
            this.objectOutputStream.writeObject(object);
            this.objectOutputStream.flush();
            this.messageBody = this.byteArrayOutputStream.toByteArray();
            this.objectOutputStream.close();
            this.byteArrayOutputStream.close();
        }
        catch (Exception e) {
            if (e instanceof NotSerializableException) {
                String errorString = ExceptionHandler.getExceptionMessage(e, "C4014");
                MessageFormatException mfe = new MessageFormatException(errorString, "C4014");
                ExceptionHandler.handleException(e, mfe);
            }
            ExceptionHandler.handleException(e, "C4038");
        }
    }

    @Override
    public Serializable getObject() throws JMSException {
        Serializable object = null;
        if (this.messageBody == null) {
            return null;
        }
        try {
            this.byteArrayInputStream = new ByteArrayInputStream(this.messageBody);
            this.objectInputStream = new ObjectInputStreamWithContextLoader(this.byteArrayInputStream);
            object = (Serializable)this.objectInputStream.readObject();
        }
        catch (Exception e) {
            if (e instanceof InvalidClassException || e instanceof OptionalDataException || e instanceof ClassNotFoundException) {
                String errorString = ExceptionHandler.getExceptionMessage(e, "C4015");
                MessageFormatException jmsex = new MessageFormatException(errorString, "C4015");
                ((JMSException)jmsex).setLinkedException(e);
                ExceptionHandler.throwJMSException(jmsex);
            }
            ExceptionHandler.handleException(e, "C4038");
        }
        return object;
    }

    @Override
    public void dump(PrintStream ps) {
        ps.println("------ ObjectMessageImpl dump ------");
        super.dump(ps);
    }

    @Override
    public String toString() {
        return super.toString();
    }

    static class ObjectInputStreamWithContextLoader
    extends ObjectInputStream {
        public ObjectInputStreamWithContextLoader(InputStream in) throws IOException, StreamCorruptedException {
            super(in);
        }

        protected Class resolveClass(ObjectStreamClass classDesc) throws IOException, ClassNotFoundException {
            try {
                return super.resolveClass(classDesc);
            }
            catch (ClassNotFoundException e) {
                ClassLoader ctxcl = null;
                try {
                    ctxcl = Thread.currentThread().getContextClassLoader();
                }
                catch (SecurityException se) {
                    throw new ClassNotFoundException(e.getMessage() + "; " + se.getMessage());
                }
                if (ctxcl == null) {
                    throw e;
                }
                return Class.forName(classDesc.getName(), false, ctxcl);
            }
        }
    }
}

