/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data;

import com.sun.messaging.jmq.io.MQAddress;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.FaultInjection;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.api.BrokerState;
import com.sun.messaging.jmq.jmsserver.cluster.api.BrokerStatus;
import com.sun.messaging.jmq.jmsserver.cluster.api.ClusterListener;
import com.sun.messaging.jmq.jmsserver.cluster.api.ClusterManager;
import com.sun.messaging.jmq.jmsserver.cluster.api.ClusteredBroker;
import com.sun.messaging.jmq.jmsserver.cluster.api.RemoteTransactionAckEntry;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.BrokerMQAddress;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.data.AutoRollbackType;
import com.sun.messaging.jmq.jmsserver.data.ClusterTransaction;
import com.sun.messaging.jmq.jmsserver.data.DetachedTransactionReaper;
import com.sun.messaging.jmq.jmsserver.data.RemoteTransaction;
import com.sun.messaging.jmq.jmsserver.data.RemoteTransactionInformation;
import com.sun.messaging.jmq.jmsserver.data.TransactionAcknowledgement;
import com.sun.messaging.jmq.jmsserver.data.TransactionBroker;
import com.sun.messaging.jmq.jmsserver.data.TransactionInformation;
import com.sun.messaging.jmq.jmsserver.data.TransactionListLoader;
import com.sun.messaging.jmq.jmsserver.data.TransactionReaper;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.data.TransactionWork;
import com.sun.messaging.jmq.jmsserver.data.TransactionWorkMessage;
import com.sun.messaging.jmq.jmsserver.data.TransactionWorkMessageAck;
import com.sun.messaging.jmq.jmsserver.persist.api.LoadException;
import com.sun.messaging.jmq.jmsserver.persist.api.NoPersistPartitionedStoreImpl;
import com.sun.messaging.jmq.jmsserver.persist.api.PartitionListener;
import com.sun.messaging.jmq.jmsserver.persist.api.PartitionedStore;
import com.sun.messaging.jmq.jmsserver.persist.api.TransactionInfo;
import com.sun.messaging.jmq.jmsserver.persist.api.TxnLoggingStore;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.UnknownTransactionException;
import com.sun.messaging.jmq.util.JMQXid;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class TransactionList
implements ClusterListener,
PartitionListener {
    protected static boolean DEBUG = false;
    public static final boolean DEBUG_CLUSTER_TXN;
    public static final boolean AUTO_ROLLBACK;
    public static final long TXN_REAPINTERVAL;
    public static final int TXN_REAPLIMIT;
    public static final int TXN_REAPLIMIT_OVERTHRESHOLD;
    public static final String XA_TXN_DETACHED_TIMEOUT_PROP = "imq.transaction.detachedTimeout";
    public static final String XA_TXN_DETACHED_RETAINALL_PROP = "imq.transaction.detachedRetainAll";
    public static final String TXN_PRODUCER_MAX_NUM_MSGS_PROP = "imq.transaction.producer.maxNumMsgs";
    public static final String TXN_CONSUMER_MAX_NUM_MSGS_PROP = "imq.transaction.consumer.maxNumMsgs";
    protected static final int defaultProducerMaxMsgCnt;
    protected static final int defaultConsumerMaxMsgCnt;
    TransactionReaper txnReaper = null;
    DetachedTransactionReaper detachedTxnReaper = null;
    HashSet inuse_translist = null;
    HashMap translist = null;
    HashMap remoteTranslist = null;
    HashMap xidTable = null;
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private Lock shareLock = this.lock.readLock();
    private Lock exclusiveLock = this.lock.writeLock();
    PartitionedStore pstore = null;
    protected Vector newlyActivatedBrokers = new Vector();
    protected Vector newlyActivatedPartitions = new Vector();
    protected final CountDownLatch loadCompleteLatch = new CountDownLatch(1);
    protected boolean loadComplete = false;
    private FaultInjection fi = null;
    private Logger logger = Globals.getLogger();
    protected BrokerResources br = Globals.getBrokerResources();
    protected DestinationList DL = null;
    private String logsuffix = "";

    private static long getTXN_REAPINTERVAL() {
        long v = Globals.getConfig().getLongProperty("imq.txn.reapInterval", 900L) * 1000L;
        if (v <= 0L) {
            v = 1000L;
        }
        return v;
    }

    public TransactionList(DestinationList dl) throws BrokerException {
        this.fi = FaultInjection.getInjection();
        this.DL = dl;
        this.pstore = dl.getPartitionedStore();
        if (Globals.getStore().getPartitionModeEnabled()) {
            this.logsuffix = " [" + this.pstore + "]";
        }
        this.translist = new HashMap(1000);
        this.remoteTranslist = new HashMap(1000);
        this.xidTable = new HashMap(1000);
        this.inuse_translist = new HashSet(1000);
        this.txnReaper = new TransactionReaper(this);
        this.detachedTxnReaper = new DetachedTransactionReaper(this);
        ClusterManager cm = Globals.getClusterManager();
        if (cm != null) {
            cm.addEventListener(this);
        }
        try {
            if (Globals.isNewTxnLogEnabled() || this.pstore instanceof TxnLoggingStore && ((TxnLoggingStore)((Object)this.pstore)).isTxnConversionRequired()) {
                ((TxnLoggingStore)((Object)this.pstore)).init();
            }
            if (this.pstore instanceof TxnLoggingStore && ((TxnLoggingStore)((Object)this.pstore)).isTxnConversionRequired()) {
                ((TxnLoggingStore)((Object)this.pstore)).convertTxnFormats(this);
            } else if (!Globals.isNewTxnLogEnabled()) {
                this.loadTransactions();
            } else if (!AUTO_ROLLBACK) {
                TransactionListLoader.loadTransactions(this.pstore, this);
            } else {
                TransactionListLoader.rollbackAllTransactions(this.pstore);
            }
            this.newlyActivatedBrokers.add(Globals.getMyAddress().getMQAddress());
            this.loadComplete = true;
            this.loadCompleteLatch.countDown();
            this.txnReaper.wakeupReaperTimer();
            this.logger.log(8, this.br.getKString("B1390") + this.logsuffix);
        }
        catch (Exception ex) {
            String emsg = this.br.getKString("B2096");
            this.logger.logStack(8, emsg, ex);
            throw new BrokerException(emsg, ex);
        }
    }

    public String toString() {
        block3: {
            block2: {
                if (this.DL == null) break block2;
                TransactionList transactionList = this;
                if (transactionList.DL.isPartitionMode()) break block3;
            }
            return super.toString();
        }
        return this.logsuffix;
    }

    public static TransactionList getTransListByTID(TransactionUID tid) throws BrokerException {
        TransactionList tl = null;
        Globals.getDestinationList();
        TransactionList[] tls = DestinationList.getTransactionList(null);
        for (int i = 0; i < tls.length; ++i) {
            if (tls[i].retrieveState(tid, true) == null) continue;
            if (tl != null) {
                throw new BrokerException(Globals.getBrokerResources().getString("B3100", "More than 1 TransactionList exist for transaction " + tid + ": " + tl + ", " + tls[i]));
            }
            tl = tls[i];
        }
        return tl;
    }

    public static Object[] getTransListAndRemoteState(TransactionUID tid) throws BrokerException {
        TransactionState ts = null;
        Globals.getDestinationList();
        TransactionList[] tls = DestinationList.getTransactionList(null);
        for (int i = 0; i < tls.length; ++i) {
            ts = tls[i].getRemoteTransactionState(tid);
            if (ts == null) continue;
            Object[] oo = new Object[]{tls[i], ts};
            return oo;
        }
        return null;
    }

    public static Object[] getTransactionByCreator(String creator) throws BrokerException {
        TransactionUID tid = null;
        TransactionList tl = null;
        Globals.getDestinationList();
        TransactionList[] tls = DestinationList.getTransactionList(null);
        for (int i = 0; i < tls.length; ++i) {
            tid = tls[i].getTransaction(creator);
            if (tid == null) continue;
            if (tl != null) {
                throw new BrokerException(Globals.getBrokerResources().getString("B3100", "More than 1 TransactionList exist for creator " + creator + ": " + tl + ", " + tls[i]));
            }
            tl = tls[i];
        }
        if (tl != null && tid != null) {
            Object[] oo = new Object[]{tl, tid};
            return oo;
        }
        return null;
    }

    public static TransactionList getTransListByPartitionID(UID pid) throws BrokerException {
        TransactionList tl = null;
        NoPersistPartitionedStoreImpl ps = new NoPersistPartitionedStoreImpl(pid);
        Globals.getDestinationList();
        TransactionList[] tls = DestinationList.getTransactionList(ps);
        tl = tls[0];
        return tl;
    }

    public static List<Object[]> getTransListsAndRemoteTranStates(TransactionUID tid) {
        ArrayList<Object[]> ret = new ArrayList<Object[]>();
        TransactionList tl = null;
        TransactionState ts = null;
        Object[] oo = null;
        Globals.getDestinationList();
        TransactionList[] tls = DestinationList.getTransactionList(null);
        for (int i = 0; i < tls.length; ++i) {
            tl = tls[i];
            if (tl == null || (ts = tl.getRemoteTransactionState(tid)) == null) continue;
            oo = new Object[]{tl, ts};
            ret.add(oo);
        }
        if (ret.size() == 0) {
            return null;
        }
        return ret;
    }

    public static Object[] getTransListAndState(TransactionUID tid, IMQConnection con, boolean inquiry, boolean newtran) {
        Object[] oo = new Object[]{null, null};
        TransactionList[] tls = null;
        TransactionList tl = null;
        TransactionState ts = null;
        if (con != null) {
            Globals.getDestinationList();
            tls = DestinationList.getTransactionList(con.getPartitionedStore());
            tl = tls[0];
            oo[0] = tl;
            if (newtran) {
                if (tl == null) {
                    return null;
                }
                return oo;
            }
            if (tl != null && (ts = tl.retrieveState(tid, inquiry)) != null) {
                oo[0] = tl;
                oo[1] = ts;
                return oo;
            }
        }
        tl = null;
        Globals.getDestinationList();
        tls = DestinationList.getTransactionList(null);
        for (int i = 0; i < tls.length; ++i) {
            tl = tls[i];
            if (tl == null || (ts = tl.retrieveState(tid, inquiry)) == null) continue;
            oo[0] = tl;
            oo[1] = ts;
            return oo;
        }
        return null;
    }

    public static Object[] mapXidToTid(JMQXid xid, IMQConnection con) {
        TransactionList[] tls = null;
        TransactionList tl = null;
        Object ts = null;
        TransactionUID tid = null;
        if (con != null) {
            Globals.getDestinationList();
            tls = DestinationList.getTransactionList(con.getPartitionedStore());
            tl = tls[0];
            if (tl != null && (tid = tl.xidToUID(xid)) != null) {
                Object[] oo = new Object[]{tl, tid};
                return oo;
            }
        }
        tl = null;
        Globals.getDestinationList();
        tls = DestinationList.getTransactionList(null);
        for (int i = 0; i < tls.length; ++i) {
            tl = tls[i];
            if (tl == null || (tid = tl.xidToUID(xid)) == null) continue;
            Object[] oo = new Object[]{tl, tid};
            return oo;
        }
        return null;
    }

    public PartitionedStore getPartitionedStore() {
        return this.pstore;
    }

    public Map getTransactionListMap() {
        return this.translist;
    }

    public Map getRemoteTransactionListMap() {
        return this.remoteTranslist;
    }

    protected boolean isLoadComplete() {
        return this.loadComplete;
    }

    public void postProcess() {
        this.detachedTxnReaper.detachOnephasePrepared();
    }

    public void destroy() {
        if (DEBUG) {
            this.logger.log(8, "Closing transaction list " + this);
        }
        if (this.txnReaper != null) {
            this.txnReaper.destroy();
        }
        if (this.detachedTxnReaper != null) {
            this.detachedTxnReaper.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getDebugState(TransactionUID id) {
        TransactionInformation ti = null;
        RemoteTransactionInformation rti = null;
        this.shareLock.lock();
        try {
            ti = (TransactionInformation)this.translist.get(id);
            rti = (RemoteTransactionInformation)this.remoteTranslist.get(id);
        }
        finally {
            this.shareLock.unlock();
        }
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        if (ti == null && rti == null) {
            ht.put(id.toString(), "UNKNOWN TID");
            return ht;
        }
        if (ti != null) {
            ht.put(id.toString(), ti.getDebugState());
        }
        if (rti != null) {
            ht.put(id.toString() + "(remote)", rti.getDebugState());
        }
        return ht;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockTakeoverTxns(List txns) {
        TransactionInformation ti = null;
        for (TransactionUID tid : txns) {
            if (tid == null) continue;
            this.shareLock.lock();
            try {
                ti = (TransactionInformation)this.translist.get(tid);
            }
            finally {
                this.shareLock.unlock();
            }
            if (ti == null) continue;
            ti.releaseTakeoverLock();
        }
    }

    public Map loadTakeoverTxns(List txns, List remoteTxns, Map<String, String> msgs) throws BrokerException, IOException {
        List<TransactionAcknowledgement> l;
        TransactionAcknowledgement[] ta;
        TransactionState ts;
        String em;
        TransactionInfo ti;
        this.logger.log(8, Globals.getBrokerResources().getKString("B1283", txns.size()));
        Iterator itr = txns.iterator();
        HashMap<TransactionUID, List<TransactionAcknowledgement>> acks = new HashMap<TransactionUID, List<TransactionAcknowledgement>>();
        while (itr.hasNext()) {
            TransactionUID tid = (TransactionUID)itr.next();
            ti = null;
            try {
                ti = this.pstore.getTransactionInfo(tid);
            }
            catch (Exception e) {
                em = "Failed to get transaction " + tid + " information from store after takeover";
                this.logger.logStack(32, "B3100", em, (Throwable)e);
                throw new BrokerException(em);
            }
            ts = ti.getTransactionState();
            this.logger.log(4, "Processing transaction " + tid + ti.toString());
            try {
                if (ts.getState() != 6 && ts.getState() != 5) {
                    this.pstore.removeTransactionAck(tid, false);
                }
                ta = this.pstore.getTransactionAcks(tid);
                this.logger.log(4, "Processing transaction acks " + tid + " number=" + ta.length);
                l = Arrays.asList(ta);
                acks.put(tid, l);
                this.addTransactionID(tid, ts, true, ti.getType(), false);
                if (ti.getType() == 2) {
                    this.logClusterTransaction(tid, ts, ti.getTransactionBrokers(), true, false);
                }
                if (ts.getState() != 5 || !ts.getOnephasePrepare()) continue;
                this.addDetachedTransactionID(tid);
            }
            catch (Exception ex) {
                this.logger.logStack(32, "B3100", "error taking over " + tid, (Throwable)ex);
                acks.remove(tid);
            }
        }
        for (TransactionUID tid : remoteTxns) {
            if (txns.contains(tid)) continue;
            ti = null;
            try {
                ti = this.pstore.getTransactionInfo(tid);
            }
            catch (Exception e) {
                em = "Failed to get remote transaction " + tid + " information from store after takeover";
                this.logger.logStack(32, "B3100", em, (Throwable)e);
                throw new BrokerException(em);
            }
            ts = ti.getTransactionState();
            if (DEBUG || DEBUG_CLUSTER_TXN) {
                this.logger.log(8, Globals.getBrokerResources().getString("B1329", tid + "[" + TransactionState.toString(ts.getState()) + "]" + ti.toString()));
            } else {
                this.logger.log(8, Globals.getBrokerResources().getString("B1329", tid + "[" + TransactionState.toString(ts.getState()) + "]"));
            }
            try {
                ta = this.pstore.getTransactionAcks(tid);
                l = new ArrayList<TransactionAcknowledgement>();
                Iterator<String> mitr = null;
                for (int i = 0; i < ta.length; ++i) {
                    for (String msgID : msgs.keySet()) {
                        if (!msgID.equals(ta[i].getSysMessageID().toString())) continue;
                        ((ArrayList)l).add(ta[i]);
                        if (!DEBUG && !DEBUG_CLUSTER_TXN) continue;
                        this.logger.log(8, "Processing remote transaction ack for TUID=" + tid + " " + ta[i].toString());
                    }
                }
                if (((ArrayList)l).size() > 0) {
                    acks.put(tid, l);
                    this.logger.log(8, "Processing remote transaction " + tid + "[" + TransactionState.toString(ts.getState()) + "] with acks " + ((ArrayList)l).size());
                    if (ts.getState() != 5 && ts.getState() != 6) {
                        ts.setState(5);
                    }
                }
                this.logRemoteTransaction(tid, ts, ((ArrayList)l).toArray((TransactionAcknowledgement[])new TransactionAcknowledgement[((ArrayList)l).size()]), ti.getTransactionHomeBroker(), true, false, false);
                if (ts.getState() != 6) continue;
                this.txnReaper.addRemoteTransaction(tid, true);
            }
            catch (Exception ex) {
                this.logger.logStack(32, "B3100", "error taking over " + tid, (Throwable)ex);
                acks.remove(tid);
            }
        }
        return acks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getDebugState() {
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        this.shareLock.lock();
        try {
            ht.put("TransactionCount", this.translist.size());
            for (TransactionUID tid : this.translist.keySet()) {
                ht.put(tid.toString(), this.getDebugState(tid));
            }
            ht.put("TransactionCount(remote)", this.remoteTranslist.size());
            for (TransactionUID tid : this.remoteTranslist.keySet()) {
                if (this.translist.containsKey(tid) || this.remoteTranslist.containsKey(tid)) continue;
                ht.put(tid.toString(), this.getDebugState(tid));
            }
            if (this.inuse_translist.size() > 0) {
                ht.put("inUse", this.inuse_translist.toArray());
            } else {
                ht.put("inUse", "none");
            }
            Hashtable<String, String> x = new Hashtable<String, String>();
            for (Map.Entry entry : this.xidTable.entrySet()) {
                x.put(entry.getKey().toString(), entry.getValue().toString());
            }
            if (x.size() > 0) {
                ht.put("XIDs", x);
            } else {
                ht.put("XIDs", "none");
            }
        }
        finally {
            this.shareLock.unlock();
        }
        ht.put("txnReaper", this.txnReaper.getDebugState());
        ht.put("detachedTxnReaper", this.detachedTxnReaper.getDebugState());
        return ht;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionUID getTransaction(String id) {
        this.shareLock.lock();
        try {
            for (TransactionInformation info : this.translist.values()) {
                TransactionState ts = info.getState();
                String creator = ts.getCreator();
                if (creator == null || !creator.equals(id)) continue;
                TransactionUID transactionUID = info.getTID();
                return transactionUID;
            }
        }
        finally {
            this.shareLock.unlock();
        }
        return null;
    }

    public void addTransactionID(TransactionUID id, TransactionState ts) throws BrokerException {
        this.addTransactionID(id, ts, false, 1, true);
    }

    public TransactionInformation addTransactionID(TransactionUID id, TransactionState ts, boolean persist) throws BrokerException {
        return this.addTransactionID(id, ts, false, 1, persist);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TransactionInformation addTransactionID(TransactionUID id, TransactionState ts, boolean takeover, int type, boolean persist) throws BrokerException {
        JMQXid xid = ts.getXid();
        this.shareLock.lock();
        try {
            if (this.inuse_translist.contains(id) && (!takeover || type != 2 || this.translist.containsKey(id) || !this.remoteTranslist.containsKey(id))) {
                throw new BrokerException(Globals.getBrokerResources().getKString("B4061", id.toString()), "B4061", null, 409);
            }
            if (xid != null && this.xidTable.containsKey(xid)) {
                throw new BrokerException(Globals.getBrokerResources().getKString("B4061", id.toString() + "[Xid=" + xid.toString() + "]"), "B4061", null, 409);
            }
        }
        finally {
            this.shareLock.unlock();
        }
        try {
            if (persist) {
                this.pstore.storeTransaction(id, ts, Destination.PERSIST_SYNC);
            }
        }
        catch (Exception ex) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4062", id.toString()), "B4062", ex, 500);
        }
        TransactionInformation ti = new TransactionInformation(id, ts, persist);
        if (takeover) {
            ti.getTakeoverLock();
        }
        this.exclusiveLock.lock();
        try {
            this.inuse_translist.add(id);
            this.translist.put(id, ti);
            if (xid != null) {
                this.xidTable.put(xid, id);
            }
        }
        finally {
            this.exclusiveLock.unlock();
        }
        return ti;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isXATransaction(TransactionUID id) throws BrokerException {
        TransactionState ts = null;
        TransactionInformation ti = null;
        this.shareLock.lock();
        try {
            ti = (TransactionInformation)this.translist.get(id);
        }
        finally {
            this.shareLock.unlock();
        }
        if (ti != null && (ts = ti.getState()) != null) {
            return ts.isXA();
        }
        throw new BrokerException("Transaction " + id + "not found", 404);
    }

    public void removeTransaction(TransactionUID id, boolean noremove) throws BrokerException {
        this.removeTransactionID(id, noremove, false, true);
    }

    public void removeTransactionID(TransactionUID id) throws BrokerException {
        this.removeTransactionID(id, false, false, true);
    }

    protected void reapTransactionID(TransactionUID id, boolean noremove) throws BrokerException {
        this.removeTransactionID(id, noremove, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTransactionID(TransactionUID id, boolean noremove, boolean fromReaper, boolean persist) throws BrokerException {
        TransactionState ts = null;
        TransactionInformation ti = null;
        this.shareLock.lock();
        try {
            ti = (TransactionInformation)this.translist.get(id);
        }
        finally {
            this.shareLock.unlock();
        }
        if (ti != null) {
            ts = ti.getState();
            if (!fromReaper && ts != null && ts.getState() == 6) {
                if (ti.getType() == 2) {
                    ti.processed();
                    this.txnReaper.addClusterTransaction(id, noremove);
                    return;
                }
                if (ti.getType() == 1) {
                    ti.processed();
                    if (noremove || TXN_REAPLIMIT > 0) {
                        this.txnReaper.addLocalTransaction(id, noremove);
                        return;
                    }
                }
            }
        }
        if (!noremove && persist) {
            try {
                this.pstore.removeTransaction(id, true, false);
            }
            catch (IOException ex) {
                throw new BrokerException(Globals.getBrokerResources().getString("B4117", "Unable to remove the transaction id " + id), ex);
            }
        }
        this.exclusiveLock.lock();
        try {
            this.translist.remove(id);
            if (!this.remoteTranslist.containsKey(id)) {
                this.inuse_translist.remove(id);
            }
            if (ts != null && ts.getXid() != null) {
                this.xidTable.remove(ts.getXid());
            }
        }
        finally {
            this.exclusiveLock.unlock();
        }
    }

    public void removeRemoteTransactionAck(TransactionUID id) throws BrokerException {
        if (Globals.getHAEnabled()) {
            return;
        }
        this.removeTransactionAck(id, true);
    }

    public void removeTransactionAck(TransactionUID id) throws BrokerException {
    }

    public void removeTransactionAck(TransactionUID id, boolean persist) throws BrokerException {
        try {
            this.pstore.removeTransactionAck(id, false);
        }
        catch (Exception ex) {
            throw new BrokerException(this.br.getKString("B4429", id, ex.getMessage()));
        }
    }

    public void addDetachedTransactionID(TransactionUID tid) {
        this.detachedTxnReaper.addDetachedTID(tid);
    }

    public void addMessage(PacketReference ref) throws BrokerException {
        TransactionUID tid = ref.getTransactionID();
        if (tid == null) {
            return;
        }
        SysMessageID sysid = ref.getSysMessageID();
        boolean delaypersist = false;
        if (ref.isPersistent() && !ref.getNeverStore() && Globals.isMinimumPersistLevel2()) {
            TransactionState ts = this.retrieveState(tid, true);
            if (ts == null) {
                throw new BrokerException(Globals.getBrokerResources().getKString("B4391", sysid, tid), 410);
            }
            if (ts.getType() != AutoRollbackType.NEVER) {
                delaypersist = true;
            }
        }
        if (Globals.isNewTxnLogEnabled()) {
            delaypersist = true;
        }
        if (!delaypersist) {
            ref.store();
        }
        this.addMessage(tid, sysid, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessage(TransactionUID id, SysMessageID sysid, boolean anyState) throws BrokerException {
        TransactionInformation info = null;
        this.shareLock.lock();
        try {
            info = (TransactionInformation)this.translist.get(id);
        }
        finally {
            this.shareLock.unlock();
        }
        if (info == null) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4391", sysid, id), 410);
        }
        TransactionInformation transactionInformation = info;
        synchronized (transactionInformation) {
            int state = info.getState().getState();
            if (state == 8) {
                throw new BrokerException(Globals.getBrokerResources().getString("B4117", "Transaction " + id + ": is has timed out "), 408);
            }
            if (!anyState && state != 1) {
                throw new BrokerException(Globals.getBrokerResources().getString("B4117", "Transaction " + id + "[" + TransactionState.toString(state) + "]: is not in " + TransactionState.toString(1) + " state"), 412);
            }
            info.addPublishedMessage(sysid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getTransactionMap(TransactionUID tid, boolean ext) throws BrokerException {
        TransactionInformation info = null;
        this.shareLock.lock();
        try {
            info = (TransactionInformation)this.translist.get(tid);
        }
        finally {
            this.shareLock.unlock();
        }
        if (info == null) {
            throw new BrokerException(Globals.getBrokerResources().getString("B4117", "received acknowledgement with Unknown Transaction ID " + tid), 410);
        }
        TransactionState ts = info.getState();
        if (ts == null) {
            throw new BrokerException(Globals.getBrokerResources().getString("B4117", "received acknowledgement with Unknown Transaction state " + tid), 500);
        }
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        ht.put("JMQAutoRollback", ts.getType().intValue());
        if (ts.getXid() != null) {
            ht.put("JMQXid", ts.getXid().toString());
        }
        ht.put("JMQSessionLess", ts.isSessionLess());
        ht.put("JMQCreateTime", ts.getCreationTime());
        ht.put("JMQLifetime", ts.getLifetime());
        if (ext) {
            ht.put("State", ts.getState() + 1);
        } else {
            ht.put("State", ts.getState());
        }
        return ht;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkAcknowledgement(TransactionUID tid, SysMessageID sysid, ConsumerUID cuid) throws BrokerException {
        TransactionInformation info = null;
        this.shareLock.lock();
        try {
            info = (TransactionInformation)this.translist.get(tid);
        }
        finally {
            this.shareLock.unlock();
        }
        if (info == null) {
            throw new BrokerException(this.br.getKString("B4396", tid, "[" + sysid + ", " + cuid + "]"), 410);
        }
        if (info.getState().getState() == 8) {
            throw new BrokerException(Globals.getBrokerResources().getString("B4117", "Transaction " + cuid + ": is has timed out "), 408);
        }
        return info.checkConsumedMessage(sysid, cuid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionUID getConsumedInTransaction(SysMessageID sysid, ConsumerUID id) {
        TransactionInformation info2 = null;
        this.shareLock.lock();
        try {
            for (TransactionInformation info2 : this.translist.values()) {
                if (info2 == null || !info2.isConsumedMessage(sysid, id)) continue;
                TransactionUID transactionUID = info2.getTID();
                return transactionUID;
            }
        }
        finally {
            this.shareLock.unlock();
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public boolean addAcknowledgement(TransactionUID tid, SysMessageID sysid, ConsumerUID intid, ConsumerUID sid) throws BrokerException {
        pr = DestinationList.get(null, sysid);
        if (pr == null) {
            if (!DestinationList.isLocked(this.pstore, sysid)) {
                throw new BrokerException(Globals.getBrokerResources().getKString("B1261", "" + sysid + "[" + intid + ":" + sid + "]TUID=" + tid), 409);
            }
            throw new BrokerException(Globals.getBrokerResources().getKString("B1289", "" + sysid + "[" + intid + ":" + sid + "]TUID=" + tid), 409);
        }
        if (!sid.shouldStore() || !pr.isPersistent() || !pr.isLocal()) ** GOTO lbl-1000
        v0 = this;
        if (!v0.DL.isPartitionMode() || pr.getPartitionedStore().getPartitionID().equals(this.pstore.getPartitionID())) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        persist = v1;
        return this.addAcknowledgement(tid, sysid, intid, sid, false, persist);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAcknowledgement(TransactionUID tid, SysMessageID sysid, ConsumerUID intid, ConsumerUID sid, boolean anystate, boolean persist) throws BrokerException {
        boolean isXA = false;
        TransactionInformation info = null;
        this.shareLock.lock();
        try {
            info = (TransactionInformation)this.translist.get(tid);
        }
        finally {
            this.shareLock.unlock();
        }
        if (info == null) {
            throw new BrokerException(Globals.getBrokerResources().getString("B4117", "Received acknowledgement with Unknown Transaction ID " + tid), 410);
        }
        TransactionState ts = null;
        TransactionInformation transactionInformation = info;
        synchronized (transactionInformation) {
            ts = info.getState();
            int state = ts.getState();
            if (state == 8) {
                throw new BrokerException(Globals.getBrokerResources().getString("B4117", "Transaction " + tid + " has timed out "), 408);
            }
            if (!anystate && state != 1) {
                throw new BrokerException(Globals.getBrokerResources().getString("B4117", "Transaction " + tid + " has state [" + TransactionState.toString(state) + "],  not in [" + TransactionState.toString(1) + "] state"), 412);
            }
            info.addConsumedMessage(sysid, intid, sid);
            isXA = info.getState().isXA();
        }
        boolean delaypersist = false;
        if (ts.getType() != AutoRollbackType.NEVER && Globals.isMinimumPersistLevel2() || Globals.isNewTxnLogEnabled()) {
            delaypersist = true;
        }
        if (persist && !delaypersist) {
            if (this.fi.FAULT_INJECTION) {
                try {
                    this.fi.checkFaultAndThrowBrokerException("txn.ack.1_3", null);
                }
                catch (BrokerException e) {
                    this.fi.unsetFault("txn.ack.1_3");
                    throw e;
                }
            }
            this.pstore.storeTransactionAck(tid, new TransactionAcknowledgement(sysid, intid, sid), false);
        }
        return isXA;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAckBrokerAddress(TransactionUID tid, SysMessageID sysid, ConsumerUID id, BrokerAddress addr) throws BrokerException {
        TransactionInformation info = null;
        this.shareLock.lock();
        try {
            info = (TransactionInformation)this.translist.get(tid);
        }
        finally {
            this.shareLock.unlock();
        }
        if (info == null) {
            throw new BrokerException(Globals.getBrokerResources().getString("B4117", "Unknown Transaction ID " + tid + " for transaction ack [" + sysid + ":" + id + "]" + addr), 410);
        }
        TransactionInformation transactionInformation = info;
        synchronized (transactionInformation) {
            int state = info.getState().getState();
            if (state == 8) {
                throw new BrokerException(Globals.getBrokerResources().getString("B4117", "Transaction " + tid + ": has timed out "), 408);
            }
            if (state != 1) {
                throw new BrokerException(Globals.getBrokerResources().getString("B4117", "Transaction " + tid + "[" + TransactionState.toString(state) + "]: is not in " + TransactionState.toString(1) + " state"), 412);
            }
            info.setAckBrokerAddress(sysid, id, addr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BrokerAddress getAckBrokerAddress(TransactionUID tid, SysMessageID sysid, ConsumerUID id) throws BrokerException {
        TransactionInformation info = null;
        this.shareLock.lock();
        try {
            info = (TransactionInformation)this.translist.get(tid);
        }
        finally {
            this.shareLock.unlock();
        }
        if (info == null) {
            throw new BrokerException(Globals.getBrokerResources().getString("B4117", "Unknown Transaction ID " + tid + " for transaction ack [" + sysid + ":" + id + "]"), 410);
        }
        TransactionInformation transactionInformation = info;
        synchronized (transactionInformation) {
            return info.getAckBrokerAddress(sysid, id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List retrieveSentMessages(TransactionUID id) {
        TransactionInformation ti = null;
        this.shareLock.lock();
        try {
            ti = (TransactionInformation)this.translist.get(id);
        }
        finally {
            this.shareLock.unlock();
        }
        if (ti == null) {
            return null;
        }
        return ti.getPublishedMessages();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int retrieveNSentMessages(TransactionUID id) {
        TransactionInformation ti = null;
        this.shareLock.lock();
        try {
            ti = (TransactionInformation)this.translist.get(id);
        }
        finally {
            this.shareLock.unlock();
        }
        if (ti == null) {
            return 0;
        }
        return ti.getNPublishedMessages();
    }

    public HashMap retrieveConsumedMessages(TransactionUID id) {
        return this.retrieveConsumedMessages(id, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap retrieveConsumedMessages(TransactionUID id, boolean inrollback) {
        TransactionInformation ti = null;
        this.shareLock.lock();
        try {
            ti = (TransactionInformation)this.translist.get(id);
        }
        finally {
            this.shareLock.unlock();
        }
        if (ti == null) {
            return null;
        }
        return ti.getConsumedMessages(inrollback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap retrieveStoredConsumerUIDs(TransactionUID id) {
        TransactionInformation ti = null;
        this.shareLock.lock();
        try {
            ti = (TransactionInformation)this.translist.get(id);
        }
        finally {
            this.shareLock.unlock();
        }
        if (ti == null) {
            return null;
        }
        return ti.getStoredConsumerUIDs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap retrieveAckBrokerAddresses(TransactionUID id) {
        TransactionInformation ti = null;
        this.shareLock.lock();
        try {
            ti = (TransactionInformation)this.translist.get(id);
        }
        finally {
            this.shareLock.unlock();
        }
        if (ti == null) {
            return null;
        }
        return ti.getAckBrokerAddresses();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int retrieveNConsumedMessages(TransactionUID id) {
        TransactionInformation ti = null;
        this.shareLock.lock();
        try {
            ti = (TransactionInformation)this.translist.get(id);
        }
        finally {
            this.shareLock.unlock();
        }
        if (ti == null) {
            return 0;
        }
        return ti.getNConsumedMessages();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int retrieveNRemoteConsumedMessages(TransactionUID id) {
        RemoteTransactionInformation ti = null;
        this.shareLock.lock();
        try {
            ti = (RemoteTransactionInformation)this.remoteTranslist.get(id);
        }
        finally {
            this.shareLock.unlock();
        }
        if (ti == null) {
            return 0;
        }
        return ti.getNRemoteConsumedMessages();
    }

    public TransactionState retrieveState(TransactionUID id) {
        return this.retrieveState(id, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionState retrieveState(TransactionUID id, boolean inquiry) {
        if (id == null) {
            return null;
        }
        TransactionInformation ti = null;
        this.shareLock.lock();
        try {
            ti = (TransactionInformation)this.translist.get(id);
        }
        finally {
            this.shareLock.unlock();
        }
        if (ti == null) {
            return null;
        }
        if (inquiry) {
            return ti.getState();
        }
        if (ti.isTakeoverLocked()) {
            Globals.getLogger().log(16, Globals.getBrokerResources().getKString("B4290", id));
            return null;
        }
        if (ti.isProcessed()) {
            return null;
        }
        return ti.getState();
    }

    public TransactionWork[] getTransactionWork(TransactionUID tid) throws BrokerException {
        List plist = this.retrieveSentMessages(tid);
        HashMap cmap = this.retrieveConsumedMessages(tid);
        HashMap sToCmap = this.retrieveStoredConsumerUIDs(tid);
        TransactionWork localwork = new TransactionWork();
        TransactionWork remotework = new TransactionWork();
        TransactionWork[] txnworks = new TransactionWork[]{localwork, remotework};
        for (int i = 0; plist != null && i < plist.size(); ++i) {
            SysMessageID sysid = (SysMessageID)plist.get(i);
            PacketReference ref = DestinationList.get(this.pstore, sysid);
            if (ref == null || ref.isDestroyed()) {
                this.logger.log(16, Globals.getBrokerResources().getKString("B2254", sysid));
                continue;
            }
            if (!ref.isPersistent() || ref.getNeverStore() || ref.isStored()) continue;
            TransactionWorkMessage txnmsg = new TransactionWorkMessage();
            Destination dest = ref.getDestination();
            txnmsg.setDestUID(dest.getDestinationUID());
            txnmsg.setPacketReference(ref);
            localwork.addMessage(txnmsg);
        }
        if (cmap != null && cmap.size() > 0) {
            for (Map.Entry entry : cmap.entrySet()) {
                SysMessageID sysid = (SysMessageID)entry.getKey();
                List interests = (List)entry.getValue();
                if (sysid == null) continue;
                PacketReference ref = DestinationList.get(null, sysid);
                if (ref == null) {
                    ConsumerUID intid = null;
                    ConsumerUID sid = null;
                    if (interests.size() > 0 && (sid = (ConsumerUID)sToCmap.get(intid = (ConsumerUID)interests.get(0))) == null) {
                        sid = intid;
                    }
                    if (!DestinationList.isLocked(this.pstore, sysid)) {
                        throw new BrokerException(Globals.getBrokerResources().getKString("B1261", "" + sysid + "[" + intid + ":" + sid + "]TUID=" + tid), 409);
                    }
                    throw new BrokerException(Globals.getBrokerResources().getKString("B1289", "" + sysid + "[" + intid + ":" + sid + "]TUID=" + tid), 409);
                }
                Destination[] ds = DestinationList.getDestination(ref.getPartitionedStore(), ref.getDestinationUID());
                Destination dst = ds[0];
                for (int i = 0; i < interests.size(); ++i) {
                    TransactionWorkMessageAck txnack;
                    ConsumerUID intid = (ConsumerUID)interests.get(i);
                    ConsumerUID sid = (ConsumerUID)sToCmap.get(intid);
                    if (sid == null) {
                        sid = intid;
                    }
                    if (!sid.shouldStore() || !ref.isPersistent()) continue;
                    TransactionAcknowledgement ta = new TransactionAcknowledgement(sysid, intid, sid);
                    if (ref.isLocal()) {
                        TransactionList transactionList = this;
                        if (!transactionList.DL.isPartitionMode() || ref.getPartitionedStore().getPartitionID().equals(this.pstore.getPartitionID())) {
                            if (ref.isDestroyed() || ref.isInvalid()) continue;
                            txnack = new TransactionWorkMessageAck();
                            txnack.setConsumerID(sid);
                            txnack.setDest(dst.getDestinationUID());
                            txnack.setSysMessageID(sysid);
                            txnack.setTransactionAcknowledgement(ta);
                            localwork.addMessageAcknowledgement(txnack);
                            continue;
                        }
                    }
                    txnack = new TransactionWorkMessageAck();
                    txnack.setConsumerID(sid);
                    txnack.setDest(dst.getDestinationUID());
                    txnack.setSysMessageID(sysid);
                    txnack.setTransactionAcknowledgement(ta);
                    remotework.addMessageAcknowledgement(txnack);
                }
            }
        }
        return txnworks;
    }

    public TransactionState updateState(TransactionUID tid, int state, boolean persist) throws BrokerException {
        return this.updateState(tid, state, -1, false, -1, persist, null);
    }

    public TransactionState updateStateCommitWithWork(TransactionUID tid, int state, boolean persist) throws BrokerException {
        if (state != 6) {
            throw new BrokerException("Unexpected call TransactionList.updateStateCommitWithWork(tid=" + tid + ", " + TransactionState.toString(state) + ", " + persist + ")");
        }
        TransactionWork[] txnworks = this.getTransactionWork(tid);
        TransactionState ts = this.updateState(tid, state, -1, false, -1, persist, txnworks[0]);
        Iterator<TransactionWorkMessage> itr = txnworks[0].getSentMessages().iterator();
        while (itr.hasNext()) {
            PacketReference ref = itr.next().getPacketReference();
            ref.setIsStored();
        }
        return ts;
    }

    public TransactionState updateState(TransactionUID tid, int state, boolean onephasePrepare, boolean persist) throws BrokerException {
        return this.updateState(tid, state, -1, onephasePrepare, -1, persist, null);
    }

    public TransactionState updateStatePrepareWithWork(TransactionUID tid, int state, boolean onephasePrepare, boolean persist) throws BrokerException {
        if (state != 5) {
            throw new BrokerException("Unexpected call TransactionList.updateStatePrepareWithWork(tid=" + tid + ", " + TransactionState.toString(state) + ", " + onephasePrepare + ", " + persist + ")");
        }
        TransactionWork[] txnworks = this.getTransactionWork(tid);
        TransactionState ts = this.updateState(tid, state, -1, onephasePrepare, -1, persist, txnworks[0]);
        Iterator<TransactionWorkMessage> itr = txnworks[0].getSentMessages().iterator();
        while (itr.hasNext()) {
            PacketReference ref = itr.next().getPacketReference();
            ref.setIsStored();
        }
        return ts;
    }

    public TransactionState updateState(TransactionUID tid, int state, int oldstate, boolean persist) throws BrokerException {
        return this.updateState(tid, state, oldstate, false, -1, persist, null);
    }

    public TransactionState updateState(TransactionUID tid, int state, boolean onephasePrepare, int failedToState, boolean persist) throws BrokerException {
        return this.updateState(tid, state, -1, onephasePrepare, failedToState, persist, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionState updateState(TransactionUID id, int state, int oldstate, boolean onephasePrepare, int failToState, boolean persist, TransactionWork txnwork) throws BrokerException {
        TransactionInformation ti = null;
        this.shareLock.lock();
        try {
            ti = (TransactionInformation)this.translist.get(id);
        }
        finally {
            this.shareLock.unlock();
        }
        if (ti == null) {
            throw new UnknownTransactionException("Update state " + TransactionState.toString(state) + " for unknown transaction: " + id);
        }
        if (ti.isTakeoverLocked()) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4290", id), 404);
        }
        TransactionState ts = null;
        TransactionInformation transactionInformation = ti;
        synchronized (transactionInformation) {
            ts = ti.getState();
            if (ts == null) {
                throw new BrokerException(Globals.getBrokerResources().getString("B4117", "updateState(): No state for transaction: " + id), 410);
            }
            if (ts.getState() == 8) {
                throw new BrokerException(Globals.getBrokerResources().getString("B4117", "Transaction " + id + ": is has timed out"), 408);
            }
            int currstate = ts.getState();
            if (oldstate != -1 && currstate != oldstate) {
                Object[] args = new String[]{id.toString(), TransactionState.toString(state), TransactionState.toString(ts.getState()), TransactionState.toString(oldstate)};
                throw new BrokerException(Globals.getBrokerResources().getKString("B4272", args), 409);
            }
            ts.setState(state);
            if (state == 5) {
                ts.setOnephasePrepare(onephasePrepare);
            }
            if (state == 2 && currstate != 2) {
                ts.setFailFromState(currstate);
                if (failToState != -1) {
                    ts.setFailToState(failToState);
                }
            }
        }
        if (persist) {
            if (this.fi.FAULT_INJECTION && (state == 4 || state == 5)) {
                String fault = "txn.update.1_3.end";
                if (state == 5) {
                    fault = "txn.update.1_3.prepare";
                }
                try {
                    this.fi.checkFaultAndThrowBrokerException(fault, null);
                }
                catch (BrokerException e) {
                    this.fi.unsetFault(fault);
                    throw e;
                }
            }
            try {
                if (txnwork == null) {
                    this.pstore.updateTransactionState(id, ts, Destination.PERSIST_SYNC);
                } else {
                    this.pstore.updateTransactionStateWithWork(id, ts, txnwork, Destination.PERSIST_SYNC);
                }
            }
            catch (IOException e) {
                throw new BrokerException(null, e);
            }
        }
        return ts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionUID xidToUID(JMQXid xid) {
        this.shareLock.lock();
        try {
            TransactionUID transactionUID = (TransactionUID)this.xidTable.get(xid);
            return transactionUID;
        }
        finally {
            this.shareLock.unlock();
        }
    }

    public JMQXid UIDToXid(TransactionUID uid) {
        TransactionState ts = this.retrieveState(uid);
        if (ts != null) {
            return ts.getXid();
        }
        return null;
    }

    public Vector getTransactions(int state) {
        return this.getTransactions(this.translist, state);
    }

    public Vector getClusterTransactions(int state) {
        return this.getTransactions(this.translist, state, 2);
    }

    public Vector getRemoteTransactions(int state) {
        return this.getTransactions(this.remoteTranslist, state);
    }

    private Vector getTransactions(Map list, int state) {
        return this.getTransactions(list, state, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector getTransactions(Map list, int state, int type) {
        TransactionUID tid = null;
        TransactionState ts = null;
        Vector<TransactionUID> v = new Vector<TransactionUID>();
        this.shareLock.lock();
        try {
            Iterator iter = list.entrySet().iterator();
            Map.Entry pair = null;
            while (iter.hasNext()) {
                pair = iter.next();
                tid = (TransactionUID)pair.getKey();
                TransactionInformation ti = (TransactionInformation)pair.getValue();
                if (state < 0 && (type == 0 || ti.getType() == type)) {
                    if (ti.isProcessed() && (type == 1 || type == 0 || type == 2 && ti.isClusterTransactionBrokersCompleted())) continue;
                    v.add(tid);
                    continue;
                }
                ts = this.retrieveState(tid);
                if (ts == null || ts.getState() != state || type != 0 && ti.getType() != type) continue;
                v.add(tid);
            }
        }
        finally {
            this.shareLock.unlock();
        }
        return v;
    }

    public void addOrphanAck(TransactionUID id, SysMessageID sysid, ConsumerUID sid) {
        this.addOrphanAck(id, sysid, sid, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOrphanAck(TransactionUID id, SysMessageID sysid, ConsumerUID sid, ConsumerUID cid) {
        TransactionInformation ti = null;
        this.shareLock.lock();
        try {
            ti = (TransactionInformation)this.translist.get(id);
        }
        finally {
            this.shareLock.unlock();
        }
        if (ti != null) {
            ti.addOrphanAck(sysid, sid, cid);
        }
    }

    public void removeOrphanAck(TransactionUID id, SysMessageID sysid, ConsumerUID sid) {
        this.removeOrphanAck(id, sysid, sid, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOrphanAck(TransactionUID id, SysMessageID sysid, ConsumerUID sid, ConsumerUID cid) {
        TransactionInformation ti = null;
        this.shareLock.lock();
        try {
            ti = (TransactionInformation)this.translist.get(id);
        }
        finally {
            this.shareLock.unlock();
        }
        if (ti != null) {
            ti.removeOrphanAck(sysid, sid, cid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getOrphanAck(TransactionUID id) {
        TransactionInformation ti = null;
        this.shareLock.lock();
        try {
            ti = (TransactionInformation)this.translist.get(id);
        }
        finally {
            this.shareLock.unlock();
        }
        if (ti != null) {
            return ti.getOrphanAck();
        }
        return null;
    }

    public void loadTransactions() throws BrokerException, IOException {
        LinkedHashMap m;
        Object[] args;
        TransactionUID tid;
        LoadException processing;
        LoadException load_ex = this.pstore.getLoadTransactionException();
        if (load_ex != null) {
            processing = load_ex;
            while (processing != null) {
                TransactionState ts;
                tid = (TransactionUID)processing.getKey();
                TransactionInfo ti = (TransactionInfo)processing.getValue();
                if (tid == null && ti == null) {
                    this.logger.log(16, "LoadTransactionException: Both key and value for a transactions entry are corrupted with key exception " + processing.getKeyCause().getMessage() + " and value exception " + processing.getValueCause());
                    processing = processing.getNextException();
                    continue;
                }
                if (tid == null) {
                    this.logger.logStack(16, "B2098", ti.toString(), processing.getKeyCause());
                    processing = processing.getNextException();
                    continue;
                }
                if (ti == null) {
                    this.logger.log(16, Globals.getBrokerResources().getKString("B2187", tid.toString()));
                    ts = new TransactionState(AutoRollbackType.NOT_PREPARED, 0L, true);
                    ts.setState(5);
                    try {
                        this.pstore.storeTransaction(tid, ts, false);
                    }
                    catch (Exception ex) {
                        this.logger.logStack(16, "Error updating transaction " + tid, ex);
                    }
                    processing = processing.getNextException();
                    continue;
                }
                if (ti.getType() == 0) {
                    this.logger.logStack(16, Globals.getBrokerResources().getKString("B2202", tid + "[" + ti.toString() + "]", TransactionInfo.toString(1)), processing.getValueCause());
                    ts = new TransactionState(AutoRollbackType.NOT_PREPARED, 0L, true);
                    ts.setState(5);
                    try {
                        this.pstore.storeTransaction(tid, ts, false);
                    }
                    catch (Exception ex) {
                        this.logger.logStack(16, "Error updating transaction " + tid, ex);
                    }
                    processing = processing.getNextException();
                    continue;
                }
                if (ti.getTransactionState() == null) {
                    this.logger.log(16, "B2097", (Object)tid, processing.getValueCause());
                    ts = new TransactionState(AutoRollbackType.NOT_PREPARED, 0L, true);
                    ts.setState(5);
                    try {
                        this.pstore.storeTransaction(tid, ts, false);
                    }
                    catch (Exception ex) {
                        this.logger.logStack(16, "Error updating transaction " + tid, ex);
                    }
                    processing = processing.getNextException();
                    continue;
                }
                if (ti.getType() == 2 && ti.getTransactionBrokers() == null) {
                    this.logger.log(16, "B2203", (Object)tid, processing.getValueCause());
                    this.pstore.storeClusterTransaction(tid, ti.getTransactionState(), null, false);
                    processing = processing.getNextException();
                    continue;
                }
                if (ti.getType() == 3 && ti.getTransactionHomeBroker() == null) {
                    this.logger.log(16, "B2204", (Object)tid, processing.getValueCause());
                    this.pstore.storeRemoteTransaction(tid, ti.getTransactionState(), null, null, false);
                    processing = processing.getNextException();
                    continue;
                }
                this.logger.log(32, "XXXI18N Internal Error: unknown load error for TUID=" + tid + "[" + ti.toString() + "]");
            }
        }
        if ((load_ex = this.pstore.getLoadTransactionAckException()) != null) {
            processing = load_ex;
            while (processing != null) {
                tid = (TransactionUID)processing.getKey();
                Object[] ta = (TransactionAcknowledgement[])processing.getValue();
                if (tid == null && ta == null) {
                    this.logger.log(16, "LoadTransactionAckException: both key and value for a Transaction Ack entry are corrupted");
                    processing = processing.getNextException();
                    continue;
                }
                if (tid == null) {
                    this.logger.log(16, "B2098", Arrays.toString(ta));
                    processing = processing.getNextException();
                    continue;
                }
                this.logger.log(16, "B2099", tid.toString());
                try {
                    this.pstore.removeTransactionAck(tid, false);
                }
                catch (Exception ex) {
                    this.logger.logStack(16, "Error updating transaction acks " + tid, ex);
                }
            }
        }
        this.logger.log(8, this.br.getKString("B1136") + this.logsuffix);
        HashMap trans = this.pstore.getAllTransactionStates();
        TransactionList.logTransactionInfo(trans, AUTO_ROLLBACK, this.logsuffix);
        HashSet<TransactionUID> clearTrans = new HashSet<TransactionUID>(trans.size());
        HashSet<TransactionUID> clearAckOnlyTrans = new HashSet<TransactionUID>(trans.size());
        HashMap<TransactionUID, Boolean> openTransactions = new HashMap<TransactionUID, Boolean>();
        HashMap<SysMessageID, HashMap<ConsumerUID, TransactionUID>> inprocessAcks = new HashMap<SysMessageID, HashMap<ConsumerUID, TransactionUID>>();
        HashMap<TransactionUID, String> committingTransactions = new HashMap<TransactionUID, String>();
        int totalN = 0;
        boolean clusterN = false;
        boolean remoteN = false;
        int prepareN = 0;
        int commitN = 0;
        int rollbackN = 0;
        int prepareCN = 0;
        int commitCN = 0;
        int commitWaitCN = 0;
        Iterator itr = trans.entrySet().iterator();
        while (itr.hasNext()) {
            ++totalN;
            try {
                Map.Entry entry = itr.next();
                TransactionUID tid2 = (TransactionUID)entry.getKey();
                TransactionInfo tif = (TransactionInfo)entry.getValue();
                TransactionState ts = tif.getTransactionState();
                Object[] ta = this.pstore.getTransactionAcks(tid2);
                if (ta == null) {
                    ta = new TransactionAcknowledgement[]{};
                }
                int state = ts.getState();
                if (DEBUG) {
                    this.logger.log(8, "Load transaction: TUID=" + tid2 + "[" + TransactionState.toString(state) + (ts.getCreationTime() == 0L ? "" : " createTime=" + ts.getCreationTime()) + "]");
                }
                switch (state) {
                    case 0: {
                        clearTrans.add(tid2);
                        break;
                    }
                    case 5: {
                        ++prepareN;
                        if (!AUTO_ROLLBACK) {
                            this.addTransactionID(tid2, ts, false);
                            if (tif.getType() == 2) {
                                this.logClusterTransaction(tid2, ts, tif.getTransactionBrokers(), true, false);
                                ++prepareCN;
                            }
                            openTransactions.put(tid2, Boolean.TRUE);
                            if (!ts.getOnephasePrepare()) break;
                            this.addDetachedTransactionID(tid2);
                            break;
                        }
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 7: {
                        this.addTransactionID(tid2, ts, false);
                        if (tif.getType() == 2) {
                            this.logClusterTransaction(tid2, ts, tif.getTransactionBrokers(), true, false);
                        }
                        openTransactions.put(tid2, Boolean.FALSE);
                        clearTrans.add(tid2);
                        ts.setState(7);
                        ++rollbackN;
                        if (state != 5) break;
                        clearAckOnlyTrans.add(tid2);
                        try {
                            this.updateState(tid2, 7, true);
                        }
                        catch (Exception e) {
                            this.logger.logStack(16, "Unable to update auto-rollback PREPARED transaction " + tid2 + " state to ROLLEDBACK", e);
                        }
                        break;
                    }
                    case 6: {
                        ++commitN;
                        committingTransactions.put(tid2, "");
                        if (tif.getType() == 2) {
                            ++commitCN;
                            boolean completed = true;
                            TransactionBroker[] brokers = tif.getTransactionBrokers();
                            this.logClusterTransaction(tid2, ts, brokers, false, false);
                            for (int i = 0; brokers != null && i < brokers.length; ++i) {
                                completed = brokers[i].isCompleted();
                                if (completed) continue;
                                if (!DEBUG_CLUSTER_TXN) break;
                                this.logger.log(8, "COMMITTED cluster transaction " + tid2 + ", incomplete broker:" + brokers[i]);
                                break;
                            }
                            if (!completed) {
                                ++commitWaitCN;
                            }
                        } else {
                            this.addTransactionID(tid2, ts, false);
                        }
                        clearTrans.add(tid2);
                        break;
                    }
                    default: {
                        this.logger.log(32, "Internal Error unexpected transaction state:" + TransactionState.toString(state) + " TUID=" + tid2 + ", set to PREPARE");
                        this.addTransactionID(tid2, ts, false);
                        if (tif.getType() == 2) {
                            this.logClusterTransaction(tid2, ts, tif.getTransactionBrokers(), true, false);
                        }
                        this.updateState(tid2, 5, true);
                        openTransactions.put(tid2, Boolean.TRUE);
                    }
                }
                for (int i = 0; i < ta.length; ++i) {
                    if (DEBUG) {
                        this.logger.log(8, "Load transaction ack " + ta[i] + " [TUID=" + tid2 + "]");
                    }
                    ConsumerUID cuid = ta[i].getConsumerUID();
                    ConsumerUID scuid = ta[i].getStoredConsumerUID();
                    SysMessageID sysid = ta[i].getSysMessageID();
                    HashMap<ConsumerUID, TransactionUID> imap = (HashMap<ConsumerUID, TransactionUID>)inprocessAcks.get(sysid);
                    if (scuid == null) {
                        this.logger.log(16, "Internal Error:  Unable to locate stored ConsumerUID :" + Arrays.toString(ta));
                        scuid = cuid;
                    }
                    if (imap == null) {
                        imap = new HashMap<ConsumerUID, TransactionUID>();
                        inprocessAcks.put(sysid, imap);
                    }
                    imap.put(scuid, tid2);
                    if (openTransactions.get(tid2) == null) continue;
                    TransactionInformation ti = (TransactionInformation)this.translist.get(tid2);
                    if (ti == null) {
                        this.logger.log(8, "Unable to retrieve  transaction information " + ti + " for " + tid2 + " we may be clearing the transaction");
                        continue;
                    }
                    if (openTransactions.get(tid2) == Boolean.TRUE) {
                        ti.addConsumedMessage(sysid, cuid, scuid);
                    }
                    ti.addOrphanAck(sysid, scuid);
                }
            }
            catch (Exception ex) {
                this.logger.logStack(16, "B3100", "Error parsing transaction ", (Throwable)ex);
            }
        }
        Object[] args2 = new Object[]{prepareCN, commitWaitCN};
        this.logger.log(8, Globals.getBrokerResources().getKString("B1284", args2));
        HashMap remoteTrans = this.pstore.getAllRemoteTransactionStates();
        HashSet<TransactionUID> clearRemoteTrans = new HashSet<TransactionUID>(remoteTrans.size());
        int prepareRN = 0;
        int rollbackRN = 0;
        int commitRN = 0;
        int completeRN = 0;
        itr = remoteTrans.entrySet().iterator();
        while (itr.hasNext()) {
            try {
                Map.Entry entry = itr.next();
                TransactionUID tid3 = (TransactionUID)entry.getKey();
                TransactionState ts = (TransactionState)entry.getValue();
                Object[] ta = this.pstore.getTransactionAcks(tid3);
                int state = ts.getState();
                if (DEBUG) {
                    this.logger.log(8, "Load remote transaction: TUID=" + tid3 + "[" + TransactionState.toString(state) + (ts.getCreationTime() == 0L ? "" : " createTime=" + ts.getCreationTime()) + "]");
                }
                switch (state) {
                    case 0: {
                        clearRemoteTrans.add(tid3);
                        ++rollbackRN;
                        break;
                    }
                    case 5: {
                        ++prepareRN;
                        this.logRemoteTransaction(tid3, ts, (TransactionAcknowledgement[])ta, this.pstore.getRemoteTransactionHomeBroker(tid3), true, true, false);
                        openTransactions.put(tid3, Boolean.TRUE);
                        break;
                    }
                    case 4: {
                        if (Globals.getHAEnabled() && ta != null && ta.length > 0) {
                            ++completeRN;
                            ts.setState(5);
                            this.logRemoteTransaction(tid3, ts, (TransactionAcknowledgement[])ta, this.pstore.getRemoteTransactionHomeBroker(tid3), true, true, false);
                            openTransactions.put(tid3, Boolean.TRUE);
                            break;
                        }
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 7: {
                        openTransactions.put(tid3, Boolean.FALSE);
                        clearRemoteTrans.add(tid3);
                        ++rollbackRN;
                        break;
                    }
                    case 6: {
                        ++commitRN;
                        this.logRemoteTransaction(tid3, ts, (TransactionAcknowledgement[])ta, this.pstore.getRemoteTransactionHomeBroker(tid3), true, true, false);
                        committingTransactions.put(tid3, "");
                        break;
                    }
                    default: {
                        this.logger.log(32, "Internal Error unexpected transaction state:" + TransactionState.toString(state) + " TUID=" + tid3 + ", set to PREPARED");
                        this.logRemoteTransaction(tid3, ts, (TransactionAcknowledgement[])ta, this.pstore.getRemoteTransactionHomeBroker(tid3), true, true, false);
                        this.updateRemoteTransactionState(tid3, 5, true, true, true);
                        openTransactions.put(tid3, Boolean.TRUE);
                    }
                }
                for (int i = 0; i < ta.length; ++i) {
                    if (DEBUG) {
                        this.logger.log(8, "Load remote transaction ack " + ta[i] + " [TUID=" + tid3 + "]");
                    }
                    ConsumerUID cuid = ta[i].getConsumerUID();
                    ConsumerUID scuid = ta[i].getStoredConsumerUID();
                    SysMessageID sysid = ta[i].getSysMessageID();
                    HashMap<ConsumerUID, TransactionUID> imap = (HashMap<ConsumerUID, TransactionUID>)inprocessAcks.get(sysid);
                    if (scuid == null) {
                        this.logger.log(16, "Internal Error:  Unable to locate stored ConsumerUID :" + Arrays.toString(ta));
                        scuid = cuid;
                    }
                    if (imap == null) {
                        imap = new HashMap<ConsumerUID, TransactionUID>();
                        inprocessAcks.put(sysid, imap);
                    }
                    imap.put(scuid, tid3);
                }
            }
            catch (Exception ex) {
                this.logger.logStack(16, "B3100", "Error parsing remote transaction ", (Throwable)ex);
            }
        }
        if (Globals.getHAEnabled()) {
            args = new Object[]{String.valueOf(remoteTrans.size()), String.valueOf(prepareRN), String.valueOf(completeRN), String.valueOf(commitRN)};
            this.logger.log(8, Globals.getBrokerResources().getString("B1268", args));
        } else {
            args = new Object[]{String.valueOf(remoteTrans.size()), String.valueOf(prepareRN), String.valueOf(commitRN)};
            this.logger.log(8, Globals.getBrokerResources().getString("B1267", args));
        }
        if (!(openTransactions.size() <= 0 && inprocessAcks.size() <= 0 || (m = this.DL.processTransactions(inprocessAcks, openTransactions, committingTransactions)) == null || m.isEmpty())) {
            for (Map.Entry me : m.entrySet()) {
                TransactionInformation ti = (TransactionInformation)this.translist.get(me.getValue());
                ti.addPublishedMessage((SysMessageID)me.getKey());
            }
        }
        Object ts = null;
        Object ti = null;
        for (TransactionUID tid4 : clearTrans) {
            this.logger.log(4, "Clearing transaction " + tid4);
            if (!clearAckOnlyTrans.contains(tid4)) {
                this.removeTransactionAck(tid4);
                this.removeTransactionID(tid4);
                continue;
            }
            this.removeTransactionAck(tid4, true);
        }
        for (TransactionUID tid5 : clearRemoteTrans) {
            try {
                this.logger.log(4, "Clearing remote transaction " + tid5);
                this.removeRemoteTransactionAck(tid5);
                this.removeRemoteTransactionID(tid5, true);
            }
            catch (Exception e) {
                this.logger.log(16, "Failed to remove remote transaction TUID=" + tid5 + ": " + e.getMessage());
            }
        }
    }

    public static void logTransactionInfo(HashMap transactions, boolean autorollback, String logsuffix) {
        Logger logger = Globals.getLogger();
        BrokerResources br = Globals.getBrokerResources();
        int nRolledBack = 0;
        int nPrepared = 0;
        int nCommitted = 0;
        if (transactions != null && transactions.size() > 0) {
            Iterator itr = transactions.values().iterator();
            while (itr.hasNext()) {
                TransactionState _ts = ((TransactionInfo)itr.next()).getTransactionState();
                if (_ts.getState() == 5) {
                    ++nPrepared;
                    if (!autorollback) continue;
                    ++nRolledBack;
                    continue;
                }
                if (_ts.getState() != 6) {
                    ++nRolledBack;
                    continue;
                }
                ++nCommitted;
            }
            logger.log(8, br.getKString("B1079", transactions.size(), nRolledBack) + logsuffix);
            Object[] args = new Object[]{transactions.size(), nPrepared, nCommitted};
            logger.log(8, br.getKString("B1080", args) + logsuffix);
            if (nPrepared > 0) {
                if (autorollback) {
                    logger.log(8, br.getKString("B1081") + logsuffix);
                } else {
                    logger.log(8, br.getKString("B1082") + logsuffix);
                }
            }
        }
    }

    public void logClusterTransaction(TransactionUID id, TransactionState ts, TransactionBroker[] brokers, boolean exist, boolean persist) throws BrokerException {
        this.logClusterTransaction(id, ts, brokers, exist, persist, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logClusterTransaction(TransactionUID id, TransactionState ts, TransactionBroker[] brokers, boolean exist, boolean persist, ClusterTransaction clusterTxn) throws BrokerException {
        boolean added = false;
        TransactionInformation ti = null;
        this.shareLock.lock();
        try {
            ti = (TransactionInformation)this.translist.get(id);
        }
        finally {
            this.shareLock.unlock();
        }
        if (ti == null) {
            if (exist) {
                throw new BrokerException(Globals.getBrokerResources().getString("B4117", "logClusterTransaction(): Unknown transaction: " + id));
            }
            ti = this.addTransactionID(id, ts, false);
            added = true;
        }
        if (ti != null && ti.isTakeoverLocked()) {
            throw new BrokerException(Globals.getBrokerResources().getString("B4290", id), 404);
        }
        if (ti != null) {
            ti.setClusterTransactionBrokers(brokers);
        }
        if (persist) {
            try {
                if (added) {
                    this.pstore.storeClusterTransaction(id, ts, brokers, Destination.PERSIST_SYNC);
                } else if (Globals.isNewTxnLogEnabled()) {
                    ((TxnLoggingStore)((Object)this.pstore)).logTxn(clusterTxn);
                } else {
                    this.pstore.updateClusterTransaction(id, brokers, Destination.PERSIST_SYNC);
                }
            }
            catch (BrokerException e) {
                if (added) {
                    this.removeTransactionID(id, false, true, false);
                }
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completeClusterTransactionBrokerState(TransactionUID id, int expectedTranState, BrokerAddress broker, boolean persist) throws BrokerException {
        boolean changed = false;
        TransactionBroker b = null;
        TransactionInformation ti = null;
        this.shareLock.lock();
        try {
            ti = (TransactionInformation)this.translist.get(id);
        }
        finally {
            this.shareLock.unlock();
        }
        if (ti == null) {
            throw new BrokerException(this.br.getKString("B4271", id), 404);
        }
        TransactionInformation transactionInformation = ti;
        synchronized (transactionInformation) {
            if (ti.getState().getState() != expectedTranState) {
                throw new BrokerException(Globals.getBrokerResources().getString("B4117", "updateClusterTransactionBrokerState(): Unexpected cluster transaction state: " + ti.getState()) + ", expect:" + expectedTranState);
            }
            b = ti.getClusterTransactionBroker(broker);
            if (b == null) {
                throw new BrokerException("Can't update transaction broker state " + broker.toString() + ": not found", 404);
            }
            changed = b.copyState(new TransactionBroker(broker, true));
        }
        if (persist && changed) {
            this.pstore.updateClusterTransactionBrokerState(id, expectedTranState, b, Destination.PERSIST_SYNC);
        }
        this.txnReaper.clusterTransactionCompleted(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateRemoteTransactionState(TransactionUID id, int state, boolean recovery, boolean sync, boolean persist) throws BrokerException {
        boolean updated = false;
        TransactionState ts = null;
        RemoteTransactionInformation ti = null;
        this.shareLock.lock();
        try {
            ti = (RemoteTransactionInformation)this.remoteTranslist.get(id);
        }
        finally {
            this.shareLock.unlock();
        }
        if (ti == null) {
            if (state == 6 && this.txnReaper.hasRemoteTransaction(id)) {
                if (DEBUG_CLUSTER_TXN) {
                    this.logger.log(8, "Remote transaction " + id + " has already been committed");
                }
                return false;
            }
            throw new BrokerException("Update remote transaction state to " + TransactionState.toString(state) + ": transaction " + id + " not found, the transaction may have already been committed.", 404);
        }
        RemoteTransactionInformation remoteTransactionInformation = ti;
        synchronized (remoteTransactionInformation) {
            ts = ti.getState();
            if (TransactionState.remoteTransactionNextState(ts, state) != state) {
                throw new BrokerException("Update remote transaction " + id + " to state " + TransactionState.toString(state) + " not allowed", 405);
            }
            if (ts.getState() != state) {
                ti.getState().setState(state);
                updated = true;
            }
        }
        if (persist && !Globals.getHAEnabled()) {
            try {
                this.pstore.updateTransactionState(id, ts, sync ? Destination.PERSIST_SYNC : false);
                if (Globals.isNewTxnLogEnabled()) {
                    ((TxnLoggingStore)((Object)this.pstore)).logTxnCompletion(id, state, 2);
                }
            }
            catch (IOException e) {
                Object[] args = new String[]{id.toString(), TransactionState.toString(state), e.getMessage()};
                throw new BrokerException(Globals.getBrokerResources().getKString("B4300", args), e);
            }
        }
        if (updated && state == 6) {
            this.txnReaper.addRemoteTransaction(id, recovery);
        }
        return updated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteTransactionAckEntry[] getRecoveryRemoteTransactionAcks(TransactionUID id) throws BrokerException {
        RemoteTransactionInformation ti = null;
        this.shareLock.lock();
        try {
            ti = (RemoteTransactionInformation)this.remoteTranslist.get(id);
        }
        finally {
            this.shareLock.unlock();
        }
        if (ti == null) {
            return null;
        }
        return ti.getRecoveryTransactionAcks();
    }

    public void logLocalRemoteTransaction(TransactionUID id, TransactionState ts, TransactionAcknowledgement[] txnAcks, BrokerAddress txnHomeBroker, boolean recovery, boolean newtxn, boolean persist) throws BrokerException {
        this.logRemoteTransaction(id, ts, txnAcks, txnHomeBroker, recovery, newtxn, true, persist);
    }

    public void logRemoteTransaction(TransactionUID id, TransactionState ts, TransactionAcknowledgement[] txnAcks, BrokerAddress txnHomeBroker, boolean recovery, boolean newtxn, boolean persist) throws BrokerException {
        this.logRemoteTransaction(id, ts, txnAcks, txnHomeBroker, recovery, newtxn, false, persist);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logRemoteTransaction(TransactionUID id, TransactionState ts, TransactionAcknowledgement[] txnAcks, BrokerAddress txnHomeBroker, boolean recovery, boolean newtxn, boolean localremote, boolean persist) throws BrokerException {
        RemoteTransactionInformation rti = null;
        boolean added = false;
        this.exclusiveLock.lock();
        try {
            rti = (RemoteTransactionInformation)this.remoteTranslist.get(id);
            if (newtxn && (rti != null || this.inuse_translist.contains(id) || this.translist.containsKey(id))) {
                throw new BrokerException(Globals.getBrokerResources().getKString("B4061", id.toString()), "B4061", null, 409);
            }
            if (rti == null) {
                rti = new RemoteTransactionInformation(id, ts, txnAcks, txnHomeBroker, recovery, localremote, persist);
                this.inuse_translist.add(id);
                this.remoteTranslist.put(id, rti);
                added = true;
            }
        }
        finally {
            this.exclusiveLock.unlock();
        }
        if (!added) {
            if (!Globals.getHAEnabled()) {
                throw new BrokerException(Globals.getBrokerResources().getKString("B4061", id.toString()), "B4061", null, 409);
            }
            RemoteTransactionInformation remoteTransactionInformation = rti;
            synchronized (remoteTransactionInformation) {
                if (!rti.getTransactionHomeBroker().equals(new TransactionBroker(txnHomeBroker))) {
                    throw new BrokerException("Transaction home broker mismatch:" + txnHomeBroker.toString() + " but existed " + rti.getTransactionHomeBroker());
                }
                if (!recovery) {
                    throw new BrokerException("XXXI18N-Internal Error: unexpected non-recovery, TUID=" + id);
                }
                if (rti.getState().getState() != ts.getState()) {
                    throw new BrokerException("XXXI18N-Internal Error: state mismatch:" + TransactionState.toString(ts.getState()) + ", but exist" + TransactionState.toString(rti.getState().getState()) + "TUID=" + id);
                }
                rti.addRecoveryTransactionAcks(txnAcks);
            }
        }
        if (persist && added) {
            try {
                if (!Globals.getHAEnabled() || Globals.getSFSHAEnabled()) {
                    if (!Globals.isNewTxnLogEnabled()) {
                        this.pstore.storeRemoteTransaction(id, ts, txnAcks, txnHomeBroker, Destination.PERSIST_SYNC);
                    } else {
                        DestinationUID[] destIds = new DestinationUID[txnAcks.length];
                        for (int i = 0; i < txnAcks.length; ++i) {
                            SysMessageID sid = txnAcks[i].getSysMessageID();
                            PacketReference p = DestinationList.get(this.pstore, sid);
                            DestinationUID destID = null;
                            if (p != null) {
                                destID = p.getDestinationUID();
                            } else {
                                this.logger.log(16, "Could not find packet for " + sid);
                            }
                            destIds[i] = destID;
                        }
                        RemoteTransaction remoteTransaction = new RemoteTransaction(id, ts, txnAcks, destIds, txnHomeBroker);
                        ((TxnLoggingStore)((Object)this.pstore)).logTxn(remoteTransaction);
                    }
                } else {
                    this.pstore.updateRemoteTransaction(id, txnAcks, txnHomeBroker, Destination.PERSIST_SYNC);
                }
            }
            catch (Exception ex) {
                if (added) {
                    this.exclusiveLock.lock();
                    try {
                        this.inuse_translist.remove(id);
                        this.remoteTranslist.remove(id);
                    }
                    finally {
                        this.exclusiveLock.unlock();
                    }
                }
                this.logger.logStack(32, ex.getMessage() + (ex.getCause() == null ? "" : ": " + ex.getCause().getMessage()), ex);
                throw new BrokerException(Globals.getBrokerResources().getKString("B4062", id.toString()), "B4062", ex, 500);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteTransactionAckEntry getRemoteTransactionAcks(TransactionUID id) throws BrokerException {
        RemoteTransactionInformation rti = null;
        this.shareLock.lock();
        try {
            rti = (RemoteTransactionInformation)this.remoteTranslist.get(id);
        }
        finally {
            this.shareLock.unlock();
        }
        if (rti == null) {
            return null;
        }
        return rti.getTransactionAcks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRemoteTransactionID(TransactionUID id, boolean persist) throws BrokerException {
        RemoteTransactionInformation rti = null;
        this.shareLock.lock();
        try {
            rti = (RemoteTransactionInformation)this.remoteTranslist.get(id);
        }
        finally {
            this.shareLock.unlock();
        }
        if (rti == null) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4301", id.toString()), 404);
        }
        if (!rti.isProcessed()) {
            return;
        }
        try {
            if (persist && !Globals.getHAEnabled()) {
                this.pstore.removeTransaction(id, false, false);
            }
        }
        catch (Exception ex) {
            throw new BrokerException(Globals.getBrokerResources().getString("B4117", "Unable to remove cluster the transaction id " + id), ex);
        }
        this.exclusiveLock.lock();
        try {
            this.remoteTranslist.remove(id);
            if (!this.translist.containsKey(id)) {
                this.inuse_translist.remove(id);
            }
        }
        finally {
            this.exclusiveLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionBroker[] getClusterTransactionBrokers(TransactionUID id) throws BrokerException {
        TransactionInformation ti = null;
        this.shareLock.lock();
        try {
            ti = (TransactionInformation)this.translist.get(id);
        }
        finally {
            this.shareLock.unlock();
        }
        if (ti == null) {
            throw new BrokerException(this.br.getKString("B4271", id), 404);
        }
        return ti.getClusterTransactionBrokers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionBroker getClusterTransactionBroker(TransactionUID id, BrokerAddress broker) {
        TransactionInformation ti = null;
        this.shareLock.lock();
        try {
            ti = (TransactionInformation)this.translist.get(id);
        }
        finally {
            this.shareLock.unlock();
        }
        if (ti == null) {
            return null;
        }
        return ti.getClusterTransactionBroker(broker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClusterTransactionBroker(TransactionUID id, UID ssid) {
        TransactionInformation ti = null;
        this.shareLock.lock();
        try {
            ti = (TransactionInformation)this.translist.get(id);
        }
        finally {
            this.shareLock.unlock();
        }
        if (ti == null) {
            return false;
        }
        return ti.isClusterTransactionBroker(ssid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasRemoteBroker(TransactionUID id) {
        TransactionInformation ti = null;
        this.shareLock.lock();
        try {
            ti = (TransactionInformation)this.translist.get(id);
        }
        finally {
            this.shareLock.unlock();
        }
        if (ti == null) {
            return false;
        }
        TransactionBroker[] brokers = ti.getClusterTransactionBrokers();
        return brokers != null && brokers.length != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionState getRemoteTransactionState(TransactionUID id) {
        RemoteTransactionInformation rti = null;
        this.shareLock.lock();
        try {
            rti = (RemoteTransactionInformation)this.remoteTranslist.get(id);
        }
        finally {
            this.shareLock.unlock();
        }
        if (rti != null) {
            return rti.getState();
        }
        if (this.txnReaper.hasRemoteTransaction(id)) {
            TransactionState ts = new TransactionState();
            try {
                ts.setState(6);
                return ts;
            }
            catch (Exception e) {
                this.logger.logStack(32, e.getMessage(), e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionBroker getRemoteTransactionHomeBroker(TransactionUID id) {
        RemoteTransactionInformation rti = null;
        this.shareLock.lock();
        try {
            rti = (RemoteTransactionInformation)this.remoteTranslist.get(id);
        }
        finally {
            this.shareLock.unlock();
        }
        if (rti == null) {
            return null;
        }
        return rti.getTransactionHomeBroker();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getPreparedRemoteTransactions(Long timeout) {
        ArrayList<TransactionUID> tids = new ArrayList<TransactionUID>();
        TransactionUID tid = null;
        TransactionState ts = null;
        RemoteTransactionInformation rti = null;
        this.shareLock.lock();
        try {
            for (Map.Entry entry : this.remoteTranslist.entrySet()) {
                tid = (TransactionUID)entry.getKey();
                rti = (RemoteTransactionInformation)entry.getValue();
                if (rti == null || (ts = rti.getState()) == null || ts.getState() != 5 || timeout != null && !rti.isPendingTimeout(timeout)) continue;
                tids.add(tid);
            }
        }
        finally {
            this.shareLock.unlock();
        }
        return tids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pendingStartedForRemotePreparedTransaction(TransactionUID id) {
        RemoteTransactionInformation rti = null;
        TransactionState ts = null;
        this.shareLock.lock();
        try {
            rti = (RemoteTransactionInformation)this.remoteTranslist.get(id);
            if (rti != null && (ts = rti.getState()) != null && ts.getState() == 5) {
                rti.pendingStarted();
            }
            return;
        }
        finally {
            this.shareLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAcknowledgement(TransactionUID tid, SysMessageID sysid, ConsumerUID id, boolean rerouted) throws BrokerException {
        TransactionInformation ti = null;
        this.shareLock.lock();
        try {
            ti = (TransactionInformation)this.translist.get(tid);
        }
        finally {
            this.shareLock.unlock();
        }
        if (ti == null) {
            throw new BrokerException(Globals.getBrokerResources().getString("B4117", "Removing acknowledgement with Unknown Transaction ID " + tid));
        }
        ti.removeConsumedMessage(sysid, id, rerouted);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap retrieveRemovedConsumedMessages(TransactionUID id, boolean rerouted) {
        TransactionInformation ti = null;
        this.shareLock.lock();
        try {
            ti = (TransactionInformation)this.translist.get(id);
        }
        finally {
            this.shareLock.unlock();
        }
        if (ti == null) {
            return null;
        }
        return ti.getRemovedConsumedMessages(rerouted);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reapTakeoverCommittedTransaction(TransactionUID id) {
        TransactionInformation ti = null;
        this.shareLock.lock();
        try {
            ti = (TransactionInformation)this.translist.get(id);
        }
        finally {
            this.shareLock.unlock();
        }
        if (ti != null) {
            if (ti.getType() == 2) {
                this.txnReaper.addClusterTransaction(id, false, true);
            } else if (ti.getType() == 1) {
                this.txnReaper.addLocalTransaction(id, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLocalTransaction(TransactionUID id) {
        TransactionInformation ti = null;
        this.shareLock.lock();
        try {
            ti = (TransactionInformation)this.translist.get(id);
        }
        finally {
            this.shareLock.unlock();
        }
        if (ti == null) {
            return false;
        }
        return ti.getType() == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTransactionAsString(TransactionUID id) {
        this.shareLock.lock();
        try {
            TransactionInformation ti = (TransactionInformation)this.translist.get(id);
            String string = ti == null ? "null" : ti.toString();
            return string;
        }
        finally {
            this.shareLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClusterTransaction(TransactionUID id) {
        TransactionInformation ti = null;
        this.shareLock.lock();
        try {
            ti = (TransactionInformation)this.translist.get(id);
        }
        finally {
            this.shareLock.unlock();
        }
        if (ti == null) {
            return false;
        }
        return ti.getType() == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRemoteTransaction(TransactionUID id) {
        RemoteTransactionInformation rti = null;
        this.shareLock.lock();
        try {
            rti = (RemoteTransactionInformation)this.remoteTranslist.get(id);
        }
        finally {
            this.shareLock.unlock();
        }
        return rti != null;
    }

    @Override
    public void clusterPropertyChanged(String name, String value) {
    }

    @Override
    public void brokerAdded(ClusteredBroker broker, UID brokerSession) {
    }

    @Override
    public void brokerRemoved(ClusteredBroker broker, UID brokerSession) {
    }

    @Override
    public void masterBrokerChanged(ClusteredBroker oldMaster, ClusteredBroker newMaster) {
    }

    @Override
    public void brokerStatusChanged(String brokerid, int oldStatus, int newStatus, UID uid, Object userData) {
        ClusterManager clsmgr = Globals.getClusterManager();
        ClusteredBroker cb = clsmgr.getBroker(brokerid);
        if (DEBUG_CLUSTER_TXN) {
            this.logger.log(8, "TransactionList:brokerStatusChanged:broker=" + cb + ", oldStatus=" + BrokerStatus.toString(oldStatus) + ", newStatus=" + BrokerStatus.toString(newStatus) + ", brokerSession=" + uid + ", userData=" + userData);
        }
        if (BrokerStatus.getBrokerLinkIsUp(newStatus) && !BrokerStatus.getBrokerLinkIsUp(oldStatus)) {
            this.newlyActivatedBrokers.add((BrokerMQAddress)cb.getBrokerURL());
            if (this.txnReaper != null) {
                this.txnReaper.wakeupReaperTimer();
            }
        }
    }

    @Override
    public void brokerStateChanged(String brokerid, BrokerState oldState, BrokerState newState) {
    }

    @Override
    public void brokerVersionChanged(String brokerid, int oldVersion, int newVersion) {
    }

    @Override
    public void brokerURLChanged(String brokerid, MQAddress oldAddress, MQAddress newAddress) {
    }

    @Override
    public void partitionAdded(UID partitionID, Object source) {
        if (source instanceof DestinationList) {
            this.newlyActivatedPartitions.add(partitionID);
            if (this.txnReaper != null) {
                this.txnReaper.wakeupReaperTimer();
            }
        }
    }

    @Override
    public void partitionRemoved(UID partitionID, Object source, Object destinedTo) {
    }

    static {
        if (Globals.getLogger().getLevel() <= 4) {
            DEBUG = true;
        }
        DEBUG_CLUSTER_TXN = Globals.getConfig().getBooleanProperty("imq.cluster.debug.txn") || DEBUG;
        AUTO_ROLLBACK = Globals.getConfig().getBooleanProperty("imq.transaction.autorollback", false);
        TXN_REAPINTERVAL = TransactionList.getTXN_REAPINTERVAL();
        TXN_REAPLIMIT = Broker.isInProcess() ? Globals.getConfig().getIntProperty("imq.txn.reapLimit", 0) : Globals.getConfig().getIntProperty("imq.txn.reapLimit", 500);
        TXN_REAPLIMIT_OVERTHRESHOLD = Globals.getConfig().getIntProperty("imq.txn.reapLimitOverThreshold", 100);
        defaultProducerMaxMsgCnt = Globals.getConfig().getIntProperty(TXN_PRODUCER_MAX_NUM_MSGS_PROP, 10000);
        defaultConsumerMaxMsgCnt = Globals.getConfig().getIntProperty(TXN_CONSUMER_MAX_NUM_MSGS_PROP, 1000);
    }
}

