/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.license;

import com.sun.messaging.jmq.jmsserver.comm.CommGlobals;
import com.sun.messaging.jmq.jmsserver.license.FileLicense;
import com.sun.messaging.jmq.jmsserver.license.LicenseBase;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Properties;

public class LicenseManager {
    private static BrokerResources br = CommGlobals.getBrokerResources();
    private static Logger logger = CommGlobals.getLogger();
    private LicenseBase currentLicense = null;
    private LicenseBase base = null;
    private static final String LICENSE_BASE_PKG_PREFIX = "com.sun.messaging.jmq.jmsserver.license.";
    private static final String STANDALONE_LICENSE_BASE = "StandaloneLicense";
    private static final String LICENSE_BASE_CLASS_PREFIX = "L";
    private static final int MAX_LICENSE_BASE_CLASSES = 16;
    private static final String LICENSE_DIR = CommGlobals.getJMQ_ETC_HOME() + File.separator + "lic" + File.separator;
    private static final String TRIAL_LICENSE_DIR = CommGlobals.getJMQ_VAR_HOME() + File.separator + "lic" + File.separator;
    private static final String LICENSE_FILE_PREFIX = "imqbroker";
    private static final String LICENSE_FILE_SUBFIX = ".lic";
    private static FilenameFilter licFilter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.startsWith(LicenseManager.LICENSE_FILE_PREFIX) && name.endsWith(LicenseManager.LICENSE_FILE_SUBFIX);
        }
    };

    public LicenseBase getLicense(String filestr) throws BrokerException {
        if (this.currentLicense != null) {
            return this.currentLicense;
        }
        this.base = this.getLicenseBase();
        if (this.base == null) {
            throw new BrokerException("Could not find license base class.This is a broker packaging error.");
        }
        FileLicense fl = null;
        fl = this.loadLicenseFile(filestr);
        if (fl != null) {
            try {
                fl.rewriteLicense();
            }
            catch (IOException e) {
                throw new BrokerException(br.getString("B3054"), e);
            }
        }
        if (fl != null) {
            if (filestr != null || fl.getPrecedence() > this.base.getPrecedence()) {
                this.base.superimpose(fl.getProperties());
                logger.log(4, br.getString("B1139", fl.getLicenseFile()));
            }
        } else if (this.base.isLicenseFileRequired()) {
            throw new BrokerException(br.getString("B3057"));
        }
        this.currentLicense = this.base;
        return this.base;
    }

    private LicenseBase getLicenseBase() throws BrokerException {
        Class<?> cl = null;
        String cname = "com.sun.messaging.jmq.jmsserver.license.StandaloneLicense";
        try {
            cl = Class.forName(cname);
            return this.newInstance(cl);
        }
        catch (Exception e) {
            ArrayList<LicenseBase> list = new ArrayList<LicenseBase>();
            for (int i = 0; i < 16; ++i) {
                cname = "com.sun.messaging.jmq.jmsserver.license.L" + i;
                try {
                    cl = Class.forName(cname);
                    list.add(this.newInstance(cl));
                    continue;
                }
                catch (Exception e2) {
                    // empty catch block
                }
            }
            LicenseBase[] licenses = list.toArray(new LicenseBase[list.size()]);
            return this.selectBestLicense(licenses);
        }
    }

    private LicenseBase newInstance(Class cl) throws Exception {
        Constructor co = cl.getConstructor(null);
        return (LicenseBase)co.newInstance(null);
    }

    private LicenseBase selectBestLicense(LicenseBase[] licenses) throws BrokerException {
        if (licenses == null || licenses.length == 0) {
            throw new BrokerException(br.getString("B3057"));
        }
        LicenseBase lb = licenses[0];
        for (int i = 1; i < licenses.length; ++i) {
            boolean current = lb.willExpire();
            boolean next = licenses[i].willExpire();
            if (current && !next) {
                lb = licenses[i];
            }
            if (current != next || lb.getPrecedence() >= licenses[i].getPrecedence()) continue;
            lb = licenses[i];
        }
        return lb;
    }

    private FileLicense loadLicenseFile(String filestr) throws BrokerException {
        File dir = new File(LICENSE_DIR);
        File trialdir = new File(TRIAL_LICENSE_DIR);
        FileLicense fl = null;
        Object lbase = null;
        if (filestr != null) {
            String strname = this.base.getProperty("imq.license_type");
            if (filestr.equalsIgnoreCase(strname)) {
                return null;
            }
            String licenseFile = LICENSE_FILE_PREFIX + filestr + LICENSE_FILE_SUBFIX;
            File file = null;
            file = filestr.equalsIgnoreCase("try") ? new File(trialdir, licenseFile) : new File(dir, licenseFile);
            if (!file.exists()) {
                throw new BrokerException(br.getString("B3159", filestr));
            }
            if (!file.canRead()) {
                throw new BrokerException(br.getString("B3163", licenseFile));
            }
            fl = new FileLicense(file);
        } else {
            LicenseBase[] licenses = LicenseManager.loadFileLicenses();
            if (LicenseManager.loadFileLicenses().length != 0) {
                fl = (FileLicense)this.selectBestLicense(licenses);
                File f = fl.getLicenseFile();
                if (!f.canRead()) {
                    throw new BrokerException(br.getString("B3163", f.toString()));
                }
                FileLicense lb = fl;
                Properties prop = lb.props;
                String datestring = prop.getProperty("date_string");
                if (datestring.startsWith("TRY")) {
                    return null;
                }
            }
        }
        return fl;
    }

    public static FileLicense[] loadFileLicenses() {
        File dir = new File(LICENSE_DIR);
        File trialdir = new File(TRIAL_LICENSE_DIR);
        String[] names = dir.list(licFilter);
        ArrayList<FileLicense> list = new ArrayList<FileLicense>();
        for (int i = 0; names != null && i < names.length; ++i) {
            try {
                File file = new File(dir, names[i]);
                FileLicense lic = new FileLicense(file);
                list.add(lic);
                continue;
            }
            catch (BrokerException e) {
                // empty catch block
            }
        }
        String[] trialnames = trialdir.list(licFilter);
        for (int j = 0; trialnames != null && j < trialnames.length; ++j) {
            try {
                File file = new File(trialdir, trialnames[j]);
                FileLicense lic = new FileLicense(file);
                list.add(lic);
                continue;
            }
            catch (BrokerException e) {
                // empty catch block
            }
        }
        return list.toArray(new FileLicense[list.size()]);
    }

    public static LicenseBase[] loadLicenses() {
        LicenseManager lm = new LicenseManager();
        LicenseBase lb = null;
        try {
            lb = lm.getLicenseBase();
        }
        catch (Exception ex) {
            // empty catch block
        }
        FileLicense[] fl = LicenseManager.loadFileLicenses();
        LicenseBase[] rl = new LicenseBase[fl.length + 1];
        for (int i = 0; i < fl.length; ++i) {
            rl[i] = fl[i];
        }
        if (lb != null) {
            rl[fl.length] = lb;
        }
        return rl;
    }
}

