/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.bdb;

import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.persist.api.ChangeRecordInfo;
import com.sun.messaging.jmq.jmsserver.persist.api.Store;
import com.sun.messaging.jmq.jmsserver.persist.bdb.BDBStore;
import com.sun.messaging.jmq.jmsserver.persist.bdb.LongTupleBinding;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

class ConfigRecordStore {
    Logger logger = Globals.getLogger();
    BrokerResources br = Globals.getBrokerResources();
    private Database db = null;
    private TupleBinding longBinding = null;

    protected ConfigRecordStore(BDBStore p) {
        this.db = p.getConfigRecordDatabase();
        this.longBinding = new LongTupleBinding();
    }

    protected void storeConfigChangeRecord(Transaction txn, long timestamp, byte[] recordData) throws BrokerException {
        try {
            DatabaseEntry key = new DatabaseEntry();
            this.longBinding.objectToEntry((Object)timestamp, key);
            DatabaseEntry data = new DatabaseEntry(recordData);
            OperationStatus status = this.db.putNoOverwrite(txn, key, data);
            if (status == OperationStatus.KEYEXIST) {
                DatabaseEntry lastdata;
                DatabaseEntry lastkey;
                Cursor cs = this.db.openCursor(txn, null);
                status = cs.getLast(lastkey = new DatabaseEntry(), lastdata = new DatabaseEntry(), null);
                if (status != OperationStatus.NOTFOUND) {
                    Long ts = (Long)this.longBinding.entryToObject(lastkey);
                    timestamp = ts + 1L;
                }
                cs.close();
                key = new DatabaseEntry();
                this.longBinding.objectToEntry((Object)timestamp, key);
                status = this.db.putNoOverwrite(txn, key, data);
                if (status == OperationStatus.KEYEXIST) {
                    String emsg = this.br.getKString("B4083", String.valueOf(timestamp) + ": Timestamp already exist");
                    this.logger.log(32, emsg);
                    throw new BrokerException(emsg);
                }
            }
        }
        catch (Exception e) {
            if (e instanceof BrokerException) {
                throw (BrokerException)e;
            }
            String emsg = this.br.getKString("B4083", String.valueOf(timestamp) + ": " + e.getMessage());
            this.logger.logStack(32, emsg, e);
            throw new BrokerException(emsg, e);
        }
    }

    protected ArrayList<ChangeRecordInfo> getConfigChangeRecordsSince(Transaction txn, long timestamp) throws BrokerException {
        ArrayList<ChangeRecordInfo> crinfos = new ArrayList<ChangeRecordInfo>();
        Cursor cs = null;
        try {
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            Long ts = null;
            cs = this.db.openCursor(txn, null);
            while (cs.getNext(key, data, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                ts = (Long)this.longBinding.entryToObject(key);
                if (ts <= timestamp) {
                    key = new DatabaseEntry();
                    data = new DatabaseEntry();
                    continue;
                }
                crinfos.add(new ChangeRecordInfo(data.getData(), ts));
            }
            cs.close();
            ArrayList<ChangeRecordInfo> arrayList = crinfos;
            return arrayList;
        }
        catch (Exception e) {
            String emsg = this.br.getKString("B4082") + "[" + timestamp + "]";
            this.logger.logStack(32, emsg, e);
            throw new BrokerException(emsg, e);
        }
        finally {
            if (cs != null) {
                try {
                    cs.close();
                }
                catch (Exception e) {
                    this.logger.log(16, "Failed to close cursor in getting cluster change records since timestamp " + timestamp + " from store: " + e.getMessage());
                }
            }
        }
    }

    public List<ChangeRecordInfo> getAllConfigRecords(Transaction txn) throws BrokerException {
        ArrayList<ChangeRecordInfo> crinfos = new ArrayList<ChangeRecordInfo>();
        Cursor cs = null;
        try {
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            Long ts = null;
            cs = this.db.openCursor(txn, null);
            while (cs.getNext(key, data, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                ts = (Long)this.longBinding.entryToObject(key);
                crinfos.add(new ChangeRecordInfo(data.getData(), ts));
            }
            cs.close();
            ArrayList<ChangeRecordInfo> arrayList = crinfos;
            return arrayList;
        }
        catch (Exception e) {
            String emsg = this.br.getKString("B4082");
            this.logger.logStack(32, emsg, e);
            throw new BrokerException(emsg, e);
        }
        finally {
            if (cs != null) {
                try {
                    cs.close();
                }
                catch (Exception e) {
                    this.logger.log(16, "Failed to close cursor in getting cluster change records from store: " + e.getMessage());
                }
            }
        }
    }

    protected void clearAll(Transaction txn) throws BrokerException {
        Cursor cs = null;
        try {
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            cs = this.db.openCursor(txn, null);
            while (cs.getNext(key, data, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                cs.delete();
            }
            cs.close();
        }
        catch (Exception e) {
            String emsg = "Deleting all cluster change records failed";
            this.logger.logStack(32, emsg, e);
            throw new BrokerException(emsg, e);
        }
        finally {
            if (cs != null) {
                try {
                    cs.close();
                }
                catch (Exception e) {
                    this.logger.log(16, "Failed to close cursor in deleting all cluster change records from store: " + e.getMessage());
                }
            }
        }
    }

    protected void close() {
        if (Store.getDEBUG()) {
            this.logger.log(8, "ConfigRecordStore: closing with " + this.db.count() + " records");
        }
    }

    protected Hashtable getDebugState() {
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("dbCount", String.valueOf(this.db.count()));
        t.put("dbConfig", this.db.getConfig().toString());
        return t;
    }
}

