/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.bdb;

import com.sleepycat.bind.EntryBinding;
import com.sleepycat.bind.serial.ClassCatalog;
import com.sleepycat.bind.serial.SerialBinding;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.persist.api.Store;
import com.sun.messaging.jmq.jmsserver.persist.bdb.BDBStore;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.DestinationNotFoundException;
import com.sun.messaging.jmq.util.log.Logger;
import java.util.ArrayList;
import java.util.Hashtable;

class DestinationStore {
    Logger logger = Globals.getLogger();
    BrokerResources br = Globals.getBrokerResources();
    private BDBStore parent = null;
    private Database db = null;
    private EntryBinding dataBinding = null;

    protected DestinationStore(BDBStore p) {
        this.parent = p;
        this.db = p.getDstDatabase();
        this.dataBinding = new SerialBinding((ClassCatalog)p.getClassCatalog(), Destination.class);
    }

    protected void storeDestination(Transaction txn, Destination destination) throws BrokerException {
        this.storeDestination(txn, destination, false);
    }

    protected void storeDestination(Transaction txn, Destination destination, boolean silentIfExist) throws BrokerException {
        try {
            String duid = destination.getDestinationUID().toString();
            DatabaseEntry key = new DatabaseEntry(duid.getBytes("UTF-8"));
            DatabaseEntry data = new DatabaseEntry();
            this.dataBinding.objectToEntry((Object)destination, data);
            OperationStatus status = this.db.putNoOverwrite(txn, key, data);
            if (status == OperationStatus.KEYEXIST) {
                if (silentIfExist) {
                    return;
                }
                String emsg = this.br.getString("B3012", destination.getName());
                this.logger.log(32, emsg);
                throw new BrokerException(emsg);
            }
        }
        catch (Exception e) {
            String emsg = this.br.getString("B4014", destination.getName());
            this.logger.log(32, emsg);
            throw new BrokerException(emsg, e);
        }
    }

    protected void updateDestination(Transaction txn, Destination destination) throws BrokerException {
        try {
            String duid = destination.getDestinationUID().toString();
            DatabaseEntry key = new DatabaseEntry(duid.getBytes("UTF-8"));
            DatabaseEntry data = new DatabaseEntry();
            data.setPartial(0, 0, true);
            OperationStatus status = this.db.get(txn, key, data, null);
            if (status == OperationStatus.NOTFOUND) {
                String emsg = this.br.getKString("B3013", destination.getName());
                this.logger.log(32, emsg);
                throw new DestinationNotFoundException(emsg);
            }
            data = new DatabaseEntry();
            this.dataBinding.objectToEntry((Object)destination, data);
            status = this.db.putNoOverwrite(txn, key, data);
        }
        catch (Exception e) {
            String emsg = this.br.getKString("B4014", destination.getName());
            this.logger.log(32, emsg);
            throw new BrokerException(emsg, e);
        }
    }

    protected void removeDestination(Transaction txn, Destination dst) throws BrokerException {
        String duid = dst.getDestinationUID().toString();
        try {
            try {
                this.parent.getMsgStore().removeDestination(txn, dst.getDestinationUID());
            }
            catch (DestinationNotFoundException e) {
                // empty catch block
            }
            DatabaseEntry key = new DatabaseEntry(duid.getBytes("UTF-8"));
            OperationStatus status = this.db.delete(txn, key);
            if (status == OperationStatus.NOTFOUND) {
                String emsg = this.br.getKString("B3013", duid);
                this.logger.log(32, emsg);
                throw new DestinationNotFoundException(emsg);
            }
        }
        catch (Exception e) {
            String emsg = this.br.getKString("B4144", duid);
            this.logger.log(32, emsg);
            throw new BrokerException(emsg, e);
        }
    }

    protected Destination getDestination(Transaction txn, DestinationUID uid) throws BrokerException {
        try {
            String duid = uid.toString();
            DatabaseEntry key = new DatabaseEntry(duid.getBytes("UTF-8"));
            DatabaseEntry data = new DatabaseEntry();
            OperationStatus status = this.db.get(txn, key, data, null);
            if (status == OperationStatus.NOTFOUND) {
                return null;
            }
            return (Destination)this.dataBinding.entryToObject(data);
        }
        catch (Exception e) {
            String emsg = this.br.getKString("B4224", uid.getName());
            this.logger.log(32, emsg);
            throw new BrokerException(emsg, e);
        }
    }

    protected void checkDestinationExist(Transaction txn, DestinationUID uid) throws BrokerException {
        try {
            String duid = uid.toString();
            DatabaseEntry key = new DatabaseEntry(duid.getBytes("UTF-8"));
            DatabaseEntry data = new DatabaseEntry();
            data.setPartial(0, 0, true);
            OperationStatus status = this.db.get(txn, key, data, null);
            if (status == OperationStatus.NOTFOUND) {
                String emsg = this.br.getKString("B3013", uid.toString());
                throw new DestinationNotFoundException(emsg);
            }
        }
        catch (Exception e) {
            String emsg = this.br.getKString("B4224", uid.getName());
            this.logger.log(32, emsg);
            throw new BrokerException(emsg, e);
        }
    }

    protected Destination[] getAllDestinations(Transaction txn) throws BrokerException {
        ArrayList<Destination> dests = new ArrayList<Destination>();
        Cursor cs = null;
        try {
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            String duid = null;
            Destination dst = null;
            cs = this.db.openCursor(txn, null);
            while (cs.getNext(key, data, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                duid = new String(key.getData(), "UTF-8");
                dst = (Destination)this.dataBinding.entryToObject(data);
                dests.add(dst);
            }
            cs.close();
            Destination[] destinationArray = dests.toArray(new Destination[dests.size()]);
            return destinationArray;
        }
        catch (Exception e) {
            String emsg = this.br.getKString("B4031");
            this.logger.log(32, emsg);
            throw new BrokerException(emsg, e);
        }
        finally {
            if (cs != null) {
                try {
                    cs.close();
                }
                catch (Exception e) {
                    this.logger.log(16, "Failed to close cursor in getting all destinations from store: " + e.getMessage());
                }
            }
        }
    }

    protected void clearAll(Transaction txn, boolean msgonly) throws BrokerException {
        Destination[] dsts = this.getAllDestinations(txn);
        int cnt = dsts.length;
        if (!msgonly) {
            for (int i = 0; i < cnt; ++i) {
                this.removeDestination(txn, dsts[i]);
            }
        } else {
            for (int i = 0; i < cnt; ++i) {
                try {
                    this.parent.getMsgStore().removeDestination(txn, dsts[i].getDestinationUID());
                    continue;
                }
                catch (DestinationNotFoundException e) {
                    // empty catch block
                }
            }
        }
    }

    protected Hashtable getDebugState() {
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("dbCount", String.valueOf(this.db.count()));
        t.put("dbConfig", this.db.getConfig().toString());
        return t;
    }

    protected void close() {
        if (Store.getDEBUG()) {
            this.logger.log(8, "DestinationStore: closing with " + this.db.count() + " destinations");
        }
    }
}

