/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.coherence;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.persist.api.Store;
import com.sun.messaging.jmq.jmsserver.persist.coherence.CoherenceStore;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import com.tangosol.net.NamedCache;
import java.io.IOException;
import java.util.Collection;
import java.util.Hashtable;

class DestinationStore {
    Logger logger = Globals.getLogger();
    BrokerResources br = Globals.getBrokerResources();
    private CoherenceStore parent = null;
    private NamedCache dstCache = null;

    DestinationStore(CoherenceStore p) {
        this.parent = p;
        this.dstCache = p.getDstCache();
    }

    protected void storeDestination(Destination dest) throws IOException, BrokerException {
        if (Store.getDEBUG()) {
            this.logger.log(8, "DestinationStore.storeDestination(" + dest + ")");
        }
        try {
            Object old = this.dstCache.put((Object)dest.getDestinationUID().toString(), (Object)dest, -1L);
            if (old != null) {
                String emsg = this.br.getString("B3012", dest.getName());
                this.logger.log(32, emsg);
                throw new BrokerException(emsg);
            }
        }
        catch (Exception e) {
            if (e instanceof BrokerException) {
                throw (BrokerException)e;
            }
            String emsg = this.br.getString("B4014", dest.getName());
            this.logger.log(32, emsg, e);
            throw new BrokerException(emsg, e);
        }
    }

    protected void updateDestination(Destination dest) throws BrokerException {
        if (Store.getDEBUG()) {
            this.logger.log(8, "DestinationStore.updateDestination(" + dest + ")");
        }
        try {
            Object oldValue = this.dstCache.put((Object)dest.getDestinationUID().toString(), (Object)dest, -1L);
            if (oldValue == null) {
                String emsg = this.br.getString("B3013", dest.getName());
                this.logger.log(32, emsg);
                throw new BrokerException(emsg);
            }
        }
        catch (Exception e) {
            if (e instanceof BrokerException) {
                throw (BrokerException)e;
            }
            String emsg = this.br.getString("B4014", dest.getName());
            this.logger.log(32, emsg, e);
            throw new BrokerException(emsg, e);
        }
    }

    protected void removeDestination(Destination dest) throws BrokerException {
        if (Store.getDEBUG()) {
            this.logger.log(8, "DestinationStore.removeDestination(" + dest + ")");
        }
        DestinationUID duid = dest.getDestinationUID();
        try {
            Object oldValue = this.dstCache.remove((Object)duid.toString());
            if (oldValue == null) {
                String emsg = this.br.getString("B3013", dest.getName());
                this.logger.log(32, emsg);
                throw new BrokerException(emsg);
            }
            this.parent.getMsgStore().releaseMessageDir(duid);
        }
        catch (Exception e) {
            if (e instanceof BrokerException) {
                throw (BrokerException)e;
            }
            String emsg = this.br.getString("B4144", dest.getName());
            this.logger.log(32, emsg, e);
            throw new BrokerException(emsg, e);
        }
    }

    protected Destination getDestination(DestinationUID duid) throws IOException {
        if (Store.getDEBUG()) {
            this.logger.log(8, "DestinationStore.getDestination(" + duid + ")");
        }
        return (Destination)this.dstCache.get((Object)duid.toString());
    }

    protected Destination[] getAllDestinations() throws IOException {
        if (Store.getDEBUG()) {
            this.logger.log(8, "DestinationStore.getAllDestinations()");
        }
        return this.getDestinations().toArray(new Destination[0]);
    }

    protected Collection getDestinations() {
        if (Store.getDEBUG()) {
            this.logger.log(8, "DestinationStore.getDestinations()");
        }
        return this.dstCache.getAll((Collection)this.dstCache.keySet()).values();
    }

    protected void clearAll(boolean clearMessages) {
        if (Store.getDEBUG()) {
            this.logger.log(8, "DestinationStore.clearAll(" + clearMessages + ")");
        }
        if (clearMessages) {
            for (Destination dst : this.getDestinations()) {
                DestinationUID did = dst.getDestinationUID();
                this.parent.getMsgStore().releaseMessageDir(did);
            }
            this.dstCache.destroy();
        }
    }

    protected Hashtable getDebugState() {
        if (Store.getDEBUG()) {
            this.logger.log(8, "DestinationStore.getDebugState()");
        }
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("Destinations", String.valueOf(this.dstCache.size()));
        return t;
    }

    protected void close(boolean cleanup) {
        if (Store.getDEBUG()) {
            this.logger.log(8, "DestinationStore.close(" + cleanup + "), " + this.dstCache.size() + " destinations");
        }
    }

    protected void checkDestination(DestinationUID duid) throws BrokerException {
        if (Store.getDEBUG()) {
            this.logger.log(8, "checkDestination(" + duid + ")" + this.dstCache.size());
        }
        if (!this.dstCache.containsKey((Object)duid.toString())) {
            String emsg = this.br.getString("B3013", duid) + "[" + this.dstCache.size() + "]";
            this.logger.log(32, emsg);
            throw new BrokerException(emsg);
        }
    }
}

