/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.SecretDecoderRing;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import javax.crypto.SecretKey;
import org.mozilla.jss.SecretDecoderRing.Encryptor;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.EncryptionAlgorithm;
import org.mozilla.jss.crypto.KeyGenAlgorithm;
import org.mozilla.jss.crypto.SecretKeyFacade;
import org.mozilla.jss.crypto.SymmetricKey;
import org.mozilla.jss.crypto.TokenException;

public class KeyManager {
    private static final int KEYID_LEN = 16;
    private static final String RNG_ALG = "pkcs11prng";
    private static final String RNG_PROVIDER = "Mozilla-JSS";
    public static final KeyGenAlgorithm DEFAULT_KEYGEN_ALG = KeyGenAlgorithm.DES3;
    public static final int DEFAULT_KEYSIZE = 0;
    private CryptoToken token;

    public KeyManager(CryptoToken cryptoToken) {
        if (cryptoToken == null) {
            throw new NullPointerException("token is null");
        }
        this.token = cryptoToken;
    }

    public byte[] generateKey() throws TokenException {
        return this.generateKey(DEFAULT_KEYGEN_ALG, 0);
    }

    public byte[] generateKey(KeyGenAlgorithm keyGenAlgorithm, int n) throws TokenException {
        if (keyGenAlgorithm == null) {
            throw new NullPointerException("alg is null");
        }
        byte[] byArray = this.generateUnusedKeyID();
        this.generateKeyNative(this.token, keyGenAlgorithm, byArray, n);
        return byArray;
    }

    private native void generateKeyNative(CryptoToken var1, KeyGenAlgorithm var2, byte[] var3, int var4);

    public byte[] generateUniqueNamedKey(String string) throws TokenException {
        return this.generateUniqueNamedKey(DEFAULT_KEYGEN_ALG, 0, string);
    }

    public byte[] generateUniqueNamedKey(KeyGenAlgorithm keyGenAlgorithm, int n, String string) throws TokenException {
        if (string != null) {
            string = string.trim();
        }
        if (keyGenAlgorithm == null) {
            throw new NullPointerException("alg is null");
        }
        if (this.uniqueNamedKeyExists(string)) {
            throw new NullPointerException("duplicate symmetric key");
        }
        byte[] byArray = this.generateUnusedKeyID();
        this.generateUniqueNamedKeyNative(this.token, keyGenAlgorithm, byArray, n, string);
        return byArray;
    }

    private native void generateUniqueNamedKeyNative(CryptoToken var1, KeyGenAlgorithm var2, byte[] var3, int var4, String var5);

    private byte[] generateUnusedKeyID() throws TokenException {
        try {
            SecureRandom secureRandom = SecureRandom.getInstance(RNG_ALG, RNG_PROVIDER);
            byte[] byArray = new byte[16];
            do {
                secureRandom.nextBytes(byArray);
            } while (this.keyExists(byArray));
            return byArray;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("No such algorithm: pkcs11prng");
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new RuntimeException("No such provider: Mozilla-JSS");
        }
    }

    private boolean keyExists(byte[] byArray) throws TokenException {
        return this.lookupKey(Encryptor.DEFAULT_ENCRYPTION_ALG, byArray) != null;
    }

    public SecretKey lookupKey(EncryptionAlgorithm encryptionAlgorithm, byte[] byArray) throws TokenException {
        if (encryptionAlgorithm == null || byArray == null) {
            throw new NullPointerException();
        }
        SymmetricKey symmetricKey = this.lookupKeyNative(this.token, encryptionAlgorithm, byArray);
        if (symmetricKey == null) {
            return null;
        }
        return new SecretKeyFacade(symmetricKey);
    }

    private native SymmetricKey lookupKeyNative(CryptoToken var1, EncryptionAlgorithm var2, byte[] var3) throws TokenException;

    public boolean uniqueNamedKeyExists(String string) throws TokenException {
        return this.lookupUniqueNamedKey(Encryptor.DEFAULT_ENCRYPTION_ALG, string) != null;
    }

    public SecretKey lookupUniqueNamedKey(EncryptionAlgorithm encryptionAlgorithm, String string) throws TokenException {
        if (string != null) {
            string = string.trim();
        }
        if (encryptionAlgorithm == null || string == null || string.equals("")) {
            throw new NullPointerException();
        }
        SymmetricKey symmetricKey = this.lookupUniqueNamedKeyNative(this.token, encryptionAlgorithm, string);
        if (symmetricKey == null) {
            return null;
        }
        return new SecretKeyFacade(symmetricKey);
    }

    private native SymmetricKey lookupUniqueNamedKeyNative(CryptoToken var1, EncryptionAlgorithm var2, String var3) throws TokenException;

    public void deleteKey(byte[] byArray) throws TokenException, InvalidKeyException {
        this.deleteKey(this.lookupKey(Encryptor.DEFAULT_ENCRYPTION_ALG, byArray));
    }

    public void deleteUniqueNamedKey(String string) throws TokenException, InvalidKeyException {
        if (this.uniqueNamedKeyExists(string)) {
            this.deleteKey(this.lookupUniqueNamedKey(Encryptor.DEFAULT_ENCRYPTION_ALG, string));
        }
    }

    public void deleteKey(SecretKey secretKey) throws TokenException, InvalidKeyException {
        if (secretKey == null) {
            throw new NullPointerException();
        }
        if (!(secretKey instanceof SecretKeyFacade)) {
            throw new InvalidKeyException("Key must be a JSS key");
        }
        this.deleteKeyNative(this.token, ((SecretKeyFacade)secretKey).key);
    }

    private native void deleteKeyNative(CryptoToken var1, SymmetricKey var2) throws TokenException;
}

