/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkcs12;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.EXPLICIT;
import org.mozilla.jss.asn1.IA5String;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.util.Assert;

public class CertBag
implements ASN1Value {
    private static final OBJECT_IDENTIFIER CERT_TYPES = OBJECT_IDENTIFIER.PKCS9.subBranch(22L);
    public static final OBJECT_IDENTIFIER X509_CERT_TYPE = CERT_TYPES.subBranch(1L);
    public static final OBJECT_IDENTIFIER SDSI_CERT_TYPE = CERT_TYPES.subBranch(2L);
    private OBJECT_IDENTIFIER certType;
    private ANY cert;
    private SEQUENCE sequence;
    private static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    public OBJECT_IDENTIFIER getCertType() {
        return this.certType;
    }

    public ANY getCert() {
        return this.cert;
    }

    public ASN1Value getInterpretedCert() throws InvalidBERException {
        if (this.certType.equals(X509_CERT_TYPE)) {
            return this.cert.decodeWith(OCTET_STRING.getTemplate());
        }
        if (this.certType.equals(SDSI_CERT_TYPE)) {
            return this.cert.decodeWith(IA5String.getTemplate());
        }
        return this.cert;
    }

    private CertBag() {
    }

    public CertBag(OBJECT_IDENTIFIER oBJECT_IDENTIFIER, ASN1Value aSN1Value) {
        if (oBJECT_IDENTIFIER == null || aSN1Value == null) {
            throw new IllegalArgumentException("certType or cert is null");
        }
        this.certType = oBJECT_IDENTIFIER;
        if (aSN1Value instanceof ANY) {
            this.cert = (ANY)aSN1Value;
        } else {
            try {
                byte[] byArray = ASN1Util.encode(aSN1Value);
                this.cert = (ANY)ASN1Util.decode(ANY.getTemplate(), byArray);
            }
            catch (InvalidBERException invalidBERException) {
                Assert.notReached("converting ASN1Value to ANY failed");
            }
        }
        this.sequence = new SEQUENCE();
        this.sequence.addElement(this.certType);
        this.sequence.addElement(new EXPLICIT(new Tag(0L), this.cert));
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.sequence.encode(outputStream);
    }

    public void encode(Tag tag, OutputStream outputStream) throws IOException {
        this.sequence.encode(tag, outputStream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(OBJECT_IDENTIFIER.getTemplate());
            this.seqt.addElement(new EXPLICIT.Template(new Tag(0L), ANY.getTemplate()));
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        public ASN1Value decode(InputStream inputStream) throws InvalidBERException, IOException {
            return this.decode(TAG, inputStream);
        }

        public ASN1Value decode(Tag tag, InputStream inputStream) throws InvalidBERException, IOException {
            SEQUENCE sEQUENCE = (SEQUENCE)this.seqt.decode(tag, inputStream);
            return new CertBag((OBJECT_IDENTIFIER)sEQUENCE.elementAt(0), ((EXPLICIT)sEQUENCE.elementAt(1)).getContent());
        }
    }
}

