/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.cmc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.GeneralizedTime;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.util.Assert;

public class PendInfo
implements ASN1Value {
    private SEQUENCE sequence;
    private OCTET_STRING pendToken;
    private GeneralizedTime pendTime;
    public static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    private PendInfo() {
    }

    public PendInfo(OCTET_STRING oCTET_STRING, GeneralizedTime generalizedTime) {
        this.sequence = new SEQUENCE();
        this.pendToken = oCTET_STRING;
        this.sequence.addElement(oCTET_STRING);
        this.pendTime = generalizedTime;
        this.sequence.addElement(generalizedTime);
    }

    public PendInfo(String string, Date date) {
        this.sequence = new SEQUENCE();
        this.pendToken = new OCTET_STRING(string.getBytes());
        this.sequence.addElement(new OCTET_STRING(string.getBytes()));
        this.pendTime = new GeneralizedTime(date);
        this.sequence.addElement(new GeneralizedTime(date));
    }

    public GeneralizedTime getPendTime() {
        return this.pendTime;
    }

    public OCTET_STRING getPendToken() {
        return this.pendToken;
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.encode(TAG, outputStream);
    }

    public void encode(Tag tag, OutputStream outputStream) throws IOException {
        this.sequence.encode(tag, outputStream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(OCTET_STRING.getTemplate());
            this.seqt.addElement(GeneralizedTime.getTemplate());
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        public ASN1Value decode(InputStream inputStream) throws InvalidBERException, IOException {
            return this.decode(TAG, inputStream);
        }

        public ASN1Value decode(Tag tag, InputStream inputStream) throws InvalidBERException, IOException {
            SEQUENCE sEQUENCE = (SEQUENCE)this.seqt.decode(tag, inputStream);
            Assert._assert(sEQUENCE.size() == 2);
            return new PendInfo((OCTET_STRING)sEQUENCE.elementAt(0), (GeneralizedTime)sEQUENCE.elementAt(1));
        }
    }
}

