/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Calendar;
import java.util.Date;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.BOOLEAN;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.InternalCertificate;
import org.mozilla.jss.crypto.SignatureAlgorithm;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.pkix.cert.Certificate;
import org.mozilla.jss.pkix.cert.CertificateInfo;
import org.mozilla.jss.pkix.cert.Extension;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;
import org.mozilla.jss.pkix.primitive.Name;
import org.mozilla.jss.pkix.primitive.SubjectPublicKeyInfo;
import org.mozilla.jss.tests.FilePasswordCallback;

public class GenerateTestCert {
    private X509Certificate nssServerCert;
    private X509Certificate nssClientCert;
    private static final String CACERT_NICKNAME = "JSSCATestCert";
    private static final String SERVERCERT_NICKNAME = "JSSTestServerCert";
    private static final String CLIENTCERT_NICKNAME = "JSSTestClientCert";
    private String keyType = "RSA";
    private int keyLength = 1024;
    private SignatureAlgorithm sigAlg = SignatureAlgorithm.RSASignatureWithSHA256Digest;

    public static void main(String[] stringArray) throws Exception {
        GenerateTestCert generateTestCert = new GenerateTestCert();
        if (stringArray.length > 0) {
            generateTestCert.doIt(stringArray);
        } else {
            generateTestCert.usage();
        }
    }

    public void usage() {
        System.out.println("USAGE: java org.mozilla.jss.tests.GenerateTestCert <test dir> <password file> <serial Number > [hostname] [Signature Alg] [CAcertNickname] [ServerCertNickname] [ClientCertNickName]");
        System.out.println("This program creates self signed Certificates.They are only meant for testing and should never be used in production. \nThe default nicknames:\n\tCA certificate: JSSCATestCert\n\tServer certificate: JSSTestServerCert\n\tClient certificate: JSSTestClientCert");
        System.out.println("Signature algorithm values:\n\tSHA-1/RSA\tSHA-256/RSA\tSHA-384/RSA\tSHA-512/RSA\tSHA-1/DSA\tSHA-1/EC\tSHA-256/EC\tSHA-384/EC\tSHA-512/EC");
        System.exit(1);
    }

    private void setSigAlg(String string) {
        if (string.equalsIgnoreCase("SHA-1/RSA")) {
            this.sigAlg = SignatureAlgorithm.RSASignatureWithSHA1Digest;
        } else if (string.equalsIgnoreCase("SHA-256/RSA")) {
            this.sigAlg = SignatureAlgorithm.RSASignatureWithSHA256Digest;
        } else if (string.equalsIgnoreCase("SHA-384/RSA")) {
            this.sigAlg = SignatureAlgorithm.RSASignatureWithSHA384Digest;
        } else if (string.equalsIgnoreCase("SHA-512/RSA")) {
            this.sigAlg = SignatureAlgorithm.RSASignatureWithSHA512Digest;
        } else if (string.equalsIgnoreCase("SHA-1/DSA")) {
            this.sigAlg = SignatureAlgorithm.DSASignatureWithSHA1Digest;
        } else if (string.equalsIgnoreCase("SHA-1/EC")) {
            this.sigAlg = SignatureAlgorithm.ECSignatureWithSHA1Digest;
        } else if (string.equalsIgnoreCase("SHA-256/EC")) {
            this.sigAlg = SignatureAlgorithm.ECSignatureWithSHA256Digest;
        } else if (string.equalsIgnoreCase("SHA-384/EC")) {
            this.sigAlg = SignatureAlgorithm.ECSignatureWithSHA384Digest;
        } else if (string.equalsIgnoreCase("SHA-512/EC")) {
            this.sigAlg = SignatureAlgorithm.ECSignatureWithSHA512Digest;
        } else {
            this.usage();
        }
        if (string.endsWith("RSA")) {
            this.keyType = "RSA";
        } else if (string.endsWith("DSA")) {
            this.keyType = "DSA";
        } else if (string.endsWith("EC")) {
            this.keyType = "EC";
            this.keyLength = 256;
        } else {
            this.usage();
        }
    }

    private void doIt(String[] stringArray) throws Exception {
        String string = CACERT_NICKNAME;
        String string2 = SERVERCERT_NICKNAME;
        String string3 = CLIENTCERT_NICKNAME;
        if (stringArray.length < 3) {
            this.usage();
        }
        try {
            X509Certificate[] x509CertificateArray;
            CryptoManager.initialize(stringArray[0]);
            CryptoManager cryptoManager = CryptoManager.getInstance();
            CryptoToken cryptoToken = cryptoManager.getInternalKeyStorageToken();
            FilePasswordCallback filePasswordCallback = new FilePasswordCallback(stringArray[1]);
            cryptoToken.login(filePasswordCallback);
            int n = new Integer(stringArray[2]);
            X509Certificate[] x509CertificateArray2 = cryptoManager.getPermCerts();
            int n2 = x509CertificateArray2.length;
            System.out.println("Number of certificates stored in the  database: " + n2);
            String string4 = "localhost";
            if (stringArray.length > 4) {
                string4 = stringArray[3];
            }
            String string5 = "SHA-256/RSA";
            if (stringArray.length > 5) {
                string5 = stringArray[4];
            }
            this.setSigAlg(string5);
            if (stringArray.length > 6) {
                string = stringArray[5];
            }
            if ((x509CertificateArray = cryptoManager.findCertsByNickname(string)).length > 0) {
                System.out.println(string + " already exists!");
                System.exit(1);
            }
            if (stringArray.length > 7) {
                string2 = stringArray[6];
            }
            if ((x509CertificateArray = cryptoManager.findCertsByNickname(string2)).length > 0) {
                System.out.println(string2 + " already exists!");
                System.exit(1);
            }
            if (stringArray.length == 8) {
                string3 = stringArray[7];
            }
            if ((x509CertificateArray = cryptoManager.findCertsByNickname(string3)).length > 0) {
                System.out.println(string3 + " already exists!");
                System.exit(1);
            }
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(this.keyType, "Mozilla-JSS");
            keyPairGenerator.initialize(this.keyLength);
            KeyPair keyPair = keyPairGenerator.genKeyPair();
            SEQUENCE sEQUENCE = new SEQUENCE();
            sEQUENCE.addElement(this.makeBasicConstraintsExtension());
            Certificate certificate = this.makeCert("CACert", "CACert", n, keyPair.getPrivate(), keyPair.getPublic(), n, sEQUENCE);
            X509Certificate x509Certificate = cryptoManager.importUserCACertPackage(ASN1Util.encode(certificate), string);
            InternalCertificate internalCertificate = (InternalCertificate)x509Certificate;
            internalCertificate.setSSLTrust(152);
            keyPairGenerator.initialize(this.keyLength);
            KeyPair keyPair2 = keyPairGenerator.genKeyPair();
            Certificate certificate2 = this.makeCert("CACert", string4, n + 1, keyPair.getPrivate(), keyPair2.getPublic(), n, null);
            this.nssServerCert = cryptoManager.importCertPackage(ASN1Util.encode(certificate2), string2);
            keyPairGenerator.initialize(this.keyLength);
            KeyPair keyPair3 = keyPairGenerator.genKeyPair();
            Certificate certificate3 = this.makeCert("CACert", "ClientCert", n + 2, keyPair.getPrivate(), keyPair3.getPublic(), n, null);
            this.nssClientCert = cryptoManager.importCertPackage(ASN1Util.encode(certificate3), string3);
            System.out.println("\nThis program created certificates with \nfollowing cert nicknames:\n\t" + string + "\n\t" + string2 + "\n\t" + string3);
            x509CertificateArray2 = cryptoManager.getPermCerts();
            if (n2 + 3 != x509CertificateArray2.length) {
                System.out.println("Error there should be three more  certificates stored in the database");
                System.exit(1);
            } else {
                System.out.println("Number of certificates stored in the  database: " + x509CertificateArray2.length);
            }
            x509CertificateArray = cryptoManager.findCertsByNickname(string);
            if (x509CertificateArray.length == 0) {
                System.out.println(string + " should exist!");
                System.exit(1);
            }
            if ((x509CertificateArray = cryptoManager.findCertsByNickname(string2)).length == 0) {
                System.out.println(string2 + " should exist!");
                System.exit(1);
            }
            if ((x509CertificateArray = cryptoManager.findCertsByNickname(string3)).length == 0) {
                System.out.println(string3 + " should exist!");
                System.exit(1);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    private Extension makeBasicConstraintsExtension() throws Exception {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addElement(new BOOLEAN(true));
        OBJECT_IDENTIFIER oBJECT_IDENTIFIER = new OBJECT_IDENTIFIER(new long[]{2L, 5L, 29L, 19L});
        OCTET_STRING oCTET_STRING = new OCTET_STRING(ASN1Util.encode(sEQUENCE));
        return new Extension(oBJECT_IDENTIFIER, true, oCTET_STRING);
    }

    private Certificate makeCert(String string, String string2, int n, PrivateKey privateKey, PublicKey publicKey, int n2, SEQUENCE sEQUENCE) throws Exception {
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(this.sigAlg.toOID());
        Name name = new Name();
        name.addCountryName("US");
        name.addOrganizationName("Mozilla");
        name.addOrganizationalUnitName("JSS Testing" + n2);
        name.addCommonName(string);
        Name name2 = new Name();
        name2.addCountryName("US");
        name2.addOrganizationName("Mozilla");
        name2.addOrganizationalUnitName("JSS Testing" + n2);
        name2.addCommonName(string2);
        Calendar calendar = Calendar.getInstance();
        Date date = calendar.getTime();
        calendar.add(1, 1);
        Date date2 = calendar.getTime();
        SubjectPublicKeyInfo.Template template = new SubjectPublicKeyInfo.Template();
        SubjectPublicKeyInfo subjectPublicKeyInfo = (SubjectPublicKeyInfo)ASN1Util.decode(template, publicKey.getEncoded());
        CertificateInfo certificateInfo = new CertificateInfo(CertificateInfo.v3, new INTEGER(n), algorithmIdentifier, name, date, date2, name2, subjectPublicKeyInfo);
        if (sEQUENCE != null) {
            certificateInfo.setExtensions(sEQUENCE);
        }
        return new Certificate(certificateInfo, privateKey, this.sigAlg);
    }
}

