/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class JSSE_SSLClient {
    private String sslRevision = "TLS";
    private String host = null;
    private int port = -1;
    private String cipherName = null;
    private String path = null;
    private int debug_level = 0;
    private String EOF = "test";
    private String keystoreLoc = "rsa.pfx";
    private SSLSocketFactory factory = null;
    private ArrayList ciphersToTest = new ArrayList();
    private ArrayList h_ciphers = new ArrayList();
    private ArrayList f_ciphers = new ArrayList();
    private boolean bVerbose = false;
    private boolean bFipsMode = false;

    public void setSslRevision(String string) {
        if (!string.equals("TLS") && !string.equals("SSLv3")) {
            System.out.println("type must equal 'TLS' or 'SSLv3'\n");
            System.exit(1);
        }
        this.sslRevision = string;
    }

    public void setHost(String string) {
        this.host = string;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public void setCipherSuite(String string) {
        this.cipherName = string;
    }

    public void setKeystoreLoc(String string) {
        this.keystoreLoc = string + "/" + this.keystoreLoc;
    }

    public String getKeystoreLoc() {
        return this.keystoreLoc;
    }

    public boolean isServerAlive() {
        boolean bl = false;
        SSLSocket sSLSocket = null;
        if (this.factory == null) {
            this.initSocketFactory();
        }
        for (int i = 0; i < 20; ++i) {
            try {
                Thread.sleep(1000L);
                System.out.println("Testing Connection:" + this.host + ":" + this.port);
                sSLSocket = (SSLSocket)this.factory.createSocket(this.host, this.port);
                sSLSocket.setEnabledCipherSuites(this.factory.getDefaultCipherSuites());
                if (!sSLSocket.isBound()) continue;
                System.out.println("connect isBound");
                bl = true;
                sSLSocket.close();
                break;
            }
            catch (ConnectException connectException) {
                continue;
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                continue;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return bl;
    }

    public void testCiphersuites() {
        SSLSocket sSLSocket = null;
        int n = 0;
        if (this.factory == null) {
            this.initSocketFactory();
        }
        if (!this.isServerAlive()) {
            System.out.println("Unable to connect to " + this.host + ":" + this.port + " exiting.");
            System.exit(1);
        }
        Iterator iterator = this.ciphersToTest.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String[] stringArray = new String[]{string};
            try {
                sSLSocket = (SSLSocket)this.factory.createSocket(this.host, this.port);
                sSLSocket.setEnabledCipherSuites(stringArray);
                this.testSSLSocket(sSLSocket, string, n++);
            }
            catch (Exception exception) {
                System.out.println("failed ciphersuite" + stringArray[0]);
                this.f_ciphers.add(stringArray[0]);
            }
        }
    }

    public void configureCipherSuites(String string, String string2) {
        boolean bl = true;
        if (this.factory == null) {
            this.initSocketFactory();
        }
        String[] stringArray = this.factory.getSupportedCipherSuites();
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            bl = true;
            if (this.bVerbose) {
                System.out.print(string3);
            }
            if (string.equalsIgnoreCase("JSS") && (string3.indexOf("_DHE_") != -1 || string3.indexOf("_DES40_") != -1 || string3.indexOf("TLS_EMPTY_RENEGOTIATION_INFO_SCSV") != -1 || string3.indexOf("SHA256") != -1 || string3.indexOf("_anon_") != -1 || string3.indexOf("_KRB5_") != -1)) {
                if (this.bVerbose) {
                    System.out.print(" -");
                }
                bl = false;
            }
            if (string.equalsIgnoreCase("JSSE")) {
                // empty if block
            }
            if (!bl) continue;
            this.ciphersToTest.add(stringArray[i]);
            if (!this.bVerbose) continue;
            System.out.print(" - Testing");
        }
        if (this.bVerbose) {
            System.out.print("\n");
        }
        if (this.bVerbose) {
            System.out.println("\nTesting " + this.ciphersToTest.size() + " ciphersuites.");
        }
    }

    private void initSocketFactory() {
        SSLContext sSLContext = null;
        KeyManagerFactory keyManagerFactory = null;
        Object var3_3 = null;
        KeyStore keyStore = null;
        Object var5_5 = null;
        String string = "SunJCE";
        char[] cArray = "m1oZilla".toCharArray();
        try {
            String string2 = System.getProperty("java.vendor");
            if (string2.equals("IBM Corporation")) {
                System.setProperty("java.protocol.handler.pkgs", "com.ibm.net.ssl.www.protocol.Handler");
                Security.addProvider((Provider)Class.forName("com.ibm.jsse2.IBMJSSEProvider2").newInstance());
                string = "IBMJCE";
            } else {
                System.setProperty("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");
                Security.addProvider((Provider)Class.forName("com.sun.crypto.provider.SunJCE").newInstance());
            }
            String string3 = new String("SunX509");
            keyStore = KeyStore.getInstance("PKCS12");
            if (string2.equals("IBM Corporation")) {
                string3 = new String("IbmX509");
                keyStore = KeyStore.getInstance("PKCS12", string);
            }
            keyManagerFactory = KeyManagerFactory.getInstance(string3);
            keyStore.load(new FileInputStream(this.getKeystoreLoc()), cArray);
            keyManagerFactory.init(keyStore, cArray);
            TrustManager[] trustManagerArray = new TrustManager[]{new X509TrustManager(){

                public boolean checkClientTrusted(X509Certificate[] x509CertificateArray) {
                    return true;
                }

                public boolean isServerTrusted(X509Certificate[] x509CertificateArray) {
                    return true;
                }

                public boolean isClientTrusted(X509Certificate[] x509CertificateArray) {
                    return true;
                }

                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
                }

                public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
                }
            }};
            sSLContext = SSLContext.getInstance(this.sslRevision);
            sSLContext.init(keyManagerFactory.getKeyManagers(), trustManagerArray, null);
            this.factory = sSLContext.getSocketFactory();
            String[] stringArray = this.factory.getSupportedCipherSuites();
        }
        catch (KeyStoreException keyStoreException) {
            keyStoreException.printStackTrace();
        }
        catch (NoSuchProviderException noSuchProviderException) {
            noSuchProviderException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void sendServerShutdownMsg() {
        try {
            SSLSocket sSLSocket = null;
            if (this.factory == null) {
                this.initSocketFactory();
            }
            sSLSocket = (SSLSocket)this.factory.createSocket(this.host, this.port);
            sSLSocket.setEnabledCipherSuites(this.factory.getDefaultCipherSuites());
            if (this.bVerbose) {
                System.out.println("Sending shutdown message to server.");
            }
            sSLSocket.startHandshake();
            OutputStream outputStream = sSLSocket.getOutputStream();
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter(outputStream)));
            printWriter.println("shutdown");
            printWriter.flush();
            printWriter.close();
            sSLSocket.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void testSSLSocket(SSLSocket sSLSocket, String string, int n) {
        try {
            sSLSocket.addHandshakeCompletedListener(new HandshakeCompletedListener(){

                public void handshakeCompleted(HandshakeCompletedEvent handshakeCompletedEvent) {
                    JSSE_SSLClient.this.h_ciphers.add(handshakeCompletedEvent.getCipherSuite());
                    System.out.println(handshakeCompletedEvent.getCipherSuite());
                }
            });
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            exception.printStackTrace();
            System.exit(1);
        }
        try {
            sSLSocket.setSoTimeout(10000);
            sSLSocket.startHandshake();
            String string2 = null;
            String string3 = null;
            InputStream inputStream = sSLSocket.getInputStream();
            OutputStream outputStream = sSLSocket.getOutputStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter(outputStream)));
            string2 = string + ":" + n + "\n";
            if (this.bVerbose) {
                System.out.println("Sending: " + string2);
            }
            printWriter.print(string2);
            printWriter.flush();
            string3 = bufferedReader.readLine();
            if (this.bVerbose) {
                System.out.println("Received: " + string3 + " on Client-" + n);
            }
            bufferedReader.close();
            printWriter.close();
        }
        catch (SSLHandshakeException sSLHandshakeException) {
            this.f_ciphers.add(string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(1);
        }
        try {
            sSLSocket.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void outputCipherResults() {
        Iterator iterator;
        String string = new String("\n----------------------------------------------------------\n");
        System.out.println(string);
        System.out.println("JSSE has " + this.factory.getSupportedCipherSuites().length + " ciphersuites and " + this.ciphersToTest.size() + " were configured and tested.");
        if (this.ciphersToTest.size() == this.h_ciphers.size()) {
            System.out.println("All " + this.ciphersToTest.size() + " configured ciphersuites tested Successfully!\n");
        }
        if (!this.h_ciphers.isEmpty()) {
            if (!this.f_ciphers.isEmpty()) {
                System.out.println(string);
                System.out.println(this.h_ciphers.size() + " ciphersuites successfully connected to the " + "server\n");
            }
            iterator = this.h_ciphers.iterator();
            while (iterator.hasNext()) {
                System.out.println((String)iterator.next());
            }
        }
        if (this.bFipsMode) {
            System.out.println("Note: ciphersuites that have the prefix \"SSL\" or \"SSL3\" were used in TLS mode.");
        }
        if (this.ciphersToTest.size() != this.h_ciphers.size() + this.f_ciphers.size()) {
            System.out.println("ERROR: did not test all expected ciphersuites");
        }
        if (!this.f_ciphers.isEmpty()) {
            System.out.println(string);
            System.out.println(this.f_ciphers.size() + " ciphersuites that did not connect to the " + "server\n\n");
            iterator = this.f_ciphers.iterator();
            while (iterator.hasNext()) {
                System.out.println((String)iterator.next());
            }
            System.out.println("we should have no failed ciphersuites!");
            System.exit(1);
        }
        System.out.println(string);
    }

    public static void main(String[] stringArray) {
        String string = null;
        String string2 = "localhost";
        String string3 = "rsa.pfx";
        int n = 29750;
        String string4 = "JSSE";
        String string5 = "java org.mozilla.jss.tests.JSSE_SSLClient\n<keystore location> <test port> <test host> <server type> <test cipher>";
        try {
            if (stringArray[0].toLowerCase().equals("-h") || stringArray.length < 1) {
                System.out.println(string5);
                System.exit(1);
            }
            if (stringArray.length >= 1) {
                string3 = stringArray[0];
            }
            if (stringArray.length >= 2) {
                n = new Integer(stringArray[1]);
                System.out.println("using port: " + n);
            }
            if (stringArray.length >= 3) {
                string2 = stringArray[2];
            }
            if (stringArray.length == 4) {
                string4 = stringArray[3];
            }
            if (stringArray.length == 5) {
                string = stringArray[4];
            }
        }
        catch (Exception exception) {
            System.out.println(string5);
            System.exit(1);
        }
        JSSE_SSLClient jSSE_SSLClient = new JSSE_SSLClient();
        jSSE_SSLClient.setHost(string2);
        jSSE_SSLClient.setPort(n);
        jSSE_SSLClient.setKeystoreLoc(string3);
        jSSE_SSLClient.setCipherSuite(string);
        jSSE_SSLClient.configureCipherSuites(string4, string);
        try {
            jSSE_SSLClient.testCiphersuites();
        }
        catch (Exception exception) {
            System.out.println("Exception caught testing ciphersuites\n" + exception.getMessage());
            exception.printStackTrace();
            System.exit(1);
        }
        jSSE_SSLClient.sendServerShutdownMsg();
        jSSE_SSLClient.outputCipherResults();
        System.exit(0);
    }
}

