/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.util;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import org.mozilla.jss.util.Assert;

public abstract class NativeProxy {
    private byte[] mPointer;
    private long registryIndex;
    static Hashtable registry = new Hashtable();
    static Random indexGenerator = new Random();

    private NativeProxy() {
        Assert._assert(false);
    }

    public NativeProxy(byte[] byArray) {
        Assert._assert(byArray != null);
        this.mPointer = byArray;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof NativeProxy)) {
            return false;
        }
        if (((NativeProxy)object).mPointer.length != this.mPointer.length) {
            return false;
        }
        for (int i = 0; i < this.mPointer.length; ++i) {
            if (this.mPointer[i] == ((NativeProxy)object).mPointer[i]) continue;
            return false;
        }
        return true;
    }

    protected abstract void releaseNativeResources();

    protected void finalize() throws Throwable {
        this.releaseNativeResources();
    }

    private static synchronized long register() {
        Long l;
        while (registry.containsKey(l = new Long(indexGenerator.nextLong()))) {
        }
        registry.put(l, l);
        return l;
    }

    private static synchronized void unregister(long l) {
        Long l2 = new Long(l);
        Long l3 = (Long)registry.remove(l2);
        Assert._assert(l3 != null);
    }

    public static synchronized Enumeration getRegistryIndices() {
        return registry.keys();
    }

    public long getRegistryIndex() {
        return this.registryIndex;
    }

    public static synchronized void assertRegistryEmpty() {
    }
}

