/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util.options;

import com.sun.messaging.jmq.util.options.BadNameValueArgException;
import com.sun.messaging.jmq.util.options.InvalidBasePropNameException;
import com.sun.messaging.jmq.util.options.InvalidHardCodedValueException;
import com.sun.messaging.jmq.util.options.MissingArgException;
import com.sun.messaging.jmq.util.options.OptionDesc;
import com.sun.messaging.jmq.util.options.OptionException;
import com.sun.messaging.jmq.util.options.OptionType;
import com.sun.messaging.jmq.util.options.UnrecognizedOptionException;
import java.util.Properties;

public class OptionParser
implements OptionType {
    public static void parseArgs(String[] args, OptionDesc[] optDesc, Properties prop) throws OptionException {
        if (args == null || optDesc == null || prop == null) {
            return;
        }
        int argsCount = args.length;
        for (int i = 0; i < argsCount; ++i) {
            String curOption = args[i];
            int match = OptionParser.findMatchingOption(optDesc, curOption);
            if (match < 0) {
                UnrecognizedOptionException uoe = new UnrecognizedOptionException();
                uoe.setOption(curOption);
                throw uoe;
            }
            OptionDesc matchOpt = optDesc[match];
            boolean ignore = matchOpt.ignore;
            String optBaseProp = matchOpt.baseProperty;
            String optValue = matchOpt.value;
            String optNameValuePair = matchOpt.nameValuePair;
            String propName = null;
            String propVal = null;
            String name = null;
            String nvPair = null;
            switch (matchOpt.type) {
                case 1: {
                    InvalidBasePropNameException ibpe;
                    propName = optBaseProp;
                    propVal = optValue;
                    if (propName == null) {
                        ibpe = new InvalidBasePropNameException();
                        ibpe.setOption(curOption);
                        throw ibpe;
                    }
                    if (propVal != null) break;
                    InvalidHardCodedValueException ihcve = new InvalidHardCodedValueException();
                    ihcve.setOption(curOption);
                    throw ihcve;
                }
                case 2: {
                    MissingArgException mae;
                    if (i + 1 >= argsCount) {
                        mae = new MissingArgException();
                        mae.setOption(curOption);
                        throw mae;
                    }
                    propName = optBaseProp;
                    propVal = args[++i];
                    if (propName != null) break;
                    InvalidBasePropNameException ibpe = new InvalidBasePropNameException();
                    ibpe.setOption(curOption);
                    throw ibpe;
                }
                case 3: {
                    BadNameValueArgException bnvae;
                    MissingArgException mae;
                    if (i + 1 >= argsCount) {
                        mae = new MissingArgException();
                        mae.setOption(curOption);
                        throw mae;
                    }
                    nvPair = args[++i];
                    name = OptionParser.getName(nvPair);
                    propVal = OptionParser.getValue(nvPair);
                    if (name == null || propVal == null) {
                        bnvae = new BadNameValueArgException();
                        bnvae.setOption(curOption);
                        bnvae.setArg(nvPair);
                        throw bnvae;
                    }
                    if (optBaseProp != null) {
                        propName = optBaseProp + "." + name;
                        break;
                    }
                    propName = name;
                    break;
                }
                case 4: {
                    BadNameValueArgException bnvae;
                    MissingArgException mae;
                    try {
                        nvPair = curOption.substring(matchOpt.option.length());
                    }
                    catch (IndexOutOfBoundsException ibe) {
                        MissingArgException mae2 = new MissingArgException();
                        mae2.setOption(matchOpt.option);
                        throw mae2;
                    }
                    if (nvPair.equals("")) {
                        mae = new MissingArgException();
                        mae.setOption(matchOpt.option);
                        throw mae;
                    }
                    name = OptionParser.getName(nvPair);
                    propVal = OptionParser.getValue(nvPair);
                    if (name == null || propVal == null) {
                        bnvae = new BadNameValueArgException();
                        bnvae.setOption(matchOpt.option);
                        bnvae.setArg(nvPair);
                        throw bnvae;
                    }
                    propName = optBaseProp != null ? optBaseProp + "." + name : name;
                }
            }
            if (propName != null && propVal != null && !ignore) {
                prop.put(propName, propVal);
            }
            if (optNameValuePair == null) continue;
            String name2 = OptionParser.getName(optNameValuePair);
            String value = OptionParser.getValue(optNameValuePair);
            if (name2 == null && value == null) continue;
            prop.put(name2, value);
        }
    }

    private static String getName(String nameValuePair) {
        if (nameValuePair == null) {
            return null;
        }
        int index = nameValuePair.indexOf("=");
        if (index > 0) {
            if (index == 0) {
                return "";
            }
            return nameValuePair.substring(0, index);
        }
        return null;
    }

    private static String getValue(String nameValuePair) {
        if (nameValuePair == null) {
            return null;
        }
        int index = nameValuePair.indexOf("=");
        if (index > 0) {
            if (nameValuePair.length() == 1) {
                return "";
            }
            return nameValuePair.substring(index + 1);
        }
        return null;
    }

    private static int findMatchingOption(OptionDesc[] optDesc, String arg) {
        int matchIndex = -1;
        for (int i = 0; i < optDesc.length; ++i) {
            int type = optDesc[i].type;
            String option = optDesc[i].option;
            if (arg.equals(option)) {
                return i;
            }
            if (type != 4 || !arg.startsWith(option)) continue;
            return i;
        }
        return matchIndex;
    }
}

