#!/bin/bash
#
# Copyright 2009 Sun Microsystems, Inc.  All Rights Reserved
# Patents Pending.  Use is subject to license terms.
#

# Parameters: VERSION NSPR_VERSION NSS_VERSION JSS_VERSION
VERSION=$1
NSPR_VERSION=$2
NSS_VERSION=$3
JSS_VERSION=$4
NSPR_TAG=$5
NSS_TAG=$6
JSS_TAG=$7

# Where are the builds
UNIX_BUILDM=wozzeck_Solaris8
WIN_BUILDM=nss-w2kp_WIN64
BASE_BUILD=$(dirname $0)/../../../..
ABS_BASE_BUILD=$(cd $BASE_BUILD && pwd)
UNIX_BUILD=${ABS_BASE_BUILD}/${UNIX_BUILDM}/mozilla/dist
WIN_BUILD=${ABS_BASE_BUILD}/${WIN_BUILDM}/mozilla/dist
CURRENT_BASE_BUILD=$(dirname $0)/../../..
CURRENT_ABS_BASE_BUILD=$(cd $CURRENT_BASE_BUILD && pwd)
SRC_BUILD=${CURRENT_ABS_BASE_BUILD}/mozilla/dist/src

# Platforms
UNIX_PLAT="SunOS_sparc SunOS_x86 Linux Darwin"
WIN_PLAT="Windows"

# CVS information for the source code
export CVSROOT=":pserver;proxy=www-proxy.us.oracle.com;proxyport=80:anonymous@cvs-mirror.mozilla.org:/cvsroot"
CVS=/share/builds/mccrel3/security/tools/solaris_sparc/cvs
FIND=/usr/bin/find
ZIP=/usr/bin/zip
TAR=/usr/bin/tar
GZIP=/usr/bin/gzip

for plat in $UNIX_PLAT
do
	echo "========== Building packages for $plat"
	gmake TARGET_OS=$plat SOURCE_BASE=$UNIX_BUILD VERSION=$VERSION \
	NSPR_VERSION=$NSPR_VERSION NSS_VERSION=$NSS_VERSION JSS_VERSION=$JSS_VERSION buildpkg
        if [ $? != 0 ]; then
          echo "ERROR:   Failed to build IPS package for $plat"
          exit 1
        fi 
	echo "========== End of $plat"
done

for plat in $WIN_PLAT
do
	echo "========== Building packages for $plat"
	gmake TARGET_OS=$plat SOURCE_BASE=$WIN_BUILD VERSION=$VERSION \
	NSPR_VERSION=$NSPR_VERSION NSS_VERSION=$NSS_VERSION JSS_VERSION=$JSS_VERSION buildpkg
        if [ $? != 0 ]; then
          echo "ERROR:   Failed to build IPS package for $plat"
          exit 1
        fi 
	echo "========== End of $plat"
done

echo "========== Getting source code"
if [ -d $SRC_BUILD ] ;
then
	rm -rf $SRC_BUILD
fi
mkdir $SRC_BUILD
# Get the source code from Mozilla
(cd $SRC_BUILD && \
$CVS -d $CVSROOT co -r $NSS_TAG mozilla/security/nss \
mozilla/security/coreconf mozilla/security/dbm mozilla/dbm)
if [ $? != 0 ]; then
  echo "ERROR:   Failed to checkout NSS source code from tag $NSS_TAG"
  exit 1
fi 
(cd $SRC_BUILD && \
$CVS -d $CVSROOT co -r NSS_3_11_1_RTM mozilla/security/nss/lib/freebl/ecl/ecl-curve.h)
if [ $? != 0 ]; then
  echo "ERROR:   Failed to checkout ECC header from tag NSS_3_11_1_RTM"
  exit 1
fi 
(cd $SRC_BUILD && \
$CVS -d $CVSROOT co -r $NSPR_TAG mozilla/nsprpub)
if [ $? != 0 ]; then
  echo "ERROR:   Failed to checkout NSPR source code from tag $NSPR_TAG"
  exit 1
fi 
(cd $SRC_BUILD && \
$CVS -d $CVSROOT co -r $JSS_TAG mozilla/security/jss)
if [ $? != 0 ]; then
  echo "ERROR:   Failed to checkout JSS source code from tag $JSS_TAG"
  exit 1
fi 

# Remove the CVS files
(cd $SRC_BUILD && \
$FIND mozilla -depth -type d -name CVS -exec rm -rf {} \;)
(cd $SRC_BUILD && \
$FIND mozilla -name .cvsignore -exec rm {} \;)

# Create the archive
(cd $SRC_BUILD && \
$ZIP -9 -r nss_nspr_jss_src.zip mozilla)
if [ $? != 0 ]; then
  echo "ERROR:   Failed to create the zip archive.  Error $?"
  exit 1
fi 
if [ -d $SRC_BUILD/mozilla ] ;
then
	rm -rf $SRC_BUILD/mozilla
fi
echo "========== End of getting source code"
echo ""
echo "========== Building source code package"
gmake TARGET_OS=common SOURCE_BASE=$SRC_BUILD VERSION=$VERSION \
NSPR_VERSION=$NSPR_VERSION NSS_VERSION=$NSS_VERSION JSS_VERSION=$JSS_VERSION \
buildsrcpkg
if [ $? != 0 ]; then
  echo "ERROR:   Failed to build source code package.  Error $?"
  exit 1
fi 
echo "========== End of source code package"

