#!/bin/bash

SCRIPT_DIR=$(dirname $0)
ABS_SCRIPT_DIR=$(cd $SCRIPT_DIR && pwd)

# Set PATH
. ${ABS_SCRIPT_DIR}/setenv.sh

# run NSS IPS packages installation test
TEST_DIR=$1
REPO_URL=$2

if [ -z "$TEST_DIR" ] || [ -z "$REPO_URL" ] ;
then
	echo "usage:   $0 TEST_DIR REPO_URL"
	echo "example: $0 /local/ips_test http://kyril.red.iplanet.com:10001"
	exit 1
fi

PKG_LIST="nss-libs nss-utils nss-dev nss-nspr-jss-src"

test_error () {
errno=$1
errmsg=$2

	if [ ! $errno == 0 ] ;
	then
		echo "Test failed: $errmsg (error $errno)"
		exit 1
	fi
}

run_pkg () {
	echo "Running pkg $1"
	if [ "${PLATFORM}" == "Windows" ] ;
	then
		cmd /c "pkg.bat $1"
		return $?
	else
		pkg $1
		return $?
	fi
} # function run_pkg

echo "Running IPS package installation test on $(uname -n) ======="
if [ ! -d ${TEST_DIR} ] ;
then
	mkdir -p ${TEST_DIR}
	test_error $? "mkdir -p ${TEST_DIR}"
fi

IMAGE_DIR=$TEST_DIR/ips_image

# Verify that we have pkg in the PATH
echo "Verifying the pkg-toolkit ==========="
if [ "${PLATFORM}" == "Windows" ] ;
then
	which pkg.bat
	test_error $? "which pkg.bat"
else
	which pkg
	test_error $? "which pkg"
fi

# Install NSS
echo "Installing NSS =============="
# start with an empty IMAGE_DIR
if [ -d ${IMAGE_DIR} ] ;
then
	rm -rf ${IMAGE_DIR}
	test_error $? "rm -rf ${IMAGE_DIR}"
fi
mkdir $IMAGE_DIR
test_error $? "mkdir $IMAGE_DIR"

if [ "${PLATFORM}" == "Windows" ] ;
then
	# make IMAGE_DIR a DOS dir
	LOCAL_IMAGE_DIR=$(echo $IMAGE_DIR | sed -e "s|^/\(.\)/|\1:/|")
else
	LOCAL_IMAGE_DIR=$IMAGE_DIR
fi

cd $IMAGE_DIR
run_pkg "image-create -U -a repo=$REPO_URL $LOCAL_IMAGE_DIR"
test_error $? "pkg image-create -U -a repo=$REPO_URL $LOCAL_IMAGE_DIR"
run_pkg "list -a"

run_pkg "install $PKG_LIST"
test_error $? "pkg install $PKG_LIST"

echo "List of files installed ==============="
find nss
test_error $? "find nss"
echo "------------------------"
# we may want to check the files here...
# Visual check for the time being.

# If we've gone so far: pass
echo "IPS package installation test on $(uname -n): PASSED"
echo "===================================================================="
