#!/bin/bash

# Platform
PLATFORM=$(uname -s)
if [ $PLATFORM = SunOS ] ;
then
	ARCH=$(uname -p)
	if [ $ARCH = i386 ] ;
	then
		ARCH="x86"
	fi
	PLATFORM="${PLATFORM}_${ARCH}"
fi
case $PLATFORM in
	MINGW*|WINNT*) PLATFORM="Windows" ;;
esac

if [ -z "${TOOLS_HOME}" ] ;
then
#	TOOLS_HOME=/net/koori/z/lore/chravel/tools
	TOOLS_HOME=/share/builds/mccrel3/security/tools
	if [ ! -d $TOOLS_HOME ] ;
	then
	    TOOLS_HOME=/net/jesbuild.us.oracle.com/export/mccrel3/security/tools
	fi
fi

echo "PLATFORM=$PLATFORM"
case $PLATFORM in
	SunOS_sparc)
		OS_PATH=/usr/bin:/usr/openwin/bin:/usr/ccs/bin:/usr/dist/exe:/tools/ns/bin
		OS_PKG_TOOL=sunos-sparc
		;;
	SunOS_x86)
		OS_PATH=/usr/bin:/usr/openwin/bin:/usr/ccs/bin:/tools/ns/bin:/tools/ns/bin
		OS_PKG_TOOL=sunos-i386
		;;
	Linux)
		OS_PATH=/bin:/usr/bin
		OS_PKG_TOOL=linux-i386
		;;
	Darwin)
		OS_PATH=/usr/bin:/bin:/usr/sbin:/sbin:/usr/local/bin:/usr/X11/bin
		OS_PKG_TOOL=darwin-universal
		;;
	Windows)
		OS_PATH=$PATH
		OS_PKG_TOOL=windows-i386
		TOOLS_HOME="/E/tools/"
		;;
esac

PKG_HOME=${TOOLS_HOME}/updatecenter21/2.1.0RR/pkg-toolkit-${OS_PKG_TOOL}
export PKG_HOME

export PATH=$PKG_HOME/pkg/bin:$OS_PATH
