/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.io;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;

public class PortMapperEntry {
    private int port = 0;
    private String protocol = null;
    private String type = null;
    private String name = null;
    private HashMap properties = null;
    public static final String NEWLINE = "\n";
    public static final String SPACE = " ";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProperty(String name, String value) {
        Object object = this;
        synchronized (object) {
            if (this.properties == null) {
                this.properties = new HashMap();
            }
        }
        object = this.properties;
        synchronized (object) {
            this.properties.put(name, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProperties(HashMap props) {
        Object object = this;
        synchronized (object) {
            if (this.properties == null) {
                this.properties = new HashMap();
            }
        }
        object = this.properties;
        synchronized (object) {
            this.properties.putAll(props);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getProperty(String name) {
        Object object = this;
        synchronized (object) {
            if (this.properties == null) {
                return null;
            }
        }
        object = this.properties;
        synchronized (object) {
            return (String)this.properties.get(name);
        }
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append(this.name + SPACE + this.protocol + SPACE + this.type + SPACE + this.port);
        if (this.properties != null) {
            strbuf.append(" [");
            HashMap hashMap = this.properties;
            synchronized (hashMap) {
                Set keyset = this.properties.keySet();
                Iterator itr = keyset.iterator();
                while (itr.hasNext()) {
                    String key = (String)itr.next();
                    String value = (String)this.properties.get(key);
                    strbuf.append(key + "=" + value);
                    if (!itr.hasNext()) continue;
                    strbuf.append(",");
                }
            }
            strbuf.append("]");
        }
        return strbuf.toString();
    }

    public static PortMapperEntry parse(String s) throws IllegalArgumentException {
        PortMapperEntry pme = new PortMapperEntry();
        StringTokenizer st = new StringTokenizer(s);
        pme.name = st.nextToken();
        pme.protocol = st.nextToken();
        pme.type = st.nextToken();
        pme.port = Integer.parseInt(st.nextToken());
        int propIndx = s.indexOf("[");
        if (propIndx != -1) {
            int endPropIndx = s.indexOf("]");
            String sub = s.substring(propIndx + 1, endPropIndx);
            StringTokenizer sst = new StringTokenizer(sub, ",");
            while (sst.hasMoreTokens()) {
                String pair = sst.nextToken();
                int indx = pair.indexOf("=");
                if (indx == -1) continue;
                String name = pair.substring(0, indx);
                String value = pair.substring(indx + 1);
                pme.addProperty(name, value);
            }
        }
        return pme;
    }
}

