/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.io.disk;

import com.sun.messaging.jmq.io.disk.ObjectInputStreamCallback;
import com.sun.messaging.jmq.io.disk.PHashMapLoadException;
import com.sun.messaging.jmq.io.disk.VRFile;
import com.sun.messaging.jmq.io.disk.VRFileRAF;
import com.sun.messaging.jmq.io.disk.VRFileWarning;
import com.sun.messaging.jmq.io.disk.VRecord;
import com.sun.messaging.jmq.io.disk.VRecordRAF;
import com.sun.messaging.jmq.resources.SharedResources;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class PHashMap
extends ConcurrentHashMap {
    private static boolean DEBUG = false;
    public static final int VERSION = 1;
    public static final int DEFAULT_INITIAL_MAP_CAPACITY = 128;
    protected VRFile backingFile;
    protected ConcurrentHashMap recordMap;
    protected boolean safe = false;
    protected static final long cookie = String.valueOf("PHashMap:1").hashCode();
    private VRFileWarning warning = null;
    protected boolean loaded = false;
    private Set entrySet = null;
    private Set keySet = null;
    private Collection values = null;

    public PHashMap(File filename, boolean safe, boolean reset, boolean isMinimumWrites, boolean interruptSafe) throws IOException {
        this(filename, 0xA00000L, 128, safe, reset, isMinimumWrites, interruptSafe);
    }

    public PHashMap(File filename, long size, boolean safe, boolean reset, boolean isMinimumWrites, boolean interruptSafe) throws IOException {
        this(filename, size, 128, safe, reset, isMinimumWrites, interruptSafe);
    }

    public PHashMap(File filename, long size, int mapCapacity, boolean safe, boolean reset, boolean isMinimumWrites, boolean interruptSafe) throws IOException {
        super(mapCapacity);
        if (DEBUG) {
            System.out.println("PHashMap cookie: " + cookie);
        }
        this.safe = safe;
        this.initBackingFile(filename, size, isMinimumWrites, interruptSafe);
        this.backingFile.setCookie(cookie);
        this.backingFile.setSafe(safe);
        if (reset) {
            this.backingFile.clear(false);
        }
        try {
            this.backingFile.open();
        }
        catch (VRFileWarning w) {
            this.warning = w;
        }
    }

    protected void initBackingFile(File filename, long size, boolean isMinimumWrites, boolean interruptSafe) {
        this.backingFile = new VRFileRAF(filename, size, isMinimumWrites, interruptSafe);
    }

    public void load(ObjectInputStreamCallback ocb) throws IOException, ClassNotFoundException, PHashMapLoadException {
        int mSize;
        PHashMapLoadException loadException = null;
        Set entries = this.backingFile.getRecords();
        int eSize = entries.size();
        this.recordMap = eSize > (mSize = this.size()) ? new ConcurrentHashMap(eSize) : new ConcurrentHashMap(mSize);
        for (VRecordRAF record : entries) {
            Object key = null;
            Object value = null;
            Throwable kex = null;
            Throwable vex = null;
            IOException ex = null;
            try {
                byte[] buf = new byte[record.getDataCapacity()];
                record.read(buf);
                ByteArrayInputStream bais = new ByteArrayInputStream(buf);
                ObjectInputStream ois = ocb.getObjectInputStream(bais);
                try {
                    key = ois.readObject();
                }
                catch (Throwable e) {
                    if (e instanceof ClassNotFoundException) {
                        throw (ClassNotFoundException)e;
                    }
                    kex = e;
                }
                try {
                    value = ois.readObject();
                }
                catch (Throwable e) {
                    if (e instanceof ClassNotFoundException) {
                        throw (ClassNotFoundException)e;
                    }
                    vex = e;
                }
                ois.close();
                bais.close();
            }
            catch (IOException e) {
                ex = e;
            }
            if (kex != null || vex != null || ex != null) {
                PHashMapLoadException le = new PHashMapLoadException("Failed to load data in [" + record.toString() + "]");
                le.setKey(key);
                le.setValue(value);
                le.setKeyCause(kex);
                le.setValueCause(vex);
                le.setNextException(loadException);
                le.initCause(ex);
                loadException = le;
                if (key != null && value != null) {
                    this.recordMap.put(key, record);
                    super.put(key, value);
                    continue;
                }
                this.backingFile.free(record);
                continue;
            }
            this.recordMap.put(key, record);
            super.put(key, value);
        }
        this.loaded = true;
        if (loadException != null) {
            throw loadException;
        }
    }

    public void force() throws IOException {
        this.force(null);
    }

    public void force(Object key) throws IOException {
        this.checkLoaded();
        if (key != null) {
            VRecord record = (VRecord)this.recordMap.get(key);
            if (record != null) {
                record.force();
            }
        } else {
            this.backingFile.force();
        }
    }

    @Override
    public Object put(Object key, Object value) {
        return this.doPut(key, value, false);
    }

    @Override
    public Object putIfAbsent(Object key, Object value) {
        return this.doPut(key, value, true);
    }

    public final Object put(Object key, Object value, boolean putIfAbsent) {
        return this.doPut(key, value, putIfAbsent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object doPut(Object key, Object value, boolean putIfAbsent) {
        this.checkLoaded();
        boolean error = false;
        Object oldValue = null;
        try {
            if (putIfAbsent) {
                oldValue = super.putIfAbsent(key, value);
                if (oldValue != null) {
                    Object object = oldValue;
                    return object;
                }
            } else {
                oldValue = super.put(key, value);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            ObjectOutputStream bos = new ObjectOutputStream(baos);
            bos.writeObject(key);
            bos.writeObject(value);
            bos.close();
            byte[] data = baos.toByteArray();
            VRecordRAF record = (VRecordRAF)this.recordMap.get(key);
            VRFile vRFile = this.backingFile;
            synchronized (vRFile) {
                if (record == null) {
                    record = (VRecordRAF)this.backingFile.allocate(data.length);
                } else if (record.getDataCapacity() < data.length) {
                    this.backingFile.free(record);
                    record = (VRecordRAF)this.backingFile.allocate(data.length);
                } else {
                    record.rewind();
                }
                record.write(data);
                if (this.safe) {
                    record.force();
                }
            }
            this.recordMap.put(key, record);
        }
        catch (IOException e) {
            error = true;
            throw new RuntimeException(e);
        }
        finally {
            if (error) {
                if (oldValue == null) {
                    super.remove(key);
                } else {
                    super.put(key, oldValue);
                }
            }
        }
        return oldValue;
    }

    @Override
    public Object remove(Object key) {
        this.checkLoaded();
        try {
            Object old = super.remove(key);
            this.removeFromFile(key);
            return old;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean remove(Object key, Object value) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    public Object replace(Object key, Object value) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    public boolean replace(Object key, Object oldValue, Object newValue) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    @Override
    public void clear() {
        this.checkLoaded();
        try {
            super.clear();
            this.recordMap.clear();
            this.backingFile.clear(false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        this.backingFile.close();
    }

    @Override
    public Set entrySet() {
        this.checkLoaded();
        Set set = this.entrySet;
        if (set == null) {
            set = this.entrySet = new HashSet(super.entrySet());
        }
        return set;
    }

    @Override
    public Set keySet() {
        this.checkLoaded();
        Set set = this.keySet;
        if (set == null) {
            set = this.keySet = new HashSet(super.keySet());
        }
        return set;
    }

    public VRFileWarning getWarning() {
        return this.warning;
    }

    @Override
    public Collection values() {
        this.checkLoaded();
        Collection c = this.values;
        if (c == null) {
            c = this.values = new ValueCollection(super.entrySet());
        }
        return c;
    }

    protected final void checkLoaded() {
        if (!this.loaded) {
            throw new IllegalStateException(SharedResources.getResources().getString("S3010"));
        }
    }

    final Object putInHashMap(Object key, Object value, boolean putIfAbsent) {
        if (putIfAbsent) {
            return super.putIfAbsent(key, value);
        }
        return super.put(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromFile(Object key) throws IOException {
        VRecord record;
        if (DEBUG) {
            System.out.println("PHashMap.removeFromFile() called for " + key);
        }
        if ((record = (VRecord)this.recordMap.remove(key)) != null) {
            VRFile vRFile = this.backingFile;
            synchronized (vRFile) {
                this.backingFile.free(record);
                if (this.safe) {
                    this.backingFile.force();
                }
            }
        }
    }

    private class HashIterator
    implements Iterator {
        boolean values = false;
        Iterator iterator = null;
        Object current = null;

        HashIterator(Iterator itor) {
            this.iterator = itor;
        }

        HashIterator(Iterator itor, boolean values) {
            this.iterator = itor;
            this.values = values;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            this.current = this.iterator.next();
            if (this.values) {
                return ((Map.Entry)this.current).getValue();
            }
            return this.current;
        }

        @Override
        public void remove() {
            this.iterator.remove();
            Object key = null;
            key = this.current instanceof Map.Entry ? ((Map.Entry)this.current).getKey() : this.current;
            try {
                PHashMap.this.removeFromFile(key);
            }
            catch (IOException t) {
                throw new RuntimeException(t);
            }
        }
    }

    private class ValueCollection
    extends AbstractCollection {
        Set entries = null;

        ValueCollection(Set e) {
            this.entries = e;
        }

        @Override
        public int size() {
            return this.entries.size();
        }

        @Override
        public boolean contains(Object o) {
            return PHashMap.this.containsValue(o);
        }

        @Override
        public void clear() {
            PHashMap.this.clear();
        }

        @Override
        public Iterator iterator() {
            return new HashIterator(this.entries.iterator(), true);
        }
    }

    private class HashSet
    extends AbstractSet {
        Set set = null;

        HashSet(Set set) {
            this.set = set;
        }

        @Override
        public int size() {
            return this.set.size();
        }

        @Override
        public boolean contains(Object o) {
            return this.set.contains(o);
        }

        @Override
        public boolean remove(Object o) {
            boolean b = this.set.remove(o);
            if (b) {
                Object key = null;
                key = o instanceof Map.Entry ? ((Map.Entry)o).getKey() : o;
                try {
                    PHashMap.this.removeFromFile(key);
                }
                catch (IOException t) {
                    throw new RuntimeException(t);
                }
            }
            return b;
        }

        @Override
        public void clear() {
            PHashMap.this.clear();
        }

        @Override
        public Iterator iterator() {
            return new HashIterator(this.set.iterator());
        }
    }
}

