/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.io.disk;

import com.sun.messaging.jmq.io.disk.ObjectInputStreamCallback;
import com.sun.messaging.jmq.io.disk.PHashMap;
import com.sun.messaging.jmq.io.disk.PHashMapLoadException;
import com.sun.messaging.jmq.io.disk.VRFile;
import com.sun.messaging.jmq.io.disk.VRFileMap;
import com.sun.messaging.jmq.io.disk.VRecordMap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.nio.InvalidMarkException;
import java.nio.MappedByteBuffer;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class PHashMapMMF
extends PHashMap {
    static final byte[] CLIENT_DATA_MARKER = new byte[]{37, 67, 68};
    static final byte[] EMPTY_CLIENT_DATA_MARKER = new byte[]{0, 0, 0};
    int maxClientDataSize = 0;

    public PHashMapMMF(File filename, boolean safe, boolean reset, boolean isMinimumWrites, boolean interruptSafe) throws IOException {
        this(filename, 0xA00000L, 128, safe, reset, isMinimumWrites, interruptSafe);
    }

    public PHashMapMMF(File filename, long size, boolean safe, boolean reset, boolean isMinimumWrites, boolean interruptSafe) throws IOException {
        super(filename, size, 128, safe, reset, isMinimumWrites, interruptSafe);
    }

    public PHashMapMMF(File filename, long size, int mapCapacity, boolean safe, boolean reset, boolean isMinimumWrites, boolean interruptSafe) throws IOException {
        super(filename, size, mapCapacity, safe, reset, isMinimumWrites, interruptSafe);
    }

    @Override
    protected void initBackingFile(File filename, long size, boolean isMinimumWrites, boolean interruptSafe) {
        this.backingFile = new VRFileMap(filename, size, isMinimumWrites, interruptSafe);
    }

    public void intClientData(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Invalid client data size");
        }
        this.maxClientDataSize = size;
    }

    @Override
    public void load(ObjectInputStreamCallback ocb) throws IOException, ClassNotFoundException, PHashMapLoadException {
        int mSize;
        PHashMapLoadException loadException = null;
        Set entries = this.backingFile.getRecords();
        int eSize = entries.size();
        this.recordMap = eSize > (mSize = this.size()) ? new ConcurrentHashMap(eSize) : new ConcurrentHashMap(mSize);
        for (VRecordMap record : entries) {
            Object key = null;
            Object value = null;
            Throwable kex = null;
            Throwable vex = null;
            IOException ex = null;
            try {
                ByteBuffer buffer = record.getBuffer();
                buffer.position(0);
                int limit = buffer.limit();
                byte[] data = new byte[limit];
                buffer.get(data);
                ByteArrayInputStream bais = new ByteArrayInputStream(data);
                ObjectInputStream ois = ocb.getObjectInputStream(bais);
                try {
                    key = ois.readObject();
                }
                catch (Throwable e) {
                    if (e instanceof ClassNotFoundException) {
                        throw (ClassNotFoundException)e;
                    }
                    kex = e;
                }
                try {
                    value = ois.readObject();
                }
                catch (Throwable e) {
                    if (e instanceof ClassNotFoundException) {
                        throw (ClassNotFoundException)e;
                    }
                    vex = e;
                }
                if (this.maxClientDataSize > 0) {
                    int pos = limit - bais.available();
                    buffer.position(pos);
                    buffer.mark();
                }
                ois.close();
                bais.close();
            }
            catch (IOException e) {
                ex = e;
            }
            if (kex != null || vex != null || ex != null) {
                PHashMapLoadException le = new PHashMapLoadException("Failed to load data in [" + record.toString() + "]");
                le.setKey(key);
                le.setValue(value);
                le.setKeyCause(kex);
                le.setValueCause(vex);
                le.setNextException(loadException);
                le.initCause(ex);
                loadException = le;
                if (key != null && value != null) {
                    this.recordMap.put(key, record);
                    this.putInHashMap(key, value, false);
                    continue;
                }
                this.backingFile.free(record);
                continue;
            }
            this.recordMap.put(key, record);
            this.putInHashMap(key, value, false);
        }
        this.loaded = true;
        if (loadException != null) {
            throw loadException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Object doPut(Object key, Object value, boolean putIfAbsent) {
        this.checkLoaded();
        boolean error = false;
        Object oldValue = null;
        try {
            oldValue = this.putInHashMap(key, value, putIfAbsent);
            if (putIfAbsent && oldValue != null) {
                Object object = oldValue;
                return object;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            ObjectOutputStream bos = new ObjectOutputStream(baos);
            bos.writeObject(key);
            bos.writeObject(value);
            bos.close();
            byte[] data = baos.toByteArray();
            int dataLength = data.length;
            if (this.maxClientDataSize > 0) {
                dataLength += this.maxClientDataSize + CLIENT_DATA_MARKER.length;
            }
            VRecordMap record = (VRecordMap)this.recordMap.get(key);
            VRFile vRFile = this.backingFile;
            synchronized (vRFile) {
                if (record == null) {
                    record = (VRecordMap)this.backingFile.allocate(dataLength);
                } else if (record.getDataCapacity() < dataLength) {
                    this.backingFile.free(record);
                    record = (VRecordMap)this.backingFile.allocate(dataLength);
                }
                MappedByteBuffer buffer = (MappedByteBuffer)record.getBuffer();
                buffer.rewind();
                buffer.put(data);
                if (this.maxClientDataSize > 0) {
                    buffer.mark();
                    buffer.put(EMPTY_CLIENT_DATA_MARKER);
                    buffer.reset();
                }
                if (this.safe) {
                    record.force();
                }
            }
            this.recordMap.put(key, record);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (error) {
                if (oldValue == null) {
                    super.remove(key);
                } else {
                    this.putInHashMap(key, oldValue, false);
                }
            }
        }
        return oldValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void putClientData(Object key, byte[] cData) {
        this.checkLoaded();
        if (this.maxClientDataSize <= 0) {
            throw new IllegalStateException("Client data size has not been initialized");
        }
        if (cData.length > this.maxClientDataSize) {
            throw new IllegalArgumentException("Client data size of " + cData.length + " bytes is larger than the byte limit (maxClientDataSize) of " + this.maxClientDataSize + " [key=" + key + ", cData=" + Arrays.toString(cData) + "]");
        }
        VRecordMap record = (VRecordMap)this.recordMap.get(key);
        if (record == null) {
            throw new IllegalStateException("Record not found [key=" + key + ", cData=" + Arrays.toString(cData) + "]");
        }
        try {
            VRFile vRFile = this.backingFile;
            synchronized (vRFile) {
                MappedByteBuffer buffer = (MappedByteBuffer)record.getBuffer();
                try {
                    buffer.reset();
                }
                catch (InvalidMarkException e) {
                    this.setClientDataMarker(buffer);
                }
                buffer.put(CLIENT_DATA_MARKER);
                buffer.put(cData);
                if (this.safe) {
                    record.force();
                }
            }
            this.recordMap.put(key, record);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to update client data [key=" + key + ", cData=" + Arrays.toString(cData) + "]", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final byte[] getClientData(Object key) {
        byte[] cData;
        block8: {
            cData = null;
            try {
                VRecordMap record;
                if (this.maxClientDataSize <= 0 || (record = (VRecordMap)this.recordMap.get(key)) == null) break block8;
                VRFile vRFile = this.backingFile;
                synchronized (vRFile) {
                    ByteBuffer buffer = record.getBuffer();
                    try {
                        buffer.reset();
                    }
                    catch (InvalidMarkException e) {
                        this.setClientDataMarker(buffer);
                    }
                    byte b1 = buffer.get();
                    byte b2 = buffer.get();
                    byte b3 = buffer.get();
                    if (b1 == CLIENT_DATA_MARKER[0] && b2 == CLIENT_DATA_MARKER[1] && b3 == CLIENT_DATA_MARKER[2]) {
                        cData = new byte[this.maxClientDataSize];
                        buffer.get(cData);
                    }
                }
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        return cData;
    }

    private void setClientDataMarker(ByteBuffer buffer) {
        int limit = buffer.limit();
        for (int i = 0; i < limit; ++i) {
            if (buffer.get(i) != CLIENT_DATA_MARKER[0] || i + 2 >= limit || buffer.get(i + 1) != CLIENT_DATA_MARKER[1] || buffer.get(i + 2) != CLIENT_DATA_MARKER[2]) continue;
            buffer.position(i);
            buffer.mark();
            return;
        }
        Object key = null;
        Object value = null;
        Throwable kex = null;
        Throwable vex = null;
        IOException ex = null;
        try {
            buffer.position(0);
            int limit2 = buffer.limit();
            byte[] data = new byte[limit2];
            buffer.get(data);
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            ObjectInputStream ois = new ObjectInputStream(bais);
            try {
                key = ois.readObject();
            }
            catch (Throwable e) {
                kex = e;
            }
            try {
                value = ois.readObject();
            }
            catch (Throwable e) {
                vex = e;
            }
            if (this.maxClientDataSize > 0) {
                int pos = limit2 - bais.available();
                buffer.position(pos);
                buffer.mark();
            }
            ois.close();
            bais.close();
        }
        catch (IOException e) {
            ex = e;
        }
        if (kex != null || vex != null || ex != null) {
            PHashMapLoadException le = new PHashMapLoadException("Failed to set client data marker");
            le.setKey(key);
            le.setValue(value);
            le.setKeyCause(kex);
            le.setValueCause(vex);
            le.initCause(ex);
            throw new RuntimeException(le);
        }
    }
}

