/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.core;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.websocket.Extension;
import org.glassfish.tyrus.core.HandshakeException;
import org.glassfish.tyrus.core.SecKey;
import org.glassfish.tyrus.core.TyrusEndpointWrapper;
import org.glassfish.tyrus.core.TyrusExtension;
import org.glassfish.tyrus.core.Utils;
import org.glassfish.tyrus.core.extension.ExtendedExtension;
import org.glassfish.tyrus.core.l10n.LocalizationMessages;
import org.glassfish.tyrus.spi.UpgradeRequest;
import org.glassfish.tyrus.spi.UpgradeResponse;

public final class Handshake {
    private static final int RESPONSE_CODE_VALUE = 101;
    private static final String VERSION = "13";
    private boolean secure;
    private String origin;
    private String serverHostName;
    private int port = 80;
    private String resourcePath;
    private List<String> subProtocols = new ArrayList<String>();
    private List<Extension> extensions = new ArrayList<Extension>();
    private UpgradeRequest request;
    private UpgradeRequest incomingRequest;
    private ExtendedExtension.ExtensionContext extensionContext;
    private SecKey secKey;

    private Handshake() {
    }

    public static Handshake createClientHandshake(UpgradeRequest webSocketRequest) {
        Handshake handshake = new Handshake();
        handshake.request = webSocketRequest;
        URI uri = webSocketRequest.getRequestURI();
        handshake.resourcePath = uri.getPath();
        if ("".equals(handshake.resourcePath)) {
            handshake.resourcePath = "/";
        }
        if (uri.getQuery() != null) {
            handshake.resourcePath = handshake.resourcePath + "?" + uri.getQuery();
        }
        handshake.serverHostName = uri.getHost();
        handshake.secure = webSocketRequest.isSecure();
        handshake.port = uri.getPort();
        handshake.origin = Handshake.appendPort(new StringBuilder(uri.getHost()), handshake.port, handshake.secure).toString();
        handshake.secKey = new SecKey();
        return handshake;
    }

    static Handshake createServerHandshake(UpgradeRequest request, ExtendedExtension.ExtensionContext extensionContext) {
        List<String> value;
        String protocolHeader;
        Handshake handshake = new Handshake();
        handshake.incomingRequest = request;
        handshake.extensionContext = extensionContext;
        Handshake.checkForHeader(request.getHeader("Upgrade"), "Upgrade", "WebSocket");
        Handshake.checkForHeader(request.getHeader("Connection"), "Connection", "Upgrade");
        handshake.origin = request.getHeader("Sec-WebSocket-Origin");
        if (handshake.origin == null) {
            handshake.origin = request.getHeader("Origin");
        }
        List<Object> list = handshake.subProtocols = (protocolHeader = request.getHeader("Sec-WebSocket-Protocol")) == null ? Collections.emptyList() : Arrays.asList(protocolHeader.split(","));
        if (request.getHeader("Host") == null) {
            throw new HandshakeException(LocalizationMessages.HEADERS_MISSING());
        }
        handshake.resourcePath = request.getRequestUri();
        String queryString = request.getQueryString();
        if (queryString != null && !queryString.isEmpty()) {
            handshake.resourcePath = handshake.resourcePath + "?" + queryString;
        }
        if ((value = request.getHeaders().get("Sec-WebSocket-Extensions")) != null) {
            handshake.extensions = TyrusExtension.fromHeaders(value);
        }
        handshake.secKey = SecKey.generateServerKey(new SecKey(request.getHeader("Sec-WebSocket-Key")));
        return handshake;
    }

    private static void checkForHeader(String currentValue, String header, String validValue) {
        Handshake.validate(header, validValue, currentValue);
    }

    private static void validate(String header, String validValue, String value) {
        if (header.equalsIgnoreCase("Connection") ? !value.toLowerCase().contains(validValue.toLowerCase()) : !value.equalsIgnoreCase(validValue)) {
            throw new HandshakeException(LocalizationMessages.INVALID_HEADER(header, value));
        }
    }

    private static StringBuilder appendPort(StringBuilder builder, int port, boolean secure) {
        if (secure) {
            if (port != 443 && port != -1) {
                builder.append(':').append(port);
            }
        } else if (port != 80 && port != -1) {
            builder.append(':').append(port);
        }
        return builder;
    }

    String getOrigin() {
        return this.origin;
    }

    List<String> getSubProtocols() {
        return this.subProtocols;
    }

    List<Extension> getExtensions() {
        return this.extensions;
    }

    public UpgradeRequest getRequest() {
        return this.request;
    }

    public void setSubProtocols(List<String> subProtocols) {
        this.subProtocols = subProtocols;
    }

    public void setExtensions(List<Extension> extensions) {
        this.extensions = extensions;
    }

    public UpgradeRequest prepareRequest() {
        String host = this.serverHostName;
        if (this.port != -1 && this.port != 80 && this.port != 443) {
            host = host + ":" + this.port;
        }
        this.putSingleHeader(this.request, "Host", host);
        this.putSingleHeader(this.request, "Connection", "Upgrade");
        this.putSingleHeader(this.request, "Upgrade", "websocket");
        this.putSingleHeader(this.request, "Sec-WebSocket-Key", this.secKey.toString());
        this.putSingleHeader(this.request, "Sec-WebSocket-Origin", this.getOrigin());
        this.putSingleHeader(this.request, "Sec-WebSocket-Version", VERSION);
        if (!this.getSubProtocols().isEmpty()) {
            this.putSingleHeader(this.request, "Sec-WebSocket-Protocol", Utils.getHeaderFromList(this.subProtocols, null));
        }
        if (!this.getExtensions().isEmpty()) {
            this.putSingleHeader(this.request, "Sec-WebSocket-Extensions", Utils.getHeaderFromList(this.getExtensions(), new Utils.Stringifier<Extension>(){

                @Override
                String toString(Extension extension) {
                    return TyrusExtension.toString(extension);
                }
            }));
        }
        String headerValue = this.request.getHeader("Sec-WebSocket-Origin");
        this.request.getHeaders().remove("Sec-WebSocket-Origin");
        this.putSingleHeader(this.request, "Origin", headerValue);
        return this.request;
    }

    private void putSingleHeader(UpgradeRequest request, String headerName, String headerValue) {
        request.getHeaders().put(headerName, Arrays.asList(headerValue));
    }

    public void validateServerResponse(UpgradeResponse response) {
        if (101 != response.getStatus()) {
            throw new HandshakeException(LocalizationMessages.INVALID_RESPONSE_CODE(101, response.getStatus()));
        }
        Handshake.checkForHeader(response.getFirstHeaderValue("Upgrade"), "Upgrade", "websocket");
        Handshake.checkForHeader(response.getFirstHeaderValue("Connection"), "Connection", "Upgrade");
        this.secKey.validateServerKey(response.getFirstHeaderValue("Sec-WebSocket-Accept"));
    }

    List<Extension> respond(UpgradeRequest request, UpgradeResponse response, TyrusEndpointWrapper endpointWrapper) {
        List<Extension> negotiatedExtensions;
        String protocol;
        response.setStatus(101);
        response.getHeaders().put("Upgrade", Arrays.asList("websocket"));
        response.getHeaders().put("Connection", Arrays.asList("Upgrade"));
        response.setReasonPhrase("Switching Protocols");
        response.getHeaders().put("Sec-WebSocket-Accept", Arrays.asList(this.secKey.getSecKey()));
        List<String> protocols = request.getHeaders().get("Sec-WebSocket-Protocol");
        List<Extension> extensions = TyrusExtension.fromString(request.getHeaders().get("Sec-WebSocket-Extensions"));
        if (this.subProtocols != null && !this.subProtocols.isEmpty() && (protocol = endpointWrapper.getNegotiatedProtocol(protocols)) != null && !protocol.isEmpty()) {
            response.getHeaders().put("Sec-WebSocket-Protocol", Arrays.asList(protocol));
        }
        if (!(negotiatedExtensions = endpointWrapper.getNegotiatedExtensions(extensions)).isEmpty()) {
            response.getHeaders().put("Sec-WebSocket-Extensions", Utils.getStringList(negotiatedExtensions, new Utils.Stringifier<Extension>(){

                @Override
                String toString(final Extension extension) {
                    if (extension instanceof ExtendedExtension) {
                        return TyrusExtension.toString(new Extension(){

                            @Override
                            public String getName() {
                                return extension.getName();
                            }

                            @Override
                            public List<Extension.Parameter> getParameters() {
                                return ((ExtendedExtension)extension).onExtensionNegotiation(Handshake.this.extensionContext, null);
                            }
                        });
                    }
                    return TyrusExtension.toString(extension);
                }
            }));
        }
        endpointWrapper.onHandShakeResponse(this.incomingRequest, response);
        return negotiatedExtensions;
    }
}

