/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.admin;

import com.sun.messaging.ConnectionFactory;
import com.sun.messaging.XAConnectionFactory;
import com.sun.messaging.bridge.api.BridgeBaseContext;
import com.sun.messaging.bridge.api.BridgeContext;
import com.sun.messaging.bridge.api.BridgeUtil;
import com.sun.messaging.bridge.api.JMSBridgeStore;
import java.io.File;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

public class BridgeContextImpl
implements BridgeContext {
    private BridgeBaseContext _bc;
    private String _name = null;
    private Properties _config = null;

    public BridgeContextImpl(BridgeBaseContext bc, String name) {
        this._bc = bc;
        this._name = name;
        this._config = new Properties();
        Properties props = this._bc.getBridgeConfig();
        String prefix = props.getProperty("PROP_PREFIX") + "." + this._name;
        List<String> keys = BridgeUtil.getPropertyNames(prefix, props);
        String key2 = null;
        for (String key2 : keys) {
            this._config.put(key2, props.getProperty(key2));
        }
        this._config.put(prefix + ".varhome", props.getProperty(props.getProperty("PROP_PREFIX") + ".varhome") + File.separator + this._name);
        this._config.put(prefix + ".libhome", props.getProperty(props.getProperty("PROP_PREFIX") + ".libhome"));
        this._config.put("BRIDGE_PROP_PREFIX", prefix);
    }

    @Override
    public boolean isEmbeded() {
        return this._bc.isEmbeded();
    }

    @Override
    public boolean doBind() {
        return this._bc.doBind();
    }

    @Override
    public boolean isEmbededBroker() {
        return this._bc.isEmbededBroker();
    }

    @Override
    public boolean isRunningOnNucleus() {
        return this._bc.isRunningOnNucleus();
    }

    @Override
    public boolean isSilentMode() {
        return this._bc.isSilentMode();
    }

    @Override
    public Object getPUService() {
        return this._bc.getPUService();
    }

    @Override
    public Properties getConfig() {
        return this._config;
    }

    @Override
    public String getRootDir() {
        return this._config.getProperty(this._config.getProperty("BRIDGE_PROP_PREFIX") + ".varhome");
    }

    @Override
    public String getLibDir() {
        return this._config.getProperty(this._config.getProperty("BRIDGE_PROP_PREFIX") + ".libhome");
    }

    @Override
    public String getProperty(String suffix) {
        return this._config.getProperty(this._config.getProperty("BRIDGE_PROP_PREFIX") + "." + suffix);
    }

    @Override
    public javax.jms.ConnectionFactory getConnectionFactory(Properties props) throws Exception {
        ConnectionFactory cf = new ConnectionFactory();
        if (props != null) {
            String name = null;
            Enumeration<?> en = props.propertyNames();
            while (en.hasMoreElements()) {
                name = (String)en.nextElement();
                if (name.equals("imqAddressList")) continue;
                cf.setProperty(name, props.getProperty(name));
            }
        }
        cf.setProperty("imqAddressList", this._bc.getBrokerServiceAddress("tcp", "NORMAL"));
        return cf;
    }

    @Override
    public javax.jms.XAConnectionFactory getXAConnectionFactory(Properties props) throws Exception {
        XAConnectionFactory cf = new XAConnectionFactory();
        if (props != null) {
            String name = null;
            Enumeration<?> en = props.propertyNames();
            while (en.hasMoreElements()) {
                name = (String)en.nextElement();
                if (name.equals("imqAddressList")) continue;
                cf.setProperty(name, props.getProperty(name));
            }
        }
        cf.setProperty("imqAddressList", this._bc.getBrokerServiceAddress("tcp", "NORMAL"));
        return cf;
    }

    @Override
    public javax.jms.ConnectionFactory getAdminConnectionFactory(Properties props) throws Exception {
        ConnectionFactory cf = new ConnectionFactory();
        if (props != null) {
            String name = null;
            Enumeration<?> en = props.propertyNames();
            while (en.hasMoreElements()) {
                name = (String)en.nextElement();
                if (name.equals("imqAddressList")) continue;
                cf.setProperty(name, props.getProperty(name));
            }
        }
        cf.setProperty("imqAddressList", this._bc.getBrokerServiceAddress("tcp", "NORMAL"));
        Properties bprops = this._bc.getBridgeConfig();
        String keyu = bprops.getProperty("PROP_PREFIX") + ".admin.user";
        String keyp = bprops.getProperty("PROP_PREFIX") + ".admin.password";
        String user = bprops.getProperty(keyu);
        String passwd = bprops.getProperty(keyp);
        cf.setProperty("imqDefaultUsername", user);
        cf.setProperty("imqDefaultPassword", passwd);
        return cf;
    }

    @Override
    public boolean handleGlobalError(Throwable ex, String reason) {
        return this._bc.handleGlobalError(ex, reason);
    }

    @Override
    public void registerService(String protocol, String type, int port, HashMap props) {
        this._bc.registerService(this._name, protocol, type, port, props);
    }

    @Override
    public Properties getDefaultSSLContextConfig() throws Exception {
        return this._bc.getDefaultSSLContextConfig(this._name);
    }

    @Override
    public String getIdentityName() throws Exception {
        return this._bc.getIdentityName();
    }

    @Override
    public String getBrokerHostName() {
        return this._bc.getBrokerHostName();
    }

    @Override
    public String getTransactionManagerClass() throws Exception {
        String key;
        Properties props = this._bc.getBridgeConfig();
        String value = props.getProperty(key = props.getProperty("PROP_PREFIX") + "." + this._name + ".tm.class");
        if (value != null) {
            return value;
        }
        key = "PROP_PREFIX.tm.class";
        return props.getProperty(key);
    }

    @Override
    public Properties getTransactionManagerProps() throws Exception {
        List<String> l;
        Properties tmp = new Properties();
        Properties props = this._bc.getBridgeConfig();
        String key = "PROP_PREFIX.tm.props";
        List<String> plist0 = BridgeUtil.getListProperty(key, props);
        key = props.getProperty("PROP_PREFIX") + "." + this._name + ".tm.props";
        List<String> plist1 = BridgeUtil.getListProperty(key, props);
        if (plist0 == null && plist1 == null) {
            return tmp;
        }
        if (plist0 != null) {
            for (String value : plist0) {
                l = BridgeUtil.breakToList(value, "=");
                if (l.size() != 2) {
                    throw new IllegalArgumentException("Invalid element for broker property " + key);
                }
                tmp.setProperty(l.get(0), l.get(1));
            }
        }
        if (plist1 != null) {
            for (String value : plist1) {
                l = BridgeUtil.breakToList(value, "=");
                if (l.size() != 2) {
                    throw new IllegalArgumentException("Invalid element for broker property " + key);
                }
                tmp.setProperty(l.get(0), l.get(1));
            }
        }
        return tmp;
    }

    @Override
    public boolean isJDBCStoreType() throws Exception {
        return this._bc.isJDBCStoreType();
    }

    @Override
    public Object getJDBCStore(String type) throws Exception {
        if (type.toUpperCase(Locale.getDefault()).equals("JMS")) {
            return (JMSBridgeStore)this._bc.getJDBCStore();
        }
        return null;
    }

    @Override
    public boolean allocateMemCheck(long size) {
        return this._bc.allocateMemCheck(size);
    }

    @Override
    public void logError(String message, Throwable t) {
        this._bc.logError(message, t);
    }

    @Override
    public void logWarn(String message, Throwable t) {
        this._bc.logWarn(message, t);
    }

    @Override
    public void logInfo(String message, Throwable t) {
        this._bc.logInfo(message, t);
    }

    @Override
    public void logDebug(String message, Throwable t) {
        this._bc.logDebug(message, t);
    }
}

