/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.PacketType;
import com.sun.messaging.jmq.jmsserver.FaultInjection;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.auth.AccessController;
import com.sun.messaging.jmq.jmsserver.data.DefaultHandler;
import com.sun.messaging.jmq.jmsserver.data.ErrHandler;
import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQService;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.ServiceRestrictionException;
import com.sun.messaging.jmq.jmsserver.util.ServiceRestrictionWaitException;
import com.sun.messaging.jmq.util.log.Logger;
import java.security.AccessControlException;

public class PacketRouter {
    private static boolean DEBUG = false;
    private final Logger logger = Globals.getLogger();
    private PacketHandler[] list = new PacketHandler[80];
    private ErrHandler defaultHandler = new DefaultHandler();
    private FaultInjection fi = FaultInjection.getInjection();

    public static boolean getDEBUG() {
        return DEBUG;
    }

    public void addHandler(int id, PacketHandler handler) throws ArrayIndexOutOfBoundsException {
        if (id > 80) {
            throw new ArrayIndexOutOfBoundsException(Globals.getBrokerResources().getString("B4117", "Trying to add handler which has no corresponding packet type [ " + id + "]"));
        }
        this.list[id] = handler;
    }

    public void addHandler(int sid, int eid, PacketHandler handler) throws ArrayIndexOutOfBoundsException {
        for (int i = sid; i < eid; ++i) {
            this.addHandler(i, handler);
        }
    }

    public PacketHandler getHandler(int id) throws ArrayIndexOutOfBoundsException {
        if (id > 80) {
            throw new ArrayIndexOutOfBoundsException(id);
        }
        return this.list[id];
    }

    public void handleMessage(IMQConnection con, Packet msg) {
        int id = msg.getPacketType();
        if (id < 0) {
            this.logger.log(32, Globals.getBrokerResources().getString("B4117", "invalid packet type {0}", String.valueOf(id)));
            this.defaultHandler.sendError(con, msg, "invalid packet type " + id, 500);
            return;
        }
        PacketHandler handler = null;
        handler = id >= 80 ? this.defaultHandler : this.list[id];
        if (handler == null) {
            handler = this.defaultHandler;
        }
        try {
            boolean freepkt;
            if (handler != this.defaultHandler) {
                this.checkServiceRestriction(msg, con, handler, id, this.defaultHandler);
                if (!this.checkAccessControl(msg, con, handler, id)) {
                    return;
                }
            }
            if (this.fi.FAULT_INJECTION && ((IMQService)con.getService()).getServiceType() != 1 && this.fi.checkFaultAndSleep("pkt.router.1.sleep", null, true)) {
                this.fi.unsetFault("pkt.router.1.sleep");
            }
            if (freepkt = handler.handle(con, msg)) {
                msg.destroy();
            }
        }
        catch (ServiceRestrictionException ex) {
            this.defaultHandler.sendError(con, msg, ex.getMessage(), 503);
        }
        catch (ServiceRestrictionWaitException ex) {
            msg.destroy();
            return;
        }
        catch (BrokerException ex) {
            assert (this.defaultHandler != null);
            if (this.defaultHandler != null) {
                if (ex.getStatusCode() == 503) {
                    this.defaultHandler.sendError(con, msg, ex.getMessage(), 503);
                } else {
                    this.defaultHandler.sendError(con, ex, msg);
                }
            }
        }
        catch (Exception ex) {
            this.logger.logStack(32, ex.getMessage(), ex);
            this.defaultHandler.sendError(con, new BrokerException(Globals.getBrokerResources().getKString("B4117", "Unexpected Error processing message"), ex), msg);
        }
    }

    private boolean checkAccessControl(Packet msg, IMQConnection con, PacketHandler handler, int pktype) {
        AccessController ac = con.getAccessController();
        if (pktype != 10 && pktype != 54 && pktype != 12 && pktype != 28) {
            if (!ac.isAuthenticated()) {
                String emsg = Globals.getBrokerResources().getKString("B3059", PacketType.getString(pktype));
                this.defaultHandler.sendError(con, msg, emsg, 500);
                return false;
            }
            try {
                handler.checkPermission(msg, con);
                return true;
            }
            catch (AccessControlException e) {
                try {
                    handler.handleForbidden(con, msg, pktype + 1);
                }
                catch (BrokerException ex) {
                    this.defaultHandler.sendError(con, ex, msg);
                }
                catch (Exception ex) {
                    this.defaultHandler.sendError(con, new BrokerException(Globals.getBrokerResources().getKString("B4117", "Unexpected Error processing message"), ex), msg);
                }
            }
            catch (BrokerException ex) {
                this.defaultHandler.sendError(con, msg, ex.getMessage(), ex.getStatusCode());
            }
            catch (Exception ex) {
                this.defaultHandler.sendError(con, new BrokerException(Globals.getBrokerResources().getKString("B4117", "Unexpected Error processing message"), ex), msg);
            }
            return false;
        }
        return true;
    }

    private void checkServiceRestriction(Packet msg, IMQConnection con, PacketHandler handler, int pktype, ErrHandler defHandler) throws BrokerException, Exception {
        if (pktype != 10 && pktype != 54 && pktype != 12 && pktype != 28) {
            handler.checkServiceRestriction(msg, con, defHandler);
        }
    }
}

