/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.bdb;

import com.sleepycat.je.DatabaseNotFoundException;
import com.sleepycat.je.Transaction;
import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.persist.bdb.BDBStore;
import com.sun.messaging.jmq.jmsserver.persist.bdb.DestinationStore;
import com.sun.messaging.jmq.jmsserver.persist.bdb.DstMsgStore;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.DestinationNotFoundException;
import com.sun.messaging.jmq.util.log.Logger;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.concurrent.ConcurrentHashMap;

class MsgStore {
    private Logger logger = Globals.getLogger();
    private BrokerResources br = Globals.getBrokerResources();
    private ConcurrentHashMap dstMap = new ConcurrentHashMap(32);
    private BDBStore parent = null;
    private DestinationStore dstStore = null;

    protected MsgStore(BDBStore p, DestinationStore dstStore) {
        this.parent = p;
        this.dstStore = dstStore;
    }

    protected Hashtable getDebugState() {
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        ht.put("dstMapSize", String.valueOf(this.dstMap.size()));
        for (DstMsgStore dmstore : this.dstMap.values()) {
            ht.put(dmstore.getMyDestinationUID().toString(), dmstore.getDebugState());
        }
        return ht;
    }

    protected void storeMessage(Transaction txn, DestinationUID duid, Packet message, ConsumerUID[] sids, int[] states) throws BrokerException {
        DstMsgStore dmstore = this.getDstMsgStore(txn, duid, true, true);
        dmstore.storeMessage(txn, message, sids, states);
    }

    protected Packet getMessage(Transaction txn, DestinationUID duid, SysMessageID mid) throws BrokerException {
        return this.getOpenDstMsgStore(duid).getMessage(txn, mid);
    }

    protected HashMap getMessageStorageInfo(Transaction txn, DestinationUID duid) throws BrokerException {
        DstMsgStore dmstore = this.getDstMsgStore(txn, duid, false, true);
        return DstMsgStore.getMessageStorageInfo(txn, dmstore);
    }

    protected void removeMessage(Transaction txn, DestinationUID duid, SysMessageID mid) throws BrokerException {
        this.getOpenDstMsgStore(duid).removeMessage(txn, mid);
    }

    protected void moveMessage(Transaction txn, Packet message, DestinationUID from, DestinationUID to, ConsumerUID[] sids, int[] states) throws BrokerException {
        SysMessageID mid = message.getSysMessageID();
        DstMsgStore fromdst = this.getOpenDstMsgStore(from);
        if (fromdst == null || !fromdst.containsMessage(txn, mid)) {
            String emsg = this.br.getKString("B3007", mid, from);
            this.logger.log(32, emsg);
            throw new BrokerException(emsg);
        }
        this.storeMessage(txn, to, message, sids, states);
        this.removeMessage(txn, from, message.getSysMessageID());
    }

    protected boolean hasMessageBeenAcked(Transaction txn, DestinationUID duid, SysMessageID mid) throws BrokerException {
        return this.getOpenDstMsgStore(duid).hasMessageBeenAcked(txn, mid);
    }

    protected void compactDestination(Transaction txn, Destination destination) throws BrokerException {
    }

    protected void removeDestination(Transaction txn, DestinationUID duid) throws BrokerException {
        DstMsgStore dmstore = this.getDstMsgStore(txn, duid, false, true);
        this.dstMap.remove(duid);
        DstMsgStore.removeDestination(txn, duid, dmstore, this.parent);
    }

    protected Enumeration messageEnumeration(Transaction txn, Destination dst) throws BrokerException {
        DstMsgStore dmstore = this.getDstMsgStore(txn, dst.getDestinationUID(), false, true);
        return DstMsgStore.messageEnumeration(dmstore, this.parent);
    }

    protected void storeInterestStates(Transaction txn, DestinationUID duid, SysMessageID mid, ConsumerUID[] sids, int[] states) throws BrokerException {
        this.getOpenDstMsgStore(duid).storeInterestStates(txn, mid, sids, states);
    }

    protected void updateInterestState(Transaction txn, DestinationUID duid, SysMessageID mid, ConsumerUID sid, int state) throws BrokerException {
        this.getOpenDstMsgStore(duid).updateInterestState(txn, mid, sid, state);
    }

    protected int getInterestState(Transaction txn, DestinationUID duid, SysMessageID mid, ConsumerUID sid) throws BrokerException {
        return this.getOpenDstMsgStore(duid).getInterestState(txn, mid, sid);
    }

    protected HashMap getInterestStates(Transaction txn, DestinationUID duid, SysMessageID mid) throws BrokerException {
        return this.getOpenDstMsgStore(duid).getInterestStates(txn, mid);
    }

    protected ConsumerUID[] getUnAckedConsumerUIDs(Transaction txn, DestinationUID duid, SysMessageID mid) throws BrokerException {
        return this.getOpenDstMsgStore(duid).getUnAckedConsumerUIDs(txn, mid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close() {
        try {
            DstMsgStore dmstore2 = null;
            for (DstMsgStore dmstore2 : this.dstMap.values()) {
                dmstore2.close();
            }
        }
        finally {
            this.dstMap.clear();
        }
    }

    private DstMsgStore getOpenDstMsgStore(DestinationUID dst) throws BrokerException {
        DstMsgStore dmstore = (DstMsgStore)this.dstMap.get(dst);
        if (dmstore == null) {
            String emsg = this.br.getKString("B3013", dst);
            this.logger.log(32, emsg);
            throw new DestinationNotFoundException(emsg);
        }
        return dmstore;
    }

    private DstMsgStore getDstMsgStore(Transaction txn, DestinationUID duid, boolean create, boolean openIfExist) throws BrokerException {
        this.dstStore.checkDestinationExist(txn, duid);
        DstMsgStore dmstore = (DstMsgStore)this.dstMap.get(duid);
        if (dmstore == null && (create || openIfExist)) {
            try {
                dmstore = new DstMsgStore(txn, duid, create, this.parent);
            }
            catch (DatabaseNotFoundException e) {
                return null;
            }
            DstMsgStore odmstore = this.dstMap.putIfAbsent(duid, dmstore);
            if (odmstore != null && odmstore != dmstore) {
                dmstore.close();
                dmstore = odmstore;
            }
        }
        return dmstore;
    }
}

