/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.coherence;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.persist.coherence.DstMsgStore;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

class MessageInfo
implements Externalizable {
    static final long serialVersionUID = -4702000974307086257L;
    private transient Logger logger = Globals.getLogger();
    private transient BrokerResources br = Globals.getBrokerResources();
    private Packet msg;
    private SysMessageID mid;
    private transient int packetSize = 0;
    private DstMsgStore parent = null;
    private HashMap iidMap = null;
    private int[] statearray = null;

    public MessageInfo() {
    }

    MessageInfo(DstMsgStore p, Packet msg, ConsumerUID[] iids, int[] states) throws BrokerException {
        this.parent = p;
        this.msg = msg;
        this.mid = (SysMessageID)msg.getSysMessageID().clone();
        this.packetSize = msg.getPacketSize();
        this.iidMap = new HashMap();
        this.statearray = new int[iids.length];
        this.storeStates(iids, states);
    }

    Packet getMessage() throws IOException {
        return this.msg;
    }

    int getSize() {
        return this.packetSize;
    }

    SysMessageID getID() {
        return this.mid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void storeStates(ConsumerUID[] iids, int[] states) throws BrokerException {
        MessageInfo messageInfo = this;
        synchronized (messageInfo) {
            if (this.iidMap.size() == 0) {
                int size = iids.length;
                this.iidMap = new HashMap(size);
                this.statearray = new int[size];
                for (int i = 0; i < size; ++i) {
                    this.iidMap.put(iids[i], i);
                    this.statearray[i] = states[i];
                }
                return;
            }
        }
        this.logger.log(16, "B3084", this.mid.toString());
        throw new BrokerException(this.br.getString("B3084", this.mid.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateState(ConsumerUID iid, int state) throws IOException, BrokerException {
        Integer indexObj = null;
        MessageInfo messageInfo = this;
        synchronized (messageInfo) {
            if (this.iidMap != null && (indexObj = (Integer)this.iidMap.get(iid)) != null) {
                int index = indexObj;
                if (this.statearray[index] != state) {
                    this.statearray[index] = state;
                }
                return;
            }
        }
        this.logger.log(32, "B3014", (Object)iid.toString(), this.mid.toString());
        throw new BrokerException(this.br.getString("B3014", iid.toString(), this.mid.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getInterestState(ConsumerUID iid) throws BrokerException {
        Integer indexobj = null;
        MessageInfo messageInfo = this;
        synchronized (messageInfo) {
            if (this.iidMap != null && (indexobj = (Integer)this.iidMap.get(iid)) != null) {
                return this.statearray[indexobj];
            }
        }
        this.logger.log(32, "B3014", (Object)iid.toString(), this.mid.toString());
        throw new BrokerException(this.br.getString("B3014", iid.toString(), this.mid.toString()));
    }

    synchronized HashMap getInterestStates() {
        HashMap states = new HashMap();
        if (this.iidMap != null) {
            Set entries = this.iidMap.entrySet();
            for (Map.Entry entry : entries) {
                int index = (Integer)entry.getValue();
                states.put(entry.getKey(), this.statearray[index]);
            }
        }
        return states;
    }

    synchronized ConsumerUID[] getConsumerUIDs() {
        ConsumerUID[] ids = new ConsumerUID[]{};
        if (this.iidMap != null) {
            ArrayList list = new ArrayList();
            Set entries = this.iidMap.entrySet();
            for (Map.Entry entry : entries) {
                Integer index = (Integer)entry.getValue();
                if (this.statearray[index] == 2) continue;
                list.add(entry.getKey());
            }
            ids = list.toArray(ids);
        }
        return ids;
    }

    synchronized boolean hasMessageBeenAck() {
        if (this.statearray != null && this.statearray.length > 0) {
            int len = this.statearray.length;
            for (int i = 0; i < len; ++i) {
                if (this.statearray[i] == 2) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.packetSize = in.readInt();
        byte[] b = new byte[this.packetSize];
        this.msg = new Packet(false);
        this.msg.generateTimestamp(false);
        this.msg.generateSequenceNumber(false);
        in.readFully(b);
        ByteArrayInputStream ais = new ByteArrayInputStream(b);
        this.msg.readPacket(ais);
        ais.close();
        this.mid = SysMessageID.get((String)in.readObject());
        this.iidMap = (HashMap)in.readObject();
        this.statearray = (int[])in.readObject();
        this.logger = Globals.getLogger();
        this.br = Globals.getBrokerResources();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        byte[] b = this.msg.getBytes();
        out.writeInt(b.length);
        out.write(b);
        out.writeObject(this.mid.toString());
        out.writeObject(this.iidMap);
        out.writeObject(this.statearray);
    }
}

