/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.coherence;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.persist.coherence.CoherenceStore;
import com.sun.messaging.jmq.jmsserver.persist.coherence.DstMsgStore;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;

class MsgStore {
    private Logger logger = Globals.getLogger();
    private BrokerResources br = Globals.getBrokerResources();
    private ConcurrentHashMap dstMap = new ConcurrentHashMap(32);
    private CoherenceStore store = null;
    private static final Enumeration emptyEnum = new Enumeration(){

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            return null;
        }
    };

    MsgStore(CoherenceStore s) {
        this.store = s;
    }

    protected Hashtable getDebugState() {
        Hashtable t = new Hashtable();
        for (DstMsgStore dstMsgStore : this.dstMap.values()) {
            t.putAll(dstMsgStore.getDebugState());
        }
        return t;
    }

    protected void storeMessage(DestinationUID duid, Packet message, ConsumerUID[] iids, int[] states) throws IOException, BrokerException {
        DstMsgStore dstMsgStore = this.getDstMsgStore(duid, true);
        dstMsgStore.storeMessage(message, iids, states);
    }

    protected Packet getMessage(DestinationUID duid, SysMessageID mid) throws BrokerException {
        try {
            return this.getDstMsgStore(duid).getMessage(mid);
        }
        catch (IOException e) {
            String emsg = this.br.getString("B4107", mid.toString());
            this.logger.log(32, emsg);
            throw new BrokerException(emsg, e);
        }
    }

    protected boolean containsMessage(DestinationUID duid, SysMessageID mid) throws BrokerException {
        DstMsgStore dstMsgStore = this.getDstMsgStore(duid, true);
        return dstMsgStore.containsMsg(mid);
    }

    protected void removeMessage(DestinationUID duid, SysMessageID mid) throws IOException, BrokerException {
        this.getDstMsgStore(duid).removeMessage(mid);
    }

    protected void moveMessage(Packet message, DestinationUID from, DestinationUID to, ConsumerUID[] ints, int[] states) throws IOException, BrokerException {
        SysMessageID mid = message.getSysMessageID();
        DstMsgStore fromdst = this.getDstMsgStore(from);
        if (fromdst == null || !fromdst.containsMsg(mid)) {
            String emsg = this.br.getString("B3007", mid, from);
            this.logger.log(32, emsg);
            throw new BrokerException(emsg);
        }
        this.storeMessage(to, message, ints, states);
        try {
            fromdst.removeMessage(message.getSysMessageID());
        }
        catch (BrokerException e) {
            this.getDstMsgStore(to).removeMessage(message.getSysMessageID());
            Object[] args = new Object[]{mid, from, to};
            this.logger.log(32, "B4187", args, (Throwable)e);
            throw e;
        }
    }

    public boolean hasMessageBeenAcked(DestinationUID duid, SysMessageID mid) throws BrokerException {
        return this.getDstMsgStore(duid).getMessageInfo(mid).hasMessageBeenAck();
    }

    public HashMap getStorageInfo(Destination dest) throws BrokerException {
        return new HashMap();
    }

    protected void compactDestination(Destination dest) throws BrokerException {
    }

    protected void removeAllMessages(DestinationUID duid, boolean sync) throws IOException, BrokerException {
        throw new BrokerException("Not implemented");
    }

    protected void releaseMessageDir(DestinationUID duid) {
        DstMsgStore dstMsgStore = (DstMsgStore)this.dstMap.remove(duid);
        dstMsgStore.close();
    }

    protected Enumeration messageEnumeration() {
        Enumeration msgEnum = new Enumeration(){
            Iterator dstitr;
            Enumeration tempenum;
            Object nextToReturn;
            {
                this.dstitr = MsgStore.this.store.getDstStore().getDestinations().iterator();
                this.tempenum = null;
                this.nextToReturn = null;
            }

            @Override
            public boolean hasMoreElements() {
                while (true) {
                    if (this.tempenum != null) {
                        if (this.tempenum.hasMoreElements()) {
                            this.nextToReturn = this.tempenum.nextElement();
                            return true;
                        }
                        this.tempenum = null;
                        continue;
                    }
                    while (this.dstitr.hasNext()) {
                        Destination dst = (Destination)this.dstitr.next();
                        try {
                            this.tempenum = MsgStore.this.messageEnumeration(dst.getDestinationUID());
                            break;
                        }
                        catch (BrokerException e) {
                            MsgStore.this.logger.log(32, "B4145", (Object)dst.getDestinationUID(), (Throwable)e);
                        }
                    }
                    if (this.tempenum == null) break;
                }
                return false;
            }

            public Object nextElement() {
                if (this.nextToReturn != null) {
                    Object tmp = this.nextToReturn;
                    this.nextToReturn = null;
                    return tmp;
                }
                throw new NoSuchElementException();
            }
        };
        return msgEnum;
    }

    protected Enumeration messageEnumeration(DestinationUID duid) throws BrokerException {
        DstMsgStore dstMsgStore = this.getDstMsgStore(duid, true);
        if (dstMsgStore != null) {
            return dstMsgStore.messageEnumeration();
        }
        return emptyEnum;
    }

    protected int getMessageCount(DestinationUID duid) throws BrokerException {
        DstMsgStore dstMsgStore = this.getDstMsgStore(duid, true);
        if (dstMsgStore != null) {
            return dstMsgStore.getMessageCount();
        }
        return 0;
    }

    protected long getByteCount(DestinationUID duid) throws BrokerException {
        DstMsgStore dstMsgStore = this.getDstMsgStore(duid, true);
        if (dstMsgStore != null) {
            return dstMsgStore.getByteCount();
        }
        return 0L;
    }

    protected void storeInterestStates(DestinationUID duid, SysMessageID mid, ConsumerUID[] iids, int[] states, boolean sync) throws BrokerException {
        try {
            this.getDstMsgStore(duid).storeInterestStates(mid, iids, states);
        }
        catch (IOException e) {
            String emsg = this.br.getString("B4105", mid.toString());
            this.logger.log(32, emsg);
            throw new BrokerException(emsg, e);
        }
    }

    protected void updateInterestState(DestinationUID duid, SysMessageID mid, ConsumerUID iid, int state, boolean sync) throws BrokerException {
        try {
            this.getDstMsgStore(duid).updateInterestState(mid, iid, state);
        }
        catch (IOException e) {
            String emsg = this.br.getString("B4015", iid.toString(), mid.toString());
            this.logger.log(32, emsg);
            throw new BrokerException(emsg, e);
        }
    }

    protected int getInterestState(DestinationUID duid, SysMessageID mid, ConsumerUID iid) throws BrokerException {
        return this.getDstMsgStore(duid).getMessageInfo(mid).getInterestState(iid);
    }

    protected HashMap getInterestStates(DestinationUID duid, SysMessageID mid) throws BrokerException {
        return this.getDstMsgStore(duid).getMessageInfo(mid).getInterestStates();
    }

    protected ConsumerUID[] getConsumerUIDs(DestinationUID duid, SysMessageID mid) throws BrokerException {
        return this.getDstMsgStore(duid).getMessageInfo(mid).getConsumerUIDs();
    }

    protected void clearAll() throws BrokerException {
        if (this.dstMap != null) {
            this.closeAllDstMsgStore(false);
            this.dstMap.clear();
        }
    }

    protected void close(boolean cleanup) {
        this.closeAllDstMsgStore(cleanup);
        this.dstMap.clear();
    }

    private DstMsgStore getDstMsgStore(DestinationUID duid) throws BrokerException {
        DstMsgStore dstMsgStore = (DstMsgStore)this.dstMap.get(duid);
        if (dstMsgStore == null) {
            String emsg = this.br.getString("B3013", duid);
            this.logger.log(32, emsg);
            throw new BrokerException(emsg);
        }
        return dstMsgStore;
    }

    private DstMsgStore getDstMsgStore(DestinationUID duid, boolean create) throws BrokerException {
        DstMsgStore oldValue;
        this.store.getDstStore().checkDestination(duid);
        DstMsgStore dstMsgStore = (DstMsgStore)this.dstMap.get(duid);
        if (dstMsgStore == null && create && (oldValue = this.dstMap.putIfAbsent(duid, dstMsgStore = new DstMsgStore(this.store, duid))) != null) {
            dstMsgStore = oldValue;
        }
        return dstMsgStore;
    }

    private void closeAllDstMsgStore(boolean msgCleanup) {
        for (DstMsgStore dstMsgStore : this.dstMap.values()) {
            if (dstMsgStore == null) continue;
            dstMsgStore.close();
        }
    }
}

