/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.inmemory;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.persist.api.Store;
import com.sun.messaging.jmq.jmsserver.persist.inmemory.InMemoryStore;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.concurrent.ConcurrentHashMap;

class DestinationStore {
    Logger logger = Globals.getLogger();
    BrokerResources br = Globals.getBrokerResources();
    private ConcurrentHashMap dstMap = null;
    private InMemoryStore parent = null;

    DestinationStore(InMemoryStore p) {
        this.parent = p;
        this.dstMap = new ConcurrentHashMap(64);
    }

    void storeDestination(Destination destination) throws IOException, BrokerException {
        DestinationUID did = destination.getDestinationUID();
        try {
            Destination oldValue = this.dstMap.putIfAbsent(did, destination);
            if (oldValue != null) {
                this.logger.log(32, "B3012", destination.getName());
                throw new BrokerException(this.br.getString("B3012", destination.getName()));
            }
        }
        catch (RuntimeException e) {
            this.logger.log(32, "B4014", destination.getName());
            throw new BrokerException(this.br.getString("B4014", destination.getName()), e);
        }
    }

    void updateDestination(Destination destination) throws BrokerException {
        DestinationUID did = destination.getDestinationUID();
        try {
            Destination oldValue = this.dstMap.replace(did, destination);
            if (oldValue == null) {
                this.logger.log(32, "B3013", destination.getName());
                throw new BrokerException(this.br.getString("B3013", destination.getName()));
            }
        }
        catch (RuntimeException e) {
            this.logger.log(32, "B4014", destination.getName());
            throw new BrokerException(this.br.getString("B4014", destination.getName()), e);
        }
    }

    void removeDestination(Destination destination) throws BrokerException {
        DestinationUID did = destination.getDestinationUID();
        try {
            Object oldValue = this.dstMap.remove(did);
            if (oldValue == null) {
                this.logger.log(32, "B3013", destination.getName());
                throw new BrokerException(this.br.getString("B3013", destination.getName()));
            }
            this.parent.getMsgStore().releaseMessageDir(did);
        }
        catch (RuntimeException e) {
            this.logger.log(32, "B4144", (Object)destination.getName(), (Throwable)e);
            throw new BrokerException(this.br.getString("B4144", destination.getName()), e);
        }
    }

    Destination getDestination(DestinationUID did) throws IOException {
        return (Destination)this.dstMap.get(did);
    }

    Destination[] getAllDestinations() throws IOException {
        return this.dstMap.values().toArray(new Destination[0]);
    }

    Collection getDestinations() {
        return this.dstMap.values();
    }

    void clearAll(boolean clearMessages) {
        if (Store.getDEBUG()) {
            this.logger.log(1, "DestinationStore.clearAll(" + clearMessages + ") called");
        }
        if (clearMessages) {
            for (Destination dst : this.dstMap.values()) {
                DestinationUID did = dst.getDestinationUID();
                this.parent.getMsgStore().releaseMessageDir(did);
            }
        }
        this.dstMap.clear();
    }

    Hashtable getDebugState() {
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("Destinations", String.valueOf(this.dstMap.size()));
        return t;
    }

    void close(boolean cleanup) {
        if (Store.getDEBUG()) {
            this.logger.log(1, "DestinationStore: closing, " + this.dstMap.size() + " in-memory destinations");
        }
    }

    void checkDestination(DestinationUID did) throws BrokerException {
        if (!this.dstMap.containsKey(did)) {
            this.logger.log(32, "B3013", did.toString());
            throw new BrokerException(this.br.getString("B3013", did.toString()));
        }
    }
}

