/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pkg.tools.ant;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Zip;
import org.apache.tools.ant.taskdefs.condition.Os;

public class Makezip
extends Task {
    private String gDestfile = "";
    private String gBasedir = "";
    private String gIncludes = "";

    public void setDestfile(String aDestfile) {
        this.gDestfile = aDestfile;
    }

    public void setBasedir(String aBasedir) {
        this.gBasedir = aBasedir;
    }

    public void setInclude(String aIncludes) {
        this.gIncludes = aIncludes;
    }

    public void execute() throws BuildException {
        String theOutput = null;
        new File(this.gDestfile).delete();
        try {
            if (Os.isFamily((String)"windows")) {
                Zip z = new Zip();
                z.setDestFile(new File(this.gDestfile));
                z.setBasedir(new File(this.gBasedir));
                if (this.gIncludes.length() != 0) {
                    z.setIncludes(this.gIncludes + "/**/*");
                }
                z.setProject(this.getProject());
                z.setTaskName("makezip");
                z.execute();
            } else {
                ProcessBuilder theProcBuilder = new ProcessBuilder(new String[0]);
                ArrayList<String> theCommand = new ArrayList<String>();
                theCommand.add("zip");
                theCommand.add("-qyr");
                theCommand.add(this.gDestfile);
                if (this.gIncludes.length() != 0) {
                    theCommand.add(this.gIncludes);
                } else {
                    theCommand.add(".");
                }
                theProcBuilder.command(theCommand);
                System.out.println("Building zip: " + this.gDestfile);
                theProcBuilder.directory(new File(this.gBasedir));
                theProcBuilder.redirectErrorStream(true);
                Process theProcess = theProcBuilder.start();
                BufferedReader stdInput = new BufferedReader(new InputStreamReader(theProcess.getInputStream()));
                while ((theOutput = stdInput.readLine()) != null) {
                    System.out.println(theOutput);
                }
                theProcess.waitFor();
                if (theProcess.exitValue() != 0) {
                    throw new BuildException("zip failed, error code = " + theProcess.exitValue());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BuildException("zip failed", (Throwable)e);
        }
    }
}

