/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.utils.network;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Observable;

public class FileDownloader
extends Observable {
    private Status status;
    private long initialSize;
    private Long downloadSize = null;
    private long downloaded;
    private final URL downloadUrl;
    private final File outputFile;
    private InputStream stream = null;
    private Exception error;
    private String userAgent;

    public FileDownloader(URL url, File file) {
        this.downloadUrl = url;
        this.outputFile = file;
        this.downloaded = 0L;
        this.initialSize = 0L;
        this.userAgent = "ArduinoIDE/1.8.6 Java/" + System.getProperty("java.version");
    }

    public long getInitialSize() {
        return this.initialSize;
    }

    public Long getDownloadSize() {
        return this.downloadSize;
    }

    public void setDownloadSize(Long downloadSize) {
        this.downloadSize = downloadSize;
        this.setChanged();
        this.notifyObservers();
    }

    public long getDownloaded() {
        return this.downloaded;
    }

    private void setDownloaded(long downloaded) {
        this.downloaded = downloaded;
        this.setChanged();
        this.notifyObservers();
    }

    public float getProgress() {
        if (this.downloadSize == null) {
            return 0.0f;
        }
        if (this.downloadSize == 0L) {
            return 100.0f;
        }
        return (float)this.downloaded / (float)this.downloadSize.longValue() * 100.0f;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
        this.setChanged();
        this.notifyObservers();
    }

    public void download() throws InterruptedException {
        if ("file".equals(this.downloadUrl.getProtocol())) {
            this.saveLocalFile();
        } else {
            this.downloadFile();
        }
    }

    private void saveLocalFile() {
        try {
            Files.write(this.outputFile.toPath(), Files.readAllBytes(Paths.get(this.downloadUrl.getPath(), new String[0])), new OpenOption[0]);
            this.setStatus(Status.COMPLETE);
        }
        catch (Exception e) {
            this.setStatus(Status.ERROR);
            this.setError(e);
        }
    }

    /*
     * Exception decompiling
     */
    private void downloadFile() throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [15[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void setError(Exception e) {
        this.error = e;
    }

    public Exception getError() {
        return this.error;
    }

    public boolean isCompleted() {
        return this.status == Status.COMPLETE;
    }

    public static enum Status {
        CONNECTING,
        CONNECTION_TIMEOUT_ERROR,
        DOWNLOADING,
        COMPLETE,
        CANCELLED,
        ERROR;

    }
}

