/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.cmm.kcms;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import sun.awt.image.ByteComponentRaster;
import sun.awt.image.IntegerComponentRaster;
import sun.awt.image.ShortComponentRaster;

class CMMImageLayout {
    private static final int typeBase = 256;
    public static final int typeComponentUByte = 256;
    public static final int typeComponentUShort12 = 257;
    public static final int typeComponentUShort = 258;
    public static final int typePixelUByte = 259;
    public static final int typePixelUShort12 = 260;
    public static final int typePixelUShort = 261;
    public static final int typeShort555 = 262;
    public static final int typeShort565 = 263;
    public static final int typeInt101010 = 264;
    public static final int typeIntRGBPacked = 265;
    public int Type;
    public int NumCols;
    public int NumRows;
    public int OffsetColumn;
    public int OffsetRow;
    public int NumChannels;
    public final boolean hasAlpha;
    public Object[] chanData;
    public int[] DataOffsets;
    public int[] sampleInfo;
    private int[] dataArrayLength;
    private static final int MAX_NumChannels = 9;

    public CMMImageLayout(byte[] byArray, int n, int n2) throws ImageLayoutException {
        this.Type = 256;
        this.chanData = new Object[n2];
        this.DataOffsets = new int[n2];
        this.dataArrayLength = new int[n2];
        this.NumCols = n;
        this.NumRows = 1;
        this.OffsetColumn = n2;
        this.OffsetRow = this.NumCols * this.OffsetColumn;
        this.NumChannels = n2;
        for (int i = 0; i < n2; ++i) {
            this.chanData[i] = byArray;
            this.DataOffsets[i] = i;
            this.dataArrayLength[i] = byArray.length;
        }
        this.hasAlpha = false;
        this.verify();
    }

    public CMMImageLayout(short[] sArray, int n, int n2) throws ImageLayoutException {
        this.Type = 258;
        this.chanData = new Object[n2];
        this.DataOffsets = new int[n2];
        this.dataArrayLength = new int[n2];
        this.NumCols = n;
        this.NumRows = 1;
        this.OffsetColumn = CMMImageLayout.safeMult(2, n2);
        this.OffsetRow = this.NumCols * this.OffsetColumn;
        this.NumChannels = n2;
        for (int i = 0; i < n2; ++i) {
            this.chanData[i] = sArray;
            this.DataOffsets[i] = i * 2;
            this.dataArrayLength[i] = 2 * sArray.length;
        }
        this.hasAlpha = false;
        this.verify();
    }

    public CMMImageLayout(BufferedImage bufferedImage) throws ImageLayoutException {
        this.Type = bufferedImage.getType();
        this.NumCols = bufferedImage.getWidth();
        this.NumRows = bufferedImage.getHeight();
        WritableRaster writableRaster = bufferedImage.getRaster();
        switch (this.Type) {
            case 1: 
            case 2: 
            case 4: {
                this.NumChannels = 3;
                this.hasAlpha = this.Type == 2;
                int n = this.hasAlpha ? 4 : 3;
                this.chanData = new Object[n];
                this.DataOffsets = new int[n];
                this.dataArrayLength = new int[n];
                this.sampleInfo = new int[n];
                this.OffsetColumn = 4;
                if (writableRaster instanceof IntegerComponentRaster) {
                    IntegerComponentRaster integerComponentRaster = (IntegerComponentRaster)writableRaster;
                    int n2 = CMMImageLayout.safeMult(4, integerComponentRaster.getPixelStride());
                    if (n2 != this.OffsetColumn) {
                        throw new ImageLayoutException("Incompatible raster type");
                    }
                    this.OffsetRow = CMMImageLayout.safeMult(4, integerComponentRaster.getScanlineStride());
                    int n3 = CMMImageLayout.safeMult(4, integerComponentRaster.getDataOffset(0));
                    int[] nArray = integerComponentRaster.getDataStorage();
                    for (int i = 0; i < 3; ++i) {
                        this.chanData[i] = nArray;
                        this.DataOffsets[i] = n3;
                        this.dataArrayLength[i] = 4 * nArray.length;
                        this.sampleInfo[i] = this.Type == 4 ? 3 - i : i + 1;
                    }
                    if (!this.hasAlpha) break;
                    this.chanData[3] = nArray;
                    this.DataOffsets[3] = n3;
                    this.dataArrayLength[3] = 4 * nArray.length;
                    this.sampleInfo[3] = 0;
                    break;
                }
                throw new ImageLayoutException("Incompatible raster type");
            }
            case 5: 
            case 6: {
                int n;
                this.NumChannels = 3;
                boolean bl = this.hasAlpha = this.Type == 6;
                if (this.hasAlpha) {
                    this.OffsetColumn = 4;
                    n = 4;
                } else {
                    this.OffsetColumn = 3;
                    n = 3;
                }
                this.chanData = new Object[n];
                this.DataOffsets = new int[n];
                this.dataArrayLength = new int[n];
                if (writableRaster instanceof ByteComponentRaster) {
                    ByteComponentRaster byteComponentRaster = (ByteComponentRaster)writableRaster;
                    int n4 = byteComponentRaster.getPixelStride();
                    if (n4 != this.OffsetColumn) {
                        throw new ImageLayoutException("Incompatible raster type");
                    }
                    this.OffsetRow = byteComponentRaster.getScanlineStride();
                    int n5 = byteComponentRaster.getDataOffset(0);
                    byte[] byArray = byteComponentRaster.getDataStorage();
                    for (int i = 0; i < n; ++i) {
                        this.chanData[i] = byArray;
                        this.DataOffsets[i] = n5 - i;
                        this.dataArrayLength[i] = byArray.length;
                    }
                    break;
                }
                throw new ImageLayoutException("Incompatible raster type");
            }
            case 10: {
                this.Type = 256;
                this.NumChannels = 1;
                this.hasAlpha = false;
                this.chanData = new Object[1];
                this.DataOffsets = new int[1];
                this.dataArrayLength = new int[1];
                this.OffsetColumn = 1;
                if (writableRaster instanceof ByteComponentRaster) {
                    ByteComponentRaster byteComponentRaster = (ByteComponentRaster)writableRaster;
                    int n = byteComponentRaster.getPixelStride();
                    if (n != this.OffsetColumn) {
                        throw new ImageLayoutException("Incompatible raster type");
                    }
                    this.OffsetRow = byteComponentRaster.getScanlineStride();
                    byte[] byArray = byteComponentRaster.getDataStorage();
                    this.chanData[0] = byArray;
                    this.dataArrayLength[0] = byArray.length;
                    this.DataOffsets[0] = byteComponentRaster.getDataOffset(0);
                    break;
                }
                throw new ImageLayoutException("Incompatible raster type");
            }
            case 11: {
                this.Type = 258;
                this.NumChannels = 1;
                this.hasAlpha = false;
                this.chanData = new Object[1];
                this.DataOffsets = new int[1];
                this.dataArrayLength = new int[1];
                this.OffsetColumn = 2;
                if (writableRaster instanceof ShortComponentRaster) {
                    ShortComponentRaster shortComponentRaster = (ShortComponentRaster)writableRaster;
                    int n = CMMImageLayout.safeMult(2, shortComponentRaster.getPixelStride());
                    if (n != this.OffsetColumn) {
                        throw new ImageLayoutException("Incompatible raster type");
                    }
                    this.OffsetRow = CMMImageLayout.safeMult(2, shortComponentRaster.getScanlineStride());
                    this.DataOffsets[0] = CMMImageLayout.safeMult(2, shortComponentRaster.getDataOffset(0));
                    short[] sArray = shortComponentRaster.getDataStorage();
                    this.chanData[0] = sArray;
                    this.dataArrayLength[0] = 2 * sArray.length;
                    break;
                }
                throw new ImageLayoutException("Incompatible raster type");
            }
            default: {
                throw new IllegalArgumentException("CMMImageLayout - bad image type passed to constructor");
            }
        }
        this.verify();
    }

    public CMMImageLayout(BufferedImage bufferedImage, SinglePixelPackedSampleModel singlePixelPackedSampleModel, int n, int n2, int n3, int n4) throws ImageLayoutException {
        this.Type = 265;
        this.NumChannels = 3;
        this.NumCols = bufferedImage.getWidth();
        this.NumRows = bufferedImage.getHeight();
        this.hasAlpha = n4 >= 0;
        int n5 = this.hasAlpha ? 4 : 3;
        this.chanData = new Object[n5];
        this.DataOffsets = new int[n5];
        this.dataArrayLength = new int[n5];
        this.sampleInfo = new int[n5];
        this.OffsetColumn = 4;
        int n6 = singlePixelPackedSampleModel.getScanlineStride();
        this.OffsetRow = CMMImageLayout.safeMult(4, n6);
        WritableRaster writableRaster = bufferedImage.getRaster();
        DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
        int n7 = writableRaster.getSampleModelTranslateX();
        int n8 = writableRaster.getSampleModelTranslateY();
        int n9 = CMMImageLayout.safeMult(n8, n6);
        int n10 = CMMImageLayout.safeMult(4, n7);
        n10 = CMMImageLayout.safeAdd(n10, n9);
        int n11 = CMMImageLayout.safeAdd(dataBufferInt.getOffset(), -n10);
        int[] nArray = dataBufferInt.getData();
        for (int i = 0; i < n5; ++i) {
            this.chanData[i] = nArray;
            this.DataOffsets[i] = n11;
            this.dataArrayLength[i] = nArray.length * 4;
        }
        this.sampleInfo[0] = n;
        this.sampleInfo[1] = n2;
        this.sampleInfo[2] = n3;
        if (this.hasAlpha) {
            this.sampleInfo[3] = n4;
        }
        this.verify();
    }

    public CMMImageLayout(BufferedImage bufferedImage, ComponentSampleModel componentSampleModel) throws ImageLayoutException {
        ColorModel colorModel = bufferedImage.getColorModel();
        int n = colorModel.getNumColorComponents();
        if (n < 0 || n > 9) {
            throw new ImageLayoutException("Invalid image layout");
        }
        this.hasAlpha = colorModel.hasAlpha();
        WritableRaster writableRaster = bufferedImage.getRaster();
        int[] nArray = componentSampleModel.getBankIndices();
        int[] nArray2 = componentSampleModel.getBandOffsets();
        this.NumChannels = n++;
        this.NumCols = bufferedImage.getWidth();
        this.NumRows = bufferedImage.getHeight();
        if (this.hasAlpha) {
            // empty if block
        }
        this.chanData = new Object[n];
        this.DataOffsets = new int[n];
        this.dataArrayLength = new int[n];
        int n2 = writableRaster.getSampleModelTranslateY();
        int n3 = writableRaster.getSampleModelTranslateX();
        int n4 = componentSampleModel.getScanlineStride();
        int n5 = componentSampleModel.getPixelStride();
        int n6 = CMMImageLayout.safeMult(n4, n2);
        int n7 = CMMImageLayout.safeMult(n5, n3);
        n7 = CMMImageLayout.safeAdd(n7, n6);
        switch (componentSampleModel.getDataType()) {
            case 0: {
                this.Type = 256;
                this.OffsetColumn = n5;
                this.OffsetRow = n4;
                DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
                int[] nArray3 = dataBufferByte.getOffsets();
                for (int i = 0; i < n; ++i) {
                    byte[] byArray = dataBufferByte.getData(nArray[i]);
                    this.chanData[i] = byArray;
                    this.dataArrayLength[i] = byArray.length;
                    int n8 = CMMImageLayout.safeAdd(nArray3[nArray[i]], -n7);
                    this.DataOffsets[i] = n8 = CMMImageLayout.safeAdd(n8, nArray2[i]);
                }
                break;
            }
            case 1: {
                this.Type = 258;
                this.OffsetColumn = CMMImageLayout.safeMult(2, n5);
                this.OffsetRow = CMMImageLayout.safeMult(2, n4);
                DataBufferUShort dataBufferUShort = (DataBufferUShort)writableRaster.getDataBuffer();
                int[] nArray4 = dataBufferUShort.getOffsets();
                for (int i = 0; i < n; ++i) {
                    short[] sArray = dataBufferUShort.getData(nArray[i]);
                    this.chanData[i] = sArray;
                    this.dataArrayLength[i] = sArray.length * 2;
                    int n9 = CMMImageLayout.safeAdd(nArray4[nArray[i]], -n7);
                    n9 = CMMImageLayout.safeAdd(n9, nArray2[i]);
                    this.DataOffsets[i] = CMMImageLayout.safeMult(2, n9);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("CMMImageLayout - bad image type passed to constructor");
            }
        }
        this.verify();
    }

    public CMMImageLayout(Raster raster, ComponentSampleModel componentSampleModel) throws ImageLayoutException {
        int n = raster.getNumBands();
        if (n < 0 || n > 9) {
            throw new ImageLayoutException("Invalid image layout");
        }
        int[] nArray = componentSampleModel.getBankIndices();
        int[] nArray2 = componentSampleModel.getBandOffsets();
        this.NumChannels = n;
        this.NumCols = raster.getWidth();
        this.NumRows = raster.getHeight();
        this.hasAlpha = false;
        this.chanData = new Object[n];
        this.DataOffsets = new int[n];
        this.dataArrayLength = new int[n];
        int n2 = componentSampleModel.getScanlineStride();
        int n3 = componentSampleModel.getPixelStride();
        int n4 = raster.getMinX();
        int n5 = raster.getMinY();
        int n6 = raster.getSampleModelTranslateX();
        int n7 = raster.getSampleModelTranslateY();
        int n8 = CMMImageLayout.safeAdd(n5, -n7);
        n8 = CMMImageLayout.safeMult(n8, n2);
        int n9 = CMMImageLayout.safeAdd(n4, -n6);
        n9 = CMMImageLayout.safeMult(n9, n3);
        n9 = CMMImageLayout.safeAdd(n9, n8);
        switch (componentSampleModel.getDataType()) {
            case 0: {
                this.Type = 256;
                this.OffsetColumn = n3;
                this.OffsetRow = n2;
                DataBufferByte dataBufferByte = (DataBufferByte)raster.getDataBuffer();
                int[] nArray3 = dataBufferByte.getOffsets();
                for (int i = 0; i < n; ++i) {
                    byte[] byArray = dataBufferByte.getData(nArray[i]);
                    this.chanData[i] = byArray;
                    this.dataArrayLength[i] = byArray.length;
                    int n10 = CMMImageLayout.safeAdd(nArray3[nArray[i]], n9);
                    this.DataOffsets[i] = CMMImageLayout.safeAdd(n10, nArray2[i]);
                }
                break;
            }
            case 1: {
                this.Type = 258;
                this.OffsetColumn = CMMImageLayout.safeMult(2, n3);
                this.OffsetRow = CMMImageLayout.safeMult(2, n2);
                DataBufferUShort dataBufferUShort = (DataBufferUShort)raster.getDataBuffer();
                int[] nArray4 = dataBufferUShort.getOffsets();
                for (int i = 0; i < n; ++i) {
                    short[] sArray = dataBufferUShort.getData(nArray[i]);
                    this.chanData[i] = sArray;
                    this.dataArrayLength[i] = sArray.length * 2;
                    int n11 = CMMImageLayout.safeAdd(nArray4[nArray[i]], n9);
                    n11 = CMMImageLayout.safeAdd(n11, nArray2[i]);
                    this.DataOffsets[i] = CMMImageLayout.safeMult(2, n11);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("CMMImageLayout - bad image type passed to constructor");
            }
        }
        this.verify();
    }

    private final void verify() throws ImageLayoutException {
        int n = CMMImageLayout.safeMult(this.OffsetRow, this.NumRows - 1);
        int n2 = CMMImageLayout.safeMult(this.OffsetColumn, this.NumCols - 1);
        n = CMMImageLayout.safeAdd(n, n2);
        int n3 = this.NumChannels;
        if (this.hasAlpha) {
            ++n3;
        }
        for (int i = 0; i < n3; ++i) {
            int n4 = this.DataOffsets[i];
            if (n4 < 0 || n4 >= this.dataArrayLength[i]) {
                throw new ImageLayoutException("Invalid image layout");
            }
            if ((n4 = CMMImageLayout.safeAdd(n4, n)) >= 0 && n4 < this.dataArrayLength[i]) continue;
            throw new ImageLayoutException("Invalid image layout");
        }
    }

    static int safeAdd(int n, int n2) throws ImageLayoutException {
        long l = n;
        if ((l += (long)n2) < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
            throw new ImageLayoutException("Invalid image layout");
        }
        return (int)l;
    }

    static int safeMult(int n, int n2) throws ImageLayoutException {
        long l = n;
        if ((l *= (long)n2) < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
            throw new ImageLayoutException("Invalid image layout");
        }
        return (int)l;
    }

    public static class ImageLayoutException
    extends Exception {
        public ImageLayoutException(String string) {
            super(string);
        }

        public ImageLayoutException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }
}

