/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.shiftreduce;

import edu.stanford.nlp.parser.shiftreduce.ShiftReduceUtils;
import edu.stanford.nlp.parser.shiftreduce.Transition;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.Scored;
import edu.stanford.nlp.util.TreeShapedStack;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;

public class State
implements Scored {
    final TreeShapedStack<Tree> stack;
    final TreeShapedStack<Transition> transitions;
    final TreeMap<Integer, String> separators;
    static final Pattern separatorRegex = Pattern.compile("^[,;:-]+$");
    static final char[][] equivalentSeparators = new char[][]{{'\uff0c', ','}, {'\uff1b', ';'}, {'\uff1a', ':'}};
    final List<Tree> sentence;
    final int tokenPosition;
    final double score;
    final boolean finished;

    public State(List<Tree> sentence) {
        this(new TreeShapedStack<Tree>(), new TreeShapedStack<Transition>(), State.findSeparators(sentence), sentence, 0, 0.0, false);
    }

    State(TreeShapedStack<Tree> stack, TreeShapedStack<Transition> transitions, TreeMap<Integer, String> separators, List<Tree> sentence, int tokenPosition, double score, boolean finished) {
        this.stack = stack;
        this.transitions = transitions;
        this.separators = separators;
        this.sentence = sentence;
        this.tokenPosition = tokenPosition;
        this.score = score;
        this.finished = finished;
    }

    Tree getStackNode(int depth) {
        if (depth >= this.stack.size()) {
            return null;
        }
        TreeShapedStack<Tree> node = this.stack;
        for (int i = 0; i < depth; ++i) {
            node = node.pop();
        }
        return node.peek();
    }

    Tree getQueueNode(int depth) {
        if (this.tokenPosition + depth >= this.sentence.size()) {
            return null;
        }
        return this.sentence.get(this.tokenPosition + depth);
    }

    String getSeparatorBetween(int right, int left) {
        if (right >= left) {
            throw new AssertionError((Object)"Expected right < left");
        }
        return this.getSeparatorBetween(this.getStackNode(right), this.getStackNode(left));
    }

    String getSeparatorBetween(Tree right, Tree left) {
        if (right == null || left == null) {
            return null;
        }
        int leftHead = ShiftReduceUtils.headIndex(left);
        int rightHead = ShiftReduceUtils.headIndex(right);
        Map.Entry<Integer, String> nextSeparator = this.separators.ceilingEntry(leftHead);
        if (nextSeparator == null || nextSeparator.getKey() > rightHead) {
            return null;
        }
        return nextSeparator.getValue().substring(0, 1);
    }

    int getSeparatorCount(int right, int left) {
        if (right >= left) {
            throw new AssertionError((Object)"Expected right < left");
        }
        return this.getSeparatorCount(this.getStackNode(right), this.getStackNode(left));
    }

    int getSeparatorCount(Tree right, Tree left) {
        if (right == null || left == null) {
            return 0;
        }
        int leftHead = ShiftReduceUtils.headIndex(left);
        int rightHead = ShiftReduceUtils.headIndex(right);
        Integer nextSeparator = this.separators.higherKey(leftHead);
        int count = 0;
        while (nextSeparator != null && nextSeparator < rightHead) {
            ++count;
            nextSeparator = this.separators.higherKey(nextSeparator);
        }
        return count;
    }

    HeadPosition getSeparator(int nodeNum) {
        boolean hasRight;
        if (nodeNum >= this.stack.size()) {
            return null;
        }
        TreeShapedStack<Tree> stack = this.stack;
        for (int i = 0; i < nodeNum; ++i) {
            stack = stack.pop();
        }
        Tree node = stack.peek();
        int head = ShiftReduceUtils.headIndex(node);
        if (this.separators.get(head) != null) {
            return HeadPosition.HEAD;
        }
        int left = ShiftReduceUtils.leftIndex(node);
        Integer nextLeft = this.separators.floorKey(head);
        boolean hasLeft = nextLeft != null && nextLeft >= left;
        int right = ShiftReduceUtils.rightIndex(node);
        Integer nextRight = this.separators.ceilingKey(head);
        boolean bl = hasRight = nextRight != null && nextRight <= right;
        if (hasLeft && hasRight) {
            return HeadPosition.BOTH;
        }
        if (hasLeft) {
            return HeadPosition.LEFT;
        }
        if (hasRight) {
            return HeadPosition.RIGHT;
        }
        return HeadPosition.NONE;
    }

    static TreeMap<Integer, String> findSeparators(List<Tree> sentence) {
        TreeMap<Integer, String> separators = Generics.newTreeMap();
        for (int index = 0; index < sentence.size(); ++index) {
            Tree leaf = sentence.get(index).children()[0];
            String value = leaf.value();
            for (char[] equivalentSeparator : equivalentSeparators) {
                value = value.replace(equivalentSeparator[0], equivalentSeparator[1]);
            }
            if (!separatorRegex.matcher(value).matches()) continue;
            separators.put(index, leaf.value());
        }
        return separators;
    }

    @Override
    public double score() {
        return this.score;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public boolean endOfQueue() {
        return this.tokenPosition == this.sentence.size();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("State summary\n");
        result.append("  Tokens: " + this.sentence + "\n");
        result.append("  Token position: " + this.tokenPosition + "\n");
        result.append("  Current stack contents: " + this.stack.toString("\n") + "\n");
        result.append("  Component transitions: " + this.transitions + "\n");
        result.append("  Score: " + this.score + "\n");
        result.append("  " + (this.finished ? "" : "not ") + "finished\n");
        return result.toString();
    }

    public boolean areTransitionsEqual(State other) {
        return this.transitions.equals(other.transitions);
    }

    public static enum HeadPosition {
        NONE,
        LEFT,
        RIGHT,
        BOTH,
        HEAD;

    }
}

