/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.process;

import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Americanize
implements Function<HasWord, HasWord> {
    private static final Redwood.RedwoodChannels log;
    private final boolean capitalizeTimex;
    public static final int DONT_CAPITALIZE_TIMEX = 1;
    private static final int MINIMUM_LENGTH_CHANGED = 4;
    private static final int MINIMUM_LENGTH_PATTERN_MATCH = 6;
    private static final String[] patStrings;
    private static final Pattern[] pats;
    private static final Pattern disjunctivePattern;
    private static final String[] OUR_EXCEPTIONS;
    private static final Pattern[] excepts;
    private static final String[] reps;
    private static final String[] converters;
    private static final String[] converted;
    private static final String[] timexConverters;
    private static final String[] timexConverted;
    private static final Map<String, String> mapping;
    private static final Map<String, String> timexMapping;

    public Americanize() {
        this(0);
    }

    public Americanize(int flags) {
        this.capitalizeTimex = (flags & 1) == 0;
    }

    @Override
    public HasWord apply(HasWord w) {
        String str = w.word();
        String outStr = Americanize.americanize(str, this.capitalizeTimex);
        if (!outStr.equals(str)) {
            w.setWord(outStr);
        }
        return w;
    }

    public static String americanize(String str) {
        return Americanize.americanize(str, true);
    }

    public static String americanize(String str, boolean capitalizeTimex) {
        String result;
        int length = str.length();
        if (length < 4) {
            return str;
        }
        if (capitalizeTimex && (result = timexMapping.get(str)) != null) {
            return result;
        }
        result = mapping.get(str);
        if (result != null) {
            return result;
        }
        if (length < 6) {
            return str;
        }
        if (!disjunctivePattern.matcher(str).find()) {
            return str;
        }
        for (int i = 0; i < pats.length; ++i) {
            Matcher me;
            Pattern ex;
            Matcher m = pats[i].matcher(str);
            if (!m.find() || (ex = excepts[i]) != null && (me = ex.matcher(str)).find()) continue;
            return m.replaceAll(reps[i]);
        }
        return str;
    }

    public String toString() {
        return "Americanize[capitalizeTimex is " + this.capitalizeTimex + "; mapping has " + mapping.size() + " mappings; timexMapping has " + timexMapping.size() + " mappings]";
    }

    public static void main(String[] args) throws IOException {
        log.info(new Americanize());
        if (args.length == 0) {
            try (BufferedReader buf = new BufferedReader(new InputStreamReader(System.in));){
                String line;
                while ((line = buf.readLine()) != null) {
                    for (String w : line.split("\\s+")) {
                        System.out.print(Americanize.americanize(w));
                        System.out.print(' ');
                    }
                    System.out.println();
                }
            }
        }
        for (String arg : args) {
            System.out.print(arg);
            System.out.print(" --> ");
            System.out.println(Americanize.americanize(arg));
        }
    }

    static {
        int i;
        log = Redwood.channels(Americanize.class);
        patStrings = new String[]{"haem(at)?o", "aemia$", "([lL])eukaem", "programme(s?)$", "^([a-z]{3,})our(s?)$"};
        pats = new Pattern[patStrings.length];
        StringBuilder foo = new StringBuilder();
        int len = pats.length;
        for (int i2 = 0; i2 < len; ++i2) {
            Americanize.pats[i2] = Pattern.compile(patStrings[i2]);
            if (i2 > 0) {
                foo.append('|');
            }
            foo.append("(?:");
            foo.append(patStrings[i2].replaceAll("[()]", ""));
            foo.append(')');
        }
        disjunctivePattern = Pattern.compile(foo.toString());
        OUR_EXCEPTIONS = new String[]{"abatjour", "beflour", "bonjour", "calambour", "carrefour", "cornflour", "contour", "de[tv]our", "dortour", "dyvour", "downpour", "giaour", "glamour", "holour", "inpour", "outpour", "pandour", "paramour", "pompadour", "recontour", "repour", "ryeflour", "sompnour", "tambour", "troubadour", "tregetour", "velour"};
        excepts = new Pattern[]{null, null, null, null, Pattern.compile(StringUtils.join(OUR_EXCEPTIONS, "|"))};
        reps = new String[]{"hem$1o", "emia", "$1eukem", "program$1", "$1or$2"};
        converters = new String[]{"anaesthetic", "analogue", "analogues", "analyse", "analysed", "analysing", "armoured", "cancelled", "cancelling", "capitalise", "capitalised", "capitalisation", "centre", "chimaeric", "coloured", "colouring", "colourful", "defence", "Defence", "discoloured", "discolouring", "encyclopaedia", "endeavoured", "endeavouring", "favoured", "favouring", "favourite", "favourites", "fibre", "fibres", "finalise", "finalised", "finalising", "flavoured", "flavouring", "grey", "homologue", "homologues", "honoured", "honouring", "honourable", "humoured", "humouring", "kerb", "labelled", "labelling", "Labour", "laboured", "labouring", "leant", "learnt", "localise", "localised", "manoeuvre", "manoeuvres", "maximise", "maximised", "maximising", "meagre", "minimise", "minimised", "minimising", "modernise", "modernised", "modernising", "neighbourhood", "neighbourhoods", "oestrogen", "oestrogens", "organisation", "organisations", "penalise", "penalised", "popularise", "popularised", "popularises", "popularising", "practise", "practised", "pressurise", "pressurised", "pressurises", "pressurising", "realise", "realised", "realising", "realises", "recognise", "recognised", "recognising", "recognises", "rumoured", "rumouring", "savoured", "savouring", "theatre", "theatres", "titre", "titres", "travelled", "travelling"};
        converted = new String[]{"anesthetic", "analog", "analogs", "analyze", "analyzed", "analyzing", "armored", "canceled", "canceling", "capitalize", "capitalized", "capitalization", "center", "chimeric", "colored", "coloring", "colorful", "defense", "Defense", "discolored", "discoloring", "encyclopedia", "endeavored", "endeavoring", "favored", "favoring", "favorite", "favorites", "fiber", "fibers", "finalize", "finalized", "finalizing", "flavored", "flavoring", "gray", "homolog", "homologs", "honored", "honoring", "honorable", "humored", "humoring", "curb", "labeled", "labeling", "Labor", "labored", "laboring", "leaned", "learned", "localize", "localized", "maneuver", "maneuvers", "maximize", "maximized", "maximizing", "meager", "minimize", "minimized", "minimizing", "modernize", "modernized", "modernizing", "neighborhood", "neighborhoods", "estrogen", "estrogens", "organization", "organizations", "penalize", "penalized", "popularize", "popularized", "popularizes", "popularizing", "practice", "practiced", "pressurize", "pressurized", "pressurizes", "pressurizing", "realize", "realized", "realizing", "realizes", "recognize", "recognized", "recognizing", "recognizes", "rumored", "rumoring", "savored", "savoring", "theater", "theaters", "titer", "titers", "traveled", "traveling"};
        timexConverters = new String[]{"january", "february", "april", "june", "july", "august", "september", "october", "november", "december", "monday", "tuesday", "wednesday", "thursday", "friday", "saturday", "sunday"};
        timexConverted = new String[]{"January", "February", "April", "June", "July", "August", "September", "October", "November", "December", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"};
        mapping = Generics.newHashMap();
        timexMapping = Generics.newHashMap();
        if (converters.length != converted.length || timexConverters.length != timexConverted.length || pats.length != reps.length || pats.length != excepts.length) {
            throw new RuntimeException("Americanize: Bad initialization data");
        }
        for (i = 0; i < converters.length; ++i) {
            mapping.put(converters[i], converted[i]);
        }
        for (i = 0; i < timexConverters.length; ++i) {
            timexMapping.put(timexConverters[i], timexConverted[i]);
        }
    }
}

