/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.trees.Tree;
import java.util.Comparator;
import java.util.IdentityHashMap;
import org.ejml.simple.SimpleMatrix;

public class DeepTree {
    private final Tree tree;
    private final IdentityHashMap<Tree, SimpleMatrix> vectors;
    private final double score;
    public static final Comparator<DeepTree> DESCENDING_COMPARATOR = new Comparator<DeepTree>(){

        @Override
        public int compare(DeepTree o1, DeepTree o2) {
            return -Double.compare(o1.score, o2.score);
        }
    };

    public Tree getTree() {
        return this.tree;
    }

    public IdentityHashMap<Tree, SimpleMatrix> getVectors() {
        return this.vectors;
    }

    public double getScore() {
        return this.score;
    }

    public DeepTree(Tree tree, IdentityHashMap<Tree, SimpleMatrix> vectors, double score) {
        this.tree = tree;
        this.vectors = vectors;
        this.score = score;
    }
}

