#include <stdio.h>
#include <stdlib.h>

#include "ratlib.h"

extern void DKDRebuildTree(DKDTree_p);

char *pName = NULL;

RATVector *vectors;
#define myrand() ((lrand48() & 0xFFF) - 0x7FF)

void usage() {

  fprintf(stderr, "Usage: %s vectors rebuilds [deletes]\n"
	  "\tvectors\t\tNumber of vectors to insert into the tree\n"
	  "\trebuilds\tNumber of times to rebuild the tree\n"
	  "\tdeletes\t\tNumber of vectors to delete\n", pName);
  exit(1);

}

void GeneratePermute(int decksize, int handsize, int **hand) {
  int i, j, tmp;
  int *deck;

  *hand = (int *) malloc(sizeof(int) * handsize);
  deck = (int *) malloc(sizeof(int) * decksize);
  for (i = 0; i < decksize; i++)
    deck[i] = i;

  j = 0;
  while(handsize) {
    i = lrand48() % (decksize - j);
    tmp = deck[j];
    deck[j] = deck[i+j];
    deck[i+j] = tmp;
    handsize--;
    (*hand)[handsize] = deck[j];
    j++;
  }
  free(deck);
}


void RandomDeletes(RATTree tree, int vecs, int deletes) {
  RATVector v1, v2;
  int *permute;

  GeneratePermute(vecs, deletes, &permute);

  while (deletes) {
    deletes--;
    if (RATDelete(tree,
		  vectors[permute[deletes]][0],
		  vectors[permute[deletes]][1],
		  vectors[permute[deletes]][2],
		  vectors[permute[deletes]][3],
		  NULL)) {
      printf("Problem w/ Deleting a vector\n");
    }
  }

  free(permute);
}



void RandomInserts(RATTree tree, int vecs) {
  srand48(time(NULL));
  vectors = (RATVector *) malloc(sizeof(RATVector) * vecs);
  while(vecs) {
    vecs--;
    vectors[vecs][0] = myrand();
    vectors[vecs][1] = myrand();
    vectors[vecs][2] = myrand();
    vectors[vecs][3] = myrand();
    RATInsert(tree, vectors[vecs][0], vectors[vecs][1], vectors[vecs][2], 
	      vectors[vecs][3], NULL);
  }
}




int main(int argc, char *argv[]) {
  int rebuilds, vectors, deletes;
  RATTree tree;

  pName = argv[0];

  if (argc < 3) {
    usage();
  }

  if ((sscanf(argv[1], "%d", &vectors) != 1) ||
      (sscanf(argv[2], "%d", &rebuilds) != 1)) {
    usage();
  }
  if (argc == 4) {
    if (sscanf(argv[3], "%d", &deletes) != 1) {
      usage();
    }
  } else {
    deletes = 0;
  }

  tree = RATCreateTree();

  RandomInserts(tree, vectors);

  if (deletes)
    RandomDeletes(tree, vectors, deletes);

  while(rebuilds--)
    DKDRebuildTree(tree);

  RATDestroyTree(tree);

  exit(0);
}
