import requests, time, random
import pandas as pd
import matplotlib.pyplot as plt

def generate_random_colors(number_of_colors):
    colors = []

    for x in range(number_of_colors):
        rgb = (random.random(), random.random(), random.random())
        colors.append(rgb)

    return colors

def search_github(keyword):
    url = "https://api.github.com/search/repositories?q={}".format(keyword)
    data = requests.get(url).json()
    repos_count = data['total_count']
    return repos_count

def retrieve_repositories_results(keywords):
    repos_results = {}

    for keyword in keywords:
        repos_count = search_github(keyword)
        print("{} repositories results found: {}".format(keyword, repos_count))
        repos_results[keyword] = repos_count
        time.sleep(3)
    
    return repos_results

def print_repos_results(repos_results):
    df = pd.DataFrame(repos_results, index=['Repository results'])
    print(df)

def print_graph(repos_results, graph_type, title):
    keywords = repos_results.keys()
    results = repos_results.values()

    plt.figure(figsize=(9, 3))
    colors = generate_random_colors(len(keywords))

    if graph_type == "bar":
        plt.bar(keywords, results, color=colors)
    else:
        plt.scatter(keywords, results, color=colors)

    plt.suptitle(title)
    plt.show()


languages = ['Python', 'Java', 'Ruby', 'Javascript', 'PHP', 'Objective-C', 'Golang', 'Bash', 'Rust', 'Powershell']
languages_results = retrieve_repositories_results(languages)

print_repos_results(languages_results)
print_graph(languages_results, "bar", "Programming Languages")
