import requests, time, random
import pandas as pd
import matplotlib.pyplot as plt

def generate_random_colors(number_of_colors):
    colors = []

    for x in range(number_of_colors):
        rgb = (random.random(), random.random(), random.random())
        colors.append(rgb)

    return colors

def search_github(keyword, language_filter=None):
    if language_filter:
        url = "https://api.github.com/search/repositories?q={}+language:{}".format(keyword, language_filter)
    else:
        url = "https://api.github.com/search/repositories?q={}".format(keyword)

    data = requests.get(url).json()
    repos_count = data['total_count']
    return repos_count

def retrieve_repositories_results(keywords, language_filter=None):
    repos_results = {}

    for keyword in keywords:
        repos_count = search_github(keyword, language_filter)
        print("{} repositories results found: {}".format(keyword, repos_count))
        repos_results[keyword] = repos_count
        time.sleep(3)
    
    return repos_results

def print_repos_results(repos_results):
    df = pd.DataFrame(repos_results, index=['Repository results'])
    print(df)

def print_graph(repos_results, graph_type, title):
    keywords = repos_results.keys()
    results = repos_results.values()

    plt.figure(figsize=(9, 3))
    colors = generate_random_colors(len(keywords))

    if graph_type == "bar":
        plt.bar(keywords, results, color=colors)
    else:
        plt.scatter(keywords, results, color=colors)

    plt.suptitle(title)
    plt.show()


# Uncomment the three lines in each section to print either stats about:
# 1. Programming languages
# 2. Python modules
# 3. Python web frameworks
# NOTE: Comment the lines for the stats you are not interested in.

languages = ['Python', 'Java', 'Ruby', 'Javascript', 'PHP', 'Objective-C', 'Golang', 'Bash', 'Rust', 'Powershell']
languages_results = retrieve_repositories_results(languages)
print_graph(languages_results, "bar", "Programming Languages")

#modules = ['Pandas', 'NumPy', 'Tkinter', 'Pytest', 'Celery', 'Matplotlib', 'SciPy', 'lxml']
#modules_results = retrieve_repositories_results(modules, 'Python')
#print_graph(modules_results, "bar", "Python Modules")

#frameworks = ['Django', 'Flask', 'Tornado', 'CherryPy', 'web2py', 'Pylons', 'AIOHTTP', 'Bottle', 'Falcon']
#frameworks_results = retrieve_repositories_results(frameworks, 'Python')
#print_graph(frameworks_results, "scatter", "Python Frameworks")


