# Note: Execute each step individually by uncommenting the right line at the end of this program
# e.g. for Step 1 uncomment step1()
# Remember to uncomment only one step at the time

# Step 1: ERROR EXPECTED
# Observe the error coming back from this code
def step1():
    week_days = ['Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday']
    # Python expects three values in the list because 
    # we have three variables on the left side of the = sign
    day1, day2, day3 = week_days # This error is fixed in Step 2

# Step 2: NO ERROR EXPECTED
# This works fine because we have 7 variables on the left side of the = sign
def step2():
    week_days = ['Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday']
    day1, day2, day3, day4, day5, day6, day7 = week_days # No errors in this case
    print(day1, day2, day3, day4, day5, day6, day7)

# Step 3: ERROR EXPECTED
# Not enough values to assign
def step3():
    weekend_days = ['Saturday' , 'Sunday']
    # The left side of the expression below contains more variables than list items
    day1, day2, day3 = weekend_days # This error is fixed in Step 4

# Step 4: NO ERROR EXPECTED
def step4():
    weekend_days = ['Saturday' , 'Sunday']
    day1, day2 = weekend_days # No errors in this case
    print(day1, day2)

# Define a function that returns square and cube of a number
def getSquareAndCube(x):
    return x**2, x**3

# Step 5: ERROR EXPECTED
def step5():
    # Error raised because the function returns two values
    # and we have three values on the left of the = sign
    square, cube, other = getSquareAndCube(2) # Fixed in Step 6

# Step 6: NO ERROR EXPECTED
def step6():
    square, cube = getSquareAndCube(2) # No errors
    print(square, cube)

# Step 7: NO ERROR EXPECTED
# Assign values returned by the getSquareAndCube function to a single variable
def step7():
    output = getSquareAndCube(2)
    print(output)

# Step 8: ERROR EXPECTED
def step8():
    name, surname = input("Enter your name and surname: ") # Fixed in Step 9

# Step 9: 
# NO ERROR EXPECTED if you pass two strings (e.g. John Ross)
# ERROR EXPECTED if you pass more than two strings (e.g. Mr John Ross) - Fixed in Step 10
def step9():
    name, surname = input("Enter your name and surname: ").split()
    print(name, surname)

# Step 10: NO ERROR EXPECTED
# Pass maxsplit argument to the split() function
def step10():
    name, surname = input("Enter your name and surname: ").split(' ', 1)
    print(name, surname)

# Step 11: ERROR EXPECTED
# Error fixed in Step 12
def step11():
    users = {'username' : 'codefather', 'name' : 'Claudio'}
    for key, value in users:
        print(key, value)

# Step 12: NO ERROR EXPECTED
# Added .items() dictionary method.
def step12():
    users = {'username' : 'codefather', 'name' : 'Claudio'}
    for key, value in users.items():
        print(key, value)


#step1()
#step2()
#step3()
#step4()
#step5()
#step6()
#step7()
#step8()
#step9()
#step10()
#step11()
#step12()