import subprocess, sys, time
   
def lookup_domain(domain, lookup_command):
    if lookup_command == "whois":
        command = "whois {} | grep 'This query returned 0 objects'".format(domain)
    elif lookup_command == "nslookup":
        command = "nslookup {} | grep -i \"Can't find\"".format(domain) 
    else:
        print("Invalid domain lookup command provided. Exiting...")
        sys.exit() 

    command_output = subprocess.run(command, stdout=subprocess.PIPE, stderr=subprocess.PIPE, shell=True)

    if command_output.returncode == 0:
        print("Domain {} does not exist".format(domain))
    else:
        print("Domain {} exists".format(domain))


domain = input("Provide domain name: ")
lookup_command = input("Provide the command to perform domain lookup: ")
start_time = time.perf_counter()
lookup_domain(domain, lookup_command)
end_time = time.perf_counter()
print("Domain lookup executed in {} seconds".format(end_time - start_time))
