import subprocess, sys, time

def get_domains_from_file(filename):
    with open(filename) as f:
        return f.readlines()

def verify_domains(domains, lookup_command):
    for domain in domains:
        lookup_domain(domain.strip(), lookup_command)
   
def lookup_domain(domain, lookup_command):
    if lookup_command == "whois":
        command = "whois {} | grep 'This query returned 0 objects'".format(domain)
    elif lookup_command == "nslookup":
        command = "nslookup {} | grep -i \"Can't find\"".format(domain) 
    else:
        print("Invalid domain lookup command provided. Exiting...")
        sys.exit() 

    command_output = subprocess.run(command, stdout=subprocess.PIPE, stderr=subprocess.PIPE, shell=True)

    if command_output.returncode == 0:
        print("Domain {} does not exist".format(domain))
    else:
        print("Domain {} exists".format(domain))


lookup_command = input("Provide the command to perform domain lookup: ")
domains = get_domains_from_file('domains.txt')
verify_domains(domains, lookup_command)
