import pandas as pd

def step1(df):
    # Create a new dataframe with renamed columns
    new_df = df.rename(columns={"Countries":"Country", "Capitals":"Capital"})
    return new_df

def step2(df):
    # Replace columns in place
    df.rename(columns={"Countries":"Country", "Capitals":"Capital"}, inplace=True)
    return df

def step3(df):
    # Update only one column
    df.rename(columns={"Countries":"COUNTRY"}, inplace=True)
    return df

def step4(df):
    # Nothing changes in the dataframe if we pass a column name that doesn't exist
    df.rename(columns={"Population":"POPULATION"}, inplace=True)
    return df

def step5(df):
    # ERROR EXPECTED
    # Notice the difference if we pass the errors parameter
    df.rename(columns={"Population":"POPULATION"}, inplace=True, errors="raise")
    return df

def step6(df):
    # Rename the last column of the dataframe
    df.rename(columns={ df.columns[-1]: "CAPITAL" }, inplace = True)
    return df

def step7(df):
    # Rename columns using a list
    df.columns = ['CoUnTrIeS','CaPiTaLs']
    return df

def step8(df):
    # Rename columns to lowercase (using another Python function)
    df.rename(columns=str.lower, inplace=True)
    return df

def step9(df):
    # Rename columns using a lambda
    df.rename(columns=lambda x: x[:2], inplace=True)
    return df

def step10(df):
    # Rename index with dictionary
    df.rename(index={0:"Nation 0", 1: "Nation 1", 2: "Nation 2", 3: "Nation 3"}, inplace=True)
    return df

def step11(df):
    # Rename index with lambda (instead of passing a long dictionary)
    df.rename(index=lambda x: "Nation " + str(x), inplace=True)
    return df

def step12(df):
    # Rename columns using axis parameter
    # Equivalent of:
    # df.rename(columns={"Countries":"Country", "Capitals":"Capital"}, inplace=True)
    # axis='columns' is equivalent to axis=1
    df.rename({"Countries":"Country", "Capitals":"Capital"}, axis='columns', inplace=True)
    return df

def step13(df):
    # Rename index using axis parameter
    # Equivalent of:
    # df.rename(index=lambda x: "Nation " + str(x), inplace=True)
    # axis='index' is equivalent to axis=0 (default value for axis)
    df.rename(lambda x: "Nation " + str(x), axis='index', inplace=True)
    return df

def step14(df):
    # Update both columns and index
    df.rename(columns={"Countries":"Country", "Capitals":"Capital"}, index=lambda x: "Nation " + str(x), inplace=True)
    return df

def step15(df):
    # Add prefix to DataFrame columns
    return df.add_prefix('col_')

def step16(df):
    # Add suffix to DataFrame columns
    return df.add_suffix('_col')


# Main
dataframe = pd.DataFrame({"Countries": ["Italy","United Kingdom", "Germany", "Greece"], "Capitals": ["Rome","London","Berlin","Athens"]})
print("\n# Original dataframe #\n", dataframe)
# Update step1 to step2, step3, etc... to call a different function
update_function = step1
print("\n# Updated dataframe #\n", update_function(dataframe))


