# Example of search query for "mozart"
# https://www.youtube.com/results?search_query=mozart

# Step 1
# Retrieve the HTML of the Youtube page

# Step 2
# We are looking for the following pattern in the HTML:
# href="/watch?v=<11_characters_identifier>"
# That's because the format of the URL for any Youtube videos is:
# https://www.youtube.com/watch?v=<11_characters_identifier>
# To do that we use the regular expression pattern r"watch\?v=(\S{11})"

import urllib.request
import re

search_keyword="mozart"
html = urllib.request.urlopen("https://www.youtube.com/results?search_query=" + search_keyword)
video_ids = re.findall(r"watch\?v=(\S{11})", html.read().decode())
# Get URL for the first search result in Youtube that matches our search
print("https://www.youtube.com/watch?v=" + video_ids[0])