def verify_user(func):
    def wrapper(*args, **kwargs):
        print("Positional arguments:", args)
        print("Keyword arguments:", kwargs)

        if not user['logged_in']:
            print("ERROR: User {} is not logged in!".format(user['name']))
            return
        else:
            print("INFO: User {} is logged in".format(user['name']))
            return func(*args, **kwargs)

    return wrapper

@verify_user
def update_list(original_list, new_element, additional_element):
    original_list.append(new_element)
    original_list.append(additional_element)
    return original_list

numbers = [1, 2, 3]
user = {'name': 'codefather', 'logged_in': True}

# Call with positional arguments
print(update_list(numbers,5, 7))

# Call with keyword arguments
print(update_list(original_list=numbers, new_element=5, additional_element=7))