from functools import wraps

def verify_user(application_module):
    def decorator(func):
        
        @wraps(func)
        def wrapper(*args, **kwargs):
            """Wrapper function for verify_user decorator"""
            print("The name of the function called is", func.__name__)
            print("The docstring of the function called is", func.__doc__)

            print("Positional arguments:", args)
            print("Keyword arguments:", kwargs)

            if not user['logged_in']:
                print(application_module, "ERROR: User {} is not logged in!".format(user['name']))
                return
            else:
                print(application_module, "INFO: User {} is logged in".format(user['name']))
                return func(*args, **kwargs)

        return wrapper
    return decorator

@verify_user('SecurityModule')
def update_list(original_list, new_element, additional_element):
    """Add two elements to a list"""
    original_list.append(new_element)
    original_list.append(additional_element)
    return original_list

numbers = [1, 2, 3]
user = {'name': 'codefather', 'logged_in': True}
print(update_list(original_list=numbers, new_element=5, additional_element=7))

print("The name of the function called is", update_list.__name__)
print("The docstring of the function called is", update_list.__doc__)