from turtle import *

# Draw a complex picture made of multiples shapes

def turn_and_draw(turn_angle, draw_pixels):
    left(turn_angle)
    forward(draw_pixels)

def draw_generic_shape(turn_angle, draw_pixels, num_of_sides):
    begin_fill()

    side_count = 0

    while side_count < num_of_sides:
        pixels = draw_pixels

        if side_count == 0:
            angle = 0
        else:
            angle = turn_angle
        
        turn_and_draw(angle, pixels)
        side_count += 1
    
    end_fill()

def draw_star(x, y, *colors):
    penup()
    goto(x, y)
    pendown()
    color(*colors)
    draw_generic_shape(144, 250, 5)

def draw_circles(x, y, *colors):
    penup()
    goto(x, y)
    pendown()
    color(*colors)
    begin_fill()

    for x in range(6):
        circle(x*25)
    
    end_fill()

def draw_complex_star(x, y, *colors):
    penup()
    goto(x, y)
    pendown()
    color(*colors)
    begin_fill()

    side_count = 0
    initial_position = pos()

    while abs(pos()) > abs(initial_position) + 1 or side_count == 0:
        pixels = 250

        if side_count == 0:
            angle = 0
        else:
            angle = 162
        
        turn_and_draw(angle, pixels)
        side_count += 1

    end_fill()

def draw_triangle(x, y, *colors):
    penup()
    goto(x, y)
    pendown()
    color(*colors)
    begin_fill()

    side_count = 0

    while side_count < 3:
        if side_count == 0:
            pixels = 125
            angle = 0
        elif side_count == 1:
            pixels = 200
            angle = 108
        else:
            pixels = 200
            angle = 144
        
        turn_and_draw(angle, pixels)
        side_count += 1
    
    end_fill()

def draw_triangles(x, y, *colors):
    for count in range(1, 5):
        setheading(0)
        draw_triangle(-200*count/2, 50*count/2, *colors)


# Start drawing
speed(10)
draw_star(0, 150, 'green', 'blue')
draw_circles(0, 0, 'blue', 'yellow')
draw_complex_star(-150, -150, 'green', 'red')
draw_triangles(-150, 150, 'yellow', 'green')
done()