--
-- PostgreSQL database dump
--

-- Dumped from database version 9.6.3
-- Dumped by pg_dump version 9.6.3

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET row_security = off;

DROP DATABASE demo;
--
-- Name: demo; Type: DATABASE; Schema: -; Owner: -
--

CREATE DATABASE demo;


\connect demo

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET row_security = off;

--
-- Name: bookings; Type: SCHEMA; Schema: -; Owner: -
--

CREATE SCHEMA bookings;


--
-- Name: SCHEMA bookings; Type: COMMENT; Schema: -; Owner: -
--

COMMENT ON SCHEMA bookings IS 'Airlines demo database schema';


--
-- Name: plpgsql; Type: EXTENSION; Schema: -; Owner: -
--

CREATE EXTENSION IF NOT EXISTS plpgsql WITH SCHEMA pg_catalog;


--
-- Name: EXTENSION plpgsql; Type: COMMENT; Schema: -; Owner: -
--

COMMENT ON EXTENSION plpgsql IS 'PL/pgSQL procedural language';


SET search_path = bookings, pg_catalog;

--
-- Name: lang(); Type: FUNCTION; Schema: bookings; Owner: -
--

CREATE FUNCTION lang() RETURNS text
    LANGUAGE plpgsql STABLE
    AS $$
BEGIN
  RETURN current_setting('bookings.lang');
EXCEPTION
  WHEN undefined_object THEN
    RETURN NULL;
END;
$$;


--
-- Name: now(); Type: FUNCTION; Schema: bookings; Owner: -
--

CREATE FUNCTION now() RETURNS timestamp with time zone
    LANGUAGE sql IMMUTABLE
    AS $$SELECT '2017-08-15 18:00:00'::TIMESTAMP AT TIME ZONE 'Europe/Moscow';$$;


--
-- Name: FUNCTION now(); Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON FUNCTION now() IS 'Point in time according to which the data are generated';


SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: aircrafts_data; Type: TABLE; Schema: bookings; Owner: -
--

CREATE TABLE aircrafts_data (
    aircraft_code character(3) NOT NULL,
    model jsonb NOT NULL,
    range integer NOT NULL,
    CONSTRAINT aircrafts_range_check CHECK ((range > 0))
);


--
-- Name: TABLE aircrafts_data; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON TABLE aircrafts_data IS 'Aircrafts (internal data)';


--
-- Name: COLUMN aircrafts_data.aircraft_code; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON COLUMN aircrafts_data.aircraft_code IS 'Aircraft code, IATA';


--
-- Name: COLUMN aircrafts_data.model; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON COLUMN aircrafts_data.model IS 'Aircraft model';


--
-- Name: COLUMN aircrafts_data.range; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON COLUMN aircrafts_data.range IS 'Maximal flying distance, km';


--
-- Name: aircrafts; Type: VIEW; Schema: bookings; Owner: -
--

CREATE VIEW aircrafts AS
 SELECT ml.aircraft_code,
    (ml.model ->> lang()) AS model,
    ml.range
   FROM aircrafts_data ml;


--
-- Name: VIEW aircrafts; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON VIEW aircrafts IS 'Aircrafts';


--
-- Name: COLUMN aircrafts.aircraft_code; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON COLUMN aircrafts.aircraft_code IS 'Aircraft code, IATA';


--
-- Name: COLUMN aircrafts.model; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON COLUMN aircrafts.model IS 'Aircraft model';


--
-- Name: COLUMN aircrafts.range; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON COLUMN aircrafts.range IS 'Maximal flying distance, km';


--
-- Name: airports_data; Type: TABLE; Schema: bookings; Owner: -
--

CREATE TABLE airports_data (
    airport_code character(3) NOT NULL,
    airport_name jsonb NOT NULL,
    city jsonb NOT NULL,
    coordinates point NOT NULL,
    timezone text NOT NULL
);


--
-- Name: TABLE airports_data; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON TABLE airports_data IS 'Airports (internal data)';


--
-- Name: COLUMN airports_data.airport_code; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON COLUMN airports_data.airport_code IS 'Airport code';


--
-- Name: COLUMN airports_data.airport_name; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON COLUMN airports_data.airport_name IS 'Airport name';


--
-- Name: COLUMN airports_data.city; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON COLUMN airports_data.city IS 'City';


--
-- Name: COLUMN airports_data.coordinates; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON COLUMN airports_data.coordinates IS 'Airport coordinates (longitude and latitude)';


--
-- Name: COLUMN airports_data.timezone; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON COLUMN airports_data.timezone IS 'Airport time zone';


--
-- Name: airports; Type: VIEW; Schema: bookings; Owner: -
--

CREATE VIEW airports AS
 SELECT ml.airport_code,
    (ml.airport_name ->> lang()) AS airport_name,
    (ml.city ->> lang()) AS city,
    ml.coordinates,
    ml.timezone
   FROM airports_data ml;


--
-- Name: VIEW airports; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON VIEW airports IS 'Airports';


--
-- Name: COLUMN airports.airport_code; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON COLUMN airports.airport_code IS 'Airport code';


--
-- Name: COLUMN airports.airport_name; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON COLUMN airports.airport_name IS 'Airport name';


--
-- Name: COLUMN airports.city; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON COLUMN airports.city IS 'City';


--
-- Name: COLUMN airports.coordinates; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON COLUMN airports.coordinates IS 'Airport coordinates (longitude and latitude)';


--
-- Name: COLUMN airports.timezone; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON COLUMN airports.timezone IS 'Airport time zone';


--
-- Name: boarding_passes; Type: TABLE; Schema: bookings; Owner: -
--

CREATE TABLE boarding_passes (
    ticket_no character(13) NOT NULL,
    flight_id integer NOT NULL,
    boarding_no integer NOT NULL,
    seat_no character varying(4) NOT NULL
);


--
-- Name: TABLE boarding_passes; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON TABLE boarding_passes IS 'Boarding passes';


--
-- Name: COLUMN boarding_passes.ticket_no; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON COLUMN boarding_passes.ticket_no IS 'Ticket number';


--
-- Name: COLUMN boarding_passes.flight_id; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON COLUMN boarding_passes.flight_id IS 'Flight ID';


--
-- Name: COLUMN boarding_passes.boarding_no; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON COLUMN boarding_passes.boarding_no IS 'Boarding pass number';


--
-- Name: COLUMN boarding_passes.seat_no; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON COLUMN boarding_passes.seat_no IS 'Seat number';


--
-- Name: bookings; Type: TABLE; Schema: bookings; Owner: -
--

CREATE TABLE bookings (
    book_ref character(6) NOT NULL,
    book_date timestamp with time zone NOT NULL,
    total_amount numeric(10,2) NOT NULL
);


--
-- Name: TABLE bookings; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON TABLE bookings IS 'Bookings';


--
-- Name: COLUMN bookings.book_ref; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON COLUMN bookings.book_ref IS 'Booking number';


--
-- Name: COLUMN bookings.book_date; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON COLUMN bookings.book_date IS 'Booking date';


--
-- Name: COLUMN bookings.total_amount; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON COLUMN bookings.total_amount IS 'Total booking cost';


--
-- Name: flights; Type: TABLE; Schema: bookings; Owner: -
--

CREATE TABLE flights (
    flight_id integer NOT NULL,
    flight_no character(6) NOT NULL,
    scheduled_departure timestamp with time zone NOT NULL,
    scheduled_arrival timestamp with time zone NOT NULL,
    departure_airport character(3) NOT NULL,
    arrival_airport character(3) NOT NULL,
    status character varying(20) NOT NULL,
    aircraft_code character(3) NOT NULL,
    actual_departure timestamp with time zone,
    actual_arrival timestamp with time zone,
    CONSTRAINT flights_check CHECK ((scheduled_arrival > scheduled_departure)),
    CONSTRAINT flights_check1 CHECK (((actual_arrival IS NULL) OR ((actual_departure IS NOT NULL) AND (actual_arrival IS NOT NULL) AND (actual_arrival > actual_departure)))),
    CONSTRAINT flights_status_check CHECK (((status)::text = ANY (ARRAY[('On Time'::character varying)::text, ('Delayed'::character varying)::text, ('Departed'::character varying)::text, ('Arrived'::character varying)::text, ('Scheduled'::character varying)::text, ('Cancelled'::character varying)::text])))
);


--
-- Name: TABLE flights; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON TABLE flights IS 'Flights';


--
-- Name: COLUMN flights.flight_id; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON COLUMN flights.flight_id IS 'Flight ID';


--
-- Name: COLUMN flights.flight_no; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON COLUMN flights.flight_no IS 'Flight number';


--
-- Name: COLUMN flights.scheduled_departure; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON COLUMN flights.scheduled_departure IS 'Scheduled departure time';


--
-- Name: COLUMN flights.scheduled_arrival; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON COLUMN flights.scheduled_arrival IS 'Scheduled arrival time';


--
-- Name: COLUMN flights.departure_airport; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON COLUMN flights.departure_airport IS 'Airport of departure';


--
-- Name: COLUMN flights.arrival_airport; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON COLUMN flights.arrival_airport IS 'Airport of arrival';


--
-- Name: COLUMN flights.status; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON COLUMN flights.status IS 'Flight status';


--
-- Name: COLUMN flights.aircraft_code; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON COLUMN flights.aircraft_code IS 'Aircraft code, IATA';


--
-- Name: COLUMN flights.actual_departure; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON COLUMN flights.actual_departure IS 'Actual departure time';


--
-- Name: COLUMN flights.actual_arrival; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON COLUMN flights.actual_arrival IS 'Actual arrival time';


--
-- Name: flights_flight_id_seq; Type: SEQUENCE; Schema: bookings; Owner: -
--

CREATE SEQUENCE flights_flight_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: flights_flight_id_seq; Type: SEQUENCE OWNED BY; Schema: bookings; Owner: -
--

ALTER SEQUENCE flights_flight_id_seq OWNED BY flights.flight_id;


--
-- Name: flights_v; Type: VIEW; Schema: bookings; Owner: -
--

CREATE VIEW flights_v AS
 SELECT f.flight_id,
    f.flight_no,
    f.scheduled_departure,
    timezone(dep.timezone, f.scheduled_departure) AS scheduled_departure_local,
    f.scheduled_arrival,
    timezone(arr.timezone, f.scheduled_arrival) AS scheduled_arrival_local,
    (f.scheduled_arrival - f.scheduled_departure) AS scheduled_duration,
    f.departure_airport,
    dep.airport_name AS departure_airport_name,
    dep.city AS departure_city,
    f.arrival_airport,
    arr.airport_name AS arrival_airport_name,
    arr.city AS arrival_city,
    f.status,
    f.aircraft_code,
    f.actual_departure,
    timezone(dep.timezone, f.actual_departure) AS actual_departure_local,
    f.actual_arrival,
    timezone(arr.timezone, f.actual_arrival) AS actual_arrival_local,
    (f.actual_arrival - f.actual_departure) AS actual_duration
   FROM flights f,
    airports dep,
    airports arr
  WHERE ((f.departure_airport = dep.airport_code) AND (f.arrival_airport = arr.airport_code));


--
-- Name: VIEW flights_v; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON VIEW flights_v IS 'Flights (extended)';


--
-- Name: COLUMN flights_v.flight_id; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON COLUMN flights_v.flight_id IS 'Flight ID';


--
-- Name: COLUMN flights_v.flight_no; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON COLUMN flights_v.flight_no IS 'Flight number';


--
-- Name: COLUMN flights_v.scheduled_departure; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON COLUMN flights_v.scheduled_departure IS 'Scheduled departure time';


--
-- Name: COLUMN flights_v.scheduled_departure_local; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON COLUMN flights_v.scheduled_departure_local IS 'Scheduled departure time, local time at the point of departure';


--
-- Name: COLUMN flights_v.scheduled_arrival; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON COLUMN flights_v.scheduled_arrival IS 'Scheduled arrival time';


--
-- Name: COLUMN flights_v.scheduled_arrival_local; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON COLUMN flights_v.scheduled_arrival_local IS 'Scheduled arrival time, local time at the point of destination';


--
-- Name: COLUMN flights_v.scheduled_duration; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON COLUMN flights_v.scheduled_duration IS 'Scheduled flight duration';


--
-- Name: COLUMN flights_v.departure_airport; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON COLUMN flights_v.departure_airport IS 'Deprature airport code';


--
-- Name: COLUMN flights_v.departure_airport_name; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON COLUMN flights_v.departure_airport_name IS 'Departure airport name';


--
-- Name: COLUMN flights_v.departure_city; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON COLUMN flights_v.departure_city IS 'City of departure';


--
-- Name: COLUMN flights_v.arrival_airport; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON COLUMN flights_v.arrival_airport IS 'Arrival airport code';


--
-- Name: COLUMN flights_v.arrival_airport_name; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON COLUMN flights_v.arrival_airport_name IS 'Arrival airport name';


--
-- Name: COLUMN flights_v.arrival_city; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON COLUMN flights_v.arrival_city IS 'City of arrival';


--
-- Name: COLUMN flights_v.status; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON COLUMN flights_v.status IS 'Flight status';


--
-- Name: COLUMN flights_v.aircraft_code; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON COLUMN flights_v.aircraft_code IS 'Aircraft code, IATA';


--
-- Name: COLUMN flights_v.actual_departure; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON COLUMN flights_v.actual_departure IS 'Actual departure time';


--
-- Name: COLUMN flights_v.actual_departure_local; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON COLUMN flights_v.actual_departure_local IS 'Actual departure time, local time at the point of departure';


--
-- Name: COLUMN flights_v.actual_arrival; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON COLUMN flights_v.actual_arrival IS 'Actual arrival time';


--
-- Name: COLUMN flights_v.actual_arrival_local; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON COLUMN flights_v.actual_arrival_local IS 'Actual arrival time, local time at the point of destination';


--
-- Name: COLUMN flights_v.actual_duration; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON COLUMN flights_v.actual_duration IS 'Actual flight duration';


--
-- Name: routes; Type: VIEW; Schema: bookings; Owner: -
--

CREATE VIEW routes AS
 WITH f3 AS (
         SELECT f2.flight_no,
            f2.departure_airport,
            f2.arrival_airport,
            f2.aircraft_code,
            f2.duration,
            array_agg(f2.days_of_week) AS days_of_week
           FROM ( SELECT f1.flight_no,
                    f1.departure_airport,
                    f1.arrival_airport,
                    f1.aircraft_code,
                    f1.duration,
                    f1.days_of_week
                   FROM ( SELECT flights.flight_no,
                            flights.departure_airport,
                            flights.arrival_airport,
                            flights.aircraft_code,
                            (flights.scheduled_arrival - flights.scheduled_departure) AS duration,
                            (to_char(flights.scheduled_departure, 'ID'::text))::integer AS days_of_week
                           FROM flights) f1
                  GROUP BY f1.flight_no, f1.departure_airport, f1.arrival_airport, f1.aircraft_code, f1.duration, f1.days_of_week
                  ORDER BY f1.flight_no, f1.departure_airport, f1.arrival_airport, f1.aircraft_code, f1.duration, f1.days_of_week) f2
          GROUP BY f2.flight_no, f2.departure_airport, f2.arrival_airport, f2.aircraft_code, f2.duration
        )
 SELECT f3.flight_no,
    f3.departure_airport,
    dep.airport_name AS departure_airport_name,
    dep.city AS departure_city,
    f3.arrival_airport,
    arr.airport_name AS arrival_airport_name,
    arr.city AS arrival_city,
    f3.aircraft_code,
    f3.duration,
    f3.days_of_week
   FROM f3,
    airports dep,
    airports arr
  WHERE ((f3.departure_airport = dep.airport_code) AND (f3.arrival_airport = arr.airport_code));


--
-- Name: VIEW routes; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON VIEW routes IS 'Routes';


--
-- Name: COLUMN routes.flight_no; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON COLUMN routes.flight_no IS 'Flight number';


--
-- Name: COLUMN routes.departure_airport; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON COLUMN routes.departure_airport IS 'Code of airport of departure';


--
-- Name: COLUMN routes.departure_airport_name; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON COLUMN routes.departure_airport_name IS 'Name of airport of departure';


--
-- Name: COLUMN routes.departure_city; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON COLUMN routes.departure_city IS 'City of departure';


--
-- Name: COLUMN routes.arrival_airport; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON COLUMN routes.arrival_airport IS 'Code of airport of arrival';


--
-- Name: COLUMN routes.arrival_airport_name; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON COLUMN routes.arrival_airport_name IS 'Name of airport of arrival';


--
-- Name: COLUMN routes.arrival_city; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON COLUMN routes.arrival_city IS 'City of arrival';


--
-- Name: COLUMN routes.aircraft_code; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON COLUMN routes.aircraft_code IS 'Aircraft code, IATA';


--
-- Name: COLUMN routes.duration; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON COLUMN routes.duration IS 'Scheduled duration of flight';


--
-- Name: COLUMN routes.days_of_week; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON COLUMN routes.days_of_week IS 'Days of week on which flights are scheduled';


--
-- Name: seats; Type: TABLE; Schema: bookings; Owner: -
--

CREATE TABLE seats (
    aircraft_code character(3) NOT NULL,
    seat_no character varying(4) NOT NULL,
    fare_conditions character varying(10) NOT NULL,
    CONSTRAINT seats_fare_conditions_check CHECK (((fare_conditions)::text = ANY (ARRAY[('Economy'::character varying)::text, ('Comfort'::character varying)::text, ('Business'::character varying)::text])))
);


--
-- Name: TABLE seats; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON TABLE seats IS 'Seats';


--
-- Name: COLUMN seats.aircraft_code; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON COLUMN seats.aircraft_code IS 'Aircraft code, IATA';


--
-- Name: COLUMN seats.seat_no; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON COLUMN seats.seat_no IS 'Seat number';


--
-- Name: COLUMN seats.fare_conditions; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON COLUMN seats.fare_conditions IS 'Travel class';


--
-- Name: ticket_flights; Type: TABLE; Schema: bookings; Owner: -
--

CREATE TABLE ticket_flights (
    ticket_no character(13) NOT NULL,
    flight_id integer NOT NULL,
    fare_conditions character varying(10) NOT NULL,
    amount numeric(10,2) NOT NULL,
    CONSTRAINT ticket_flights_amount_check CHECK ((amount >= (0)::numeric)),
    CONSTRAINT ticket_flights_fare_conditions_check CHECK (((fare_conditions)::text = ANY (ARRAY[('Economy'::character varying)::text, ('Comfort'::character varying)::text, ('Business'::character varying)::text])))
);


--
-- Name: TABLE ticket_flights; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON TABLE ticket_flights IS 'Flight segment';


--
-- Name: COLUMN ticket_flights.ticket_no; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON COLUMN ticket_flights.ticket_no IS 'Ticket number';


--
-- Name: COLUMN ticket_flights.flight_id; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON COLUMN ticket_flights.flight_id IS 'Flight ID';


--
-- Name: COLUMN ticket_flights.fare_conditions; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON COLUMN ticket_flights.fare_conditions IS 'Travel class';


--
-- Name: COLUMN ticket_flights.amount; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON COLUMN ticket_flights.amount IS 'Travel cost';


--
-- Name: tickets; Type: TABLE; Schema: bookings; Owner: -
--

CREATE TABLE tickets (
    ticket_no character(13) NOT NULL,
    book_ref character(6) NOT NULL,
    passenger_id character varying(20) NOT NULL,
    passenger_name text NOT NULL,
    contact_data jsonb
);


--
-- Name: TABLE tickets; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON TABLE tickets IS 'Tickets';


--
-- Name: COLUMN tickets.ticket_no; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON COLUMN tickets.ticket_no IS 'Ticket number';


--
-- Name: COLUMN tickets.book_ref; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON COLUMN tickets.book_ref IS 'Booking number';


--
-- Name: COLUMN tickets.passenger_id; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON COLUMN tickets.passenger_id IS 'Passenger ID';


--
-- Name: COLUMN tickets.passenger_name; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON COLUMN tickets.passenger_name IS 'Passenger name';


--
-- Name: COLUMN tickets.contact_data; Type: COMMENT; Schema: bookings; Owner: -
--

COMMENT ON COLUMN tickets.contact_data IS 'Passenger contact information';


--
-- Name: flights flight_id; Type: DEFAULT; Schema: bookings; Owner: -
--

ALTER TABLE ONLY flights ALTER COLUMN flight_id SET DEFAULT nextval('flights_flight_id_seq'::regclass);


--
-- Data for Name: aircrafts_data; Type: TABLE DATA; Schema: bookings; Owner: -
--

COPY aircrafts_data (aircraft_code, model, range) FROM stdin;
773	{"en": "Boeing 777-300", "ru": "Боинг 777-300"}	11100
763	{"en": "Boeing 767-300", "ru": "Боинг 767-300"}	7900
SU9	{"en": "Sukhoi Superjet-100", "ru": "Сухой Суперджет-100"}	3000
320	{"en": "Airbus A320-200", "ru": "Аэробус A320-200"}	5700
321	{"en": "Airbus A321-200", "ru": "Аэробус A321-200"}	5600
319	{"en": "Airbus A319-100", "ru": "Аэробус A319-100"}	6700
733	{"en": "Boeing 737-300", "ru": "Боинг 737-300"}	4200
CN1	{"en": "Cessna 208 Caravan", "ru": "Сессна 208 Караван"}	1200
CR2	{"en": "Bombardier CRJ-200", "ru": "Бомбардье CRJ-200"}	2700
\.


--
-- Data for Name: airports_data; Type: TABLE DATA; Schema: bookings; Owner: -
--

COPY airports_data (airport_code, airport_name, city, coordinates, timezone) FROM stdin;
YKS	{"en": "Yakutsk Airport", "ru": "Якутск"}	{"en": "Yakutsk", "ru": "Якутск"}	(129.77099609375,62.0932998657226562)	Asia/Yakutsk
MJZ	{"en": "Mirny Airport", "ru": "Мирный"}	{"en": "Mirnyj", "ru": "Мирный"}	(114.03900146484375,62.534698486328125)	Asia/Yakutsk
KHV	{"en": "Khabarovsk-Novy Airport", "ru": "Хабаровск-Новый"}	{"en": "Khabarovsk", "ru": "Хабаровск"}	(135.18800354004,48.5279998779300001)	Asia/Vladivostok
PKC	{"en": "Yelizovo Airport", "ru": "Елизово"}	{"en": "Petropavlovsk", "ru": "Петропавловск-Камчатский"}	(158.453994750976562,53.1679000854492188)	Asia/Kamchatka
UUS	{"en": "Yuzhno-Sakhalinsk Airport", "ru": "Хомутово"}	{"en": "Yuzhno-Sakhalinsk", "ru": "Южно-Сахалинск"}	(142.718002319335938,46.8886985778808594)	Asia/Sakhalin
VVO	{"en": "Vladivostok International Airport", "ru": "Владивосток"}	{"en": "Vladivostok", "ru": "Владивосток"}	(132.147994995117188,43.3989982604980469)	Asia/Vladivostok
LED	{"en": "Pulkovo Airport", "ru": "Пулково"}	{"en": "St. Petersburg", "ru": "Санкт-Петербург"}	(30.2625007629394531,59.8003005981445312)	Europe/Moscow
KGD	{"en": "Khrabrovo Airport", "ru": "Храброво"}	{"en": "Kaliningrad", "ru": "Калининград"}	(20.5925998687744141,54.8899993896484375)	Europe/Kaliningrad
KEJ	{"en": "Kemerovo Airport", "ru": "Кемерово"}	{"en": "Kemorovo", "ru": "Кемерово"}	(86.1072006225585938,55.2700996398925781)	Asia/Novokuznetsk
CEK	{"en": "Chelyabinsk Balandino Airport", "ru": "Челябинск"}	{"en": "Chelyabinsk", "ru": "Челябинск"}	(61.503300000000003,55.3058010000000024)	Asia/Yekaterinburg
MQF	{"en": "Magnitogorsk International Airport", "ru": "Магнитогорск"}	{"en": "Magnetiogorsk", "ru": "Магнитогорск"}	(58.7556991577148438,53.3931007385253906)	Asia/Yekaterinburg
PEE	{"en": "Bolshoye Savino Airport", "ru": "Пермь"}	{"en": "Perm", "ru": "Пермь"}	(56.021198272705,57.9145011901860016)	Asia/Yekaterinburg
SGC	{"en": "Surgut Airport", "ru": "Сургут"}	{"en": "Surgut", "ru": "Сургут"}	(73.4018020629882812,61.3437004089355469)	Asia/Yekaterinburg
BZK	{"en": "Bryansk Airport", "ru": "Брянск"}	{"en": "Bryansk", "ru": "Брянск"}	(34.1763992309999978,53.2141990661999955)	Europe/Moscow
MRV	{"en": "Mineralnyye Vody Airport", "ru": "Минеральные Воды"}	{"en": "Mineralnye Vody", "ru": "Минеральные Воды"}	(43.0819015502929688,44.2251014709472656)	Europe/Moscow
STW	{"en": "Stavropol Shpakovskoye Airport", "ru": "Ставрополь"}	{"en": "Stavropol", "ru": "Ставрополь"}	(42.1128005981445312,45.1091995239257812)	Europe/Moscow
ASF	{"en": "Astrakhan Airport", "ru": "Астрахань"}	{"en": "Astrakhan", "ru": "Астрахань"}	(48.0063018799000005,46.2832984924000002)	Europe/Samara
NJC	{"en": "Nizhnevartovsk Airport", "ru": "Нижневартовск"}	{"en": "Nizhnevartovsk", "ru": "Нижневартовск"}	(76.4835968017578125,60.9492988586425781)	Asia/Yekaterinburg
SVX	{"en": "Koltsovo Airport", "ru": "Кольцово"}	{"en": "Yekaterinburg", "ru": "Екатеринбург"}	(60.8027000427250002,56.7430992126460012)	Asia/Yekaterinburg
SVO	{"en": "Sheremetyevo International Airport", "ru": "Шереметьево"}	{"en": "Moscow", "ru": "Москва"}	(37.4146000000000001,55.9725990000000024)	Europe/Moscow
VOZ	{"en": "Voronezh International Airport", "ru": "Воронеж"}	{"en": "Voronezh", "ru": "Воронеж"}	(39.2295989990234375,51.8142013549804688)	Europe/Moscow
VKO	{"en": "Vnukovo International Airport", "ru": "Внуково"}	{"en": "Moscow", "ru": "Москва"}	(37.2615013122999983,55.5914993286000012)	Europe/Moscow
SCW	{"en": "Syktyvkar Airport", "ru": "Сыктывкар"}	{"en": "Syktyvkar", "ru": "Сыктывкар"}	(50.8451004028320312,61.6469993591308594)	Europe/Moscow
KUF	{"en": "Kurumoch International Airport", "ru": "Курумоч"}	{"en": "Samara", "ru": "Самара"}	(50.1642990112299998,53.5049018859860013)	Europe/Samara
DME	{"en": "Domodedovo International Airport", "ru": "Домодедово"}	{"en": "Moscow", "ru": "Москва"}	(37.9062995910644531,55.4087982177734375)	Europe/Moscow
TJM	{"en": "Roshchino International Airport", "ru": "Рощино"}	{"en": "Tyumen", "ru": "Тюмень"}	(65.3243026732999965,57.1896018981999958)	Asia/Yekaterinburg
GOJ	{"en": "Nizhny Novgorod Strigino International Airport", "ru": "Стригино"}	{"en": "Nizhniy Novgorod", "ru": "Нижний Новгород"}	(43.7840003967289988,56.2300987243649999)	Europe/Moscow
TOF	{"en": "Bogashevo Airport", "ru": "Богашёво"}	{"en": "Tomsk", "ru": "Томск"}	(85.2082977294920028,56.3802986145020029)	Asia/Krasnoyarsk
UIK	{"en": "Ust-Ilimsk Airport", "ru": "Усть-Илимск"}	{"en": "Ust Ilimsk", "ru": "Усть-Илимск"}	(102.56500244140625,58.1361007690429688)	Asia/Irkutsk
NSK	{"en": "Norilsk-Alykel Airport", "ru": "Норильск"}	{"en": "Norilsk", "ru": "Норильск"}	(87.3321990966796875,69.31109619140625)	Asia/Krasnoyarsk
ARH	{"en": "Talagi Airport", "ru": "Талаги"}	{"en": "Arkhangelsk", "ru": "Архангельск"}	(40.7167015075683594,64.6003036499023438)	Europe/Moscow
RTW	{"en": "Saratov Central Airport", "ru": "Саратов-Центральный"}	{"en": "Saratov", "ru": "Саратов"}	(46.0466995239257812,51.5649986267089844)	Europe/Volgograd
NUX	{"en": "Novy Urengoy Airport", "ru": "Новый Уренгой"}	{"en": "Novy Urengoy", "ru": "Новый Уренгой"}	(76.5203018188476562,66.06939697265625)	Asia/Yekaterinburg
NOJ	{"en": "Noyabrsk Airport", "ru": "Ноябрьск"}	{"en": "Noyabrsk", "ru": "Ноябрьск"}	(75.2699966430664062,63.1833000183105469)	Asia/Yekaterinburg
UCT	{"en": "Ukhta Airport", "ru": "Ухта"}	{"en": "Ukhta", "ru": "Ухта"}	(53.8046989440917969,63.5668983459472656)	Europe/Moscow
USK	{"en": "Usinsk Airport", "ru": "Усинск"}	{"en": "Usinsk", "ru": "Усинск"}	(57.3671989440917969,66.00469970703125)	Europe/Moscow
NNM	{"en": "Naryan Mar Airport", "ru": "Нарьян-Мар"}	{"en": "Naryan-Mar", "ru": "Нарьян-Мар"}	(53.1218986511230469,67.6399993896484375)	Europe/Moscow
PKV	{"en": "Pskov Airport", "ru": "Псков"}	{"en": "Pskov", "ru": "Псков"}	(28.395599365234375,57.7839012145996094)	Europe/Moscow
KGP	{"en": "Kogalym International Airport", "ru": "Когалым"}	{"en": "Kogalym", "ru": "Когалым"}	(74.5337982177734375,62.190399169921875)	Asia/Yekaterinburg
KJA	{"en": "Yemelyanovo Airport", "ru": "Емельяново"}	{"en": "Krasnoyarsk", "ru": "Красноярск"}	(92.493301391602003,56.1729011535639984)	Asia/Krasnoyarsk
URJ	{"en": "Uray Airport", "ru": "Петрозаводск"}	{"en": "Uraj", "ru": "Урай"}	(64.8266983032226562,60.1032981872558594)	Asia/Yekaterinburg
IWA	{"en": "Ivanovo South Airport", "ru": "Иваново-Южный"}	{"en": "Ivanovo", "ru": "Иваново"}	(40.9407997131347656,56.9393997192382812)	Europe/Moscow
PYJ	{"en": "Polyarny Airport", "ru": "Полярный"}	{"en": "Yakutia", "ru": "Удачный"}	(112.029998778999996,66.4003982544000024)	Asia/Yakutsk
KXK	{"en": "Komsomolsk-on-Amur Airport", "ru": "Хурба"}	{"en": "Komsomolsk-on-Amur", "ru": "Комсомольск-на-Амуре"}	(136.934005737304688,50.4090003967285156)	Asia/Vladivostok
DYR	{"en": "Ugolny Airport", "ru": "Анадырь"}	{"en": "Anadyr", "ru": "Анадырь"}	(177.740997314453125,64.7349014282226562)	Asia/Anadyr
PES	{"en": "Petrozavodsk Airport", "ru": "Бесовец"}	{"en": "Petrozavodsk", "ru": "Петрозаводск"}	(34.1547012329101562,61.8852005004882812)	Europe/Moscow
KYZ	{"en": "Kyzyl Airport", "ru": "Кызыл"}	{"en": "Kyzyl", "ru": "Кызыл"}	(94.4005966186523438,51.6693992614746094)	Asia/Krasnoyarsk
NOZ	{"en": "Spichenkovo Airport", "ru": "Спиченково"}	{"en": "Novokuznetsk", "ru": "Новокузнецк"}	(86.877197265625,53.8114013671875)	Asia/Novokuznetsk
GRV	{"en": "Khankala Air Base", "ru": "Грозный"}	{"en": "Grozny", "ru": "Грозный"}	(45.7840995788574219,43.2980995178222656)	Europe/Moscow
NAL	{"en": "Nalchik Airport", "ru": "Нальчик"}	{"en": "Nalchik", "ru": "Нальчик"}	(43.6366004943847656,43.5129013061523438)	Europe/Moscow
OGZ	{"en": "Beslan Airport", "ru": "Беслан"}	{"en": "Beslan", "ru": "Владикавказ"}	(44.6066017150999983,43.2051010132000002)	Europe/Moscow
ESL	{"en": "Elista Airport", "ru": "Элиста"}	{"en": "Elista", "ru": "Элиста"}	(44.3308982849121094,46.3739013671875)	Europe/Moscow
SLY	{"en": "Salekhard Airport", "ru": "Салехард"}	{"en": "Salekhard", "ru": "Салехард"}	(66.6110000610351562,66.5907974243164062)	Asia/Yekaterinburg
HMA	{"en": "Khanty Mansiysk Airport", "ru": "Ханты-Мансийск"}	{"en": "Khanty-Mansiysk", "ru": "Ханты-Мансийск"}	(69.0860977172851562,61.0284996032714844)	Asia/Yekaterinburg
NYA	{"en": "Nyagan Airport", "ru": "Нягань"}	{"en": "Nyagan", "ru": "Нягань"}	(65.6149978637695312,62.1100006103515625)	Asia/Yekaterinburg
OVS	{"en": "Sovetskiy Airport", "ru": "Советский"}	{"en": "Sovetskiy", "ru": "Советский"}	(63.6019134521484375,61.3266220092773438)	Asia/Yekaterinburg
IJK	{"en": "Izhevsk Airport", "ru": "Ижевск"}	{"en": "Izhevsk", "ru": "Ижевск"}	(53.4575004577636719,56.8280982971191406)	Europe/Samara
KVX	{"en": "Pobedilovo Airport", "ru": "Победилово"}	{"en": "Kirov", "ru": "Киров"}	(49.3483009338379972,58.5032997131350001)	Europe/Moscow
NYM	{"en": "Nadym Airport", "ru": "Надым"}	{"en": "Nadym", "ru": "Надым"}	(72.6988983154296875,65.4809036254882812)	Asia/Yekaterinburg
NFG	{"en": "Nefteyugansk Airport", "ru": "Нефтеюганск"}	{"en": "Nefteyugansk", "ru": "Нефтеюганск"}	(72.6500015258789062,61.1082992553710938)	Asia/Yekaterinburg
KRO	{"en": "Kurgan Airport", "ru": "Курган"}	{"en": "Kurgan", "ru": "Курган"}	(65.4156036376953125,55.4752998352050781)	Asia/Yekaterinburg
EGO	{"en": "Belgorod International Airport", "ru": "Белгород"}	{"en": "Belgorod", "ru": "Белгород"}	(36.5900993347167969,50.643798828125)	Europe/Moscow
URS	{"en": "Kursk East Airport", "ru": "Курск-Восточный"}	{"en": "Kursk", "ru": "Курск"}	(36.2956008911132812,51.7505989074707031)	Europe/Moscow
LPK	{"en": "Lipetsk Airport", "ru": "Липецк"}	{"en": "Lipetsk", "ru": "Липецк"}	(39.5377998352050781,52.7028007507324219)	Europe/Moscow
VKT	{"en": "Vorkuta Airport", "ru": "Воркута"}	{"en": "Vorkuta", "ru": "Воркута"}	(63.9930992126464844,67.4886016845703125)	Europe/Moscow
UUA	{"en": "Bugulma Airport", "ru": "Бугульма"}	{"en": "Bugulma", "ru": "Бугульма"}	(52.8017005920410156,54.6399993896484375)	Europe/Moscow
JOK	{"en": "Yoshkar-Ola Airport", "ru": "Йошкар-Ола"}	{"en": "Yoshkar-Ola", "ru": "Йошкар-Ола"}	(47.9047012329101562,56.7005996704101562)	Europe/Moscow
CSY	{"en": "Cheboksary Airport", "ru": "Чебоксары"}	{"en": "Cheboksary", "ru": "Чебоксары"}	(47.3473014831542969,56.090301513671875)	Europe/Moscow
ULY	{"en": "Ulyanovsk East Airport", "ru": "Ульяновск-Восточный"}	{"en": "Ulyanovsk", "ru": "Ульяновск"}	(48.8027000427246094,54.4010009765625)	Europe/Samara
OSW	{"en": "Orsk Airport", "ru": "Орск"}	{"en": "Orsk", "ru": "Орск"}	(58.5956001281738281,51.0724983215332031)	Asia/Yekaterinburg
PEZ	{"en": "Penza Airport", "ru": "Пенза"}	{"en": "Penza", "ru": "Пенза"}	(45.0210990905761719,53.1105995178222656)	Europe/Moscow
SKX	{"en": "Saransk Airport", "ru": "Саранск"}	{"en": "Saransk", "ru": "Саранск"}	(45.2122573852539062,54.1251296997070312)	Europe/Moscow
TBW	{"en": "Donskoye Airport", "ru": "Донское"}	{"en": "Tambow", "ru": "Тамбов"}	(41.4827995300289984,52.806098937987997)	Europe/Moscow
UKX	{"en": "Ust-Kut Airport", "ru": "Усть-Кут"}	{"en": "Ust-Kut", "ru": "Усть-Кут"}	(105.730003356933594,56.8567008972167969)	Asia/Irkutsk
GDZ	{"en": "Gelendzhik Airport", "ru": "Геленджик"}	{"en": "Gelendzhik", "ru": "Геленджик"}	(38.012480735799997,44.5820926295000035)	Europe/Moscow
IAR	{"en": "Tunoshna Airport", "ru": "Туношна"}	{"en": "Yaroslavl", "ru": "Ярославль"}	(40.1573982238769531,57.560699462890625)	Europe/Moscow
NBC	{"en": "Begishevo Airport", "ru": "Бегишево"}	{"en": "Nizhnekamsk", "ru": "Нижнекамск"}	(52.092498779296875,55.5647010803222656)	Europe/Moscow
ULV	{"en": "Ulyanovsk Baratayevka Airport", "ru": "Баратаевка"}	{"en": "Ulyanovsk", "ru": "Ульяновск"}	(48.2266998291000064,54.2682991027999932)	Europe/Samara
SWT	{"en": "Strezhevoy Airport", "ru": "Стрежевой"}	{"en": "Strezhevoy", "ru": "Стрежевой"}	(77.66000366210001,60.7094001769999991)	Asia/Krasnoyarsk
EYK	{"en": "Beloyarskiy Airport", "ru": "Белоярский"}	{"en": "Beloyarsky", "ru": "Белоярский"}	(66.6986007689999951,63.6869010924999941)	Asia/Yekaterinburg
KLF	{"en": "Grabtsevo Airport", "ru": "Калуга"}	{"en": "Kaluga", "ru": "Калуга"}	(36.3666687011999983,54.5499992371000033)	Europe/Moscow
RGK	{"en": "Gorno-Altaysk Airport", "ru": "Горно-Алтайск"}	{"en": "Gorno-Altaysk", "ru": "Горно-Алтайск"}	(85.8332977295000035,51.9667015075999998)	Asia/Krasnoyarsk
KRR	{"en": "Krasnodar Pashkovsky International Airport", "ru": "Краснодар"}	{"en": "Krasnodar", "ru": "Краснодар"}	(39.1705017089839984,45.0346984863279971)	Europe/Moscow
MCX	{"en": "Uytash Airport", "ru": "Уйташ"}	{"en": "Makhachkala", "ru": "Махачкала"}	(47.6523017883300781,42.8167991638183594)	Europe/Moscow
KZN	{"en": "Kazan International Airport", "ru": "Казань"}	{"en": "Kazan", "ru": "Казань"}	(49.278701782227003,55.606201171875)	Europe/Moscow
REN	{"en": "Orenburg Central Airport", "ru": "Оренбург-Центральный"}	{"en": "Orenburg", "ru": "Оренбург"}	(55.4566993713378906,51.7957992553710938)	Asia/Yekaterinburg
UFA	{"en": "Ufa International Airport", "ru": "Уфа"}	{"en": "Ufa", "ru": "Уфа"}	(55.8744010925289984,54.5574989318850001)	Asia/Yekaterinburg
OVB	{"en": "Tolmachevo Airport", "ru": "Толмачёво"}	{"en": "Novosibirsk", "ru": "Новосибирск"}	(82.6507034301759944,55.012599945067997)	Asia/Novosibirsk
CEE	{"en": "Cherepovets Airport", "ru": "Череповец"}	{"en": "Cherepovets", "ru": "Череповец"}	(38.0158004761000043,59.2736015320000007)	Europe/Moscow
OMS	{"en": "Omsk Central Airport", "ru": "Омск-Центральный"}	{"en": "Omsk", "ru": "Омск"}	(73.3105010986328125,54.9669990539550781)	Asia/Omsk
ROV	{"en": "Rostov-on-Don Airport", "ru": "Ростов-на-Дону"}	{"en": "Rostov", "ru": "Ростов-на-Дону"}	(39.8180999755999991,47.2582015990999977)	Europe/Moscow
AER	{"en": "Sochi International Airport", "ru": "Сочи"}	{"en": "Sochi", "ru": "Сочи"}	(39.9566001892089986,43.4499015808110016)	Europe/Moscow
VOG	{"en": "Volgograd International Airport", "ru": "Гумрак"}	{"en": "Volgograd", "ru": "Волгоград"}	(44.3455009460449219,48.782501220703125)	Europe/Volgograd
BQS	{"en": "Ignatyevo Airport", "ru": "Игнатьево"}	{"en": "Blagoveschensk", "ru": "Благовещенск"}	(127.412002563476562,50.4253997802734375)	Asia/Yakutsk
GDX	{"en": "Sokol Airport", "ru": "Магадан"}	{"en": "Magadan", "ru": "Магадан"}	(150.720001220703125,59.9109992980957031)	Asia/Magadan
HTA	{"en": "Chita-Kadala Airport", "ru": "Чита"}	{"en": "Chita", "ru": "Чита"}	(113.305999999999997,52.0262990000000016)	Asia/Chita
BTK	{"en": "Bratsk Airport", "ru": "Братск"}	{"en": "Bratsk", "ru": "Братск"}	(101.697998046875,56.3706016540527344)	Asia/Irkutsk
IKT	{"en": "Irkutsk Airport", "ru": "Иркутск"}	{"en": "Irkutsk", "ru": "Иркутск"}	(104.388999938959998,52.2680015563960012)	Asia/Irkutsk
UUD	{"en": "Ulan-Ude Airport (Mukhino)", "ru": "Байкал"}	{"en": "Ulan-ude", "ru": "Улан-Удэ"}	(107.438003540039062,51.80780029296875)	Asia/Irkutsk
MMK	{"en": "Murmansk Airport", "ru": "Мурманск"}	{"en": "Murmansk", "ru": "Мурманск"}	(32.7508010864257812,68.7817001342773438)	Europe/Moscow
ABA	{"en": "Abakan Airport", "ru": "Абакан"}	{"en": "Abakan", "ru": "Абакан"}	(91.3850021362304688,53.7400016784667969)	Asia/Krasnoyarsk
BAX	{"en": "Barnaul Airport", "ru": "Барнаул"}	{"en": "Barnaul", "ru": "Барнаул"}	(83.5384979248046875,53.363800048828125)	Asia/Krasnoyarsk
AAQ	{"en": "Anapa Vityazevo Airport", "ru": "Витязево"}	{"en": "Anapa", "ru": "Анапа"}	(37.3473014831539984,45.002101898192997)	Europe/Moscow
CNN	{"en": "Chulman Airport", "ru": "Чульман"}	{"en": "Neryungri", "ru": "Нерюнгри"}	(124.914001464839998,56.9138984680179973)	Asia/Yakutsk
\.


--
-- Data for Name: boarding_passes; Type: TABLE DATA; Schema: bookings; Owner: -
--

COPY boarding_passes (ticket_no, flight_id, boarding_no, seat_no) FROM stdin;
0005435212351	30625	1	2D
0005435212386	30625	2	3G
0005435212381	30625	3	4H
0005432211370	30625	4	5D
0005435212357	30625	5	11A
0005435212360	30625	6	11E
0005435212393	30625	7	11H
0005435212374	30625	8	12E
0005435212365	30625	9	13D
0005435212378	30625	10	14H
0005435212362	30625	11	15E
0005435212334	30625	12	15F
0005435212370	30625	13	15K
0005435212329	30625	14	15H
0005435725513	30625	15	16D
0005435212328	30625	16	16C
0005435630915	30625	17	16E
0005435212388	30625	18	17E
0005432159775	30625	19	17D
0005435212382	30625	20	17H
0005432211367	30625	21	19K
0005435212354	30625	22	20B
0005432211372	30625	23	20F
0005432159776	30625	24	2A
0005435212344	30625	25	20K
0005435212372	30625	26	22B
0005435212355	30625	27	22H
0005435212376	30625	28	23F
0005435725512	30625	29	25D
0005435212385	30625	30	25C
0005435212336	30625	31	26D
0005435212367	30625	32	26J
0005435212359	30625	33	27B
0005435212364	30625	34	27H
0005435725514	30625	35	27K
0005435212338	30625	36	28C
0005435212391	30625	37	28B
0005435212366	30625	38	28G
0005435212347	30625	39	28J
0005432211366	30625	40	28K
0005433656614	30625	41	29D
0005435212383	30625	42	29C
0005435212373	30625	43	29B
0005435212395	30625	44	29J
0005435212343	30625	45	30E
0005435212371	30625	46	30J
0005435212377	30625	47	31J
0005435212358	30625	48	32C
0005435212330	30625	49	32B
0005432211371	30625	50	32F
0005435212368	30625	51	32K
0005435212340	30625	52	33D
0005435212335	30625	53	33C
0005435212363	30625	54	33H
0005435212380	30625	55	35A
0005435212345	30625	56	35C
0005435212375	30625	57	35B
0005432211365	30625	58	35F
0005435212350	30625	59	35E
0005435212331	30625	60	35G
0005435212353	30625	61	36G
0005435630916	30625	62	36J
0005435212337	30625	63	37B
0005432211368	30625	64	37E
0005432211369	30625	65	37F
0005435212356	30625	66	37H
0005435212332	30625	67	38A
0005435212348	30625	68	38K
0005435212352	30625	69	39E
0005435212394	30625	70	40G
0005435212389	30625	71	40J
0005435212369	30625	72	42A
0005435212392	30625	73	41K
0005435212379	30625	74	42C
0005435725516	30625	75	42E
0005435212396	30625	76	42K
0005432159777	30625	77	43A
0005433656613	30625	78	43G
0005435725515	30625	79	43H
0005435212346	30625	80	43K
0005435212390	30625	81	45D
0005435212361	30625	82	45E
0005435212341	30625	83	45K
0005435725511	30625	84	46C
0005435212349	30625	85	46B
0005432159778	30625	86	46K
0005435212384	30625	87	47E
0005435630914	30625	88	49E
0005435212339	30625	89	49G
0005435212333	30625	90	50C
0005435212387	30625	91	50H
0005435212342	30625	92	51D
0005433367244	24836	1	1D
0005433367229	24836	2	1F
0005433367230	24836	3	2C
0005433367245	24836	4	2D
0005433367256	24836	5	3D
0005433367225	24836	6	3F
0005433367228	24836	7	4A
0005433367236	24836	8	4C
0005433367252	24836	9	4E
0005433367243	24836	10	5A
0005433367222	24836	11	5C
0005433367234	24836	12	5D
0005433367231	24836	13	5F
0005433367218	24836	14	6C
0005433367224	24836	15	6E
0005433367237	24836	16	7A
0005433367255	24836	17	7D
0005433367246	24836	18	7E
0005433367227	24836	19	8A
0005433367233	24836	20	8F
0005433367242	24836	21	9A
0005433367248	24836	22	9F
0005433367223	24836	23	10C
0005433367241	24836	24	10E
0005433367221	24836	25	10F
0005433367258	24836	26	11A
0005433367240	24836	27	13E
0005433367226	24836	28	13F
0005433367247	24836	29	14A
0005433367235	24836	30	14F
0005433367257	24836	31	15F
0005433367251	24836	32	16A
0005433367239	24836	33	16C
0005433367220	24836	34	16D
0005433367250	24836	35	16E
0005433367219	24836	36	17C
0005433367253	24836	37	17D
0005433367232	24836	38	18A
0005433367249	24836	39	18E
0005433367238	24836	40	19D
0005433367254	24836	41	19E
0005434979262	2055	1	1C
0005434979271	2055	2	1D
0005434979277	2055	3	2B
0005434979252	2055	4	2C
0005434979282	2055	5	2D
0005434979273	2055	6	3B
0005434979280	2055	7	3C
0005434979255	2055	8	4A
0005434979269	2055	9	4B
0005434979275	2055	10	4C
0005435801642	2055	11	4D
0005434979279	2055	12	5A
0005434979267	2055	13	5B
0005434979254	2055	14	5D
0005434979264	2055	15	6A
0005434979263	2055	16	6C
0005434979276	2055	17	7B
0005434979270	2055	18	18A
0005434979258	2055	19	18B
0005434979256	2055	20	18C
0005434979265	2055	21	18D
0005434979261	2055	22	19A
0005434979253	2055	23	19B
0005434979259	2055	24	19D
0005435801643	2055	25	20A
0005434979272	2055	26	20B
0005434979260	2055	27	20C
0005434979274	2055	28	20D
0005434979268	2055	29	21C
0005434979257	2055	30	21D
0005434979278	2055	31	22A
0005434979266	2055	32	22B
0005435801644	2055	33	22D
0005434979281	2055	34	23B
0005434952466	2575	1	1B
0005434952464	2575	2	4A
0005434952467	2575	3	5A
0005434952465	2575	4	4B
0005433256382	28205	1	1B
0005433256381	28205	2	5A
0005433111467	19732	1	1A
0005433111468	19732	2	3B
0005433112350	19732	3	4B
0005433111469	19732	4	6A
0005434190367	19092	1	1C
0005434190368	19092	2	7A
0005433534460	6786	1	1B
0005433534461	6786	2	2A
0005433534463	6786	3	2D
0005433538721	6786	4	3A
0005433538717	6786	5	4B
0005433538718	6786	6	4C
0005433534462	6786	7	5C
0005433538720	6786	8	21A
0005433538719	6786	9	21B
0005433538722	6786	10	21D
0005433538723	6786	11	22A
0005433538724	6786	12	23B
0005435259680	25029	1	3D
0005435259678	25029	2	4C
0005435259681	25029	3	18A
0005435259679	25029	4	19D
0005433511804	823	1	1D
0005433511803	823	2	4B
0005433511809	823	3	5D
0005433511807	823	4	6A
0005433511802	823	5	7B
0005433511801	823	6	19B
0005433511808	823	7	20B
0005433511806	823	8	21B
0005433511805	823	9	22B
0005432922454	16157	1	1C
0005432922455	16157	2	2D
0005432922453	16157	3	5A
0005433475633	4021	1	1D
0005433475632	4021	2	2D
0005433475631	4021	3	18D
0005433475630	4021	4	21A
0005435696849	3660	1	1B
0005435696846	3660	2	1D
0005434950451	3660	3	2A
0005435696864	3660	4	2B
0005435696862	3660	5	2D
0005435696847	3660	6	3A
0005435696850	3660	7	3D
0005435696866	3660	8	4A
0005435696843	3660	9	4C
0005435696863	3660	10	5A
0005435696851	3660	11	5B
0005434950450	3660	12	5D
0005435696870	3660	13	6B
0005434950452	3660	14	6D
0005435696859	3660	15	7A
0005435696871	3660	16	7B
0005435696855	3660	17	7D
0005435696869	3660	18	18A
0005435696852	3660	19	18C
0005435696857	3660	20	18D
0005435696853	3660	21	19A
0005435696845	3660	22	19B
0005435696844	3660	23	19C
0005435696856	3660	24	20B
0005435696858	3660	25	20C
0005435696865	3660	26	20D
0005435696848	3660	27	21C
0005435696861	3660	28	22A
0005435696860	3660	29	22B
0005435696854	3660	30	22D
0005435696868	3660	31	23B
0005435696867	3660	32	23A
0005435916119	16272	1	6A
0005435916118	16272	2	7B
0005432609659	3993	1	1A
0005432609661	3993	2	1B
0005432607495	3993	3	1C
0005434606760	3993	4	1D
0005432609658	3993	5	2D
0005434606759	3993	6	4A
0005434606763	3993	7	4D
0005433519378	3993	8	5B
0005432607494	3993	9	6B
0005433519379	3993	10	6D
0005434604838	3993	11	7A
0005434606761	3993	12	18B
0005433519377	3993	13	19B
0005432609660	3993	14	19C
0005434604839	3993	15	19D
0005434606762	3993	16	20B
0005433519380	3993	17	20C
0005432607496	3993	18	21B
0005434604837	3993	19	21C
0005435853578	22080	1	1D
0005435853580	22080	2	18C
0005435853579	22080	3	22C
0005435628670	728	1	1A
0005435628672	728	2	2A
0005435628669	728	3	4B
0005435628671	728	4	6A
0005433348889	15900	1	1A
0005433348891	15900	2	2A
0005433348887	15900	3	3B
0005433348888	15900	4	5B
0005433348890	15900	5	6B
0005433159275	17677	1	4A
0005433159274	17677	2	6A
0005433159276	17677	3	6B
0005435132700	7862	1	2B
0005435132696	7862	2	2D
0005435132694	7862	3	3D
0005435132695	7862	4	4B
0005435132698	7862	5	5A
0005435132697	7862	6	6A
0005435132699	7862	7	7D
0005435132703	7862	8	19B
0005435132704	7862	9	20A
0005435132702	7862	10	21C
0005435132701	7862	11	23A
0005435383058	33092	1	1A
0005435383057	33092	2	5C
0005435383056	33092	3	6B
0005435383059	33092	4	18B
0005435383055	33092	5	22B
0005435160112	7477	1	4C
0005435160111	7477	2	6A
0005435160104	7477	3	7C
0005435160106	7477	4	7B
0005435160109	7477	5	18B
0005435160103	7477	6	18D
0005435160105	7477	7	20A
0005435160110	7477	8	21B
0005435160113	7477	9	21C
0005435160107	7477	10	21D
0005435160108	7477	11	23B
0005435390116	29573	1	1A
0005435390120	29573	2	4A
0005435390121	29573	3	4B
0005435390122	29573	4	5C
0005435390118	29573	5	7C
0005435390117	29573	6	21A
0005435390119	29573	7	21D
0005434503467	6547	1	2C
0005434503492	6547	2	2F
0005434503487	6547	3	4A
0005434503465	6547	4	4C
0005434503495	6547	5	4F
0005434503472	6547	6	5A
0005434503463	6547	7	5D
0005434503469	6547	8	5E
0005434503460	6547	9	5F
0005434503488	6547	10	6C
0005434503484	6547	11	6D
0005434503490	6547	12	6E
0005434503468	6547	13	6F
0005434503482	6547	14	7A
0005435103797	6547	15	7D
0005435103796	6547	16	7E
0005434503479	6547	17	8A
0005435103802	6547	18	8C
0005434503471	6547	19	8D
0005434503494	6547	20	8E
0005434503483	6547	21	8F
0005434503474	6547	22	9C
0005434503464	6547	23	9D
0005434503476	6547	24	9E
0005435103803	6547	25	10A
0005434503462	6547	26	10C
0005434503459	6547	27	10E
0005435103799	6547	28	10F
0005434503458	6547	29	11C
0005434503466	6547	30	11F
0005434503478	6547	31	12A
0005434503470	6547	32	12C
0005434503486	6547	33	13C
0005434503489	6547	34	13F
0005434503491	6547	35	14A
0005435103793	6547	36	14D
0005435103795	6547	37	14E
0005434503485	6547	38	14F
0005434503477	6547	39	15C
0005434503461	6547	40	15E
0005434503473	6547	41	15F
0005434503496	6547	42	16D
0005435103794	6547	43	16E
0005434503475	6547	44	17E
0005434503493	6547	45	17F
0005435103801	6547	46	18D
0005435103798	6547	47	19A
0005435103800	6547	48	20A
0005434503481	6547	49	20C
0005434503480	6547	50	20E
0005435652274	1654	1	1A
0005435652282	1654	2	1D
0005435652261	1654	3	2C
0005435652269	1654	4	2F
0005435652292	1654	5	3C
0005435652275	1654	6	4A
0005435652281	1654	7	4C
0005435652283	1654	8	5D
0005435652263	1654	9	5E
0005435652260	1654	10	6D
0005435652264	1654	11	6F
0005435652278	1654	12	7A
0005435652266	1654	13	7D
0005435652272	1654	14	7F
0005435652250	1654	15	8A
0005435652254	1654	16	8C
0005435652268	1654	17	8E
0005435652253	1654	18	9C
0005435652279	1654	19	9D
0005435652276	1654	20	9E
0005435652251	1654	21	10A
0005435652273	1654	22	10C
0005435652252	1654	23	11A
0005435652295	1654	24	11C
0005435652284	1654	25	11D
0005435652259	1654	26	11E
0005435652265	1654	27	12C
0005435652262	1654	28	12D
0005435652267	1654	29	12E
0005435652280	1654	30	13A
0005435652294	1654	31	13C
0005435652296	1654	32	13D
0005435652257	1654	33	13E
0005435652288	1654	34	14C
0005435652271	1654	35	14D
0005435652285	1654	36	15D
0005435652258	1654	37	15E
0005435652286	1654	38	15F
0005435652291	1654	39	16A
0005435652293	1654	40	16E
0005435652256	1654	41	16D
0005435652270	1654	42	17C
0005435652289	1654	43	18C
0005435652287	1654	44	18D
0005435652290	1654	45	19E
0005435652277	1654	46	19F
0005435652255	1654	47	20D
0005433367257	21707	1	1C
0005433367244	21707	2	1D
0005433367258	21707	3	1F
0005433367221	21707	4	2F
0005433367224	21707	5	4A
0005433367218	21707	6	4D
0005433367240	21707	7	4E
0005433367222	21707	8	6D
0005433367227	21707	9	6E
0005433367252	21707	10	6F
0005433367256	21707	11	7C
0005433367245	21707	12	7F
0005433367247	21707	13	8A
0005433367248	21707	14	8D
0005433367251	21707	15	8E
0005433367235	21707	16	9E
0005433367246	21707	17	10A
0005433367237	21707	18	10C
0005433367242	21707	19	10D
0005433367241	21707	20	10E
0005433367234	21707	21	10F
0005433367253	21707	22	11D
0005433367250	21707	23	11F
0005433367255	21707	24	13D
0005433367231	21707	25	13E
0005433367228	21707	26	14D
0005433367220	21707	27	14E
0005433367238	21707	28	15A
0005433367219	21707	29	15D
0005433367225	21707	30	16A
0005433367226	21707	31	16C
0005433367236	21707	32	16D
0005433367230	21707	33	17A
0005433367254	21707	34	17C
0005433367239	21707	35	18F
0005433367229	21707	36	19A
0005433367232	21707	37	19C
0005433367233	21707	38	19D
0005433367249	21707	39	19E
0005433367243	21707	40	20A
0005433367223	21707	41	20D
0005433985127	4135	1	1D
0005433985129	4135	2	1F
0005433985123	4135	3	2A
0005433985126	4135	4	2C
0005433985160	4135	5	2F
0005435788725	4135	6	3A
0005433985140	4135	7	3D
0005433985155	4135	8	3F
0005433985137	4135	9	4A
0005433985159	4135	10	4E
0005433985125	4135	11	5A
0005433985154	4135	12	5D
0005433985161	4135	13	5E
0005433985122	4135	14	5F
0005433985136	4135	15	7D
0005433985148	4135	16	8A
0005433985143	4135	17	8E
0005433985131	4135	18	9A
0005433985133	4135	19	9C
0005433985158	4135	20	9D
0005433985141	4135	21	10A
0005433985134	4135	22	10D
0005433985139	4135	23	10F
0005435788726	4135	24	11A
0005433985145	4135	25	11E
0005433985152	4135	26	12A
0005433985144	4135	27	12C
0005433985147	4135	28	12F
0005433985146	4135	29	13A
0005435788727	4135	30	13C
0005433985124	4135	31	13D
0005435788728	4135	32	13E
0005433985153	4135	33	14A
0005433985156	4135	34	14D
0005433985130	4135	35	14E
0005433985150	4135	36	17A
0005433985132	4135	37	17D
0005433985151	4135	38	17E
0005433985157	4135	39	18F
0005433985135	4135	40	19A
0005433985142	4135	41	19E
0005433985128	4135	42	19F
0005433985149	4135	43	20D
0005433985138	4135	44	20E
0005433168301	21332	1	3B
0005433168299	21332	2	3D
0005433168302	21332	3	6C
0005433168300	21332	4	20A
0005432869415	17856	1	3F
0005432869416	17856	2	8F
0005432869413	17856	3	9A
0005434151654	17856	4	12D
0005434151656	17856	5	18E
0005432869412	17856	6	19D
0005434151655	17856	7	20C
0005432869414	17856	8	20F
0005432327913	3108	1	1D
0005432327892	3108	2	2D
0005432327911	3108	3	2F
0005432327914	3108	4	3F
0005432287105	3108	5	4D
0005432287101	3108	6	4F
0005432287104	3108	7	4E
0005432327915	3108	8	5C
0005432327904	3108	9	5E
0005432327907	3108	10	5F
0005432327925	3108	11	6A
0005432327930	3108	12	6C
0005432327894	3108	13	6D
0005432287100	3108	14	6E
0005433438767	3108	15	6F
0005432327931	3108	16	7A
0005432327923	3108	17	7C
0005432327898	3108	18	7D
0005432327920	3108	19	7E
0005432327928	3108	20	8A
0005432327893	3108	21	8C
0005432327921	3108	22	8E
0005432327934	3108	23	8F
0005432327912	3108	24	9A
0005432327901	3108	25	9C
0005432327929	3108	26	9F
0005432327932	3108	27	10A
0005432287099	3108	28	10C
0005432327924	3108	29	10D
0005432327903	3108	30	10F
0005433438765	3108	31	11C
0005432327890	3108	32	11E
0005432327896	3108	33	11F
0005433438764	3108	34	12A
0005433438763	3108	35	12C
0005432327917	3108	36	12D
0005432327906	3108	37	13A
0005432327910	3108	38	13C
0005432287103	3108	39	13D
0005432327919	3108	40	13E
0005432327895	3108	41	13F
0005432327926	3108	42	14C
0005432327899	3108	43	14D
0005432327902	3108	44	14E
0005432327897	3108	45	15A
0005432327909	3108	46	15C
0005432287102	3108	47	16D
0005433438766	3108	48	17A
0005432327937	3108	49	17C
0005432327891	3108	50	17E
0005432327922	3108	51	17F
0005432327905	3108	52	18C
0005432327935	3108	53	18D
0005432327900	3108	54	18F
0005432327927	3108	55	19A
0005432327936	3108	56	19C
0005432327918	3108	57	19D
0005432327908	3108	58	20A
0005432327916	3108	59	20D
0005432327933	3108	60	20F
0005432905025	31103	1	3F
0005432054254	31103	2	4C
0005432905022	31103	3	7E
0005432905024	31103	4	11E
0005432905023	31103	5	12E
0005432054252	31103	6	13C
0005432905019	31103	7	13F
0005432905020	31103	8	14D
0005432905021	31103	9	15C
0005432054253	31103	10	19C
0005434309500	6223	1	1A
0005434309510	6223	2	1D
0005432146164	6223	3	2D
0005434309502	6223	4	3F
0005435998953	6223	5	5C
0005435998957	6223	6	5E
0005434309511	6223	7	6C
0005435998963	6223	8	6E
0005434309508	6223	9	7A
0005434309506	6223	10	7C
0005435998956	6223	11	8C
0005435998965	6223	12	9E
0005434309509	6223	13	10B
0005435998964	6223	14	11E
0005435998952	6223	15	11F
0005435998959	6223	16	12F
0005434309501	6223	17	13E
0005435998962	6223	18	14A
0005434309513	6223	19	14C
0005434309512	6223	20	14D
0005435998958	6223	21	16A
0005435998954	6223	22	17C
0005432146163	6223	23	18A
0005435998966	6223	24	18C
0005435998961	6223	25	18E
0005434309505	6223	26	18F
0005435998960	6223	27	19A
0005434309507	6223	28	19E
0005434309503	6223	29	19F
0005435998967	6223	30	20A
0005434309504	6223	31	20E
0005432146165	6223	32	21B
0005435998955	6223	33	23A
0005435998951	6223	34	23E
0005435296942	19528	1	1D
0005435296939	19528	2	2F
0005435296941	19528	3	7A
0005435296938	19528	4	7D
0005435296943	19528	5	7F
0005435296940	19528	6	16E
0005433158094	17534	1	21B
0005433158093	17534	2	22B
0005435501945	1567	1	1A
0005435508176	1567	2	1C
0005435501931	1567	3	1F
0005434565681	1567	4	2C
0005435501933	1567	5	2D
0005434565690	1567	6	3C
0005435517599	1567	7	3D
0005435508167	1567	8	3F
0005435501932	1567	9	4A
0005435501936	1567	10	4C
0005435501950	1567	11	4D
0005434565688	1567	12	5A
0005435517590	1567	13	5D
0005435517605	1567	14	5F
0005435508174	1567	15	6C
0005435501947	1567	16	6D
0005432291890	1567	17	6E
0005435508166	1567	18	6F
0005435501941	1567	19	7A
0005434565686	1567	20	7C
0005435517602	1567	21	7D
0005435517591	1567	22	7E
0005434565678	1567	23	7F
0005435517595	1567	24	8A
0005435501937	1567	25	8D
0005435508164	1567	26	8E
0005434565684	1567	27	8F
0005435501943	1567	28	9A
0005434565687	1567	29	9E
0005435517604	1567	30	9F
0005435501948	1567	31	10A
0005435517596	1567	32	10D
0005435501946	1567	33	10E
0005435517603	1567	34	11A
0005432291889	1567	35	11C
0005435517594	1567	36	11D
0005435508173	1567	37	11E
0005435501944	1567	38	11F
0005434565679	1567	39	12A
0005435508171	1567	40	12C
0005435517600	1567	41	12D
0005434565682	1567	42	12E
0005435508170	1567	43	13A
0005435501952	1567	44	13C
0005435501935	1567	45	13D
0005435508165	1567	46	13E
0005435501938	1567	47	13F
0005435508175	1567	48	14A
0005434565689	1567	49	14C
0005435517585	1567	50	14D
0005435517601	1567	51	14E
0005435517587	1567	52	15A
0005435501949	1567	53	14F
0005435517598	1567	54	15C
0005434565691	1567	55	15D
0005435517589	1567	56	15E
0005435508168	1567	57	15F
0005435517588	1567	58	16C
0005435501940	1567	59	16F
0005435501951	1567	60	17A
0005434565677	1567	61	17C
0005434565685	1567	62	17E
0005435517592	1567	63	18A
0005435501942	1567	64	18C
0005434565683	1567	65	18D
0005435517597	1567	66	18E
0005435501934	1567	67	18F
0005435508169	1567	68	19C
0005435517593	1567	69	19D
0005435517586	1567	70	19F
0005435501939	1567	71	20A
0005435517606	1567	72	20D
0005434565680	1567	73	20E
0005435508172	1567	74	20F
0005433185971	20846	1	2A
0005433185974	20846	2	3A
0005433185975	20846	3	4D
0005433185970	20846	4	5C
0005433185968	20846	5	6F
0005433185969	20846	6	7E
0005433185973	20846	7	18C
0005433185972	20846	8	20F
0005435153627	3925	1	1B
0005435153628	3925	2	2D
0005435153626	3925	3	3B
0005435153631	3925	4	7C
0005435153629	3925	5	18D
0005435153630	3925	6	20D
0005435931536	21848	1	6C
0005435931538	21848	2	18C
0005435931537	21848	3	22D
0005432628586	7226	1	1A
0005432628591	7226	2	2D
0005432628592	7226	3	3D
0005432628588	7226	4	4B
0005432628593	7226	5	4D
0005432628595	7226	6	5C
0005432628596	7226	7	5D
0005432628597	7226	8	6A
0005432628599	7226	9	18A
0005432628594	7226	10	19A
0005432628589	7226	11	20A
0005432628590	7226	12	20C
0005432628585	7226	13	21A
0005432628598	7226	14	21B
0005432628587	7226	15	22C
0005435225447	28100	1	2A
0005435225445	28100	2	18D
0005435225446	28100	3	19A
0005435225449	28100	4	20D
0005435225444	28100	5	21A
0005435225443	28100	6	22A
0005435225448	28100	7	22B
0005435959984	8719	1	6C
0005435959983	8719	2	7C
0005435959985	8719	3	18A
0005435959982	8719	4	20A
0005434267884	15264	1	2A
0005434267885	15264	2	3B
0005434267886	15264	3	5A
0005432674869	1214	1	2A
0005432674874	1214	2	2F
0005432674868	1214	3	3C
0005432674866	1214	4	3F
0005432674876	1214	5	4C
0005432674865	1214	6	5A
0005432674875	1214	7	7D
0005432674873	1214	8	8C
0005432674872	1214	9	10A
0005432674867	1214	10	14F
0005432674871	1214	11	17E
0005432674863	1214	12	18F
0005432674870	1214	13	19B
0005432674877	1214	14	19F
0005432674864	1214	15	20B
0005432873167	17509	1	3D
0005432873168	17509	2	3C
0005432873172	17509	3	5A
0005432873165	17509	4	7A
0005432873171	17509	5	7F
0005432873166	17509	6	10D
0005432873173	17509	7	14C
0005432873169	17509	8	17C
0005432873170	17509	9	20D
0005434434912	1127	1	2A
0005434434913	1127	2	2B
0005434434915	1127	3	3C
0005434434918	1127	4	3D
0005434434919	1127	5	4C
0005434434922	1127	6	5B
0005434434924	1127	7	5C
0005434434910	1127	8	7B
0005434434914	1127	9	18B
0005434434909	1127	10	19C
0005434434921	1127	11	19D
0005434434911	1127	12	20D
0005434434920	1127	13	21B
0005434434916	1127	14	21C
0005434434917	1127	15	22A
0005434434923	1127	16	22D
0005433156598	17301	1	1C
0005433156599	17301	2	2B
0005433156605	17301	3	3D
0005433156604	17301	4	4A
0005433156597	17301	5	4C
0005433156603	17301	6	20A
0005433156600	17301	7	21D
0005433156602	17301	8	22C
0005433156601	17301	9	22D
0005435086706	4103	1	2D
0005435086702	4103	2	3A
0005435086704	4103	3	5A
0005435086703	4103	4	19D
0005435086701	4103	5	21C
0005435086705	4103	6	22B
0005435086700	4103	7	22D
0005435928060	24384	1	1B
0005435928061	24384	2	2D
0005435928057	24384	3	3A
0005435928059	24384	4	7B
0005435928058	24384	5	19A
0005435551493	17003	1	3F
0005435551492	17003	2	4A
0005435551491	17003	3	4G
0005435098522	17003	4	13F
0005435098521	17003	5	14H
0005435551490	17003	6	20F
0005434625797	4822	1	4D
0005434625796	4822	2	6D
0005434625798	4822	3	8A
0005434625793	4822	4	10E
0005434625802	4822	5	11D
0005434625799	4822	6	12F
0005434625794	4822	7	14F
0005434625801	4822	8	19A
0005434625795	4822	9	19F
0005434625800	4822	10	20C
0005435907416	32920	1	1D
0005435907418	32920	2	5F
0005433194818	32920	3	9E
0005435907417	32920	4	11A
0005433194819	32920	5	11F
0005435907419	32920	6	13E
0005435907420	32920	7	15F
0005433194817	32920	8	19F
0005432195657	13777	1	2D
0005432195655	13777	2	3C
0005435937312	13777	3	5A
0005435937307	13777	4	5D
0005435937313	13777	5	18B
0005435937310	13777	6	18D
0005435937306	13777	7	19A
0005432195656	13777	8	19B
0005435937308	13777	9	19D
0005435937309	13777	10	20A
0005435937305	13777	11	21A
0005435937311	13777	12	22A
0005435310836	20272	1	1F
0005435310855	20272	2	2A
0005435310841	20272	3	2C
0005435310846	20272	4	3C
0005435310848	20272	5	3D
0005435310840	20272	6	4F
0005435310854	20272	7	6D
0005432058315	20272	8	7E
0005435310851	20272	9	8D
0005435310849	20272	10	9A
0005435310847	20272	11	9C
0005432058313	20272	12	11F
0005435310844	20272	13	12E
0005435310842	20272	14	14D
0005435310839	20272	15	14F
0005435310845	20272	16	15E
0005435310852	20272	17	15F
0005435310838	20272	18	16D
0005435310837	20272	19	16F
0005435310853	20272	20	17E
0005435310843	20272	21	17F
0005435310850	20272	22	18F
0005432058314	20272	23	19A
0005432058312	20272	24	20F
0005434406641	26958	1	1A
0005432153814	26958	2	1C
0005434406650	26958	3	1D
0005434406669	26958	4	2C
0005434406689	26958	5	2D
0005434406685	26958	6	2F
0005434406643	26958	7	3A
0005434406668	26958	8	3C
0005434406665	26958	9	3D
0005434406695	26958	10	3F
0005432153813	26958	11	4C
0005434406651	26958	12	4E
0005434406654	26958	13	4F
0005434406642	26958	14	5A
0005434406683	26958	15	5C
0005432153815	26958	16	5D
0005434406649	26958	17	5E
0005434406646	26958	18	6A
0005434406701	26958	19	6C
0005432153817	26958	20	6F
0005434406678	26958	21	7A
0005434406690	26958	22	7D
0005434406667	26958	23	7E
0005434406658	26958	24	7F
0005434406679	26958	25	8A
0005434406674	26958	26	8C
0005434406639	26958	27	8F
0005434406673	26958	28	9A
0005434406691	26958	29	9C
0005434406700	26958	30	9E
0005434406656	26958	31	10A
0005434406692	26958	32	10F
0005434406681	26958	33	11A
0005434406666	26958	34	11C
0005434406640	26958	35	11D
0005434406682	26958	36	11E
0005434406670	26958	37	11F
0005434406661	26958	38	12C
0005434406698	26958	39	12D
0005434406662	26958	40	12E
0005434406676	26958	41	12F
0005434406696	26958	42	13A
0005434406653	26958	43	13D
0005434406652	26958	44	13E
0005434406687	26958	45	14D
0005434406677	26958	46	14F
0005434406645	26958	47	15C
0005434406680	26958	48	15D
0005434406693	26958	49	15E
0005434406644	26958	50	15F
0005432153819	26958	51	16A
0005434406659	26958	52	16C
0005434406664	26958	53	16D
0005434406660	26958	54	16E
0005434406655	26958	55	16F
0005434406657	26958	56	17A
0005434406699	26958	57	17C
0005434406671	26958	58	17D
0005434406675	26958	59	17F
0005434406647	26958	60	18C
0005434406686	26958	61	18D
0005434406684	26958	62	18E
0005434406663	26958	63	18F
0005434406697	26958	64	19A
0005434406648	26958	65	19C
0005432153818	26958	66	19D
0005434406672	26958	67	20C
0005432153816	26958	68	20D
0005434406694	26958	69	20E
0005434406688	26958	70	20F
0005434319150	5671	1	2D
0005434319142	5671	2	4F
0005434319149	5671	3	6F
0005434311182	5671	4	7F
0005432109655	5671	5	8D
0005432109656	5671	6	10E
0005434319144	5671	7	10F
0005434319148	5671	8	11F
0005434319143	5671	9	12C
0005434319141	5671	10	13E
0005434319147	5671	11	14F
0005434319145	5671	12	16D
0005434311181	5671	13	16E
0005434319146	5671	14	18E
0005433123577	15695	1	2C
0005433123582	15695	2	2F
0005433123571	15695	3	4A
0005433123580	15695	4	4C
0005433123578	15695	5	6C
0005433123566	15695	6	7C
0005433123573	15695	7	8C
0005433123574	15695	8	11C
0005433123586	15695	9	11D
0005433123587	15695	10	11E
0005433123569	15695	11	12C
0005433123568	15695	12	12D
0005433123575	15695	13	13A
0005433123584	15695	14	13F
0005433123567	15695	15	14A
0005433123565	15695	16	15A
0005433123570	15695	17	15C
0005433123585	15695	18	15E
0005433123583	15695	19	16A
0005433123579	15695	20	17F
0005433123572	15695	21	18F
0005433123581	15695	22	20E
0005433123576	15695	23	20F
0005435219165	31748	1	3C
0005435220283	31748	2	21D
0005435220284	31748	3	22D
0005434484235	9001	1	2B
0005434484231	9001	2	4B
0005434484237	9001	3	4D
0005434484234	9001	4	6B
0005434484236	9001	5	6C
0005434484232	9001	6	18B
0005434484233	9001	7	21B
0005434189075	16620	1	4B
0005434189079	16620	2	6A
0005434189076	16620	3	20C
0005434189077	16620	4	20D
0005434189078	16620	5	21A
0005434189080	16620	6	22B
0005433123582	7571	1	1C
0005433123572	7571	2	2F
0005433123565	7571	3	3C
0005433123574	7571	4	4A
0005433123570	7571	5	4C
0005433123583	7571	6	4F
0005433123581	7571	7	5F
0005433123573	7571	8	7F
0005433123580	7571	9	8D
0005433123566	7571	10	10C
0005433123576	7571	11	11E
0005433123567	7571	12	13D
0005433123584	7571	13	14D
0005433123586	7571	14	15D
0005433123587	7571	15	16A
0005433123579	7571	16	17A
0005433123585	7571	17	17D
0005433123578	7571	18	17F
0005433123577	7571	19	19C
0005433123575	7571	20	19E
0005433123569	7571	21	19F
0005433123568	7571	22	20A
0005433123571	7571	23	20D
0005432720450	7572	1	1C
0005432692555	7572	2	1D
0005432692532	7572	3	1F
0005432720453	7572	4	2A
0005432720446	7572	5	2C
0005432692535	7572	6	2F
0005432720452	7572	7	3D
0005433449584	7572	8	3F
0005432720442	7572	9	4A
0005432720448	7572	10	4C
0005432720447	7572	11	4D
0005432720455	7572	12	4E
0005433449583	7572	13	4F
0005432720435	7572	14	5A
0005432692528	7572	15	5C
0005432692539	7572	16	5D
0005432720433	7572	17	5E
0005432692547	7572	18	5F
0005432720444	7572	19	6A
0005432692527	7572	20	6C
0005433449590	7572	21	6D
0005432692536	7572	22	6E
0005433449604	7572	23	6F
0005432720445	7572	24	7A
0005432692552	7572	25	7C
0005432692542	7572	26	7D
0005432692545	7572	27	7E
0005432720440	7572	28	7F
0005433449595	7572	29	8A
0005432720429	7572	30	8C
0005432720454	7572	31	8D
0005432692534	7572	32	8E
0005432692529	7572	33	8F
0005432692541	7572	34	9A
0005432071520	7572	35	9C
0005432720451	7572	36	9D
0005433449588	7572	37	9E
0005433449601	7572	38	9F
0005432720430	7572	39	10A
0005432720437	7572	40	10C
0005432720439	7572	41	10D
0005432071522	7572	42	10F
0005433449593	7572	43	11A
0005433449586	7572	44	11C
0005432692543	7572	45	11D
0005432720436	7572	46	11E
0005432720449	7572	47	11F
0005432720434	7572	48	12A
0005433449592	7572	49	12C
0005432692549	7572	50	12D
0005432692557	7572	51	12E
0005433449599	7572	52	13A
0005433449591	7572	53	13C
0005432692553	7572	54	13D
0005432720443	7572	55	13E
0005432071521	7572	56	13F
0005432720428	7572	57	14A
0005432692537	7572	58	14C
0005432720438	7572	59	14E
0005432692551	7572	60	15D
0005432692540	7572	61	15C
0005433449597	7572	62	15E
0005432692546	7572	63	15F
0005432692530	7572	64	16A
0005432692554	7572	65	16C
0005432692550	7572	66	16D
0005433449598	7572	67	16E
0005432720432	7572	68	16F
0005432692533	7572	69	17A
0005432692548	7572	70	17C
0005432692531	7572	71	17D
0005433449603	7572	72	17E
0005432692556	7572	73	17F
0005433449600	7572	74	18A
0005433449587	7572	75	18C
0005432692558	7572	76	18D
0005433449602	7572	77	18F
0005433449596	7572	78	18E
0005433449589	7572	79	19A
0005433449605	7572	80	19C
0005433449594	7572	81	19D
0005432692544	7572	82	19E
0005432720441	7572	83	20A
0005432720431	7572	84	20C
0005433449585	7572	85	20E
0005432692538	7572	86	20F
0005433722106	30450	1	2C
0005433722105	30450	2	4E
0005433722104	30450	3	9D
0005433722102	30450	4	12E
0005433722103	30450	5	15F
0005434586172	1368	1	1A
0005434513533	1368	2	1C
0005434586169	1368	3	2A
0005434586179	1368	4	2D
0005434586161	1368	5	2F
0005433524846	1368	6	3A
0005434514921	1368	7	3C
0005433524850	1368	8	3F
0005432270954	1368	9	4C
0005434586160	1368	10	4D
0005433524855	1368	11	4E
0005434586164	1368	12	5A
0005434586171	1368	13	5E
0005432270955	1368	14	6A
0005434586165	1368	15	6F
0005434586162	1368	16	7A
0005434586158	1368	17	7C
0005433524853	1368	18	7D
0005434586177	1368	19	7E
0005434586176	1368	20	7F
0005434586163	1368	21	8D
0005433524851	1368	22	9F
0005432270956	1368	23	10D
0005433524852	1368	24	10E
0005434586181	1368	25	11A
0005434586159	1368	26	11E
0005433524854	1368	27	11F
0005433724726	1368	28	12A
0005433524849	1368	29	12C
0005434586173	1368	30	12E
0005433724727	1368	31	13A
0005434586174	1368	32	13D
0005434513534	1368	33	14C
0005434586182	1368	34	14F
0005434586180	1368	35	15A
0005433724724	1368	36	15D
0005434586157	1368	37	16C
0005434514922	1368	38	16D
0005434586170	1368	39	16E
0005434586167	1368	40	16F
0005434586166	1368	41	17C
0005434586168	1368	42	17D
0005433724725	1368	43	17E
0005434513535	1368	44	18C
0005434586178	1368	45	19C
0005433524848	1368	46	19F
0005434586175	1368	47	20C
0005433524847	1368	48	20D
0005434514923	1368	49	20E
0005433192815	18514	1	4A
0005433192818	18514	2	7D
0005433192812	18514	3	9E
0005433192814	18514	4	9F
0005433192813	18514	5	10A
0005433192816	18514	6	10C
0005433192817	18514	7	11C
0005433192809	18514	8	12E
0005433192810	18514	9	18D
0005433192821	18514	10	19A
0005433192811	18514	11	19D
0005433192820	18514	12	20C
0005433192819	18514	13	20E
0005434142542	11429	1	5A
0005434142541	11429	2	7D
0005434142540	11429	3	20D
0005434142543	11429	4	21B
0005435304095	29766	1	7C
0005435304096	29766	2	7D
0005435304092	29766	3	18D
0005435304094	29766	4	19C
0005435304093	29766	5	20A
0005435304989	29766	6	23A
0005435824155	1287	1	1F
0005435824160	1287	2	2C
0005435824158	1287	3	4A
0005435824164	1287	4	5C
0005435824154	1287	5	6E
0005435824172	1287	6	7B
0005435824173	1287	7	6F
0005435824151	1287	8	8B
0005435824161	1287	9	8A
0005435824169	1287	10	8E
0005435824177	1287	11	9F
0005435824178	1287	12	9E
0005435824156	1287	13	10B
0005435824175	1287	14	10D
0005432284506	1287	15	11A
0005435824170	1287	16	11B
0005435824167	1287	17	12C
0005435824171	1287	18	12E
0005435824162	1287	19	13A
0005435824174	1287	20	13F
0005435824163	1287	21	14C
0005432284505	1287	22	16A
0005435824157	1287	23	16C
0005435824153	1287	24	16D
0005435824165	1287	25	16E
0005432284508	1287	26	17B
0005435824168	1287	27	18D
0005432284507	1287	28	19B
0005435824166	1287	29	19D
0005435824176	1287	30	20A
0005435824159	1287	31	19E
0005435824152	1287	32	20B
0005433415388	17980	1	4A
0005433415381	17980	2	5C
0005433415385	17980	3	6F
0005433415389	17980	4	7B
0005433415384	17980	5	9D
0005433415391	17980	6	9C
0005433415380	17980	7	12E
0005433415383	17980	8	13A
0005433415390	17980	9	14E
0005433415378	17980	10	15B
0005433415379	17980	11	16D
0005433415386	17980	12	17A
0005433415392	17980	13	18A
0005433415382	17980	14	18C
0005433415393	17980	15	20E
0005433415387	17980	16	21A
0005432143931	5615	1	1A
0005432782863	5615	2	1D
0005432782838	5615	3	1F
0005432782841	5615	4	2A
0005432782840	5615	5	2F
0005432782847	5615	6	3A
0005432782887	5615	7	3C
0005432782888	5615	8	4C
0005432782870	5615	9	4D
0005432782872	5615	10	4E
0005432143932	5615	11	5A
0005432782850	5615	12	5C
0005432782849	5615	13	5F
0005432782889	5615	14	6A
0005432782871	5615	15	6C
0005432782857	5615	16	6D
0005432782873	5615	17	7A
0005432782877	5615	18	7C
0005432782858	5615	19	7D
0005432782854	5615	20	7F
0005432782892	5615	21	8D
0005432782864	5615	22	8F
0005432782851	5615	23	9A
0005432782848	5615	24	9D
0005432782891	5615	25	9E
0005432782860	5615	26	9F
0005432782861	5615	27	10A
0005432782880	5615	28	10C
0005432782882	5615	29	10E
0005432782853	5615	30	10F
0005432782839	5615	31	11E
0005432782881	5615	32	11F
0005432782883	5615	33	12A
0005432782842	5615	34	12C
0005432782879	5615	35	12D
0005432782876	5615	36	12E
0005432782869	5615	37	13A
0005432782859	5615	38	13C
0005432782867	5615	39	13D
0005432782855	5615	40	14A
0005432782845	5615	41	14E
0005432782884	5615	42	15C
0005432782886	5615	43	16A
0005432782874	5615	44	16E
0005432782846	5615	45	17C
0005432143930	5615	46	17F
0005432782878	5615	47	18A
0005432782843	5615	48	18C
0005432143929	5615	49	18F
0005432782865	5615	50	19A
0005432782890	5615	51	19C
0005432782856	5615	52	19D
0005432782875	5615	53	19E
0005432782862	5615	54	19F
0005432782868	5615	55	20A
0005432782885	5615	56	20C
0005432782852	5615	57	20D
0005432782844	5615	58	20E
0005432782866	5615	59	20F
0005435476637	15345	1	1C
0005435476646	15345	2	4C
0005435476647	15345	3	4D
0005435476640	15345	4	5A
0005435476634	15345	5	5D
0005435476636	15345	6	6F
0005435476643	15345	7	8A
0005435476645	15345	8	12F
0005435476635	15345	9	14A
0005435476641	15345	10	14E
0005435476639	15345	11	15C
0005435476642	15345	12	16F
0005435476638	15345	13	18D
0005435476648	15345	14	20A
0005435476644	15345	15	20F
0005432848055	4384	1	1B
0005432848056	4384	2	2C
0005434462753	4384	3	2D
0005432848057	4384	4	3C
0005432848064	4384	5	3D
0005432848059	4384	6	4B
0005432848066	4384	7	5A
0005432848062	4384	8	5D
0005432848067	4384	9	7C
0005434463892	4384	10	7D
0005434463891	4384	11	18D
0005432848060	4384	12	19C
0005432848061	4384	13	20C
0005432848070	4384	14	21A
0005432848068	4384	15	21C
0005432848058	4384	16	22A
0005432848065	4384	17	22B
0005434462752	4384	18	22C
0005432848069	4384	19	23A
0005432848063	4384	20	23B
0005435850752	28883	1	1B
0005435850751	28883	2	2C
0005435850756	28883	3	4D
0005435850750	28883	4	5B
0005435850754	28883	5	18C
0005435850755	28883	6	19A
0005435850753	28883	7	21C
0005435850757	28883	8	22B
0005433496438	6253	1	1A
0005433496444	6253	2	1D
0005433496449	6253	3	1F
0005434443432	6253	4	2A
0005434925249	6253	5	2C
0005433496435	6253	6	2F
0005433496432	6253	7	3C
0005434443436	6253	8	3F
0005433496431	6253	9	4A
0005434925247	6253	10	4C
0005434925256	6253	11	4E
0005434925264	6253	12	4D
0005434443433	6253	13	5C
0005434925254	6253	14	5D
0005434443427	6253	15	5E
0005434925265	6253	16	5F
0005434443424	6253	17	6D
0005433496436	6253	18	6E
0005434925250	6253	19	6F
0005434925263	6253	20	7C
0005434925269	6253	21	7D
0005434925255	6253	22	7F
0005433496430	6253	23	7E
0005434925266	6253	24	8D
0005433496418	6253	25	8E
0005434443434	6253	26	8F
0005432075169	6253	27	9A
0005433496447	6253	28	9C
0005434443438	6253	29	9D
0005433496433	6253	30	9F
0005434925270	6253	31	10C
0005433496420	6253	32	10E
0005434925258	6253	33	10F
0005433496445	6253	34	11A
0005434925248	6253	35	11C
0005433496422	6253	36	11D
0005434443439	6253	37	11F
0005434925268	6253	38	12A
0005433496421	6253	39	12C
0005434925251	6253	40	12D
0005434925271	6253	41	12E
0005433496428	6253	42	12F
0005433496425	6253	43	13A
0005433496434	6253	44	13C
0005434925253	6253	45	13D
0005434925260	6253	46	13E
0005433496429	6253	47	13F
0005433496427	6253	48	14A
0005432075170	6253	49	14C
0005434443425	6253	50	14D
0005433496424	6253	51	14E
0005434443435	6253	52	14F
0005434925259	6253	53	15A
0005433496423	6253	54	15C
0005434443429	6253	55	15D
0005434443428	6253	56	16D
0005434443426	6253	57	16E
0005433496442	6253	58	16F
0005433496441	6253	59	17A
0005434443431	6253	60	17C
0005434925261	6253	61	17D
0005434925257	6253	62	17E
0005433496440	6253	63	17F
0005433496446	6253	64	18A
0005433496426	6253	65	18D
0005432075171	6253	66	18E
0005433496437	6253	67	18F
0005434925272	6253	68	19A
0005434925252	6253	69	19C
0005433496439	6253	70	19D
0005433496419	6253	71	19E
0005434925262	6253	72	19F
0005434443437	6253	73	20A
0005433496443	6253	74	20C
0005434925267	6253	75	20D
0005433496448	6253	76	20E
0005434443430	6253	77	20F
0005435242399	12211	1	1A
0005435242390	12211	2	3C
0005435242389	12211	3	3D
0005435242409	12211	4	3F
0005435242393	12211	5	5C
0005435242400	12211	6	5D
0005435242403	12211	7	7C
0005435242404	12211	8	7F
0005435242394	12211	9	9C
0005435242401	12211	10	9D
0005435242414	12211	11	9E
0005435242413	12211	12	9F
0005435242396	12211	13	11C
0005435242410	12211	14	11E
0005435242411	12211	15	11F
0005435242398	12211	16	12A
0005435242407	12211	17	13A
0005435242391	12211	18	13C
0005435242395	12211	19	14F
0005435242388	12211	20	15A
0005435242408	12211	21	15C
0005435242392	12211	22	15E
0005435242405	12211	23	16C
0005435242402	12211	24	16D
0005435242412	12211	25	16E
0005435242406	12211	26	17A
0005435242387	12211	27	17C
0005435242415	12211	28	19C
0005435242397	12211	29	20C
0005435913849	10095	1	5D
0005434910069	10095	2	6E
0005434910068	10095	3	15C
0005434910070	10095	4	16D
0005435913850	10095	5	18D
0005434876590	14602	1	1C
0005434876598	14602	2	1A
0005434876624	14602	3	1D
0005434876582	14602	4	2C
0005434876616	14602	5	2A
0005434876615	14602	6	2D
0005434876569	14602	7	3A
0005434876638	14602	8	3D
0005434876620	14602	9	3C
0005434876608	14602	10	4A
0005434876636	14602	11	3F
0005434876555	14602	12	4D
0005434876601	14602	13	4C
0005434876617	14602	14	4F
0005434876593	14602	15	5C
0005434876610	14602	16	5F
0005434876564	14602	17	5D
0005434876629	14602	18	6A
0005434876650	14602	19	6C
0005434876648	14602	20	6F
0005434876621	14602	21	6E
0005434876574	14602	22	6D
0005434876618	14602	23	7A
0005434876641	14602	24	7C
0005434876579	14602	25	7B
0005434876565	14602	26	7D
0005434876635	14602	27	7F
0005434758853	14602	28	7E
0005434876557	14602	29	8B
0005434876600	14602	30	8D
0005434876558	14602	31	8C
0005434876611	14602	32	8F
0005434876563	14602	33	9B
0005434876570	14602	34	9A
0005434876637	14602	35	9C
0005434876583	14602	36	9E
0005434876639	14602	37	9D
0005434876573	14602	38	10B
0005434876612	14602	39	10A
0005434876595	14602	40	9F
0005434876626	14602	41	10C
0005434876592	14602	42	10E
0005434876580	14602	43	10D
0005434876560	14602	44	11A
0005434876586	14602	45	10F
0005434876568	14602	46	11C
0005434876581	14602	47	11B
0005434876619	14602	48	11F
0005434876607	14602	49	11E
0005434876609	14602	50	12B
0005434876559	14602	51	12A
0005434876614	14602	52	12D
0005434876603	14602	53	12C
0005434876651	14602	54	12E
0005434758854	14602	55	13A
0005434876649	14602	56	12F
0005434876633	14602	57	13C
0005434758852	14602	58	13B
0005434876606	14602	59	13E
0005434876562	14602	60	13D
0005434876646	14602	61	13F
0005434876596	14602	62	14B
0005434876561	14602	63	14D
0005434876556	14602	64	14C
0005434876634	14602	65	14F
0005434876631	14602	66	15B
0005434876640	14602	67	15A
0005434876625	14602	68	15C
0005434876623	14602	69	15F
0005434876627	14602	70	15E
0005434876575	14602	71	16A
0005434876597	14602	72	16C
0005434876588	14602	73	16B
0005434876642	14602	74	16F
0005434876572	14602	75	16E
0005434876587	14602	76	17C
0005434876585	14602	77	17B
0005434876605	14602	78	17F
0005434876602	14602	79	17E
0005434876628	14602	80	18B
0005434876589	14602	81	18A
0005434876567	14602	82	18C
0005434876599	14602	83	18D
0005434876647	14602	84	19A
0005434876645	14602	85	18F
0005434876644	14602	86	19B
0005434876591	14602	87	19E
0005434876576	14602	88	19D
0005434876632	14602	89	20B
0005434876604	14602	90	20A
0005434876566	14602	91	20D
0005434876578	14602	92	20C
0005434876594	14602	93	20F
0005434876622	14602	94	20E
0005434876584	14602	95	21A
0005434876571	14602	96	21C
0005434876643	14602	97	21B
0005434876577	14602	98	21E
0005434876630	14602	99	21D
0005434876613	14602	100	21F
0005435659943	9262	1	1A
0005435659937	9262	2	1B
0005435659948	9262	3	1C
0005435659946	9262	4	3A
0005435659939	9262	5	4C
0005435659941	9262	6	4D
0005435659940	9262	7	5A
0005435659944	9262	8	5D
0005435659938	9262	9	20A
0005435659945	9262	10	21C
0005435659947	9262	11	21D
0005435659942	9262	12	22A
0005434251798	24676	1	1D
0005434251800	24676	2	2A
0005434251802	24676	3	2B
0005434251795	24676	4	4C
0005434251801	24676	5	5B
0005434251797	24676	6	5C
0005434251804	24676	7	6B
0005434251803	24676	8	6C
0005434251796	24676	9	7A
0005434251799	24676	10	18B
0005433679726	2796	1	1A
0005433679724	2796	2	1C
0005433679740	2796	3	1D
0005433679728	2796	4	1F
0005433679715	2796	5	2A
0005432222688	2796	6	2D
0005433679754	2796	7	3C
0005432222690	2796	8	4A
0005433679717	2796	9	4C
0005433679752	2796	10	4D
0005433679718	2796	11	4E
0005433679716	2796	12	5C
0005433679745	2796	13	5D
0005433679731	2796	14	5E
0005433679727	2796	15	6A
0005433679747	2796	16	6C
0005433679719	2796	17	6D
0005433679755	2796	18	6E
0005433679734	2796	19	7A
0005433679710	2796	20	7E
0005433679733	2796	21	7F
0005433679722	2796	22	8C
0005433679744	2796	23	8E
0005433679739	2796	24	8F
0005433679732	2796	25	10A
0005433679729	2796	26	10C
0005433679713	2796	27	10E
0005433679711	2796	28	11A
0005433679720	2796	29	12C
0005433679736	2796	30	12D
0005433679750	2796	31	12E
0005433679748	2796	32	12F
0005432222691	2796	33	13A
0005433679741	2796	34	13D
0005433679742	2796	35	13E
0005433679749	2796	36	13F
0005432222689	2796	37	14A
0005433679709	2796	38	14C
0005433679725	2796	39	14D
0005433679721	2796	40	14F
0005433679756	2796	41	15A
0005433679751	2796	42	15D
0005433679723	2796	43	16C
0005433679737	2796	44	16F
0005433679746	2796	45	17A
0005433679743	2796	46	17C
0005433679730	2796	47	17F
0005433679735	2796	48	18A
0005433679738	2796	49	18C
0005433679753	2796	50	18F
0005433679712	2796	51	19C
0005433679714	2796	52	19D
0005432222692	2796	53	20C
0005432966502	29150	1	2C
0005432966499	29150	2	3A
0005432966486	29150	3	3C
0005432966482	29150	4	3F
0005432966494	29150	5	4A
0005432966495	29150	6	4C
0005432966489	29150	7	4D
0005432966504	29150	8	5C
0005432966492	29150	9	6C
0005432966480	29150	10	6D
0005432966497	29150	11	7F
0005432005165	29150	12	8A
0005432966483	29150	13	8F
0005432005164	29150	14	9A
0005432966503	29150	15	10C
0005432966498	29150	16	11A
0005432966491	29150	17	13C
0005432966493	29150	18	13E
0005432966479	29150	19	13F
0005432966481	29150	20	14E
0005432966496	29150	21	14F
0005432966488	29150	22	15C
0005432966500	29150	23	16A
0005432966484	29150	24	16C
0005432966501	29150	25	16E
0005432005163	29150	26	17C
0005432966487	29150	27	17E
0005432966485	29150	28	18A
0005432966490	29150	29	18D
0005433577568	9307	1	3A
0005433577564	9307	2	4C
0005433577563	9307	3	6A
0005433577565	9307	4	6F
0005432755016	9307	5	7F
0005432756789	9307	6	8A
0005433577567	9307	7	8C
0005433577572	9307	8	10B
0005433577566	9307	9	10E
0005432755017	9307	10	12B
0005433577571	9307	11	14B
0005432756787	9307	12	14F
0005433577562	9307	13	19B
0005432755015	9307	14	20B
0005433577573	9307	15	20C
0005433577570	9307	16	25B
0005433577569	9307	17	26A
0005432756788	9307	18	27A
0005433577561	9307	19	30C
0005432184902	4199	1	2C
0005435986654	4199	2	13B
0005435986650	4199	3	13G
0005435986652	4199	4	15H
0005435986649	4199	5	21E
0005432184901	4199	6	24B
0005435986653	4199	7	28A
0005432184900	4199	8	33B
0005435986651	4199	9	38E
0005435947005	26588	1	1A
0005432571260	26588	2	1H
0005432571259	26588	3	3B
0005435947001	26588	4	4A
0005435947010	26588	5	5C
0005435947004	26588	6	11G
0005435856131	26588	7	13A
0005435947003	26588	8	14A
0005435946996	26588	9	18E
0005435947000	26588	10	18D
0005435787321	26588	11	19F
0005432571257	26588	12	20E
0005435946997	26588	13	23H
0005435947009	26588	14	30F
0005432571258	26588	15	30G
0005435946998	26588	16	31G
0005435947006	26588	17	32E
0005435946999	26588	18	33F
0005435856133	26588	19	33G
0005435947008	26588	20	36B
0005435856130	26588	21	36D
0005435947002	26588	22	37H
0005435787320	26588	23	38D
0005435947011	26588	24	38F
0005435947007	26588	25	38G
0005435856132	26588	26	38H
0005433568041	331	1	2A
0005433568033	331	2	2D
0005433568034	331	3	3F
0005433568043	331	4	5A
0005433568065	331	5	4F
0005433568018	331	6	5F
0005433568045	331	7	5D
0005433568061	331	8	6A
0005433568019	331	9	7A
0005433568029	331	10	8A
0005433568037	331	11	8B
0005433568057	331	12	9B
0005433568036	331	13	9C
0005433568022	331	14	9D
0005433568038	331	15	9F
0005433568053	331	16	10B
0005432238832	331	17	10F
0005433568060	331	18	11A
0005433568040	331	19	11D
0005433568054	331	20	11C
0005432238829	331	21	11F
0005433568066	331	22	12D
0005433568067	331	23	13B
0005433568042	331	24	14C
0005433568027	331	25	15A
0005433568028	331	26	15D
0005432238831	331	27	15F
0005433568063	331	28	15E
0005432238828	331	29	17A
0005432238830	331	30	17D
0005433568032	331	31	17E
0005433568044	331	32	18A
0005433568023	331	33	18B
0005433568049	331	34	18D
0005433568046	331	35	18C
0005433568047	331	36	19E
0005433568052	331	37	20D
0005433568020	331	38	21B
0005433568039	331	39	21D
0005433568048	331	40	21F
0005433568050	331	41	22B
0005433568056	331	42	22C
0005433568030	331	43	22E
0005433568031	331	44	22D
0005433568035	331	45	23C
0005433568058	331	46	24D
0005433568059	331	47	24F
0005432238827	331	48	25B
0005433568015	331	49	25D
0005433568062	331	50	25C
0005433568025	331	51	27A
0005433568016	331	52	27C
0005433568068	331	53	27E
0005433568064	331	54	28C
0005433568055	331	55	28D
0005433568017	331	56	29A
0005433568051	331	57	29D
0005433568026	331	58	30F
0005433568024	331	59	31B
0005433568021	331	60	31F
0005433074208	11606	1	1D
0005432192264	11606	2	1C
0005433134056	11606	3	2D
0005433074209	11606	4	4D
0005433074203	11606	5	6C
0005433074216	11606	6	6F
0005433074217	11606	7	6D
0005433074213	11606	8	7A
0005433074204	11606	9	8A
0005433074219	11606	10	10B
0005432192265	11606	11	11E
0005433074214	11606	12	12E
0005433074225	11606	13	12D
0005433074199	11606	14	13A
0005433074197	11606	15	13D
0005433074207	11606	16	13F
0005433074196	11606	17	14D
0005433074211	11606	18	15A
0005433134059	11606	19	15E
0005433131627	11606	20	15D
0005433134058	11606	21	15F
0005433131629	11606	22	16A
0005433074222	11606	23	17A
0005433074218	11606	24	17F
0005433074205	11606	25	17E
0005433074210	11606	26	18C
0005433074201	11606	27	18E
0005432192263	11606	28	19E
0005433074223	11606	29	20B
0005433131626	11606	30	20F
0005433074212	11606	31	24A
0005433074200	11606	32	25A
0005433074221	11606	33	27D
0005433131628	11606	34	27F
0005433134057	11606	35	28C
0005433074206	11606	36	28F
0005433074198	11606	37	29D
0005433074224	11606	38	29F
0005433074220	11606	39	29E
0005433074215	11606	40	30A
0005433074202	11606	41	31B
0005433817405	10005	1	1A
0005433817407	10005	2	1B
0005433817406	10005	3	3B
0005433817404	10005	4	6B
0005434732921	13968	1	3B
0005434732918	13968	2	4A
0005434732920	13968	3	4B
0005434732919	13968	4	5A
0005433753223	2323	1	1A
0005432655337	2323	2	1C
0005433753243	2323	3	1B
0005432655327	2323	4	1F
0005433753278	2323	5	1G
0005433753262	2323	6	2A
0005435981535	2323	7	1H
0005435981511	2323	8	2F
0005433753275	2323	9	2C
0005433753244	2323	10	3B
0005433753246	2323	11	3F
0005433753273	2323	12	3C
0005432225946	2323	13	4A
0005435981527	2323	14	4B
0005435981514	2323	15	4F
0005435981510	2323	16	5A
0005432655334	2323	17	5F
0005433753267	2323	18	5C
0005435981519	2323	19	9B
0005433753268	2323	20	11B
0005435981537	2323	21	11F
0005432655335	2323	22	11G
0005433753249	2323	23	12A
0005435981513	2323	24	12F
0005433753269	2323	25	13D
0005435981534	2323	26	13B
0005433753258	2323	27	13E
0005435981533	2323	28	13F
0005435981509	2323	29	13H
0005433753228	2323	30	13G
0005433753227	2323	31	14A
0005435981515	2323	32	14E
0005433753240	2323	33	14D
0005433753251	2323	34	14F
0005433753241	2323	35	14H
0005433753221	2323	36	14G
0005433753271	2323	37	15D
0005432300163	2323	38	15F
0005433753250	2323	39	15H
0005433753239	2323	40	15G
0005435981528	2323	41	16E
0005435981545	2323	42	16G
0005432225947	2323	43	16F
0005433753266	2323	44	17B
0005433753253	2323	45	17A
0005435981518	2323	46	17D
0005433753224	2323	47	17E
0005433753242	2323	48	17G
0005432655331	2323	49	17H
0005433753254	2323	50	18B
0005432300165	2323	51	18D
0005433753232	2323	52	18F
0005435981540	2323	53	18H
0005433753237	2323	54	19B
0005433753259	2323	55	19A
0005433764644	2323	56	19D
0005433753233	2323	57	19F
0005435981546	2323	58	19H
0005433764643	2323	59	19G
0005435981523	2323	60	20A
0005433766573	2323	61	20E
0005435981543	2323	62	20D
0005433753261	2323	63	20G
0005435981531	2323	64	20F
0005435981542	2323	65	21A
0005432300161	2323	66	21F
0005433753255	2323	67	22A
0005432655332	2323	68	21G
0005432655333	2323	69	22B
0005435981530	2323	70	22E
0005433753235	2323	71	22F
0005433753263	2323	72	22H
0005435981517	2323	73	23F
0005435981547	2323	74	23E
0005435981516	2323	75	24B
0005433753245	2323	76	24D
0005433753230	2323	77	24H
0005433753272	2323	78	24G
0005435981539	2323	79	25D
0005433753225	2323	80	25E
0005432655336	2323	81	27B
0005433766575	2323	82	27E
0005432225952	2323	83	27D
0005433753277	2323	84	27G
0005433753231	2323	85	27F
0005432655328	2323	86	27H
0005432225950	2323	87	28B
0005432300162	2323	88	28H
0005433753238	2323	89	28G
0005433753229	2323	90	29A
0005435981522	2323	91	29G
0005432225949	2323	92	30B
0005433753260	2323	93	30A
0005435981521	2323	94	30D
0005433753265	2323	95	30F
0005435981532	2323	96	30E
0005433753274	2323	97	30G
0005433753247	2323	98	30H
0005435981536	2323	99	31B
0005432225951	2323	100	31A
0005435981526	2323	101	31G
0005432655326	2323	102	32A
0005435981538	2323	103	32B
0005435981529	2323	104	32E
0005433753256	2323	105	32H
0005433766572	2323	106	33A
0005433753226	2323	107	33B
0005435981508	2323	108	34A
0005433753248	2323	109	34D
0005432300164	2323	110	34E
0005435981520	2323	111	34G
0005433753222	2323	112	34F
0005435981512	2323	113	35A
0005433753234	2323	114	34H
0005433753270	2323	115	35B
0005433753236	2323	116	35D
0005435981544	2323	117	35E
0005433753264	2323	118	35H
0005433753257	2323	119	35G
0005432655330	2323	120	36F
0005433753252	2323	121	37D
0005435981541	2323	122	37A
0005432655329	2323	123	37G
0005435981524	2323	124	38A
0005433766574	2323	125	38G
0005432225948	2323	126	39E
0005433753276	2323	127	39D
0005435981525	2323	128	39F
0005432984529	26185	1	1A
0005432051075	26185	2	1B
0005433434188	26185	3	1F
0005433434192	26185	4	1G
0005432984518	26185	5	2A
0005432984503	26185	6	2B
0005433434184	26185	7	3F
0005432984526	26185	8	4B
0005433434195	26185	9	4F
0005432984506	26185	10	5A
0005432984530	26185	11	5F
0005433434186	26185	12	9G
0005432984514	26185	13	11E
0005433434203	26185	14	12B
0005433434181	26185	15	12F
0005432984510	26185	16	12G
0005432984501	26185	17	13H
0005432984524	26185	18	14A
0005433434187	26185	19	14F
0005432984507	26185	20	15E
0005432984527	26185	21	16D
0005433434189	26185	22	16E
0005432984511	26185	23	17A
0005432984505	26185	24	18A
0005432984516	26185	25	18G
0005434731099	26185	26	19B
0005433434185	26185	27	19F
0005433434204	26185	28	19G
0005433434193	26185	29	20D
0005433434182	26185	30	20H
0005432984504	26185	31	21B
0005433434202	26185	32	22D
0005433434197	26185	33	22F
0005432984502	26185	34	22E
0005433434198	26185	35	23B
0005432984515	26185	36	23E
0005433434199	26185	37	24A
0005432984520	26185	38	24D
0005434731097	26185	39	24E
0005434731096	26185	40	24G
0005433434201	26185	41	27H
0005433434207	26185	42	29E
0005433434208	26185	43	29G
0005433434180	26185	44	29H
0005432984512	26185	45	30E
0005434731098	26185	46	31D
0005432049402	26185	47	31F
0005432051076	26185	48	31E
0005432984508	26185	49	31H
0005433434190	26185	50	32D
0005432984509	26185	51	32B
0005433434194	26185	52	32F
0005432051074	26185	53	33A
0005432049400	26185	54	33B
0005432984513	26185	55	33D
0005433434196	26185	56	33G
0005432984521	26185	57	33F
0005432984519	26185	58	34A
0005432984531	26185	59	34D
0005433434191	26185	60	35E
0005432984532	26185	61	35D
0005432984523	26185	62	36A
0005432984522	26185	63	36B
0005433434200	26185	64	36D
0005433434183	26185	65	36E
0005432984517	26185	66	37D
0005432984500	26185	67	38A
0005432049401	26185	68	38D
0005432984525	26185	69	38E
0005433434206	26185	70	38F
0005433434205	26185	71	39D
0005432984528	26185	72	39F
0005434373852	1521	1	1A
0005434373860	1521	2	1D
0005434373851	1521	3	2C
0005434373859	1521	4	2D
0005433460399	1521	5	3A
0005434373870	1521	6	2F
0005434373884	1521	7	3C
0005434373856	1521	8	4B
0005434373887	1521	9	4D
0005434373897	1521	10	5D
0005432267782	1521	11	5F
0005434373854	1521	12	6B
0005434373874	1521	13	6A
0005434373857	1521	14	6C
0005433461550	1521	15	6D
0005434373846	1521	16	6E
0005434373872	1521	17	7B
0005434373855	1521	18	7C
0005434373879	1521	19	7D
0005434373890	1521	20	9B
0005434373876	1521	21	9C
0005432267778	1521	22	9E
0005434373867	1521	23	9F
0005434373869	1521	24	10B
0005434373861	1521	25	10E
0005434373847	1521	26	10D
0005434373878	1521	27	11A
0005434373881	1521	28	11D
0005434373894	1521	29	11C
0005434373891	1521	30	11E
0005434373873	1521	31	11F
0005434373888	1521	32	12B
0005434373895	1521	33	12D
0005434373877	1521	34	12E
0005433460398	1521	35	13B
0005434373853	1521	36	13D
0005434373864	1521	37	13C
0005434373893	1521	38	13F
0005434373885	1521	39	14C
0005434373849	1521	40	14B
0005432267780	1521	41	15B
0005434373880	1521	42	16E
0005434373848	1521	43	17B
0005434373883	1521	44	17C
0005434373875	1521	45	17F
0005434373862	1521	46	17E
0005432267779	1521	47	18B
0005434373863	1521	48	18C
0005433461551	1521	49	18D
0005434373882	1521	50	19A
0005432267777	1521	51	19B
0005434373865	1521	52	19D
0005434373868	1521	53	20B
0005434373889	1521	54	20D
0005432267781	1521	55	20E
0005434373886	1521	56	21A
0005434373866	1521	57	21C
0005434373850	1521	58	22C
0005434373871	1521	59	22D
0005434373892	1521	60	23A
0005434373858	1521	61	23B
0005434373896	1521	62	23D
0005433150802	20159	1	1D
0005433150806	20159	2	1F
0005433150801	20159	3	2A
0005433150825	20159	4	3D
0005433931415	20159	5	3F
0005433150796	20159	6	4B
0005433931414	20159	7	4F
0005433150820	20159	8	5B
0005432056231	20159	9	5A
0005432056232	20159	10	5F
0005433150817	20159	11	6D
0005432056233	20159	12	7B
0005433150808	20159	13	7D
0005433150809	20159	14	7E
0005433931413	20159	15	8C
0005433150819	20159	16	8F
0005433150804	20159	17	9D
0005434029615	20159	18	10C
0005433764643	20159	19	11C
0005433150795	20159	20	11B
0005433150812	20159	21	11E
0005433150816	20159	22	11D
0005433150799	20159	23	12D
0005432056234	20159	24	13A
0005433931416	20159	25	13C
0005433150818	20159	26	13B
0005433150803	20159	27	13E
0005433150826	20159	28	13F
0005433150821	20159	29	14D
0005434029613	20159	30	14F
0005433150797	20159	31	15B
0005433150807	20159	32	15C
0005433150824	20159	33	15D
0005433150794	20159	34	15E
0005433150822	20159	35	16B
0005433150813	20159	36	16C
0005433150811	20159	37	17B
0005433150815	20159	38	17C
0005434029614	20159	39	17F
0005433150810	20159	40	18E
0005433150805	20159	41	18F
0005433150800	20159	42	19A
0005433150814	20159	43	21C
0005433150798	20159	44	22C
0005433150823	20159	45	22E
0005433764644	20159	46	23B
0005433150827	20159	47	23A
0005432423614	533	1	1D
0005432423631	533	2	2C
0005432282742	533	3	4C
0005432282744	533	4	7A
0005432423633	533	5	8B
0005432423621	533	6	8C
0005432423607	533	7	10B
0005432423644	533	8	10D
0005432423626	533	9	10E
0005432423612	533	10	11F
0005432423605	533	11	11E
0005432282745	533	12	12B
0005432282740	533	13	12D
0005432423618	533	14	12C
0005432423634	533	15	12E
0005432423623	533	16	13D
0005432423642	533	17	13F
0005432423637	533	18	14D
0005432423632	533	19	15A
0005432423645	533	20	15B
0005432423630	533	21	15E
0005432423604	533	22	15D
0005432423617	533	23	16C
0005432423616	533	24	17F
0005432423643	533	25	18B
0005432282746	533	26	18E
0005432423609	533	27	18F
0005432423610	533	28	19C
0005432423635	533	29	19D
0005432423639	533	30	20D
0005432423646	533	31	20E
0005432423638	533	32	21A
0005432423606	533	33	21F
0005432423628	533	34	22C
0005432423627	533	35	23A
0005432423622	533	36	23B
0005432282739	533	37	23C
0005432423611	533	38	23F
0005432423641	533	39	24C
0005432423640	533	40	24D
0005432423636	533	41	25E
0005432423613	533	42	25F
0005432423625	533	43	26B
0005432423620	533	44	26E
0005432423608	533	45	26F
0005432282743	533	46	27A
0005432423619	533	47	28B
0005432423624	533	48	28F
0005432423629	533	49	29A
0005432282741	533	50	29D
0005432423647	533	51	30A
0005432423615	533	52	31E
0005432302265	12840	1	7C
0005432302266	12840	2	9F
0005433158094	12840	3	24C
0005433158093	12840	4	24F
0005434022558	478	1	1G
0005434022550	478	2	2B
0005432235505	478	3	2G
0005434022515	478	4	2H
0005434022561	478	5	3G
0005434022537	478	6	4A
0005434022536	478	7	3H
0005434022507	478	8	4F
0005434022534	478	9	5B
0005432235507	478	10	5G
0005434022547	478	11	11A
0005434022528	478	12	11E
0005434022520	478	13	11G
0005434022502	478	14	12D
0005434022553	478	15	12E
0005434022525	478	16	12H
0005434022506	478	17	13F
0005434022503	478	18	14B
0005434022562	478	19	14G
0005434022541	478	20	15E
0005434022565	478	21	15F
0005432235508	478	22	15H
0005434022521	478	23	15G
0005434022527	478	24	16A
0005434022542	478	25	16F
0005432235512	478	26	16D
0005434022512	478	27	17D
0005434022524	478	28	17F
0005434022519	478	29	17G
0005434022508	478	30	18E
0005432235506	478	31	18G
0005434022556	478	32	19E
0005434022510	478	33	20D
0005434022538	478	34	20F
0005434022567	478	35	21D
0005434022539	478	36	21H
0005434022530	478	37	21G
0005434022533	478	38	22D
0005434022516	478	39	22G
0005434022531	478	40	23A
0005434022505	478	41	23D
0005434022523	478	42	23H
0005434022535	478	43	24B
0005434022568	478	44	24D
0005434022548	478	45	24F
0005434022540	478	46	27A
0005434022549	478	47	27E
0005434022564	478	48	28F
0005434022513	478	49	28H
0005434022552	478	50	29D
0005432235509	478	51	29G
0005434022529	478	52	29F
0005434022517	478	53	30A
0005434022557	478	54	31A
0005434022545	478	55	30H
0005434022546	478	56	31B
0005434022518	478	57	31F
0005432235510	478	58	31G
0005434022560	478	59	32D
0005434022544	478	60	33A
0005434022563	478	61	33E
0005434022543	478	62	33F
0005432235504	478	63	33H
0005434022509	478	64	33G
0005434022522	478	65	34E
0005434022555	478	66	34G
0005434022566	478	67	35B
0005434022511	478	68	35E
0005434022551	478	69	35G
0005434022504	478	70	36A
0005432235511	478	71	35H
0005434022532	478	72	37B
0005434022559	478	73	37E
0005434022514	478	74	37H
0005434022501	478	75	38D
0005434022526	478	76	38H
0005434022569	478	77	39F
0005434022554	478	78	39E
0005432156288	12679	1	1B
0005434735601	12679	2	1F
0005433057203	12679	3	2F
0005433057204	12679	4	2G
0005433929541	12679	5	4A
0005433057198	12679	6	4C
0005433057179	12679	7	4F
0005433057182	12679	8	5F
0005433057190	12679	9	9A
0005433057194	12679	10	11A
0005433929539	12679	11	11E
0005433057206	12679	12	11H
0005433057196	12679	13	12H
0005433929540	12679	14	13F
0005433057168	12679	15	13H
0005433057187	12679	16	14D
0005433057181	12679	17	15F
0005433057191	12679	18	16A
0005433057176	12679	19	16D
0005433057174	12679	20	17B
0005433057169	12679	21	17F
0005433057170	12679	22	18A
0005433057197	12679	23	18E
0005432156289	12679	24	19B
0005433057178	12679	25	19G
0005433057183	12679	26	20E
0005433057172	12679	27	20F
0005432156290	12679	28	21A
0005433057193	12679	29	20H
0005433057188	12679	30	21B
0005433057180	12679	31	22B
0005432156286	12679	32	22D
0005432157457	12679	33	22E
0005433057202	12679	34	22F
0005433057189	12679	35	23E
0005433057200	12679	36	23F
0005433057173	12679	37	24A
0005433057205	12679	38	24H
0005433057184	12679	39	27G
0005433057175	12679	40	28A
0005433057186	12679	41	29G
0005433057195	12679	42	29F
0005433057199	12679	43	30A
0005432156287	12679	44	30G
0005433057201	12679	45	31G
0005433057208	12679	46	32A
0005434735600	12679	47	32F
0005433057192	12679	48	32G
0005433929542	12679	49	33A
0005434735599	12679	50	33G
0005433684385	12679	51	34D
0005433057185	12679	52	34B
0005432157458	12679	53	36D
0005434735597	12679	54	36F
0005433684384	12679	55	36G
0005433057171	12679	56	37A
0005433057207	12679	57	36H
0005434735598	12679	58	37H
0005433057177	12679	59	38E
0005433921597	2140	1	1A
0005432231380	2140	2	1C
0005433921601	2140	3	1B
0005433921643	2140	4	1F
0005433929540	2140	5	1G
0005433921659	2140	6	2C
0005433921667	2140	7	2H
0005433931415	2140	8	2G
0005433921590	2140	9	4B
0005433921655	2140	10	4H
0005433921623	2140	11	4F
0005433921665	2140	12	5A
0005433921605	2140	13	5B
0005433921624	2140	14	5C
0005432231376	2140	15	5G
0005433921621	2140	16	5H
0005433921673	2140	17	9B
0005432231384	2140	18	9G
0005433921661	2140	19	9H
0005433921650	2140	20	11B
0005432044477	2140	21	11D
0005433929539	2140	22	11G
0005433921632	2140	23	12A
0005433921594	2140	24	12B
0005433921660	2140	25	12H
0005433921642	2140	26	13B
0005433921639	2140	27	13A
0005433921684	2140	28	13F
0005433921668	2140	29	13E
0005433921680	2140	30	13H
0005433921603	2140	31	14F
0005433921615	2140	32	14E
0005432231377	2140	33	15A
0005433921600	2140	34	15B
0005433921629	2140	35	15E
0005433931416	2140	36	15F
0005433921619	2140	37	16B
0005433921611	2140	38	16A
0005433921675	2140	39	15H
0005433921656	2140	40	16D
0005433921618	2140	41	16H
0005433921654	2140	42	16G
0005433921666	2140	43	17A
0005433921634	2140	44	17B
0005433921644	2140	45	17G
0005433921630	2140	46	17F
0005433921636	2140	47	17H
0005433921671	2140	48	18E
0005433921648	2140	49	18F
0005433931414	2140	50	19A
0005433921587	2140	51	19D
0005433921649	2140	52	19F
0005433921682	2140	53	19H
0005433921622	2140	54	19G
0005433921638	2140	55	20D
0005433921664	2140	56	20B
0005433921683	2140	57	20E
0005432231379	2140	58	20H
0005432044476	2140	59	21E
0005433921606	2140	60	21H
0005433921633	2140	61	22B
0005433921598	2140	62	22G
0005433921646	2140	63	22F
0005433921672	2140	64	23A
0005433921610	2140	65	22H
0005432231378	2140	66	23D
0005433921626	2140	67	23E
0005433921658	2140	68	23G
0005433921663	2140	69	24D
0005433921676	2140	70	24F
0005433921631	2140	71	24G
0005433921662	2140	72	25E
0005433921670	2140	73	27A
0005433921678	2140	74	27E
0005433921645	2140	75	27D
0005432044475	2140	76	27F
0005433921608	2140	77	27H
0005433921681	2140	78	28H
0005432231375	2140	79	29D
0005433921669	2140	80	29B
0005433921637	2140	81	29F
0005433921652	2140	82	30A
0005433921604	2140	83	30B
0005433921635	2140	84	30E
0005433931413	2140	85	30D
0005433921641	2140	86	30F
0005433921651	2140	87	30G
0005432231383	2140	88	31A
0005433921627	2140	89	31E
0005433921628	2140	90	31G
0005433921588	2140	91	32A
0005433921647	2140	92	31H
0005433929542	2140	93	32E
0005433921620	2140	94	33A
0005433921674	2140	95	33B
0005433921614	2140	96	33D
0005433921679	2140	97	33G
0005433921653	2140	98	33F
0005433921613	2140	99	33H
0005433921616	2140	100	34B
0005433921595	2140	101	34A
0005433921677	2140	102	34D
0005433921612	2140	103	34F
0005432231382	2140	104	34E
0005432231381	2140	105	34H
0005433921589	2140	106	35B
0005433921609	2140	107	35F
0005433921640	2140	108	35H
0005433921602	2140	109	35G
0005433921593	2140	110	36B
0005433921657	2140	111	36A
0005433929541	2140	112	36E
0005433921617	2140	113	36F
0005433921592	2140	114	36H
0005433921599	2140	115	37A
0005433921625	2140	116	37F
0005433921596	2140	117	37H
0005432231374	2140	118	38A
0005433921591	2140	119	38E
0005433921607	2140	120	38F
0005433035392	24118	1	1B
0005433035386	24118	2	1F
0005433035391	24118	3	1G
0005433035374	24118	4	2H
0005433035377	24118	5	3G
0005433035396	24118	6	4C
0005433035388	24118	7	5B
0005433035390	24118	8	9A
0005433035364	24118	9	11E
0005433035369	24118	10	11F
0005433035378	24118	11	12A
0005433035398	24118	12	11H
0005432206096	24118	13	12G
0005432207616	24118	14	13E
0005433035381	24118	15	13H
0005433035393	24118	16	14G
0005433035379	24118	17	14F
0005433035384	24118	18	15A
0005433035383	24118	19	15F
0005433035356	24118	20	16D
0005433035370	24118	21	16G
0005432207617	24118	22	17B
0005433035409	24118	23	18B
0005433035380	24118	24	18G
0005433035358	24118	25	18F
0005433035397	24118	26	18H
0005433035373	24118	27	19D
0005432206094	24118	28	19H
0005433035403	24118	29	19G
0005433035366	24118	30	20E
0005433035368	24118	31	20G
0005432206091	24118	32	21F
0005433035404	24118	33	22A
0005433035406	24118	34	22D
0005433035365	24118	35	22F
0005433035371	24118	36	22E
0005433035407	24118	37	23E
0005434028249	24118	38	23G
0005433035375	24118	39	23F
0005433035372	24118	40	24B
0005433035405	24118	41	24E
0005433035385	24118	42	24D
0005433035387	24118	43	24H
0005432207618	24118	44	25D
0005432206093	24118	45	27A
0005433035394	24118	46	27D
0005433035367	24118	47	27E
0005433035363	24118	48	30F
0005433035376	24118	49	30H
0005433035399	24118	50	31D
0005432206095	24118	51	32H
0005434028247	24118	52	32G
0005433035360	24118	53	33A
0005433035410	24118	54	33E
0005433035361	24118	55	34B
0005433035357	24118	56	34A
0005433035389	24118	57	35B
0005433035359	24118	58	35E
0005433035395	24118	59	35D
0005433035400	24118	60	35G
0005434028246	24118	61	36D
0005433035362	24118	62	36E
0005432206092	24118	63	37B
0005433035408	24118	64	37E
0005432749747	24118	65	37D
0005433035401	24118	66	37G
0005433035402	24118	67	37F
0005433035382	24118	68	37H
0005434028248	24118	69	38D
0005432749748	24118	70	38G
0005434550284	277	1	1C
0005434723419	277	2	1A
0005434723381	277	3	1H
0005434723410	277	4	1G
0005434550305	277	5	2A
0005434723388	277	6	1K
0005434550256	277	7	2C
0005434550307	277	8	2G
0005434723407	277	9	2K
0005434550275	277	10	3H
0005434723327	277	11	3K
0005435142344	277	12	4D
0005434723399	277	13	5A
0005434723343	277	14	4H
0005434723346	277	15	5H
0005434723421	277	16	5G
0005434550303	277	17	5K
0005434723394	277	18	11C
0005434723349	277	19	11F
0005434550294	277	20	11G
0005434302381	277	21	12C
0005432277569	277	22	11K
0005434550293	277	23	12G
0005434723359	277	24	13A
0005434723352	277	25	12H
0005432277572	277	26	13C
0005434550288	277	27	13G
0005434723325	277	28	13F
0005434723391	277	29	13E
0005434550270	277	30	13H
0005435142348	277	31	14C
0005434723402	277	32	14A
0005434550276	277	33	14G
0005434550281	277	34	14F
0005432277575	277	35	14E
0005434550263	277	36	15C
0005434723373	277	37	15K
0005434723337	277	38	16D
0005434723378	277	39	16E
0005434723329	277	40	17C
0005434550286	277	41	17E
0005434723431	277	42	17D
0005434550260	277	43	18A
0005434550299	277	44	18B
0005432277580	277	45	18E
0005434723334	277	46	18D
0005434550267	277	47	18C
0005434723355	277	48	18G
0005434550291	277	49	18J
0005434723396	277	50	19B
0005432277574	277	51	19A
0005434550258	277	52	19H
0005434723395	277	53	19G
0005435142337	277	54	19K
0005434550279	277	55	20C
0005434723312	277	56	20B
0005434550277	277	57	20A
0005434723351	277	58	20E
0005434723379	277	59	20D
0005434723314	277	60	20G
0005434723424	277	61	20J
0005434723360	277	62	20H
0005434550283	277	63	21A
0005434723414	277	64	21D
0005434723389	277	65	21C
0005434550306	277	66	21G
0005434550287	277	67	22C
0005435142347	277	68	22G
0005434723433	277	69	22J
0005434723423	277	70	23B
0005434550309	277	71	23A
0005434723345	277	72	23D
0005434723365	277	73	23F
0005434723320	277	74	23E
0005435142341	277	75	23J
0005432277577	277	76	24D
0005434302382	277	77	23K
0005435142342	277	78	24E
0005434723393	277	79	25A
0005434550269	277	80	25D
0005434723366	277	81	25B
0005434723356	277	82	25E
0005434723335	277	83	25G
0005434550265	277	84	26A
0005434723357	277	85	25J
0005435142343	277	86	26C
0005435142346	277	87	26B
0005434723374	277	88	26E
0005434550259	277	89	26H
0005434550268	277	90	26F
0005434723417	277	91	26J
0005434723316	277	92	27D
0005434723406	277	93	27B
0005434723418	277	94	27E
0005434723368	277	95	27J
0005432277581	277	96	28B
0005434550262	277	97	28E
0005434723386	277	98	28D
0005434723403	277	99	28G
0005434550264	277	100	28F
0005434723430	277	101	28H
0005434723333	277	102	29A
0005434723390	277	103	29D
0005434723341	277	104	29C
0005434723321	277	105	29F
0005434550310	277	106	29E
0005434723432	277	107	29J
0005432277571	277	108	29H
0005434723408	277	109	30C
0005434550280	277	110	30B
0005434723319	277	111	30D
0005434723330	277	112	30G
0005434723411	277	113	30J
0005434723369	277	114	31A
0005434550257	277	115	31C
0005434723323	277	116	31E
0005434723380	277	117	31G
0005434723354	277	118	31K
0005434723370	277	119	31J
0005434550300	277	120	32E
0005434723363	277	121	32D
0005435142340	277	122	32F
0005434723383	277	123	32K
0005434550301	277	124	33D
0005434302853	277	125	33C
0005434723364	277	126	33H
0005434723331	277	127	34A
0005434723413	277	128	33K
0005434723313	277	129	33J
0005434723342	277	130	34B
0005434723398	277	131	34E
0005435142335	277	132	34C
0005434723427	277	133	34K
0005434723404	277	134	34J
0005434723362	277	135	35B
0005434723416	277	136	35D
0005434723361	277	137	35C
0005434723382	277	138	35E
0005432277579	277	139	35H
0005434550272	277	140	36A
0005434723353	277	141	36C
0005435142339	277	142	36D
0005434723412	277	143	36K
0005435142338	277	144	36J
0005434723318	277	145	37D
0005434723387	277	146	37C
0005434302383	277	147	37F
0005434550278	277	148	37E
0005434550298	277	149	37J
0005434723348	277	150	38A
0005434723409	277	151	37K
0005434302384	277	152	38C
0005434723385	277	153	38H
0005434723311	277	154	39B
0005434550261	277	155	39A
0005434723336	277	156	39D
0005435142336	277	157	39H
0005434723338	277	158	39K
0005434723344	277	159	39J
0005434723367	277	160	40B
0005432277576	277	161	40D
0005434723392	277	162	40K
0005434723384	277	163	41B
0005434550297	277	164	41D
0005432277573	277	165	41C
0005434550285	277	166	41G
0005434550266	277	167	41E
0005434550302	277	168	41K
0005432277578	277	169	41J
0005434723347	277	170	42C
0005434723428	277	171	42B
0005434723332	277	172	42D
0005434723426	277	173	42G
0005434723375	277	174	43D
0005434723339	277	175	43E
0005434723415	277	176	43H
0005434723425	277	177	43G
0005434723317	277	178	43K
0005434723324	277	179	43J
0005434723315	277	180	44A
0005434550290	277	181	44D
0005434723372	277	182	44C
0005434723326	277	183	45B
0005434723340	277	184	45J
0005434723350	277	185	45G
0005434550308	277	186	45K
0005434550274	277	187	46B
0005434723310	277	188	46A
0005434723422	277	189	46D
0005434723401	277	190	46F
0005434550282	277	191	46K
0005434723376	277	192	47C
0005434723377	277	193	47E
0005434550289	277	194	47D
0005434302385	277	195	47F
0005434723429	277	196	48A
0005434723400	277	197	48F
0005434550296	277	198	48E
0005434550273	277	199	48D
0005434723397	277	200	48H
0005434723322	277	201	48G
0005434550271	277	202	49C
0005434550295	277	203	49A
0005434723420	277	204	49F
0005434550304	277	205	49E
0005434723358	277	206	49H
0005434723405	277	207	50A
0005434723371	277	208	50H
0005434550311	277	209	50F
0005435142345	277	210	51D
0005432277570	277	211	50K
0005434723328	277	212	51E
0005434550292	277	213	51G
0005433233127	9829	1	1A
0005434031947	9829	2	1G
0005433233121	9829	3	1K
0005433180671	9829	4	2C
0005432199129	9829	5	2G
0005433180649	9829	6	3G
0005432199128	9829	7	4G
0005433180661	9829	8	4D
0005433180665	9829	9	4H
0005433233138	9829	10	5D
0005433233096	9829	11	5H
0005432199126	9829	12	11A
0005433233093	9829	13	11D
0005433233111	9829	14	11G
0005433180667	9829	15	11F
0005433233097	9829	16	11H
0005433233110	9829	17	12C
0005433233112	9829	18	13A
0005433180672	9829	19	12H
0005433180664	9829	20	13C
0005433180657	9829	21	13K
0005433233103	9829	22	13G
0005433233091	9829	23	14G
0005433233102	9829	24	15H
0005433233107	9829	25	15G
0005433233118	9829	26	15F
0005433233089	9829	27	18C
0005433233124	9829	28	18A
0005433180653	9829	29	18E
0005433233090	9829	30	18F
0005433233114	9829	31	19A
0005433233143	9829	32	19D
0005433233133	9829	33	19C
0005433233108	9829	34	20F
0005433180673	9829	35	21C
0005433233117	9829	36	21J
0005433113496	9829	37	21H
0005434031946	9829	38	23B
0005433180670	9829	39	23E
0005433233092	9829	40	23H
0005432199123	9829	41	23K
0005433233085	9829	42	25E
0005433233134	9829	43	25H
0005433180668	9829	44	26E
0005433233131	9829	45	26D
0005433766574	9829	46	26F
0005433233080	9829	47	26J
0005433180660	9829	48	27A
0005433233116	9829	49	27C
0005432199124	9829	50	28A
0005433180654	9829	51	28C
0005433180669	9829	52	28B
0005433766573	9829	53	28E
0005433180651	9829	54	28G
0005433233125	9829	55	28J
0005433233115	9829	56	29B
0005432199127	9829	57	29G
0005433233141	9829	58	30B
0005433233086	9829	59	30E
0005433233139	9829	60	30C
0005432199125	9829	61	30J
0005433766575	9829	62	30K
0005433233101	9829	63	31D
0005433233105	9829	64	31F
0005433113495	9829	65	31E
0005433233135	9829	66	31K
0005433180659	9829	67	32H
0005433233123	9829	68	33B
0005433233119	9829	69	32K
0005433233082	9829	70	33K
0005433233120	9829	71	34E
0005433233100	9829	72	35K
0005433233136	9829	73	36F
0005433233099	9829	74	36H
0005433233113	9829	75	36G
0005433233130	9829	76	37F
0005433233126	9829	77	37E
0005433233083	9829	78	37G
0005434031945	9829	79	38A
0005433180655	9829	80	37K
0005433233140	9829	81	39C
0005433233137	9829	82	39B
0005434031944	9829	83	39D
0005433766572	9829	84	40D
0005433180652	9829	85	40F
0005433233129	9829	86	41A
0005433180666	9829	87	41D
0005433233142	9829	88	42A
0005433180648	9829	89	41J
0005433233109	9829	90	42G
0005433180663	9829	91	43D
0005433233088	9829	92	43K
0005433233122	9829	93	44B
0005433233104	9829	94	44H
0005433233095	9829	95	44G
0005433180662	9829	96	45A
0005433233106	9829	97	45E
0005433233094	9829	98	45G
0005433180656	9829	99	46D
0005433233098	9829	100	46J
0005433233128	9829	101	47F
0005433233084	9829	102	48G
0005433233081	9829	103	48K
0005433233132	9829	104	49C
0005433180658	9829	105	49H
0005433180650	9829	106	50E
0005433233087	9829	107	50H
0005432525678	7768	1	1C
0005432525723	7768	2	1A
0005432525761	7768	3	2A
0005434066299	7768	4	1K
0005432525677	7768	5	1H
0005432525642	7768	6	2D
0005432525709	7768	7	2C
0005434066325	7768	8	2G
0005432150061	7768	9	3C
0005434066354	7768	10	3K
0005434066360	7768	11	3H
0005434066313	7768	12	3G
0005432525732	7768	13	4A
0005434066306	7768	14	4G
0005432533242	7768	15	5C
0005432525674	7768	16	5A
0005432525694	7768	17	5D
0005432069406	7768	18	11A
0005432525731	7768	19	5K
0005432525648	7768	20	11D
0005432525634	7768	21	11C
0005432525645	7768	22	11F
0005434066327	7768	23	11E
0005432525727	7768	24	11H
0005434066321	7768	25	11G
0005434066332	7768	26	12C
0005432525744	7768	27	12A
0005432525666	7768	28	12D
0005434066351	7768	29	12F
0005432525733	7768	30	12K
0005432525655	7768	31	13C
0005432525686	7768	32	13F
0005432150057	7768	33	13E
0005434066343	7768	34	13G
0005432535748	7768	35	14A
0005434066322	7768	36	13K
0005432525735	7768	37	14E
0005434066305	7768	38	14H
0005432525730	7768	39	14G
0005434066317	7768	40	15C
0005432525710	7768	41	15A
0005432525667	7768	42	15D
0005432150055	7768	43	15G
0005432525701	7768	44	15K
0005432525669	7768	45	16D
0005432525639	7768	46	16C
0005434066334	7768	47	16E
0005432525765	7768	48	16K
0005434066352	7768	49	17E
0005432525647	7768	50	17G
0005432525739	7768	51	17F
0005434066315	7768	52	18A
0005432525767	7768	53	17K
0005434066355	7768	54	18C
0005432525654	7768	55	18B
0005432525658	7768	56	18E
0005432525644	7768	57	18D
0005434066335	7768	58	18G
0005434066342	7768	59	18F
0005432525736	7768	60	18H
0005434066346	7768	61	19B
0005432150060	7768	62	18K
0005432525662	7768	63	19D
0005434066341	7768	64	19C
0005432525729	7768	65	19H
0005432150054	7768	66	19G
0005432525696	7768	67	19J
0005432525691	7768	68	20B
0005432525697	7768	69	20E
0005432525718	7768	70	20C
0005432525703	7768	71	20F
0005434066362	7768	72	20K
0005432525646	7768	73	21B
0005434066324	7768	74	21A
0005432525685	7768	75	21D
0005434066353	7768	76	21C
0005432525747	7768	77	21H
0005434066340	7768	78	21G
0005434066345	7768	79	22A
0005434066303	7768	80	22D
0005432525716	7768	81	22C
0005432533241	7768	82	22B
0005434066304	7768	83	22E
0005432525668	7768	84	22H
0005432069400	7768	85	22G
0005432069397	7768	86	22J
0005434066333	7768	87	23B
0005432150059	7768	88	23A
0005432535746	7768	89	23D
0005434066326	7768	90	23G
0005432525742	7768	91	23F
0005434066361	7768	92	23J
0005434066295	7768	93	23H
0005434066323	7768	94	24D
0005432428867	7768	95	24F
0005434066318	7768	96	25B
0005432525649	7768	97	25A
0005432150058	7768	98	24G
0005434066319	7768	99	25D
0005434066328	7768	100	25C
0005432525670	7768	101	25F
0005432069404	7768	102	25H
0005432525741	7768	103	25K
0005432069394	7768	104	25J
0005432525754	7768	105	26A
0005434066364	7768	106	26E
0005432525746	7768	107	26G
0005434066316	7768	108	26F
0005432525687	7768	109	26K
0005432525758	7768	110	26J
0005432535745	7768	111	27A
0005434066312	7768	112	27B
0005432525692	7768	113	27E
0005432525635	7768	114	27H
0005432525664	7768	115	27G
0005434066349	7768	116	27J
0005432525714	7768	117	28C
0005432525659	7768	118	28B
0005432525683	7768	119	28G
0005434066366	7768	120	28J
0005432525725	7768	121	28H
0005432525745	7768	122	29B
0005432525766	7768	123	29A
0005434066358	7768	124	28K
0005432525759	7768	125	29C
0005434066300	7768	126	29G
0005432525652	7768	127	30A
0005432525715	7768	128	29J
0005434066314	7768	129	30B
0005432525719	7768	130	30F
0005432069401	7768	131	30K
0005432525717	7768	132	30J
0005432525763	7768	133	31D
0005432525762	7768	134	31G
0005434066302	7768	135	31K
0005434066365	7768	136	31J
0005432069407	7768	137	32C
0005432525748	7768	138	32E
0005434066344	7768	139	32D
0005432525698	7768	140	32G
0005432069403	7768	141	32J
0005432525637	7768	142	32H
0005432525653	7768	143	33B
0005432525651	7768	144	33D
0005432525713	7768	145	33F
0005432525671	7768	146	33J
0005432525700	7768	147	33G
0005434066330	7768	148	34A
0005432525663	7768	149	33K
0005434066297	7768	150	34C
0005434066298	7768	151	34B
0005434066348	7768	152	34D
0005432525721	7768	153	34G
0005434066307	7768	154	34F
0005432535747	7768	155	34J
0005432069399	7768	156	35A
0005432525724	7768	157	35C
0005432525753	7768	158	35J
0005434066331	7768	159	35H
0005432150062	7768	160	36A
0005432069408	7768	161	35K
0005432525752	7768	162	36C
0005434066311	7768	163	36B
0005434066329	7768	164	36F
0005432150056	7768	165	36E
0005432525720	7768	166	36D
0005432525638	7768	167	36K
0005432525665	7768	168	36J
0005432428869	7768	169	37B
0005432525656	7768	170	37E
0005432525705	7768	171	37J
0005432525690	7768	172	38A
0005434066339	7768	173	37K
0005434066350	7768	174	38C
0005432525737	7768	175	38J
0005432525707	7768	176	39B
0005432428868	7768	177	39G
0005432525755	7768	178	39F
0005434066320	7768	179	39D
0005432525702	7768	180	39K
0005432525641	7768	181	39J
0005432525751	7768	182	40C
0005432069395	7768	183	40B
0005434066310	7768	184	40F
0005434066296	7768	185	40D
0005432525726	7768	186	40K
0005432525689	7768	187	40J
0005432525693	7768	188	41A
0005432525643	7768	189	41D
0005432525673	7768	190	41C
0005432535749	7768	191	41F
0005432525681	7768	192	41E
0005432525704	7768	193	41H
0005432525738	7768	194	41G
0005434066338	7768	195	42A
0005432525688	7768	196	41K
0005432525650	7768	197	42B
0005432525708	7768	198	42E
0005432525743	7768	199	42K
0005432525657	7768	200	42J
0005432525660	7768	201	43C
0005432525695	7768	202	43F
0005432525640	7768	203	43G
0005432525672	7768	204	43K
0005432069396	7768	205	43J
0005432525712	7768	206	44B
0005434066337	7768	207	44E
0005434066356	7768	208	44G
0005432525757	7768	209	44F
0005432069402	7768	210	44K
0005432533240	7768	211	44H
0005432069398	7768	212	45B
0005432525760	7768	213	45F
0005434066336	7768	214	45H
0005432525756	7768	215	45G
0005432525675	7768	216	46E
0005432525699	7768	217	46D
0005432525722	7768	218	46G
0005434066359	7768	219	46F
0005432525636	7768	220	46H
0005432525740	7768	221	46K
0005432525734	7768	222	47D
0005434066357	7768	223	47C
0005432525728	7768	224	48A
0005432525676	7768	225	47K
0005432525711	7768	226	48C
0005432069405	7768	227	48E
0005434066309	7768	228	48H
0005432525749	7768	229	49A
0005434066363	7768	230	49D
0005432525706	7768	231	49C
0005432525679	7768	232	49G
0005432525684	7768	233	49F
0005432525682	7768	234	49K
0005432525680	7768	235	49H
0005432525750	7768	236	50C
0005432525764	7768	237	50A
0005434066301	7768	238	50E
0005434066308	7768	239	50D
0005434066347	7768	240	50F
0005432525661	7768	241	51E
0005435611762	5354	1	1A
0005434343587	5354	2	1H
0005432132951	5354	3	1G
0005434343593	5354	4	1K
0005435611739	5354	5	2H
0005435611766	5354	6	3A
0005435611757	5354	7	4H
0005434573103	5354	8	5C
0005435097048	5354	9	5A
0005435611769	5354	10	5G
0005434343591	5354	11	11C
0005435611727	5354	12	11G
0005434343600	5354	13	11F
0005435097051	5354	14	12C
0005432132947	5354	15	12F
0005435611699	5354	16	13D
0005435611731	5354	17	13C
0005435097047	5354	18	13A
0005432132954	5354	19	14A
0005432132942	5354	20	14E
0005435611713	5354	21	14C
0005434573110	5354	22	15C
0005435611722	5354	23	15E
0005434343611	5354	24	16A
0005434573104	5354	25	15K
0005435611700	5354	26	16C
0005435611743	5354	27	16F
0005435611754	5354	28	17D
0005434573106	5354	29	17K
0005432132955	5354	30	18C
0005435611701	5354	31	18B
0005434343609	5354	32	18D
0005435611746	5354	33	19F
0005435611737	5354	34	20E
0005435611755	5354	35	20D
0005435611748	5354	36	20F
0005435611715	5354	37	21H
0005435611733	5354	38	22B
0005432047485	5354	39	22F
0005434573101	5354	40	22J
0005435097044	5354	41	23F
0005435611740	5354	42	23H
0005432132941	5354	43	23K
0005434343605	5354	44	24G
0005434343608	5354	45	25E
0005435611738	5354	46	25G
0005435611698	5354	47	26A
0005435097043	5354	48	26D
0005435611717	5354	49	26H
0005434343610	5354	50	27A
0005432132953	5354	51	27C
0005435611750	5354	52	27B
0005434343599	5354	53	27F
0005435611742	5354	54	27J
0005434573102	5354	55	27G
0005432132944	5354	56	27K
0005434343603	5354	57	28E
0005435611734	5354	58	28G
0005435611714	5354	59	28F
0005435611712	5354	60	29B
0005435611702	5354	61	29C
0005432047484	5354	62	29G
0005435611741	5354	63	29F
0005435611751	5354	64	29H
0005432132952	5354	65	30E
0005435611708	5354	66	30D
0005435611719	5354	67	30G
0005434343589	5354	68	30J
0005435611756	5354	69	31E
0005434573107	5354	70	31H
0005435611764	5354	71	32C
0005434343613	5354	72	32B
0005434343597	5354	73	32D
0005434573115	5354	74	32G
0005435611753	5354	75	32F
0005432047486	5354	76	32J
0005435611707	5354	77	32K
0005434343586	5354	78	33C
0005435097049	5354	79	33H
0005435097050	5354	80	33G
0005434343615	5354	81	34A
0005435611763	5354	82	33K
0005434343595	5354	83	33J
0005435611730	5354	84	34G
0005434573114	5354	85	34K
0005435611725	5354	86	35B
0005435611723	5354	87	35F
0005435611710	5354	88	35E
0005435611726	5354	89	36A
0005434343585	5354	90	36B
0005434343602	5354	91	36E
0005435611771	5354	92	36G
0005432132945	5354	93	36K
0005435611718	5354	94	36J
0005434343604	5354	95	37A
0005434343590	5354	96	37D
0005434343582	5354	97	37C
0005434343592	5354	98	37G
0005434343601	5354	99	37J
0005434573108	5354	100	38A
0005434343594	5354	101	38H
0005435611765	5354	102	38C
0005435097046	5354	103	38B
0005435611761	5354	104	38J
0005432132948	5354	105	39B
0005435611706	5354	106	39E
0005434343584	5354	107	39J
0005435611760	5354	108	39H
0005432132943	5354	109	40A
0005432132949	5354	110	40B
0005435611745	5354	111	40D
0005435611705	5354	112	40H
0005435611728	5354	113	41B
0005434343606	5354	114	41D
0005435611759	5354	115	41C
0005434573111	5354	116	41G
0005435611711	5354	117	41F
0005435611709	5354	118	41K
0005434343588	5354	119	42C
0005435611724	5354	120	42B
0005434573105	5354	121	42E
0005435611767	5354	122	42G
0005435611752	5354	123	42H
0005435611758	5354	124	42K
0005434343607	5354	125	43C
0005434343596	5354	126	43J
0005435611772	5354	127	44C
0005434343583	5354	128	44A
0005434343598	5354	129	44E
0005432132946	5354	130	44H
0005435611768	5354	131	44G
0005435611720	5354	132	44J
0005435611747	5354	133	44K
0005435611721	5354	134	45F
0005434573113	5354	135	45J
0005435611732	5354	136	45H
0005434343612	5354	137	45K
0005435611703	5354	138	46C
0005434343614	5354	139	46B
0005435611729	5354	140	47C
0005435611716	5354	141	46K
0005435611770	5354	142	47F
0005435611749	5354	143	47K
0005434573109	5354	144	48D
0005435097045	5354	145	48F
0005432132950	5354	146	48G
0005434343616	5354	147	49C
0005435611736	5354	148	49A
0005434573112	5354	149	48K
0005435611704	5354	150	49G
0005435611744	5354	151	50H
0005435611735	5354	152	51G
0005434244460	10895	1	1A
0005432840976	10895	2	2H
0005435423601	10895	3	3H
0005435423610	10895	4	4D
0005434656521	10895	5	4K
0005432166845	10895	6	11A
0005432164904	10895	7	11F
0005434244482	10895	8	11H
0005434244467	10895	9	12C
0005435423600	10895	10	12E
0005435423613	10895	11	12H
0005435423615	10895	12	12G
0005434244474	10895	13	13C
0005434656520	10895	14	13F
0005435423623	10895	15	14D
0005434244476	10895	16	14G
0005435423591	10895	17	15D
0005432164906	10895	18	15A
0005434244471	10895	19	15E
0005433719080	10895	20	15G
0005435423637	10895	21	16C
0005435423626	10895	22	17C
0005435423594	10895	23	17A
0005435423616	10895	24	17D
0005435423639	10895	25	18B
0005435423642	10895	26	18D
0005435423640	10895	27	18J
0005434244480	10895	28	19A
0005434244455	10895	29	19D
0005434244477	10895	30	19G
0005435423619	10895	31	20E
0005435423627	10895	32	20F
0005434244473	10895	33	20H
0005435423644	10895	34	21B
0005435423598	10895	35	21A
0005435423587	10895	36	21D
0005434244461	10895	37	21G
0005435423631	10895	38	21K
0005435423643	10895	39	22E
0005435042820	10895	40	22K
0005435423614	10895	41	23B
0005434244464	10895	42	23A
0005434244463	10895	43	23K
0005435423582	10895	44	24F
0005435423595	10895	45	25F
0005433719082	10895	46	25J
0005435423592	10895	47	25H
0005434244459	10895	48	26C
0005434244458	10895	49	26B
0005435423636	10895	50	26D
0005432166844	10895	51	26G
0005435423584	10895	52	26K
0005435423612	10895	53	27D
0005435423576	10895	54	27C
0005435042822	10895	55	28C
0005434244472	10895	56	28B
0005435423632	10895	57	28A
0005435423588	10895	58	28G
0005435423617	10895	59	28J
0005434244457	10895	60	29H
0005432164902	10895	61	29K
0005435423645	10895	62	30E
0005435423604	10895	63	31B
0005435423628	10895	64	31D
0005435423597	10895	65	31F
0005435423599	10895	66	31H
0005432363359	10895	67	32C
0005435423622	10895	68	32K
0005432164903	10895	69	33B
0005434244456	10895	70	33D
0005435423634	10895	71	33C
0005432164901	10895	72	33F
0005434244475	10895	73	33H
0005434244470	10895	74	33K
0005435423583	10895	75	34E
0005435423578	10895	76	34F
0005434244479	10895	77	35C
0005434244481	10895	78	35F
0005435423586	10895	79	35H
0005435423620	10895	80	35G
0005432166843	10895	81	36A
0005435423638	10895	82	36C
0005434244483	10895	83	36F
0005433719081	10895	84	36H
0005435423635	10895	85	36G
0005435423589	10895	86	37E
0005435423608	10895	87	37D
0005435042821	10895	88	37C
0005435423577	10895	89	37G
0005435423603	10895	90	37H
0005435423580	10895	91	37J
0005432363360	10895	92	38J
0005434244466	10895	93	39A
0005435423633	10895	94	39G
0005434244469	10895	95	39K
0005435423593	10895	96	40E
0005435423611	10895	97	40G
0005435042823	10895	98	40K
0005434244465	10895	99	41F
0005433719083	10895	100	41E
0005435423596	10895	101	41K
0005435423579	10895	102	42B
0005435423605	10895	103	43C
0005435423609	10895	104	43B
0005435423629	10895	105	43G
0005434244453	10895	106	43J
0005432164907	10895	107	44H
0005435423624	10895	108	45B
0005435423621	10895	109	45D
0005435423641	10895	110	45H
0005435423602	10895	111	45G
0005434244468	10895	112	45K
0005435423625	10895	113	46D
0005435423618	10895	114	46K
0005435423585	10895	115	46H
0005435423607	10895	116	47C
0005435423581	10895	117	47G
0005434244454	10895	118	48F
0005432164905	10895	119	48H
0005435423590	10895	120	49C
0005434244478	10895	121	48K
0005432164908	10895	122	49D
0005435423606	10895	123	51D
0005435423630	10895	124	50K
0005435423575	10895	125	51F
0005434244462	10895	126	51G
0005433804786	3316	1	1F
0005433804791	3316	2	1D
0005433804793	3316	3	2D
0005433633228	3316	4	2C
0005433506853	3316	5	2F
0005433633225	3316	6	3A
0005433633239	3316	7	3F
0005433633226	3316	8	4A
0005433633227	3316	9	4D
0005432181320	3316	10	5C
0005433633217	3316	11	5F
0005433633231	3316	12	5D
0005433633222	3316	13	7A
0005433506856	3316	14	7C
0005433506855	3316	15	7F
0005433633214	3316	16	7D
0005433633221	3316	17	8C
0005433804780	3316	18	8B
0005432181330	3316	19	8D
0005433804788	3316	20	8F
0005433633213	3316	21	9A
0005432181331	3316	22	9C
0005433633220	3316	23	9E
0005433633245	3316	24	9D
0005433506857	3316	25	10A
0005433506861	3316	26	10C
0005432181325	3316	27	10B
0005432181339	3316	28	10D
0005433633247	3316	29	11B
0005433633241	3316	30	11C
0005433804782	3316	31	11D
0005432181329	3316	32	11F
0005432181327	3316	33	12B
0005432181332	3316	34	12E
0005433506866	3316	35	13A
0005433804790	3316	36	13D
0005432181323	3316	37	13E
0005433633244	3316	38	14A
0005433804787	3316	39	14D
0005433506867	3316	40	14C
0005433633229	3316	41	14F
0005433506870	3316	42	15B
0005432181322	3316	43	15A
0005433804781	3316	44	15E
0005432181324	3316	45	16A
0005433633219	3316	46	15F
0005433804778	3316	47	16C
0005433804783	3316	48	16E
0005433633224	3316	49	17B
0005433804784	3316	50	17C
0005433506862	3316	51	18A
0005432181321	3316	52	17F
0005432181333	3316	53	18C
0005433506868	3316	54	18E
0005433633230	3316	55	18F
0005432181334	3316	56	19C
0005433633235	3316	57	20B
0005432181337	3316	58	20A
0005433633215	3316	59	20E
0005433633233	3316	60	21B
0005433633242	3316	61	21D
0005433506860	3316	62	22B
0005433506869	3316	63	22A
0005433633234	3316	64	22D
0005433633216	3316	65	22C
0005433633223	3316	66	22F
0005433506859	3316	67	23A
0005433506858	3316	68	23B
0005433633237	3316	69	23D
0005432181335	3316	70	23C
0005433506854	3316	71	23F
0005432181340	3316	72	24B
0005433804777	3316	73	24E
0005432181319	3316	74	24F
0005433506863	3316	75	25A
0005432181326	3316	76	26A
0005433804789	3316	77	26C
0005433506871	3316	78	26E
0005432181336	3316	79	27A
0005432181338	3316	80	27D
0005433633232	3316	81	27F
0005433633236	3316	82	28A
0005433804785	3316	83	28D
0005433804792	3316	84	28C
0005433633243	3316	85	29B
0005433633246	3316	86	29A
0005433506864	3316	87	29C
0005432181328	3316	88	29E
0005433804779	3316	89	29F
0005433633218	3316	90	30B
0005433633238	3316	91	30A
0005433633240	3316	92	30F
0005433506865	3316	93	31C
0005435884382	8323	1	1C
0005432458972	8323	2	1A
0005432458984	8323	3	1F
0005435884409	8323	4	2A
0005432458964	8323	5	2C
0005432458973	8323	6	2D
0005435884393	8323	7	2F
0005432458992	8323	8	3D
0005432459008	8323	9	3C
0005435884385	8323	10	3F
0005435884375	8323	11	4D
0005435884414	8323	12	4F
0005432458980	8323	13	5D
0005432042479	8323	14	6A
0005432042473	8323	15	6C
0005432458965	8323	16	6D
0005432458991	8323	17	7C
0005432459003	8323	18	7F
0005432458999	8323	19	8D
0005435884405	8323	20	8C
0005435884410	8323	21	9A
0005432042478	8323	22	8F
0005435884408	8323	23	9B
0005432458978	8323	24	9C
0005432458956	8323	25	9D
0005432459005	8323	26	10A
0005435884411	8323	27	10B
0005432042469	8323	28	10D
0005435884384	8323	29	10C
0005435884377	8323	30	10E
0005432458979	8323	31	11C
0005432458967	8323	32	11B
0005432458993	8323	33	11D
0005435884417	8323	34	11E
0005435884378	8323	35	12A
0005435884418	8323	36	11F
0005435884415	8323	37	12C
0005432458990	8323	38	12E
0005432458995	8323	39	12D
0005432458963	8323	40	13A
0005432042471	8323	41	12F
0005432458962	8323	42	13B
0005432459001	8323	43	13C
0005435884420	8323	44	13F
0005435884425	8323	45	13E
0005432458971	8323	46	14A
0005432458996	8323	47	14C
0005435884381	8323	48	14D
0005435884372	8323	49	14E
0005435884424	8323	50	14F
0005435884373	8323	51	15B
0005432458960	8323	52	15F
0005435884374	8323	53	15E
0005435884422	8323	54	16A
0005435884391	8323	55	16C
0005432458985	8323	56	16F
0005435884401	8323	57	17B
0005432458970	8323	58	17C
0005435884407	8323	59	17D
0005432458968	8323	60	17E
0005432459006	8323	61	18B
0005434312283	8323	62	18D
0005435884386	8323	63	18C
0005432458974	8323	64	18E
0005434312284	8323	65	19C
0005435884412	8323	66	19B
0005432458977	8323	67	19E
0005435884389	8323	68	20B
0005435884404	8323	69	20A
0005432459000	8323	70	20D
0005435884397	8323	71	20C
0005432042475	8323	72	20E
0005432458966	8323	73	20F
0005435884383	8323	74	21A
0005435884371	8323	75	21C
0005432458988	8323	76	21E
0005435884426	8323	77	21D
0005432458975	8323	78	22B
0005435884402	8323	79	22A
0005435884398	8323	80	22D
0005435884396	8323	81	22C
0005435884416	8323	82	22E
0005432458997	8323	83	23A
0005435884390	8323	84	23C
0005435884370	8323	85	23B
0005432458983	8323	86	23D
0005435884394	8323	87	23E
0005432042472	8323	88	24A
0005435884400	8323	89	23F
0005432042476	8323	90	24D
0005435884421	8323	91	24C
0005435884419	8323	92	24E
0005435884395	8323	93	25B
0005432459004	8323	94	25A
0005432458976	8323	95	25D
0005432458961	8323	96	25C
0005432459009	8323	97	25E
0005435884413	8323	98	25F
0005435884423	8323	99	26B
0005432458989	8323	100	26A
0005432042474	8323	101	26C
0005432458987	8323	102	26E
0005435884387	8323	103	26F
0005432458969	8323	104	27C
0005435884376	8323	105	27D
0005432459002	8323	106	27F
0005432458957	8323	107	27E
0005435884406	8323	108	28C
0005435884399	8323	109	28B
0005432459007	8323	110	28A
0005432042480	8323	111	28E
0005432458998	8323	112	29A
0005432458981	8323	113	29C
0005432458958	8323	114	29B
0005432458959	8323	115	29D
0005432458982	8323	116	29F
0005432042470	8323	117	29E
0005435884379	8323	118	30A
0005432042468	8323	119	30B
0005435884392	8323	120	30C
0005435884380	8323	121	30E
0005432042477	8323	122	30D
0005432458986	8323	123	31C
0005432458994	8323	124	31D
0005435884403	8323	125	31F
0005435884388	8323	126	31E
0005432382506	4522	1	1A
0005432382517	4522	2	1F
0005432727721	4522	3	3A
0005432382485	4522	4	3C
0005432382509	4522	5	3D
0005432382488	4522	6	3F
0005432727716	4522	7	4A
0005432727720	4522	8	5A
0005433722105	4522	9	5D
0005432382501	4522	10	5E
0005432382505	4522	11	5F
0005432382511	4522	12	6C
0005432382500	4522	13	6E
0005432727722	4522	14	7A
0005432382495	4522	15	7F
0005432382508	4522	16	8A
0005432727727	4522	17	8C
0005432382492	4522	18	8D
0005432727725	4522	19	9C
0005432382497	4522	20	9D
0005432382486	4522	21	9F
0005432382512	4522	22	10C
0005432382507	4522	23	10D
0005432382493	4522	24	10F
0005433722106	4522	25	11A
0005432382514	4522	26	11C
0005433722103	4522	27	11D
0005432382484	4522	28	11F
0005432382502	4522	29	12A
0005432382499	4522	30	12C
0005432382519	4522	31	12F
0005432382503	4522	32	13C
0005432382504	4522	33	13D
0005433722104	4522	34	13F
0005433453727	4522	35	14A
0005432382510	4522	36	14C
0005432727719	4522	37	14E
0005432727718	4522	38	14F
0005432382498	4522	39	15A
0005433722102	4522	40	15C
0005432382496	4522	41	15D
0005432382487	4522	42	15E
0005432382516	4522	43	15F
0005432727717	4522	44	16A
0005432727723	4522	45	16C
0005432382518	4522	46	16F
0005432382490	4522	47	17A
0005433454838	4522	48	17C
0005432382489	4522	49	17F
0005432727724	4522	50	18A
0005433453726	4522	51	18C
0005432727726	4522	52	19C
0005432382494	4522	53	19D
0005432382515	4522	54	19E
0005433454837	4522	55	19F
0005432382513	4522	56	20A
0005432382491	4522	57	20D
0005432382520	4522	58	20E
0005435528884	1764	1	1C
0005433516726	1764	2	1D
0005432294445	1764	3	1F
0005435540628	1764	4	2C
0005435528879	1764	5	2F
0005435528885	1764	6	3A
0005435528896	1764	7	3C
0005435540640	1764	8	4E
0005435540625	1764	9	5C
0005435540639	1764	10	5D
0005435540638	1764	11	5E
0005435540630	1764	12	5F
0005435528894	1764	13	6D
0005435540627	1764	14	6E
0005435528893	1764	15	6F
0005435540633	1764	16	7A
0005435528898	1764	17	7D
0005435540635	1764	18	7E
0005435528891	1764	19	7F
0005433516727	1764	20	8C
0005435540643	1764	21	8F
0005435540641	1764	22	9A
0005435540634	1764	23	9C
0005435540632	1764	24	9E
0005435528880	1764	25	9F
0005433516722	1764	26	10A
0005435528887	1764	27	10C
0005435540629	1764	28	10E
0005435528883	1764	29	10F
0005435528881	1764	30	11A
0005435528882	1764	31	11C
0005435540631	1764	32	11E
0005435540623	1764	33	12C
0005433516729	1764	34	13A
0005435540637	1764	35	13D
0005435528895	1764	36	13E
0005433516721	1764	37	14A
0005435528899	1764	38	14C
0005435540642	1764	39	14D
0005435528892	1764	40	14E
0005435528900	1764	41	15A
0005435540636	1764	42	15C
0005432294446	1764	43	15D
0005435528886	1764	44	15E
0005435540626	1764	45	15F
0005433516723	1764	46	16E
0005435540622	1764	47	16F
0005435528890	1764	48	17E
0005435540624	1764	49	17F
0005433516725	1764	50	18A
0005433516724	1764	51	18C
0005435528888	1764	52	20A
0005435528889	1764	53	20C
0005435528897	1764	54	20D
0005433516728	1764	55	20F
0005432924953	21969	1	6A
0005432924951	21969	2	9E
0005432924955	21969	3	12D
0005432924952	21969	4	14D
0005432924954	21969	5	15E
0005434458440	7364	1	1A
0005432838490	7364	2	1C
0005432838492	7364	3	1F
0005434458439	7364	4	2A
0005432838507	7364	5	2C
0005432838495	7364	6	4C
0005434458449	7364	7	4D
0005434458437	7364	8	4E
0005434458448	7364	9	5E
0005432838510	7364	10	5F
0005432838488	7364	11	6A
0005432073330	7364	12	6E
0005434458433	7364	13	6F
0005434458436	7364	14	7A
0005432838505	7364	15	7E
0005434458450	7364	16	7F
0005432838498	7364	17	8A
0005434458452	7364	18	8C
0005434458434	7364	19	8D
0005432838509	7364	20	8E
0005432838497	7364	21	9D
0005432073331	7364	22	9E
0005434458443	7364	23	10A
0005432838496	7364	24	10C
0005432838484	7364	25	10E
0005434458453	7364	26	11D
0005432838489	7364	27	11E
0005432838487	7364	28	12C
0005432838480	7364	29	12E
0005434458435	7364	30	12F
0005434458438	7364	31	13A
0005434458442	7364	32	13D
0005434458451	7364	33	13F
0005432838499	7364	34	14A
0005432073329	7364	35	14C
0005432838481	7364	36	14D
0005432838483	7364	37	14E
0005432838503	7364	38	14F
0005432838511	7364	39	15C
0005432838485	7364	40	15D
0005434458441	7364	41	15E
0005432838501	7364	42	15F
0005434458447	7364	43	17A
0005432838482	7364	44	17D
0005434458444	7364	45	17C
0005432838502	7364	46	17E
0005432838486	7364	47	18C
0005434458445	7364	48	18D
0005432838508	7364	49	18E
0005432838500	7364	50	19C
0005434458446	7364	51	19D
0005432838493	7364	52	19E
0005432838491	7364	53	20C
0005432838506	7364	54	20D
0005432838494	7364	55	20E
0005432838504	7364	56	20F
0005435252378	28935	1	1A
0005435252382	28935	2	1D
0005435252385	28935	3	2C
0005435252379	28935	4	2D
0005435252390	28935	5	3A
0005435252381	28935	6	4E
0005435252396	28935	7	5C
0005435491407	28935	8	6A
0005435252383	28935	9	6D
0005432000987	28935	10	7A
0005435252393	28935	11	8A
0005435252392	28935	12	9F
0005435252388	28935	13	10A
0005432000988	28935	14	10E
0005434664920	28935	15	11D
0005435252380	28935	16	11F
0005434664919	28935	17	14F
0005435252384	28935	18	15C
0005435252389	28935	19	16A
0005435252395	28935	20	18A
0005435491405	28935	21	18D
0005435491406	28935	22	18E
0005435252391	28935	23	19E
0005435252387	28935	24	19F
0005435252394	28935	25	20E
0005435252386	28935	26	20F
0005435990502	8817	1	3A
0005435990497	8817	2	6B
0005435990498	8817	3	6D
0005435990503	8817	4	7E
0005435990501	8817	5	13B
0005435990499	8817	6	14C
0005435990500	8817	7	20B
0005434275928	15750	1	1F
0005434275925	15750	2	11C
0005434275926	15750	3	11D
0005434275924	15750	4	18A
0005434275927	15750	5	20D
0005433468183	2079	1	1D
0005433468182	2079	2	3B
0005433468185	2079	3	5D
0005433468184	2079	4	7C
0005433468181	2079	5	20C
0005433468186	2079	6	21C
0005433468180	2079	7	22D
0005433468187	2079	8	23A
0005433468188	2079	9	23B
0005432359506	6411	1	1A
0005432062135	6411	2	1F
0005432359555	6411	3	2C
0005432359536	6411	4	2D
0005432335821	6411	5	3C
0005432335824	6411	6	3A
0005432359533	6411	7	3F
0005432359552	6411	8	4B
0005432359525	6411	9	4E
0005432335829	6411	10	4D
0005432359537	6411	11	5B
0005432359513	6411	12	5C
0005432359521	6411	13	6C
0005432062136	6411	14	6B
0005432359527	6411	15	6D
0005432335825	6411	16	7D
0005432359540	6411	17	7E
0005432335822	6411	18	8A
0005432359544	6411	19	8C
0005432363360	6411	20	8E
0005432359507	6411	21	8F
0005432359550	6411	22	9B
0005432335823	6411	23	9C
0005432359529	6411	24	9F
0005432359543	6411	25	10B
0005432359511	6411	26	10E
0005432359528	6411	27	11D
0005432359551	6411	28	11F
0005432359522	6411	29	12B
0005432359547	6411	30	12D
0005432359510	6411	31	12C
0005432359532	6411	32	12E
0005432359524	6411	33	12F
0005432359508	6411	34	13A
0005432359541	6411	35	13B
0005432359542	6411	36	13D
0005432335827	6411	37	13E
0005432359512	6411	38	13F
0005432359518	6411	39	14A
0005432359517	6411	40	14C
0005432359548	6411	41	14F
0005432062134	6411	42	15B
0005432062137	6411	43	15D
0005432363359	6411	44	15E
0005432335820	6411	45	16A
0005432359519	6411	46	15F
0005432359539	6411	47	16B
0005432359554	6411	48	16E
0005432359534	6411	49	16F
0005432062139	6411	50	17A
0005432335826	6411	51	17E
0005432335830	6411	52	18A
0005432359530	6411	53	17F
0005432335831	6411	54	18B
0005432335828	6411	55	18D
0005432062138	6411	56	18C
0005432359526	6411	57	18F
0005432359520	6411	58	19C
0005432359545	6411	59	20B
0005432359531	6411	60	20C
0005432359515	6411	61	20E
0005432359514	6411	62	21B
0005432359523	6411	63	21F
0005432359538	6411	64	22A
0005432359546	6411	65	22B
0005432359535	6411	66	22E
0005432359553	6411	67	23A
0005432359549	6411	68	22F
0005432359516	6411	69	23B
0005432359509	6411	70	23C
0005435176585	20993	1	1C
0005435723010	20993	2	2A
0005434149526	20993	3	3C
0005435176587	20993	4	4B
0005435176608	20993	5	4E
0005434149522	20993	6	4F
0005435176610	20993	7	5C
0005435176594	20993	8	5F
0005435176612	20993	9	5E
0005435723009	20993	10	6D
0005435176601	20993	11	7B
0005435176603	20993	12	8A
0005435176596	20993	13	7F
0005432052694	20993	14	8C
0005435176602	20993	15	8F
0005434149529	20993	16	9A
0005432052692	20993	17	9B
0005435176590	20993	18	9C
0005435176600	20993	19	9E
0005434149521	20993	20	9D
0005435176588	20993	21	9F
0005435176599	20993	22	10B
0005434149528	20993	23	10C
0005435490169	20993	24	10E
0005432052693	20993	25	11A
0005434149530	20993	26	11E
0005435176592	20993	27	11F
0005435176593	20993	28	12B
0005432052691	20993	29	12C
0005435176609	20993	30	13D
0005435176597	20993	31	13E
0005435490172	20993	32	14D
0005435176604	20993	33	14E
0005434149531	20993	34	14F
0005435176591	20993	35	15C
0005435176589	20993	36	15B
0005434149527	20993	37	16A
0005435176586	20993	38	15F
0005435176611	20993	39	17A
0005435176598	20993	40	17B
0005435176607	20993	41	18A
0005434149525	20993	42	18B
0005435176605	20993	43	18E
0005435176595	20993	44	19A
0005435490173	20993	45	19B
0005435176606	20993	46	19E
0005434149523	20993	47	22D
0005435490170	20993	48	22F
0005434149520	20993	49	23A
0005435490171	20993	50	23B
0005434149524	20993	51	23E
0005434186148	17732	1	4D
0005434186147	17732	2	7D
0005434186149	17732	3	20A
0005434458435	29107	1	1A
0005434458448	29107	2	2A
0005434458445	29107	3	2C
0005434458442	29107	4	3A
0005434458446	29107	5	3C
0005434458449	29107	6	4A
0005434458452	29107	7	4C
0005434458437	29107	8	5C
0005434458450	29107	9	5D
0005434458440	29107	10	6A
0005434458453	29107	11	6B
0005434458447	29107	12	7C
0005434458444	29107	13	7D
0005434458451	29107	14	18B
0005434458433	29107	15	19B
0005434458439	29107	16	20D
0005434458434	29107	17	21B
0005434458441	29107	18	22A
0005434458438	29107	19	22B
0005434458436	29107	20	22C
0005434458443	29107	21	22D
0005435221036	31696	1	1B
0005435221035	31696	2	1C
0005435221497	31696	3	2A
0005433293144	29590	1	2D
0005433293143	29590	2	7A
0005433293145	29590	3	18A
0005433293142	29590	4	18D
0005433293146	29590	5	20C
0005433293147	29590	6	21C
0005433473104	6691	1	2A
0005433473108	6691	2	3B
0005433473101	6691	3	4A
0005433473107	6691	4	6A
0005433473103	6691	5	6B
0005433473106	6691	6	18A
0005433473105	6691	7	21B
0005433473102	6691	8	22C
0005433473100	6691	9	23A
0005432746899	370	1	1A
0005432746871	370	2	1D
0005432746901	370	3	1F
0005432746867	370	4	2C
0005432746878	370	5	3C
0005432746869	370	6	4A
0005432746898	370	7	4C
0005432746876	370	8	4D
0005432746886	370	9	4F
0005432746872	370	10	5A
0005432746880	370	11	5C
0005432746896	370	12	5E
0005432746893	370	13	5F
0005432219928	370	14	6E
0005432746883	370	15	7A
0005432219929	370	16	7D
0005432746891	370	17	7E
0005432746902	370	18	8C
0005432746875	370	19	8D
0005432746887	370	20	9C
0005432746900	370	21	10E
0005432746895	370	22	10F
0005432746865	370	23	11A
0005432746866	370	24	11E
0005432746884	370	25	11F
0005432746889	370	26	12C
0005432746888	370	27	12D
0005432746873	370	28	12F
0005432746890	370	29	13F
0005432746877	370	30	14C
0005432746879	370	31	14E
0005432746868	370	32	14F
0005432746874	370	33	16D
0005432746892	370	34	16E
0005432219926	370	35	17C
0005432746881	370	36	17E
0005432746864	370	37	17F
0005432746897	370	38	18C
0005432746870	370	39	19C
0005432746882	370	40	19D
0005432219927	370	41	19E
0005432746885	370	42	20C
0005432746894	370	43	20F
0005432890687	12076	1	1A
0005432890680	12076	2	1C
0005432890679	12076	3	2A
0005432214765	12076	4	2D
0005432890686	12076	5	3D
0005432890688	12076	6	4F
0005432214766	12076	7	5F
0005432214764	12076	8	6C
0005432890670	12076	9	8C
0005433875352	12076	10	8F
0005432890675	12076	11	10F
0005432890671	12076	12	11E
0005432890689	12076	13	12E
0005432890672	12076	14	13C
0005432890677	12076	15	13D
0005432890678	12076	16	14D
0005432890674	12076	17	15D
0005432890683	12076	18	16C
0005432890669	12076	19	17C
0005432890673	12076	20	17E
0005432890682	12076	21	17F
0005432890684	12076	22	18D
0005432890681	12076	23	18E
0005432890676	12076	24	19D
0005432890685	12076	25	20F
0005432927886	32474	1	6A
0005432927885	32474	2	6B
0005432927888	32474	3	20C
0005432927889	32474	4	22A
0005432927887	32474	5	22B
0005434821383	5254	1	1C
0005434821405	5254	2	1G
0005432396171	5254	3	2A
0005434821341	5254	4	2H
0005434821329	5254	5	3G
0005434821353	5254	6	3C
0005434821372	5254	7	4C
0005434821375	5254	8	4A
0005434821347	5254	9	4G
0005435149796	5254	10	4H
0005432394035	5254	11	5C
0005434821390	5254	12	5A
0005432121094	5254	13	5H
0005434821349	5254	14	11A
0005434821389	5254	15	11F
0005434821357	5254	16	11K
0005434821364	5254	17	11H
0005434821323	5254	18	12G
0005434821419	5254	19	12F
0005434821348	5254	20	13H
0005434821345	5254	21	13G
0005434821358	5254	22	14A
0005434821346	5254	23	13K
0005432394033	5254	24	14C
0005434821438	5254	25	14G
0005434821382	5254	26	14F
0005434821338	5254	27	15A
0005434821437	5254	28	14K
0005434821377	5254	29	15F
0005432121085	5254	30	16A
0005434821325	5254	31	15K
0005434821340	5254	32	15H
0005434821411	5254	33	16D
0005434821367	5254	34	16C
0005432121090	5254	35	16F
0005432121087	5254	36	16H
0005434821426	5254	37	16G
0005434821337	5254	38	17D
0005434821397	5254	39	17G
0005434821417	5254	40	17F
0005434821392	5254	41	17H
0005434821363	5254	42	18E
0005434821343	5254	43	18C
0005434821321	5254	44	18J
0005434821332	5254	45	19C
0005434821386	5254	46	19E
0005434821312	5254	47	20C
0005434821422	5254	48	21B
0005434821391	5254	49	21A
0005434821316	5254	50	21D
0005434821339	5254	51	21F
0005434821378	5254	52	21E
0005434821376	5254	53	21J
0005434821314	5254	54	21H
0005432396173	5254	55	21K
0005434821430	5254	56	22D
0005434821388	5254	57	22E
0005434821423	5254	58	22K
0005434821407	5254	59	23A
0005434821395	5254	60	23F
0005434821311	5254	61	23E
0005432121088	5254	62	25B
0005434821355	5254	63	25A
0005434821393	5254	64	25D
0005434821374	5254	65	25C
0005434821327	5254	66	25F
0005434821399	5254	67	25G
0005435149793	5254	68	25K
0005434821334	5254	69	26E
0005434821400	5254	70	26G
0005432396170	5254	71	27B
0005435149788	5254	72	27F
0005434821403	5254	73	27J
0005434821387	5254	74	28B
0005434821354	5254	75	28E
0005434821416	5254	76	28D
0005434821342	5254	77	28F
0005434821320	5254	78	29B
0005434821352	5254	79	29E
0005434821414	5254	80	29H
0005434821396	5254	81	29K
0005434821381	5254	82	29J
0005434821429	5254	83	30A
0005434821409	5254	84	30E
0005435149792	5254	85	30H
0005434821428	5254	86	30G
0005434821319	5254	87	31A
0005434821362	5254	88	31D
0005432121092	5254	89	31C
0005435149785	5254	90	31E
0005432394034	5254	91	31H
0005434821356	5254	92	32A
0005434821333	5254	93	32H
0005434821315	5254	94	33D
0005434821326	5254	95	33C
0005434821368	5254	96	33J
0005432121084	5254	97	33H
0005435149797	5254	98	33K
0005435149789	5254	99	34C
0005434821394	5254	100	34E
0005434821418	5254	101	34D
0005434821318	5254	102	34K
0005434821384	5254	103	35A
0005434821415	5254	104	35E
0005434821361	5254	105	35J
0005434821317	5254	106	35G
0005434821370	5254	107	36F
0005432394032	5254	108	36D
0005434821408	5254	109	37D
0005434821335	5254	110	37F
0005434821425	5254	111	37H
0005434821406	5254	112	37K
0005435149786	5254	113	38C
0005434821410	5254	114	38A
0005434821421	5254	115	38J
0005435149795	5254	116	39F
0005434821371	5254	117	40A
0005434821366	5254	118	39K
0005434821433	5254	119	40D
0005432121091	5254	120	40F
0005434821435	5254	121	40J
0005432121083	5254	122	40K
0005434821336	5254	123	41D
0005435149794	5254	124	41C
0005434821344	5254	125	41G
0005434821385	5254	126	41E
0005434821432	5254	127	41H
0005432121095	5254	128	42C
0005434821412	5254	129	42B
0005434821398	5254	130	42A
0005434821427	5254	131	42D
0005434821420	5254	132	43F
0005432396174	5254	133	43H
0005435149790	5254	134	43G
0005434821413	5254	135	43K
0005434821328	5254	136	44A
0005432121089	5254	137	44E
0005434821330	5254	138	44F
0005434821369	5254	139	44J
0005434821434	5254	140	44H
0005434821436	5254	141	45B
0005432396172	5254	142	45A
0005434821404	5254	143	45C
0005434821380	5254	144	45D
0005434821401	5254	145	45G
0005432121086	5254	146	45K
0005434821379	5254	147	45J
0005434821313	5254	148	46B
0005434821351	5254	149	46G
0005434821365	5254	150	46F
0005434821439	5254	151	46H
0005435149787	5254	152	47E
0005432121093	5254	153	47F
0005434821373	5254	154	47K
0005434821331	5254	155	47H
0005434821424	5254	156	48D
0005434821359	5254	157	48C
0005434821431	5254	158	48K
0005434821322	5254	159	49D
0005435149791	5254	160	49C
0005434821402	5254	161	50D
0005434821350	5254	162	50F
0005434821324	5254	163	51D
0005434821360	5254	164	50H
0005435372151	9891	1	2C
0005435372158	9891	2	2G
0005435735057	9891	3	2K
0005435372150	9891	4	3K
0005435372145	9891	5	5H
0005435372110	9891	6	11D
0005435372100	9891	7	11G
0005435372147	9891	8	12C
0005435372157	9891	9	12D
0005435372149	9891	10	13C
0005435372125	9891	11	13H
0005435372107	9891	12	14E
0005435372097	9891	13	14D
0005432202939	9891	14	14G
0005435386455	9891	15	14K
0005435661881	9891	16	15F
0005435372132	9891	17	15K
0005435372140	9891	18	16D
0005435372103	9891	19	16C
0005435372154	9891	20	16G
0005432202933	9891	21	17E
0005435372104	9891	22	17F
0005435372102	9891	23	18B
0005432202936	9891	24	18H
0005435372094	9891	25	19C
0005435372142	9891	26	19E
0005435372136	9891	27	19J
0005435661880	9891	28	21B
0005435735055	9891	29	21G
0005435386456	9891	30	22C
0005435372115	9891	31	22E
0005432823415	9891	32	22G
0005435372105	9891	33	22K
0005435372121	9891	34	24F
0005435372144	9891	35	25A
0005435372114	9891	36	25C
0005435372153	9891	37	25B
0005435372137	9891	38	25E
0005432202940	9891	39	27D
0005435372106	9891	40	27E
0005435372113	9891	41	27G
0005435372143	9891	42	28D
0005435372129	9891	43	29C
0005435661879	9891	44	30C
0005435372099	9891	45	31K
0005435372133	9891	46	32C
0005435372123	9891	47	32B
0005435372126	9891	48	32G
0005435372118	9891	49	33D
0005435372127	9891	50	33C
0005435372130	9891	51	33E
0005432202938	9891	52	34D
0005435372098	9891	53	34G
0005435372096	9891	54	34F
0005435735059	9891	55	35B
0005435372122	9891	56	35A
0005435735056	9891	57	35D
0005432202937	9891	58	36D
0005435372138	9891	59	36B
0005435372124	9891	60	36H
0005435372156	9891	61	37A
0005435372109	9891	62	37G
0005435735058	9891	63	37F
0005435372152	9891	64	39C
0005435372141	9891	65	39G
0005435372095	9891	66	41E
0005432202935	9891	67	42D
0005435372131	9891	68	42F
0005435372146	9891	69	42K
0005435372134	9891	70	43A
0005435372117	9891	71	43D
0005435372128	9891	72	44E
0005435372112	9891	73	45A
0005435372116	9891	74	45C
0005435372101	9891	75	46C
0005435372155	9891	76	46D
0005435372135	9891	77	47A
0005432202934	9891	78	47G
0005435386457	9891	79	47E
0005435372139	9891	80	47H
0005435386454	9891	81	48G
0005435372119	9891	82	49C
0005435372120	9891	83	49G
0005435372148	9891	84	50A
0005435372111	9891	85	50G
0005435372108	9891	86	50K
0005435082647	6978	1	1B
0005435082645	6978	2	2C
0005435082646	6978	3	5A
0005435790256	6978	4	6A
0005435790255	6978	5	18B
0005435082644	6978	6	19C
0005435082643	6978	7	21A
0005435082649	6978	8	22B
0005435082648	6978	9	22C
0005434755729	9528	1	1C
0005434755725	9528	2	1F
0005434755717	9528	3	2A
0005434755712	9528	4	2F
0005434755709	9528	5	3F
0005434755720	9528	6	4A
0005434755719	9528	7	4E
0005434755710	9528	8	5A
0005434755721	9528	9	5C
0005434755724	9528	10	5F
0005434755728	9528	11	6A
0005434755708	9528	12	6F
0005434755735	9528	13	7A
0005434755705	9528	14	7D
0005434755704	9528	15	8D
0005434755711	9528	16	9E
0005434755718	9528	17	9D
0005434755715	9528	18	9F
0005434755727	9528	19	10D
0005434755706	9528	20	11D
0005434755716	9528	21	12D
0005434755732	9528	22	12E
0005434755713	9528	23	13D
0005434755734	9528	24	14A
0005434755730	9528	25	15C
0005434755723	9528	26	16E
0005434755707	9528	27	16F
0005434755703	9528	28	17D
0005434755714	9528	29	17E
0005434755731	9528	30	18E
0005434755726	9528	31	18F
0005434755733	9528	32	19E
0005434755722	9528	33	20E
0005435100070	10806	1	7B
0005435100071	10806	2	18A
0005435100069	10806	3	21B
0005434760153	31815	1	6C
0005434760155	31815	2	19D
0005434760154	31815	3	20D
0005434638861	1994	1	1A
0005434638852	1994	2	1B
0005434638867	1994	3	1C
0005434638851	1994	4	2A
0005432290582	1994	5	2C
0005434638858	1994	6	2D
0005434638875	1994	7	3A
0005434638868	1994	8	3B
0005434638846	1994	9	3C
0005434638849	1994	10	3D
0005434638865	1994	11	4C
0005434638869	1994	12	4D
0005434638873	1994	13	5B
0005434638855	1994	14	5C
0005432290579	1994	15	6A
0005435948304	1994	16	6B
0005432290581	1994	17	6C
0005434638853	1994	18	6D
0005434638866	1994	19	7B
0005434638872	1994	20	7D
0005434638862	1994	21	18A
0005434638863	1994	22	18B
0005434638854	1994	23	19A
0005434638871	1994	24	19B
0005434638850	1994	25	19D
0005435948306	1994	26	20B
0005434638860	1994	27	20C
0005432290580	1994	28	20D
0005434638856	1994	29	21A
0005434638848	1994	30	21B
0005434638857	1994	31	21C
0005434638847	1994	32	21D
0005434638864	1994	33	22B
0005435948305	1994	34	22A
0005434638859	1994	35	22C
0005434638870	1994	36	22D
0005434638874	1994	37	23B
0005434600341	6050	1	1A
0005434600351	6050	2	1C
0005434600342	6050	3	1F
0005433531228	6050	4	2A
0005434600333	6050	5	2C
0005433531225	6050	6	2F
0005433533242	6050	7	3A
0005434600346	6050	8	3D
0005434600336	6050	9	3F
0005434600338	6050	10	4A
0005434600349	6050	11	4E
0005434600331	6050	12	5F
0005434600340	6050	13	6F
0005432111226	6050	14	7D
0005434600332	6050	15	7F
0005433533241	6050	16	8F
0005433531226	6050	17	9E
0005434600337	6050	18	10C
0005434600343	6050	19	11C
0005434600329	6050	20	11F
0005433533240	6050	21	12C
0005434600353	6050	22	12D
0005434600334	6050	23	13D
0005434600328	6050	24	13E
0005433533243	6050	25	15A
0005432111227	6050	26	15D
0005434600330	6050	27	15E
0005434600339	6050	28	15F
0005433531227	6050	29	16C
0005434600350	6050	30	17A
0005434600345	6050	31	17E
0005434600344	6050	32	18A
0005434600352	6050	33	18D
0005434600347	6050	34	18F
0005434600348	6050	35	18E
0005434600335	6050	36	19C
0005432111225	6050	37	19D
0005434600327	6050	38	20D
0005435326511	18571	1	2C
0005435326498	18571	2	4D
0005435326500	18571	3	4F
0005435326507	18571	4	6E
0005435326510	18571	5	9C
0005435326497	18571	6	11A
0005435326506	18571	7	13C
0005435326501	18571	8	14D
0005435326509	18571	9	15F
0005435326499	18571	10	16A
0005435326504	18571	11	16C
0005435326505	18571	12	18E
0005435326502	18571	13	19C
0005435326503	18571	14	19F
0005435326508	18571	15	20D
0005434554024	10653	1	15C
0005433180671	27692	1	1A
0005433180663	27692	2	2D
0005433180665	27692	3	2F
0005433180648	27692	4	3A
0005433180649	27692	5	3D
0005433180661	27692	6	3F
0005433180650	27692	7	4E
0005433180667	27692	8	5D
0005433180662	27692	9	6E
0005433180659	27692	10	7A
0005433180672	27692	11	6F
0005433180670	27692	12	7C
0005433180657	27692	13	7F
0005433180652	27692	14	8A
0005433180656	27692	15	10D
0005433180673	27692	16	10F
0005433180655	27692	17	11C
0005433180654	27692	18	11E
0005433180658	27692	19	12A
0005433180666	27692	20	12C
0005433180660	27692	21	13D
0005433180664	27692	22	13E
0005433180653	27692	23	14C
0005433180651	27692	24	14E
0005433180668	27692	25	16F
0005433180669	27692	26	20C
0005433459143	6148	1	1B
0005433459145	6148	2	2B
0005433459146	6148	3	5A
0005433459144	6148	4	6B
0005435254429	19301	1	2B
0005435254430	19301	2	6A
0005435681419	6733	1	1A
0005435681402	6733	2	1F
0005432136082	6733	3	2A
0005435681386	6733	4	2C
0005432136083	6733	5	2F
0005435681404	6733	6	3A
0005435681421	6733	7	4A
0005435681423	6733	8	4E
0005435681425	6733	9	5A
0005435681403	6733	10	5D
0005435681390	6733	11	6A
0005435681408	6733	12	6C
0005435720118	6733	13	6D
0005435681384	6733	14	6E
0005435681422	6733	15	6F
0005432136081	6733	16	7A
0005435681411	6733	17	7C
0005435681392	6733	18	7E
0005435681389	6733	19	8A
0005435681401	6733	20	8D
0005435681385	6733	21	8E
0005435681415	6733	22	8F
0005435681395	6733	23	9A
0005435681396	6733	24	9C
0005435681399	6733	25	9F
0005435681410	6733	26	10C
0005435681391	6733	27	10E
0005435681414	6733	28	11A
0005435681420	6733	29	11E
0005432136079	6733	30	12C
0005435681417	6733	31	12D
0005435720119	6733	32	13A
0005432136084	6733	33	13D
0005435681407	6733	34	13E
0005435681427	6733	35	14D
0005435681393	6733	36	14E
0005435681405	6733	37	14F
0005432136080	6733	38	15A
0005435681394	6733	39	15D
0005435681397	6733	40	16A
0005435681426	6733	41	16C
0005435681387	6733	42	17C
0005435681424	6733	43	17D
0005435681388	6733	44	18C
0005435681413	6733	45	18D
0005435681409	6733	46	18E
0005435681412	6733	47	18F
0005435681400	6733	48	19F
0005435681398	6733	49	20A
0005435681418	6733	50	20C
0005435681406	6733	51	20D
0005435681416	6733	52	20F
0005435437570	24574	1	1C
0005435437562	24574	2	2C
0005435437557	24574	3	2D
0005435437568	24574	4	3C
0005435437573	24574	5	3D
0005432533240	24574	6	4C
0005435437566	24574	7	4D
0005435437574	24574	8	5D
0005432305706	24574	9	6A
0005434828649	24574	10	6C
0005435437563	24574	11	6E
0005435437567	24574	12	6F
0005435437569	24574	13	7E
0005435437572	24574	14	7F
0005435437559	24574	15	8A
0005435437551	24574	16	8C
0005435437553	24574	17	9C
0005434828650	24574	18	9E
0005435437560	24574	19	9F
0005434828648	24574	20	10A
0005435437554	24574	21	11A
0005432305705	24574	22	11D
0005435437564	24574	23	12E
0005435437571	24574	24	15D
0005432533241	24574	25	16D
0005435437555	24574	26	17C
0005435437565	24574	27	18D
0005435437558	24574	28	18F
0005432533242	24574	29	19F
0005435437556	24574	30	20C
0005435437561	24574	31	20E
0005435437552	24574	32	20F
0005435105923	11521	1	14E
0005435105925	11521	2	18E
0005435105924	11521	3	20A
0005435558039	31901	1	4C
0005435558040	31901	2	7D
0005435558041	31901	3	18F
0005433397181	13537	1	1F
0005433397182	13537	2	2A
0005433397222	13537	3	3C
0005433397212	13537	4	3D
0005433397220	13537	5	3F
0005433397200	13537	6	4A
0005433397203	13537	7	4C
0005433397184	13537	8	4E
0005433397179	13537	9	6D
0005433397188	13537	10	6E
0005433397202	13537	11	6F
0005433397196	13537	12	7D
0005433397213	13537	13	7E
0005433397201	13537	14	8C
0005433397224	13537	15	8D
0005433397207	13537	16	8E
0005433397197	13537	17	9A
0005433397208	13537	18	9E
0005433397183	13537	19	9F
0005433397205	13537	20	10C
0005433397187	13537	21	10D
0005433397211	13537	22	10F
0005433397228	13537	23	11C
0005433397217	13537	24	11D
0005433397194	13537	25	11F
0005433397214	13537	26	12E
0005433397189	13537	27	12F
0005433397215	13537	28	13D
0005433397226	13537	29	13F
0005433397225	13537	30	14A
0005433397216	13537	31	14D
0005433397227	13537	32	14F
0005433397223	13537	33	15C
0005433397185	13537	34	15D
0005433397198	13537	35	15E
0005433397192	13537	36	15F
0005433397219	13537	37	16A
0005433397210	13537	38	16C
0005433397178	13537	39	16D
0005433397206	13537	40	16F
0005433397180	13537	41	17A
0005433397193	13537	42	17D
0005433397218	13537	43	17E
0005433397191	13537	44	18A
0005433397221	13537	45	18C
0005433397199	13537	46	18E
0005433397186	13537	47	19D
0005433397209	13537	48	20A
0005433397190	13537	49	20C
0005433397195	13537	50	20D
0005433397204	13537	51	20F
0005435732116	19417	1	1C
0005435732122	19417	2	2A
0005435732117	19417	3	3A
0005435732114	19417	4	3C
0005435732121	19417	5	4E
0005432297231	19417	6	5A
0005435732119	19417	7	5F
0005435732112	19417	8	8A
0005435732115	19417	9	10F
0005435732123	19417	10	11D
0005432297232	19417	11	13C
0005435732120	19417	12	13E
0005432297230	19417	13	16C
0005435732113	19417	14	16D
0005435732124	19417	15	17D
0005435732118	19417	16	20E
0005435925055	13148	1	2D
0005435925051	13148	2	2F
0005435925047	13148	3	3C
0005435925054	13148	4	5D
0005435925060	13148	5	6F
0005435925049	13148	6	7A
0005435925057	13148	7	7E
0005435925048	13148	8	8A
0005435925052	13148	9	10F
0005435925050	13148	10	12C
0005435925046	13148	11	14F
0005435925058	13148	12	15D
0005435925059	13148	13	15E
0005435925053	13148	14	18F
0005435925056	13148	15	20D
0005433407477	29499	1	1C
0005433407479	29499	2	4D
0005433407478	29499	3	6A
0005433407480	29499	4	20A
0005433407481	29499	5	21B
0005434213729	10699	1	1A
0005434213726	10699	2	1D
0005434213707	10699	3	2A
0005434213720	10699	4	2C
0005434213731	10699	5	3D
0005434213728	10699	6	4A
0005434213740	10699	7	4D
0005434213705	10699	8	4F
0005434213704	10699	9	5C
0005434213702	10699	10	6A
0005434213737	10699	11	6F
0005434213708	10699	12	7A
0005434213732	10699	13	7C
0005434213712	10699	14	7F
0005434213724	10699	15	8A
0005434213743	10699	16	8D
0005434213742	10699	17	8E
0005434213701	10699	18	9A
0005434213709	10699	19	10A
0005434213698	10699	20	10C
0005434213714	10699	21	10D
0005434213717	10699	22	10F
0005434213733	10699	23	11C
0005434213703	10699	24	11D
0005434213734	10699	25	11E
0005434213721	10699	26	11F
0005434213715	10699	27	12C
0005434213713	10699	28	13D
0005434213718	10699	29	13F
0005434213723	10699	30	14D
0005434213711	10699	31	15A
0005434213735	10699	32	15D
0005434213716	10699	33	15E
0005434213744	10699	34	16C
0005434213727	10699	35	16E
0005434213700	10699	36	16F
0005434213719	10699	37	17D
0005434213738	10699	38	17E
0005434213706	10699	39	18A
0005434213736	10699	40	18C
0005434213730	10699	41	18D
0005434213710	10699	42	18E
0005434213741	10699	43	19D
0005434213739	10699	44	19E
0005434213745	10699	45	19F
0005434213725	10699	46	20D
0005434213699	10699	47	20E
0005434213722	10699	48	20F
0005435006602	5474	1	1A
0005432125319	5474	2	1C
0005435038610	5474	3	1D
0005435006618	5474	4	1F
0005435006616	5474	5	2A
0005432125321	5474	6	2D
0005435038645	5474	7	2F
0005435006611	5474	8	3D
0005435038638	5474	9	3F
0005432125324	5474	10	4A
0005435038661	5474	11	4D
0005435038618	5474	12	4C
0005435006606	5474	13	4E
0005435038631	5474	14	4F
0005435006610	5474	15	5B
0005435038643	5474	16	5A
0005435038627	5474	17	5C
0005432125322	5474	18	5D
0005435038656	5474	19	5F
0005435006607	5474	20	6B
0005435038668	5474	21	6F
0005435038619	5474	22	6E
0005435038648	5474	23	7A
0005435038611	5474	24	7C
0005435038642	5474	25	7B
0005435038652	5474	26	7E
0005435038665	5474	27	8A
0005435038626	5474	28	7F
0005435038666	5474	29	8B
0005435006603	5474	30	8C
0005435038672	5474	31	8D
0005435038675	5474	32	8F
0005435038662	5474	33	8E
0005435038659	5474	34	9A
0005435038657	5474	35	9B
0005435006613	5474	36	9C
0005435038663	5474	37	9F
0005435038616	5474	38	9E
0005435038640	5474	39	10B
0005432125325	5474	40	10C
0005435038622	5474	41	10E
0005435038651	5474	42	11A
0005435038654	5474	43	11B
0005435038625	5474	44	11C
0005435038647	5474	45	11D
0005435038637	5474	46	11F
0005432125318	5474	47	12A
0005435038650	5474	48	12D
0005435038639	5474	49	12E
0005435038653	5474	50	13B
0005435038641	5474	51	13A
0005435038628	5474	52	13F
0005435038646	5474	53	14B
0005435006615	5474	54	14D
0005435038671	5474	55	14E
0005435038621	5474	56	14F
0005435006609	5474	57	15C
0005435038649	5474	58	15B
0005435038620	5474	59	15D
0005435038670	5474	60	15F
0005435038615	5474	61	16A
0005435006614	5474	62	16B
0005435042820	5474	63	16C
0005435038614	5474	64	16D
0005435006617	5474	65	16F
0005435006605	5474	66	17B
0005435038612	5474	67	17A
0005435042822	5474	68	17C
0005435038624	5474	69	17E
0005435038658	5474	70	17D
0005435038633	5474	71	17F
0005435038613	5474	72	18B
0005435006604	5474	73	18C
0005435038617	5474	74	18E
0005435038664	5474	75	18D
0005435006601	5474	76	19A
0005432125323	5474	77	19C
0005432125320	5474	78	19E
0005435038644	5474	79	19D
0005435038655	5474	80	19F
0005435042823	5474	81	20A
0005435038634	5474	82	20E
0005435006608	5474	83	20F
0005435042821	5474	84	21B
0005435006619	5474	85	21A
0005435006612	5474	86	21C
0005435038673	5474	87	21E
0005435038629	5474	88	22B
0005435038623	5474	89	22A
0005435038632	5474	90	22C
0005435006620	5474	91	22D
0005435038674	5474	92	22F
0005435038669	5474	93	23B
0005435038660	5474	94	23A
0005435038630	5474	95	23C
0005435038667	5474	96	23E
0005435038635	5474	97	23D
0005435038636	5474	98	23F
0005432304331	12973	1	1F
0005434228978	12973	2	2D
0005434228981	12973	3	5F
0005434228980	12973	4	7B
0005434228970	12973	5	8A
0005434228986	12973	6	8C
0005432304330	12973	7	8E
0005434228988	12973	8	11C
0005434228975	12973	9	11B
0005434228967	12973	10	12C
0005434228968	12973	11	13D
0005434228977	12973	12	14C
0005434228985	12973	13	15C
0005434228971	12973	14	16A
0005432304329	12973	15	17C
0005434228982	12973	16	18D
0005434228979	12973	17	18C
0005434228973	12973	18	19A
0005434228983	12973	19	19C
0005434228987	12973	20	19E
0005434228984	12973	21	20A
0005434228972	12973	22	20D
0005434228974	12973	23	21B
0005434228966	12973	24	22D
0005434228969	12973	25	23B
0005434228976	12973	26	23E
0005432059471	20234	1	1F
0005435554107	20234	2	2A
0005432059469	20234	3	2C
0005435902395	20234	4	2F
0005435902389	20234	5	4C
0005435902393	20234	6	5E
0005435902398	20234	7	6A
0005435902387	20234	8	6F
0005435554103	20234	9	7F
0005435902385	20234	10	9C
0005435902390	20234	11	11D
0005432059470	20234	12	11E
0005435902388	20234	13	11F
0005435554106	20234	14	13C
0005435902397	20234	15	13D
0005435902391	20234	16	13E
0005435902400	20234	17	14A
0005435554104	20234	18	15F
0005435902392	20234	19	16C
0005435902399	20234	20	16F
0005435902401	20234	21	17C
0005435902396	20234	22	18D
0005435902384	20234	23	18F
0005435902386	20234	24	19A
0005435554105	20234	25	19C
0005435902394	20234	26	20F
0005434269067	26680	1	1C
0005433434207	26680	2	2A
0005433434206	26680	3	2C
0005433434187	26680	4	3C
0005433434186	26680	5	4D
0005433434196	26680	6	5C
0005433434181	26680	7	5E
0005433434194	26680	8	6A
0005434269068	26680	9	6C
0005433434195	26680	10	7D
0005433434182	26680	11	7F
0005433434201	26680	12	8A
0005433434198	26680	13	8C
0005433434197	26680	14	8E
0005433434205	26680	15	9C
0005433434202	26680	16	10C
0005433434191	26680	17	10D
0005433434203	26680	18	10E
0005433434208	26680	19	10F
0005433434180	26680	20	11A
0005433434188	26680	21	11C
0005433434192	26680	22	11D
0005434270171	26680	23	12C
0005432051074	26680	24	12D
0005433434183	26680	25	12F
0005434269069	26680	26	13C
0005433434204	26680	27	13E
0005433434184	26680	28	14E
0005433434199	26680	29	15A
0005432051076	26680	30	15D
0005434271275	26680	31	16A
0005433434200	26680	32	16E
0005433434185	26680	33	17C
0005432051075	26680	34	18C
0005433434193	26680	35	19C
0005434270170	26680	36	19D
0005433434190	26680	37	19F
0005433434189	26680	38	20E
0005434271276	26680	39	20F
0005432583598	3180	1	1B
0005432583604	3180	2	1C
0005432583594	3180	3	1D
0005432583591	3180	4	2A
0005432583589	3180	5	2B
0005432583586	3180	6	3C
0005432583606	3180	7	3D
0005432583588	3180	8	4A
0005432583592	3180	9	4B
0005432583600	3180	10	4C
0005432583590	3180	11	4D
0005432583582	3180	12	5B
0005432583585	3180	13	5D
0005432583596	3180	14	6B
0005432583599	3180	15	6C
0005432583583	3180	16	7A
0005432583605	3180	17	7D
0005432583597	3180	18	18A
0005432583584	3180	19	18B
0005432583593	3180	20	19B
0005432583603	3180	21	19C
0005432216222	3180	22	20A
0005432583601	3180	23	20B
0005432216223	3180	24	21B
0005432583602	3180	25	21C
0005432583595	3180	26	22B
0005432583587	3180	27	22D
0005432216224	3180	28	23B
0005432857855	31520	1	2B
0005432857858	31520	2	2C
0005432857852	31520	3	3D
0005432857856	31520	4	4C
0005432857854	31520	5	5B
0005432857860	31520	6	5D
0005432857857	31520	7	6A
0005432857861	31520	8	18D
0005432857859	31520	9	20B
0005432857853	31520	10	21A
0005432857863	31520	11	21D
0005432857862	31520	12	22A
0005434943193	912	1	1D
0005434943187	912	2	3B
0005434943184	912	3	4A
0005434943186	912	4	4C
0005434943191	912	5	5B
0005434943194	912	6	6C
0005434943190	912	7	6D
0005434943185	912	8	7C
0005434943189	912	9	20A
0005434943192	912	10	21C
0005434943188	912	11	23B
0005433255025	16199	1	1A
0005433255023	16199	2	2B
0005433255021	16199	3	5A
0005433255024	16199	4	6B
0005433255022	16199	5	18A
0005433654647	4322	1	3D
0005433654653	4322	2	8E
0005433654648	4322	3	9E
0005433654652	4322	4	9F
0005433654651	4322	5	15C
0005433654650	4322	6	16F
0005433654654	4322	7	17F
0005433654649	4322	8	21D
0005433804791	9336	1	1C
0005433784317	9336	2	1G
0005433762954	9336	3	2H
0005433784328	9336	4	2G
0005432666352	9336	5	3B
0005433804783	9336	6	3G
0005433784321	9336	7	4C
0005433804779	9336	8	4B
0005433804784	9336	9	4F
0005433762944	9336	10	5B
0005433804788	9336	11	5C
0005433784297	9336	12	5G
0005433784312	9336	13	5H
0005433784306	9336	14	12A
0005432665238	9336	15	12E
0005433784316	9336	16	12F
0005433784327	9336	17	13A
0005433784305	9336	18	13B
0005432657393	9336	19	13D
0005433784294	9336	20	13G
0005433762942	9336	21	13F
0005433762949	9336	22	14A
0005433762953	9336	23	15D
0005433784299	9336	24	15F
0005433784326	9336	25	15H
0005433784302	9336	26	16A
0005433784292	9336	27	16H
0005433784313	9336	28	16G
0005433762955	9336	29	17A
0005433784322	9336	30	17D
0005433804780	9336	31	17B
0005433784324	9336	32	17H
0005432666353	9336	33	18F
0005433804785	9336	34	18H
0005433784320	9336	35	19B
0005433784318	9336	36	20H
0005433784295	9336	37	21B
0005432665237	9336	38	21E
0005433804790	9336	39	22D
0005433762943	9336	40	22G
0005433784301	9336	41	23B
0005433804792	9336	42	23A
0005433784319	9336	43	23H
0005433762948	9336	44	24E
0005432657395	9336	45	24H
0005433762950	9336	46	27A
0005433804787	9336	47	27D
0005433762951	9336	48	27H
0005433762956	9336	49	27G
0005433762946	9336	50	28B
0005433784296	9336	51	28F
0005433762947	9336	52	30H
0005433804781	9336	53	31F
0005433784311	9336	54	31H
0005433804778	9336	55	32D
0005433804782	9336	56	32B
0005433784315	9336	57	32G
0005433804777	9336	58	33H
0005433784293	9336	59	34A
0005433784304	9336	60	34D
0005432657394	9336	61	34B
0005433804789	9336	62	34G
0005433784325	9336	63	35G
0005433784309	9336	64	36B
0005433784300	9336	65	36A
0005433804793	9336	66	36E
0005433784298	9336	67	36D
0005433784307	9336	68	36F
0005432666351	9336	69	36H
0005433784310	9336	70	37E
0005433784314	9336	71	38A
0005433804786	9336	72	38B
0005433784303	9336	73	38H
0005433762952	9336	74	38G
0005433784323	9336	75	39E
0005433762945	9336	76	39D
0005433784308	9336	77	39F
0005434170798	26277	1	2G
0005435269632	26277	2	4C
0005435269631	26277	3	9G
0005434170806	26277	4	11B
0005434170804	26277	5	12E
0005435269628	26277	6	12H
0005435269633	26277	7	14B
0005435269625	26277	8	15E
0005434170807	26277	9	15F
0005435269634	26277	10	15H
0005435269622	26277	11	16A
0005434170801	26277	12	16G
0005435269641	26277	13	17B
0005434170797	26277	14	18E
0005434170810	26277	15	19G
0005435269621	26277	16	19H
0005435269624	26277	17	22D
0005435269635	26277	18	23D
0005435269639	26277	19	24A
0005434170809	26277	20	25F
0005434170805	26277	21	27D
0005435269642	26277	22	30E
0005434170800	26277	23	31F
0005435269623	26277	24	31G
0005435269640	26277	25	32B
0005435269627	26277	26	32D
0005435269636	26277	27	32H
0005434170803	26277	28	33B
0005434170802	26277	29	34A
0005435269626	26277	30	34E
0005434170808	26277	31	36A
0005434170799	26277	32	35H
0005435269638	26277	33	37F
0005435269630	26277	34	39E
0005435269629	26277	35	39D
0005435269637	26277	36	39F
0005435135585	4920	1	2D
0005435135582	4920	2	7C
0005435135583	4920	3	21B
0005435135584	4920	4	23A
0005435929595	33055	1	2A
0005435929597	33055	2	7B
0005435929596	33055	3	18D
0005434983194	9467	1	2D
0005434983198	9467	2	4A
0005434983195	9467	3	6B
0005434983197	9467	4	7A
0005434983196	9467	5	21B
0005434983193	9467	6	22C
0005434217896	27368	1	5A
0005434217894	27368	2	6B
0005434217897	27368	3	18B
0005434217895	27368	4	22B
0005434217898	27368	5	22D
0005434479880	923	1	1B
0005434479885	923	2	1C
0005434479896	923	3	2A
0005432269447	923	4	2B
0005434479888	923	5	2C
0005434479903	923	6	2D
0005432269445	923	7	4A
0005434479893	923	8	4B
0005434479894	923	9	4C
0005434479895	923	10	5B
0005434479879	923	11	5C
0005434479900	923	12	5D
0005434479897	923	13	6A
0005434479886	923	14	6C
0005434479890	923	15	7C
0005434479901	923	16	18A
0005434479878	923	17	18B
0005432269446	923	18	18C
0005434479881	923	19	19A
0005434479898	923	20	19C
0005434479902	923	21	20A
0005434479892	923	22	20B
0005434479883	923	23	20C
0005434479887	923	24	20D
0005434479882	923	25	21A
0005434479884	923	26	21C
0005434479889	923	27	21D
0005434479899	923	28	22A
0005434479891	923	29	23A
0005433165675	16590	1	1C
0005433165683	16590	2	2B
0005433165682	16590	3	2C
0005433165676	16590	4	4C
0005433165680	16590	5	4D
0005433165670	16590	6	6A
0005433165674	16590	7	6B
0005433165677	16590	8	6C
0005433165678	16590	9	6D
0005433165673	16590	10	18B
0005433165681	16590	11	19A
0005433165672	16590	12	20A
0005433165671	16590	13	20D
0005433165679	16590	14	22D
0005433872427	3194	1	2A
0005433872426	3194	2	19D
0005433872428	3194	3	23A
0005435386455	21926	1	1B
0005435386456	21926	2	1D
0005433289725	21926	3	5B
0005435386454	21926	4	6B
0005433289727	21926	5	21A
0005433289726	21926	6	21B
0005433289728	21926	7	22A
0005435386457	21926	8	22B
0005433289730	21926	9	22C
0005433289729	21926	10	22D
0005435319423	20931	1	2C
0005435319424	20931	2	3D
0005435319429	20931	3	5E
0005435319431	20931	4	6C
0005435319426	20931	5	10F
0005435319427	20931	6	11C
0005435319425	20931	7	12C
0005435319428	20931	8	14E
0005435319430	20931	9	17C
0005433683291	24306	1	3D
0005433683290	24306	2	4C
0005433683293	24306	3	19B
0005433683292	24306	4	19C
0005433927397	29277	1	3A
0005433927396	29277	2	3D
0005433927395	29277	3	5A
0005432706316	2926	1	1A
0005432706311	2926	2	1D
0005432706307	2926	3	2A
0005432217726	2926	4	2D
0005432706324	2926	5	4C
0005432706313	2926	6	4D
0005432706329	2926	7	6A
0005432706318	2926	8	6C
0005432706312	2926	9	6D
0005432706326	2926	10	7A
0005432706331	2926	11	7C
0005432706330	2926	12	8C
0005432706309	2926	13	8D
0005432706321	2926	14	9C
0005432706310	2926	15	9D
0005432706308	2926	16	9E
0005432706323	2926	17	10E
0005432706322	2926	18	10F
0005432706328	2926	19	11C
0005432217725	2926	20	12A
0005432706332	2926	21	12E
0005432706319	2926	22	13A
0005432706325	2926	23	13F
0005432706315	2926	24	14C
0005432706320	2926	25	17A
0005432706317	2926	26	17C
0005432706327	2926	27	18A
0005432706314	2926	28	18E
0005432217724	2926	29	18F
0005432692531	30019	1	1C
0005432692533	30019	2	1F
0005432692527	30019	3	3C
0005432692534	30019	4	3F
0005432880563	30019	5	4A
0005432880561	30019	6	4D
0005432692552	30019	7	5A
0005432692547	30019	8	5E
0005432880555	30019	9	5F
0005432692541	30019	10	6A
0005432692556	30019	11	6D
0005432692553	30019	12	6E
0005432692545	30019	13	6F
0005432692529	30019	14	7C
0005432692528	30019	15	7E
0005432692549	30019	16	7D
0005432880557	30019	17	8C
0005432880562	30019	18	8F
0005432692554	30019	19	9C
0005432692550	30019	20	9E
0005432692557	30019	21	10D
0005432692543	30019	22	11A
0005432692539	30019	23	11C
0005432880551	30019	24	11F
0005432692536	30019	25	12C
0005432692540	30019	26	13A
0005432880553	30019	27	13C
0005432880554	30019	28	14C
0005432692555	30019	29	14D
0005432692546	30019	30	14E
0005432880558	30019	31	15A
0005432692548	30019	32	15D
0005432692551	30019	33	15E
0005432880552	30019	34	16A
0005432880565	30019	35	16D
0005432880564	30019	36	17A
0005432692530	30019	37	17D
0005432880560	30019	38	17F
0005432692538	30019	39	18A
0005432692532	30019	40	18D
0005432692558	30019	41	18E
0005432692544	30019	42	18F
0005432692535	30019	43	19C
0005432880556	30019	44	19D
0005432692542	30019	45	19F
0005432692537	30019	46	20D
0005432880559	30019	47	20F
0005433113495	19632	1	2A
0005433113496	19632	2	19A
0005435068172	3533	1	1A
0005435068190	3533	2	1C
0005435068181	3533	3	1D
0005435068175	3533	4	2D
0005435718830	3533	5	2F
0005435068200	3533	6	3A
0005435068194	3533	7	3C
0005435068180	3533	8	4C
0005435068210	3533	9	4E
0005435068207	3533	10	4D
0005435068163	3533	11	5C
0005435718828	3533	12	5D
0005435718827	3533	13	5F
0005435068160	3533	14	6A
0005435068161	3533	15	6C
0005435068176	3533	16	6D
0005435068170	3533	17	7A
0005435068168	3533	18	7D
0005435068199	3533	19	7E
0005435068162	3533	20	7F
0005435068169	3533	21	8D
0005435718831	3533	22	8E
0005435068184	3533	23	8F
0005435068195	3533	24	9D
0005435068208	3533	25	9E
0005435068178	3533	26	9F
0005435068192	3533	27	10A
0005435068174	3533	28	10C
0005435068183	3533	29	10D
0005435068198	3533	30	11A
0005435068166	3533	31	11C
0005435068191	3533	32	11E
0005435068187	3533	33	12D
0005435718829	3533	34	12E
0005435068173	3533	35	12F
0005435068158	3533	36	13C
0005435068171	3533	37	13E
0005435068202	3533	38	13F
0005435068209	3533	39	14D
0005435068164	3533	40	14E
0005435068159	3533	41	15E
0005435068197	3533	42	15F
0005435068204	3533	43	16A
0005435068179	3533	44	16D
0005435068205	3533	45	16F
0005435068185	3533	46	17A
0005435068193	3533	47	17E
0005435068201	3533	48	17F
0005435068188	3533	49	18A
0005435068206	3533	50	18C
0005435068186	3533	51	18D
0005435068189	3533	52	18F
0005435068196	3533	53	19A
0005435068203	3533	54	19C
0005435068177	3533	55	19D
0005435068182	3533	56	19F
0005435068167	3533	57	20A
0005435068165	3533	58	20E
0005435925060	15302	1	4A
0005435925056	15302	2	4E
0005435925051	15302	3	5C
0005435925049	15302	4	6D
0005435925048	15302	5	8E
0005435925057	15302	6	9A
0005435925052	15302	7	9C
0005435925046	15302	8	9D
0005435939856	15302	9	11D
0005435925053	15302	10	15E
0005435925058	15302	11	16C
0005435925047	15302	12	17A
0005435925059	15302	13	17E
0005435925055	15302	14	19C
0005435925050	15302	15	20A
0005435925054	15302	16	20D
0005432157458	62	1	5F
0005432157457	62	2	25C
0005432816945	1	1	2C
0005432261133	1	2	2F
0005432261100	1	3	2D
0005432261098	1	4	4A
0005432261099	1	5	4F
0005432816962	1	6	5C
0005432261101	1	7	5F
0005432816959	1	8	6D
0005432261122	1	9	6C
0005432261110	1	10	6F
0005432261129	1	11	7C
0005432261096	1	12	7F
0005432816955	1	13	8A
0005432261119	1	14	8D
0005432816943	1	15	8C
0005432816947	1	16	9A
0005432816938	1	17	8F
0005432261090	1	18	9C
0005432816951	1	19	9D
0005432816960	1	20	9F
0005432261115	1	21	10B
0005432816954	1	22	10D
0005432816961	1	23	10E
0005432261097	1	24	10F
0005432261092	1	25	11B
0005432816963	1	26	11C
0005432261103	1	27	11D
0005432261116	1	28	11E
0005432816939	1	29	12A
0005432261109	1	30	11F
0005432261126	1	31	12E
0005432261121	1	32	12D
0005432816940	1	33	12F
0005432261120	1	34	13D
0005432261087	1	35	14B
0005432816965	1	36	14D
0005432288927	1	37	14E
0005432261112	1	38	14F
0005432261127	1	39	15B
0005432816958	1	40	15D
0005432816946	1	41	16E
0005432261114	1	42	16D
0005432816964	1	43	16F
0005432261132	1	44	17A
0005432261113	1	45	17F
0005432816952	1	46	18A
0005432261125	1	47	18B
0005432261118	1	48	18D
0005432261102	1	49	18C
0005432261128	1	50	19E
0005432816966	1	51	19D
0005432288929	1	52	20A
0005432261091	1	53	20C
0005432261123	1	54	20E
0005432261107	1	55	20F
0005432261094	1	56	21F
0005432816957	1	57	22A
0005432261111	1	58	22B
0005432261124	1	59	22D
0005432261108	1	60	23B
0005432816948	1	61	24A
0005432261093	1	62	25B
0005432816949	1	63	25D
0005432816953	1	64	25C
0005432816950	1	65	26A
0005432261130	1	66	26E
0005432261095	1	67	27A
0005432261089	1	68	27B
0005432261117	1	69	27E
0005432816942	1	70	27D
0005432816956	1	71	28E
0005432261131	1	72	28F
0005432261105	1	73	29D
0005432261106	1	74	29F
0005432288928	1	75	30B
0005432261104	1	76	30D
0005432816944	1	77	30E
0005432261088	1	78	31A
0005432816941	1	79	31E
0005433101217	8078	1	1D
0005433101189	8078	2	2A
0005432391945	8078	3	1F
0005433101183	8078	4	2C
0005433101197	8078	5	2F
0005432019787	8078	6	3C
0005432019786	8078	7	3D
0005433101173	8078	8	4A
0005433101216	8078	9	3F
0005433101157	8078	10	4C
0005433101155	8078	11	4D
0005432391946	8078	12	5A
0005433101200	8078	13	5C
0005433101194	8078	14	5F
0005433101168	8078	15	6D
0005433101148	8078	16	7A
0005433101161	8078	17	6F
0005432753243	8078	18	7F
0005433101176	8078	19	7D
0005433101172	8078	20	8A
0005433101196	8078	21	8C
0005432751469	8078	22	9A
0005433101160	8078	23	9B
0005433101150	8078	24	9C
0005432019796	8078	25	9D
0005433101190	8078	26	9E
0005432045579	8078	27	10A
0005433101210	8078	28	10C
0005433101171	8078	29	10B
0005432019794	8078	30	10D
0005433101204	8078	31	10E
0005432019779	8078	32	10F
0005433101154	8078	33	11A
0005433101184	8078	34	11B
0005432753242	8078	35	11D
0005433101220	8078	36	11E
0005432019780	8078	37	12A
0005433101162	8078	38	12B
0005433101178	8078	39	12C
0005433101170	8078	40	12D
0005432019797	8078	41	12E
0005433101207	8078	42	13B
0005433101212	8078	43	13C
0005432019784	8078	44	13D
0005433101164	8078	45	13F
0005433101202	8078	46	13E
0005432019793	8078	47	14A
0005432677503	8078	48	14B
0005433101169	8078	49	14C
0005433101187	8078	50	14E
0005433101182	8078	51	14F
0005432019792	8078	52	15A
0005432044475	8078	53	15C
0005432044477	8078	54	15B
0005433101219	8078	55	15F
0005432019801	8078	56	15E
0005433101209	8078	57	16B
0005432045580	8078	58	16D
0005433101213	8078	59	16F
0005432019800	8078	60	17F
0005433101205	8078	61	17E
0005433101208	8078	62	18A
0005433101179	8078	63	18C
0005433101159	8078	64	18B
0005433101203	8078	65	18D
0005433101195	8078	66	19B
0005432019789	8078	67	18F
0005433101193	8078	68	20A
0005432019790	8078	69	19E
0005433101152	8078	70	20C
0005433101206	8078	71	20D
0005433101192	8078	72	20F
0005432019783	8078	73	21A
0005433101199	8078	74	21C
0005433101177	8078	75	21B
0005433101167	8078	76	22B
0005433101163	8078	77	22A
0005432019804	8078	78	22E
0005433101211	8078	79	22D
0005432019781	8078	80	22F
0005433101201	8078	81	23A
0005433101165	8078	82	23D
0005432751468	8078	83	23C
0005432045581	8078	84	23E
0005433101149	8078	85	24A
0005433101185	8078	86	24D
0005433101214	8078	87	24C
0005433101198	8078	88	24F
0005432019799	8078	89	25A
0005433101151	8078	90	25C
0005433101175	8078	91	25B
0005433101188	8078	92	25D
0005432019802	8078	93	25E
0005433101166	8078	94	26A
0005432019785	8078	95	25F
0005432677506	8078	96	26B
0005432391947	8078	97	26C
0005432019795	8078	98	26E
0005432019803	8078	99	26F
0005433101186	8078	100	27B
0005432677504	8078	101	27E
0005433101218	8078	102	27D
0005432019782	8078	103	28B
0005433101180	8078	104	28D
0005432019788	8078	105	28F
0005433101158	8078	106	29A
0005432019791	8078	107	29C
0005432677505	8078	108	29E
0005432044476	8078	109	30A
0005432753244	8078	110	30B
0005433101156	8078	111	30D
0005433101153	8078	112	31A
0005433101181	8078	113	30F
0005432019798	8078	114	31B
0005433101215	8078	115	31C
0005433101191	8078	116	31F
0005433101174	8078	117	31E
0005432901293	8076	1	1C
0005432901302	8076	2	1F
0005432901304	8076	3	5C
0005432901295	8076	4	6D
0005432901310	8076	5	8D
0005432901298	8076	6	8C
0005432901307	8076	7	8F
0005432901309	8076	8	9C
0005432901308	8076	9	10B
0005432901297	8076	10	10D
0005432901300	8076	11	15B
0005432002040	8076	12	15F
0005432002041	8076	13	17D
0005432901299	8076	14	18C
0005432901303	8076	15	19E
0005432901296	8076	16	20C
0005432901306	8076	17	23A
0005432901294	8076	18	25B
0005432901311	8076	19	28D
0005432901301	8076	20	30B
0005432901305	8076	21	30D
0005433870692	9671	1	3B
0005433870691	9671	2	5B
0005434175681	32374	1	1A
0005434175678	32374	2	2B
0005434175680	32374	3	4A
0005434175679	32374	4	5A
0005434175682	32374	5	6B
0005434876559	3490	1	1A
0005435625879	3490	2	1G
0005432798964	3490	3	1D
0005434876557	3490	4	1K
0005435625862	3490	5	1H
0005432798955	3490	6	2D
0005434876620	3490	7	2C
0005435125675	3490	8	2A
0005434876651	3490	9	2H
0005434876564	3490	10	2G
0005434876581	3490	11	3A
0005432613790	3490	12	2K
0005435125669	3490	13	3D
0005435125656	3490	14	3C
0005434876585	3490	15	3H
0005432798962	3490	16	4A
0005432798966	3490	17	4G
0005434426109	3490	18	4K
0005435625868	3490	19	4H
0005434426101	3490	20	5C
0005435625876	3490	21	5A
0005434876593	3490	22	5H
0005434876614	3490	23	11A
0005434876575	3490	24	5K
0005434876617	3490	25	11E
0005434876565	3490	26	11D
0005435625858	3490	27	11C
0005435125677	3490	28	11F
0005432798969	3490	29	11G
0005434876583	3490	30	12A
0005435125661	3490	31	12E
0005432798961	3490	32	12G
0005435625877	3490	33	12F
0005434876621	3490	34	12K
0005434876636	3490	35	13F
0005434937796	3490	36	13E
0005434876558	3490	37	13H
0005435625873	3490	38	13G
0005435125665	3490	39	14A
0005434876650	3490	40	14G
0005435125651	3490	41	14F
0005434876580	3490	42	14K
0005434876578	3490	43	15C
0005435125663	3490	44	15E
0005432613789	3490	45	15G
0005434426085	3490	46	15H
0005434426092	3490	47	16C
0005434876633	3490	48	16A
0005435125688	3490	49	16E
0005434426091	3490	50	16H
0005434937810	3490	51	16G
0005434876569	3490	52	17A
0005434876600	3490	53	17E
0005432798977	3490	54	17D
0005435125678	3490	55	17C
0005434876582	3490	56	17F
0005434876608	3490	57	17K
0005434876609	3490	58	18C
0005432798956	3490	59	18E
0005434876574	3490	60	18D
0005434426093	3490	61	18F
0005434876591	3490	62	18K
0005435625867	3490	63	18J
0005434937805	3490	64	18H
0005435125682	3490	65	19B
0005435625857	3490	66	19A
0005434876640	3490	67	19D
0005435125687	3490	68	19C
0005435625869	3490	69	19E
0005435625863	3490	70	19J
0005434937808	3490	71	19H
0005435125666	3490	72	20A
0005434876584	3490	73	19K
0005435125652	3490	74	20B
0005435125653	3490	75	20E
0005434876599	3490	76	20C
0005435125657	3490	77	20K
0005434937802	3490	78	20J
0005435125655	3490	79	20H
0005435125674	3490	80	21A
0005432798972	3490	81	21D
0005434876598	3490	82	21F
0005434426096	3490	83	22A
0005434876646	3490	84	21K
0005435625875	3490	85	22C
0005434426102	3490	86	22B
0005434426099	3490	87	22E
0005435625861	3490	88	22D
0005434876639	3490	89	22G
0005434426098	3490	90	22F
0005434426105	3490	91	22K
0005434937792	3490	92	22H
0005434876619	3490	93	23B
0005434426088	3490	94	23A
0005434937809	3490	95	23D
0005434426089	3490	96	23C
0005432798968	3490	97	23G
0005434937797	3490	98	23F
0005434876642	3490	99	23E
0005432188550	3490	100	23J
0005435125671	3490	101	23H
0005434426104	3490	102	23K
0005434937793	3490	103	25A
0005434876615	3490	104	24G
0005432188551	3490	105	25C
0005434876616	3490	106	25B
0005434426095	3490	107	25F
0005434937806	3490	108	25E
0005434876618	3490	109	25G
0005432188553	3490	110	26A
0005435625865	3490	111	25J
0005434426113	3490	112	26D
0005434876610	3490	113	26C
0005432798979	3490	114	26H
0005434876597	3490	115	26F
0005434876626	3490	116	27B
0005434876606	3490	117	27A
0005434937804	3490	118	26K
0005434876622	3490	119	27D
0005432798976	3490	120	27C
0005434426110	3490	121	27F
0005435125659	3490	122	27H
0005434876568	3490	123	27K
0005434876647	3490	124	27J
0005434876560	3490	125	28C
0005435625874	3490	126	28B
0005432798954	3490	127	28D
0005435625878	3490	128	28G
0005432183428	3490	129	28H
0005434876624	3490	130	29B
0005432798965	3490	131	29A
0005434876571	3490	132	29D
0005432798975	3490	133	29C
0005435125660	3490	134	29F
0005434876627	3490	135	29E
0005432798971	3490	136	29H
0005435125672	3490	137	29K
0005434426112	3490	138	30C
0005434937799	3490	139	30B
0005434876570	3490	140	30D
0005434876630	3490	141	30G
0005434937800	3490	142	30E
0005434876629	3490	143	30K
0005434426108	3490	144	31D
0005434876645	3490	145	31C
0005435125647	3490	146	31F
0005434426094	3490	147	31J
0005432798970	3490	148	31G
0005434876587	3490	149	31K
0005435625871	3490	150	32C
0005434937795	3490	151	32B
0005432613792	3490	152	32A
0005435125686	3490	153	32E
0005434876590	3490	154	32G
0005434426107	3490	155	32J
0005432188552	3490	156	32H
0005432613791	3490	157	33B
0005434426097	3490	158	33A
0005434876556	3490	159	33F
0005435125670	3490	160	33E
0005434876572	3490	161	33G
0005434876635	3490	162	33K
0005434876576	3490	163	34B
0005435125676	3490	164	34A
0005434876623	3490	165	34E
0005435125667	3490	166	34H
0005434937807	3490	167	34G
0005434876612	3490	168	34J
0005432798981	3490	169	35B
0005434876596	3490	170	35A
0005434876605	3490	171	34K
0005434876631	3490	172	35C
0005434876602	3490	173	35F
0005434876603	3490	174	35E
0005435625864	3490	175	35H
0005434426100	3490	176	35G
0005434876563	3490	177	35J
0005434876632	3490	178	36C
0005434876634	3490	179	36E
0005434937798	3490	180	36D
0005434876577	3490	181	36F
0005434876604	3490	182	36K
0005435125685	3490	183	36J
0005434876628	3490	184	37B
0005435125648	3490	185	37A
0005435625872	3490	186	37E
0005432798960	3490	187	37D
0005434426090	3490	188	37F
0005434876566	3490	189	37J
0005434876637	3490	190	38B
0005435625860	3490	191	39A
0005434937803	3490	192	39D
0005434876595	3490	193	39B
0005435125650	3490	194	39G
0005434876625	3490	195	39J
0005432798980	3490	196	40C
0005432798958	3490	197	40E
0005434937794	3490	198	40D
0005432183429	3490	199	40H
0005434426084	3490	200	40F
0005435625859	3490	201	40J
0005435125668	3490	202	41B
0005434876638	3490	203	40K
0005434876588	3490	204	41D
0005435125683	3490	205	41C
0005434426086	3490	206	41F
0005434426106	3490	207	41G
0005434426087	3490	208	42A
0005432188549	3490	209	41J
0005435125664	3490	210	42E
0005435125658	3490	211	42F
0005432798974	3490	212	42J
0005434876648	3490	213	43A
0005434426111	3490	214	42K
0005434876644	3490	215	43C
0005434876567	3490	216	43B
0005434876611	3490	217	43E
0005434426103	3490	218	43H
0005432798957	3490	219	43J
0005432798978	3490	220	44C
0005435625870	3490	221	44A
0005434876613	3490	222	44D
0005435125681	3490	223	44G
0005434937801	3490	224	44F
0005434876594	3490	225	44J
0005435125673	3490	226	45B
0005432798967	3490	227	45A
0005432798963	3490	228	45H
0005434876561	3490	229	46B
0005432798953	3490	230	46A
0005434876562	3490	231	46F
0005434876641	3490	232	46H
0005434876643	3490	233	47E
0005432798973	3490	234	47D
0005432798982	3490	235	47C
0005434876601	3490	236	48A
0005434876586	3490	237	47K
0005434876592	3490	238	47H
0005434876589	3490	239	48C
0005435125684	3490	240	48F
0005435125649	3490	241	48H
0005434876573	3490	242	49A
0005435125654	3490	243	49E
0005435125680	3490	244	49G
0005434876555	3490	245	49F
0005435625866	3490	246	49K
0005434876579	3490	247	49H
0005435125679	3490	248	50C
0005434937811	3490	249	50A
0005435125662	3490	250	50E
0005434876649	3490	251	50H
0005432798959	3490	252	50F
0005434876607	3490	253	50K
0005435902395	14551	1	2A
0005435902390	14551	2	2H
0005435902388	14551	3	4G
0005432059471	14551	4	5A
0005435902400	14551	5	5H
0005435913849	14551	6	11D
0005432059469	14551	7	12C
0005435902384	14551	8	13F
0005435902389	14551	9	25B
0005435902386	14551	10	26D
0005435902385	14551	11	27F
0005435902401	14551	12	28G
0005435902398	14551	13	30A
0005435902396	14551	14	30K
0005435902387	14551	15	33D
0005435902397	14551	16	33G
0005432059470	14551	17	35K
0005435902399	14551	18	36D
0005435902394	14551	19	39B
0005435902393	14551	20	45J
0005435902391	14551	21	46J
0005435913850	14551	22	48F
0005435902392	14551	23	48D
0005434325452	3625	1	1A
0005434325451	3625	2	1C
0005434325445	3625	3	1D
0005434325450	3625	4	2C
0005434325446	3625	5	3A
0005434325453	3625	6	3D
0005434325448	3625	7	5A
0005434325447	3625	8	6C
0005434325444	3625	9	7C
0005434325443	3625	10	19B
0005434325449	3625	11	19C
0005434325454	3625	12	20C
0005434325455	3625	13	21B
0005435889790	15639	1	4C
0005435889793	15639	2	5C
0005435889791	15639	3	7C
0005435889789	15639	4	7D
0005435889788	15639	5	21A
0005435889792	15639	6	22A
0005435957441	669	1	1B
0005435957438	669	2	4B
0005435957450	669	3	4C
0005435957447	669	4	5B
0005435957453	669	5	5D
0005435957445	669	6	6A
0005435957449	669	7	7A
0005435957448	669	8	7C
0005435957440	669	9	18A
0005435957439	669	10	18D
0005435957444	669	11	19A
0005435957451	669	12	19B
0005435957443	669	13	19D
0005435957452	669	14	21C
0005435957442	669	15	22D
0005435957446	669	16	23B
0005433420253	15177	1	1B
0005433420249	15177	2	2B
0005433420252	15177	3	3A
0005433420256	15177	4	3B
0005433420251	15177	5	4C
0005433420254	15177	6	20B
0005433420255	15177	7	20D
0005433420257	15177	8	21D
0005433420250	15177	9	22A
0005435217676	31773	1	1A
0005435218099	31773	2	5B
0005435216554	31773	3	6A
0005435217677	31773	4	21C
0005435217678	31773	5	22A
0005435216553	31773	6	22D
0005435629383	8849	1	1B
0005434247102	16118	1	1A
0005434247100	16118	2	2B
0005434247101	16118	3	3B
0005434467723	4016	1	4B
0005434467724	4016	2	5A
0005435163143	4432	1	3A
0005435163141	4432	2	5A
0005435163142	4432	3	5C
0005435163144	4432	4	5D
0005435163140	4432	5	18D
0005435163139	4432	6	22A
0005435933395	29506	1	1C
0005435933394	29506	2	6D
0005432645761	6840	1	1A
0005432645768	6840	2	2D
0005432645773	6840	3	3D
0005432645767	6840	4	4E
0005432645764	6840	5	7C
0005432645765	6840	6	10D
0005432645763	6840	7	12F
0005432645766	6840	8	14F
0005432645762	6840	9	15D
0005432645772	6840	10	15E
0005432645769	6840	11	15F
0005432645771	6840	12	17A
0005432645770	6840	13	19F
0005435797234	2837	1	2C
0005435797224	2837	2	4A
0005435797223	2837	3	4D
0005435797226	2837	4	6A
0005435797227	2837	5	8E
0005435797222	2837	6	9D
0005435797230	2837	7	10C
0005435797233	2837	8	11C
0005435797225	2837	9	12A
0005435797231	2837	10	13F
0005435797236	2837	11	14C
0005435797232	2837	12	16C
0005435797235	2837	13	19D
0005435797229	2837	14	20A
0005435797228	2837	15	20F
0005433404679	29309	1	1C
0005433404677	29309	2	3A
0005433404683	29309	3	5C
0005433404681	29309	4	14D
0005433404678	29309	5	15A
0005433404680	29309	6	17C
0005433404682	29309	7	19E
0005434947871	5814	1	1A
0005434947870	5814	2	3A
0005434947868	5814	3	3B
0005434947869	5814	4	4A
0005434947874	5814	5	4B
0005434947872	5814	6	5B
0005434947873	5814	7	6A
0005435376312	16432	1	4A
0005435376313	16432	2	6A
0005435376314	16432	3	6B
0005433959869	6863	1	1A
0005433959896	6863	2	1D
0005433959866	6863	3	2C
0005433959860	6863	4	2D
0005433959895	6863	5	3A
0005433959903	6863	6	3D
0005433959865	6863	7	3F
0005433959883	6863	8	4C
0005433959864	6863	9	4D
0005433959879	6863	10	4E
0005433959891	6863	11	5A
0005433959882	6863	12	5C
0005433959871	6863	13	5F
0005433959872	6863	14	6F
0005433959888	6863	15	7A
0005433959889	6863	16	8A
0005433959900	6863	17	8C
0005433959857	6863	18	8E
0005433959881	6863	19	9D
0005433959893	6863	20	10C
0005433959867	6863	21	10E
0005433959898	6863	22	11A
0005433959870	6863	23	11C
0005433959885	6863	24	11E
0005433959863	6863	25	11F
0005433959887	6863	26	12A
0005433959858	6863	27	12F
0005433959877	6863	28	13E
0005433959902	6863	29	13D
0005433959894	6863	30	14A
0005433959897	6863	31	14C
0005433959876	6863	32	14F
0005433959874	6863	33	15A
0005433959892	6863	34	15E
0005433959862	6863	35	16C
0005433959899	6863	36	16E
0005433959868	6863	37	17C
0005433959859	6863	38	17D
0005433959873	6863	39	17E
0005433959861	6863	40	17F
0005433959875	6863	41	18E
0005433959856	6863	42	18F
0005433959878	6863	43	19E
0005433959901	6863	44	20A
0005433959884	6863	45	20C
0005433959880	6863	46	20D
0005433959886	6863	47	20E
0005433959890	6863	48	20F
0005434244467	5200	1	2D
0005434244473	5200	2	5A
0005434244459	5200	3	4F
0005434244463	5200	4	6A
0005434244453	5200	5	8A
0005434244466	5200	6	9C
0005434244469	5200	7	10A
0005434244470	5200	8	9F
0005434244479	5200	9	12A
0005434244457	5200	10	12E
0005434244462	5200	11	14A
0005434244456	5200	12	15D
0005434244480	5200	13	15E
0005434244477	5200	14	15F
0005434244458	5200	15	17D
0005434244455	5200	16	20A
0005434244478	5200	17	20C
0005434244481	5200	18	20F
0005432166843	5200	19	21C
0005434244476	5200	20	21B
0005432166845	5200	21	22C
0005434244468	5200	22	22E
0005434244464	5200	23	24B
0005434244474	5200	24	25C
0005434244475	5200	25	26A
0005434244471	5200	26	25F
0005434244461	5200	27	26D
0005434244454	5200	28	28A
0005434244482	5200	29	28D
0005434244483	5200	30	29B
0005434244472	5200	31	29E
0005432166844	5200	32	30A
0005434244465	5200	33	30F
0005434244460	5200	34	31B
0005432104729	5204	1	1A
0005433613444	5204	2	1C
0005432104738	5204	3	1F
0005433784315	5204	4	1D
0005433784293	5204	5	2A
0005433613453	5204	6	2C
0005432104714	5204	7	2F
0005433784299	5204	8	2D
0005432104734	5204	9	3A
0005433784312	5204	10	3C
0005432104711	5204	11	3D
0005433613386	5204	12	4A
0005432104749	5204	13	3F
0005433784324	5204	14	4C
0005432104740	5204	15	4F
0005433613433	5204	16	4D
0005433613388	5204	17	5C
0005433784313	5204	18	5A
0005433613452	5204	19	5D
0005433613418	5204	20	6A
0005433784304	5204	21	5F
0005432104735	5204	22	6C
0005433613429	5204	23	6F
0005432104736	5204	24	6D
0005432104742	5204	25	7A
0005432666351	5204	26	7C
0005433613421	5204	27	7D
0005432104728	5204	28	8A
0005433784308	5204	29	7F
0005433784309	5204	30	8B
0005432104759	5204	31	8D
0005432104755	5204	32	8C
0005432104732	5204	33	8E
0005433784311	5204	34	8F
0005433784328	5204	35	9B
0005433613460	5204	36	9A
0005433784301	5204	37	9C
0005432104751	5204	38	9E
0005433613407	5204	39	9D
0005433784292	5204	40	9F
0005432145075	5204	41	10A
0005432104747	5204	42	10C
0005433784317	5204	43	10B
0005433613393	5204	44	10D
0005433784297	5204	45	10E
0005433613435	5204	46	10F
0005433613409	5204	47	11A
0005433613455	5204	48	11C
0005432104725	5204	49	11B
0005432104723	5204	50	11D
0005432104717	5204	51	11E
0005432104744	5204	52	12A
0005433613431	5204	53	11F
0005433784314	5204	54	12C
0005433613408	5204	55	12B
0005433613395	5204	56	12D
0005433613448	5204	57	12E
0005432665237	5204	58	12F
0005432104758	5204	59	13A
0005432104713	5204	60	13C
0005433784305	5204	61	13B
0005433613458	5204	62	13D
0005432104712	5204	63	13F
0005433613419	5204	64	13E
0005433613441	5204	65	14A
0005433613415	5204	66	14C
0005433613423	5204	67	14B
0005433784295	5204	68	14D
0005433613437	5204	69	14F
0005432666352	5204	70	15B
0005432104752	5204	71	15A
0005433613445	5204	72	15C
0005433613397	5204	73	15D
0005433784323	5204	74	15F
0005433613414	5204	75	15E
0005432104715	5204	76	16A
0005432104731	5204	77	16B
0005433613404	5204	78	16D
0005433613424	5204	79	16C
0005432104718	5204	80	16E
0005433613411	5204	81	17A
0005433784316	5204	82	16F
0005433613412	5204	83	17C
0005433613401	5204	84	17B
0005433613420	5204	85	17E
0005433784296	5204	86	17D
0005433613425	5204	87	18A
0005432104748	5204	88	17F
0005433613400	5204	89	18B
0005433613457	5204	90	18C
0005433784318	5204	91	18E
0005432666353	5204	92	18D
0005433784300	5204	93	18F
0005433613396	5204	94	19C
0005432104753	5204	95	19B
0005432104757	5204	96	19D
0005433613416	5204	97	19E
0005433613417	5204	98	20B
0005433613440	5204	99	20A
0005433784322	5204	100	20C
0005433613426	5204	101	20D
0005433613443	5204	102	20F
0005432104727	5204	103	20E
0005433613459	5204	104	21A
0005433613394	5204	105	21C
0005432104722	5204	106	21B
0005433613451	5204	107	21D
0005433613405	5204	108	21E
0005432145077	5204	109	22A
0005432104741	5204	110	21F
0005433613392	5204	111	22B
0005433613454	5204	112	22D
0005433613427	5204	113	22C
0005432104750	5204	114	22E
0005432104726	5204	115	22F
0005433613436	5204	116	23B
0005432665238	5204	117	23A
0005433613430	5204	118	23C
0005433784325	5204	119	23D
0005433613391	5204	120	23F
0005433613446	5204	121	23E
0005432104733	5204	122	24A
0005433784321	5204	123	24B
0005433613410	5204	124	24C
0005433784294	5204	125	24E
0005433784326	5204	126	24D
0005433784298	5204	127	24F
0005433613442	5204	128	25A
0005433613406	5204	129	25C
0005433613439	5204	130	25B
0005433784320	5204	131	25D
0005433613450	5204	132	25F
0005432104737	5204	133	25E
0005433613390	5204	134	26A
0005433784302	5204	135	26B
0005433613413	5204	136	26D
0005433613434	5204	137	26C
0005433784319	5204	138	26E
0005432104716	5204	139	27A
0005432145076	5204	140	26F
0005433784306	5204	141	27C
0005432104720	5204	142	27B
0005433613389	5204	143	27D
0005432104745	5204	144	27F
0005432104719	5204	145	27E
0005433613456	5204	146	28A
0005433784307	5204	147	28B
0005432104743	5204	148	28C
0005433613402	5204	149	28E
0005433613438	5204	150	28D
0005432104724	5204	151	28F
0005433613403	5204	152	29B
0005432104739	5204	153	29A
0005433784303	5204	154	29D
0005433613447	5204	155	29C
0005433613422	5204	156	29E
0005433784310	5204	157	30A
0005432104746	5204	158	29F
0005433613387	5204	159	30B
0005433784327	5204	160	30D
0005432104754	5204	161	30C
0005433613432	5204	162	30E
0005433613449	5204	163	31A
0005432104756	5204	164	30F
0005432104730	5204	165	31B
0005433613399	5204	166	31C
0005433613428	5204	167	31D
0005433613398	5204	168	31E
0005432104721	5204	169	31F
0005434228981	5220	1	2A
0005434149531	5220	2	2D
0005434264695	5220	3	3A
0005434228967	5220	4	2F
0005434264681	5220	5	3F
0005434149528	5220	6	3D
0005434149523	5220	7	4C
0005434149527	5220	8	4D
0005434264679	5220	9	5A
0005434228969	5220	10	4F
0005434264685	5220	11	5C
0005434264686	5220	12	6A
0005434264683	5220	13	6D
0005434228979	5220	14	7A
0005434228975	5220	15	7D
0005434228977	5220	16	7C
0005434149522	5220	17	8A
0005434264693	5220	18	8C
0005434264688	5220	19	9D
0005434264680	5220	20	9F
0005434264682	5220	21	10A
0005434228984	5220	22	10C
0005434264696	5220	23	11B
0005434264694	5220	24	11E
0005434228966	5220	25	12C
0005434149526	5220	26	12E
0005434149525	5220	27	13B
0005434228973	5220	28	14C
0005434264676	5220	29	15D
0005434149524	5220	30	16B
0005434264691	5220	31	16C
0005434264690	5220	32	16F
0005434228983	5220	33	17A
0005434228987	5220	34	17C
0005434228970	5220	35	17E
0005434149530	5220	36	19B
0005434264687	5220	37	19C
0005434149521	5220	38	19E
0005434264689	5220	39	20A
0005434228985	5220	40	20C
0005434149529	5220	41	20D
0005434264692	5220	42	21D
0005434228982	5220	43	21F
0005434264678	5220	44	22A
0005434228976	5220	45	22D
0005434264697	5220	46	22C
0005434264701	5220	47	23A
0005434228974	5220	48	23B
0005434173450	5220	49	23E
0005434228986	5220	50	24B
0005434173451	5220	51	25D
0005434149520	5220	52	26C
0005434264684	5220	53	27C
0005434228968	5220	54	27F
0005434228988	5220	55	28A
0005434228980	5220	56	28E
0005434264700	5220	57	29E
0005434264699	5220	58	29D
0005434264677	5220	59	30A
0005434228978	5220	60	30C
0005434228972	5220	61	30E
0005434228971	5220	62	30D
0005434264698	5220	63	31B
0005434264675	5220	64	31C
0005435269621	8632	1	2D
0005435269636	8632	2	5F
0005435269642	8632	3	8B
0005435269637	8632	4	11C
0005435269628	8632	5	12B
0005435269629	8632	6	12E
0005435269625	8632	7	12F
0005435269624	8632	8	13F
0005435269634	8632	9	14D
0005435269622	8632	10	15D
0005435269639	8632	11	17B
0005435269631	8632	12	17A
0005435269633	8632	13	21B
0005435269627	8632	14	23B
0005435269626	8632	15	25C
0005435269638	8632	16	25B
0005435269623	8632	17	26D
0005435269632	8632	18	27D
0005435269630	8632	19	27F
0005435269635	8632	20	28D
0005435269641	8632	21	29F
0005435269640	8632	22	30A
0005435006615	8630	1	1A
0005432034450	8630	2	1C
0005432034469	8630	3	1D
0005435006619	8630	4	2A
0005432034463	8630	5	3D
0005432047484	8630	6	3C
0005435006608	8630	7	3A
0005432335826	8630	8	4D
0005435006610	8630	9	4C
0005432034456	8630	10	4F
0005435006609	8630	11	5A
0005432034459	8630	12	5F
0005433688773	8630	13	6A
0005432335828	8630	14	6D
0005432034468	8630	15	7A
0005435006612	8630	16	7C
0005435006602	8630	17	8A
0005435006607	8630	18	8C
0005432034451	8630	19	8E
0005435006618	8630	20	9C
0005435006601	8630	21	9D
0005432335827	8630	22	9E
0005433688774	8630	23	10A
0005433815302	8630	24	10B
0005433534460	8630	25	10C
0005432034460	8630	26	10D
0005433534462	8630	27	11A
0005432047486	8630	28	10E
0005433689875	8630	29	11C
0005432034452	8630	30	12A
0005433815300	8630	31	12B
0005432034471	8630	32	12D
0005435006616	8630	33	12C
0005432335821	8630	34	13B
0005432034462	8630	35	13F
0005435006620	8630	36	14C
0005434311182	8630	37	14D
0005432034466	8630	38	15A
0005432034473	8630	39	14F
0005435006617	8630	40	15C
0005432034467	8630	41	16B
0005435006611	8630	42	17A
0005435006605	8630	43	18D
0005433815303	8630	44	19C
0005435006613	8630	45	19D
0005432034470	8630	46	19E
0005432335831	8630	47	20B
0005432034465	8630	48	21A
0005435006614	8630	49	21D
0005433815305	8630	50	21C
0005432034477	8630	51	22A
0005432335830	8630	52	22B
0005432034464	8630	53	22D
0005432034461	8630	54	22F
0005432034449	8630	55	23B
0005432034453	8630	56	23C
0005432335829	8630	57	23E
0005432034474	8630	58	24A
0005432034457	8630	59	23F
0005435006606	8630	60	24E
0005432034476	8630	61	24F
0005433689874	8630	62	25A
0005433534461	8630	63	25D
0005432047485	8630	64	25C
0005433815301	8630	65	25F
0005432034458	8630	66	26B
0005433815304	8630	67	27A
0005432335822	8630	68	27D
0005432335820	8630	69	27F
0005433690890	8630	70	27E
0005433534463	8630	71	28A
0005433690891	8630	72	28B
0005432034475	8630	73	28C
0005432335823	8630	74	28E
0005433690892	8630	75	29B
0005432034455	8630	76	29A
0005435006603	8630	77	29C
0005434311181	8630	78	29D
0005432335825	8630	79	29F
0005433688775	8630	80	30B
0005432034472	8630	81	30D
0005432335824	8630	82	31A
0005435006604	8630	83	30F
0005432034454	8630	84	31B
0005433202114	12615	1	1C
0005433202104	12615	2	1D
0005433202103	12615	3	2A
0005433202110	12615	4	2C
0005433202106	12615	5	3A
0005433202113	12615	6	3D
0005433202109	12615	7	5A
0005433202111	12615	8	5B
0005433202115	12615	9	5C
0005433202105	12615	10	6A
0005433202102	12615	11	7B
0005433202107	12615	12	7D
0005433202108	12615	13	19B
0005433202116	12615	14	22B
0005433202112	12615	15	22D
0005432054252	21103	1	9D
0005432054253	21103	2	18F
0005432054254	21103	3	20C
0005433642080	2485	1	2C
0005433642085	2485	2	2D
0005433642073	2485	3	5E
0005433642078	2485	4	6F
0005433642075	2485	5	9C
0005433642086	2485	6	9D
0005433642087	2485	7	9F
0005433642081	2485	8	10D
0005433642082	2485	9	13A
0005433642084	2485	10	14A
0005433642079	2485	11	16C
0005433642083	2485	12	18C
0005433642077	2485	13	19C
0005433642074	2485	14	19F
0005433642076	2485	15	20F
0005432822072	9614	1	1C
0005432816942	9614	2	1D
0005432816945	9614	3	1F
0005432288929	9614	4	2D
0005432816966	9614	5	4A
0005432822064	9614	6	4E
0005432816950	9614	7	5D
0005432816965	9614	8	5F
0005432816956	9614	9	6C
0005434448256	9614	10	6E
0005432816954	9614	11	6F
0005432816953	9614	12	7C
0005432816960	9614	13	8D
0005432816949	9614	14	8F
0005434448253	9614	15	9A
0005432816952	9614	16	9C
0005432816957	9614	17	9E
0005432822068	9614	18	10A
0005432816943	9614	19	10C
0005432822070	9614	20	10D
0005432816938	9614	21	11E
0005432816961	9614	22	12E
0005432822067	9614	23	14A
0005432816964	9614	24	14C
0005432288927	9614	25	14D
0005432816939	9614	26	14E
0005434448255	9614	27	15C
0005432822071	9614	28	15D
0005432816948	9614	29	15F
0005434448254	9614	30	16C
0005432816962	9614	31	16E
0005432816951	9614	32	16F
0005432816963	9614	33	17A
0005432816946	9614	34	17C
0005432816947	9614	35	17E
0005432822069	9614	36	17F
0005432816958	9614	37	18C
0005432288928	9614	38	18D
0005432816944	9614	39	19A
0005432816941	9614	40	19D
0005432816959	9614	41	19E
0005432816955	9614	42	19F
0005432822066	9614	43	20A
0005432822065	9614	44	20C
0005432816940	9614	45	20E
0005434157344	29001	1	1C
0005432901298	29001	2	1F
0005432901294	29001	3	2A
0005434157341	29001	4	2F
0005432901306	29001	5	3D
0005432901300	29001	6	4D
0005432901303	29001	7	5C
0005432901304	29001	8	5F
0005432002041	29001	9	7F
0005432901302	29001	10	9C
0005432901309	29001	11	9E
0005432901307	29001	12	10C
0005432901293	29001	13	10E
0005434157342	29001	14	11A
0005434157345	29001	15	11D
0005432901310	29001	16	12A
0005432901301	29001	17	12C
0005432901308	29001	18	12D
0005432901296	29001	19	14D
0005432901311	29001	20	14E
0005432002040	29001	21	16A
0005432901299	29001	22	16C
0005432901295	29001	23	17C
0005432901305	29001	24	18E
0005434157343	29001	25	19F
0005432901297	29001	26	20A
0005434157346	29001	27	20F
0005432613789	15145	1	1A
0005432613792	15145	2	1B
0005432613790	15145	3	2B
0005432613791	15145	4	5A
0005432947780	25270	1	2C
0005432947782	25270	2	2A
0005432947789	25270	3	4D
0005432947768	25270	4	5D
0005432947764	25270	5	6B
0005432947798	25270	6	6E
0005432947796	25270	7	7C
0005432947800	25270	8	7E
0005432947787	25270	9	8E
0005432947779	25270	10	9B
0005432947778	25270	11	9A
0005432947784	25270	12	9F
0005432947767	25270	13	10B
0005432947793	25270	14	10E
0005432947795	25270	15	10F
0005432947781	25270	16	11B
0005432947775	25270	17	11A
0005432947783	25270	18	11F
0005432947801	25270	19	11E
0005432947772	25270	20	12A
0005432947771	25270	21	13A
0005432947773	25270	22	13C
0005432947790	25270	23	13B
0005432947804	25270	24	14C
0005432947769	25270	25	14E
0005432947797	25270	26	15D
0005432947765	25270	27	15C
0005432947791	25270	28	15F
0005432947774	25270	29	16A
0005432947794	25270	30	17B
0005432947802	25270	31	17C
0005432947786	25270	32	17F
0005432947777	25270	33	17E
0005432947788	25270	34	18A
0005432947799	25270	35	18E
0005432947770	25270	36	19C
0005432947785	25270	37	20A
0005432947766	25270	38	20D
0005432947776	25270	39	20F
0005432947792	25270	40	20E
0005432947803	25270	41	21E
0005432430803	14467	1	6E
0005432430800	14467	2	9C
0005434026671	14467	3	11C
0005432430802	14467	4	12E
0005434026669	14467	5	19A
0005434026670	14467	6	21C
0005432430801	14467	7	21E
0005433808308	30832	1	1A
0005433808307	30832	2	9A
0005433808309	30832	3	10B
0005433808304	30832	4	11F
0005433808305	30832	5	14D
0005433808306	30832	6	19A
0005434654168	5381	1	1A
0005434654179	5381	2	2D
0005434654182	5381	3	3A
0005434654172	5381	4	3C
0005434654178	5381	5	3D
0005434654163	5381	6	3F
0005434654170	5381	7	4C
0005434654166	5381	8	4D
0005434654167	5381	9	5A
0005434654174	5381	10	5C
0005434654186	5381	11	5D
0005434656521	5381	12	5F
0005434654187	5381	13	6A
0005434654162	5381	14	6F
0005434654169	5381	15	7A
0005434654181	5381	16	7F
0005434654184	5381	17	8E
0005434656520	5381	18	8F
0005434654176	5381	19	9C
0005434654173	5381	20	9F
0005434654175	5381	21	10E
0005434654164	5381	22	11C
0005432114146	5381	23	11E
0005434654161	5381	24	12C
0005432114145	5381	25	12D
0005432114147	5381	26	12F
0005434654183	5381	27	13E
0005434654165	5381	28	13F
0005434654188	5381	29	14C
0005434654177	5381	30	16F
0005432114148	5381	31	17A
0005434654185	5381	32	17C
0005434654160	5381	33	19C
0005434654171	5381	34	20E
0005434654180	5381	35	20F
0005435555335	12554	1	1D
0005435339991	12554	2	3C
0005435339989	12554	3	4F
0005435339996	12554	4	6D
0005435339998	12554	5	6F
0005435339992	12554	6	8C
0005435340001	12554	7	8D
0005435555334	12554	8	10D
0005435340002	12554	9	11D
0005435340000	12554	10	13A
0005435339999	12554	11	15D
0005435339993	12554	12	15F
0005435339990	12554	13	17F
0005435339995	12554	14	18F
0005435340003	12554	15	19C
0005435339997	12554	16	19D
0005435339994	12554	17	20A
0005433715070	7456	1	1C
0005433715087	7456	2	1F
0005433715100	7456	3	2D
0005432078011	7456	4	2F
0005433715080	7456	5	3C
0005433715114	7456	6	4B
0005433715068	7456	7	5B
0005433715093	7456	8	5A
0005432078008	7456	9	5D
0005433715075	7456	10	5E
0005433715097	7456	11	6A
0005433715091	7456	12	7D
0005433715083	7456	13	7C
0005433715109	7456	14	7E
0005433715094	7456	15	7F
0005432078012	7456	16	8B
0005433715105	7456	17	8C
0005433715112	7456	18	8D
0005433715076	7456	19	8E
0005433715108	7456	20	9B
0005433715104	7456	21	9C
0005432078013	7456	22	9E
0005433715107	7456	23	9D
0005433715081	7456	24	10D
0005432078009	7456	25	10E
0005433715090	7456	26	11A
0005433715099	7456	27	11F
0005433715086	7456	28	12B
0005433715077	7456	29	12A
0005433715074	7456	30	12E
0005433715115	7456	31	12D
0005433715098	7456	32	13C
0005433715089	7456	33	13F
0005433715110	7456	34	14B
0005433715095	7456	35	14C
0005433715071	7456	36	15A
0005433715069	7456	37	15F
0005433715096	7456	38	16D
0005433715101	7456	39	16C
0005433715072	7456	40	17A
0005433715082	7456	41	17D
0005433715103	7456	42	17F
0005432078014	7456	43	18A
0005433715106	7456	44	18E
0005433715067	7456	45	18D
0005433715102	7456	46	18F
0005433715111	7456	47	19B
0005433715084	7456	48	20B
0005433715088	7456	49	21E
0005433715073	7456	50	22B
0005433715085	7456	51	22D
0005433715078	7456	52	22E
0005433715092	7456	53	22F
0005432078010	7456	54	23B
0005432078015	7456	55	23A
0005433715113	7456	56	23D
0005433715079	7456	57	23F
0005432428867	29197	1	6D
0005432006710	29197	2	12E
0005432006708	29197	3	12F
0005432428868	29197	4	15B
0005432006709	29197	5	16E
0005432428869	29197	6	18D
0005435266074	29197	7	20F
0005434095016	8676	1	3A
0005434095020	8676	2	4F
0005434095022	8676	3	5C
0005434095024	8676	4	5D
0005434095028	8676	5	6A
0005434095021	8676	6	6F
0005434095029	8676	7	7F
0005434095018	8676	8	10A
0005434095015	8676	9	10E
0005434095017	8676	10	17A
0005434095025	8676	11	17C
0005434095026	8676	12	17E
0005434095019	8676	13	19A
0005434095023	8676	14	19C
0005434095027	8676	15	19F
0005434181965	11646	1	1C
0005434181957	11646	2	4C
0005434181959	11646	3	5E
0005434181964	11646	4	6F
0005434181963	11646	5	8A
0005434181962	11646	6	11F
0005434181966	11646	7	12C
0005434181961	11646	8	13D
0005434181967	11646	9	13E
0005434181968	11646	10	17F
0005434181960	11646	11	18A
0005434181958	11646	12	20F
0005433456897	1452	1	6D
0005435732120	1452	2	6E
0005435732116	1452	3	7A
0005435732115	1452	4	7C
0005433456898	1452	5	8E
0005435732117	1452	6	9F
0005435732124	1452	7	11D
0005435732122	1452	8	12C
0005432297231	1452	9	12D
0005432297232	1452	10	13C
0005433456900	1452	11	14D
0005433456899	1452	12	14F
0005432297230	1452	13	15D
0005435732119	1452	14	16A
0005435732118	1452	15	16E
0005435732114	1452	16	17A
0005435732123	1452	17	17E
0005435732113	1452	18	19A
0005435732121	1452	19	19E
0005435732112	1452	20	20F
0005433397213	19231	1	1A
0005433397186	19231	2	1C
0005433397228	19231	3	2C
0005433397225	19231	4	2D
0005433397222	19231	5	3A
0005433397217	19231	6	3D
0005433397187	19231	7	3F
0005433397218	19231	8	4A
0005433397185	19231	9	4D
0005433397211	19231	10	4E
0005433397199	19231	11	4F
0005433397219	19231	12	5A
0005433397194	19231	13	5C
0005433397184	19231	14	5D
0005433397189	19231	15	5E
0005433397223	19231	16	6A
0005433397212	19231	17	6E
0005433397196	19231	18	7A
0005432906492	19231	19	7C
0005433397210	19231	20	7D
0005433397178	19231	21	7E
0005433397221	19231	22	8D
0005433397216	19231	23	8F
0005433397190	19231	24	9C
0005433397183	19231	25	9F
0005433397182	19231	26	10D
0005433397209	19231	27	10E
0005433397198	19231	28	10F
0005433397197	19231	29	11C
0005433397191	19231	30	11D
0005433397215	19231	31	12C
0005433397226	19231	32	12D
0005433397195	19231	33	12E
0005432906491	19231	34	12F
0005433397192	19231	35	13A
0005433397180	19231	36	13D
0005433397214	19231	37	13F
0005433397200	19231	38	14A
0005433397181	19231	39	14C
0005433397220	19231	40	14D
0005433397204	19231	41	14E
0005433397193	19231	42	15A
0005433397179	19231	43	15F
0005433397227	19231	44	17E
0005433397208	19231	45	17F
0005433397202	19231	46	18C
0005433397206	19231	47	18D
0005433397205	19231	48	19A
0005433397207	19231	49	19C
0005433397201	19231	50	19F
0005433397188	19231	51	20C
0005433397203	19231	52	20D
0005433397224	19231	53	20E
0005434954540	7267	1	1A
0005434954538	7267	2	4A
0005434954539	7267	3	6A
0005434954537	7267	4	5B
0005435377538	28327	1	1B
0005435377537	28327	2	5A
0005434351476	4490	1	1C
0005434351466	4490	2	2B
0005434351464	4490	3	2C
0005434351472	4490	4	5C
0005434351471	4490	5	5D
0005434351475	4490	6	6B
0005434351469	4490	7	6D
0005434351468	4490	8	18B
0005434351473	4490	9	18D
0005434351463	4490	10	19A
0005434351470	4490	11	21B
0005434351474	4490	12	21C
0005434351465	4490	13	22A
0005434351467	4490	14	22C
0005435893507	29663	1	3C
0005435893505	29663	2	4B
0005435893509	29663	3	7D
0005435893506	29663	4	18C
0005435893503	29663	5	19C
0005435893508	29663	6	21D
0005435893504	29663	7	22A
0005435091899	1090	1	4F
0005435091897	1090	2	11F
0005435091895	1090	3	11H
0005433462709	1090	4	12A
0005435091894	1090	5	12F
0005432293165	1090	6	14A
0005433463863	1090	7	16D
0005435091896	1090	8	18B
0005435091892	1090	9	18E
0005433463862	1090	10	20F
0005435091898	1090	11	21F
0005434445207	1090	12	22A
0005435091893	1090	13	23E
0005435091900	1090	14	24D
0005434446476	1090	15	24E
0005434445210	1090	16	28F
0005434445208	1090	17	29G
0005433463861	1090	18	30D
0005434445209	1090	19	31A
0005433462708	1090	20	34G
0005432293164	1090	21	35G
0005435091901	1090	22	37G
0005433269620	17024	1	16H
0005433269619	17024	2	19G
0005433269624	17024	3	27E
0005433269622	17024	4	27H
0005433269623	17024	5	31H
0005433269621	17024	6	32D
0005432851815	18263	1	7E
0005432851816	18263	2	7F
0005432851819	18263	3	10B
0005432851817	18263	4	11D
0005432851820	18263	5	17D
0005432851818	18263	6	20E
0005432159776	12797	1	4B
0005432433582	12797	2	4C
0005432433585	12797	3	5B
0005433812858	12797	4	6F
0005433812857	12797	5	7A
0005432433586	12797	6	9B
0005432161111	12797	7	9C
0005432161110	12797	8	12D
0005432433583	12797	9	19C
0005432159777	12797	10	19D
0005432159778	12797	11	20A
0005432433584	12797	12	20E
0005433812859	12797	13	21C
0005432159775	12797	14	23A
0005433989684	30696	1	5E
0005433989681	30696	2	16A
0005433989682	30696	3	20A
0005433989683	30696	4	20F
0005435765119	5493	1	1C
0005435765148	5493	2	1H
0005435765122	5493	3	2B
0005432140305	5493	4	3A
0005435765106	5493	5	3F
0005435722013	5493	6	3H
0005435765169	5493	7	4B
0005435765146	5493	8	4G
0005435765136	5493	9	4H
0005435765134	5493	10	5G
0005435765116	5493	11	5F
0005433529211	5493	12	9B
0005432140301	5493	13	9G
0005435765107	5493	14	9H
0005435765127	5493	15	11B
0005435765139	5493	16	11D
0005432140300	5493	17	11H
0005435765168	5493	18	12G
0005435765130	5493	19	12H
0005435765159	5493	20	13B
0005435765144	5493	21	13A
0005435765115	5493	22	13G
0005435765125	5493	23	14B
0005435765126	5493	24	14F
0005435765164	5493	25	15A
0005435765128	5493	26	15F
0005435765140	5493	27	15H
0005435765121	5493	28	16A
0005435720800	5493	29	16D
0005432140298	5493	30	16E
0005433529212	5493	31	16F
0005435765154	5493	32	16H
0005435765166	5493	33	16G
0005435765141	5493	34	17E
0005432140306	5493	35	17G
0005435765111	5493	36	17H
0005433529210	5493	37	18A
0005435765110	5493	38	18E
0005435765171	5493	39	18D
0005435765124	5493	40	18G
0005435765162	5493	41	19D
0005435765138	5493	42	19B
0005435765102	5493	43	19E
0005435765132	5493	44	20A
0005435765152	5493	45	19H
0005435765133	5493	46	20B
0005435765167	5493	47	20F
0005432140303	5493	48	21A
0005432140304	5493	49	21B
0005435765129	5493	50	21E
0005435765165	5493	51	22B
0005435765135	5493	52	22A
0005435765158	5493	53	22F
0005435765147	5493	54	23A
0005435765109	5493	55	22H
0005435765155	5493	56	23B
0005435765105	5493	57	23E
0005435765160	5493	58	23H
0005435765149	5493	59	24A
0005435765157	5493	60	24D
0005433527199	5493	61	24E
0005435765123	5493	62	25D
0005433527202	5493	63	24H
0005435765145	5493	64	25F
0005432140299	5493	65	27B
0005435765103	5493	66	28A
0005435765161	5493	67	27H
0005435722012	5493	68	28B
0005435765150	5493	69	28F
0005435765131	5493	70	29A
0005435765120	5493	71	29F
0005435765143	5493	72	30D
0005435765163	5493	73	30G
0005433529213	5493	74	31B
0005435765156	5493	75	31A
0005435765151	5493	76	31D
0005435765114	5493	77	32A
0005432140307	5493	78	33A
0005435765112	5493	79	33E
0005435765104	5493	80	34A
0005435765142	5493	81	34E
0005435765108	5493	82	34H
0005435765137	5493	83	35E
0005435720798	5493	84	35D
0005435765118	5493	85	36D
0005432140302	5493	86	36H
0005435720799	5493	87	37B
0005435765170	5493	88	37G
0005433527200	5493	89	38A
0005435765153	5493	90	38D
0005435765113	5493	91	38H
0005433527201	5493	92	39D
0005435765117	5493	93	39F
0005432535746	13470	1	1C
0005434264686	13470	2	1B
0005432535749	13470	3	1G
0005434264678	13470	4	2C
0005435461788	13470	5	2G
0005434831066	13470	6	3A
0005435461769	13470	7	2H
0005435461777	13470	8	3F
0005435461773	13470	9	4A
0005435461756	13470	10	3H
0005435461763	13470	11	4B
0005434264696	13470	12	4G
0005435461784	13470	13	5B
0005435461768	13470	14	5C
0005434264683	13470	15	11A
0005432535747	13470	16	11E
0005434264685	13470	17	12A
0005435461787	13470	18	12F
0005434264691	13470	19	13F
0005434264681	13470	20	13G
0005434264677	13470	21	14B
0005435461774	13470	22	14A
0005435461780	13470	23	14E
0005432194435	13470	24	15A
0005434264690	13470	25	15D
0005435461776	13470	26	15H
0005434264700	13470	27	16G
0005435461786	13470	28	16F
0005435461762	13470	29	17D
0005435461781	13470	30	17E
0005432194438	13470	31	17G
0005435461791	13470	32	18B
0005435461779	13470	33	18D
0005434264699	13470	34	18G
0005435461772	13470	35	19F
0005434264695	13470	36	20A
0005432535745	13470	37	20E
0005434264701	13470	38	20G
0005434264687	13470	39	21B
0005434831068	13470	40	21H
0005435461790	13470	41	22A
0005434264697	13470	42	22G
0005435461760	13470	43	23E
0005435461789	13470	44	23F
0005435461794	13470	45	24B
0005434264684	13470	46	24E
0005432194436	13470	47	24G
0005434264676	13470	48	25E
0005434264692	13470	49	27A
0005434264698	13470	50	27D
0005435461792	13470	51	27F
0005434264682	13470	52	27H
0005435461766	13470	53	28D
0005435461765	13470	54	28H
0005434264689	13470	55	29A
0005434264688	13470	56	29B
0005435461770	13470	57	29H
0005434831067	13470	58	29G
0005432194437	13470	59	30A
0005434831070	13470	60	31B
0005434264693	13470	61	31G
0005432194439	13470	62	32D
0005435461764	13470	63	32B
0005435461758	13470	64	33F
0005434831069	13470	65	34B
0005435461759	13470	66	34F
0005435461771	13470	67	34H
0005432535748	13470	68	35B
0005435461757	13470	69	35G
0005435461778	13470	70	35F
0005435461785	13470	71	36A
0005435461793	13470	72	35H
0005435461767	13470	73	36B
0005434264694	13470	74	36E
0005434264680	13470	75	37A
0005435461775	13470	76	37D
0005434264679	13470	77	38B
0005434264675	13470	78	38E
0005435461761	13470	79	38F
0005435461783	13470	80	39D
0005435461782	13470	81	39F
0005435846191	25096	1	10A
0005435846188	25096	2	10D
0005435846190	25096	3	12D
0005435846189	25096	4	15E
0005433810491	1819	1	2D
0005432295834	1819	2	8D
0005432295833	1819	3	14D
0005433810488	1819	4	15C
0005433810489	1819	5	17E
0005433810490	1819	6	19E
0005432295832	1819	7	19F
0005433845696	5588	1	1C
0005433845710	5588	2	1D
0005432081398	5588	3	2D
0005433845663	5588	4	2F
0005433845704	5588	5	3D
0005433845679	5588	6	4A
0005433845678	5588	7	4C
0005433845720	5588	8	4F
0005433845712	5588	9	4D
0005433845673	5588	10	5A
0005433845684	5588	11	5F
0005433845691	5588	12	6A
0005433845690	5588	13	6C
0005433845716	5588	14	6B
0005433845689	5588	15	6F
0005433845714	5588	16	6E
0005433845681	5588	17	7C
0005433845692	5588	18	7D
0005433845705	5588	19	7F
0005433845701	5588	20	8A
0005433845676	5588	21	8D
0005433845715	5588	22	8F
0005433845708	5588	23	8E
0005433845668	5588	24	9A
0005433845695	5588	25	9C
0005433845719	5588	26	9E
0005433845665	5588	27	10A
0005433845697	5588	28	9F
0005433845667	5588	29	10B
0005432081394	5588	30	11B
0005433845713	5588	31	11A
0005433845683	5588	32	11D
0005433845682	5588	33	11E
0005432081396	5588	34	12B
0005433845721	5588	35	12D
0005432081393	5588	36	13B
0005433845706	5588	37	13A
0005433845688	5588	38	13D
0005433845687	5588	39	14A
0005432081400	5588	40	13F
0005433845711	5588	41	13E
0005433845722	5588	42	14B
0005433845685	5588	43	14D
0005433845680	5588	44	14C
0005433845702	5588	45	14F
0005433845666	5588	46	15B
0005433845703	5588	47	15F
0005432081397	5588	48	15E
0005433845693	5588	49	16E
0005433845672	5588	50	16D
0005433845677	5588	51	16C
0005433845671	5588	52	17A
0005433845699	5588	53	16F
0005432081399	5588	54	17C
0005432081395	5588	55	17D
0005433845670	5588	56	18B
0005433845717	5588	57	17F
0005433845674	5588	58	18C
0005433845686	5588	59	18F
0005433845707	5588	60	18E
0005433845669	5588	61	18D
0005433845664	5588	62	19C
0005433845709	5588	63	19F
0005433845718	5588	64	20C
0005433845675	5588	65	20A
0005433845700	5588	66	20F
0005433845698	5588	67	21E
0005433845694	5588	68	21D
0005435282067	13884	1	2A
0005435282064	13884	2	3F
0005434173451	13884	3	4C
0005435282058	13884	4	4A
0005432003645	13884	5	5A
0005435282055	13884	6	4F
0005435282069	13884	7	6C
0005435282059	13884	8	8D
0005435282057	13884	9	8F
0005435282054	13884	10	9A
0005435282062	13884	11	10C
0005435282053	13884	12	10B
0005435282061	13884	13	10E
0005435282050	13884	14	11B
0005435282063	13884	15	11A
0005435282049	13884	16	12B
0005432003647	13884	17	12E
0005435282052	13884	18	13F
0005435282051	13884	19	14C
0005435282060	13884	20	14D
0005435282068	13884	21	16A
0005434173450	13884	22	16E
0005435282065	13884	23	17C
0005435282056	13884	24	17F
0005432003646	13884	25	20E
0005435282066	13884	26	21C
0005434620228	7843	1	1C
0005434620230	7843	2	1D
0005434620232	7843	3	2A
0005432112476	7843	4	2D
0005434620233	7843	5	3A
0005434620240	7843	6	3D
0005434620226	7843	7	4D
0005434620242	7843	8	5B
0005434620223	7843	9	5C
0005434620222	7843	10	6A
0005434620238	7843	11	7A
0005434620227	7843	12	7B
0005434620241	7843	13	18A
0005434620239	7843	14	18C
0005434620229	7843	15	19B
0005434620231	7843	16	20A
0005434620234	7843	17	20C
0005434620235	7843	18	21A
0005434620236	7843	19	21B
0005434620224	7843	20	21C
0005434620237	7843	21	21D
0005434620225	7843	22	22D
0005432112475	7843	23	23A
0005435332153	32948	1	2B
0005435332154	32948	2	3A
0005435332149	32948	3	3B
0005435332156	32948	4	4A
0005435332150	32948	5	6B
0005435332152	32948	6	18B
0005435332155	32948	7	19A
0005435332146	32948	8	20B
0005435332148	32948	9	21B
0005435332147	32948	10	21D
0005435332151	32948	11	23A
0005435784754	4260	1	1A
0005435784742	4260	2	2C
0005432190562	4260	3	2F
0005432190561	4260	4	3C
0005435784758	4260	5	3D
0005432190564	4260	6	4A
0005435784748	4260	7	4D
0005435784736	4260	8	4E
0005435784760	4260	9	5D
0005435784757	4260	10	5E
0005434993846	4260	11	5F
0005435784762	4260	12	6A
0005435784755	4260	13	6C
0005435784737	4260	14	6D
0005435784731	4260	15	7A
0005435784738	4260	16	8C
0005435784729	4260	17	8D
0005435784734	4260	18	9A
0005435784739	4260	19	9E
0005435784756	4260	20	9F
0005432190563	4260	21	10C
0005435784740	4260	22	10D
0005435784732	4260	23	10E
0005434993854	4260	24	11A
0005434993851	4260	25	12C
0005435784749	4260	26	12D
0005435784752	4260	27	12F
0005434993848	4260	28	13A
0005435784746	4260	29	13D
0005435784747	4260	30	13E
0005435784735	4260	31	14C
0005434993853	4260	32	14E
0005434993852	4260	33	15C
0005435784759	4260	34	15D
0005435784733	4260	35	16D
0005435784727	4260	36	16E
0005435784728	4260	37	17C
0005435784751	4260	38	17D
0005435784750	4260	39	17F
0005435784763	4260	40	18A
0005435784730	4260	41	18C
0005435784753	4260	42	18E
0005434993850	4260	43	18F
0005434993847	4260	44	19A
0005435784744	4260	45	19C
0005435784745	4260	46	19D
0005434993849	4260	47	19E
0005435784743	4260	48	20A
0005435784761	4260	49	20E
0005435784741	4260	50	20F
0005435918570	27318	1	1F
0005435918572	27318	2	11D
0005435918571	27318	3	14E
0005435918569	27318	4	18F
0005432566574	4695	1	1A
0005434081472	4695	2	2C
0005434081483	4695	3	2F
0005432170270	4695	4	2G
0005432566543	4695	5	3A
0005432566539	4695	6	3C
0005432566569	4695	7	3H
0005432566545	4695	8	3G
0005434081485	4695	9	4G
0005434081479	4695	10	5A
0005432566541	4695	11	5F
0005432566535	4695	12	5G
0005434081473	4695	13	9A
0005432566575	4695	14	5H
0005432566577	4695	15	9B
0005432566584	4695	16	11A
0005432566555	4695	17	9H
0005432566557	4695	18	11E
0005432566581	4695	19	11G
0005432566565	4695	20	12A
0005432566586	4695	21	11H
0005434081484	4695	22	12D
0005432566530	4695	23	12E
0005432566566	4695	24	12F
0005432566538	4695	25	13D
0005432566542	4695	26	13B
0005432566558	4695	27	13G
0005432566580	4695	28	13H
0005432566572	4695	29	14B
0005432566551	4695	30	14D
0005434081480	4695	31	14F
0005432566548	4695	32	14H
0005432566570	4695	33	15B
0005432566540	4695	34	15E
0005432566547	4695	35	15D
0005432566533	4695	36	16D
0005432566553	4695	37	18A
0005432566588	4695	38	18F
0005432566534	4695	39	18E
0005432566544	4695	40	18H
0005434081476	4695	41	19D
0005432566550	4695	42	19H
0005432566563	4695	43	19G
0005432566582	4695	44	20A
0005432566525	4695	45	20B
0005434081477	4695	46	20E
0005434081471	4695	47	20D
0005432566583	4695	48	20H
0005433726063	4695	49	21A
0005432566568	4695	50	22B
0005432566562	4695	51	22E
0005433451582	4695	52	22G
0005432566578	4695	53	23B
0005432566546	4695	54	23G
0005432566528	4695	55	24B
0005433451583	4695	56	24E
0005434081475	4695	57	24G
0005432186804	4695	58	25E
0005432566571	4695	59	27A
0005432566556	4695	60	25F
0005434081486	4695	61	27B
0005432566564	4695	62	27F
0005432566579	4695	63	27G
0005432186803	4695	64	28A
0005432566526	4695	65	28D
0005432566549	4695	66	29B
0005432566585	4695	67	29E
0005434081470	4695	68	29F
0005432566573	4695	69	30B
0005432566532	4695	70	30A
0005432186806	4695	71	30E
0005433452702	4695	72	30F
0005432566576	4695	73	30H
0005432566554	4695	74	31B
0005432170267	4695	75	31A
0005434081474	4695	76	32E
0005432566529	4695	77	32F
0005434081482	4695	78	33H
0005432566559	4695	79	34A
0005434081481	4695	80	34F
0005432170269	4695	81	34E
0005432566536	4695	82	34G
0005432566560	4695	83	35A
0005432566527	4695	84	35D
0005432186805	4695	85	35G
0005434081478	4695	86	35F
0005432566561	4695	87	35H
0005432566531	4695	88	36B
0005432170266	4695	89	36A
0005432566537	4695	90	36E
0005432566567	4695	91	36G
0005433452701	4695	92	37A
0005433452703	4695	93	37E
0005432170268	4695	94	37D
0005432566552	4695	95	37H
0005432566587	4695	96	38A
0005432161110	30531	1	3G
0005432213541	30531	2	15G
0005432213539	30531	3	29B
0005432161111	30531	4	32F
0005432213542	30531	5	33E
0005432213540	30531	6	37A
0005435720798	13619	1	1A
0005435720800	13619	2	4A
0005435722013	13619	3	4B
0005435720799	13619	4	5A
0005435722012	13619	5	6A
0005432295833	22773	1	4A
0005432295832	22773	2	22A
0005432295834	22773	3	22C
0005433341410	11112	1	1C
0005433341457	11112	2	1F
0005433341429	11112	3	1D
0005433341416	11112	4	2A
0005433341395	11112	5	2C
0005433341381	11112	6	3A
0005433341468	11112	7	2F
0005433341402	11112	8	3D
0005433341463	11112	9	3C
0005433341409	11112	10	3F
0005433341464	11112	11	4A
0005433341456	11112	12	4B
0005433341379	11112	13	4D
0005433341417	11112	14	4C
0005433341452	11112	15	4E
0005433341389	11112	16	4F
0005433341446	11112	17	5B
0005433341467	11112	18	5D
0005433341408	11112	19	5C
0005433341436	11112	20	5E
0005433341448	11112	21	6A
0005433341398	11112	22	5F
0005433341420	11112	23	6B
0005433341478	11112	24	6D
0005433341378	11112	25	6F
0005433341425	11112	26	6E
0005433341462	11112	27	7C
0005433341384	11112	28	7B
0005433341434	11112	29	7E
0005433341422	11112	30	7D
0005433341455	11112	31	8B
0005433341471	11112	32	8D
0005433341405	11112	33	8C
0005433341470	11112	34	8E
0005433341401	11112	35	8F
0005433341458	11112	36	9C
0005433341387	11112	37	9E
0005433341419	11112	38	9D
0005433341406	11112	39	9F
0005433341394	11112	40	10C
0005433341443	11112	41	10E
0005433341423	11112	42	10D
0005433341465	11112	43	11B
0005433341426	11112	44	11D
0005433341445	11112	45	12B
0005433341380	11112	46	12A
0005433341459	11112	47	12C
0005433341450	11112	48	12D
0005433341449	11112	49	12E
0005433341454	11112	50	12F
0005433341411	11112	51	13B
0005433341382	11112	52	13A
0005433341430	11112	53	13D
0005433341412	11112	54	13E
0005433341439	11112	55	14A
0005433341391	11112	56	13F
0005433341451	11112	57	14B
0005433341393	11112	58	14D
0005433341400	11112	59	14C
0005433341385	11112	60	14E
0005433341447	11112	61	15B
0005433341461	11112	62	15A
0005433341396	11112	63	15C
0005433341390	11112	64	15D
0005433341432	11112	65	15E
0005433341414	11112	66	15F
0005433341444	11112	67	16B
0005433341472	11112	68	16A
0005433341437	11112	69	16C
0005433341440	11112	70	16D
0005433341476	11112	71	16F
0005433341418	11112	72	16E
0005433341383	11112	73	17B
0005433341424	11112	74	17E
0005433341386	11112	75	17D
0005433341407	11112	76	17F
0005433341399	11112	77	18A
0005433341431	11112	78	18C
0005433341428	11112	79	18B
0005433341392	11112	80	18D
0005433341466	11112	81	18F
0005433341433	11112	82	19B
0005433341404	11112	83	19A
0005433341415	11112	84	19C
0005433341435	11112	85	19E
0005433341441	11112	86	19D
0005433341479	11112	87	19F
0005433341469	11112	88	20C
0005433341477	11112	89	20D
0005433341427	11112	90	21A
0005433341473	11112	91	21C
0005433341460	11112	92	21B
0005433341474	11112	93	21D
0005433341421	11112	94	21E
0005433341438	11112	95	21F
0005433341475	11112	96	22B
0005433341453	11112	97	22E
0005433341413	11112	98	22F
0005433341403	11112	99	23B
0005433341397	11112	100	23A
0005433341442	11112	101	23C
0005433341388	11112	102	23D
0005432293165	17112	1	15D
0005432293164	17112	2	20B
0005433506861	9116	1	1C
0005433506866	9116	2	2C
0005433506857	9116	3	2D
0005433506863	9116	4	3C
0005433481032	9116	5	3D
0005433506870	9116	6	3F
0005433481029	9116	7	4C
0005433506859	9116	8	5A
0005433506860	9116	9	5F
0005433481031	9116	10	6C
0005433506856	9116	11	6D
0005433506862	9116	12	8D
0005433481030	9116	13	9A
0005433481027	9116	14	9F
0005433506864	9116	15	11D
0005433506871	9116	16	11F
0005433481034	9116	17	12D
0005433481033	9116	18	13A
0005433506869	9116	19	13D
0005433506855	9116	20	14A
0005433506865	9116	21	15A
0005433506854	9116	22	15D
0005433506867	9116	23	17D
0005433481028	9116	24	19D
0005433506868	9116	25	20A
0005433506853	9116	26	20D
0005433506858	9116	27	20F
0005432919520	20490	1	2D
0005432919523	20490	2	2F
0005432919514	20490	3	3D
0005432919504	20490	4	3F
0005434158945	20490	5	4A
0005432919511	20490	6	4C
0005432919506	20490	7	5C
0005432919517	20490	8	6C
0005432919521	20490	9	6E
0005432919524	20490	10	7C
0005432919513	20490	11	9E
0005432919518	20490	12	10D
0005434158946	20490	13	10E
0005432919508	20490	14	11E
0005432919516	20490	15	12A
0005434158943	20490	16	12C
0005432919505	20490	17	13C
0005432919522	20490	18	13F
0005432919509	20490	19	15D
0005432919515	20490	20	17A
0005432919507	20490	21	17C
0005432919510	20490	22	17E
0005434158944	20490	23	18A
0005432919519	20490	24	18F
0005432919512	20490	25	19F
0005432919503	20490	26	20F
0005434411702	11042	1	8C
0005434928248	11042	2	10A
0005434411704	11042	3	12A
0005434928249	11042	4	13F
0005434928251	11042	5	15D
0005434411703	11042	6	18F
0005434411701	11042	7	19D
0005434928250	11042	8	20A
0005435125688	14685	1	1A
0005435125651	14685	2	1D
0005435556647	14685	3	1F
0005435625861	14685	4	2A
0005435625875	14685	5	2C
0005435125680	14685	6	2D
0005435125675	14685	7	3A
0005435125655	14685	8	3C
0005435125673	14685	9	3D
0005435625859	14685	10	3F
0005435125659	14685	11	4C
0005435125663	14685	12	4D
0005435625878	14685	13	4E
0005435625870	14685	14	4F
0005435125678	14685	15	5A
0005435125662	14685	16	5C
0005435125666	14685	17	5D
0005435125672	14685	18	5E
0005435556646	14685	19	5F
0005435125665	14685	20	6A
0005435125654	14685	21	6E
0005435125647	14685	22	7A
0005435625879	14685	23	7D
0005435625864	14685	24	7F
0005435125670	14685	25	8E
0005435125653	14685	26	8F
0005435556648	14685	27	9A
0005435125649	14685	28	9C
0005435556649	14685	29	10A
0005435625874	14685	30	9F
0005435625871	14685	31	10C
0005435125664	14685	32	10D
0005435625860	14685	33	11A
0005435125685	14685	34	11C
0005435625876	14685	35	11D
0005435125656	14685	36	11F
0005435125681	14685	37	12C
0005435625872	14685	38	12D
0005435625857	14685	39	12E
0005435625873	14685	40	12F
0005435125648	14685	41	13A
0005435625862	14685	42	13C
0005435625865	14685	43	13D
0005435125657	14685	44	13E
0005435125660	14685	45	13F
0005435625868	14685	46	14A
0005435125650	14685	47	14C
0005435625858	14685	48	14D
0005435625866	14685	49	14E
0005435125687	14685	50	14F
0005435125658	14685	51	15C
0005435125667	14685	52	15D
0005435125661	14685	53	15E
0005435625877	14685	54	15F
0005435125683	14685	55	16A
0005435125679	14685	56	16C
0005435625867	14685	57	16E
0005435125676	14685	58	16F
0005435125674	14685	59	17C
0005435125686	14685	60	17D
0005435125669	14685	61	17F
0005435125677	14685	62	18A
0005435625863	14685	63	18E
0005435125652	14685	64	19D
0005435625869	14685	65	19E
0005435125671	14685	66	19F
0005435125684	14685	67	20A
0005435125682	14685	68	20D
0005435125668	14685	69	20F
0005432400059	7130	1	2F
0005435715162	7130	2	3F
0005435715170	7130	3	4A
0005432400056	7130	4	4C
0005432398131	7130	5	4D
0005432400060	7130	6	5F
0005432400057	7130	7	6C
0005435715169	7130	8	6D
0005435715174	7130	9	7A
0005435715161	7130	10	7D
0005435715173	7130	11	8A
0005432398129	7130	12	8C
0005435715175	7130	13	10C
0005435715171	7130	14	11C
0005435715163	7130	15	11F
0005435715168	7130	16	13A
0005435715165	7130	17	15E
0005435715172	7130	18	15F
0005435715176	7130	19	16A
0005435715167	7130	20	16E
0005432398130	7130	21	16F
0005432400058	7130	22	17D
0005435715166	7130	23	18D
0005435715164	7130	24	18F
0005435715160	7130	25	19C
0005435443144	27055	1	2D
0005435443151	27055	2	3A
0005435443148	27055	3	5F
0005435443149	27055	4	13D
0005435443145	27055	5	18D
0005435443150	27055	6	19A
0005435443147	27055	7	19C
0005435443146	27055	8	19D
0005435443152	27055	9	19E
0005434084849	2725	1	2A
0005434084848	2725	2	3B
0005434084851	2725	3	4A
0005434084850	2725	4	6A
0005434084852	2725	5	6B
0005433060366	28497	1	2B
0005433060367	28497	2	5B
0005434906370	2294	1	1C
0005434906375	2294	2	1F
0005434906367	2294	3	2F
0005434906395	2294	4	3D
0005434906366	2294	5	4C
0005434906397	2294	6	5E
0005434906402	2294	7	5F
0005434906372	2294	8	6A
0005434906359	2294	9	6C
0005434906365	2294	10	7A
0005434906361	2294	11	7C
0005434906391	2294	12	7D
0005434906374	2294	13	7E
0005434906387	2294	14	7F
0005434906380	2294	15	8A
0005434906362	2294	16	8C
0005434906379	2294	17	8D
0005434906392	2294	18	9C
0005434906400	2294	19	9D
0005434906364	2294	20	9F
0005434906386	2294	21	10D
0005434906376	2294	22	10F
0005434906378	2294	23	11D
0005434906393	2294	24	11E
0005434906373	2294	25	12D
0005434906371	2294	26	12F
0005434906396	2294	27	13E
0005434906382	2294	28	14A
0005434906406	2294	29	14C
0005434906377	2294	30	14E
0005434906388	2294	31	15A
0005434906405	2294	32	16A
0005434906401	2294	33	16C
0005434906369	2294	34	16D
0005434906404	2294	35	16E
0005434906363	2294	36	16F
0005434906398	2294	37	17C
0005434906385	2294	38	17D
0005434906399	2294	39	17E
0005434906390	2294	40	17F
0005434906383	2294	41	18A
0005434906394	2294	42	18D
0005434906360	2294	43	19A
0005434906381	2294	44	19D
0005434906384	2294	45	19F
0005434906368	2294	46	20D
0005434906403	2294	47	20E
0005434906389	2294	48	20F
0005433250950	25591	1	1A
0005433250955	25591	2	3A
0005433250929	25591	3	3D
0005433250945	25591	4	4A
0005433250938	25591	5	4C
0005433250940	25591	6	6A
0005433250931	25591	7	6D
0005433400929	25591	8	6F
0005433250928	25591	9	7A
0005433250949	25591	10	7E
0005433250935	25591	11	8A
0005433400930	25591	12	8E
0005433250944	25591	13	10E
0005433250933	25591	14	11A
0005433250934	25591	15	11C
0005433250954	25591	16	11D
0005433250937	25591	17	11F
0005433250943	25591	18	12A
0005433250957	25591	19	12C
0005433250947	25591	20	12E
0005433250941	25591	21	13C
0005433250930	25591	22	13E
0005433250948	25591	23	13F
0005433250956	25591	24	14A
0005433250932	25591	25	14C
0005433250936	25591	26	14D
0005433250942	25591	27	15A
0005433250951	25591	28	15D
0005433250927	25591	29	16A
0005433250952	25591	30	16D
0005433250946	25591	31	17E
0005433400931	25591	32	18E
0005433250958	25591	33	18F
0005433400932	25591	34	19E
0005433250939	25591	35	19F
0005433250953	25591	36	20E
0005432620788	2525	1	1A
0005432620793	2525	2	1C
0005432620792	2525	3	2B
0005432620796	2525	4	3B
0005432620790	2525	5	3D
0005432620799	2525	6	4B
0005432620789	2525	7	4C
0005432620795	2525	8	5D
0005432620794	2525	9	6B
0005432620798	2525	10	6C
0005432620787	2525	11	7D
0005432620786	2525	12	18D
0005432620797	2525	13	19C
0005432620791	2525	14	20A
0005432620800	2525	15	20C
0005432862166	28066	1	2A
0005432862167	28066	2	4C
0005432862165	28066	3	4D
0005432862169	28066	4	7A
0005432862168	28066	5	19B
0005432862162	28066	6	20D
0005432862163	28066	7	22C
0005432862164	28066	8	23B
0005434097449	13030	1	1B
0005433452703	31031	1	1A
0005433452702	31031	2	1B
0005433451583	31031	3	5A
0005433452701	31031	4	6A
0005433451582	31031	5	6B
0005433131627	29863	1	1B
0005433131626	29863	2	2C
0005434183543	29863	3	5A
0005434183545	29863	4	5D
0005433134059	29863	5	6D
0005434184630	29863	6	7B
0005433131628	29863	7	18B
0005433134056	29863	8	19B
0005434184629	29863	9	19D
0005433134057	29863	10	20A
0005433131629	29863	11	20B
0005434183544	29863	12	21B
0005434183546	29863	13	22C
0005433134058	29863	14	22D
0005435798915	1611	1	1A
0005435934992	24740	1	2A
0005435934993	24740	2	6C
0005435934994	24740	3	21D
0005435934995	24740	4	22A
0005432968802	21642	1	2A
0005432968801	21642	2	3B
0005432968803	21642	3	4A
0005434136717	7350	1	1A
0005434136743	7350	2	1C
0005434136697	7350	3	1D
0005434136694	7350	4	1F
0005434136685	7350	5	2A
0005434136752	7350	6	2C
0005434136755	7350	7	2D
0005434136701	7350	8	3A
0005434136733	7350	9	3C
0005434136702	7350	10	3D
0005434136732	7350	11	3F
0005434136704	7350	12	4A
0005434136678	7350	13	4C
0005434136683	7350	14	4F
0005434136734	7350	15	5A
0005434136742	7350	16	5C
0005434136713	7350	17	5D
0005434136750	7350	18	5E
0005434136758	7350	19	5F
0005434087429	7350	20	6A
0005434136709	7350	21	6C
0005434136710	7350	22	6E
0005434136721	7350	23	6F
0005434136692	7350	24	7A
0005434136757	7350	25	7C
0005434136698	7350	26	7D
0005434136716	7350	27	7E
0005434136675	7350	28	7F
0005434136748	7350	29	8A
0005434136753	7350	30	8C
0005434136691	7350	31	8E
0005434136686	7350	32	8F
0005434136723	7350	33	9A
0005434136722	7350	34	9C
0005434136736	7350	35	9D
0005434136741	7350	36	9E
0005434087428	7350	37	9F
0005434136726	7350	38	10A
0005434136688	7350	39	10C
0005434136676	7350	40	10D
0005434136693	7350	41	10F
0005434136700	7350	42	11A
0005434136744	7350	43	11C
0005434136679	7350	44	11D
0005434136759	7350	45	11E
0005434136687	7350	46	11F
0005434136728	7350	47	12A
0005434136705	7350	48	12C
0005434136756	7350	49	12D
0005434136695	7350	50	12E
0005434136719	7350	51	12F
0005434136681	7350	52	13A
0005434136684	7350	53	13C
0005434087427	7350	54	13D
0005434136751	7350	55	13E
0005434136746	7350	56	13F
0005434136731	7350	57	14A
0005434136738	7350	58	14C
0005434136745	7350	59	14D
0005434136718	7350	60	14E
0005434136714	7350	61	14F
0005434136740	7350	62	15A
0005434136725	7350	63	15C
0005434136707	7350	64	15D
0005434136737	7350	65	15E
0005434136720	7350	66	15F
0005434136708	7350	67	16A
0005434136727	7350	68	16C
0005434136729	7350	69	16D
0005434136703	7350	70	16F
0005434136730	7350	71	17A
0005434087430	7350	72	17C
0005434136690	7350	73	17D
0005434136711	7350	74	17E
0005434136682	7350	75	17F
0005434136689	7350	76	18A
0005434136739	7350	77	18C
0005434136706	7350	78	18D
0005434136680	7350	79	18E
0005434136712	7350	80	19A
0005434136677	7350	81	19C
0005434136754	7350	82	19D
0005434136696	7350	83	19E
0005434136749	7350	84	19F
0005434136699	7350	85	20A
0005434136747	7350	86	20C
0005434136735	7350	87	20D
0005434136715	7350	88	20E
0005434136724	7350	89	20F
0005435808052	1943	1	2B
0005435808054	1943	2	4B
0005435808055	1943	3	4C
0005435808058	1943	4	6B
0005434610167	1943	5	7A
0005435808049	1943	6	7B
0005435808051	1943	7	7C
0005434610166	1943	8	18C
0005435808050	1943	9	18D
0005435808059	1943	10	20B
0005435808057	1943	11	20C
0005435808053	1943	12	21A
0005435808056	1943	13	22B
0005434608276	6496	1	3D
0005434608277	6496	2	20A
0005435078071	2231	1	1C
0005435078075	2231	2	3A
0005435078079	2231	3	4A
0005435078069	2231	4	4B
0005435078070	2231	5	4C
0005435078063	2231	6	5C
0005435078072	2231	7	6A
0005435078068	2231	8	6B
0005435078064	2231	9	7C
0005435078065	2231	10	7D
0005435078076	2231	11	20B
0005435078078	2231	12	20C
0005435078077	2231	13	21A
0005435078067	2231	14	21B
0005435078074	2231	15	22B
0005435078073	2231	16	22C
0005435078066	2231	17	22D
0005433266564	24372	1	1A
0005433266562	24372	2	1B
0005433266563	24372	3	3D
0005433266565	24372	4	4C
0005433266559	24372	5	4D
0005433266561	24372	6	5A
0005433266560	24372	7	18D
0005433266557	24372	8	20A
0005433266558	24372	9	22C
0005433266566	24372	10	22D
0005433266556	24372	11	23A
0005434988556	6650	1	1C
0005435803211	6650	2	1D
0005435803210	6650	3	2A
0005434988555	6650	4	3D
0005434988559	6650	5	4A
0005434988563	6650	6	4C
0005434988561	6650	7	5B
0005434988558	6650	8	5C
0005434988557	6650	9	7D
0005435803212	6650	10	20B
0005434988564	6650	11	21A
0005434988562	6650	12	21B
0005435803213	6650	13	21D
0005434988560	6650	14	22A
0005435464473	23602	1	6B
0005435464472	23602	2	18D
0005432382491	30471	1	1C
0005433449593	30471	2	1D
0005432382518	30471	3	1F
0005433449595	30471	4	2A
0005433449599	30471	5	2C
0005433449600	30471	6	2D
0005432382487	30471	7	3A
0005432382485	30471	8	3C
0005432382519	30471	9	3F
0005432382495	30471	10	4D
0005433454838	30471	11	4E
0005433449586	30471	12	4F
0005432382505	30471	13	5A
0005432382493	30471	14	5D
0005433449589	30471	15	5E
0005433454837	30471	16	5F
0005432382501	30471	17	6A
0005433449588	30471	18	6C
0005432382499	30471	19	6D
0005432382514	30471	20	6F
0005432382510	30471	21	7A
0005432382484	30471	22	7C
0005433449596	30471	23	7E
0005433449594	30471	24	8A
0005432382490	30471	25	8C
0005432382492	30471	26	8D
0005433449590	30471	27	8E
0005432382496	30471	28	9A
0005432382506	30471	29	9C
0005433449605	30471	30	9E
0005433449584	30471	31	10C
0005432382515	30471	32	10D
0005433449592	30471	33	10E
0005433449604	30471	34	10F
0005432382500	30471	35	11A
0005433449603	30471	36	11C
0005433449591	30471	37	11F
0005432382520	30471	38	12A
0005432382498	30471	39	12C
0005433449583	30471	40	12D
0005432382504	30471	41	12E
0005432382508	30471	42	12F
0005432382513	30471	43	13A
0005432382489	30471	44	13D
0005433449587	30471	45	14A
0005433453727	30471	46	14C
0005433449597	30471	47	14D
0005432382488	30471	48	14E
0005432382486	30471	49	14F
0005432382517	30471	50	15A
0005433449602	30471	51	15C
0005432382516	30471	52	15E
0005432382497	30471	53	15F
0005432382502	30471	54	16A
0005433449598	30471	55	16E
0005432382511	30471	56	16F
0005432382509	30471	57	17C
0005432382507	30471	58	17F
0005432382503	30471	59	18C
0005432382494	30471	60	18E
0005433449585	30471	61	19E
0005433453726	30471	62	20A
0005433449601	30471	63	20C
0005432382512	30471	64	20F
0005435299698	29743	1	1A
0005435302120	29743	2	1B
0005433126769	29743	3	1D
0005435302119	29743	4	4A
0005433129199	29743	5	4C
0005435299697	29743	6	5A
0005433126768	29743	7	5B
0005435299696	29743	8	6B
0005433126771	29743	9	7B
0005435299699	29743	10	7C
0005435302123	29743	11	18C
0005433129198	29743	12	18D
0005433129201	29743	13	19C
0005433129200	29743	14	20A
0005435302122	29743	15	20D
0005433126770	29743	16	22A
0005435302121	29743	17	22D
0005434286911	2412	1	1B
0005434286899	2412	2	1D
0005434286894	2412	3	2C
0005434286895	2412	4	2D
0005434286905	2412	5	3A
0005434286912	2412	6	3D
0005434286900	2412	7	4C
0005434286914	2412	8	4D
0005434286892	2412	9	5A
0005434286893	2412	10	5C
0005434286909	2412	11	6B
0005432264431	2412	12	6C
0005432264432	2412	13	7B
0005434286910	2412	14	7A
0005434286901	2412	15	7C
0005434286896	2412	16	18A
0005434286903	2412	17	18D
0005432264433	2412	18	19B
0005434286898	2412	19	19C
0005434286897	2412	20	20A
0005434286906	2412	21	20B
0005434286902	2412	22	20D
0005434286913	2412	23	21C
0005434286904	2412	24	22B
0005434286907	2412	25	23A
0005434286908	2412	26	23B
0005433109843	26879	1	3A
0005433109846	26879	2	3B
0005433109845	26879	3	4C
0005433109847	26879	4	6A
0005433109837	26879	5	18B
0005433109848	26879	6	19A
0005433109841	26879	7	19C
0005433109844	26879	8	21B
0005433109842	26879	9	21C
0005433109840	26879	10	21D
0005433109839	26879	11	23A
0005433109838	26879	12	23B
0005435856133	25496	1	2A
0005435856130	25496	2	7A
0005435856131	25496	3	20C
0005435856132	25496	4	20D
0005434273046	26658	1	2B
0005434272161	26658	2	3A
0005434273047	26658	3	18D
0005434272162	26658	4	22C
0005435314767	19070	1	3B
0005435314769	19070	2	3D
0005435314770	19070	3	4B
0005435314768	19070	4	22C
0005435314771	19070	5	23B
0005433874293	7786	1	19A
0005433874292	7786	2	20B
0005433874291	7786	3	21C
0005433867752	4809	1	1A
0005433867734	4809	2	1B
0005433867757	4809	3	1C
0005433867751	4809	4	1D
0005433867740	4809	5	2A
0005433867755	4809	6	2B
0005433867732	4809	7	2C
0005433867731	4809	8	3A
0005433867739	4809	9	3B
0005433867762	4809	10	3C
0005433867754	4809	11	3D
0005433867748	4809	12	4A
0005433867749	4809	13	4B
0005433867766	4809	14	4C
0005433867728	4809	15	4D
0005433867746	4809	16	5A
0005433867733	4809	17	5B
0005433867730	4809	18	5C
0005433867735	4809	19	6A
0005433867753	4809	20	6C
0005433867767	4809	21	6D
0005433867741	4809	22	7A
0005433867737	4809	23	7C
0005433867729	4809	24	7D
0005433867761	4809	25	18A
0005433867747	4809	26	18B
0005433867756	4809	27	18C
0005433867763	4809	28	18D
0005433867768	4809	29	19A
0005433867727	4809	30	19C
0005433867760	4809	31	19D
0005433867736	4809	32	20A
0005433867742	4809	33	20B
0005433867743	4809	34	20C
0005433867745	4809	35	20D
0005433867764	4809	36	21A
0005433867750	4809	37	21B
0005433867738	4809	38	21D
0005433867769	4809	39	22A
0005433867765	4809	40	22B
0005433867758	4809	41	22C
0005433867744	4809	42	22D
0005433867759	4809	43	23A
0005434663174	3415	1	1B
0005434663168	3415	2	2B
0005434461608	3415	3	3A
0005434663172	3415	4	4B
0005434460466	3415	5	4C
0005434663169	3415	6	4D
0005434663166	3415	7	5C
0005434663176	3415	8	6B
0005434461609	3415	9	6D
0005434663165	3415	10	7A
0005434663173	3415	11	18C
0005434461610	3415	12	18D
0005434460467	3415	13	19B
0005434663175	3415	14	19C
0005434663178	3415	15	19D
0005434663167	3415	16	20B
0005434663171	3415	17	20C
0005434663170	3415	18	22A
0005434663177	3415	19	22C
0005434460468	3415	20	23A
0005435911321	12445	1	2B
0005435911315	12445	2	5D
0005435911316	12445	3	18D
0005435911322	12445	4	19C
0005435911319	12445	5	20A
0005435911317	12445	6	21B
0005435911320	12445	7	22B
0005435911318	12445	8	23A
0005432153818	7072	1	1A
0005434406677	7072	2	1D
0005434299162	7072	3	2A
0005434406659	7072	4	2D
0005434299151	7072	5	2C
0005434406691	7072	6	2F
0005434406673	7072	7	3C
0005434406658	7072	8	3D
0005434299154	7072	9	4A
0005434406676	7072	10	4B
0005434299152	7072	11	4C
0005434406696	7072	12	4E
0005434406681	7072	13	4F
0005434406657	7072	14	5C
0005434299160	7072	15	5F
0005434406660	7072	16	5E
0005434406678	7072	17	6B
0005434406668	7072	18	6A
0005434299147	7072	19	6D
0005432153815	7072	20	6C
0005434406669	7072	21	7A
0005434299150	7072	22	6F
0005434406701	7072	23	7B
0005434406682	7072	24	7C
0005434406644	7072	25	7D
0005432153819	7072	26	8A
0005432153817	7072	27	7F
0005434406646	7072	28	8B
0005434406684	7072	29	8D
0005434299155	7072	30	8C
0005434406698	7072	31	8F
0005434406653	7072	32	8E
0005432153814	7072	33	9D
0005434406656	7072	34	9F
0005434406665	7072	35	10B
0005434406639	7072	36	10D
0005434406687	7072	37	11B
0005434406672	7072	38	11D
0005434406670	7072	39	11C
0005434406690	7072	40	11E
0005434406699	7072	41	11F
0005434406645	7072	42	12A
0005434406695	7072	43	12B
0005434406664	7072	44	12D
0005434406685	7072	45	12C
0005434406640	7072	46	12F
0005434406679	7072	47	13B
0005434299158	7072	48	13C
0005434406680	7072	49	13D
0005434406649	7072	50	13E
0005434299163	7072	51	13F
0005434406697	7072	52	14A
0005434406655	7072	53	14C
0005432153813	7072	54	14B
0005434299166	7072	55	14D
0005432153816	7072	56	14E
0005434406675	7072	57	14F
0005434406650	7072	58	15C
0005434299168	7072	59	15D
0005434406663	7072	60	15E
0005434406700	7072	61	16A
0005434406642	7072	62	16B
0005434406661	7072	63	16C
0005434299164	7072	64	16D
0005432108205	7072	65	16F
0005434406688	7072	66	17A
0005434406643	7072	67	17B
0005434299165	7072	68	17C
0005434406667	7072	69	17F
0005434299167	7072	70	17E
0005434406652	7072	71	18A
0005434406654	7072	72	18B
0005434299161	7072	73	18D
0005432108206	7072	74	18E
0005434299159	7072	75	18F
0005434406647	7072	76	19A
0005434406648	7072	77	19B
0005434299169	7072	78	19C
0005434406666	7072	79	19E
0005434299157	7072	80	19F
0005432108204	7072	81	20A
0005434299156	7072	82	20C
0005434406686	7072	83	20B
0005434406692	7072	84	20E
0005434406671	7072	85	20F
0005434299149	7072	86	21C
0005434406689	7072	87	21B
0005434406651	7072	88	21E
0005434406641	7072	89	22A
0005434406693	7072	90	21F
0005434299148	7072	91	22B
0005434299153	7072	92	22C
0005434406674	7072	93	22F
0005434406683	7072	94	23B
0005434406694	7072	95	23F
0005434406662	7072	96	23E
0005435293048	26885	1	1F
0005435293050	26885	2	3C
0005435293054	26885	3	5A
0005435293049	26885	4	5E
0005435293055	26885	5	6E
0005435293051	26885	6	9C
0005435293053	26885	7	16F
0005435293046	26885	8	18E
0005435293052	26885	9	18F
0005435293047	26885	10	19C
0005435293056	26885	11	20E
0005435293045	26885	12	23F
0005432603662	6446	1	1A
0005432603673	6446	2	1B
0005432603668	6446	3	1C
0005432603657	6446	4	1D
0005432603681	6446	5	2A
0005432603672	6446	6	2B
0005432603674	6446	7	2C
0005432603669	6446	8	2D
0005432603642	6446	9	3A
0005432603648	6446	10	3B
0005432603679	6446	11	3C
0005432603647	6446	12	4A
0005434512019	6446	13	4B
0005434512017	6446	14	4C
0005432603654	6446	15	4D
0005432603664	6446	16	5A
0005432603680	6446	17	5B
0005432603677	6446	18	5C
0005432603656	6446	19	5D
0005432603675	6446	20	6A
0005432603660	6446	21	6B
0005432603651	6446	22	6C
0005432603667	6446	23	6D
0005432603665	6446	24	7A
0005432603661	6446	25	7B
0005434512016	6446	26	7C
0005432603646	6446	27	7D
0005432603666	6446	28	18A
0005434512021	6446	29	18B
0005434512015	6446	30	18C
0005434512018	6446	31	19A
0005432603643	6446	32	19B
0005434512020	6446	33	19C
0005432603655	6446	34	20A
0005432603670	6446	35	20B
0005432603678	6446	36	20C
0005432603658	6446	37	20D
0005432603645	6446	38	21A
0005432603671	6446	39	21C
0005432603644	6446	40	21B
0005432603650	6446	41	21D
0005432603663	6446	42	22B
0005432603676	6446	43	22A
0005432603653	6446	44	22C
0005432603649	6446	45	22D
0005432603652	6446	46	23A
0005432603659	6446	47	23B
0005435221035	21383	1	7B
0005435221497	21383	2	19D
0005435221036	21383	3	20D
0005433250932	15025	1	1A
0005433250946	15025	2	1C
0005433250928	15025	3	2C
0005433250937	15025	4	2D
0005433250938	15025	5	2F
0005433250956	15025	6	3A
0005433250949	15025	7	4E
0005433250954	15025	8	5C
0005433250934	15025	9	6D
0005433250947	15025	10	7C
0005433250931	15025	11	7E
0005433250943	15025	12	8C
0005433250942	15025	13	8F
0005433250948	15025	14	9A
0005433250957	15025	15	9E
0005433250929	15025	16	10C
0005433250935	15025	17	10F
0005433250944	15025	18	11C
0005433250952	15025	19	12C
0005433250951	15025	20	12D
0005433250950	15025	21	13A
0005433250933	15025	22	13E
0005433250945	15025	23	13F
0005433250955	15025	24	14C
0005433250927	15025	25	16C
0005433250940	15025	26	16F
0005433250936	15025	27	17F
0005433250941	15025	28	18C
0005433250958	15025	29	18D
0005433250939	15025	30	20C
0005433250953	15025	31	20D
0005433250930	15025	32	20F
0005433007840	14158	1	1C
0005433007824	14158	2	1D
0005433007835	14158	3	2A
0005433007825	14158	4	2C
0005433007860	14158	5	2D
0005433007845	14158	6	2F
0005433007864	14158	7	3D
0005433007832	14158	8	4A
0005433007855	14158	9	4C
0005433007829	14158	10	4D
0005433007827	14158	11	4E
0005433007830	14158	12	5E
0005433007863	14158	13	6A
0005433007848	14158	14	6E
0005433007822	14158	15	7D
0005433007843	14158	16	7F
0005433007851	14158	17	8A
0005433007847	14158	18	8C
0005433007852	14158	19	8E
0005433007867	14158	20	9A
0005433007865	14158	21	9C
0005433007841	14158	22	9E
0005433007859	14158	23	10D
0005433007842	14158	24	11D
0005433007853	14158	25	12A
0005433007833	14158	26	12C
0005433007861	14158	27	13A
0005433007850	14158	28	13D
0005433007826	14158	29	14A
0005433007831	14158	30	14D
0005433007838	14158	31	14E
0005433007862	14158	32	15A
0005433007837	14158	33	15C
0005433007839	14158	34	15D
0005433007858	14158	35	16A
0005433007857	14158	36	17E
0005433007836	14158	37	18A
0005433007828	14158	38	18C
0005433007856	14158	39	18F
0005433007854	14158	40	19A
0005433007849	14158	41	19C
0005433007866	14158	42	20A
0005433007844	14158	43	20C
0005433007823	14158	44	20E
0005433007834	14158	45	20D
0005433007846	14158	46	20F
0005435487465	15791	1	1B
0005435487470	15791	2	1C
0005435487462	15791	3	2B
0005435487458	15791	4	2D
0005435487454	15791	5	3A
0005435487471	15791	6	3B
0005435487461	15791	7	4D
0005435487468	15791	8	5B
0005435487464	15791	9	6A
0005435487456	15791	10	7A
0005435487469	15791	11	7B
0005435487459	15791	12	18C
0005435487460	15791	13	19C
0005435487463	15791	14	19D
0005435487453	15791	15	20B
0005435487467	15791	16	20C
0005435487457	15791	17	20D
0005435487455	15791	18	21A
0005435487473	15791	19	21D
0005435487472	15791	20	22A
0005435487466	15791	21	22C
0005435487474	15791	22	23A
0005435838963	5995	1	2A
0005435838980	5995	2	4A
0005435838962	5995	3	4C
0005432659671	5995	4	4F
0005435838958	5995	5	5F
0005432142198	5995	6	5D
0005432142199	5995	7	6B
0005432658556	5995	8	6C
0005435838969	5995	9	7C
0005432142201	5995	10	8B
0005435838978	5995	11	8D
0005435838973	5995	12	9B
0005432142197	5995	13	9E
0005435838964	5995	14	9F
0005435838975	5995	15	10E
0005432659672	5995	16	11D
0005435838961	5995	17	12E
0005435838984	5995	18	13C
0005435838979	5995	19	13D
0005435838960	5995	20	14B
0005435838971	5995	21	14D
0005435838966	5995	22	14F
0005435838983	5995	23	15C
0005435838985	5995	24	15D
0005435838982	5995	25	15F
0005435838972	5995	26	16E
0005435838965	5995	27	17D
0005435838959	5995	28	17F
0005435838981	5995	29	17E
0005432142200	5995	30	18F
0005435838970	5995	31	19B
0005435838974	5995	32	19E
0005435838968	5995	33	19C
0005435838976	5995	34	19F
0005435838977	5995	35	20C
0005432658555	5995	36	20D
0005432658557	5995	37	20E
0005435838967	5995	38	21B
0005435472521	18069	1	2C
0005435472516	18069	2	1F
0005435472513	18069	3	3F
0005432537022	18069	4	4C
0005435472525	18069	5	6F
0005435472512	18069	6	7D
0005435472515	18069	7	8B
0005435472523	18069	8	10F
0005435472511	18069	9	11A
0005435472522	18069	10	11D
0005435472526	18069	11	12A
0005435472519	18069	12	12E
0005435472524	18069	13	13C
0005435472520	18069	14	13B
0005435472517	18069	15	13F
0005435472528	18069	16	15C
0005435472527	18069	17	15B
0005435472518	18069	18	18A
0005435472514	18069	19	19E
0005433463862	17263	1	4B
0005433462709	17263	2	19F
0005433462708	17263	3	22G
0005433463863	17263	4	30G
0005433463861	17263	5	33B
0005433284791	32042	1	1D
0005433284772	32042	2	1F
0005433284792	32042	3	3D
0005433284777	32042	4	4A
0005433284774	32042	5	4B
0005433284783	32042	6	4F
0005433284778	32042	7	5E
0005433284794	32042	8	5F
0005433284787	32042	9	6B
0005433284770	32042	10	6F
0005433284776	32042	11	7E
0005433284785	32042	12	7D
0005433284782	32042	13	8A
0005433284773	32042	14	7F
0005433284788	32042	15	12F
0005433284779	32042	16	13E
0005433284771	32042	17	14F
0005433284784	32042	18	15A
0005433284790	32042	19	16A
0005433284786	32042	20	16D
0005433284769	32042	21	17B
0005433284793	32042	22	18D
0005433284789	32042	23	18E
0005433284781	32042	24	19C
0005433284780	32042	25	21B
0005433284775	32042	26	23E
0005433656615	30589	1	1D
0005432159779	30589	2	2A
0005435212416	30589	3	2G
0005432211378	30589	4	2K
0005435212420	30589	5	3C
0005432159781	30589	6	4C
0005435212426	30589	7	4A
0005435630917	30589	8	4G
0005435212438	30589	9	5C
0005435212405	30589	10	5A
0005435212452	30589	11	5G
0005435212400	30589	12	12G
0005435212422	30589	13	13D
0005435212454	30589	14	14G
0005435212419	30589	15	14F
0005435212459	30589	16	15D
0005435212403	30589	17	15G
0005435212404	30589	18	16D
0005435212429	30589	19	16E
0005435212428	30589	20	17C
0005432211379	30589	21	16K
0005435212445	30589	22	18B
0005432211377	30589	23	18E
0005435212406	30589	24	19B
0005435212451	30589	25	19D
0005435212464	30589	26	19C
0005435212447	30589	27	19F
0005435212424	30589	28	19G
0005435212441	30589	29	19K
0005432211375	30589	30	20B
0005435212463	30589	31	21D
0005432211376	30589	32	21B
0005435212461	30589	33	21F
0005435212397	30589	34	21J
0005435212433	30589	35	21K
0005435212413	30589	36	22J
0005433656616	30589	37	23B
0005435212423	30589	38	23E
0005435212409	30589	39	23H
0005435725520	30589	40	24G
0005435212458	30589	41	25B
0005435630918	30589	42	25E
0005435212443	30589	43	25D
0005435212462	30589	44	25J
0005433656617	30589	45	26D
0005432159780	30589	46	26F
0005432211373	30589	47	27C
0005435212457	30589	48	27G
0005432211374	30589	49	27K
0005435212418	30589	50	28C
0005435212448	30589	51	28B
0005435212407	30589	52	29C
0005435212430	30589	53	29F
0005435212434	30589	54	30B
0005435212450	30589	55	30H
0005435212408	30589	56	31B
0005435212437	30589	57	31A
0005435725517	30589	58	31F
0005435212444	30589	59	32A
0005435212411	30589	60	32C
0005435212466	30589	61	32D
0005435212432	30589	62	32G
0005435212412	30589	63	33H
0005435212427	30589	64	34E
0005435212440	30589	65	35H
0005435212442	30589	66	35K
0005435212446	30589	67	36D
0005435212439	30589	68	36K
0005435212410	30589	69	37C
0005435212401	30589	70	37G
0005435212431	30589	71	37F
0005432159783	30589	72	39C
0005435212421	30589	73	39H
0005432159782	30589	74	40A
0005435212460	30589	75	40D
0005435212455	30589	76	41C
0005435725519	30589	77	43B
0005435212415	30589	78	43A
0005435212398	30589	79	43D
0005435212436	30589	80	45A
0005435725518	30589	81	45J
0005435212414	30589	82	46G
0005435212425	30589	83	47A
0005435212399	30589	84	46K
0005435212435	30589	85	47E
0005435212402	30589	86	47D
0005432211380	30589	87	47G
0005435212453	30589	88	47H
0005435212456	30589	89	48G
0005435212417	30589	90	48K
0005435212465	30589	91	50G
0005435212449	30589	92	51E
0005433367281	24833	1	1A
0005433367289	24833	2	2A
0005433367277	24833	3	2F
0005433367275	24833	4	3A
0005433367271	24833	5	3C
0005433367278	24833	6	4E
0005433367288	24833	7	4F
0005433367284	24833	8	5D
0005433367272	24833	9	5E
0005433367268	24833	10	6C
0005433367290	24833	11	6D
0005433367292	24833	12	6E
0005433367293	24833	13	7D
0005433367270	24833	14	7F
0005433367266	24833	15	8C
0005433367273	24833	16	8E
0005433367285	24833	17	9A
0005433367261	24833	18	9C
0005433367263	24833	19	10D
0005433367291	24833	20	12C
0005433367267	24833	21	13C
0005433367264	24833	22	13D
0005433367262	24833	23	13E
0005433367274	24833	24	14A
0005433367294	24833	25	14E
0005433367279	24833	26	15A
0005433367260	24833	27	15F
0005433367286	24833	28	16C
0005433367280	24833	29	16D
0005433367287	24833	30	16E
0005433367265	24833	31	18D
0005433367282	24833	32	18F
0005433367276	24833	33	19C
0005433367269	24833	34	19D
0005433367283	24833	35	20C
0005433367259	24833	36	20E
0005434979294	2032	1	1B
0005434979286	2032	2	1D
0005434979288	2032	3	2A
0005434979313	2032	4	2B
0005434979299	2032	5	2C
0005434979312	2032	6	2D
0005434979308	2032	7	3A
0005434979309	2032	8	3B
0005435801647	2032	9	3C
0005434979300	2032	10	3D
0005434979296	2032	11	4C
0005434979284	2032	12	5A
0005434979306	2032	13	5C
0005434979287	2032	14	5D
0005435801645	2032	15	6A
0005434979297	2032	16	6B
0005434979301	2032	17	6D
0005434979289	2032	18	7B
0005434979290	2032	19	7C
0005434979292	2032	20	18A
0005434979303	2032	21	18C
0005434979295	2032	22	18D
0005434979283	2032	23	19A
0005434979310	2032	24	19C
0005434979298	2032	25	19D
0005434979305	2032	26	20A
0005434979293	2032	27	20B
0005434979285	2032	28	20C
0005434979302	2032	29	20D
0005434979291	2032	30	21B
0005434979311	2032	31	21C
0005434979304	2032	32	22B
0005434979307	2032	33	22D
0005435801646	2032	34	23B
0005434952468	2569	1	1B
0005434952470	2569	2	3B
0005434952469	2569	3	6B
0005433256384	28267	1	1B
0005433256385	28267	2	3A
0005433256383	28267	3	4B
0005433111470	19841	1	3A
0005433111471	19841	2	5B
0005434136687	28737	1	1A
0005434136723	28737	2	1C
0005434136742	28737	3	1D
0005434136727	28737	4	1F
0005434136751	28737	5	2A
0005434136721	28737	6	2C
0005434136733	28737	7	2D
0005434136696	28737	8	2F
0005434136729	28737	9	3A
0005434136736	28737	10	3C
0005434136722	28737	11	3D
0005434136699	28737	12	3F
0005434136689	28737	13	4A
0005434136693	28737	14	4C
0005434136678	28737	15	4E
0005434136704	28737	16	5A
0005434136745	28737	17	4F
0005434136757	28737	18	5C
0005434136717	28737	19	5E
0005434136713	28737	20	5D
0005434136739	28737	21	6A
0005434136706	28737	22	6C
0005434136724	28737	23	6D
0005434136691	28737	24	6E
0005434136683	28737	25	6F
0005434136680	28737	26	7C
0005434136754	28737	27	7D
0005434136701	28737	28	7E
0005434136707	28737	29	7F
0005434136716	28737	30	8C
0005434136730	28737	31	8D
0005434136702	28737	32	8F
0005434136677	28737	33	9A
0005434136731	28737	34	9C
0005434136746	28737	35	9D
0005434136737	28737	36	9E
0005434136676	28737	37	10A
0005434136688	28737	38	10C
0005434136714	28737	39	10D
0005434136741	28737	40	10E
0005434136734	28737	41	10F
0005434136720	28737	42	11A
0005434136675	28737	43	11C
0005434136740	28737	44	11D
0005434136719	28737	45	11E
0005434136705	28737	46	11F
0005434136708	28737	47	12A
0005434136752	28737	48	12C
0005434136692	28737	49	12D
0005434136759	28737	50	12E
0005434136728	28737	51	12F
0005434136756	28737	52	13A
0005434136700	28737	53	13C
0005434136718	28737	54	13D
0005434136712	28737	55	13F
0005434136725	28737	56	14C
0005434136679	28737	57	14D
0005434136735	28737	58	14E
0005434136681	28737	59	14F
0005434136747	28737	60	15A
0005434136694	28737	61	15C
0005434136686	28737	62	15D
0005434136744	28737	63	15E
0005434136748	28737	64	15F
0005434136750	28737	65	16A
0005434136743	28737	66	16C
0005434136715	28737	67	16D
0005434136684	28737	68	16E
0005434136732	28737	69	16F
0005434136758	28737	70	17A
0005434136703	28737	71	17C
0005434136697	28737	72	17D
0005434136709	28737	73	17E
0005434136698	28737	74	17F
0005434136755	28737	75	18A
0005434136749	28737	76	18C
0005434136726	28737	77	18D
0005434136711	28737	78	18E
0005434136682	28737	79	18F
0005434136695	28737	80	19C
0005434136753	28737	81	19F
0005434136738	28737	82	20A
0005434136690	28737	83	20C
0005434136710	28737	84	20D
0005434136685	28737	85	20F
0005433538729	6814	1	3B
0005433538730	6814	2	3D
0005433538733	6814	3	5B
0005433538726	6814	4	6A
0005433538732	6814	5	7B
0005433538725	6814	6	19C
0005433538728	6814	7	20A
0005433538731	6814	8	21A
0005433538727	6814	9	21D
0005435259685	25016	1	1C
0005435259683	25016	2	1D
0005435259682	25016	3	7D
0005435259684	25016	4	19D
0005435259686	25016	5	20C
0005435259687	25016	6	21D
0005433511815	806	1	2C
0005433511813	806	2	2D
0005433511810	806	3	4C
0005433511812	806	4	5D
0005433511811	806	5	6B
0005433511814	806	6	18B
0005433511816	806	7	19A
0005433511817	806	8	22A
0005432922456	16133	1	5C
0005432922459	16133	2	19C
0005432922458	16133	3	20D
0005432922457	16133	4	22B
0005434950458	3667	1	1A
0005434950455	3667	2	1B
0005435696899	3667	3	1C
0005435696880	3667	4	1D
0005435696887	3667	5	2A
0005435696900	3667	6	2C
0005434950453	3667	7	2D
0005435696879	3667	8	3A
0005435696878	3667	9	3B
0005435696876	3667	10	3D
0005435696893	3667	11	3C
0005434950454	3667	12	5B
0005435696883	3667	13	5C
0005434950456	3667	14	5D
0005435696872	3667	15	6C
0005435696895	3667	16	7B
0005435696884	3667	17	7C
0005434950457	3667	18	7D
0005435696888	3667	19	18A
0005435696890	3667	20	18D
0005435696898	3667	21	19B
0005435696889	3667	22	19D
0005435696886	3667	23	19C
0005435696892	3667	24	20A
0005435696891	3667	25	20B
0005435696896	3667	26	20C
0005435696894	3667	27	21A
0005435696897	3667	28	21B
0005435696874	3667	29	21C
0005435696885	3667	30	21D
0005435696873	3667	31	22A
0005435696877	3667	32	22C
0005435696882	3667	33	22D
0005435696881	3667	34	23A
0005435696875	3667	35	23B
0005435916121	16305	1	1B
0005435916120	16305	2	6C
0005435934992	16305	3	18C
0005435934995	16305	4	18D
0005435934993	16305	5	19A
0005435934994	16305	6	19D
0005435916122	16305	7	21B
0005433519381	3957	1	1A
0005432609666	3957	2	1D
0005434604843	3957	3	2A
0005434606767	3957	4	2C
0005433519383	3957	5	3D
0005434604842	3957	6	4A
0005433519384	3957	7	4D
0005432607498	3957	8	5A
0005434606765	3957	9	5B
0005432609662	3957	10	5C
0005432607499	3957	11	6D
0005433519382	3957	12	7A
0005434606766	3957	13	7D
0005434604841	3957	14	18B
0005433519385	3957	15	19B
0005432607500	3957	16	20A
0005434604844	3957	17	20C
0005434604840	3957	18	20D
0005432609665	3957	19	21B
0005434606764	3957	20	21C
0005432607497	3957	21	22C
0005432607501	3957	22	22D
0005432609663	3957	23	23A
0005432609664	3957	24	23B
0005433348892	15973	1	1A
0005433348896	15973	2	1B
0005433348893	15973	3	2A
0005433348895	15973	4	2B
0005433348894	15973	5	5B
0005433348897	15973	6	6A
0005434445208	17189	1	1B
0005434445209	17189	2	3B
0005434445207	17189	3	4B
0005434445210	17189	4	5A
0005434446476	17189	5	6A
0005433159277	17585	1	4B
0005433159278	17585	2	5B
0005435132711	7908	1	2B
0005435132709	7908	2	2D
0005435132712	7908	3	3A
0005435132710	7908	4	5D
0005435132707	7908	5	6A
0005435132708	7908	6	7B
0005435132706	7908	7	19D
0005435132714	7908	8	20D
0005435132705	7908	9	21D
0005435132713	7908	10	22A
0005435383066	33114	1	3C
0005435383060	33114	2	4A
0005435383065	33114	3	7B
0005435383061	33114	4	18D
0005435383062	33114	5	19B
0005435383063	33114	6	22A
0005435383064	33114	7	23A
0005435810985	4405	1	6E
0005435810993	4405	2	7F
0005435810988	4405	3	8A
0005435810995	4405	4	8F
0005435810989	4405	5	9F
0005435810992	4405	6	14C
0005435810991	4405	7	15D
0005435810994	4405	8	15B
0005435810987	4405	9	15F
0005435810990	4405	10	16B
0005435810986	4405	11	20C
0005435938844	29457	1	6A
0005435938845	29457	2	8F
0005435938843	29457	3	12B
0005435160125	7507	1	2A
0005435160123	7507	2	2C
0005435160124	7507	3	6A
0005435160114	7507	4	6C
0005435160116	7507	5	7B
0005435160119	7507	6	7C
0005435160121	7507	7	18A
0005435160118	7507	8	18B
0005435160117	7507	9	18D
0005435160115	7507	10	20B
0005435160120	7507	11	21C
0005435160122	7507	12	22A
0005435390125	29541	1	2A
0005435390124	29541	2	3A
0005435390126	29541	3	7A
0005435390129	29541	4	18A
0005435390127	29541	5	18B
0005435390128	29541	6	20B
0005435390123	29541	7	22B
0005435390130	29541	8	22C
0005435178469	18462	1	2B
0005435178977	18462	2	3B
0005435178470	18462	3	5A
0005432400060	27182	1	1A
0005432400058	27182	2	2A
0005432400059	27182	3	3A
0005432400056	27182	4	4A
0005432398129	27182	5	4B
0005432398131	27182	6	5A
0005432398130	27182	7	5B
0005432400057	27182	8	6B
0005435103816	6565	1	1F
0005434503534	6565	2	2C
0005434503498	6565	3	2D
0005434503502	6565	4	2F
0005434503513	6565	5	3A
0005435103809	6565	6	3C
0005434503507	6565	7	3D
0005434503520	6565	8	3F
0005435103804	6565	9	4A
0005435103814	6565	10	4C
0005435103810	6565	11	4E
0005434503497	6565	12	4F
0005434503526	6565	13	5A
0005434503532	6565	14	5C
0005434503517	6565	15	5D
0005434503529	6565	16	5E
0005434503536	6565	17	6E
0005434503527	6565	18	7C
0005434503530	6565	19	7D
0005435103817	6565	20	7E
0005434503528	6565	21	7F
0005434503516	6565	22	8C
0005434503505	6565	23	8D
0005434503500	6565	24	8E
0005435103808	6565	25	9C
0005435103812	6565	26	9F
0005434503499	6565	27	10C
0005434503514	6565	28	10D
0005434503503	6565	29	10E
0005434503535	6565	30	11A
0005434503524	6565	31	11C
0005435103811	6565	32	11D
0005434503511	6565	33	12A
0005435103818	6565	34	12C
0005435103805	6565	35	12F
0005434503515	6565	36	13A
0005434503501	6565	37	13D
0005434503508	6565	38	13E
0005434503512	6565	39	15F
0005434503506	6565	40	16A
0005434503509	6565	41	16C
0005434503521	6565	42	16D
0005434503519	6565	43	16E
0005435103815	6565	44	16F
0005434503518	6565	45	17A
0005434503523	6565	46	17C
0005434503522	6565	47	17D
0005434503531	6565	48	17E
0005434503533	6565	49	17F
0005434503525	6565	50	18F
0005434503510	6565	51	19A
0005435103807	6565	52	19C
0005435103813	6565	53	19E
0005434503504	6565	54	20C
0005435103806	6565	55	20E
0005435652303	1664	1	1A
0005435652309	1664	2	1F
0005435652300	1664	3	2A
0005435652317	1664	4	2D
0005435652302	1664	5	3C
0005435652325	1664	6	4C
0005435652318	1664	7	6C
0005435652320	1664	8	6D
0005435652298	1664	9	6E
0005435652304	1664	10	7D
0005435652326	1664	11	7F
0005435652299	1664	12	8E
0005435652307	1664	13	9A
0005435652324	1664	14	9D
0005435652316	1664	15	9E
0005435652312	1664	16	9F
0005435652338	1664	17	10C
0005435652330	1664	18	10E
0005435652323	1664	19	11A
0005435652308	1664	20	12C
0005435652334	1664	21	12E
0005435652329	1664	22	13C
0005435652306	1664	23	13E
0005435652328	1664	24	14D
0005435652319	1664	25	14F
0005435652339	1664	26	15A
0005435652332	1664	27	15C
0005435652297	1664	28	15D
0005435652322	1664	29	15F
0005435652313	1664	30	16C
0005435652301	1664	31	16F
0005435652337	1664	32	17A
0005435652327	1664	33	17C
0005435652315	1664	34	17D
0005435652321	1664	35	17E
0005435652310	1664	36	18A
0005435652305	1664	37	18C
0005435652331	1664	38	18D
0005435652314	1664	39	18E
0005435652335	1664	40	19A
0005435652333	1664	41	19C
0005435652311	1664	42	19D
0005435652336	1664	43	20C
0005433367275	21714	1	1C
0005433367270	21714	2	1D
0005433367268	21714	3	3A
0005433367264	21714	4	3C
0005433367290	21714	5	3F
0005433367278	21714	6	4D
0005433367289	21714	7	4F
0005433367280	21714	8	5C
0005433367274	21714	9	5E
0005433367265	21714	10	6C
0005433367288	21714	11	6D
0005433367273	21714	12	7A
0005433367279	21714	13	7C
0005433367269	21714	14	7F
0005433367291	21714	15	8A
0005433367282	21714	16	8C
0005433367262	21714	17	8D
0005433367272	21714	18	8E
0005433367287	21714	19	9C
0005433367283	21714	20	9D
0005433367276	21714	21	10C
0005433367286	21714	22	10E
0005433367284	21714	23	10F
0005433367293	21714	24	11D
0005433367263	21714	25	11E
0005433367277	21714	26	12A
0005433367267	21714	27	14D
0005433367271	21714	28	14F
0005433367294	21714	29	15E
0005433367292	21714	30	16C
0005433367285	21714	31	16F
0005433367266	21714	32	17C
0005433367281	21714	33	18C
0005433367260	21714	34	18E
0005433367259	21714	35	19A
0005433367261	21714	36	20C
0005433985170	4188	1	1F
0005433985169	4188	2	2C
0005433985210	4188	3	2D
0005433985180	4188	4	2F
0005433985182	4188	5	3A
0005433985171	4188	6	4A
0005433985176	4188	7	4C
0005433985186	4188	8	4D
0005433985201	4188	9	5A
0005433985191	4188	10	5D
0005433985172	4188	11	6A
0005433985200	4188	12	6C
0005433985167	4188	13	6D
0005433985184	4188	14	6E
0005433985195	4188	15	7A
0005433985197	4188	16	7C
0005433985175	4188	17	7E
0005433985190	4188	18	7F
0005435788730	4188	19	8C
0005433985211	4188	20	8D
0005433985173	4188	21	8F
0005433985193	4188	22	9C
0005433985199	4188	23	9D
0005433985165	4188	24	9E
0005433985174	4188	25	10D
0005433985166	4188	26	10F
0005433985181	4188	27	11A
0005433985203	4188	28	11E
0005433985179	4188	29	12A
0005433985178	4188	30	12C
0005433985209	4188	31	12D
0005433985194	4188	32	12E
0005433985185	4188	33	13C
0005433985183	4188	34	13D
0005433985204	4188	35	13E
0005433985163	4188	36	14A
0005435788729	4188	37	14D
0005433985187	4188	38	14E
0005433985198	4188	39	14F
0005433985208	4188	40	15D
0005433985192	4188	41	15F
0005433985188	4188	42	16A
0005433985205	4188	43	16C
0005433985164	4188	44	16D
0005433985202	4188	45	16E
0005433985207	4188	46	16F
0005433985206	4188	47	17C
0005433985162	4188	48	17D
0005433985189	4188	49	18A
0005433985196	4188	50	18E
0005433985168	4188	51	19F
0005433985177	4188	52	20A
0005435720119	24782	1	19B
0005435720118	24782	2	20B
0005434509023	1614	1	3A
0005434509016	1614	2	4B
0005434509025	1614	3	5A
0005434509015	1614	4	5B
0005434509022	1614	5	6A
0005434509024	1614	6	6D
0005434509028	1614	7	7A
0005434509027	1614	8	7C
0005434509018	1614	9	18A
0005434509014	1614	10	18C
0005434509021	1614	11	18D
0005434509026	1614	12	20B
0005434509019	1614	13	20D
0005434509017	1614	14	21A
0005434509030	1614	15	22D
0005434509029	1614	16	23A
0005434509020	1614	17	23B
0005432869418	17829	1	1C
0005432869422	17829	2	3F
0005432869419	17829	3	4C
0005434151657	17829	4	8D
0005434151658	17829	5	8E
0005432869423	17829	6	11A
0005432869417	17829	7	13A
0005432869420	17829	8	16A
0005432869421	17829	9	17C
0005434151659	17829	10	20E
0005432666353	26292	1	2C
0005432665238	26292	2	2D
0005432657395	26292	3	3F
0005432657394	26292	4	4D
0005432657393	26292	5	10A
0005432666351	26292	6	11D
0005432666352	26292	7	12E
0005432665237	26292	8	18E
0005432865895	25073	1	1A
0005432865897	25073	2	2D
0005432865903	25073	3	3A
0005432865899	25073	4	4A
0005432865902	25073	5	6D
0005432865901	25073	6	7D
0005432865908	25073	7	9C
0005432865907	25073	8	13C
0005432865905	25073	9	14A
0005432865906	25073	10	16C
0005432865898	25073	11	16D
0005432865904	25073	12	16E
0005432865896	25073	13	19A
0005432865900	25073	14	19E
0005432865894	25073	15	19F
0005432327939	3086	1	1A
0005433438776	3086	2	1D
0005432287106	3086	3	1F
0005432327938	3086	4	2A
0005433438771	3086	5	2C
0005432327941	3086	6	2D
0005432327960	3086	7	2F
0005432327980	3086	8	3A
0005432327957	3086	9	3C
0005432327973	3086	10	3D
0005432327951	3086	11	3F
0005432327967	3086	12	4A
0005432327982	3086	13	4C
0005432327970	3086	14	4D
0005432327984	3086	15	4E
0005433438772	3086	16	4F
0005432287107	3086	17	5A
0005433438775	3086	18	5D
0005432327958	3086	19	5E
0005433438769	3086	20	6E
0005432327975	3086	21	6F
0005432327942	3086	22	7A
0005432327963	3086	23	7D
0005432327954	3086	24	7E
0005432327953	3086	25	8D
0005432327955	3086	26	8F
0005432327943	3086	27	9D
0005432327979	3086	28	9F
0005432327949	3086	29	10A
0005432327981	3086	30	10C
0005432327947	3086	31	10F
0005432327946	3086	32	11A
0005432287108	3086	33	12A
0005432327945	3086	34	12D
0005432327952	3086	35	13C
0005432287109	3086	36	13E
0005432327956	3086	37	14A
0005432327969	3086	38	14F
0005432327971	3086	39	15A
0005432327944	3086	40	15C
0005432327977	3086	41	15E
0005432327972	3086	42	15D
0005433438774	3086	43	15F
0005433438770	3086	44	16A
0005432327965	3086	45	16C
0005432327962	3086	46	17A
0005432327976	3086	47	17E
0005432327964	3086	48	18A
0005432327966	3086	49	18C
0005432327978	3086	50	18D
0005432327961	3086	51	18E
0005432327974	3086	52	18F
0005432327948	3086	53	19C
0005432327940	3086	54	19D
0005432327950	3086	55	19E
0005433438773	3086	56	20A
0005433438768	3086	57	20C
0005432327983	3086	58	20D
0005432327968	3086	59	20E
0005432327959	3086	60	20F
0005432054255	31120	1	1A
0005432905028	31120	2	1F
0005432905027	31120	3	6F
0005432054256	31120	4	12C
0005432905026	31120	5	13C
0005432054257	31120	6	14F
0005435998981	6201	1	2C
0005435998969	6201	2	2F
0005434309523	6201	3	4F
0005435998977	6201	4	5C
0005434309517	6201	5	5E
0005435998974	6201	6	6A
0005434309527	6201	7	6D
0005434309519	6201	8	8A
0005435998983	6201	9	8C
0005435998984	6201	10	8F
0005435998968	6201	11	9D
0005435998975	6201	12	10E
0005435998970	6201	13	11C
0005434309518	6201	14	11B
0005435998979	6201	15	12C
0005435998976	6201	16	12E
0005434309515	6201	17	12F
0005434309529	6201	18	13E
0005434309525	6201	19	15A
0005434309514	6201	20	16B
0005434309528	6201	21	16A
0005434309521	6201	22	16F
0005434309522	6201	23	17B
0005434309520	6201	24	19E
0005435998978	6201	25	19F
0005435998971	6201	26	20A
0005435998982	6201	27	20D
0005435998972	6201	28	21D
0005434309526	6201	29	21F
0005432146166	6201	30	22B
0005434309524	6201	31	22D
0005435998973	6201	32	23B
0005434309516	6201	33	23D
0005435998980	6201	34	23C
0005435487456	19552	1	1C
0005435487465	19552	2	1F
0005435487464	19552	3	2C
0005435487471	19552	4	4D
0005435296949	19552	5	5D
0005435296950	19552	6	5F
0005435296947	19552	7	6F
0005435487470	19552	8	7B
0005435487466	19552	9	7E
0005435487472	19552	10	8C
0005435296944	19552	11	10E
0005435487453	19552	12	11D
0005435487457	19552	13	11E
0005435487474	19552	14	12A
0005435487461	19552	15	13A
0005435487463	19552	16	12F
0005435296946	19552	17	14B
0005435487455	19552	18	17E
0005435487467	19552	19	18E
0005435296948	19552	20	19A
0005435487473	19552	21	19D
0005435487454	19552	22	19C
0005435487459	19552	23	20B
0005435487469	19552	24	20D
0005435296945	19552	25	20C
0005435487460	19552	26	20F
0005435487468	19552	27	23A
0005435487458	19552	28	23E
0005435487462	19552	29	23F
0005432291892	1599	1	1C
0005435501954	1599	2	1F
0005434565699	1599	3	2C
0005435501960	1599	4	2D
0005435501964	1599	5	2F
0005434565693	1599	6	3A
0005435501965	1599	7	3C
0005435517612	1599	8	3D
0005435508178	1599	9	3F
0005434565696	1599	10	4A
0005435517607	1599	11	4C
0005434565701	1599	12	4D
0005434565702	1599	13	4E
0005435508182	1599	14	4F
0005435517624	1599	15	5A
0005435501957	1599	16	5C
0005435501953	1599	17	5D
0005435517619	1599	18	5E
0005434565700	1599	19	5F
0005435517628	1599	20	6A
0005435517608	1599	21	6C
0005435508181	1599	22	6D
0005435501956	1599	23	6E
0005435501958	1599	24	6F
0005435517622	1599	25	7C
0005434565703	1599	26	7D
0005435517611	1599	27	7E
0005434565698	1599	28	7F
0005435501955	1599	29	8A
0005435501974	1599	30	8D
0005435508183	1599	31	8F
0005435501970	1599	32	9A
0005434565692	1599	33	9E
0005435501959	1599	34	10C
0005435517613	1599	35	10E
0005435517614	1599	36	10F
0005435501971	1599	37	11C
0005435501962	1599	38	12D
0005435501963	1599	39	13A
0005435517626	1599	40	13D
0005435517625	1599	41	13E
0005434565694	1599	42	14A
0005435517615	1599	43	14C
0005435501967	1599	44	14D
0005434565704	1599	45	14F
0005435508179	1599	46	15A
0005435517616	1599	47	15D
0005435501961	1599	48	15E
0005434565695	1599	49	15F
0005435501973	1599	50	16A
0005435517620	1599	51	16D
0005432291891	1599	52	16E
0005434565705	1599	53	16F
0005435517609	1599	54	17A
0005435508184	1599	55	17C
0005435517617	1599	56	17D
0005435508180	1599	57	17E
0005435517610	1599	58	18A
0005434565697	1599	59	18C
0005435501972	1599	60	18E
0005435517618	1599	61	18F
0005435508177	1599	62	19A
0005435517621	1599	63	19D
0005435501969	1599	64	19E
0005435501966	1599	65	20A
0005435517623	1599	66	20C
0005435517627	1599	67	20D
0005435501968	1599	68	20E
0005433185981	20861	1	5E
0005433185984	20861	2	6D
0005433185979	20861	3	9D
0005433185982	20861	4	10C
0005433185977	20861	5	11D
0005433185978	20861	6	13D
0005433185980	20861	7	14E
0005433185983	20861	8	16D
0005433185976	20861	9	18E
0005435153639	3879	1	1C
0005435153637	3879	2	2B
0005435153632	3879	3	3C
0005435153638	3879	4	4B
0005435153633	3879	5	6B
0005435153635	3879	6	7B
0005435153636	3879	7	18C
0005435153634	3879	8	22A
0005435931540	21849	1	1D
0005435931539	21849	2	3A
0005435931542	21849	3	6B
0005435931541	21849	4	18A
0005432628616	7179	1	1B
0005432628609	7179	2	2B
0005432628612	7179	3	3D
0005432628600	7179	4	4A
0005432628607	7179	5	4D
0005432628606	7179	6	7C
0005432628605	7179	7	7D
0005432628613	7179	8	19A
0005432628603	7179	9	20A
0005432628602	7179	10	20C
0005432628601	7179	11	20D
0005432628611	7179	12	21B
0005432628608	7179	13	21C
0005432628610	7179	14	21D
0005432628615	7179	15	22B
0005432628614	7179	16	22C
0005432628604	7179	17	23A
0005435225455	28148	1	2C
0005435225454	28148	2	3B
0005435225452	28148	3	4A
0005435225456	28148	4	5D
0005435225453	28148	5	6C
0005435225457	28148	6	7C
0005435225458	28148	7	19B
0005435225451	28148	8	21B
0005435225450	28148	9	22B
0005435959989	8762	1	2D
0005435959988	8762	2	18B
0005435959986	8762	3	20A
0005435959987	8762	4	21C
0005434267889	15218	1	4D
0005434267890	15218	2	18A
0005434267888	15218	3	18D
0005434267887	15218	4	20C
0005432677506	1172	1	1F
0005432692551	1172	2	2A
0005432677505	1172	3	2D
0005432692536	1172	4	3C
0005432692554	1172	5	4D
0005432692540	1172	6	4C
0005432692531	1172	7	4F
0005432674886	1172	8	5C
0005432674888	1172	9	5A
0005432692558	1172	10	6B
0005432692547	1172	11	6A
0005432692557	1172	12	6E
0005432692549	1172	13	6D
0005432692548	1172	14	7B
0005432692552	1172	15	7E
0005432692535	1172	16	7D
0005432674881	1172	17	8A
0005432674880	1172	18	8B
0005432674889	1172	19	8C
0005432692530	1172	20	9C
0005432692529	1172	21	9B
0005432674883	1172	22	9E
0005432674885	1172	23	10C
0005432692541	1172	24	10F
0005432692537	1172	25	11C
0005432677504	1172	26	12A
0005432692532	1172	27	12D
0005432692528	1172	28	13D
0005432692543	1172	29	14B
0005432692546	1172	30	14A
0005432674878	1172	31	14D
0005432692544	1172	32	15C
0005432692534	1172	33	15E
0005432692533	1172	34	15D
0005432674892	1172	35	16B
0005432674882	1172	36	16A
0005432674887	1172	37	16D
0005432674891	1172	38	17B
0005432674884	1172	39	17D
0005432692545	1172	40	18B
0005432674879	1172	41	18A
0005432692550	1172	42	18C
0005432677503	1172	43	19A
0005432692538	1172	44	19B
0005432692539	1172	45	19F
0005432692555	1172	46	20A
0005432692556	1172	47	21B
0005432692542	1172	48	21A
0005432674890	1172	49	20F
0005432692527	1172	50	21E
0005432692553	1172	51	21F
0005432873174	17471	1	8C
0005432873179	17471	2	12D
0005432873178	17471	3	13A
0005432873176	17471	4	15C
0005432873177	17471	5	17F
0005432873175	17471	6	21C
0005434434940	1101	1	1A
0005434434930	1101	2	2B
0005434434939	1101	3	4D
0005434434926	1101	4	5A
0005434434933	1101	5	6B
0005434434931	1101	6	7C
0005434434938	1101	7	7D
0005434434929	1101	8	18C
0005434434937	1101	9	18D
0005434434925	1101	10	19C
0005434434934	1101	11	21B
0005434434935	1101	12	21D
0005434434927	1101	13	22A
0005434434928	1101	14	22C
0005434434936	1101	15	23A
0005434434932	1101	16	23B
0005433156610	17310	1	1B
0005433156606	17310	2	5C
0005433156609	17310	3	6B
0005433156612	17310	4	6D
0005433156608	17310	5	18B
0005433156607	17310	6	18C
0005433156611	17310	7	20B
0005435086709	4086	1	1D
0005435086713	4086	2	2B
0005435086707	4086	3	3B
0005435086710	4086	4	4C
0005435086711	4086	5	5C
0005435086715	4086	6	5D
0005435086714	4086	7	6B
0005435086708	4086	8	18C
0005435086712	4086	9	23B
0005435928067	24440	1	1B
0005435928065	24440	2	1C
0005435928063	24440	3	2C
0005435928064	24440	4	4C
0005435928062	24440	5	5A
0005435928066	24440	6	19B
0005434963930	1315	1	1F
0005434963898	1315	2	1C
0005434963932	1315	3	1H
0005434963910	1315	4	3A
0005434963927	1315	5	4G
0005434963921	1315	6	5B
0005434963917	1315	7	5C
0005434963902	1315	8	5F
0005434963911	1315	9	11H
0005434963901	1315	10	12F
0005432279238	1315	11	13E
0005434963903	1315	12	14A
0005434963904	1315	13	14D
0005434963906	1315	14	15E
0005434963923	1315	15	16A
0005432279236	1315	16	17A
0005434963928	1315	17	17B
0005434963925	1315	18	17G
0005432279237	1315	19	18A
0005434963895	1315	20	19B
0005434963909	1315	21	19A
0005434963912	1315	22	21A
0005434963920	1315	23	21D
0005434963918	1315	24	22D
0005434963922	1315	25	22H
0005434963929	1315	26	23B
0005434963896	1315	27	23D
0005434963924	1315	28	23F
0005434963919	1315	29	23H
0005432279235	1315	30	29B
0005434963926	1315	31	29F
0005434963915	1315	32	29H
0005434963900	1315	33	32F
0005434963905	1315	34	33E
0005434963916	1315	35	33F
0005434963913	1315	36	34G
0005434963931	1315	37	35A
0005434963933	1315	38	36H
0005434963908	1315	39	37B
0005434963907	1315	40	37H
0005434963914	1315	41	38F
0005434963899	1315	42	38H
0005434963897	1315	43	39F
0005433261393	18258	1	11B
0005433261388	18258	2	13A
0005433261396	18258	3	15A
0005433261395	18258	4	15B
0005433261402	18258	5	15D
0005433261404	18258	6	15H
0005433261389	18258	7	16H
0005433261406	18258	8	19F
0005433261392	18258	9	20A
0005433261399	18258	10	22G
0005433261401	18258	11	23G
0005433261397	18258	12	24A
0005433261407	18258	13	24E
0005433261405	18258	14	27E
0005433261390	18258	15	29D
0005433261408	18258	16	31A
0005433261391	18258	17	31B
0005433261394	18258	18	33A
0005433261398	18258	19	34A
0005433261400	18258	20	35H
0005433261403	18258	21	38D
0005434625803	4821	1	2A
0005434625809	4821	2	5A
0005434625807	4821	3	6A
0005434625812	4821	4	10F
0005434625810	4821	5	17A
0005434625806	4821	6	18E
0005434625808	4821	7	19A
0005434625811	4821	8	19C
0005434625805	4821	9	19D
0005434625804	4821	10	20E
0005433194823	32913	1	5C
0005435907421	32913	2	6A
0005433194820	32913	3	8C
0005433194822	32913	4	9F
0005435907425	32913	5	13F
0005435907423	32913	6	16A
0005435907422	32913	7	17D
0005433194821	32913	8	18F
0005435907424	32913	9	20C
0005432195658	13778	1	2C
0005435937315	13778	2	5D
0005432195659	13778	3	19A
0005435937318	13778	4	20A
0005435937314	13778	5	22A
0005435937316	13778	6	22C
0005435937317	13778	7	23A
0005435784732	27409	1	1A
0005432190563	27409	2	1B
0005435784756	27409	3	1C
0005435784730	27409	4	1D
0005435784752	27409	5	2B
0005435784738	27409	6	2C
0005435784739	27409	7	2D
0005435784737	27409	8	3A
0005435784759	27409	9	3C
0005435784742	27409	10	3D
0005435784736	27409	11	4A
0005435784748	27409	12	4B
0005435784735	27409	13	4C
0005435784733	27409	14	4D
0005435784750	27409	15	5A
0005435784761	27409	16	5C
0005435784758	27409	17	6A
0005435784757	27409	18	6B
0005435784763	27409	19	6C
0005432190564	27409	20	7A
0005435784749	27409	21	6D
0005432190561	27409	22	7B
0005435784762	27409	23	7C
0005435784729	27409	24	7D
0005432190562	27409	25	18A
0005435784731	27409	26	18C
0005435784755	27409	27	19A
0005435784744	27409	28	18D
0005435784740	27409	29	19B
0005435784747	27409	30	19C
0005435784754	27409	31	19D
0005435784728	27409	32	20A
0005435784745	27409	33	20B
0005435784751	27409	34	20C
0005435784746	27409	35	20D
0005435784741	27409	36	21C
0005435784743	27409	37	22A
0005435784753	27409	38	22B
0005435784727	27409	39	22D
0005435784734	27409	40	23A
0005435784760	27409	41	23B
0005432058316	20278	1	1A
0005435310873	20278	2	2A
0005435310859	20278	3	2C
0005435310861	20278	4	4D
0005435310869	20278	5	5C
0005432058317	20278	6	5D
0005435310858	20278	7	5F
0005435310863	20278	8	6E
0005435310867	20278	9	6F
0005435310875	20278	10	7D
0005435310860	20278	11	7E
0005435310856	20278	12	8A
0005435310857	20278	13	8F
0005435310870	20278	14	10C
0005432058319	20278	15	10F
0005435310866	20278	16	11E
0005435310872	20278	17	12A
0005435310862	20278	18	13C
0005435310865	20278	19	15A
0005435310871	20278	20	15C
0005435310868	20278	21	16A
0005435310874	20278	22	18D
0005432058318	20278	23	19D
0005435310864	20278	24	19F
0005434406750	26977	1	1A
0005434406732	26977	2	1C
0005434406744	26977	3	1D
0005434406737	26977	4	2C
0005434406755	26977	5	2D
0005434406753	26977	6	2F
0005434406747	26977	7	3A
0005434406721	26977	8	3C
0005434406713	26977	9	3D
0005434406751	26977	10	3F
0005434406726	26977	11	4A
0005434406763	26977	12	4C
0005434406722	26977	13	4E
0005434406709	26977	14	4F
0005434406703	26977	15	5C
0005432153826	26977	16	5D
0005434406716	26977	17	5F
0005434406707	26977	18	6C
0005434406715	26977	19	6D
0005434406759	26977	20	6E
0005432153822	26977	21	6F
0005432153821	26977	22	7A
0005434406740	26977	23	7C
0005432153827	26977	24	7D
0005432153824	26977	25	7E
0005434406735	26977	26	8D
0005434406719	26977	27	9A
0005434406734	26977	28	9C
0005434406741	26977	29	9E
0005434406764	26977	30	10A
0005432153820	26977	31	10C
0005434406748	26977	32	10E
0005434406757	26977	33	10F
0005434406723	26977	34	11A
0005434406731	26977	35	11D
0005434406702	26977	36	11E
0005434406728	26977	37	11F
0005434406704	26977	38	12A
0005434406718	26977	39	12C
0005434406742	26977	40	12D
0005434406761	26977	41	12E
0005434406733	26977	42	12F
0005434406711	26977	43	13A
0005434406749	26977	44	13C
0005434406708	26977	45	13D
0005434406724	26977	46	13E
0005434406727	26977	47	13F
0005434406738	26977	48	14A
0005434406739	26977	49	14C
0005434406714	26977	50	14D
0005434406760	26977	51	14F
0005434406712	26977	52	15A
0005434406752	26977	53	15D
0005434406745	26977	54	15E
0005434406730	26977	55	15F
0005434406758	26977	56	16C
0005434406729	26977	57	16E
0005434406705	26977	58	16F
0005434406743	26977	59	17D
0005432153825	26977	60	17E
0005432153823	26977	61	17F
0005434406720	26977	62	18C
0005434406736	26977	63	18D
0005434406746	26977	64	18E
0005434406717	26977	65	19A
0005434406754	26977	66	19D
0005434406762	26977	67	19E
0005434406725	26977	68	19F
0005434406756	26977	69	20D
0005434406710	26977	70	20E
0005434406706	26977	71	20F
0005434319151	5673	1	1D
0005432109658	5673	2	2C
0005434319160	5673	3	2D
0005434319156	5673	4	3A
0005434319162	5673	5	3D
0005434319163	5673	6	4A
0005434319158	5673	7	5D
0005434319152	5673	8	5E
0005432109657	5673	9	6D
0005434319155	5673	10	9C
0005432109659	5673	11	10E
0005434319161	5673	12	12C
0005434311184	5673	13	13A
0005434319157	5673	14	14F
0005434319154	5673	15	15A
0005434319153	5673	16	15C
0005434311183	5673	17	17D
0005434319159	5673	18	19D
0005433123598	15683	1	1C
0005433123606	15683	2	1F
0005433123605	15683	3	3A
0005433123589	15683	4	3C
0005433123602	15683	5	3D
0005433123600	15683	6	4A
0005433123597	15683	7	5E
0005433123608	15683	8	6A
0005433123609	15683	9	9A
0005433123595	15683	10	10D
0005433123601	15683	11	11A
0005433123599	15683	12	11E
0005433123607	15683	13	11F
0005433123596	15683	14	12A
0005433123610	15683	15	13C
0005433123603	15683	16	13E
0005433123594	15683	17	15D
0005433123604	15683	18	15E
0005433123590	15683	19	16A
0005433123588	15683	20	16C
0005433123591	15683	21	17C
0005433123592	15683	22	17E
0005433123593	15683	23	18A
0005434484241	8978	1	2C
0005434484243	8978	2	3B
0005434484238	8978	3	4A
0005434484239	8978	4	4D
0005434484242	8978	5	21A
0005434484240	8978	6	21C
0005434484244	8978	7	23A
0005434189084	16643	1	1A
0005434189083	16643	2	3D
0005434189086	16643	3	5A
0005434189085	16643	4	6B
0005434189081	16643	5	19C
0005434189082	16643	6	23A
0005433123598	7659	1	1C
0005433123606	7659	2	2C
0005433123601	7659	3	4A
0005433123593	7659	4	5E
0005433123610	7659	5	5F
0005433123602	7659	6	6C
0005433123599	7659	7	7A
0005433123604	7659	8	7F
0005433123589	7659	9	8C
0005433123596	7659	10	8E
0005433123590	7659	11	11F
0005433123608	7659	12	12F
0005433123605	7659	13	13D
0005433123603	7659	14	14E
0005433123588	7659	15	15D
0005433123594	7659	16	17C
0005433123607	7659	17	17F
0005433123592	7659	18	18A
0005433123600	7659	19	18D
0005433123591	7659	20	18F
0005433123609	7659	21	19A
0005433123597	7659	22	19C
0005433123595	7659	23	19D
0005432720474	7660	1	1A
0005432692588	7660	2	1C
0005432692575	7660	3	1D
0005432720471	7660	4	1F
0005433449624	7660	5	2A
0005432720478	7660	6	2C
0005433449627	7660	7	2D
0005432720465	7660	8	2F
0005432692565	7660	9	3A
0005432692566	7660	10	3D
0005432692578	7660	11	3F
0005433449607	7660	12	4A
0005432692573	7660	13	4C
0005432692569	7660	14	4D
0005432720463	7660	15	4E
0005432720459	7660	16	4F
0005432720456	7660	17	5A
0005432692581	7660	18	5C
0005432720475	7660	19	5D
0005432692571	7660	20	5E
0005432692576	7660	21	5F
0005432692567	7660	22	6A
0005432720482	7660	23	6C
0005433449618	7660	24	6D
0005432720473	7660	25	6E
0005432720470	7660	26	6F
0005433449612	7660	27	7C
0005432692562	7660	28	7D
0005432720458	7660	29	7E
0005432692572	7660	30	7F
0005432720462	7660	31	8A
0005432071523	7660	32	8C
0005432720457	7660	33	8E
0005432720460	7660	34	8F
0005432692585	7660	35	9A
0005433449609	7660	36	9C
0005432692564	7660	37	9D
0005432720480	7660	38	9E
0005433449611	7660	39	9F
0005433449626	7660	40	10A
0005432692582	7660	41	10C
0005433449608	7660	42	10E
0005432692587	7660	43	10F
0005433449625	7660	44	11A
0005432071525	7660	45	11C
0005432071526	7660	46	11D
0005433449610	7660	47	11E
0005432720466	7660	48	11F
0005432692560	7660	49	12A
0005432692583	7660	50	12C
0005432692563	7660	51	12D
0005432692559	7660	52	12E
0005432720467	7660	53	12F
0005433449614	7660	54	13A
0005433449613	7660	55	13C
0005432692570	7660	56	13D
0005432692586	7660	57	13F
0005432071524	7660	58	14A
0005432692579	7660	59	14C
0005433449615	7660	60	14D
0005433449616	7660	61	14E
0005432692589	7660	62	14F
0005432692580	7660	63	15A
0005433449606	7660	64	15D
0005432720464	7660	65	15E
0005432720481	7660	66	15F
0005432692577	7660	67	16A
0005433449623	7660	68	16D
0005432720461	7660	69	17A
0005432720468	7660	70	17D
0005432692584	7660	71	17E
0005432720479	7660	72	18A
0005432692568	7660	73	18C
0005432720476	7660	74	18D
0005432692574	7660	75	18E
0005432692561	7660	76	18F
0005432720477	7660	77	19A
0005433449622	7660	78	19C
0005433449621	7660	79	19D
0005433449619	7660	80	19F
0005433449620	7660	81	20A
0005432720469	7660	82	20D
0005432720472	7660	83	20E
0005433449617	7660	84	20F
0005433722107	30444	1	2F
0005433722114	30444	2	6D
0005433722117	30444	3	7F
0005433722111	30444	4	8E
0005433722112	30444	5	9C
0005433722108	30444	6	9D
0005433722116	30444	7	11E
0005433722115	30444	8	13E
0005433722109	30444	9	16E
0005433722113	30444	10	18C
0005433722110	30444	11	20A
0005434514925	1393	1	1C
0005434586198	1393	2	1D
0005433524866	1393	3	1F
0005433724731	1393	4	2A
0005434586203	1393	5	3F
0005433524865	1393	6	4A
0005433524863	1393	7	4C
0005434586192	1393	8	4E
0005433524861	1393	9	4F
0005434586194	1393	10	5A
0005434514924	1393	11	5C
0005434586204	1393	12	5D
0005434586189	1393	13	5F
0005434586206	1393	14	6A
0005434586190	1393	15	6C
0005434586186	1393	16	6D
0005434513536	1393	17	6E
0005434586205	1393	18	6F
0005434586195	1393	19	7C
0005434586191	1393	20	7F
0005433524859	1393	21	8A
0005434586184	1393	22	8D
0005433524867	1393	23	9C
0005433524860	1393	24	9E
0005434586187	1393	25	10A
0005433524868	1393	26	10C
0005432270957	1393	27	10E
0005433724729	1393	28	10F
0005434586196	1393	29	11A
0005433524864	1393	30	11C
0005434586185	1393	31	11D
0005434586202	1393	32	12C
0005434586183	1393	33	12D
0005434586207	1393	34	12E
0005434586200	1393	35	12F
0005433724728	1393	36	13A
0005433524857	1393	37	13F
0005433524862	1393	38	14A
0005432270958	1393	39	14C
0005433524856	1393	40	14E
0005433724732	1393	41	14F
0005434586193	1393	42	15C
0005433524869	1393	43	16C
0005434586197	1393	44	16D
0005434586199	1393	45	16F
0005434586201	1393	46	17A
0005434586188	1393	47	18A
0005433524858	1393	48	18F
0005432270959	1393	49	19A
0005433724730	1393	50	19F
0005434586208	1393	51	20A
0005434513537	1393	52	20F
0005433192835	18549	1	1F
0005432968802	18549	2	2A
0005432927889	18549	3	2F
0005433192837	18549	4	3C
0005433192836	18549	5	4E
0005433192825	18549	6	5C
0005433192823	18549	7	5D
0005433192827	18549	8	6F
0005432927886	18549	9	8E
0005433192831	18549	10	9C
0005433192832	18549	11	11A
0005433192822	18549	12	11F
0005433192834	18549	13	12E
0005432968803	18549	14	14A
0005433192830	18549	15	14D
0005432968801	18549	16	15A
0005433192826	18549	17	15E
0005432927885	18549	18	16F
0005433192833	18549	19	18A
0005432927887	18549	20	19C
0005432927888	18549	21	20C
0005433192829	18549	22	20D
0005433192828	18549	23	20E
0005433192824	18549	24	20F
0005434343582	11432	1	1A
0005434142545	11432	2	1B
0005434343592	11432	3	1C
0005434142546	11432	4	1D
0005434343608	11432	5	2B
0005434343597	11432	6	2D
0005434343590	11432	7	3A
0005434343607	11432	8	3B
0005434343603	11432	9	3C
0005434142544	11432	10	3D
0005434343587	11432	11	4A
0005434343611	11432	12	4B
0005434343584	11432	13	4C
0005434343615	11432	14	5A
0005434142547	11432	15	5B
0005434343606	11432	16	5C
0005434343602	11432	17	5D
0005434343599	11432	18	6A
0005434343600	11432	19	6B
0005434343589	11432	20	7A
0005434343596	11432	21	7B
0005434343614	11432	22	7C
0005434343609	11432	23	7D
0005434343585	11432	24	18B
0005434343610	11432	25	18C
0005434343605	11432	26	18D
0005434343616	11432	27	19A
0005434343586	11432	28	19B
0005434343591	11432	29	19C
0005434343595	11432	30	20B
0005434343598	11432	31	20D
0005434343588	11432	32	21A
0005434343593	11432	33	21C
0005434343583	11432	34	21D
0005434343594	11432	35	22A
0005434343613	11432	36	22B
0005434343612	11432	37	22C
0005434343604	11432	38	22D
0005434343601	11432	39	23B
0005435304097	29770	1	4A
0005435304098	29770	2	19C
0005435824187	1252	1	1C
0005435824203	1252	2	2A
0005435824181	1252	3	3D
0005435824192	1252	4	4C
0005435824204	1252	5	5A
0005435824202	1252	6	6A
0005435824199	1252	7	8B
0005435824186	1252	8	8E
0005435824200	1252	9	9F
0005435824196	1252	10	9E
0005432284510	1252	11	10A
0005432284512	1252	12	10C
0005432284511	1252	13	10D
0005435824184	1252	14	10F
0005435824195	1252	15	10E
0005435824193	1252	16	11B
0005435824205	1252	17	11D
0005435824180	1252	18	12C
0005435824191	1252	19	13B
0005435824189	1252	20	13D
0005435824183	1252	21	13F
0005432284509	1252	22	15C
0005435824190	1252	23	16B
0005435824185	1252	24	16E
0005435824194	1252	25	17B
0005435824197	1252	26	17A
0005435824198	1252	27	18F
0005435824201	1252	28	18E
0005435824188	1252	29	19A
0005435824182	1252	30	20B
0005435824179	1252	31	21F
0005433415401	18029	1	2C
0005433415403	18029	2	3A
0005433415394	18029	3	2F
0005433415398	18029	4	5F
0005433415400	18029	5	6A
0005433415404	18029	6	8F
0005433415407	18029	7	11A
0005433415395	18029	8	14B
0005433415408	18029	9	16F
0005433415410	18029	10	16E
0005433415402	18029	11	17A
0005433415406	18029	12	19B
0005433415397	18029	13	19E
0005433415396	18029	14	19D
0005433415399	18029	15	20C
0005433415405	18029	16	21B
0005433415409	18029	17	21E
0005434461608	12579	1	1B
0005434461609	12579	2	6A
0005434460467	12579	3	6B
0005434461610	12579	4	19B
0005434460466	12579	5	22A
0005434460468	12579	6	23B
0005432782922	5636	1	1D
0005432782915	5636	2	1F
0005432782930	5636	3	2C
0005432782912	5636	4	2D
0005432782936	5636	5	2F
0005432143933	5636	6	3A
0005432782940	5636	7	3F
0005432782927	5636	8	4A
0005432782918	5636	9	4C
0005432782941	5636	10	4D
0005432782934	5636	11	4F
0005432782933	5636	12	5A
0005432782928	5636	13	5C
0005432143934	5636	14	5D
0005432782945	5636	15	5F
0005432782946	5636	16	6A
0005432782903	5636	17	6F
0005432782929	5636	18	7C
0005432782947	5636	19	7D
0005432782908	5636	20	7E
0005432782893	5636	21	8A
0005432782907	5636	22	8C
0005432782938	5636	23	8D
0005432782899	5636	24	9C
0005432782932	5636	25	9D
0005432782913	5636	26	9F
0005432782911	5636	27	10A
0005432782904	5636	28	10C
0005432782914	5636	29	10D
0005432782905	5636	30	10E
0005432782923	5636	31	10F
0005432782944	5636	32	11D
0005432782895	5636	33	11E
0005432782916	5636	34	11F
0005432782921	5636	35	12A
0005432782917	5636	36	12D
0005432782937	5636	37	12E
0005432782906	5636	38	13A
0005432782943	5636	39	13D
0005432782910	5636	40	13E
0005432782924	5636	41	14A
0005432782920	5636	42	14E
0005432782919	5636	43	14F
0005432782898	5636	44	15A
0005432782931	5636	45	15C
0005432782909	5636	46	15E
0005432782942	5636	47	15F
0005432782896	5636	48	16A
0005432782900	5636	49	17C
0005432782902	5636	50	17D
0005432782939	5636	51	17F
0005432782901	5636	52	18A
0005432782926	5636	53	18C
0005432782897	5636	54	18D
0005432143935	5636	55	18F
0005432782925	5636	56	19A
0005432782935	5636	57	19F
0005432782894	5636	58	20C
0005432782948	5636	59	20E
0005435242390	15349	1	1A
0005435242391	15349	2	2F
0005435242406	15349	3	3A
0005435242412	15349	4	3D
0005435242403	15349	5	4A
0005435242387	15349	6	4D
0005435242396	15349	7	5A
0005435242409	15349	8	5E
0005435242402	15349	9	6E
0005435242405	15349	10	7A
0005435242393	15349	11	7C
0005435242413	15349	12	7D
0005435242389	15349	13	8A
0005435242415	15349	14	8D
0005435476651	15349	15	9A
0005435242395	15349	16	9D
0005435242388	15349	17	9F
0005435242414	15349	18	10A
0005435242410	15349	19	10C
0005435242401	15349	20	10E
0005435242394	15349	21	12C
0005435242400	15349	22	13A
0005435242408	15349	23	13C
0005435242398	15349	24	13D
0005435476650	15349	25	15E
0005435476649	15349	26	16F
0005435242407	15349	27	18D
0005435242392	15349	28	19C
0005435242411	15349	29	19E
0005435242397	15349	30	19F
0005435242404	15349	31	20A
0005435242399	15349	32	20C
0005432848083	4387	1	1D
0005432848082	4387	2	3B
0005432848075	4387	3	4A
0005432848080	4387	4	4D
0005434463895	4387	5	5B
0005432848084	4387	6	5C
0005432848079	4387	7	5D
0005432848081	4387	8	6B
0005432848078	4387	9	6D
0005432848077	4387	10	7C
0005432848076	4387	11	7D
0005434462755	4387	12	18C
0005432848074	4387	13	19A
0005434462754	4387	14	20B
0005434463894	4387	15	20C
0005432848073	4387	16	20D
0005432848072	4387	17	21C
0005432848071	4387	18	22A
0005434463893	4387	19	23A
0005435850759	28861	1	3A
0005435850760	28861	2	3B
0005435850764	28861	3	3D
0005435850765	28861	4	4A
0005435850762	28861	5	6B
0005435850766	28861	6	18D
0005435850758	28861	7	19B
0005435850763	28861	8	21D
0005435850761	28861	9	22D
0005433496460	6314	1	1A
0005434443452	6314	2	1C
0005434443453	6314	3	1D
0005434925293	6314	4	2A
0005433496452	6314	5	2C
0005433496472	6314	6	2D
0005433496459	6314	7	2F
0005434443448	6314	8	3A
0005433496479	6314	9	3C
0005434443450	6314	10	3D
0005434443441	6314	11	3F
0005432075173	6314	12	4A
0005433496464	6314	13	4E
0005433496473	6314	14	4F
0005434925303	6314	15	5A
0005433496482	6314	16	5C
0005433496469	6314	17	5D
0005434925288	6314	18	5E
0005433496451	6314	19	5F
0005432075175	6314	20	6A
0005434925275	6314	21	6C
0005434443454	6314	22	6D
0005434925287	6314	23	6E
0005434443451	6314	24	6F
0005434925297	6314	25	7A
0005434925300	6314	26	7C
0005434443455	6314	27	7D
0005433496450	6314	28	7E
0005433496456	6314	29	7F
0005434925294	6314	30	8A
0005434443443	6314	31	8C
0005434443446	6314	32	8D
0005434925299	6314	33	8E
0005433496481	6314	34	8F
0005434925305	6314	35	9A
0005434925274	6314	36	9C
0005434443444	6314	37	9D
0005432075174	6314	38	9F
0005434443449	6314	39	10A
0005434925280	6314	40	10C
0005432075172	6314	41	10E
0005434925304	6314	42	10F
0005433496480	6314	43	11A
0005434925273	6314	44	11C
0005433496465	6314	45	11D
0005434925292	6314	46	11E
0005434925282	6314	47	11F
0005433496475	6314	48	12A
0005434925298	6314	49	12D
0005433496477	6314	50	12E
0005433496467	6314	51	12F
0005434925301	6314	52	13A
0005434443447	6314	53	13C
0005434925302	6314	54	13D
0005433496462	6314	55	13E
0005433496454	6314	56	13F
0005433496458	6314	57	14A
0005434925290	6314	58	14C
0005434443440	6314	59	14E
0005433496474	6314	60	14D
0005433496476	6314	61	14F
0005433496471	6314	62	15A
0005434925277	6314	63	15C
0005434925286	6314	64	15D
0005433496463	6314	65	15F
0005433496466	6314	66	16A
0005434925283	6314	67	16C
0005433496455	6314	68	16D
0005433496470	6314	69	16E
0005433496468	6314	70	16F
0005434925284	6314	71	17A
0005434925285	6314	72	17C
0005434925281	6314	73	17D
0005434925278	6314	74	17E
0005433496453	6314	75	17F
0005433496461	6314	76	18C
0005433496478	6314	77	18D
0005433496457	6314	78	18E
0005434925295	6314	79	19A
0005434925291	6314	80	19D
0005434925279	6314	81	19E
0005434443442	6314	82	20A
0005434925296	6314	83	20C
0005434443445	6314	84	20D
0005434925276	6314	85	20E
0005434925289	6314	86	20F
0005435242431	12197	1	1A
0005435242418	12197	2	1D
0005435242430	12197	3	3A
0005435242419	12197	4	4C
0005435242427	12197	5	4F
0005435242429	12197	6	6A
0005435242442	12197	7	6E
0005435242426	12197	8	6F
0005435242424	12197	9	7D
0005435242433	12197	10	8A
0005435242441	12197	11	8C
0005435242416	12197	12	8D
0005435242438	12197	13	10A
0005435242432	12197	14	10C
0005435242436	12197	15	11E
0005435242420	12197	16	12D
0005435242425	12197	17	15D
0005435242423	12197	18	15E
0005435242428	12197	19	15F
0005435242437	12197	20	16C
0005435242439	12197	21	16D
0005435242435	12197	22	17A
0005435242421	12197	23	17C
0005435242417	12197	24	17E
0005435242422	12197	25	18C
0005435242440	12197	26	18D
0005435242434	12197	27	20C
0005432782857	15398	1	1D
0005432782842	15398	2	2A
0005432782890	15398	3	3A
0005432782856	15398	4	3C
0005432782847	15398	5	3D
0005432782855	15398	6	4C
0005432782859	15398	7	4D
0005432782873	15398	8	4F
0005432782880	15398	9	5A
0005432782891	15398	10	5E
0005432782879	15398	11	5F
0005432782850	15398	12	6A
0005432782862	15398	13	6E
0005432782884	15398	14	7A
0005432782846	15398	15	7C
0005432782848	15398	16	7D
0005432782877	15398	17	7E
0005432782887	15398	18	8A
0005432782868	15398	19	8E
0005432782858	15398	20	9C
0005432782875	15398	21	9D
0005432782864	15398	22	9F
0005432782881	15398	23	10A
0005432782882	15398	24	10D
0005432782865	15398	25	11A
0005432782843	15398	26	11C
0005432782866	15398	27	11F
0005432782876	15398	28	12A
0005432782870	15398	29	12D
0005432782885	15398	30	12E
0005432782841	15398	31	13A
0005432782839	15398	32	13E
0005432782883	15398	33	13D
0005432782851	15398	34	14A
0005432782869	15398	35	14C
0005432782888	15398	36	14E
0005432782844	15398	37	15A
0005432782849	15398	38	15C
0005432782860	15398	39	15F
0005432782863	15398	40	16A
0005432782874	15398	41	16C
0005432782840	15398	42	16D
0005432782854	15398	43	17C
0005432782838	15398	44	17E
0005432782872	15398	45	17F
0005432782886	15398	46	18A
0005432782853	15398	47	18C
0005432782852	15398	48	18D
0005432782867	15398	49	18F
0005432782871	15398	50	19A
0005432782845	15398	51	19C
0005432782861	15398	52	19E
0005432782889	15398	53	20A
0005432782892	15398	54	20C
0005432782878	15398	55	20F
0005435913855	10111	1	1F
0005434910071	10111	2	6F
0005435913852	10111	3	9E
0005435913853	10111	4	11A
0005434910072	10111	5	12F
0005435913851	10111	6	15E
0005435913854	10111	7	17E
0005435913856	10111	8	19F
0005435913857	10111	9	20F
0005434876746	14650	1	1A
0005434876668	14650	2	1D
0005434876726	14650	3	2C
0005434876654	14650	4	2A
0005434876652	14650	5	2F
0005434876666	14650	6	2D
0005434876740	14650	7	3A
0005434876742	14650	8	3D
0005434876737	14650	9	3C
0005434876657	14650	10	4A
0005434876743	14650	11	3F
0005434876732	14650	12	4D
0005434876658	14650	13	4C
0005434876679	14650	14	5A
0005434876681	14650	15	4F
0005434876717	14650	16	5D
0005434876725	14650	17	5C
0005434876703	14650	18	5F
0005434876669	14650	19	6A
0005434876684	14650	20	6D
0005434876706	14650	21	6C
0005434876739	14650	22	6B
0005434876691	14650	23	6F
0005434876688	14650	24	6E
0005434876724	14650	25	7A
0005434876672	14650	26	7C
0005434876653	14650	27	7B
0005434876690	14650	28	7E
0005434876727	14650	29	7D
0005434876713	14650	30	7F
0005434876719	14650	31	8B
0005434876707	14650	32	8A
0005434876718	14650	33	8E
0005434876710	14650	34	9B
0005434876695	14650	35	9A
0005434876697	14650	36	9C
0005434876736	14650	37	9F
0005434876685	14650	38	9E
0005434876744	14650	39	9D
0005434876662	14650	40	10B
0005434876696	14650	41	10A
0005434876694	14650	42	10C
0005434876716	14650	43	10D
0005434876711	14650	44	10F
0005434876700	14650	45	11C
0005434876683	14650	46	11B
0005434876665	14650	47	11D
0005434876704	14650	48	11F
0005434876692	14650	49	12B
0005434876670	14650	50	12A
0005434876682	14650	51	12D
0005434876741	14650	52	12C
0005434876733	14650	53	12F
0005434876734	14650	54	12E
0005434876735	14650	55	13C
0005434758855	14650	56	13B
0005434876659	14650	57	13E
0005434876712	14650	58	13D
0005434876676	14650	59	14A
0005434876667	14650	60	13F
0005434876747	14650	61	14B
0005434758856	14650	62	14C
0005434876728	14650	63	14F
0005434876738	14650	64	14E
0005434876745	14650	65	15B
0005434876701	14650	66	15D
0005434876689	14650	67	15C
0005434876680	14650	68	15F
0005434876686	14650	69	15E
0005434876673	14650	70	16A
0005434876729	14650	71	16C
0005434876721	14650	72	16B
0005434876748	14650	73	16D
0005434876663	14650	74	16F
0005434876675	14650	75	16E
0005434876664	14650	76	17C
0005434876715	14650	77	17B
0005434876702	14650	78	17A
0005434876661	14650	79	17D
0005434876687	14650	80	18B
0005434876723	14650	81	18A
0005434876677	14650	82	17F
0005434876693	14650	83	18C
0005434876699	14650	84	18D
0005434876709	14650	85	19A
0005434876720	14650	86	18F
0005434876698	14650	87	19E
0005434876671	14650	88	19D
0005434876722	14650	89	19C
0005434876731	14650	90	19F
0005434876660	14650	91	20B
0005434876674	14650	92	20A
0005434876705	14650	93	20C
0005434876656	14650	94	20F
0005434876730	14650	95	20D
0005434876678	14650	96	21A
0005434876714	14650	97	21C
0005434876708	14650	98	21E
0005434876655	14650	99	21F
0005435659953	9246	1	1A
0005435659954	9246	2	2A
0005435659949	9246	3	4A
0005435659950	9246	4	4D
0005435659959	9246	5	5C
0005435659958	9246	6	5D
0005435659951	9246	7	7A
0005435659955	9246	8	19B
0005435659956	9246	9	19D
0005435659952	9246	10	21C
0005435659957	9246	11	22C
0005434251809	24625	1	1C
0005434251810	24625	2	3D
0005434251808	24625	3	4D
0005434251812	24625	4	5A
0005434251813	24625	5	5C
0005434251811	24625	6	19B
0005434251805	24625	7	20C
0005434251807	24625	8	20D
0005434251806	24625	9	21D
0005434251814	24625	10	23B
0005433679787	2803	1	1C
0005433679788	2803	2	2C
0005433679790	2803	3	3A
0005433679759	2803	4	3C
0005433679772	2803	5	4A
0005433684385	2803	6	4D
0005433679767	2803	7	4E
0005433679758	2803	8	5A
0005433679771	2803	9	5C
0005433679791	2803	10	5E
0005433679769	2803	11	5F
0005433679768	2803	12	6A
0005433679770	2803	13	6C
0005433679793	2803	14	6D
0005433679805	2803	15	6E
0005433679774	2803	16	6F
0005433679799	2803	17	7A
0005433679765	2803	18	7C
0005433679783	2803	19	7D
0005433679761	2803	20	7F
0005433679785	2803	21	8A
0005433679776	2803	22	8C
0005432222695	2803	23	8D
0005433679797	2803	24	8E
0005433679784	2803	25	9D
0005433679779	2803	26	9E
0005433679804	2803	27	9F
0005433679763	2803	28	10C
0005433679789	2803	29	10E
0005433679792	2803	30	11A
0005433679762	2803	31	11C
0005433679778	2803	32	11D
0005433679775	2803	33	11E
0005433679801	2803	34	11F
0005433679780	2803	35	12A
0005433679798	2803	36	12C
0005432222693	2803	37	12D
0005433684384	2803	38	12F
0005433679781	2803	39	12E
0005433679764	2803	40	13C
0005433679806	2803	41	13E
0005433679773	2803	42	14D
0005433679796	2803	43	15A
0005432222694	2803	44	15C
0005433679794	2803	45	15D
0005432222697	2803	46	16A
0005433679757	2803	47	16C
0005433679795	2803	48	16D
0005433679803	2803	49	17A
0005432222696	2803	50	17C
0005433679782	2803	51	17D
0005433679760	2803	52	18A
0005433679802	2803	53	19A
0005433679786	2803	54	19F
0005433679777	2803	55	20D
0005433679766	2803	56	20E
0005433679800	2803	57	20F
0005432966515	29157	1	3D
0005432966513	29157	2	4E
0005432966526	29157	3	5D
0005432966530	29157	4	5E
0005432966512	29157	5	6A
0005432966508	29157	6	6E
0005432005166	29157	7	7A
0005432966507	29157	8	7C
0005432966516	29157	9	7D
0005432966525	29157	10	8D
0005432966514	29157	11	8F
0005432966518	29157	12	9E
0005432966522	29157	13	10D
0005432966505	29157	14	10F
0005432966528	29157	15	11C
0005432005167	29157	16	12A
0005432966520	29157	17	13A
0005432966510	29157	18	13F
0005432966521	29157	19	14A
0005432005168	29157	20	14D
0005432966531	29157	21	14E
0005432966527	29157	22	15C
0005432966511	29157	23	17E
0005432966523	29157	24	18C
0005432966519	29157	25	18E
0005432966529	29157	26	18F
0005432966506	29157	27	19C
0005432966524	29157	28	19E
0005432966509	29157	29	20A
0005432966517	29157	30	20C
0005433613391	9319	1	1C
0005433613431	9319	2	1A
0005433613388	9319	3	1D
0005433613438	9319	4	2A
0005433613440	9319	5	2C
0005433633240	9319	6	2F
0005433613450	9319	7	2D
0005433613422	9319	8	3A
0005433613433	9319	9	3C
0005432756792	9319	10	3D
0005433613460	9319	11	3F
0005433613427	9319	12	4C
0005433613413	9319	13	5A
0005433613447	9319	14	4F
0005433613429	9319	15	5C
0005433613399	9319	16	5D
0005433633217	9319	17	6A
0005433633230	9319	18	6C
0005433613400	9319	19	6F
0005433633214	9319	20	6D
0005433633219	9319	21	7A
0005433613446	9319	22	7C
0005433613432	9319	23	8B
0005433633246	9319	24	8D
0005433613415	9319	25	8C
0005433613416	9319	26	8E
0005433633224	9319	27	9A
0005433613412	9319	28	8F
0005433613390	9319	29	9D
0005433633213	9319	30	9E
0005433613458	9319	31	10A
0005433577583	9319	32	9F
0005432145076	9319	33	10D
0005433577576	9319	34	10C
0005433613402	9319	35	10E
0005433613418	9319	36	10F
0005433613417	9319	37	11B
0005433613452	9319	38	11A
0005433633236	9319	39	11C
0005433613404	9319	40	11D
0005432756790	9319	41	12A
0005433613437	9319	42	11F
0005433577577	9319	43	12C
0005433613421	9319	44	12B
0005433613445	9319	45	12D
0005433633245	9319	46	12E
0005433633218	9319	47	12F
0005433613459	9319	48	13C
0005433613397	9319	49	13B
0005433613407	9319	50	13D
0005433633226	9319	51	13F
0005433613453	9319	52	13E
0005433577574	9319	53	14A
0005433613443	9319	54	14E
0005433613456	9319	55	14D
0005433613425	9319	56	14F
0005433613444	9319	57	15C
0005433613454	9319	58	15B
0005433633241	9319	59	15E
0005433613409	9319	60	15D
0005433613401	9319	61	16A
0005433633235	9319	62	15F
0005433633227	9319	63	16C
0005433613436	9319	64	16B
0005433633225	9319	65	16D
0005433577579	9319	66	16F
0005433613386	9319	67	17C
0005433633232	9319	68	17B
0005433613434	9319	69	17D
0005433613393	9319	70	17F
0005433613441	9319	71	17E
0005433633231	9319	72	18B
0005433613387	9319	73	18D
0005433577580	9319	74	18C
0005433613396	9319	75	18E
0005433633244	9319	76	18F
0005433613395	9319	77	19C
0005433633221	9319	78	19B
0005433633239	9319	79	20A
0005433613403	9319	80	19E
0005433613408	9319	81	20B
0005433633223	9319	82	20C
0005433613392	9319	83	20F
0005433633247	9319	84	21B
0005433613424	9319	85	21D
0005433613414	9319	86	21E
0005433613398	9319	87	21F
0005433633242	9319	88	22B
0005433613423	9319	89	22A
0005433613389	9319	90	22D
0005433633237	9319	91	22C
0005432145077	9319	92	22F
0005433577584	9319	93	22E
0005433633228	9319	94	23B
0005433613448	9319	95	23D
0005433633243	9319	96	24A
0005432755018	9319	97	23F
0005433613420	9319	98	24B
0005433613449	9319	99	24D
0005433577581	9319	100	24C
0005432145075	9319	101	24E
0005433633229	9319	102	24F
0005433613406	9319	103	25B
0005433577586	9319	104	25A
0005433613435	9319	105	25C
0005433633234	9319	106	25D
0005433613419	9319	107	25E
0005432755020	9319	108	25F
0005432756793	9319	109	26B
0005433633220	9319	110	26A
0005433613430	9319	111	26D
0005433633215	9319	112	26C
0005433613442	9319	113	26E
0005433577587	9319	114	26F
0005432755019	9319	115	27A
0005433577578	9319	116	27C
0005433613405	9319	117	27D
0005433613451	9319	118	27E
0005433577582	9319	119	27F
0005433633233	9319	120	28D
0005433577585	9319	121	28F
0005433633222	9319	122	29A
0005433613394	9319	123	29C
0005433633216	9319	124	29B
0005433613439	9319	125	29D
0005433613455	9319	126	29E
0005433613457	9319	127	29F
0005433633238	9319	128	30D
0005433613426	9319	129	30C
0005432756791	9319	130	30E
0005433577575	9319	131	31A
0005433613411	9319	132	31C
0005433613410	9319	133	31D
0005433613428	9319	134	31F
0005434163466	25219	1	3F
0005434163467	25219	2	5C
0005434273047	25219	3	5D
0005434163464	25219	4	9E
0005434163469	25219	5	10D
0005434163463	25219	6	12F
0005434272162	25219	7	13B
0005434163461	25219	8	14B
0005434163458	25219	9	20C
0005434163460	25219	10	22F
0005434163459	25219	11	23E
0005434272161	25219	12	25A
0005434163468	25219	13	26F
0005434163462	25219	14	27D
0005434163465	25219	15	30F
0005434273046	25219	16	31C
0005435986656	4255	1	15A
0005432184903	4255	2	21B
0005432184904	4255	3	31G
0005435986655	4255	4	32A
0005432184905	4255	5	33G
0005435787323	26569	1	1B
0005435787322	26569	2	1G
0005435947021	26569	3	5B
0005435947017	26569	4	5H
0005435947023	26569	5	11F
0005435947024	26569	6	11H
0005432571263	26569	7	14B
0005435947025	26569	8	14A
0005435947019	26569	9	16E
0005435856137	26569	10	17G
0005432571262	26569	11	20E
0005435947020	26569	12	20H
0005435947014	26569	13	21A
0005435947012	26569	14	23A
0005435947022	26569	15	24B
0005435947016	26569	16	28A
0005435947015	26569	17	32D
0005435947013	26569	18	34G
0005432571261	26569	19	35B
0005435856134	26569	20	35E
0005435947018	26569	21	35G
0005435856136	26569	22	37B
0005435856135	26569	23	39E
0005432238837	363	1	1C
0005433568112	363	2	1D
0005433568086	363	3	2A
0005433568103	363	4	2D
0005433568083	363	5	4A
0005433568072	363	6	3F
0005433568120	363	7	4C
0005433568096	363	8	5D
0005433568102	363	9	7A
0005433568113	363	10	7F
0005433568088	363	11	8B
0005433568092	363	12	9C
0005433568093	363	13	9F
0005433568100	363	14	9E
0005433568122	363	15	10A
0005433568111	363	16	10C
0005433568099	363	17	10F
0005433568115	363	18	11C
0005432238839	363	19	11D
0005433568073	363	20	12B
0005433568121	363	21	12D
0005433568089	363	22	12F
0005433568123	363	23	12E
0005433568109	363	24	13C
0005433568107	363	25	13D
0005433568097	363	26	14A
0005433568094	363	27	14E
0005433568104	363	28	14F
0005433568085	363	29	15A
0005433568078	363	30	15D
0005433568076	363	31	15E
0005433568090	363	32	16B
0005433568071	363	33	17A
0005433568108	363	34	17B
0005432238836	363	35	19B
0005433568117	363	36	19E
0005432238834	363	37	20B
0005433568084	363	38	20A
0005433568118	363	39	20D
0005433568077	363	40	21B
0005433568116	363	41	22C
0005433568101	363	42	22E
0005433568091	363	43	23B
0005433568110	363	44	24B
0005432238835	363	45	24D
0005433568082	363	46	24F
0005433568105	363	47	25B
0005432238833	363	48	25C
0005433568098	363	49	25E
0005433568114	363	50	26D
0005433568070	363	51	26C
0005433568080	363	52	26E
0005433568095	363	53	27B
0005433568081	363	54	27D
0005433568087	363	55	27F
0005433568119	363	56	28B
0005433568074	363	57	28E
0005433568079	363	58	29A
0005432238838	363	59	29C
0005433568069	363	60	29D
0005433568106	363	61	30D
0005433568075	363	62	31C
0005433074234	11605	1	1D
0005432947798	11605	2	2A
0005432947802	11605	3	2D
0005432947785	11605	4	4D
0005432947767	11605	5	4C
0005433074242	11605	6	4F
0005433074232	11605	7	5A
0005432947775	11605	8	6A
0005432947766	11605	9	6C
0005433074238	11605	10	6D
0005433074254	11605	11	7A
0005432192268	11605	12	7C
0005433074231	11605	13	8A
0005432947777	11605	14	8B
0005432947770	11605	15	8E
0005432947768	11605	16	9B
0005433074244	11605	17	9A
0005433074246	11605	18	9E
0005433134064	11605	19	10A
0005432192269	11605	20	10B
0005432947797	11605	21	10D
0005432947776	11605	22	10F
0005432947779	11605	23	11A
0005433074252	11605	24	11C
0005433074248	11605	25	11E
0005433131634	11605	26	11F
0005432947793	11605	27	12A
0005432947791	11605	28	12B
0005432947769	11605	29	12D
0005433074236	11605	30	13A
0005432947800	11605	31	13D
0005433074241	11605	32	13F
0005432947784	11605	33	14C
0005433074226	11605	34	14E
0005432947787	11605	35	15C
0005432947786	11605	36	15D
0005432192266	11605	37	15F
0005432947796	11605	38	16B
0005432947764	11605	39	16E
0005432947771	11605	40	17A
0005433074227	11605	41	17C
0005433074233	11605	42	17E
0005432947803	11605	43	18A
0005432192267	11605	44	18C
0005433074247	11605	45	18D
0005432947789	11605	46	18E
0005432947794	11605	47	19B
0005432947780	11605	48	18F
0005433134062	11605	49	19D
0005432947788	11605	50	20C
0005433074240	11605	51	20D
0005433131632	11605	52	20E
0005433074229	11605	53	21B
0005433134063	11605	54	21E
0005433074237	11605	55	22A
0005432947778	11605	56	21F
0005432947799	11605	57	22D
0005432947765	11605	58	22E
0005432947772	11605	59	23A
0005432947795	11605	60	23B
0005433074230	11605	61	23E
0005433074253	11605	62	23F
0005433131631	11605	63	24B
0005433074245	11605	64	24D
0005432947804	11605	65	24C
0005432947783	11605	66	24E
0005433074243	11605	67	25C
0005432947792	11605	68	26A
0005432947782	11605	69	25F
0005433074239	11605	70	26B
0005432947774	11605	71	26D
0005432947790	11605	72	26C
0005433131630	11605	73	26E
0005433134060	11605	74	27C
0005433074250	11605	75	27B
0005433074228	11605	76	27D
0005433074249	11605	77	27F
0005433134061	11605	78	28A
0005432947781	11605	79	28E
0005433074251	11605	80	29B
0005432947801	11605	81	30F
0005433131633	11605	82	31A
0005433074235	11605	83	31B
0005432947773	11605	84	31E
0005433817409	10037	1	4A
0005433817411	10037	2	3B
0005433817408	10037	3	5A
0005433817410	10037	4	6A
0005434732924	13972	1	1B
0005434732922	13972	2	4B
0005434732925	13972	3	5A
0005434732923	13972	4	6B
0005433753307	2370	1	1A
0005435981586	2370	2	1C
0005433753299	2370	3	1F
0005435981560	2370	4	2B
0005435981576	2370	5	2F
0005435981565	2370	6	2C
0005432655339	2370	7	2G
0005435981559	2370	8	3B
0005433753329	2370	9	3C
0005435981567	2370	10	3G
0005433753323	2370	11	3H
0005433753300	2370	12	4C
0005435981561	2370	13	4G
0005433753288	2370	14	4H
0005433753309	2370	15	5B
0005435981558	2370	16	5C
0005435981564	2370	17	5G
0005433753333	2370	18	5F
0005433753331	2370	19	5H
0005432655347	2370	20	9B
0005433766579	2370	21	9A
0005433753281	2370	22	9G
0005433753335	2370	23	11B
0005435981589	2370	24	11F
0005432300169	2370	25	11H
0005432225956	2370	26	12B
0005433753330	2370	27	12A
0005435981571	2370	28	12D
0005432300170	2370	29	12E
0005435981588	2370	30	12F
0005432225954	2370	31	12H
0005433753321	2370	32	12G
0005435981574	2370	33	13B
0005433753308	2370	34	13A
0005433753314	2370	35	13D
0005433753327	2370	36	13G
0005433753294	2370	37	13H
0005433766576	2370	38	14B
0005433753291	2370	39	14D
0005433753310	2370	40	14G
0005433753334	2370	41	15B
0005433753284	2370	42	15D
0005432300168	2370	43	15F
0005433753304	2370	44	15H
0005435981583	2370	45	16A
0005433753326	2370	46	16B
0005435981590	2370	47	17A
0005435981581	2370	48	17D
0005433766578	2370	49	17E
0005433753282	2370	50	17F
0005433764645	2370	51	18A
0005432300167	2370	52	18D
0005435981569	2370	53	18B
0005435981572	2370	54	18E
0005433753320	2370	55	18G
0005433753280	2370	56	19A
0005432655338	2370	57	18H
0005432225958	2370	58	19D
0005435981568	2370	59	19F
0005435981584	2370	60	19G
0005435981552	2370	61	20D
0005432655340	2370	62	20F
0005433753328	2370	63	20H
0005435981551	2370	64	21A
0005433753317	2370	65	21B
0005433764646	2370	66	21E
0005435981573	2370	67	22A
0005433753319	2370	68	22F
0005435981548	2370	69	22E
0005435981577	2370	70	22G
0005433753311	2370	71	23A
0005433753293	2370	72	23B
0005433753295	2370	73	23D
0005432655346	2370	74	23F
0005433766580	2370	75	23H
0005433753298	2370	76	23G
0005432655342	2370	77	24A
0005435981570	2370	78	24B
0005433753302	2370	79	24H
0005432225953	2370	80	25D
0005435981587	2370	81	25F
0005433766577	2370	82	27D
0005433753296	2370	83	27F
0005433753312	2370	84	27E
0005435981592	2370	85	27H
0005435981591	2370	86	28A
0005432300171	2370	87	28D
0005432655344	2370	88	28E
0005435981555	2370	89	28F
0005435981585	2370	90	29A
0005433753332	2370	91	28H
0005435981575	2370	92	29D
0005433753322	2370	93	29B
0005435981553	2370	94	29E
0005433753287	2370	95	29F
0005432655348	2370	96	30B
0005433753289	2370	97	30D
0005435981562	2370	98	30F
0005435981549	2370	99	30H
0005433753283	2370	100	31A
0005433753286	2370	101	31E
0005433753290	2370	102	31G
0005433753279	2370	103	31H
0005433753285	2370	104	32D
0005435981550	2370	105	32G
0005435981566	2370	106	33A
0005433753318	2370	107	33B
0005433753297	2370	108	33F
0005433753306	2370	109	33H
0005433753292	2370	110	34A
0005432655343	2370	111	34D
0005433753324	2370	112	34E
0005435981580	2370	113	34H
0005432225959	2370	114	35A
0005432655345	2370	115	35D
0005435981593	2370	116	35E
0005435981563	2370	117	35G
0005433753316	2370	118	36A
0005435981557	2370	119	36D
0005432655349	2370	120	36E
0005435981556	2370	121	36G
0005432655341	2370	122	37A
0005432225957	2370	123	36H
0005435981554	2370	124	37B
0005433753301	2370	125	37E
0005433753303	2370	126	37D
0005435981579	2370	127	37F
0005432225955	2370	128	38A
0005435981582	2370	129	38B
0005432300166	2370	130	38E
0005433753313	2370	131	38D
0005435981578	2370	132	38H
0005433753325	2370	133	38G
0005433753315	2370	134	39F
0005433753305	2370	135	39E
0005432984559	26174	1	1C
0005433434217	26174	2	1B
0005433434210	26174	3	2C
0005432984541	26174	4	2H
0005433434225	26174	5	2G
0005433434212	26174	6	3F
0005432984550	26174	7	3C
0005432984551	26174	8	4A
0005432869413	26174	9	4G
0005433434211	26174	10	4H
0005433434236	26174	11	5C
0005432984552	26174	12	5G
0005432984540	26174	13	11E
0005433434220	26174	14	11D
0005433434228	26174	15	11F
0005432984536	26174	16	11G
0005433434209	26174	17	12B
0005432869414	26174	18	12E
0005432984555	26174	19	12D
0005434731102	26174	20	12F
0005432984543	26174	21	13G
0005433434218	26174	22	14A
0005433434234	26174	23	14F
0005432984546	26174	24	14G
0005433434226	26174	25	15A
0005432984544	26174	26	15F
0005432984564	26174	27	16B
0005433434221	26174	28	16D
0005433434231	26174	29	16F
0005432869416	26174	30	16H
0005433434213	26174	31	17B
0005432984542	26174	32	17E
0005433434229	26174	33	17H
0005433434232	26174	34	18D
0005432984534	26174	35	19A
0005432984557	26174	36	19E
0005432869415	26174	37	20A
0005432984554	26174	38	20H
0005432984556	26174	39	21A
0005432051078	26174	40	21B
0005433434233	26174	41	22A
0005432049405	26174	42	22D
0005434731101	26174	43	22G
0005434731100	26174	44	22H
0005432984561	26174	45	23G
0005432984545	26174	46	23H
0005432984537	26174	47	24B
0005433434223	26174	48	24D
0005432984535	26174	49	24H
0005432049406	26174	50	28E
0005433434227	26174	51	28D
0005434731103	26174	52	28H
0005433434230	26174	53	28G
0005432984560	26174	54	29B
0005432984549	26174	55	29E
0005432984538	26174	56	30E
0005432049404	26174	57	31A
0005433434222	26174	58	32A
0005433434224	26174	59	32F
0005432984558	26174	60	32H
0005432984566	26174	61	33B
0005433434216	26174	62	33D
0005433434235	26174	63	33H
0005432984553	26174	64	34A
0005433434219	26174	65	34G
0005432984547	26174	66	35A
0005432984562	26174	67	35D
0005432869412	26174	68	35G
0005432984533	26174	69	36B
0005432051077	26174	70	36H
0005432984539	26174	71	36G
0005432984563	26174	72	37A
0005433434214	26174	73	37D
0005432984565	26174	74	37F
0005432049403	26174	75	38B
0005432984548	26174	76	38D
0005433434215	26174	77	38H
0005434373922	1502	1	1A
0005434373934	1502	2	1C
0005432267783	1502	3	1D
0005434373944	1502	4	1F
0005434373928	1502	5	2F
0005434373920	1502	6	3F
0005434373931	1502	7	4D
0005434373900	1502	8	4C
0005434373905	1502	9	4E
0005434373919	1502	10	5A
0005432267787	1502	11	4F
0005434373915	1502	12	5C
0005434373910	1502	13	5E
0005434373914	1502	14	6A
0005434373936	1502	15	6C
0005432267786	1502	16	6D
0005434373902	1502	17	7C
0005432267784	1502	18	7B
0005434373935	1502	19	7E
0005434373940	1502	20	7F
0005434373933	1502	21	9A
0005434373937	1502	22	9C
0005433461553	1502	23	10B
0005434373912	1502	24	11B
0005434373907	1502	25	11F
0005432267789	1502	26	11E
0005434373899	1502	27	12F
0005434373926	1502	28	13A
0005434373908	1502	29	13B
0005434373932	1502	30	13D
0005434373942	1502	31	13C
0005434373941	1502	32	13F
0005434373901	1502	33	14A
0005434373930	1502	34	14D
0005434373925	1502	35	14F
0005434373903	1502	36	14E
0005434373916	1502	37	15A
0005434373939	1502	38	15C
0005434373924	1502	39	16B
0005434373929	1502	40	16F
0005434373906	1502	41	16E
0005433461552	1502	42	17B
0005434373917	1502	43	17A
0005434373911	1502	44	17C
0005434373943	1502	45	17D
0005434373918	1502	46	18A
0005434373927	1502	47	19D
0005434373913	1502	48	20B
0005434373898	1502	49	20C
0005433460400	1502	50	20F
0005434373938	1502	51	21B
0005434373909	1502	52	21C
0005432267785	1502	53	21D
0005434373904	1502	54	22C
0005432267788	1502	55	22D
0005434373923	1502	56	22E
0005434373921	1502	57	22F
0005433460401	1502	58	23F
0005433150840	20115	1	1A
0005433150847	20115	2	1D
0005433150861	20115	3	2A
0005433150850	20115	4	3A
0005434029617	20115	5	3D
0005434029616	20115	6	4A
0005433150833	20115	7	3F
0005433150837	20115	8	4B
0005433150856	20115	9	5D
0005432056235	20115	10	6F
0005433150836	20115	11	6E
0005433150849	20115	12	7C
0005433150842	20115	13	7D
0005433931417	20115	14	8A
0005433931419	20115	15	9D
0005433150843	20115	16	9F
0005433150832	20115	17	10E
0005433150852	20115	18	11E
0005433150853	20115	19	11F
0005433150851	20115	20	12C
0005433150848	20115	21	12D
0005433150829	20115	22	13B
0005433150863	20115	23	13C
0005433150860	20115	24	13F
0005433150831	20115	25	14A
0005432056238	20115	26	14D
0005433764645	20115	27	14E
0005433150845	20115	28	14F
0005433764646	20115	29	15C
0005433931418	20115	30	15E
0005432056236	20115	31	16A
0005433150854	20115	32	16C
0005433150834	20115	33	16E
0005433150839	20115	34	17A
0005433150830	20115	35	16F
0005432056237	20115	36	17B
0005433150846	20115	37	17D
0005433150838	20115	38	18A
0005433150858	20115	39	17F
0005433150841	20115	40	18E
0005433150857	20115	41	19A
0005434029618	20115	42	20A
0005433150859	20115	43	20E
0005433150855	20115	44	21F
0005433150862	20115	45	22B
0005433150828	20115	46	22D
0005433150835	20115	47	22F
0005433150844	20115	48	23A
0005432423653	585	1	1F
0005432423678	585	2	2C
0005432423665	585	3	2F
0005432423662	585	4	3C
0005432423692	585	5	3F
0005432423675	585	6	4C
0005432423686	585	7	4F
0005432423684	585	8	5D
0005432423682	585	9	6A
0005432423691	585	10	6D
0005432423685	585	11	6C
0005432423671	585	12	7C
0005432423661	585	13	8A
0005432423690	585	14	8D
0005432282749	585	15	9F
0005432282752	585	16	11A
0005432423680	585	17	11B
0005432282751	585	18	11D
0005432423683	585	19	11F
0005432423673	585	20	12A
0005432423679	585	21	13D
0005432282750	585	22	13F
0005432282748	585	23	14B
0005432423660	585	24	15A
0005432423676	585	25	15F
0005432423669	585	26	16B
0005432282754	585	27	16E
0005432423658	585	28	17A
0005432282747	585	29	17F
0005432423693	585	30	18D
0005432282753	585	31	18E
0005432423668	585	32	19B
0005432423664	585	33	20B
0005432423681	585	34	20E
0005432423674	585	35	21A
0005432423663	585	36	21B
0005432423688	585	37	21E
0005432423667	585	38	22E
0005432423649	585	39	22F
0005432423657	585	40	23C
0005432423672	585	41	23E
0005432423689	585	42	24B
0005432423659	585	43	24F
0005432423652	585	44	25B
0005432423677	585	45	25C
0005432423687	585	46	26C
0005432423648	585	47	27B
0005432423650	585	48	27D
0005432423654	585	49	27F
0005432423670	585	50	28C
0005432423655	585	51	28B
0005432423656	585	52	28D
0005432423651	585	53	30C
0005432423666	585	54	31D
0005432302267	12907	1	10C
0005432302271	12907	2	19C
0005432302270	12907	3	26F
0005432302268	12907	4	29B
0005432302269	12907	5	30C
0005434022601	487	1	1C
0005434022621	487	2	1B
0005434022611	487	3	1G
0005434022594	487	4	1H
0005434022605	487	5	3B
0005434031946	487	6	3C
0005434022618	487	7	3G
0005434022579	487	8	4C
0005434022613	487	9	4G
0005434022631	487	10	4H
0005434022622	487	11	5G
0005434022625	487	12	9H
0005434022610	487	13	11B
0005434022630	487	14	11E
0005434022602	487	15	11G
0005432235515	487	16	12E
0005434022638	487	17	12F
0005434022629	487	18	13B
0005434022587	487	19	13G
0005432235516	487	20	14A
0005434029615	487	21	14D
0005434022606	487	22	14E
0005432235517	487	23	14H
0005432045579	487	24	15D
0005434022597	487	25	15G
0005434022620	487	26	16D
0005434022578	487	27	16H
0005434022571	487	28	17B
0005434022590	487	29	17G
0005434022582	487	30	18D
0005434022584	487	31	18G
0005434022633	487	32	19B
0005434022577	487	33	20H
0005434022615	487	34	20G
0005434028246	487	35	21G
0005434022627	487	36	21F
0005432235513	487	37	21H
0005434022592	487	38	23A
0005434022637	487	39	22H
0005432235518	487	40	23B
0005434022608	487	41	23D
0005434022583	487	42	23E
0005434022570	487	43	23G
0005434022635	487	44	23H
0005434022616	487	45	24E
0005434022609	487	46	24F
0005434022595	487	47	24G
0005434022624	487	48	25D
0005434022572	487	49	25F
0005434022585	487	50	27A
0005434029614	487	51	27E
0005434022576	487	52	27D
0005434022619	487	53	27F
0005434022628	487	54	27H
0005434022588	487	55	28F
0005434022580	487	56	28H
0005434022607	487	57	28G
0005434022623	487	58	29D
0005432045581	487	59	29B
0005434022636	487	60	29F
0005434022573	487	61	30A
0005434029613	487	62	30G
0005434022589	487	63	31A
0005434022586	487	64	30H
0005434022634	487	65	31B
0005432045580	487	66	31D
0005434022581	487	67	31F
0005434022574	487	68	31G
0005434031947	487	69	32B
0005434022598	487	70	32F
0005434022593	487	71	32G
0005434031944	487	72	33E
0005434028249	487	73	33F
0005434022632	487	74	34B
0005434022612	487	75	34A
0005434022599	487	76	34G
0005434031945	487	77	34F
0005434022603	487	78	35A
0005434028247	487	79	35G
0005434022596	487	80	36A
0005434022575	487	81	36F
0005432235514	487	82	36E
0005434022614	487	83	36H
0005434022600	487	84	38A
0005434022591	487	85	38B
0005434022617	487	86	38E
0005434028248	487	87	38H
0005434022626	487	88	39D
0005434022604	487	89	39F
0005433057209	12658	1	2C
0005433057223	12658	2	3G
0005433057225	12658	3	4A
0005433057237	12658	4	4B
0005433057248	12658	5	5A
0005433057247	12658	6	9B
0005433057238	12658	7	11A
0005433057227	12658	8	11D
0005434735603	12658	9	11B
0005432157459	12658	10	11E
0005433057231	12658	11	11F
0005433057242	12658	12	11H
0005433057224	12658	13	12D
0005433057212	12658	14	12G
0005433057236	12658	15	13B
0005433057217	12658	16	13F
0005433057240	12658	17	13H
0005433057219	12658	18	14B
0005433057211	12658	19	14E
0005433929546	12658	20	15D
0005433684388	12658	21	16B
0005432156293	12658	22	16F
0005433057246	12658	23	17B
0005433057214	12658	24	18A
0005433684387	12658	25	19A
0005433929543	12658	26	19D
0005433057229	12658	27	19G
0005433057213	12658	28	21B
0005433057239	12658	29	21G
0005433057249	12658	30	22E
0005433057226	12658	31	22G
0005433057220	12658	32	22H
0005433057216	12658	33	23B
0005433057232	12658	34	23A
0005434735604	12658	35	23E
0005433057228	12658	36	23G
0005432156292	12658	37	24H
0005432156291	12658	38	24G
0005433057234	12658	39	27G
0005433057222	12658	40	27H
0005433057243	12658	41	28G
0005433057210	12658	42	29A
0005433929545	12658	43	28H
0005433057218	12658	44	29F
0005432156294	12658	45	29G
0005433057244	12658	46	30B
0005434735606	12658	47	31B
0005433057241	12658	48	31D
0005433057215	12658	49	31G
0005433057233	12658	50	32B
0005433057230	12658	51	32D
0005432157460	12658	52	34B
0005433684386	12658	53	35B
0005434735602	12658	54	36B
0005433057221	12658	55	37E
0005433057245	12658	56	37H
0005433929544	12658	57	37G
0005433057235	12658	58	38D
0005434735605	12658	59	39F
0005433921738	2153	1	1A
0005433921753	2153	2	1C
0005433921767	2153	3	1F
0005433921770	2153	4	2A
0005433921771	2153	5	1H
0005433921692	2153	6	2B
0005432044478	2153	7	2H
0005433921776	2153	8	2G
0005433921775	2153	9	3A
0005433921711	2153	10	3B
0005433921742	2153	11	3C
0005433929545	2153	12	3G
0005433921710	2153	13	4A
0005433921705	2153	14	4G
0005433921780	2153	15	5A
0005433921694	2153	16	5B
0005433921724	2153	17	5C
0005433921723	2153	18	9G
0005432044480	2153	19	11A
0005433921726	2153	20	11B
0005433921708	2153	21	11E
0005433921699	2153	22	12A
0005433921766	2153	23	12D
0005433921762	2153	24	12E
0005433921768	2153	25	12F
0005432231392	2153	26	13A
0005433921712	2153	27	13D
0005432231385	2153	28	13G
0005432231390	2153	29	13F
0005433921741	2153	30	13H
0005433921747	2153	31	14F
0005433921758	2153	32	14G
0005433921769	2153	33	14H
0005433921717	2153	34	15B
0005433929546	2153	35	15G
0005433921764	2153	36	16A
0005433921736	2153	37	16E
0005432231394	2153	38	16F
0005433921707	2153	39	17A
0005433921749	2153	40	17E
0005433921713	2153	41	17G
0005433921743	2153	42	17H
0005433921687	2153	43	18A
0005432231389	2153	44	18D
0005433921730	2153	45	18E
0005432231391	2153	46	18G
0005433921688	2153	47	19A
0005433921746	2153	48	18H
0005433921728	2153	49	19F
0005432231395	2153	50	19H
0005433921695	2153	51	19G
0005433921754	2153	52	20E
0005433921716	2153	53	20D
0005433921706	2153	54	20F
0005433921781	2153	55	21A
0005432231396	2153	56	20H
0005433921773	2153	57	21E
0005433921685	2153	58	21F
0005433921757	2153	59	21G
0005433875352	2153	60	22B
0005432044479	2153	61	22E
0005433921709	2153	62	22G
0005433921714	2153	63	22F
0005433921745	2153	64	23A
0005433921691	2153	65	23B
0005433921732	2153	66	23F
0005433921689	2153	67	23G
0005433921719	2153	68	23H
0005433921697	2153	69	24B
0005433921759	2153	70	24E
0005433921761	2153	71	24F
0005433921721	2153	72	25E
0005433921720	2153	73	25D
0005433921750	2153	74	25F
0005433921735	2153	75	27F
0005433921715	2153	76	27H
0005433931417	2153	77	27G
0005433921698	2153	78	28A
0005433921703	2153	79	28B
0005433921777	2153	80	28F
0005433921700	2153	81	28H
0005433921774	2153	82	29B
0005433921772	2153	83	29G
0005433921778	2153	84	29F
0005433921718	2153	85	29H
0005433931418	2153	86	30B
0005433921727	2153	87	30E
0005433921729	2153	88	30D
0005433921740	2153	89	30G
0005433931419	2153	90	31A
0005433921686	2153	91	30H
0005433921690	2153	92	31B
0005433921702	2153	93	31E
0005433921765	2153	94	32A
0005433921782	2153	95	31H
0005433921748	2153	96	32B
0005432231388	2153	97	32E
0005433921737	2153	98	32F
0005433921751	2153	99	32G
0005433921696	2153	100	33A
0005433929543	2153	101	33D
0005433921701	2153	102	34D
0005433921752	2153	103	35A
0005433921733	2153	104	34H
0005433921693	2153	105	35B
0005433921755	2153	106	35F
0005433921734	2153	107	35E
0005433921756	2153	108	35H
0005433921739	2153	109	36A
0005433921725	2153	110	36E
0005433921744	2153	111	36F
0005433921779	2153	112	36H
0005432231393	2153	113	36G
0005432231386	2153	114	37A
0005433921760	2153	115	37F
0005433929544	2153	116	37H
0005433921722	2153	117	37G
0005432231387	2153	118	38A
0005433921731	2153	119	38D
0005433921763	2153	120	38F
0005433921704	2153	121	39F
0005432749750	24129	1	1B
0005433035446	24129	2	1A
0005433035440	24129	3	1C
0005433035444	24129	4	1F
0005433035449	24129	5	2B
0005433035425	24129	6	2F
0005434028252	24129	7	3B
0005433035430	24129	8	3F
0005432207620	24129	9	4A
0005434028251	24129	10	4G
0005433035426	24129	11	4H
0005433035431	24129	12	5B
0005433035445	24129	13	5F
0005433035442	24129	14	9A
0005433035457	24129	15	9G
0005433035415	24129	16	11G
0005432206102	24129	17	12A
0005433035439	24129	18	14E
0005433035419	24129	19	15G
0005433035421	24129	20	16A
0005433035463	24129	21	16G
0005433035452	24129	22	16F
0005433035450	24129	23	16H
0005432207621	24129	24	17A
0005433035437	24129	25	17E
0005434028250	24129	26	18A
0005433035462	24129	27	18D
0005433035422	24129	28	18E
0005433035428	24129	29	18G
0005433035424	24129	30	19E
0005433035448	24129	31	20D
0005433035435	24129	32	20F
0005433035458	24129	33	21B
0005433035427	24129	34	21H
0005433035456	24129	35	22H
0005433035454	24129	36	23B
0005432206100	24129	37	23A
0005432749749	24129	38	23D
0005432206101	24129	39	23E
0005433035412	24129	40	24D
0005433035411	24129	41	24F
0005432207619	24129	42	24E
0005433035461	24129	43	24G
0005433035429	24129	44	24H
0005433035420	24129	45	27E
0005433035416	24129	46	28A
0005433035418	24129	47	28E
0005433035432	24129	48	29D
0005433035433	24129	49	29G
0005433035453	24129	50	29H
0005433035459	24129	51	30B
0005432206098	24129	52	30D
0005434028253	24129	53	31A
0005433035413	24129	54	30H
0005432206097	24129	55	31F
0005433035455	24129	56	31H
0005433035443	24129	57	32E
0005433035438	24129	58	32F
0005433035451	24129	59	32H
0005432206099	24129	60	33F
0005433035436	24129	61	34H
0005433035414	24129	62	35D
0005433035423	24129	63	35E
0005433035447	24129	64	35H
0005433035417	24129	65	36E
0005433035460	24129	66	36H
0005433035441	24129	67	38A
0005433035434	24129	68	39F
0005434723483	288	1	1C
0005435142360	288	2	1G
0005434550314	288	3	1K
0005432277589	288	4	2A
0005434723489	288	5	2G
0005432277585	288	6	3C
0005434723440	288	7	3G
0005434550368	288	8	4A
0005434550335	288	9	3K
0005435142349	288	10	4G
0005434550325	288	11	4H
0005434723537	288	12	5D
0005434735598	288	13	5C
0005434723556	288	14	5H
0005434723504	288	15	5G
0005434723435	288	16	11C
0005434723540	288	17	5K
0005434723441	288	18	11E
0005434550364	288	19	11D
0005434723548	288	20	11F
0005434723502	288	21	11K
0005434550351	288	22	11H
0005434550330	288	23	12A
0005434550316	288	24	12E
0005432277584	288	25	12H
0005434731096	288	26	12G
0005432277591	288	27	12K
0005434723505	288	28	13F
0005434723511	288	29	13E
0005435142358	288	30	13H
0005434723453	288	31	14D
0005434723498	288	32	14C
0005432277582	288	33	15E
0005434723475	288	34	15D
0005434550365	288	35	15H
0005434723536	288	36	15G
0005434723452	288	37	15F
0005432277587	288	38	16D
0005434723543	288	39	16F
0005435142353	288	40	16K
0005432277594	288	41	16G
0005432277592	288	42	17C
0005434723469	288	43	17A
0005434723487	288	44	17E
0005434550354	288	45	17G
0005434550357	288	46	17F
0005434723527	288	47	18A
0005434723507	288	48	17K
0005434735599	288	49	17H
0005434723519	288	50	18C
0005434731098	288	51	18B
0005434550362	288	52	18D
0005434723438	288	53	18F
0005434723459	288	54	18H
0005434550312	288	55	19D
0005434550341	288	56	19F
0005434550336	288	57	19E
0005435142357	288	58	20A
0005434723521	288	59	19K
0005434735601	288	60	19J
0005434723555	288	61	20G
0005434723526	288	62	20F
0005434550337	288	63	20K
0005434723530	288	64	21B
0005434723468	288	65	21D
0005434723456	288	66	21C
0005434550355	288	67	21G
0005435142352	288	68	21F
0005434550349	288	69	21H
0005435142356	288	70	21K
0005434723466	288	71	22B
0005434723494	288	72	22E
0005434723508	288	73	22D
0005434723454	288	74	22G
0005432277583	288	75	22F
0005435142361	288	76	23B
0005434723518	288	77	23A
0005432277595	288	78	23D
0005434723500	288	79	23C
0005434723471	288	80	23F
0005434723478	288	81	23J
0005434723465	288	82	23G
0005434550350	288	83	23K
0005434723464	288	84	25C
0005435142355	288	85	25B
0005434723506	288	86	25F
0005434550360	288	87	25E
0005434302388	288	88	25G
0005434550353	288	89	25K
0005434550317	288	90	26E
0005434550333	288	91	26D
0005434550334	288	92	26F
0005434723541	288	93	26H
0005434550318	288	94	27B
0005434723534	288	95	27A
0005434550363	288	96	26K
0005434723538	288	97	27D
0005434550359	288	98	27H
0005434723503	288	99	27G
0005434723446	288	100	28B
0005434723515	288	101	28C
0005434723514	288	102	28J
0005434302387	288	103	28H
0005434723522	288	104	29A
0005434550323	288	105	29E
0005434723532	288	106	29D
0005434723473	288	107	30A
0005434723474	288	108	30E
0005434723513	288	109	30F
0005434723450	288	110	30J
0005435142351	288	111	31B
0005434723510	288	112	31A
0005434550358	288	113	31D
0005434723444	288	114	31F
0005434723463	288	115	31E
0005434723445	288	116	31H
0005435142350	288	117	31J
0005434723470	288	118	32E
0005434735597	288	119	32D
0005432277593	288	120	32C
0005434723436	288	121	32G
0005434723523	288	122	32F
0005434550345	288	123	33A
0005434723476	288	124	33C
0005434723492	288	125	33F
0005434550332	288	126	33E
0005434723488	288	127	33H
0005435142359	288	128	33K
0005434723525	288	129	34A
0005434723486	288	130	34G
0005434723437	288	131	35A
0005434550339	288	132	35D
0005434550367	288	133	35B
0005432277596	288	134	35F
0005434723451	288	135	35J
0005434550343	288	136	35H
0005434550352	288	137	35G
0005434723449	288	138	36A
0005434550348	288	139	35K
0005434723458	288	140	36C
0005434723533	288	141	36B
0005434723493	288	142	36D
0005434550324	288	143	36G
0005434723439	288	144	36F
0005434723460	288	145	37B
0005434723484	288	146	37A
0005434723529	288	147	37F
0005434723472	288	148	37E
0005434723550	288	149	37H
0005434723481	288	150	38A
0005434302390	288	151	37K
0005434723545	288	152	38C
0005434723447	288	153	39C
0005434723479	288	154	39F
0005434723495	288	155	39E
0005434723448	288	156	39G
0005434550331	288	157	40A
0005434550347	288	158	39K
0005432277586	288	159	40K
0005435142362	288	160	40H
0005434550327	288	161	41A
0005434723553	288	162	41D
0005434723551	288	163	41C
0005434550328	288	164	41G
0005434550356	288	165	41F
0005434723554	288	166	41E
0005434550340	288	167	41H
0005434550346	288	168	42A
0005434723501	288	169	41K
0005434723482	288	170	41J
0005434723485	288	171	42C
0005435142354	288	172	42E
0005434723462	288	173	42D
0005434723546	288	174	42H
0005434723509	288	175	43B
0005434550338	288	176	43A
0005434723467	288	177	42K
0005434723528	288	178	43D
0005434723461	288	179	43C
0005434550322	288	180	43F
0005434723496	288	181	43E
0005434723517	288	182	43G
0005434723544	288	183	43K
0005434723443	288	184	43J
0005434731099	288	185	44B
0005434550366	288	186	44A
0005434302389	288	187	44E
0005434723457	288	188	44C
0005434723434	288	189	44G
0005432277588	288	190	44K
0005434723535	288	191	44J
0005434550321	288	192	45B
0005434723455	288	193	45D
0005434550326	288	194	45C
0005434723520	288	195	45F
0005434723531	288	196	45E
0005434723512	288	197	45G
0005434302386	288	198	45K
0005434735600	288	199	45J
0005434550313	288	200	46C
0005432277590	288	201	46E
0005434723516	288	202	47C
0005434550315	288	203	46K
0005434723524	288	204	47E
0005434723542	288	205	47G
0005434550320	288	206	47F
0005434723547	288	207	48A
0005434723497	288	208	47K
0005434550342	288	209	48C
0005434723442	288	210	48F
0005434723499	288	211	48E
0005434550344	288	212	48D
0005434723549	288	213	49A
0005434550361	288	214	49D
0005434550319	288	215	49C
0005434723552	288	216	49K
0005434550329	288	217	49H
0005434723491	288	218	49G
0005434723480	288	219	50D
0005434723477	288	220	50F
0005434723539	288	221	51D
0005434723490	288	222	51F
0005434731097	288	223	51G
0005433233166	9841	1	2C
0005433233186	9841	2	2H
0005433233195	9841	3	2D
0005433233170	9841	4	2K
0005433233153	9841	5	3D
0005433180691	9841	6	4D
0005433180699	9841	7	5C
0005433233204	9841	8	5A
0005433180697	9841	9	5G
0005433180693	9841	10	5D
0005433289725	9841	11	11D
0005433180696	9841	12	11C
0005433233188	9841	13	11E
0005433289728	9841	14	12F
0005433289730	9841	15	13A
0005433126768	9841	16	15C
0005433233208	9841	17	15D
0005433180679	9841	18	15G
0005433180694	9841	19	15F
0005433233205	9841	20	15K
0005433233206	9841	21	16E
0005432199131	9841	22	16K
0005433233152	9841	23	16G
0005433766578	9841	24	17H
0005433180680	9841	25	18C
0005433233158	9841	26	18B
0005432199136	9841	27	18G
0005433233198	9841	28	18J
0005433289727	9841	29	19A
0005433126770	9841	30	19D
0005433233184	9841	31	19C
0005433129201	9841	32	19E
0005433180688	9841	33	19K
0005432199135	9841	34	19J
0005433180686	9841	35	20C
0005433180689	9841	36	20B
0005433233151	9841	37	20H
0005433233161	9841	38	20G
0005433233150	9841	39	21A
0005433180684	9841	40	20K
0005433766580	9841	41	21G
0005433233187	9841	42	21H
0005433233155	9841	43	22E
0005432199130	9841	44	23B
0005433233154	9841	45	23D
0005433766579	9841	46	23J
0005433233159	9841	47	24D
0005433233197	9841	48	23K
0005433233190	9841	49	24F
0005433233189	9841	50	24E
0005433233173	9841	51	25A
0005433766576	9841	52	24G
0005433233168	9841	53	25C
0005433233196	9841	54	25G
0005433180675	9841	55	26A
0005433180681	9841	56	26K
0005433129198	9841	57	27D
0005433233180	9841	58	28A
0005434031949	9841	59	28E
0005433233147	9841	60	28J
0005434031952	9841	61	28H
0005433233160	9841	62	28K
0005433113498	9841	63	29C
0005433233172	9841	64	29E
0005433233164	9841	65	29H
0005433180678	9841	66	30C
0005433180676	9841	67	30G
0005433180700	9841	68	30J
0005433233177	9841	69	30H
0005433766577	9841	70	31D
0005433233181	9841	71	31H
0005433129200	9841	72	31G
0005433129199	9841	73	32C
0005433233163	9841	74	33F
0005433233194	9841	75	33E
0005433233199	9841	76	33H
0005433126769	9841	77	34E
0005433233185	9841	78	35C
0005433126771	9841	79	35E
0005433233176	9841	80	35G
0005433180690	9841	81	35K
0005433233192	9841	82	36G
0005433180683	9841	83	36F
0005432199133	9841	84	36H
0005433233169	9841	85	37B
0005433233148	9841	86	37A
0005434031951	9841	87	37D
0005433180685	9841	88	37E
0005433180674	9841	89	37J
0005433233156	9841	90	37H
0005433180692	9841	91	39B
0005434031950	9841	92	39A
0005433233157	9841	93	39F
0005433233203	9841	94	40A
0005433233167	9841	95	40C
0005433233165	9841	96	40F
0005433233145	9841	97	40K
0005433233182	9841	98	41D
0005433113497	9841	99	41F
0005433233183	9841	100	41H
0005433113499	9841	101	41G
0005433233201	9841	102	42C
0005433180682	9841	103	42F
0005433233146	9841	104	42K
0005433180695	9841	105	43B
0005433233162	9841	106	44B
0005433180687	9841	107	44E
0005433233171	9841	108	45A
0005432199134	9841	109	44K
0005433233179	9841	110	45J
0005433233175	9841	111	45G
0005433289729	9841	112	46A
0005433233207	9841	113	45K
0005433289726	9841	114	46C
0005433233149	9841	115	46B
0005433233191	9841	116	46G
0005433233200	9841	117	46J
0005433180677	9841	118	48F
0005433233144	9841	119	48D
0005432199132	9841	120	48H
0005433180698	9841	121	49D
0005433233174	9841	122	49F
0005433233178	9841	123	49K
0005433233193	9841	124	49H
0005434031948	9841	125	50H
0005433233202	9841	126	51E
0005434066410	7717	1	1C
0005434066399	7717	2	1A
0005434066426	7717	3	1H
0005432525771	7717	4	1G
0005432525803	7717	5	2A
0005432069413	7717	6	1K
0005434066400	7717	7	2C
0005432525798	7717	8	2G
0005432525854	7717	9	3A
0005434066388	7717	10	2K
0005432525812	7717	11	2H
0005434066417	7717	12	3D
0005434066367	7717	13	3G
0005432069420	7717	14	4G
0005434066371	7717	15	4D
0005434066396	7717	16	4K
0005432525897	7717	17	4H
0005432525855	7717	18	5C
0005432150063	7717	19	5H
0005432525786	7717	20	5G
0005432525810	7717	21	11A
0005432525881	7717	22	5K
0005432525783	7717	23	11D
0005432525789	7717	24	11C
0005432069416	7717	25	11K
0005432525895	7717	26	11H
0005432525840	7717	27	12C
0005432525872	7717	28	12A
0005434066404	7717	29	12G
0005432525831	7717	30	12F
0005434066393	7717	31	12H
0005432525900	7717	32	13D
0005434066439	7717	33	13C
0005432525861	7717	34	13F
0005432525795	7717	35	13K
0005434066395	7717	36	13H
0005434066368	7717	37	14A
0005432069423	7717	38	14D
0005434066435	7717	39	14C
0005432525793	7717	40	14F
0005434066427	7717	41	15C
0005432525860	7717	42	15E
0005432525869	7717	43	15G
0005434066406	7717	44	15F
0005432525805	7717	45	16A
0005432525837	7717	46	15K
0005432525828	7717	47	15H
0005432525856	7717	48	16F
0005432525898	7717	49	16K
0005432525780	7717	50	16H
0005432525850	7717	51	17C
0005432525870	7717	52	17H
0005432525791	7717	53	18B
0005432525838	7717	54	18A
0005432150065	7717	55	18D
0005432525825	7717	56	18C
0005432525883	7717	57	18F
0005432525817	7717	58	18K
0005432525848	7717	59	18J
0005434066416	7717	60	18H
0005432525839	7717	61	19B
0005432525773	7717	62	19A
0005432525847	7717	63	19F
0005432525772	7717	64	19E
0005432525899	7717	65	20A
0005432150066	7717	66	19K
0005434066413	7717	67	19J
0005434066389	7717	68	20B
0005432525901	7717	69	20D
0005434066418	7717	70	20G
0005432069411	7717	71	20F
0005432525887	7717	72	20H
0005432525846	7717	73	21B
0005432525845	7717	74	21A
0005432150070	7717	75	21D
0005434066429	7717	76	21K
0005434066414	7717	77	21J
0005432535751	7717	78	22D
0005434066415	7717	79	22B
0005432069422	7717	80	22F
0005434066422	7717	81	22E
0005432525862	7717	82	22G
0005434066379	7717	83	22K
0005434066377	7717	84	23A
0005432525842	7717	85	23C
0005432150068	7717	86	23J
0005432069418	7717	87	23G
0005432150069	7717	88	23K
0005434066370	7717	89	24F
0005434066405	7717	90	25A
0005432525886	7717	91	24G
0005434066382	7717	92	25D
0005432525826	7717	93	25C
0005432069419	7717	94	25B
0005432525890	7717	95	25E
0005432069409	7717	96	25J
0005432525871	7717	97	26E
0005434066372	7717	98	26F
0005434066385	7717	99	26K
0005432525792	7717	100	26J
0005432525833	7717	101	26H
0005432525822	7717	102	27D
0005432150064	7717	103	27C
0005434066387	7717	104	27B
0005432150067	7717	105	27F
0005434066381	7717	106	27E
0005434066431	7717	107	27H
0005432525866	7717	108	27G
0005432525777	7717	109	28A
0005432525781	7717	110	28C
0005432525818	7717	111	28B
0005432525844	7717	112	28E
0005432525801	7717	113	28G
0005434066420	7717	114	28J
0005432525841	7717	115	29A
0005434066375	7717	116	29D
0005432525823	7717	117	29F
0005434066421	7717	118	29E
0005432525808	7717	119	29G
0005434066408	7717	120	30A
0005432525849	7717	121	29J
0005434066432	7717	122	30C
0005432525873	7717	123	30E
0005432525836	7717	124	30D
0005434066394	7717	125	30G
0005432535750	7717	126	30F
0005432525799	7717	127	30J
0005432428871	7717	128	30K
0005432535753	7717	129	31C
0005432525769	7717	130	31E
0005432525797	7717	131	31J
0005432069421	7717	132	31G
0005432525891	7717	133	31K
0005432525820	7717	134	32C
0005434066380	7717	135	32B
0005434066433	7717	136	32E
0005432525892	7717	137	32G
0005434066398	7717	138	32J
0005432525867	7717	139	32H
0005432525782	7717	140	32K
0005432525851	7717	141	33C
0005434066383	7717	142	33F
0005432525888	7717	143	33E
0005432525882	7717	144	34A
0005432525800	7717	145	33K
0005432525864	7717	146	33J
0005432525821	7717	147	34E
0005434066425	7717	148	34D
0005434066423	7717	149	34C
0005432069415	7717	150	34K
0005434066409	7717	151	35B
0005432525843	7717	152	35A
0005432525809	7717	153	35D
0005434066407	7717	154	35C
0005432525830	7717	155	35F
0005432525877	7717	156	35E
0005432525857	7717	157	35J
0005432525859	7717	158	35H
0005432525868	7717	159	35G
0005432525816	7717	160	36A
0005432533243	7717	161	36C
0005432525879	7717	162	36B
0005432525824	7717	163	36E
0005432525775	7717	164	36H
0005434066386	7717	165	36F
0005434066402	7717	166	36J
0005432428873	7717	167	37B
0005432525896	7717	168	37A
0005432525814	7717	169	36K
0005432537022	7717	170	37F
0005434066430	7717	171	37E
0005434066411	7717	172	37J
0005432069412	7717	173	38K
0005432533245	7717	174	38J
0005432525875	7717	175	39B
0005434066424	7717	176	39A
0005432525834	7717	177	39D
0005432535752	7717	178	39C
0005434066397	7717	179	39E
0005432525788	7717	180	39H
0005434066428	7717	181	39G
0005434066437	7717	182	39K
0005432069417	7717	183	40A
0005432525811	7717	184	40G
0005432535755	7717	185	40F
0005432525819	7717	186	40K
0005434066391	7717	187	40J
0005432525880	7717	188	40H
0005432525853	7717	189	41A
0005432525784	7717	190	41D
0005432525806	7717	191	41B
0005432533246	7717	192	41F
0005432525858	7717	193	41E
0005432525813	7717	194	41J
0005432525893	7717	195	41H
0005432525804	7717	196	42A
0005432525794	7717	197	42C
0005432525852	7717	198	42E
0005432525894	7717	199	42F
0005434066434	7717	200	42J
0005432525774	7717	201	42H
0005432525796	7717	202	43B
0005434066390	7717	203	43C
0005432525790	7717	204	43F
0005434066401	7717	205	43E
0005432069410	7717	206	43G
0005434066384	7717	207	43K
0005434066438	7717	208	44E
0005434066419	7717	209	44G
0005434066392	7717	210	44F
0005432525865	7717	211	44J
0005432525768	7717	212	44H
0005432525815	7717	213	45B
0005432525778	7717	214	45A
0005432525835	7717	215	44K
0005432533244	7717	216	45D
0005432525827	7717	217	45C
0005434066436	7717	218	45E
0005432535754	7717	219	45H
0005432525770	7717	220	45K
0005432525903	7717	221	45J
0005432069414	7717	222	46A
0005432525787	7717	223	46D
0005434066369	7717	224	46G
0005432525878	7717	225	46F
0005434066378	7717	226	46K
0005434066412	7717	227	46J
0005432525876	7717	228	47A
0005432525902	7717	229	47E
0005432525832	7717	230	47D
0005432525863	7717	231	47C
0005432525779	7717	232	47K
0005432428870	7717	233	48C
0005432525807	7717	234	48F
0005432525829	7717	235	48H
0005432525802	7717	236	48K
0005434066376	7717	237	49D
0005434066373	7717	238	49C
0005432525889	7717	239	49G
0005432525785	7717	240	49E
0005434066403	7717	241	49K
0005432525885	7717	242	49H
0005432525776	7717	243	50C
0005432525874	7717	244	50A
0005434066374	7717	245	50F
0005432525884	7717	246	50K
0005432428872	7717	247	51F
0005434343650	5304	1	1H
0005435611802	5304	2	1G
0005434573123	5304	3	1D
0005435611828	5304	4	2A
0005435611825	5304	5	2D
0005435611816	5304	6	2H
0005434343621	5304	7	2G
0005435611788	5304	8	3A
0005435611789	5304	9	3G
0005435611870	5304	10	4C
0005435611813	5304	11	4D
0005435611776	5304	12	5C
0005435611866	5304	13	5H
0005434343645	5304	14	11A
0005434343630	5304	15	11D
0005435611822	5304	16	11F
0005435611841	5304	17	11H
0005435611798	5304	18	11G
0005435611796	5304	19	12C
0005435490173	5304	20	12D
0005434343646	5304	21	12K
0005432132956	5304	22	12H
0005435611799	5304	23	13C
0005434343635	5304	24	13F
0005434343620	5304	25	13H
0005434343643	5304	26	14G
0005435611781	5304	27	15C
0005434343624	5304	28	15E
0005432132965	5304	29	15D
0005435611773	5304	30	15H
0005435611868	5304	31	16A
0005435097056	5304	32	15K
0005435611793	5304	33	16C
0005435611811	5304	34	16G
0005434343634	5304	35	16E
0005435611804	5304	36	16H
0005434343642	5304	37	17C
0005435611824	5304	38	17E
0005435611815	5304	39	17D
0005435097058	5304	40	17G
0005435611854	5304	41	17F
0005435611777	5304	42	18A
0005435611827	5304	43	17K
0005434573119	5304	44	18C
0005435611839	5304	45	18B
0005432132963	5304	46	18E
0005435611838	5304	47	18D
0005435611832	5304	48	18J
0005434343636	5304	49	19B
0005435611830	5304	50	19A
0005435611821	5304	51	19C
0005435097053	5304	52	19G
0005434343617	5304	53	20A
0005435611782	5304	54	19K
0005435611847	5304	55	19J
0005434573129	5304	56	20D
0005434573121	5304	57	20G
0005435491407	5304	58	20F
0005434343625	5304	59	20J
0005435611865	5304	60	20H
0005435611872	5304	61	21A
0005434573127	5304	62	21F
0005435611867	5304	63	21E
0005435097059	5304	64	21J
0005435611790	5304	65	21K
0005434343622	5304	66	22B
0005435611806	5304	67	22H
0005434343619	5304	68	22J
0005435611837	5304	69	23E
0005435611851	5304	70	23G
0005434573126	5304	71	23F
0005432132960	5304	72	23J
0005432132967	5304	73	23K
0005435611842	5304	74	24E
0005435611856	5304	75	24D
0005435611791	5304	76	25F
0005434343641	5304	77	25H
0005434343647	5304	78	26E
0005432132962	5304	79	26D
0005434343648	5304	80	26C
0005434343631	5304	81	26F
0005435097054	5304	82	26J
0005435611819	5304	83	27B
0005434343649	5304	84	27D
0005435611848	5304	85	27F
0005435611852	5304	86	27E
0005435611874	5304	87	27K
0005432132969	5304	88	27J
0005435611810	5304	89	28H
0005435555335	5304	90	29B
0005434343640	5304	91	29A
0005435097057	5304	92	29D
0005435611800	5304	93	29E
0005432047489	5304	94	29K
0005435611801	5304	95	30D
0005435611826	5304	96	30E
0005435611803	5304	97	30H
0005435611820	5304	98	31B
0005435611778	5304	99	31A
0005435611860	5304	100	31C
0005435611864	5304	101	31E
0005435490171	5304	102	31K
0005435611807	5304	103	32A
0005435611859	5304	104	32E
0005435611855	5304	105	32D
0005434573117	5304	106	33A
0005435611875	5304	107	33C
0005435611786	5304	108	33G
0005435611785	5304	109	33E
0005432047491	5304	110	33H
0005435611845	5304	111	33K
0005435611844	5304	112	34E
0005435611871	5304	113	34G
0005432132961	5304	114	34K
0005434573124	5304	115	34H
0005435490170	5304	116	35B
0005435611794	5304	117	35D
0005434343627	5304	118	35C
0005435611833	5304	119	35F
0005435611836	5304	120	35H
0005434343638	5304	121	36A
0005432132966	5304	122	35K
0005435611829	5304	123	36C
0005434573118	5304	124	36B
0005435490172	5304	125	36E
0005435611795	5304	126	36H
0005435611869	5304	127	36G
0005434573128	5304	128	36F
0005434573116	5304	129	36K
0005435611853	5304	130	37E
0005432047490	5304	131	37D
0005435611843	5304	132	37H
0005435611817	5304	133	37G
0005435611835	5304	134	38B
0005435611823	5304	135	39D
0005435611831	5304	136	39C
0005434343628	5304	137	39F
0005435611783	5304	138	39H
0005435611858	5304	139	40B
0005435097055	5304	140	40D
0005435611814	5304	141	40K
0005434343633	5304	142	40J
0005432132957	5304	143	40H
0005434343632	5304	144	41A
0005435611809	5304	145	41D
0005435611846	5304	146	41C
0005435611861	5304	147	41F
0005434343623	5304	148	41E
0005434343618	5304	149	41H
0005435611834	5304	150	41G
0005435611840	5304	151	42C
0005434573125	5304	152	42B
0005435611849	5304	153	42F
0005432132970	5304	154	42H
0005435611787	5304	155	43B
0005435611808	5304	156	42K
0005435555334	5304	157	43D
0005435611779	5304	158	43H
0005435611784	5304	159	43G
0005435611862	5304	160	43K
0005435611792	5304	161	44B
0005434573120	5304	162	44E
0005432132971	5304	163	44J
0005432047488	5304	164	45A
0005435097052	5304	165	45D
0005434343639	5304	166	45C
0005435611775	5304	167	45B
0005432047487	5304	168	45J
0005435611774	5304	169	46B
0005432132964	5304	170	46A
0005435611818	5304	171	46G
0005435490169	5304	172	46F
0005432132959	5304	173	46K
0005432132968	5304	174	46H
0005432132958	5304	175	47E
0005435611797	5304	176	47C
0005434343637	5304	177	47K
0005435611863	5304	178	48C
0005435611857	5304	179	48A
0005434343626	5304	180	48F
0005434343644	5304	181	48D
0005435611805	5304	182	49A
0005434343629	5304	183	49E
0005435491406	5304	184	49H
0005435611873	5304	185	50A
0005435611812	5304	186	50E
0005434573122	5304	187	51D
0005435491405	5304	188	51F
0005435611780	5304	189	51E
0005435611850	5304	190	51G
0005434244499	10928	1	1D
0005435423694	10928	2	1G
0005434244489	10928	3	1K
0005435423669	10928	4	2D
0005432164915	10928	5	3A
0005435319424	10928	6	2K
0005435423704	10928	7	3K
0005434244488	10928	8	3H
0005432164916	10928	9	3G
0005435423681	10928	10	4C
0005435423703	10928	11	4D
0005435423696	10928	12	5C
0005435423675	10928	13	11A
0005435423660	10928	14	11F
0005432164911	10928	15	12A
0005435423690	10928	16	11K
0005435423673	10928	17	12G
0005435423652	10928	18	13D
0005435423648	10928	19	13C
0005435423654	10928	20	13A
0005435423664	10928	21	13E
0005435423715	10928	22	14E
0005435319427	10928	23	15A
0005435423672	10928	24	15D
0005432363363	10928	25	15F
0005435423674	10928	26	15K
0005434244509	10928	27	16K
0005434244512	10928	28	17G
0005433719084	10928	29	18F
0005432164912	10928	30	19D
0005435319429	10928	31	19G
0005434244514	10928	32	19J
0005435319430	10928	33	20B
0005435423708	10928	34	20A
0005435423665	10928	35	20D
0005434244508	10928	36	20H
0005435423714	10928	37	21A
0005435423666	10928	38	21D
0005434244511	10928	39	21C
0005435304092	10928	40	21J
0005435423677	10928	41	22E
0005432164910	10928	42	22D
0005434244494	10928	43	22G
0005432840978	10928	44	22F
0005435423680	10928	45	23A
0005434244513	10928	46	23F
0005434244485	10928	47	23K
0005434244493	10928	48	25F
0005434656523	10928	49	25H
0005435319426	10928	50	25K
0005435423692	10928	51	26C
0005435423668	10928	52	26B
0005435423653	10928	53	26E
0005435423646	10928	54	26F
0005434244498	10928	55	27A
0005435423709	10928	56	26K
0005435423706	10928	57	27D
0005435423701	10928	58	27C
0005432363362	10928	59	27H
0005435319428	10928	60	28B
0005432166847	10928	61	28C
0005433719085	10928	62	28F
0005435423647	10928	63	28H
0005434244484	10928	64	29A
0005434244505	10928	65	29C
0005435423658	10928	66	29F
0005435423693	10928	67	29H
0005435319425	10928	68	29K
0005432166846	10928	69	30B
0005434244491	10928	70	30G
0005432840977	10928	71	30J
0005434244500	10928	72	31B
0005435423655	10928	73	31F
0005434244501	10928	74	31E
0005435423686	10928	75	31H
0005434244492	10928	76	32B
0005435304095	10928	77	32D
0005435423702	10928	78	32G
0005435304093	10928	79	33D
0005434656522	10928	80	33C
0005434244503	10928	81	33G
0005435319423	10928	82	33E
0005432840979	10928	83	33K
0005432363364	10928	84	33J
0005435423656	10928	85	34D
0005435423659	10928	86	34F
0005435423667	10928	87	34K
0005435423679	10928	88	35A
0005435423700	10928	89	35E
0005435423678	10928	90	35G
0005434244490	10928	91	36F
0005435423711	10928	92	36J
0005434244496	10928	93	37D
0005435423684	10928	94	37C
0005435423691	10928	95	37G
0005435423707	10928	96	38K
0005435423712	10928	97	39D
0005432164913	10928	98	39E
0005434244495	10928	99	39H
0005435423663	10928	100	39G
0005434244510	10928	101	40A
0005432166849	10928	102	40B
0005435423650	10928	103	40D
0005434244507	10928	104	40H
0005435423687	10928	105	40J
0005432164914	10928	106	41F
0005434244486	10928	107	41G
0005432164909	10928	108	42A
0005435423689	10928	109	41K
0005435423651	10928	110	42C
0005435304094	10928	111	42H
0005434244487	10928	112	42F
0005434244502	10928	113	43A
0005435423698	10928	114	43H
0005435423695	10928	115	44A
0005435423682	10928	116	43J
0005435423683	10928	117	44C
0005434244504	10928	118	44E
0005435423705	10928	119	44G
0005435423657	10928	120	44J
0005435423710	10928	121	45B
0005435304096	10928	122	45D
0005432166848	10928	123	45E
0005433719086	10928	124	46A
0005435423661	10928	125	46B
0005435319431	10928	126	46C
0005433719087	10928	127	47C
0005434244506	10928	128	47E
0005435304989	10928	129	47D
0005435423649	10928	130	47F
0005435423697	10928	131	47H
0005435423713	10928	132	48D
0005434244497	10928	133	48F
0005435423685	10928	134	48E
0005435423676	10928	135	48H
0005435423662	10928	136	49A
0005435423688	10928	137	49C
0005435423699	10928	138	50D
0005432363361	10928	139	50F
0005435423670	10928	140	50K
0005435423671	10928	141	50H
0005432181354	3229	1	1A
0005433804814	3229	2	1F
0005432181352	3229	3	2A
0005433804809	3229	4	2C
0005433804825	3229	5	3A
0005433633250	3229	6	2F
0005432181345	3229	7	3C
0005433804826	3229	8	3F
0005433804818	3229	9	4C
0005432181362	3229	10	4D
0005433804804	3229	11	4F
0005432181348	3229	12	5D
0005433633248	3229	13	5C
0005433633257	3229	14	6C
0005433506887	3229	15	6D
0005433506882	3229	16	7A
0005433506876	3229	17	7D
0005433506874	3229	18	8A
0005433633260	3229	19	8D
0005432181361	3229	20	9B
0005432181357	3229	21	9A
0005432181341	3229	22	9C
0005433804799	3229	23	9D
0005433633258	3229	24	9E
0005433633253	3229	25	10A
0005433633271	3229	26	10B
0005432181363	3229	27	10C
0005433804820	3229	28	10E
0005433633279	3229	29	10F
0005433804808	3229	30	11B
0005433506883	3229	31	11D
0005433633268	3229	32	11F
0005433804812	3229	33	12A
0005433804803	3229	34	12B
0005433804801	3229	35	12D
0005432181347	3229	36	12F
0005433804824	3229	37	13D
0005433633272	3229	38	14B
0005433633259	3229	39	14A
0005433506890	3229	40	14C
0005433633256	3229	41	14E
0005433633261	3229	42	15A
0005432181350	3229	43	15B
0005433804798	3229	44	15D
0005433804810	3229	45	15E
0005433633265	3229	46	16A
0005433804805	3229	47	16C
0005432181351	3229	48	16D
0005433633264	3229	49	16E
0005433804816	3229	50	16F
0005432181346	3229	51	17B
0005432181360	3229	52	17A
0005433804806	3229	53	17D
0005433633274	3229	54	18A
0005433804800	3229	55	17F
0005433633249	3229	56	18B
0005433633280	3229	57	18C
0005433804811	3229	58	18D
0005433506884	3229	59	18F
0005433804794	3229	60	19D
0005433506875	3229	61	20A
0005433506877	3229	62	19E
0005433633254	3229	63	20C
0005433506881	3229	64	20E
0005433633267	3229	65	20D
0005432181353	3229	66	21A
0005433506878	3229	67	20F
0005433633276	3229	68	21B
0005433506886	3229	69	21E
0005433804827	3229	70	21F
0005433804795	3229	71	22B
0005433804807	3229	72	22A
0005433633282	3229	73	22C
0005433804815	3229	74	22E
0005433633266	3229	75	22D
0005433506888	3229	76	23A
0005433633273	3229	77	23C
0005433633269	3229	78	23D
0005433506885	3229	79	23E
0005433804802	3229	80	23F
0005433633262	3229	81	24B
0005433633277	3229	82	24C
0005433804819	3229	83	24F
0005433506873	3229	84	24E
0005433804822	3229	85	25A
0005433506879	3229	86	25C
0005432181344	3229	87	25D
0005433633251	3229	88	26A
0005433804821	3229	89	26C
0005433804828	3229	90	26E
0005432181356	3229	91	26D
0005433633270	3229	92	26F
0005433804813	3229	93	27A
0005432181359	3229	94	27C
0005432181349	3229	95	27D
0005433804796	3229	96	28A
0005433633281	3229	97	28C
0005433804817	3229	98	28B
0005433506889	3229	99	28D
0005433804823	3229	100	28E
0005432181355	3229	101	28F
0005433633252	3229	102	29F
0005433506880	3229	103	30B
0005433633275	3229	104	30A
0005433804797	3229	105	30D
0005433633255	3229	106	30E
0005432181358	3229	107	31B
0005433633278	3229	108	31A
0005432181342	3229	109	31C
0005433633263	3229	110	31E
0005433506872	3229	111	31D
0005432181343	3229	112	31F
0005432459023	8205	1	1C
0005435884470	8205	2	1D
0005432459038	8205	3	2A
0005432459061	8205	4	1F
0005432459015	8205	5	2D
0005435884452	8205	6	2C
0005432042493	8205	7	2F
0005435884438	8205	8	3A
0005432459012	8205	9	3F
0005435884460	8205	10	4D
0005432459017	8205	11	4F
0005432459051	8205	12	5C
0005432459058	8205	13	5F
0005435884449	8205	14	5D
0005435884480	8205	15	6A
0005435884444	8205	16	6C
0005435884448	8205	17	6F
0005435884429	8205	18	6D
0005432459043	8205	19	7C
0005432459054	8205	20	7F
0005432459035	8205	21	7D
0005435884465	8205	22	8A
0005432459046	8205	23	8B
0005435884454	8205	24	8D
0005435884467	8205	25	8C
0005434312286	8205	26	8F
0005435884469	8205	27	9A
0005435884477	8205	28	9C
0005435884433	8205	29	9D
0005435884446	8205	30	9E
0005432042481	8205	31	10A
0005432459029	8205	32	10B
0005435884443	8205	33	10E
0005432459060	8205	34	10D
0005435884451	8205	35	10F
0005432459014	8205	36	11B
0005432459037	8205	37	11D
0005432042488	8205	38	11F
0005432459059	8205	39	12A
0005432042487	8205	40	12B
0005432459039	8205	41	12C
0005432459022	8205	42	12E
0005435884435	8205	43	12D
0005432459018	8205	44	12F
0005432459041	8205	45	13C
0005435884476	8205	46	13D
0005432459025	8205	47	14A
0005432459036	8205	48	14B
0005435884447	8205	49	14C
0005435884457	8205	50	14E
0005432459024	8205	51	14D
0005432459050	8205	52	15C
0005435884481	8205	53	15B
0005432459055	8205	54	15E
0005432459049	8205	55	15D
0005435884440	8205	56	15F
0005432042482	8205	57	16B
0005432459047	8205	58	16D
0005432459057	8205	59	16C
0005432459062	8205	60	16E
0005435884428	8205	61	16F
0005432042492	8205	62	17B
0005432459053	8205	63	17A
0005432459052	8205	64	17D
0005435884439	8205	65	17E
0005432459056	8205	66	18A
0005432042489	8205	67	17F
0005432459044	8205	68	18B
0005432042490	8205	69	18C
0005432459026	8205	70	19B
0005435884431	8205	71	19D
0005435884459	8205	72	20B
0005435884466	8205	73	20A
0005435884461	8205	74	20C
0005432459019	8205	75	20D
0005435884442	8205	76	20F
0005435884456	8205	77	20E
0005435884437	8205	78	21A
0005435884471	8205	79	21B
0005432459010	8205	80	21D
0005432459013	8205	81	21E
0005432042485	8205	82	21F
0005435884463	8205	83	22B
0005435884468	8205	84	22C
0005432459033	8205	85	22E
0005432459011	8205	86	22F
0005435884478	8205	87	23D
0005432459028	8205	88	23C
0005432042484	8205	89	23F
0005435884430	8205	90	24B
0005435884455	8205	91	24A
0005432459031	8205	92	24D
0005432459034	8205	93	24F
0005432459016	8205	94	25A
0005435884445	8205	95	25C
0005435884475	8205	96	25B
0005435884441	8205	97	25E
0005432459027	8205	98	26A
0005432459030	8205	99	26B
0005432459020	8205	100	26E
0005432459042	8205	101	26D
0005435884436	8205	102	27A
0005435884462	8205	103	26F
0005432042483	8205	104	27C
0005432042491	8205	105	27F
0005432459048	8205	106	27E
0005435884479	8205	107	28A
0005435884458	8205	108	28C
0005432459021	8205	109	28B
0005435884434	8205	110	28D
0005435884427	8205	111	28F
0005432042494	8205	112	29B
0005434312285	8205	113	29A
0005435884464	8205	114	29C
0005435884432	8205	115	29D
0005435884450	8205	116	30A
0005432459045	8205	117	29F
0005432459032	8205	118	30B
0005435884453	8205	119	30C
0005432459040	8205	120	30D
0005435884474	8205	121	30F
0005435884472	8205	122	31B
0005435884473	8205	123	31A
0005432042486	8205	124	31C
0005432382539	4576	1	1A
0005432382531	4576	2	1C
0005432382536	4576	3	1D
0005432382542	4576	4	1F
0005432382524	4576	5	2A
0005433454840	4576	6	2D
0005432382543	4576	7	3A
0005432382535	4576	8	3C
0005432382532	4576	9	3D
0005433722114	4576	10	3F
0005432382546	4576	11	4A
0005432382560	4576	12	4F
0005433722107	4576	13	5D
0005432727729	4576	14	5E
0005433453728	4576	15	5F
0005433453729	4576	16	6A
0005432382558	4576	17	6C
0005433194819	4576	18	6D
0005432382527	4576	19	6E
0005433722115	4576	20	6F
0005432727738	4576	21	7A
0005432382526	4576	22	7E
0005432382523	4576	23	7F
0005432727728	4576	24	8A
0005432382530	4576	25	8D
0005433722108	4576	26	8E
0005432382561	4576	27	8F
0005432727730	4576	28	9C
0005432382547	4576	29	9D
0005433454839	4576	30	9E
0005433722109	4576	31	9F
0005433722110	4576	32	10C
0005432382538	4576	33	10D
0005432727732	4576	34	10E
0005432727734	4576	35	10F
0005432382551	4576	36	11D
0005433194817	4576	37	11E
0005432727735	4576	38	11F
0005432382553	4576	39	12A
0005432382550	4576	40	12C
0005432382540	4576	41	12D
0005432382545	4576	42	12E
0005432382555	4576	43	13C
0005432727739	4576	44	13D
0005432382544	4576	45	13E
0005432382522	4576	46	13F
0005432382552	4576	47	14A
0005432382559	4576	48	14C
0005432382528	4576	49	14D
0005432727736	4576	50	14F
0005432382529	4576	51	15E
0005432382556	4576	52	15F
0005432382534	4576	53	16C
0005432727733	4576	54	16D
0005433722117	4576	55	16E
0005432382554	4576	56	16F
0005432727737	4576	57	17A
0005432382525	4576	58	17C
0005433194818	4576	59	17D
0005432382533	4576	60	17E
0005432727731	4576	61	17F
0005432382557	4576	62	18A
0005433722113	4576	63	18C
0005432382537	4576	64	18D
0005433722116	4576	65	18E
0005432382563	4576	66	18F
0005432382549	4576	67	19A
0005432382541	4576	68	19C
0005432382521	4576	69	19E
0005432382548	4576	70	19F
0005432382562	4576	71	20C
0005433722111	4576	72	20D
0005433722112	4576	73	20E
0005432727740	4576	74	20F
0005435528904	1715	1	1A
0005435528915	1715	2	1C
0005435528917	1715	3	1D
0005435528908	1715	4	1F
0005433516738	1715	5	2C
0005435540664	1715	6	3A
0005435540660	1715	7	3C
0005435540651	1715	8	3D
0005435540646	1715	9	3F
0005435540656	1715	10	4E
0005435528919	1715	11	4F
0005432294449	1715	12	5A
0005432294447	1715	13	5C
0005435528902	1715	14	5D
0005435528912	1715	15	5E
0005435528901	1715	16	6A
0005435528913	1715	17	6C
0005433516736	1715	18	6D
0005435528911	1715	19	7F
0005433516737	1715	20	8A
0005435540665	1715	21	8C
0005433516732	1715	22	8D
0005433516730	1715	23	9A
0005433516739	1715	24	9D
0005435528906	1715	25	9E
0005435540655	1715	26	9F
0005435540648	1715	27	10C
0005435528903	1715	28	10D
0005435540654	1715	29	10E
0005433516733	1715	30	10F
0005435540661	1715	31	11A
0005433516731	1715	32	11C
0005433516735	1715	33	11F
0005435540650	1715	34	12C
0005435540659	1715	35	12E
0005435528907	1715	36	13C
0005435540652	1715	37	13D
0005435528909	1715	38	13E
0005435540662	1715	39	13F
0005435528910	1715	40	14A
0005435528905	1715	41	14D
0005435528921	1715	42	14E
0005435528920	1715	43	14F
0005435540663	1715	44	15C
0005433516734	1715	45	15D
0005435528916	1715	46	16C
0005435528914	1715	47	16D
0005435540657	1715	48	16E
0005432294448	1715	49	16F
0005435528918	1715	50	17A
0005435540644	1715	51	17C
0005435540649	1715	52	17D
0005435540647	1715	53	17F
0005435540666	1715	54	18E
0005435540645	1715	55	19C
0005435540658	1715	56	20E
0005435540653	1715	57	20F
0005432924958	22014	1	4D
0005432924956	22014	2	4F
0005432924959	22014	3	5D
0005432924957	22014	4	13E
0005432924960	22014	5	16F
0005432838514	7371	1	1C
0005432838524	7371	2	1F
0005432838520	7371	3	2A
0005434458458	7371	4	2D
0005432838540	7371	5	2F
0005432840976	7371	6	3A
0005432838535	7371	7	4A
0005432838536	7371	8	4D
0005432838537	7371	9	4E
0005432838529	7371	10	4F
0005432838527	7371	11	5C
0005432838515	7371	12	5D
0005434458471	7371	13	6A
0005432838531	7371	14	6C
0005432073335	7371	15	6D
0005432838542	7371	16	6F
0005432838544	7371	17	7E
0005432073334	7371	18	7F
0005432838541	7371	19	8A
0005432073332	7371	20	8C
0005432838522	7371	21	8D
0005434458454	7371	22	8E
0005434458455	7371	23	8F
0005434458464	7371	24	9C
0005434458465	7371	25	9D
0005432823415	7371	26	9E
0005432838516	7371	27	10A
0005434458470	7371	28	10C
0005434458469	7371	29	10D
0005432838533	7371	30	10E
0005432838543	7371	31	11A
0005432838512	7371	32	11C
0005434458457	7371	33	11D
0005432838521	7371	34	11F
0005432838539	7371	35	12A
0005432838513	7371	36	12E
0005434458467	7371	37	12F
0005432838519	7371	38	13A
0005434458462	7371	39	13C
0005432838538	7371	40	13D
0005432838517	7371	41	14E
0005432838532	7371	42	14F
0005432073333	7371	43	15C
0005434458459	7371	44	15D
0005434458474	7371	45	15E
0005432838528	7371	46	15F
0005434458460	7371	47	16A
0005432838518	7371	48	16D
0005434458456	7371	49	16E
0005432838534	7371	50	16F
0005432838525	7371	51	17A
0005432838530	7371	52	17D
0005434458466	7371	53	17E
0005434458472	7371	54	17F
0005432838523	7371	55	18C
0005434458468	7371	56	18D
0005434458461	7371	57	18E
0005434458473	7371	58	18F
0005434458475	7371	59	19E
0005434458463	7371	60	20E
0005432838526	7371	61	20F
0005434664923	28939	1	1F
0005432000990	28939	2	3F
0005435252398	28939	3	4F
0005435491408	28939	4	5F
0005435252407	28939	5	6D
0005435252417	28939	6	6E
0005435252408	28939	7	6F
0005435252397	28939	8	7E
0005435252406	28939	9	9A
0005435252401	28939	10	9F
0005435252404	28939	11	10F
0005435252405	28939	12	11D
0005435252399	28939	13	12A
0005435252409	28939	14	12C
0005435252403	28939	15	13C
0005435252410	28939	16	14A
0005435252414	28939	17	14C
0005435252400	28939	18	14E
0005435252413	28939	19	14F
0005434664924	28939	20	15A
0005435252402	28939	21	15D
0005435252416	28939	22	16A
0005435252412	28939	23	16F
0005435252411	28939	24	17D
0005435252415	28939	25	17E
0005434664922	28939	26	18C
0005432000989	28939	27	18E
0005435491409	28939	28	19A
0005434664921	28939	29	20E
0005435990506	8796	1	8B
0005435990511	8796	2	10B
0005435990512	8796	3	14C
0005435990510	8796	4	18A
0005435990505	8796	5	18D
0005435990508	8796	6	18E
0005435990504	8796	7	19A
0005435990507	8796	8	20A
0005435990509	8796	9	21B
0005434275929	15753	1	6B
0005434275930	15753	2	7B
0005434275931	15753	3	11E
0005434275937	15753	4	12F
0005434275936	15753	5	13D
0005434275933	15753	6	13F
0005434275932	15753	7	15D
0005434275934	15753	8	19E
0005434275935	15753	9	20F
0005432427109	20619	1	1D
0005432427106	20619	2	6A
0005432427107	20619	3	19C
0005432427108	20619	4	23B
0005433476856	30855	1	3B
0005433476858	30855	2	7C
0005433476857	30855	3	18B
0005433476855	30855	4	19A
0005432359599	6364	1	1D
0005432359591	6364	2	2C
0005432359598	6364	3	2D
0005432359602	6364	4	2F
0005432335838	6364	5	3A
0005432335833	6364	6	3F
0005432363363	6364	7	4C
0005432359559	6364	8	4E
0005432359567	6364	9	4F
0005432359603	6364	10	5C
0005432359586	6364	11	5D
0005432359563	6364	12	6B
0005432359581	6364	13	6C
0005432335835	6364	14	7A
0005432359577	6364	15	6F
0005432359572	6364	16	7C
0005432062141	6364	17	7E
0005432335839	6364	18	7F
0005432335844	6364	19	8B
0005432335842	6364	20	8C
0005432359560	6364	21	8F
0005432359589	6364	22	9C
0005432359585	6364	23	9D
0005432335832	6364	24	10B
0005432359594	6364	25	10C
0005432359574	6364	26	10D
0005432335841	6364	27	10E
0005432359584	6364	28	11D
0005432359605	6364	29	11F
0005432335834	6364	30	12B
0005432335840	6364	31	12E
0005432359592	6364	32	12F
0005432359597	6364	33	13A
0005432359573	6364	34	13C
0005432062143	6364	35	13B
0005432359568	6364	36	13D
0005432359569	6364	37	13E
0005432359564	6364	38	13F
0005432359588	6364	39	14B
0005432359562	6364	40	14A
0005432335837	6364	41	14D
0005432359576	6364	42	15A
0005432359601	6364	43	15C
0005432359587	6364	44	15D
0005432359561	6364	45	15F
0005432359558	6364	46	16B
0005432359595	6364	47	16D
0005432363364	6364	48	16E
0005432359575	6364	49	16F
0005432359570	6364	50	17D
0005432359582	6364	51	17C
0005432359590	6364	52	17E
0005432062142	6364	53	18A
0005432359593	6364	54	17F
0005432363362	6364	55	18B
0005432359596	6364	56	18C
0005432359565	6364	57	19C
0005432359600	6364	58	19B
0005432359566	6364	59	19D
0005432062140	6364	60	20B
0005432359579	6364	61	21A
0005432359556	6364	62	20F
0005432335843	6364	63	21C
0005432359580	6364	64	21D
0005432359604	6364	65	21F
0005432363361	6364	66	22B
0005432359557	6364	67	22A
0005432335836	6364	68	22E
0005432359571	6364	69	23A
0005432359578	6364	70	23E
0005432359583	6364	71	23F
0005435176637	20982	1	1A
0005432052697	20982	2	1C
0005434149533	20982	3	1D
0005435176628	20982	4	2A
0005435176635	20982	5	2C
0005432052695	20982	6	2F
0005435723012	20982	7	3C
0005435176640	20982	8	3A
0005434149541	20982	9	5A
0005435490174	20982	10	5D
0005435176617	20982	11	6C
0005435176619	20982	12	6E
0005435490176	20982	13	7B
0005435176624	20982	14	7C
0005434149532	20982	15	7F
0005435176627	20982	16	8A
0005435176618	20982	17	8D
0005435176636	20982	18	8E
0005435176629	20982	19	8F
0005434149539	20982	20	9A
0005435176641	20982	21	10D
0005434149536	20982	22	10E
0005435176631	20982	23	11B
0005434149542	20982	24	11C
0005435176625	20982	25	12A
0005434149535	20982	26	12E
0005434149537	20982	27	13C
0005435176634	20982	28	14D
0005435176626	20982	29	15B
0005435176630	20982	30	15C
0005435176621	20982	31	15E
0005435490175	20982	32	15D
0005435723011	20982	33	16A
0005435176622	20982	34	15F
0005435176613	20982	35	16C
0005435176623	20982	36	17A
0005434149540	20982	37	17B
0005434149543	20982	38	17F
0005432052696	20982	39	18B
0005434149538	20982	40	18F
0005435176614	20982	41	19B
0005435176633	20982	42	19C
0005435176620	20982	43	19F
0005435176615	20982	44	20B
0005435176632	20982	45	20F
0005435176616	20982	46	21D
0005434149534	20982	47	21E
0005435176638	20982	48	22A
0005435176639	20982	49	22E
0005432052698	20982	50	23F
0005434186150	17693	1	1D
0005434186152	17693	2	3A
0005434186151	17693	3	6B
0005434458458	29125	1	1A
0005434458464	29125	2	1B
0005434458461	29125	3	1C
0005434463892	29125	4	2A
0005434458474	29125	5	2B
0005434458463	29125	6	2C
0005434458454	29125	7	2D
0005434462752	29125	8	3A
0005434458462	29125	9	3B
0005434458475	29125	10	4A
0005434458467	29125	11	4B
0005434458466	29125	12	4C
0005434458456	29125	13	5B
0005434458471	29125	14	6A
0005434458470	29125	15	6B
0005434458465	29125	16	7B
0005434448255	29125	17	7C
0005434458469	29125	18	7D
0005434458455	29125	19	18C
0005434458460	29125	20	18D
0005434458473	29125	21	19A
0005434463891	29125	22	19B
0005434462753	29125	23	19C
0005434458468	29125	24	20A
0005434448253	29125	25	20B
0005434458472	29125	26	20C
0005434448254	29125	27	20D
0005434458457	29125	28	21A
0005434448256	29125	29	21C
0005434458459	29125	30	23A
0005432603673	21411	1	1A
0005432603680	21411	2	1B
0005432603674	21411	3	1C
0005432603667	21411	4	1D
0005432603657	21411	5	2A
0005432603662	21411	6	2B
0005432603660	21411	7	2D
0005432603656	21411	8	3A
0005432603652	21411	9	3B
0005432603644	21411	10	3D
0005432603661	21411	11	4B
0005432603675	21411	12	4C
0005432603664	21411	13	4D
0005432603648	21411	14	5A
0005432603646	21411	15	5B
0005432603645	21411	16	5D
0005432603653	21411	17	6A
0005432603666	21411	18	6C
0005432603659	21411	19	6B
0005432603669	21411	20	6D
0005432603676	21411	21	7A
0005432603651	21411	22	7B
0005432603679	21411	23	7C
0005432603672	21411	24	18B
0005432603677	21411	25	18C
0005432603671	21411	26	18D
0005432603681	21411	27	19A
0005432603643	21411	28	19C
0005432603655	21411	29	20A
0005432603654	21411	30	20B
0005432603663	21411	31	20C
0005432603649	21411	32	20D
0005432603642	21411	33	21A
0005432603650	21411	34	21B
0005432603647	21411	35	21C
0005432603670	21411	36	21D
0005432603668	21411	37	22B
0005432603665	21411	38	22C
0005432603678	21411	39	22D
0005432603658	21411	40	23A
0005434606760	22352	1	1A
0005434606759	22352	2	2B
0005434606762	22352	3	3A
0005434606763	22352	4	3B
0005434606761	22352	5	4A
0005434604838	22352	6	5A
0005434604839	22352	7	6A
0005434604837	22352	8	6B
0005432746912	376	1	2D
0005432746925	376	2	2F
0005432746923	376	3	3A
0005432746943	376	4	3C
0005432746935	376	5	4D
0005432746910	376	6	4F
0005432746921	376	7	6A
0005432753244	376	8	6D
0005432753243	376	9	7A
0005432746924	376	10	7E
0005432219933	376	11	8A
0005435154581	376	12	8D
0005432746940	376	13	8E
0005432219930	376	14	9A
0005432746915	376	15	9D
0005432746922	376	16	9E
0005432746942	376	17	9F
0005432746909	376	18	10A
0005432746908	376	19	10D
0005432746931	376	20	11A
0005432746911	376	21	11C
0005432751468	376	22	11D
0005432746944	376	23	11F
0005432746913	376	24	12A
0005432746929	376	25	12C
0005432746928	376	26	12D
0005432746903	376	27	12F
0005432746916	376	28	13A
0005432746933	376	29	13D
0005432746941	376	30	13E
0005432746927	376	31	13F
0005432751469	376	32	14C
0005432746907	376	33	14D
0005435154580	376	34	14F
0005432746917	376	35	15A
0005432749748	376	36	15C
0005435154582	376	37	15D
0005432746937	376	38	15E
0005432746914	376	39	16A
0005432746930	376	40	16D
0005432746905	376	41	16E
0005432753242	376	42	17A
0005432746920	376	43	17C
0005432746936	376	44	17D
0005432746932	376	45	17E
0005432219932	376	46	18A
0005432746904	376	47	18C
0005432219931	376	48	18D
0005432746934	376	49	19A
0005432746938	376	50	19C
0005432746939	376	51	19D
0005432746926	376	52	19E
0005432746919	376	53	19F
0005432746918	376	54	20D
0005432749747	376	55	20E
0005432746906	376	56	20F
0005432890709	12064	1	1C
0005432890693	12064	2	1D
0005432890706	12064	3	1F
0005432890702	12064	4	2D
0005432890707	12064	5	3F
0005433875354	12064	6	4A
0005432214767	12064	7	4E
0005432214768	12064	8	5C
0005433293146	12064	9	6A
0005432890699	12064	10	7A
0005432890701	12064	11	7E
0005433875353	12064	12	7F
0005433293144	12064	13	8D
0005433293147	12064	14	9C
0005433293143	12064	15	10C
0005432890692	12064	16	10E
0005432890698	12064	17	10F
0005432890703	12064	18	11C
0005433293145	12064	19	12A
0005432890704	12064	20	14A
0005432890708	12064	21	15F
0005432890694	12064	22	16C
0005432890700	12064	23	16F
0005432890697	12064	24	17C
0005433293142	12064	25	18C
0005432890691	12064	26	18D
0005432890695	12064	27	19A
0005432890705	12064	28	19D
0005432890690	12064	29	19F
0005432890696	12064	30	20F
0005433524855	18989	1	1A
0005433531227	18989	2	1B
0005433524854	18989	3	2C
0005433531228	18989	4	3A
0005433533243	18989	5	3C
0005433533240	18989	6	4D
0005433531226	18989	7	5B
0005433524849	18989	8	6A
0005433524853	18989	9	6C
0005433524847	18989	10	6D
0005433533242	18989	11	7A
0005433524846	18989	12	7B
0005433524852	18989	13	18A
0005433531225	18989	14	18C
0005433524850	18989	15	19A
0005433524851	18989	16	19D
0005433524848	18989	17	21B
0005433533241	18989	18	21C
0005432927892	32512	1	2D
0005432927891	32512	2	5B
0005432927894	32512	3	7B
0005432927893	32512	4	18A
0005432927890	32512	5	18C
0005432927895	32512	6	20C
0005432927896	32512	7	23B
0005434821524	5278	1	1D
0005434558146	5278	2	1K
0005434821526	5278	3	1H
0005434821536	5278	4	2G
0005434558143	5278	5	3C
0005434821511	5278	6	4K
0005434821470	5278	7	4H
0005434821447	5278	8	5G
0005432121103	5278	9	11C
0005434821498	5278	10	11K
0005434821478	5278	11	11H
0005435149801	5278	12	11G
0005432121102	5278	13	12A
0005434821519	5278	14	12G
0005434821501	5278	15	12F
0005434821454	5278	16	13A
0005434831070	5278	17	12H
0005434821458	5278	18	13D
0005434821441	5278	19	13C
0005432396178	5278	20	13G
0005434821518	5278	21	14D
0005434821445	5278	22	14C
0005434821527	5278	23	14K
0005434821505	5278	24	14G
0005434821516	5278	25	15C
0005435149806	5278	26	15E
0005435149811	5278	27	15H
0005434821547	5278	28	15G
0005434821538	5278	29	15F
0005434821506	5278	30	16D
0005434821467	5278	31	16C
0005434821532	5278	32	16E
0005434821549	5278	33	17D
0005434821540	5278	34	17H
0005432121107	5278	35	17G
0005432394038	5278	36	17K
0005434821488	5278	37	18C
0005434821533	5278	38	18B
0005434821512	5278	39	18E
0005434821514	5278	40	18D
0005432121101	5278	41	18G
0005434821554	5278	42	18K
0005434821503	5278	43	18H
0005432396177	5278	44	19B
0005434558140	5278	45	19A
0005435149800	5278	46	19C
0005435149805	5278	47	19F
0005434821449	5278	48	20C
0005432394039	5278	49	20G
0005434821555	5278	50	20F
0005434821440	5278	51	20K
0005434821551	5278	52	20J
0005434831067	5278	53	21A
0005434821491	5278	54	21D
0005434558145	5278	55	21C
0005434821492	5278	56	21F
0005434821556	5278	57	21H
0005434821530	5278	58	22A
0005434821565	5278	59	22B
0005434821496	5278	60	22E
0005434821563	5278	61	23B
0005434664920	5278	62	22K
0005434821558	5278	63	23E
0005434821539	5278	64	23D
0005434821463	5278	65	23C
0005434821567	5278	66	23F
0005434821568	5278	67	23J
0005434821515	5278	68	23H
0005434821466	5278	69	23G
0005434821468	5278	70	24F
0005434821490	5278	71	25D
0005432121097	5278	72	25F
0005435149804	5278	73	25E
0005432394036	5278	74	25H
0005434821507	5278	75	25G
0005434821508	5278	76	25J
0005434821500	5278	77	26E
0005434821570	5278	78	26D
0005434821509	5278	79	26K
0005434558141	5278	80	26J
0005434821461	5278	81	27B
0005434821452	5278	82	27A
0005434821480	5278	83	27D
0005434821513	5278	84	27F
0005434558148	5278	85	27J
0005434821531	5278	86	27G
0005434821525	5278	87	28B
0005434821485	5278	88	28E
0005434558144	5278	89	28D
0005435149807	5278	90	28C
0005434821450	5278	91	29E
0005434821469	5278	92	29J
0005434821543	5278	93	30A
0005434821502	5278	94	29K
0005434821517	5278	95	30B
0005434558142	5278	96	30D
0005434821564	5278	97	30G
0005434821444	5278	98	30F
0005434821520	5278	99	31B
0005434821475	5278	100	31D
0005434821484	5278	101	32A
0005432396175	5278	102	32C
0005434821442	5278	103	32E
0005434821541	5278	104	32F
0005434821456	5278	105	32H
0005434821542	5278	106	33B
0005434821521	5278	107	33A
0005434821471	5278	108	33D
0005434821473	5278	109	33C
0005434821497	5278	110	33E
0005432121098	5278	111	33G
0005432121110	5278	112	33K
0005434821557	5278	113	34C
0005434821481	5278	114	34B
0005434821569	5278	115	34G
0005434821464	5278	116	34K
0005434828648	5278	117	35B
0005434821460	5278	118	35A
0005432394037	5278	119	35D
0005434821529	5278	120	35H
0005434821453	5278	121	35G
0005434821495	5278	122	36A
0005435149809	5278	123	35K
0005434821535	5278	124	36C
0005434821476	5278	125	36E
0005434821523	5278	126	36D
0005434821499	5278	127	36G
0005434821493	5278	128	36F
0005434821446	5278	129	36K
0005434821472	5278	130	36J
0005434821482	5278	131	37A
0005434821552	5278	132	37D
0005434831066	5278	133	37F
0005434831069	5278	134	37H
0005432121099	5278	135	37K
0005434821489	5278	136	38K
0005435149812	5278	137	38J
0005434821479	5278	138	39A
0005434828649	5278	139	39D
0005434821544	5278	140	39G
0005435149808	5278	141	40D
0005434821494	5278	142	40J
0005434821443	5278	143	41J
0005434821528	5278	144	41G
0005434821561	5278	145	42C
0005435149799	5278	146	42B
0005435149803	5278	147	42G
0005434821455	5278	148	42F
0005434821546	5278	149	42J
0005434821483	5278	150	42H
0005434821486	5278	151	43B
0005434821477	5278	152	43A
0005434821451	5278	153	42K
0005432121109	5278	154	43D
0005434821548	5278	155	43H
0005434821553	5278	156	43G
0005432121096	5278	157	43J
0005434821566	5278	158	44B
0005432121108	5278	159	44A
0005434821550	5278	160	44E
0005432121100	5278	161	44D
0005434828650	5278	162	44C
0005434821559	5278	163	45A
0005435149802	5278	164	45C
0005434821487	5278	165	45D
0005434821465	5278	166	45G
0005434664919	5278	167	45K
0005434821459	5278	168	46A
0005434821504	5278	169	46D
0005434821510	5278	170	46G
0005435149798	5278	171	46F
0005434821560	5278	172	46K
0005432121106	5278	173	46H
0005432121105	5278	174	47C
0005432121104	5278	175	47G
0005434821474	5278	176	47K
0005434558147	5278	177	47H
0005434821448	5278	178	48D
0005432396176	5278	179	48C
0005434821534	5278	180	48A
0005434831068	5278	181	48F
0005434821562	5278	182	48K
0005434821537	5278	183	49E
0005435149810	5278	184	49H
0005434821457	5278	185	50C
0005434821522	5278	186	50A
0005434821545	5278	187	50F
0005434821462	5278	188	50E
0005434558139	5278	189	50D
0005435372211	9883	1	1C
0005435372202	9883	2	1A
0005435372222	9883	3	1D
0005435372218	9883	4	2C
0005435372213	9883	5	3G
0005432202946	9883	6	4A
0005435372204	9883	7	4K
0005435386463	9883	8	5C
0005435372201	9883	9	5H
0005435386459	9883	10	5G
0005435372197	9883	11	11A
0005435735061	9883	12	5K
0005435372193	9883	13	11D
0005432202942	9883	14	11G
0005435735064	9883	15	13D
0005435735062	9883	16	14E
0005435372166	9883	17	14D
0005432823416	9883	18	14G
0005435179687	9883	19	14F
0005435372210	9883	20	15D
0005435372198	9883	21	15C
0005435372160	9883	22	16A
0005435372187	9883	23	16F
0005435372174	9883	24	16E
0005432823417	9883	25	17A
0005435735060	9883	26	18A
0005435386464	9883	27	18H
0005435372186	9883	28	19C
0005435302122	9883	29	19E
0005435386461	9883	30	20E
0005435372184	9883	31	20H
0005435372165	9883	32	20G
0005435372219	9883	33	21A
0005435386462	9883	34	21E
0005435372215	9883	35	21J
0005435372161	9883	36	22F
0005435372169	9883	37	22K
0005432202948	9883	38	22J
0005432823418	9883	39	23B
0005435372216	9883	40	23D
0005435372212	9883	41	23C
0005435179686	9883	42	25A
0005435372200	9883	43	25C
0005435302119	9883	44	25H
0005435372163	9883	45	25K
0005435299696	9883	46	25J
0005435302123	9883	47	26G
0005435372178	9883	48	27A
0005435386460	9883	49	26K
0005435372179	9883	50	27D
0005435372171	9883	51	27E
0005435299699	9883	52	27H
0005435372203	9883	53	29C
0005435372191	9883	54	29E
0005435372162	9883	55	30B
0005435661884	9883	56	30F
0005435372176	9883	57	30H
0005435372192	9883	58	31A
0005435372205	9883	59	31E
0005435372214	9883	60	31J
0005435372190	9883	61	32C
0005435372221	9883	62	32B
0005435372173	9883	63	32A
0005435386458	9883	64	32F
0005435372164	9883	65	32K
0005435372209	9883	66	33C
0005435661882	9883	67	33F
0005435372195	9883	68	33H
0005435735063	9883	69	33G
0005435372194	9883	70	34F
0005432202947	9883	71	34J
0005435372206	9883	72	35D
0005435372189	9883	73	35C
0005435372181	9883	74	35F
0005435372159	9883	75	35G
0005435372217	9883	76	36A
0005435372223	9883	77	36G
0005435372167	9883	78	36F
0005435372175	9883	79	37F
0005432202941	9883	80	38J
0005432202943	9883	81	38H
0005435372208	9883	82	39C
0005435372207	9883	83	39G
0005435372177	9883	84	39H
0005435372224	9883	85	41A
0005435372183	9883	86	41J
0005435372225	9883	87	42E
0005435372172	9883	88	42D
0005435661883	9883	89	43D
0005435302120	9883	90	43F
0005435372182	9883	91	44A
0005435372185	9883	92	44G
0005435372168	9883	93	45B
0005432202945	9883	94	45F
0005435372180	9883	95	45H
0005435372199	9883	96	45J
0005435372170	9883	97	46F
0005435302121	9883	98	46J
0005435372188	9883	99	47E
0005435372196	9883	100	48E
0005432202944	9883	101	49G
0005435299698	9883	102	49K
0005435299697	9883	103	50F
0005435372220	9883	104	51E
0005435082657	6983	1	1D
0005435790259	6983	2	2B
0005435790257	6983	3	2C
0005435082653	6983	4	4C
0005435082658	6983	5	6A
0005435082652	6983	6	6C
0005435082654	6983	7	7D
0005435790258	6983	8	18C
0005435082656	6983	9	19B
0005435082660	6983	10	19C
0005435082650	6983	11	20B
0005435082661	6983	12	20C
0005435082651	6983	13	21A
0005435082655	6983	14	21C
0005435082659	6983	15	22C
0005434755781	9557	1	1C
0005434755756	9557	2	2C
0005434755771	9557	3	2D
0005434755737	9557	4	3A
0005434755765	9557	5	3D
0005434755759	9557	6	4A
0005434755766	9557	7	4D
0005434755757	9557	8	4F
0005434755746	9557	9	5A
0005434755773	9557	10	5C
0005434755747	9557	11	6D
0005434755774	9557	12	6E
0005434755739	9557	13	7C
0005434755763	9557	14	7E
0005434755743	9557	15	8C
0005434755738	9557	16	9D
0005434755758	9557	17	10C
0005434755772	9557	18	10D
0005434755762	9557	19	11A
0005434755760	9557	20	11C
0005434755776	9557	21	12A
0005434755778	9557	22	12C
0005434755767	9557	23	13C
0005434755764	9557	24	13D
0005434755745	9557	25	13E
0005434755755	9557	26	13F
0005434755742	9557	27	14A
0005434755749	9557	28	14C
0005434755752	9557	29	14D
0005434755780	9557	30	15A
0005434755769	9557	31	15C
0005434755748	9557	32	15D
0005434755761	9557	33	16C
0005434755736	9557	34	16D
0005434755750	9557	35	17C
0005434755754	9557	36	17D
0005434755740	9557	37	17E
0005434755744	9557	38	17F
0005434755777	9557	39	18A
0005434755779	9557	40	18D
0005434755741	9557	41	19A
0005434755753	9557	42	19C
0005434755775	9557	43	19E
0005434755751	9557	44	20A
0005434755768	9557	45	20E
0005434755770	9557	46	20F
0005434213722	28631	1	1A
0005434213723	28631	2	1D
0005434213728	28631	3	1F
0005434213734	28631	4	2F
0005434213731	28631	5	3A
0005434213730	28631	6	3C
0005434213715	28631	7	3D
0005434213699	28631	8	3F
0005434213732	28631	9	4A
0005434213714	28631	10	4C
0005434213743	28631	11	4D
0005434213738	28631	12	4E
0005434213704	28631	13	4F
0005434213720	28631	14	5A
0005434213719	28631	15	6C
0005434213703	28631	16	6D
0005434213739	28631	17	7A
0005434213737	28631	18	7D
0005434213718	28631	19	7E
0005434213706	28631	20	8A
0005434213726	28631	21	8C
0005434213700	28631	22	9C
0005434213712	28631	23	9D
0005434213725	28631	24	9F
0005434213729	28631	25	10C
0005434213740	28631	26	10D
0005434213745	28631	27	10E
0005434213717	28631	28	11C
0005434213711	28631	29	11E
0005434213701	28631	30	12A
0005434213744	28631	31	12C
0005434213710	28631	32	12D
0005434213716	28631	33	12E
0005434213735	28631	34	12F
0005434213705	28631	35	13C
0005434213713	28631	36	13E
0005434213708	28631	37	15C
0005434213724	28631	38	15F
0005434213702	28631	39	16A
0005434213736	28631	40	16D
0005434213742	28631	41	16F
0005434213709	28631	42	17F
0005434213733	28631	43	18A
0005434213721	28631	44	18F
0005434213727	28631	45	19C
0005434213707	28631	46	19F
0005434213741	28631	47	20A
0005434213698	28631	48	20C
0005435100072	10823	1	6A
0005435100074	10823	2	21C
0005435100073	10823	3	22C
0005434760157	31806	1	5A
0005434760156	31806	2	7B
0005434638882	1982	1	1A
0005434638898	1982	2	1C
0005434638880	1982	3	1D
0005434638883	1982	4	2A
0005434638887	1982	5	2B
0005434638891	1982	6	2C
0005434638901	1982	7	2D
0005434638894	1982	8	3B
0005434638896	1982	9	4A
0005434638879	1982	10	4C
0005432290583	1982	11	4D
0005435948307	1982	12	5A
0005434638902	1982	13	5B
0005434638884	1982	14	5C
0005434638895	1982	15	6A
0005434638888	1982	16	6D
0005434638899	1982	17	7A
0005432290584	1982	18	7B
0005434638900	1982	19	7C
0005434638892	1982	20	18C
0005434638885	1982	21	19A
0005434638877	1982	22	19D
0005434638897	1982	23	20A
0005434638889	1982	24	20B
0005434638890	1982	25	20C
0005434638886	1982	26	21D
0005434638876	1982	27	22C
0005434638893	1982	28	22D
0005434638881	1982	29	23A
0005434638878	1982	30	23B
0005433202105	23271	1	1B
0005433202116	23271	2	2A
0005433202113	23271	3	2D
0005433202110	23271	4	3C
0005433202115	23271	5	5D
0005433202111	23271	6	6B
0005433202106	23271	7	6C
0005433202107	23271	8	7B
0005433202108	23271	9	7C
0005433202112	23271	10	7D
0005433202103	23271	11	18A
0005433202104	23271	12	18B
0005433202102	23271	13	19A
0005433202109	23271	14	20C
0005433202114	23271	15	21C
0005434600380	6036	1	1A
0005434600372	6036	2	1C
0005432111229	6036	3	1F
0005434600370	6036	4	2A
0005433533245	6036	5	3D
0005434600368	6036	6	4A
0005434600366	6036	7	4C
0005434600365	6036	8	4E
0005433531231	6036	9	5D
0005434600357	6036	10	5E
0005434600359	6036	11	6E
0005433531230	6036	12	7C
0005434600358	6036	13	8D
0005433533247	6036	14	8C
0005434600381	6036	15	8E
0005434600354	6036	16	9C
0005434600362	6036	17	9A
0005432111230	6036	18	9D
0005434600373	6036	19	9F
0005434600356	6036	20	10E
0005433531232	6036	21	11D
0005434600364	6036	22	11E
0005434600374	6036	23	12D
0005434600379	6036	24	12E
0005434600377	6036	25	13A
0005434600376	6036	26	13D
0005433531229	6036	27	13F
0005433531233	6036	28	14E
0005434600375	6036	29	14F
0005434600371	6036	30	15A
0005434600361	6036	31	15C
0005434600367	6036	32	15D
0005433533244	6036	33	17A
0005433533246	6036	34	17D
0005434600369	6036	35	18C
0005434600355	6036	36	18D
0005434600360	6036	37	18E
0005434600363	6036	38	19D
0005434600378	6036	39	20C
0005432111228	6036	40	20E
0005435326512	18565	1	2A
0005435326516	18565	2	4A
0005435326523	18565	3	5F
0005435326521	18565	4	6D
0005435326514	18565	5	7A
0005435326515	18565	6	9E
0005435326518	18565	7	9F
0005435326519	18565	8	12A
0005435326513	18565	9	12D
0005435326517	18565	10	13A
0005435326522	18565	11	14E
0005435326520	18565	12	18E
0005435326524	18565	13	20F
0005434550311	10599	1	1A
0005434550267	10599	2	1F
0005434550299	10599	3	2C
0005434550310	10599	4	2D
0005434550288	10599	5	2F
0005434550266	10599	6	3A
0005434550305	10599	7	3D
0005434550292	10599	8	4A
0005434550263	10599	9	4C
0005434550289	10599	10	4D
0005434550271	10599	11	4E
0005434550306	10599	12	5C
0005434550279	10599	13	5D
0005434550309	10599	14	5E
0005434550259	10599	15	6D
0005434550297	10599	16	6F
0005434550293	10599	17	7D
0005434550274	10599	18	7E
0005434550277	10599	19	7F
0005434550287	10599	20	8A
0005434550281	10599	21	8D
0005434550276	10599	22	8E
0005434550283	10599	23	9A
0005434550272	10599	24	9C
0005434550260	10599	25	9E
0005434554025	10599	26	9F
0005434550286	10599	27	10A
0005434550257	10599	28	10C
0005434550265	10599	29	10D
0005434550262	10599	30	10F
0005434550303	10599	31	11C
0005434550256	10599	32	11D
0005434550268	10599	33	11E
0005434550269	10599	34	12A
0005434554026	10599	35	12E
0005434550300	10599	36	13A
0005434550296	10599	37	13C
0005434550261	10599	38	13E
0005434554027	10599	39	13F
0005434550308	10599	40	14A
0005434550298	10599	41	14D
0005434550264	10599	42	14E
0005434550291	10599	43	14F
0005434550280	10599	44	15A
0005434550284	10599	45	15C
0005434550285	10599	46	15D
0005434550275	10599	47	15F
0005434550290	10599	48	16C
0005434550301	10599	49	16D
0005434550295	10599	50	16F
0005434550282	10599	51	17A
0005434550294	10599	52	17C
0005434550273	10599	53	18A
0005434550302	10599	54	18D
0005434550270	10599	55	18E
0005434550304	10599	56	19C
0005434550307	10599	57	19E
0005434550278	10599	58	20C
0005434550258	10599	59	20D
0005433180686	27760	1	1F
0005433180693	27760	2	3A
0005433180683	27760	3	3C
0005433180688	27760	4	3F
0005433180679	27760	5	4C
0005433180697	27760	6	4E
0005433180692	27760	7	5E
0005433180678	27760	8	6A
0005433180677	27760	9	7A
0005433180700	27760	10	7C
0005433180675	27760	11	7D
0005433180684	27760	12	7E
0005433180685	27760	13	10D
0005433180691	27760	14	10F
0005433180680	27760	15	11C
0005433180682	27760	16	11E
0005433180699	27760	17	12F
0005433180695	27760	18	13D
0005433180690	27760	19	14C
0005433180687	27760	20	14E
0005433180698	27760	21	15A
0005433180676	27760	22	15C
0005433180674	27760	23	16C
0005433180694	27760	24	18A
0005433180681	27760	25	19A
0005433180689	27760	26	19C
0005433180696	27760	27	20A
0005433459150	6138	1	1A
0005433459151	6138	2	1B
0005433459148	6138	3	4A
0005433459147	6138	4	4B
0005433459149	6138	5	6B
0005435254433	19333	1	2A
0005435254431	19333	2	3B
0005435254432	19333	3	5A
0005435681466	6731	1	1A
0005435681436	6731	2	1D
0005435681433	6731	3	1F
0005435681463	6731	4	2A
0005435681442	6731	5	2C
0005435681438	6731	6	2D
0005435681443	6731	7	3C
0005435681429	6731	8	3F
0005432136085	6731	9	4A
0005435681437	6731	10	4E
0005435681444	6731	11	4F
0005435681446	6731	12	5F
0005435681432	6731	13	6A
0005435681456	6731	14	6C
0005435681454	6731	15	6D
0005435681450	6731	16	6E
0005435630915	6731	17	6F
0005432136089	6731	18	7A
0005435681428	6731	19	7C
0005435681464	6731	20	7D
0005432136087	6731	21	7E
0005435681452	6731	22	8C
0005432136088	6731	23	8D
0005435681445	6731	24	8F
0005435681462	6731	25	9A
0005435681458	6731	26	9C
0005435681431	6731	27	9D
0005435681455	6731	28	10F
0005435681430	6731	29	11E
0005432136086	6731	30	12D
0005435681457	6731	31	12E
0005435681439	6731	32	13C
0005435681440	6731	33	13D
0005435630914	6731	34	13E
0005435661879	6731	35	13F
0005435681460	6731	36	14A
0005435681465	6731	37	14C
0005435661881	6731	38	14E
0005435681447	6731	39	15A
0005435661880	6731	40	15F
0005435681451	6731	41	16C
0005435681453	6731	42	17F
0005435681449	6731	43	18C
0005435681448	6731	44	18F
0005435681459	6731	45	19A
0005435681441	6731	46	19C
0005435681434	6731	47	19D
0005435681435	6731	48	19F
0005435681461	6731	49	20A
0005435630916	6731	50	20C
0005435437587	24572	1	1C
0005435437588	24572	2	2C
0005435437590	24572	3	3C
0005435220284	24572	4	3F
0005432533246	24572	5	4A
0005435437580	24572	6	4C
0005432305708	24572	7	4F
0005435437592	24572	8	5A
0005434828651	24572	9	5D
0005435437595	24572	10	7A
0005435219165	24572	11	7C
0005435437593	24572	12	8C
0005435437586	24572	13	8D
0005432533245	24572	14	8E
0005435437581	24572	15	8F
0005435437582	24572	16	9D
0005434828652	24572	17	12A
0005435437577	24572	18	12D
0005435437575	24572	19	12F
0005432533244	24572	20	13A
0005435437596	24572	21	14A
0005435437583	24572	22	14D
0005435437579	24572	23	14E
0005435437591	24572	24	15D
0005435220283	24572	25	15F
0005435437585	24572	26	16E
0005434828653	24572	27	17A
0005435437589	24572	28	17E
0005435437576	24572	29	18A
0005435437578	24572	30	18E
0005432305707	24572	31	19D
0005435437594	24572	32	19E
0005435437584	24572	33	20D
0005432533243	24572	34	20E
0005435125672	11533	1	1C
0005435125667	11533	2	1D
0005435098522	11533	3	1F
0005435125670	11533	4	2C
0005435125676	11533	5	2D
0005435105926	11533	6	2F
0005435105929	11533	7	3A
0005435105928	11533	8	3C
0005435125685	11533	9	4A
0005435125658	11533	10	4D
0005435125675	11533	11	5A
0005435125686	11533	12	5D
0005435125678	11533	13	5F
0005435125679	11533	14	6F
0005435125662	11533	15	7D
0005435125659	11533	16	8D
0005435125666	11533	17	9C
0005435125665	11533	18	9D
0005435125669	11533	19	9E
0005435125652	11533	20	9F
0005435098521	11533	21	10E
0005435125682	11533	22	11E
0005435125674	11533	23	11F
0005435125687	11533	24	12A
0005435125671	11533	25	12D
0005435125673	11533	26	12E
0005435125657	11533	27	12F
0005435105927	11533	28	13A
0005435125664	11533	29	13C
0005435125684	11533	30	14A
0005435125680	11533	31	14D
0005435125649	11533	32	14E
0005435125648	11533	33	14F
0005435125663	11533	34	15D
0005435125647	11533	35	15E
0005435125681	11533	36	16A
0005435125668	11533	37	16D
0005435125660	11533	38	16E
0005435125655	11533	39	16F
0005435125654	11533	40	17D
0005435125677	11533	41	17E
0005435125688	11533	42	17F
0005435125650	11533	43	18C
0005435125651	11533	44	18E
0005435125683	11533	45	19C
0005435125653	11533	46	19E
0005435125656	11533	47	20A
0005435125661	11533	48	20C
0005435558044	31872	1	4F
0005435558045	31872	2	5A
0005435558043	31872	3	6E
0005435558042	31872	4	7E
0005435558046	31872	5	14F
0005433397267	13533	1	1D
0005433397234	13533	2	1F
0005433397246	13533	3	2C
0005433397245	13533	4	2D
0005433397233	13533	5	2F
0005433397229	13533	6	3D
0005433397253	13533	7	3F
0005433397257	13533	8	4E
0005433397252	13533	9	5C
0005433397270	13533	10	5E
0005433397240	13533	11	6A
0005433397248	13533	12	6D
0005433397269	13533	13	6E
0005433397243	13533	14	7A
0005433397256	13533	15	7E
0005433397239	13533	16	7F
0005433397275	13533	17	8A
0005433397235	13533	18	8D
0005433397232	13533	19	9A
0005433397277	13533	20	9D
0005433397259	13533	21	9E
0005433397272	13533	22	10C
0005433397273	13533	23	10D
0005433397254	13533	24	10E
0005433397274	13533	25	10F
0005433397271	13533	26	11A
0005433397250	13533	27	11E
0005433397258	13533	28	12D
0005433397236	13533	29	12E
0005433397230	13533	30	12F
0005433397263	13533	31	13E
0005433397260	13533	32	14E
0005433397261	13533	33	14F
0005433397251	13533	34	15C
0005433397262	13533	35	15E
0005433397231	13533	36	16D
0005433397276	13533	37	16F
0005433397268	13533	38	17D
0005433397247	13533	39	17E
0005433397241	13533	40	17F
0005433397265	13533	41	18A
0005433397266	13533	42	18C
0005433397238	13533	43	18D
0005433397249	13533	44	19A
0005433397237	13533	45	19C
0005433397244	13533	46	19D
0005433397264	13533	47	19E
0005433397255	13533	48	20E
0005433397242	13533	49	20F
0005435732126	19378	1	1A
0005435732128	19378	2	1C
0005435732127	19378	3	1F
0005432297233	19378	4	5C
0005435732125	19378	5	7A
0005432297234	19378	6	20C
0005435925072	13149	1	1D
0005435925062	13149	2	3A
0005435925070	13149	3	4D
0005435925063	13149	4	7C
0005435925061	13149	5	8D
0005435925073	13149	6	9C
0005435925074	13149	7	10C
0005435925067	13149	8	12D
0005435925076	13149	9	14C
0005435925065	13149	10	15E
0005435925068	13149	11	15F
0005435925075	13149	12	17A
0005435925066	13149	13	17F
0005435925064	13149	14	18F
0005435925077	13149	15	20C
0005435925071	13149	16	20D
0005435925069	13149	17	20E
0005435068201	15478	1	1A
0005435068162	15478	2	1C
0005435068161	15478	3	2C
0005435068181	15478	4	2D
0005435068189	15478	5	2F
0005435068165	15478	6	3D
0005435068203	15478	7	4A
0005435068188	15478	8	4D
0005435068190	15478	9	4E
0005435068171	15478	10	4F
0005435068183	15478	11	5D
0005435068207	15478	12	5F
0005435068186	15478	13	7A
0005435068163	15478	14	7C
0005435068167	15478	15	7D
0005435068166	15478	16	7E
0005435068184	15478	17	8A
0005435068168	15478	18	8D
0005435068208	15478	19	9C
0005435068196	15478	20	9D
0005435068160	15478	21	9F
0005435068200	15478	22	10A
0005435068193	15478	23	10C
0005435068169	15478	24	10E
0005435068209	15478	25	11A
0005435068187	15478	26	11C
0005435068158	15478	27	11D
0005435068180	15478	28	11F
0005435068174	15478	29	12C
0005435068185	15478	30	12E
0005435068204	15478	31	12F
0005435068159	15478	32	13A
0005435068175	15478	33	14A
0005435068176	15478	34	14C
0005435068198	15478	35	14D
0005435068197	15478	36	14E
0005435068178	15478	37	14F
0005435068192	15478	38	15A
0005435068194	15478	39	15C
0005435068199	15478	40	15E
0005435068177	15478	41	15F
0005435068202	15478	42	16A
0005435068191	15478	43	16C
0005435068164	15478	44	16E
0005435068210	15478	45	16F
0005435068206	15478	46	17E
0005435068170	15478	47	18C
0005435068179	15478	48	18D
0005435068172	15478	49	19C
0005435068173	15478	50	19D
0005435068182	15478	51	19F
0005435068195	15478	52	20A
0005435068205	15478	53	20E
0005435808058	23194	1	2A
0005435808049	23194	2	2D
0005435808057	23194	3	4D
0005435808055	23194	4	5C
0005435808051	23194	5	6C
0005435808056	23194	6	7A
0005435808053	23194	7	7B
0005435808054	23194	8	19C
0005435808050	23194	9	20A
0005435808059	23194	10	21B
0005435808052	23194	11	22A
0005434213772	10689	1	1D
0005434213755	10689	2	1F
0005434213767	10689	3	2F
0005434213784	10689	4	3A
0005434213782	10689	5	3C
0005434213793	10689	6	4C
0005434213763	10689	7	4D
0005434213789	10689	8	4F
0005434213781	10689	9	5A
0005434213758	10689	10	5D
0005434213786	10689	11	5F
0005434213757	10689	12	6D
0005434213753	10689	13	6E
0005434213777	10689	14	7A
0005434213787	10689	15	7C
0005434213766	10689	16	7E
0005434213746	10689	17	7F
0005434213774	10689	18	8A
0005434213747	10689	19	8C
0005434213778	10689	20	8D
0005434213783	10689	21	8F
0005434213792	10689	22	9D
0005434213750	10689	23	9E
0005434213760	10689	24	10A
0005434213752	10689	25	10C
0005434213751	10689	26	10D
0005434213749	10689	27	11C
0005434213779	10689	28	11D
0005434213780	10689	29	11E
0005434213768	10689	30	11F
0005434213762	10689	31	12D
0005434213790	10689	32	13D
0005434213754	10689	33	13F
0005434213765	10689	34	14D
0005434213761	10689	35	14E
0005434213791	10689	36	15D
0005434213756	10689	37	16A
0005434213759	10689	38	16C
0005434213771	10689	39	16D
0005434213769	10689	40	17C
0005434213770	10689	41	17D
0005434213764	10689	42	18C
0005434213785	10689	43	18D
0005434213776	10689	44	19A
0005434213788	10689	45	19D
0005434213773	10689	46	20C
0005434213748	10689	47	20D
0005434213775	10689	48	20F
0005434755729	28649	1	1F
0005434755707	28649	2	2A
0005434755731	28649	3	2F
0005434755722	28649	4	3F
0005434755733	28649	5	4A
0005434755732	28649	6	4E
0005434755714	28649	7	4F
0005434755730	28649	8	5A
0005434755726	28649	9	5C
0005434755715	28649	10	5F
0005434755725	28649	11	6A
0005434755728	28649	12	6C
0005434755706	28649	13	8A
0005434755717	28649	14	8C
0005434755703	28649	15	9E
0005434755718	28649	16	10D
0005434755712	28649	17	12C
0005434755727	28649	18	12D
0005434755704	28649	19	13D
0005434755724	28649	20	13E
0005434755719	28649	21	14E
0005434755711	28649	22	14F
0005434755709	28649	23	15E
0005434755710	28649	24	16D
0005434755723	28649	25	16F
0005434755721	28649	26	17E
0005434755705	28649	27	17F
0005434755735	28649	28	18A
0005434755713	28649	29	18C
0005434755720	28649	30	18E
0005434755734	28649	31	18F
0005434755708	28649	32	20C
0005434755716	28649	33	20D
0005435038681	5456	1	1A
0005435006633	5456	2	1C
0005435038715	5456	3	1F
0005435038709	5456	4	1D
0005435038678	5456	5	2A
0005435006629	5456	6	2C
0005435038734	5456	7	2F
0005435038708	5456	8	2D
0005435038721	5456	9	3C
0005432125329	5456	10	3A
0005435038732	5456	11	3D
0005435038718	5456	12	3F
0005435038738	5456	13	4A
0005432125327	5456	14	4D
0005435038704	5456	15	4E
0005435038719	5456	16	4F
0005435038737	5456	17	5A
0005435038703	5456	18	5C
0005435038726	5456	19	5D
0005435038727	5456	20	5F
0005435006630	5456	21	6A
0005435006621	5456	22	6C
0005435006636	5456	23	6D
0005435038682	5456	24	6F
0005435038698	5456	25	7D
0005435038725	5456	26	7E
0005435006625	5456	27	8A
0005435006623	5456	28	7F
0005435038710	5456	29	8B
0005435038731	5456	30	8D
0005435038680	5456	31	8C
0005435038707	5456	32	8F
0005432125328	5456	33	9A
0005435038716	5456	34	9D
0005435006644	5456	35	9C
0005435038705	5456	36	9F
0005432125330	5456	37	9E
0005435038735	5456	38	10B
0005435038728	5456	39	10E
0005435038676	5456	40	10D
0005435038679	5456	41	11A
0005435038730	5456	42	11C
0005432125331	5456	43	11B
0005435006622	5456	44	11D
0005435006634	5456	45	11F
0005435038687	5456	46	11E
0005435038696	5456	47	12B
0005435038702	5456	48	12A
0005435038684	5456	49	12D
0005435038724	5456	50	12E
0005435038713	5456	51	12F
0005435006628	5456	52	13C
0005435038699	5456	53	13E
0005435006643	5456	54	13F
0005435038688	5456	55	14C
0005435038686	5456	56	14B
0005435006626	5456	57	14D
0005435038711	5456	58	14E
0005435038685	5456	59	15A
0005435006645	5456	60	14F
0005435006641	5456	61	15B
0005435038693	5456	62	15C
0005435006640	5456	63	15D
0005435006642	5456	64	15E
0005435038695	5456	65	15F
0005435038677	5456	66	16A
0005435006631	5456	67	16C
0005432125333	5456	68	16D
0005435038689	5456	69	16F
0005435038690	5456	70	16E
0005435038729	5456	71	17A
0005435038722	5456	72	17E
0005435006646	5456	73	17D
0005435038717	5456	74	18A
0005432125332	5456	75	17F
0005435006638	5456	76	18B
0005435006639	5456	77	18E
0005435006637	5456	78	18F
0005435038733	5456	79	19A
0005435006632	5456	80	19D
0005435038714	5456	81	19E
0005435038701	5456	82	20A
0005435038683	5456	83	20B
0005435038694	5456	84	20D
0005435038723	5456	85	20C
0005435038697	5456	86	20F
0005435006635	5456	87	21A
0005435038692	5456	88	21D
0005435038691	5456	89	22A
0005435006624	5456	90	21F
0005435038700	5456	91	22B
0005435038736	5456	92	22D
0005435038720	5456	93	22E
0005432125326	5456	94	22F
0005435006627	5456	95	23B
0005435038712	5456	96	23C
0005435038706	5456	97	23E
0005434228995	12969	1	2A
0005434228996	12969	2	2D
0005434228990	12969	3	3A
0005432304334	12969	4	3D
0005434229009	12969	5	4B
0005434229006	12969	6	6B
0005432304335	12969	7	7F
0005434229007	12969	8	8B
0005434228989	12969	9	9C
0005434228997	12969	10	9E
0005434228993	12969	11	9F
0005434229010	12969	12	10C
0005432304332	12969	13	11E
0005432304333	12969	14	12C
0005434229001	12969	15	12B
0005434229002	12969	16	13A
0005434228998	12969	17	14F
0005434229005	12969	18	16B
0005434229011	12969	19	16C
0005432304336	12969	20	17D
0005434228992	12969	21	17F
0005434229003	12969	22	19A
0005434229008	12969	23	20B
0005432304337	12969	24	20A
0005434229004	12969	25	20C
0005434228994	12969	26	21A
0005434228999	12969	27	22C
0005434228991	12969	28	23A
0005434229000	12969	29	23F
0005432188549	14856	1	1A
0005434411704	14856	2	2C
0005434426101	14856	3	2D
0005434426112	14856	4	2F
0005434426084	14856	5	3F
0005434426093	14856	6	4C
0005434411703	14856	7	4D
0005432188550	14856	8	4E
0005434426094	14856	9	5A
0005434411701	14856	10	5C
0005434426100	14856	11	6A
0005434426095	14856	12	6E
0005434426098	14856	13	7C
0005434426089	14856	14	7E
0005434426088	14856	15	7F
0005434426087	14856	16	8C
0005434426108	14856	17	8F
0005434426103	14856	18	9A
0005434411702	14856	19	10D
0005432188553	14856	20	10F
0005434426105	14856	21	11C
0005434426104	14856	22	11E
0005434426106	14856	23	11F
0005434426109	14856	24	12F
0005432188552	14856	25	13A
0005434426091	14856	26	14E
0005434426113	14856	27	15D
0005432188551	14856	28	15E
0005434426110	14856	29	15F
0005434426085	14856	30	16E
0005434426092	14856	31	17F
0005434426090	14856	32	18A
0005434426099	14856	33	18C
0005434426107	14856	34	18D
0005434426096	14856	35	18F
0005434426111	14856	36	19D
0005434426086	14856	37	19F
0005434426097	14856	38	20C
0005434426102	14856	39	20F
0005435902410	20208	1	2D
0005435902405	20208	2	4A
0005435902413	20208	3	5C
0005435902418	20208	4	5E
0005435902415	20208	5	6A
0005435902420	20208	6	6C
0005435902409	20208	7	8C
0005435554111	20208	8	8F
0005435902419	20208	9	10C
0005435902417	20208	10	10E
0005435902408	20208	11	12E
0005435902412	20208	12	13A
0005435902414	20208	13	13D
0005435554109	20208	14	13E
0005435902402	20208	15	13F
0005435902411	20208	16	14E
0005435902404	20208	17	14F
0005435902406	20208	18	15D
0005435554108	20208	19	15E
0005435902407	20208	20	16A
0005435554110	20208	21	17A
0005432059472	20208	22	17D
0005435902416	20208	23	17F
0005435554112	20208	24	19F
0005435902403	20208	25	20A
0005435981545	26528	1	1C
0005435981511	26528	2	1D
0005435981540	26528	3	1F
0005432300163	26528	4	2A
0005435981526	26528	5	2F
0005435981539	26528	6	3A
0005435981525	26528	7	3C
0005435981513	26528	8	4A
0005435981533	26528	9	4E
0005435981543	26528	10	5C
0005435981530	26528	11	5D
0005435981529	26528	12	5E
0005435981520	26528	13	5F
0005435981509	26528	14	6A
0005435981510	26528	15	6C
0005432300161	26528	16	6D
0005435981523	26528	17	6E
0005435981538	26528	18	7A
0005435981516	26528	19	7F
0005435981517	26528	20	8E
0005435981518	26528	21	8F
0005435981512	26528	22	9A
0005435981542	26528	23	9F
0005435981528	26528	24	10A
0005435981536	26528	25	11C
0005435981524	26528	26	11E
0005435981535	26528	27	12C
0005435981508	26528	28	12D
0005432300162	26528	29	12E
0005435981514	26528	30	13A
0005435981522	26528	31	13C
0005435981519	26528	32	14A
0005435981541	26528	33	14E
0005435981515	26528	34	15C
0005435981532	26528	35	15D
0005435981546	26528	36	16A
0005435981531	26528	37	16C
0005435981527	26528	38	16F
0005432300164	26528	39	17D
0005435981534	26528	40	18E
0005435981544	26528	41	19D
0005432300165	26528	42	19E
0005435981537	26528	43	20A
0005435981521	26528	44	20E
0005435981547	26528	45	20F
0005434270173	26697	1	1D
0005433434218	26697	2	1F
0005433434228	26697	3	2D
0005433434233	26697	4	2F
0005433434231	26697	5	3A
0005433434234	26697	6	4D
0005433434210	26697	7	5A
0005432051078	26697	8	5C
0005433434213	26697	9	5E
0005433434216	26697	10	6D
0005433434235	26697	11	6E
0005433434226	26697	12	6F
0005432051077	26697	13	7C
0005433434232	26697	14	8A
0005433434221	26697	15	8D
0005433434230	26697	16	8F
0005434271279	26697	17	9C
0005433434212	26697	18	10E
0005433434215	26697	19	11A
0005434270172	26697	20	11D
0005433434223	26697	21	11F
0005433434220	26697	22	12D
0005433434222	26697	23	12E
0005434271277	26697	24	13C
0005433434211	26697	25	13E
0005433434227	26697	26	14D
0005433434225	26697	27	14E
0005433434217	26697	28	15E
0005434271280	26697	29	16A
0005434271278	26697	30	17E
0005433434209	26697	31	17F
0005433434236	26697	32	19C
0005433434224	26697	33	19D
0005433434219	26697	34	19E
0005433434214	26697	35	20E
0005433434229	26697	36	20F
0005432583609	3165	1	1A
0005432583629	3165	2	1B
0005432216226	3165	3	1C
0005432583633	3165	4	2A
0005432583617	3165	5	2C
0005432583622	3165	6	3A
0005432216225	3165	7	3B
0005432583615	3165	8	3C
0005432583625	3165	9	3D
0005432583628	3165	10	4B
0005432583616	3165	11	4C
0005432583619	3165	12	4D
0005432216227	3165	13	5A
0005432583614	3165	14	5C
0005432583610	3165	15	5D
0005432583611	3165	16	6A
0005432583620	3165	17	7B
0005432583608	3165	18	7D
0005432583627	3165	19	18B
0005432583626	3165	20	18D
0005432583634	3165	21	19C
0005432583618	3165	22	20A
0005432583607	3165	23	20B
0005432583624	3165	24	20C
0005432583630	3165	25	20D
0005432583621	3165	26	21A
0005432583623	3165	27	21B
0005432583612	3165	28	21C
0005432583632	3165	29	22A
0005432583613	3165	30	22D
0005432583631	3165	31	23A
0005432857873	31474	1	2A
0005432857871	31474	2	3B
0005432857867	31474	3	3D
0005432857869	31474	4	4A
0005432857868	31474	5	7B
0005432857866	31474	6	7C
0005432857865	31474	7	18A
0005432857870	31474	8	18D
0005432857872	31474	9	19D
0005432857864	31474	10	20A
0005434943200	862	1	2A
0005434943203	862	2	2D
0005434943202	862	3	3C
0005434943199	862	4	6A
0005434943195	862	5	7A
0005434943196	862	6	18A
0005434943201	862	7	18B
0005434943198	862	8	19D
0005434943197	862	9	21D
0005433255030	16231	1	1B
0005433255028	16231	2	1C
0005433255027	16231	3	2C
0005433255026	16231	4	7D
0005433255029	16231	5	23A
0005433255031	16231	6	23B
0005435652273	21749	1	1A
0005435652250	21749	2	2A
0005435652277	21749	3	2C
0005435652292	21749	4	2F
0005435652252	21749	5	3A
0005435652284	21749	6	3F
0005435652258	21749	7	4D
0005435652254	21749	8	4F
0005435652260	21749	9	5D
0005435652262	21749	10	5F
0005435652279	21749	11	6F
0005435652269	21749	12	7A
0005435652257	21749	13	8A
0005435652287	21749	14	8E
0005435652281	21749	15	9C
0005435652288	21749	16	9D
0005435652296	21749	17	9E
0005435652295	21749	18	9F
0005435652264	21749	19	10C
0005435652286	21749	20	10D
0005435652263	21749	21	10F
0005435652270	21749	22	11C
0005435652268	21749	23	12C
0005435652293	21749	24	12D
0005435652271	21749	25	12E
0005435652272	21749	26	12F
0005435652255	21749	27	13C
0005435652291	21749	28	14D
0005435652290	21749	29	14E
0005435652267	21749	30	14F
0005435652274	21749	31	15A
0005435652261	21749	32	15D
0005435652275	21749	33	15E
0005435652266	21749	34	16C
0005435652294	21749	35	16D
0005435652276	21749	36	16E
0005435652282	21749	37	17D
0005435652251	21749	38	17E
0005435652256	21749	39	18A
0005435652265	21749	40	18D
0005435652253	21749	41	19C
0005435652289	21749	42	19E
0005435652280	21749	43	20A
0005435652278	21749	44	20C
0005435652283	21749	45	20D
0005435652285	21749	46	20E
0005435652259	21749	47	20F
0005433804816	9379	1	1A
0005433804799	9379	2	1C
0005433784351	9379	3	1G
0005432657397	9379	4	2A
0005433762963	9379	5	2F
0005433804813	9379	6	3A
0005433784356	9379	7	3F
0005433784365	9379	8	3C
0005433804805	9379	9	3G
0005433762970	9379	10	4B
0005433762957	9379	11	4F
0005433784336	9379	12	5F
0005432665239	9379	13	5C
0005433804806	9379	14	5G
0005433784331	9379	15	5H
0005433762965	9379	16	9G
0005433804824	9379	17	11D
0005433804804	9379	18	11B
0005433784335	9379	19	11E
0005433804814	9379	20	12A
0005433762960	9379	21	12D
0005433804811	9379	22	12B
0005433784343	9379	23	12F
0005433804820	9379	24	13D
0005433784342	9379	25	13E
0005433784345	9379	26	14F
0005433784347	9379	27	15A
0005433804826	9379	28	15G
0005432657399	9379	29	15F
0005433784337	9379	30	16B
0005433784329	9379	31	16F
0005433784364	9379	32	17D
0005433784350	9379	33	17H
0005433804815	9379	34	18D
0005433784341	9379	35	18F
0005433762972	9379	36	19B
0005433784348	9379	37	19E
0005432667420	9379	38	19H
0005433762962	9379	39	19G
0005433804818	9379	40	20A
0005433784355	9379	41	20E
0005433762971	9379	42	20D
0005433804796	9379	43	20H
0005433784333	9379	44	20G
0005433784353	9379	45	21D
0005432667418	9379	46	21E
0005433762964	9379	47	21F
0005433804797	9379	48	22D
0005433804823	9379	49	23A
0005433804801	9379	50	23E
0005433784349	9379	51	23D
0005433804800	9379	52	23B
0005433784359	9379	53	23G
0005433804825	9379	54	24A
0005433762968	9379	55	23H
0005433784332	9379	56	24E
0005433784346	9379	57	24D
0005432666354	9379	58	24H
0005433804803	9379	59	24G
0005433784340	9379	60	25D
0005433784360	9379	61	27A
0005433804808	9379	62	27B
0005433804809	9379	63	27E
0005433804821	9379	64	27D
0005433804795	9379	65	28A
0005432667419	9379	66	27H
0005433804822	9379	67	28B
0005433804819	9379	68	28E
0005433784357	9379	69	29B
0005433804802	9379	70	29G
0005433784338	9379	71	29H
0005433784352	9379	72	30A
0005433804817	9379	73	30F
0005433784339	9379	74	30E
0005433762967	9379	75	30G
0005433784334	9379	76	31F
0005433804794	9379	77	32D
0005433804807	9379	78	32E
0005433762959	9379	79	32F
0005432665240	9379	80	32G
0005432657396	9379	81	32H
0005433804798	9379	82	33B
0005432657398	9379	83	33E
0005433804812	9379	84	33D
0005433762966	9379	85	34B
0005433784366	9379	86	34F
0005433784358	9379	87	34E
0005433784354	9379	88	34H
0005433762961	9379	89	35E
0005433784330	9379	90	36D
0005433784362	9379	91	36F
0005433784361	9379	92	36G
0005433762969	9379	93	37B
0005433784344	9379	94	37E
0005433762958	9379	95	37D
0005433804828	9379	96	38D
0005433784363	9379	97	38H
0005433804810	9379	98	38G
0005433804827	9379	99	39F
0005434170812	26245	1	1B
0005434269069	26245	2	1F
0005434170824	26245	3	4F
0005434170815	26245	4	4C
0005435269643	26245	5	5B
0005434170825	26245	6	5A
0005434170822	26245	7	13E
0005435269644	26245	8	13H
0005434151654	26245	9	14A
0005434170814	26245	10	14H
0005434269068	26245	11	15F
0005434170813	26245	12	16F
0005435269646	26245	13	16H
0005434170811	26245	14	17D
0005434170820	26245	15	17E
0005434269067	26245	16	18H
0005434170817	26245	17	21E
0005434170823	26245	18	21G
0005434170821	26245	19	24F
0005435269645	26245	20	24G
0005434170819	26245	21	25E
0005434170818	26245	22	28H
0005434270170	26245	23	29D
0005435269647	26245	24	30B
0005434270171	26245	25	30G
0005434151656	26245	26	31H
0005434151655	26245	27	33H
0005434271276	26245	28	34B
0005434271275	26245	29	35E
0005434170816	26245	30	36B
0005435135588	4918	1	2C
0005435135589	4918	2	3C
0005435135586	4918	3	4C
0005435135587	4918	4	5A
0005435135590	4918	5	18C
0005435929599	33053	1	4C
0005435929598	33053	2	7A
0005434983202	9492	1	4C
0005434983199	9492	2	4D
0005434983201	9492	3	5A
0005434983200	9492	4	5D
0005434983203	9492	5	7C
0005434217901	27351	1	18C
0005434217900	27351	2	18D
0005434217899	27351	3	20C
0005433959860	25957	1	1C
0005433985134	25957	2	2B
0005433959872	25957	3	2H
0005433959896	25957	4	3A
0005433959894	25957	5	3C
0005433985124	25957	6	3F
0005433959879	25957	7	3G
0005433959878	25957	8	4B
0005433959901	25957	9	4F
0005433959875	25957	10	4H
0005433959888	25957	11	5B
0005433959903	25957	12	5F
0005433985133	25957	13	9B
0005433959882	25957	14	9G
0005433985144	25957	15	11A
0005433985140	25957	16	11E
0005433985125	25957	17	11D
0005433985149	25957	18	11F
0005433959876	25957	19	11G
0005433959898	25957	20	12H
0005433959889	25957	21	13F
0005433985147	25957	22	13G
0005433959861	25957	23	14F
0005433959883	25957	24	14G
0005433959893	25957	25	15A
0005433985146	25957	26	15B
0005433985128	25957	27	15F
0005433959902	25957	28	15G
0005433985160	25957	29	15H
0005433959865	25957	30	16D
0005433985135	25957	31	16E
0005433985151	25957	32	16G
0005433985157	25957	33	17B
0005433959870	25957	34	17D
0005433985158	25957	35	17G
0005433985123	25957	36	18A
0005433959859	25957	37	19H
0005433959873	25957	38	20A
0005433959856	25957	39	20B
0005433959884	25957	40	20H
0005433985141	25957	41	21E
0005433985132	25957	42	21D
0005433985127	25957	43	21H
0005433959895	25957	44	22A
0005433985148	25957	45	23F
0005433985156	25957	46	24A
0005433959866	25957	47	24E
0005433959877	25957	48	27D
0005433985131	25957	49	27G
0005433959881	25957	50	28E
0005433959863	25957	51	28F
0005433985130	25957	52	28H
0005433985152	25957	53	29B
0005433959899	25957	54	29D
0005433985138	25957	55	29H
0005433959869	25957	56	30D
0005433985129	25957	57	30B
0005433985143	25957	58	30E
0005433959867	25957	59	30G
0005433959864	25957	60	30H
0005433959897	25957	61	31D
0005433959891	25957	62	31G
0005433985137	25957	63	32E
0005433985126	25957	64	32H
0005433985122	25957	65	32G
0005433959886	25957	66	33A
0005433959900	25957	67	33B
0005433959885	25957	68	33E
0005433959858	25957	69	33D
0005433959887	25957	70	33F
0005433959857	25957	71	34A
0005433959871	25957	72	34D
0005433985153	25957	73	34B
0005433959862	25957	74	35A
0005433959890	25957	75	35G
0005433985142	25957	76	35H
0005433959892	25957	77	36A
0005433985154	25957	78	36E
0005433959868	25957	79	36H
0005433985159	25957	80	36G
0005433959880	25957	81	37B
0005433985139	25957	82	37E
0005433959874	25957	83	38B
0005433985136	25957	84	38E
0005433985155	25957	85	38G
0005433985145	25957	86	38H
0005433985161	25957	87	39E
0005433985150	25957	88	39F
0005434479917	948	1	1C
0005432269448	948	2	1D
0005434479923	948	3	2A
0005434479907	948	4	2B
0005434479904	948	5	2D
0005434479913	948	6	3B
0005434479924	948	7	3C
0005434479915	948	8	4D
0005434479910	948	9	5D
0005434479919	948	10	6A
0005434479906	948	11	7B
0005434479912	948	12	7C
0005434479925	948	13	7D
0005434479911	948	14	18B
0005432269449	948	15	18D
0005434479914	948	16	19C
0005432269450	948	17	19D
0005434479920	948	18	20B
0005434479905	948	19	20C
0005434479922	948	20	20D
0005434479909	948	21	21B
0005434479908	948	22	22A
0005434479921	948	23	22B
0005434479918	948	24	22C
0005434479916	948	25	22D
0005433165693	16566	1	1C
0005433165694	16566	2	2C
0005433165689	16566	3	4B
0005433165692	16566	4	18A
0005433165688	16566	5	19B
0005433165686	16566	6	19D
0005433165684	16566	7	20A
0005433165687	16566	8	20B
0005433165691	16566	9	20D
0005433165690	16566	10	21A
0005433165685	16566	11	22A
0005435149796	10341	1	1B
0005435142340	10341	2	1C
0005435149797	10341	3	1D
0005435149788	10341	4	2A
0005435142342	10341	5	2C
0005435149792	10341	6	3A
0005435149790	10341	7	3B
0005435142345	10341	8	3D
0005435142343	10341	9	5A
0005435149789	10341	10	5D
0005435149795	10341	11	6A
0005435149787	10341	12	6B
0005435149791	10341	13	6C
0005435142337	10341	14	6D
0005435142341	10341	15	7C
0005435142348	10341	16	7D
0005435142339	10341	17	18C
0005435149785	10341	18	19A
0005435142338	10341	19	19B
0005435142346	10341	20	19C
0005435149794	10341	21	20B
0005435142347	10341	22	20C
0005435142335	10341	23	20D
0005435142344	10341	24	21B
0005435149786	10341	25	21C
0005435149793	10341	26	22A
0005435142336	10341	27	22C
0005435386463	21929	1	2C
0005433289733	21929	2	2D
0005435386461	21929	3	3A
0005433289731	21929	4	5C
0005435386464	21929	5	5D
0005433289738	21929	6	6B
0005433289734	21929	7	6D
0005433289735	21929	8	7A
0005433289736	21929	9	7B
0005433289737	21929	10	18D
0005435386460	21929	11	19A
0005435386462	21929	12	19C
0005433289732	21929	13	20D
0005435386459	21929	14	21B
0005435386458	21929	15	22B
0005434573108	11232	1	2F
0005434573104	11232	2	6A
0005434573109	11232	3	8E
0005434573111	11232	4	10E
0005434573113	11232	5	10F
0005434573105	11232	6	12C
0005434573107	11232	7	14F
0005434573112	11232	8	17A
0005434573110	11232	9	17C
0005434573115	11232	10	18A
0005434573102	11232	11	18C
0005434573106	11232	12	18D
0005434573101	11232	13	18F
0005434573114	11232	14	19A
0005434573103	11232	15	19D
0005435319436	20961	1	1A
0005435501940	20961	2	1C
0005435517588	20961	3	1D
0005435517599	20961	4	2A
0005435501944	20961	5	2C
0005435501933	20961	6	2F
0005435508176	20961	7	3A
0005435501936	20961	8	3C
0005435501934	20961	9	3D
0005435501952	20961	10	4A
0005435501939	20961	11	4E
0005435319438	20961	12	4F
0005435508175	20961	13	5A
0005435508170	20961	14	5C
0005435501951	20961	15	5D
0005435517606	20961	16	5E
0005435517585	20961	17	6C
0005435517596	20961	18	6D
0005435501931	20961	19	6E
0005435517592	20961	20	6F
0005435319439	20961	21	7C
0005435319432	20961	22	7D
0005435517605	20961	23	8A
0005435517603	20961	24	7F
0005435501938	20961	25	8C
0005435517594	20961	26	8E
0005435508164	20961	27	8F
0005435508168	20961	28	9A
0005435517591	20961	29	9C
0005435517587	20961	30	9E
0005435501949	20961	31	9F
0005435517604	20961	32	10C
0005432291890	20961	33	10D
0005435319434	20961	34	10E
0005435508172	20961	35	11A
0005435501942	20961	36	11C
0005435319435	20961	37	11D
0005435319440	20961	38	11E
0005435517602	20961	39	11F
0005435508169	20961	40	12C
0005435501937	20961	41	12D
0005435517598	20961	42	12E
0005435508174	20961	43	12F
0005435508165	20961	44	13A
0005435508173	20961	45	13D
0005435501941	20961	46	13E
0005435517590	20961	47	14D
0005435508171	20961	48	14E
0005432291889	20961	49	15A
0005435517597	20961	50	15E
0005435501945	20961	51	15F
0005435508166	20961	52	16A
0005435517595	20961	53	16C
0005435319433	20961	54	16D
0005435501943	20961	55	16E
0005435319437	20961	56	16F
0005435508167	20961	57	17A
0005435501935	20961	58	17C
0005435501932	20961	59	17D
0005435501948	20961	60	18A
0005435517593	20961	61	18E
0005435501946	20961	62	19C
0005435501950	20961	63	19E
0005435501947	20961	64	19F
0005435517589	20961	65	20A
0005435517586	20961	66	20C
0005435517600	20961	67	20D
0005435517601	20961	68	20E
0005432706358	2911	1	1A
0005432706350	2911	2	1C
0005432217727	2911	3	1F
0005432706354	2911	4	2D
0005432706348	2911	5	2F
0005432706345	2911	6	3A
0005432706335	2911	7	4A
0005432706352	2911	8	4E
0005432706351	2911	9	4F
0005432706349	2911	10	6D
0005432706333	2911	11	6E
0005432706357	2911	12	7E
0005432706346	2911	13	8A
0005432217729	2911	14	8C
0005432706339	2911	15	8D
0005432706338	2911	16	9C
0005432706355	2911	17	9D
0005432706359	2911	18	9F
0005432706353	2911	19	10C
0005432706337	2911	20	10D
0005432217728	2911	21	11F
0005432706334	2911	22	12C
0005432706342	2911	23	13C
0005432706340	2911	24	13E
0005432706343	2911	25	13F
0005432217730	2911	26	15C
0005432706347	2911	27	16D
0005432706336	2911	28	17E
0005432706356	2911	29	17F
0005432706344	2911	30	18F
0005432706341	2911	31	20E
0005432692577	29980	1	1A
0005432692573	29980	2	1C
0005432692588	29980	3	1D
0005432880573	29980	4	1F
0005433123575	29980	5	2A
0005433123573	29980	6	2C
0005433123567	29980	7	2D
0005433123586	29980	8	2F
0005433123584	29980	9	3A
0005432880576	29980	10	3C
0005433123572	29980	11	3D
0005433194819	29980	12	3F
0005432692565	29980	13	4A
0005433123583	29980	14	4D
0005432692589	29980	15	4E
0005432880569	29980	16	4F
0005432692581	29980	17	5A
0005432692587	29980	18	5C
0005433123581	29980	19	5D
0005432880577	29980	20	5E
0005432692568	29980	21	5F
0005432692585	29980	22	6A
0005433123582	29980	23	6C
0005432692582	29980	24	6D
0005433123569	29980	25	6F
0005432692562	29980	26	7C
0005432692576	29980	27	7D
0005432692574	29980	28	7E
0005433123565	29980	29	8A
0005432880578	29980	30	8C
0005432692563	29980	31	8E
0005433123574	29980	32	8F
0005433123585	29980	33	9C
0005432880579	29980	34	9D
0005432692578	29980	35	9E
0005432880572	29980	36	10C
0005433123566	29980	37	10D
0005432880567	29980	38	10E
0005432692561	29980	39	10F
0005432692569	29980	40	11A
0005432692566	29980	41	11C
0005432880580	29980	42	11E
0005432692571	29980	43	11F
0005432692579	29980	44	12A
0005432692567	29980	45	12D
0005433123587	29980	46	12E
0005432692580	29980	47	12F
0005432692572	29980	48	13C
0005433123568	29980	49	14A
0005432692570	29980	50	14E
0005432692559	29980	51	14F
0005432692560	29980	52	15A
0005432880568	29980	53	15D
0005432880570	29980	54	15E
0005433194817	29980	55	15F
0005432692584	29980	56	16A
0005433123571	29980	57	16C
0005432692564	29980	58	16E
0005432880574	29980	59	16F
0005432692586	29980	60	17C
0005433123579	29980	61	17D
0005433123570	29980	62	17E
0005433123578	29980	63	17F
0005432880571	29980	64	18C
0005433123577	29980	65	18D
0005432880566	29980	66	18F
0005433123576	29980	67	19C
0005433194818	29980	68	19D
0005433123580	29980	69	19E
0005432692575	29980	70	20C
0005432880575	29980	71	20D
0005432692583	29980	72	20F
0005434979265	23701	1	1A
0005434979258	23701	2	1B
0005434979278	23701	3	1C
0005434979272	23701	4	1D
0005434979254	23701	5	2A
0005434988557	23701	6	2B
0005434988561	23701	7	2C
0005434979269	23701	8	2D
0005434979275	23701	9	3A
0005434979260	23701	10	3B
0005434979276	23701	11	3D
0005434979263	23701	12	4A
0005434979252	23701	13	4B
0005434979271	23701	14	4D
0005434988562	23701	15	5B
0005434979273	23701	16	5C
0005434979277	23701	17	6A
0005434979255	23701	18	6B
0005434979262	23701	19	6C
0005434979268	23701	20	6D
0005434979267	23701	21	7A
0005434979261	23701	22	7B
0005434979259	23701	23	7C
0005434979264	23701	24	7D
0005434979281	23701	25	18B
0005434979266	23701	26	18C
0005434988558	23701	27	18D
0005434988560	23701	28	19A
0005434979279	23701	29	19C
0005434988559	23701	30	19D
0005434979282	23701	31	20A
0005434979253	23701	32	20B
0005434979280	23701	33	20C
0005434988555	23701	34	21A
0005434988564	23701	35	21B
0005434979270	23701	36	21D
0005434979257	23701	37	22A
0005434988563	23701	38	22B
0005434979256	23701	39	22C
0005434979274	23701	40	23A
0005434988556	23701	41	23B
0005434302383	10258	1	2A
0005434302385	10258	2	3B
0005434302382	10258	3	18D
0005434302381	10258	4	20D
0005434302384	10258	5	21A
0005434302853	10258	6	21D
0005433113499	19645	1	5D
0005433113497	19645	2	7C
0005433113498	19645	3	22A
0005435068246	3553	1	1C
0005435718834	3553	2	1A
0005435068211	3553	3	1D
0005435068238	3553	4	1F
0005435068230	3553	5	2A
0005435068257	3553	6	2C
0005435068237	3553	7	3A
0005435068227	3553	8	4A
0005435068243	3553	9	4D
0005435068217	3553	10	4E
0005435068254	3553	11	4F
0005435068260	3553	12	5A
0005435068253	3553	13	5C
0005435068213	3553	14	5D
0005435068256	3553	15	5E
0005435068241	3553	16	6A
0005435068255	3553	17	6D
0005435068226	3553	18	6E
0005435068249	3553	19	6F
0005435068236	3553	20	7A
0005435068247	3553	21	7C
0005435068263	3553	22	7E
0005435068261	3553	23	8A
0005435068242	3553	24	8C
0005435068239	3553	25	8E
0005435718836	3553	26	9D
0005435068234	3553	27	10A
0005435068225	3553	28	10D
0005435068233	3553	29	10E
0005435068248	3553	30	10F
0005435068252	3553	31	11A
0005435068212	3553	32	11D
0005435718832	3553	33	12A
0005435068258	3553	34	12D
0005435068216	3553	35	12F
0005435068222	3553	36	13E
0005435068259	3553	37	14A
0005435068229	3553	38	14E
0005435068240	3553	39	14F
0005435068262	3553	40	15A
0005435068232	3553	41	15C
0005435718835	3553	42	15E
0005435718837	3553	43	16A
0005435068220	3553	44	16E
0005435068219	3553	45	17C
0005435068218	3553	46	17E
0005435718833	3553	47	17F
0005435068231	3553	48	18A
0005435068221	3553	49	18D
0005435068250	3553	50	18F
0005435068224	3553	51	18E
0005435068223	3553	52	19A
0005435068244	3553	53	19D
0005435068245	3553	54	19E
0005435068251	3553	55	20A
0005435068235	3553	56	20C
0005435068215	3553	57	20D
0005435068214	3553	58	20E
0005435068228	3553	59	20F
0005435925063	15276	1	1A
0005435925071	15276	2	1F
0005435939858	15276	3	2C
0005435925072	15276	4	3A
0005435925074	15276	5	4A
0005435925068	15276	6	5D
0005435925067	15276	7	5F
0005435925066	15276	8	6F
0005435925065	15276	9	8A
0005435925061	15276	10	8C
0005435925077	15276	11	9A
0005435925073	15276	12	10F
0005435939857	15276	13	11E
0005435925069	15276	14	12F
0005435925076	15276	15	14D
0005435925075	15276	16	14E
0005435925064	15276	17	15D
0005435925062	15276	18	18C
0005435925070	15276	19	20E
0005432658556	18221	1	2A
0005432659671	18221	2	4B
0005432658555	18221	3	5B
0005432659672	18221	4	6B
0005432658557	18221	5	6A
0005432157459	88	1	4D
0005432157460	88	2	29B
0005432261160	87	1	1F
0005432261145	87	2	2D
0005432261155	87	3	3A
0005432816986	87	4	2F
0005432816977	87	5	3C
0005432261149	87	6	3D
0005432261159	87	7	4D
0005432816983	87	8	7A
0005432816973	87	9	6F
0005432261171	87	10	8A
0005432261152	87	11	8E
0005432816994	87	12	8F
0005432816967	87	13	9A
0005432261144	87	14	9F
0005432261139	87	15	10B
0005432816995	87	16	10C
0005432261174	87	17	10E
0005432816992	87	18	10F
0005432261161	87	19	11B
0005432261150	87	20	11A
0005432261156	87	21	11C
0005432261169	87	22	11D
0005432816978	87	23	11E
0005432261140	87	24	12B
0005432261180	87	25	12C
0005432816970	87	26	13C
0005432816981	87	27	13D
0005432261142	87	28	13F
0005432261162	87	29	13E
0005432207618	87	30	14A
0005432816969	87	31	14B
0005432261172	87	32	14C
0005432261138	87	33	15B
0005432261143	87	34	15F
0005432261148	87	35	16B
0005432261158	87	36	16C
0005432816979	87	37	16F
0005432288932	87	38	17C
0005432261165	87	39	18A
0005432261136	87	40	18D
0005432261146	87	41	18C
0005432816980	87	42	19B
0005432288933	87	43	18F
0005432261173	87	44	19C
0005432288930	87	45	19D
0005432261137	87	46	20E
0005432816974	87	47	20D
0005432261178	87	48	21A
0005432261151	87	49	21C
0005432207616	87	50	21B
0005432261176	87	51	21F
0005432261170	87	52	22E
0005432261166	87	53	22F
0005432261179	87	54	23A
0005432261153	87	55	23C
0005432816984	87	56	23D
0005432816993	87	57	23F
0005432816997	87	58	24B
0005432288931	87	59	24A
0005432816985	87	60	24D
0005432816989	87	61	24E
0005432816990	87	62	24F
0005432261163	87	63	25B
0005432261147	87	64	25A
0005432816988	87	65	25E
0005432816975	87	66	25D
0005432816976	87	67	25C
0005432261177	87	68	25F
0005432261134	87	69	26C
0005432261141	87	70	27B
0005432261164	87	71	27D
0005432261154	87	72	27E
0005432261167	87	73	27F
0005432816968	87	74	28B
0005432816971	87	75	28D
0005432816991	87	76	29A
0005432261168	87	77	28F
0005432816982	87	78	29C
0005432261157	87	79	29D
0005432261175	87	80	29E
0005432816972	87	81	30A
0005432816987	87	82	30B
0005432207617	87	83	31B
0005432816996	87	84	31D
0005432261135	87	85	31E
0005433101258	7947	1	1A
0005432019812	7947	2	1C
0005432919516	7947	3	1F
0005433101272	7947	4	1D
0005432019817	7947	5	2A
0005432019818	7947	6	2C
0005432045583	7947	7	3A
0005432019805	7947	8	2F
0005432677510	7947	9	3D
0005432391951	7947	10	4A
0005433101270	7947	11	3F
0005433101269	7947	12	4C
0005432019823	7947	13	4D
0005432019813	7947	14	5A
0005432919506	7947	15	4F
0005433101271	7947	16	5D
0005432019814	7947	17	6A
0005433101231	7947	18	6C
0005432919512	7947	19	7A
0005432019832	7947	20	6F
0005432919503	7947	21	7D
0005432751473	7947	22	8A
0005432919517	7947	23	8C
0005432919515	7947	24	8B
0005432019821	7947	25	8D
0005432019808	7947	26	8E
0005432919521	7947	27	9A
0005433101266	7947	28	8F
0005433101226	7947	29	9B
0005433101267	7947	30	9C
0005432019816	7947	31	9F
0005433101263	7947	32	10A
0005432919504	7947	33	10D
0005432019820	7947	34	10C
0005432019815	7947	35	10E
0005433101251	7947	36	11A
0005432753245	7947	37	11C
0005432751472	7947	38	11B
0005433101223	7947	39	11D
0005432391948	7947	40	11E
0005432919510	7947	41	12A
0005432677507	7947	42	11F
0005432919511	7947	43	12B
0005433101224	7947	44	12D
0005433101248	7947	45	12E
0005433101250	7947	46	13B
0005432019826	7947	47	13A
0005433101221	7947	48	13D
0005433101232	7947	49	13E
0005433101245	7947	50	14A
0005432019809	7947	51	13F
0005432753246	7947	52	14B
0005432019830	7947	53	14C
0005433101261	7947	54	14D
0005432919524	7947	55	15B
0005433101275	7947	56	15A
0005432044479	7947	57	15C
0005433101257	7947	58	15D
0005433101288	7947	59	15F
0005433101241	7947	60	16B
0005433101289	7947	61	16D
0005432019831	7947	62	16C
0005433101228	7947	63	16E
0005432919522	7947	64	17A
0005432919519	7947	65	16F
0005433101265	7947	66	17C
0005433101239	7947	67	17B
0005432019810	7947	68	17E
0005432919507	7947	69	17D
0005433101235	7947	70	17F
0005433101276	7947	71	18A
0005433101290	7947	72	18C
0005433101278	7947	73	18D
0005433101246	7947	74	19B
0005433101268	7947	75	18F
0005432019828	7947	76	19C
0005432919505	7947	77	20A
0005433101233	7947	78	19E
0005432019829	7947	79	20B
0005433101252	7947	80	20C
0005432019825	7947	81	20E
0005432919520	7947	82	20D
0005432019827	7947	83	20F
0005433101264	7947	84	21C
0005433101225	7947	85	21B
0005433101259	7947	86	21D
0005433101236	7947	87	21F
0005433101277	7947	88	21E
0005433101255	7947	89	22A
0005433101243	7947	90	22B
0005433101229	7947	91	22C
0005432919508	7947	92	22E
0005433101234	7947	93	22D
0005433101279	7947	94	22F
0005433101247	7947	95	23A
0005433101254	7947	96	23C
0005432919514	7947	97	23B
0005433101283	7947	98	23E
0005433101262	7947	99	23F
0005432391950	7947	100	24B
0005433101286	7947	101	24A
0005433101230	7947	102	24C
0005432044480	7947	103	24F
0005432919513	7947	104	24E
0005432019807	7947	105	25A
0005432019819	7947	106	25C
0005433101260	7947	107	25F
0005433101237	7947	108	25E
0005432751470	7947	109	26A
0005432019806	7947	110	26B
0005432919523	7947	111	26D
0005433101242	7947	112	26C
0005433101273	7947	113	26F
0005432019822	7947	114	26E
0005433101284	7947	115	27B
0005432677508	7947	116	27A
0005433101240	7947	117	27C
0005432045582	7947	118	27D
0005433101249	7947	119	27F
0005432019824	7947	120	27E
0005433101281	7947	121	28A
0005433101222	7947	122	28B
0005433101282	7947	123	28D
0005432919518	7947	124	28C
0005433101227	7947	125	28E
0005433101256	7947	126	28F
0005433101285	7947	127	29B
0005432677509	7947	128	29D
0005433101274	7947	129	29E
0005433101253	7947	130	30A
0005432751471	7947	131	30B
0005433101244	7947	132	30D
0005433101280	7947	133	30C
0005433101238	7947	134	30E
0005432044478	7947	135	31A
0005432753247	7947	136	31B
0005432019811	7947	137	31D
0005432919509	7947	138	31C
0005433101287	7947	139	31E
0005432391949	7947	140	31F
0005432901316	7945	1	4A
0005432901313	7945	2	4D
0005432901315	7945	3	6C
0005432901327	7945	4	7D
0005432901322	7945	5	10C
0005432901318	7945	6	10E
0005432901325	7945	7	14D
0005432901324	7945	8	15D
0005432901319	7945	9	16C
0005432002043	7945	10	17E
0005432901326	7945	11	21B
0005432901323	7945	12	21F
0005432901320	7945	13	24E
0005432901317	7945	14	28A
0005432901328	7945	15	28C
0005432901314	7945	16	29C
0005432901312	7945	17	29E
0005432002042	7945	18	30F
0005432901321	7945	19	31B
0005433870693	9651	1	2A
0005433870695	9651	2	4B
0005433870694	9651	3	5B
0005434175685	32328	1	1B
0005434175686	32328	2	3A
0005434175684	32328	3	4A
0005434175683	32328	4	6A
0005434876740	3475	1	1C
0005434876652	3475	2	1G
0005432799001	3475	3	1K
0005434876748	3475	4	2C
0005434876653	3475	5	2A
0005432188554	3475	6	2H
0005432798997	3475	7	2G
0005435625882	3475	8	3A
0005435625896	3475	9	2K
0005435125726	3475	10	3G
0005434876703	3475	11	3C
0005434876718	3475	12	3H
0005434876694	3475	13	4C
0005434876689	3475	14	4G
0005432188555	3475	15	4D
0005435625883	3475	16	4K
0005434876717	3475	17	4H
0005434426138	3475	18	5C
0005434876700	3475	19	5D
0005435125699	3475	20	11A
0005434876677	3475	21	5K
0005434876709	3475	22	11D
0005434876666	3475	23	11H
0005435625888	3475	24	12C
0005434876707	3475	25	12E
0005434876656	3475	26	12D
0005435125708	3475	27	12F
0005434876672	3475	28	12K
0005435125719	3475	29	13C
0005432798994	3475	30	13E
0005435125725	3475	31	13G
0005434426118	3475	32	14A
0005434876714	3475	33	14D
0005435125722	3475	34	14G
0005434876669	3475	35	14K
0005435125712	3475	36	14H
0005432798996	3475	37	15C
0005434937812	3475	38	15E
0005434876711	3475	39	15D
0005434937831	3475	40	15H
0005434876723	3475	41	15G
0005434876741	3475	42	15F
0005435125695	3475	43	16A
0005434426131	3475	44	15K
0005435125717	3475	45	16D
0005434426125	3475	46	16F
0005434876729	3475	47	16H
0005435625889	3475	48	17C
0005435125704	3475	49	17A
0005432798992	3475	50	16K
0005432799006	3475	51	17E
0005432798987	3475	52	17D
0005435625884	3475	53	17G
0005434937816	3475	54	17F
0005435125689	3475	55	17K
0005435125718	3475	56	18C
0005435125705	3475	57	18B
0005434876708	3475	58	18A
0005434937820	3475	59	18H
0005434876678	3475	60	18K
0005435625897	3475	61	18J
0005432611644	3475	62	19F
0005434876673	3475	63	19E
0005434876692	3475	64	19D
0005434937823	3475	65	19H
0005435125706	3475	66	20A
0005434937832	3475	67	20C
0005435125690	3475	68	20E
0005434937814	3475	69	20F
0005434426119	3475	70	20K
0005435125693	3475	71	20H
0005432611642	3475	72	21A
0005435125697	3475	73	21D
0005432798983	3475	74	21C
0005434876697	3475	75	22C
0005432798998	3475	76	22B
0005434937827	3475	77	22F
0005434426139	3475	78	22E
0005432611645	3475	79	22D
0005434876663	3475	80	22G
0005435625899	3475	81	22K
0005434876695	3475	82	23B
0005434426134	3475	83	23A
0005434876690	3475	84	23D
0005434876747	3475	85	23F
0005434426116	3475	86	23E
0005432799008	3475	87	24D
0005434876712	3475	88	23K
0005434876686	3475	89	23J
0005434876710	3475	90	24E
0005434876661	3475	91	25B
0005434876684	3475	92	25D
0005434876664	3475	93	25F
0005435125721	3475	94	25E
0005434937819	3475	95	25H
0005435125720	3475	96	25G
0005434426145	3475	97	25K
0005434876683	3475	98	26C
0005434876745	3475	99	26B
0005434876667	3475	100	26A
0005432799009	3475	101	26E
0005434426126	3475	102	26D
0005434876670	3475	103	26G
0005434876706	3475	104	26K
0005432798984	3475	105	26J
0005434876682	3475	106	26H
0005435125716	3475	107	27A
0005435125698	3475	108	27D
0005434876738	3475	109	27C
0005434876658	3475	110	27B
0005434937821	3475	111	27E
0005434426114	3475	112	27H
0005435625891	3475	113	27G
0005434876662	3475	114	27F
0005432798989	3475	115	27K
0005432799000	3475	116	27J
0005435125700	3475	117	28B
0005432798995	3475	118	28E
0005434876659	3475	119	28D
0005434426136	3475	120	28G
0005434876715	3475	121	28J
0005432799004	3475	122	29B
0005435625880	3475	123	29A
0005434876732	3475	124	29D
0005435125701	3475	125	29J
0005432799003	3475	126	29G
0005434426127	3475	127	30A
0005434876726	3475	128	29K
0005434876674	3475	129	30B
0005435125727	3475	130	30D
0005434937830	3475	131	30G
0005432613795	3475	132	30H
0005434426142	3475	133	31C
0005432613796	3475	134	31B
0005432799005	3475	135	31F
0005435625892	3475	136	31H
0005434876693	3475	137	31J
0005434876687	3475	138	32A
0005434876701	3475	139	32E
0005434426122	3475	140	32D
0005435625887	3475	141	32C
0005434876688	3475	142	32G
0005434876722	3475	143	33B
0005432798993	3475	144	33A
0005434876660	3475	145	33C
0005435125715	3475	146	33F
0005434876736	3475	147	33E
0005434876728	3475	148	33J
0005435625894	3475	149	33H
0005434426143	3475	150	33K
0005435125714	3475	151	34C
0005434876685	3475	152	34B
0005432798988	3475	153	34D
0005435125728	3475	154	34G
0005434426123	3475	155	34J
0005435125692	3475	156	34H
0005435625895	3475	157	35B
0005432613793	3475	158	35A
0005434876655	3475	159	34K
0005434937825	3475	160	35C
0005434426144	3475	161	35F
0005435625885	3475	162	35E
0005435125694	3475	163	35H
0005434876716	3475	164	35K
0005435125729	3475	165	36C
0005434876665	3475	166	36B
0005434876705	3475	167	36E
0005432183431	3475	168	36G
0005435125691	3475	169	36K
0005435125707	3475	170	37A
0005434876691	3475	171	37C
0005432798990	3475	172	37E
0005434937826	3475	173	37J
0005432798999	3475	174	37H
0005434937813	3475	175	37G
0005434426132	3475	176	38A
0005434876679	3475	177	38K
0005434426137	3475	178	38J
0005432798991	3475	179	38H
0005434876676	3475	180	39A
0005434876731	3475	181	39C
0005435625890	3475	182	39F
0005434876720	3475	183	39E
0005434426130	3475	184	39J
0005434426128	3475	185	40B
0005435625886	3475	186	40E
0005434876698	3475	187	40D
0005434426129	3475	188	40G
0005434876742	3475	189	40K
0005432799002	3475	190	40J
0005435125702	3475	191	41A
0005434876733	3475	192	41D
0005434426120	3475	193	41C
0005434876735	3475	194	41F
0005434937828	3475	195	41E
0005434426117	3475	196	41H
0005432183430	3475	197	41G
0005435125711	3475	198	42A
0005435125709	3475	199	41J
0005432188556	3475	200	42C
0005434876739	3475	201	42B
0005434426124	3475	202	42J
0005434876724	3475	203	42H
0005434876737	3475	204	42K
0005434876671	3475	205	43D
0005434876746	3475	206	43C
0005434937822	3475	207	43B
0005432799010	3475	208	43F
0005432799007	3475	209	43E
0005434876734	3475	210	43J
0005434876727	3475	211	43H
0005434937824	3475	212	43G
0005435125723	3475	213	44A
0005435125710	3475	214	44C
0005434937817	3475	215	44B
0005434937829	3475	216	44F
0005434426121	3475	217	44J
0005434876675	3475	218	45B
0005434876680	3475	219	45D
0005434876713	3475	220	45G
0005434426115	3475	221	45F
0005434876744	3475	222	45E
0005434876719	3475	223	45H
0005434937818	3475	224	45K
0005432611643	3475	225	45J
0005435125713	3475	226	46C
0005432611646	3475	227	46B
0005434876704	3475	228	46A
0005434876721	3475	229	46F
0005434876730	3475	230	46K
0005432798985	3475	231	46H
0005434426140	3475	232	47A
0005434876699	3475	233	47D
0005434876696	3475	234	47F
0005434426133	3475	235	48A
0005435625898	3475	236	47K
0005434876681	3475	237	47H
0005432613794	3475	238	48C
0005434937815	3475	239	48H
0005434876743	3475	240	48G
0005434876668	3475	241	49A
0005434876657	3475	242	48K
0005435125703	3475	243	49D
0005435625893	3475	244	49F
0005435625881	3475	245	49K
0005432798986	3475	246	49H
0005435125724	3475	247	50A
0005434876702	3475	248	50E
0005434426141	3475	249	50D
0005434876725	3475	250	50G
0005435125696	3475	251	50F
0005434426135	3475	252	50K
0005434876654	3475	253	51F
0005435902405	14534	1	13F
0005435913855	14534	2	14E
0005435902404	14534	3	15A
0005435902416	14534	4	17H
0005435913851	14534	5	19B
0005435902402	14534	6	19F
0005435842313	14534	7	19K
0005435902418	14534	8	21J
0005432059472	14534	9	23B
0005435902408	14534	10	23C
0005435902419	14534	11	23H
0005435902415	14534	12	27B
0005435913852	14534	13	29G
0005435914681	14534	14	30H
0005435902420	14534	15	32F
0005435902413	14534	16	32K
0005435902417	14534	17	33D
0005435913856	14534	18	33G
0005435842311	14534	19	37K
0005435902406	14534	20	39F
0005435902403	14534	21	40J
0005435914682	14534	22	41D
0005435902412	14534	23	42C
0005435902414	14534	24	42F
0005435913853	14534	25	43A
0005435902411	14534	26	44B
0005435913857	14534	27	44A
0005435913854	14534	28	44K
0005435902409	14534	29	46G
0005435902407	14534	30	47D
0005435902410	14534	31	48C
0005435842312	14534	32	48H
0005434325461	3638	1	1A
0005434325462	3638	2	2D
0005434312283	3638	3	4C
0005434325457	3638	4	5D
0005434325456	3638	5	6B
0005434325463	3638	6	6C
0005434325459	3638	7	7D
0005434325460	3638	8	19D
0005434325464	3638	9	20B
0005434325458	3638	10	20D
0005434312284	3638	11	21A
0005434325465	3638	12	22C
0005435889798	15599	1	2C
0005435889800	15599	2	3D
0005435889796	15599	3	4C
0005435889795	15599	4	5A
0005435889794	15599	5	6A
0005435889799	15599	6	20C
0005435889797	15599	7	20D
0005435957455	616	1	1D
0005435957465	616	2	2C
0005435957454	616	3	2D
0005435957463	616	4	4D
0005435957466	616	5	6B
0005435957461	616	6	6C
0005435957468	616	7	18A
0005435957462	616	8	19B
0005435957457	616	9	19D
0005435957456	616	10	20B
0005435957464	616	11	21B
0005435957458	616	12	21D
0005435957459	616	13	22A
0005435957467	616	14	22B
0005435957460	616	15	23B
0005433420261	15158	1	2D
0005433420263	15158	2	5C
0005433420258	15158	3	7C
0005433420260	15158	4	18C
0005433420259	15158	5	19C
0005433420264	15158	6	20C
0005433420262	15158	7	21C
0005433420265	15158	8	23B
0005435629384	8875	1	3A
0005434247104	16101	1	4A
0005434247103	16101	2	6B
0005435797249	2872	1	3A
0005435797247	2872	2	4C
0005435797238	2872	3	4D
0005435797240	2872	4	6D
0005435797250	2872	5	6F
0005435797242	2872	6	8F
0005435797237	2872	7	10A
0005435797246	2872	8	11D
0005435797248	2872	9	13A
0005435797241	2872	10	14E
0005435797251	2872	11	15D
0005435797244	2872	12	16E
0005435797239	2872	13	17A
0005435797243	2872	14	18C
0005435797245	2872	15	20F
0005433404687	29307	1	6D
0005433404688	29307	2	8C
0005433404689	29307	3	10D
0005433404686	29307	4	16A
0005433404690	29307	5	16C
0005433404685	29307	6	19D
0005433404684	29307	7	19F
0005434947879	5830	1	1A
0005434947884	5830	2	1B
0005434947881	5830	3	2A
0005434947876	5830	4	2B
0005434947882	5830	5	3B
0005434947875	5830	6	4A
0005434947878	5830	7	5A
0005434947877	5830	8	6A
0005434947883	5830	9	5B
0005434947880	5830	10	6B
0005433959919	6890	1	1A
0005433959944	6890	2	1F
0005433959942	6890	3	2C
0005433959954	6890	4	2F
0005433959957	6890	5	3A
0005433959927	6890	6	3C
0005433959908	6890	7	3F
0005433959962	6890	8	4A
0005433959959	6890	9	4C
0005433959947	6890	10	4D
0005433959934	6890	11	4E
0005433959905	6890	12	4F
0005433959906	6890	13	5C
0005433959931	6890	14	5D
0005433959915	6890	15	5E
0005433959949	6890	16	5F
0005433959943	6890	17	6A
0005433959909	6890	18	6D
0005433959913	6890	19	6E
0005433959918	6890	20	7C
0005433959940	6890	21	8A
0005433959951	6890	22	9A
0005433959928	6890	23	9C
0005433959956	6890	24	9D
0005433959933	6890	25	9E
0005433959937	6890	26	9F
0005433959904	6890	27	10A
0005433959914	6890	28	10D
0005433959912	6890	29	10E
0005433959955	6890	30	11A
0005433959924	6890	31	11C
0005433959945	6890	32	11D
0005433959960	6890	33	11E
0005433959936	6890	34	12D
0005433959907	6890	35	12F
0005433959946	6890	36	13A
0005433959926	6890	37	13D
0005433959941	6890	38	13E
0005433959953	6890	39	14C
0005433959932	6890	40	14D
0005433959930	6890	41	14E
0005433959952	6890	42	15A
0005433959948	6890	43	15C
0005433959916	6890	44	15D
0005433959961	6890	45	15E
0005433959963	6890	46	15F
0005433959935	6890	47	16A
0005433959917	6890	48	16D
0005433959929	6890	49	16F
0005433959950	6890	50	17A
0005433959910	6890	51	17D
0005433959922	6890	52	17E
0005433959920	6890	53	18C
0005433959923	6890	54	18F
0005433959958	6890	55	19A
0005433959911	6890	56	19D
0005433959925	6890	57	19F
0005433959921	6890	58	20A
0005433959938	6890	59	20C
0005433959939	6890	60	20D
0005435082646	26091	1	1A
0005435082647	26091	2	2A
0005435082648	26091	3	2B
0005435082643	26091	4	3B
0005435082644	26091	5	5B
0005435082649	26091	6	6A
0005435082645	26091	7	6B
0005434244507	5142	1	3A
0005434244484	5142	2	5C
0005434244503	5142	3	7D
0005434244492	5142	4	7F
0005434244494	5142	5	8A
0005432166848	5142	6	8E
0005434244511	5142	7	8F
0005434244488	5142	8	9F
0005434244505	5142	9	10B
0005434244501	5142	10	11B
0005434244514	5142	11	11E
0005434244489	5142	12	13E
0005432166849	5142	13	14C
0005434244508	5142	14	15D
0005434244502	5142	15	17A
0005434244495	5142	16	18A
0005434244493	5142	17	20A
0005432166846	5142	18	20E
0005434244509	5142	19	21C
0005434244491	5142	20	21D
0005434244486	5142	21	21F
0005434244504	5142	22	22D
0005434244499	5142	23	23A
0005434244490	5142	24	23D
0005434244512	5142	25	24E
0005434244513	5142	26	24F
0005434244497	5142	27	25B
0005434244498	5142	28	25F
0005434244510	5142	29	27B
0005434244500	5142	30	27C
0005434244487	5142	31	27F
0005434244496	5142	32	29A
0005432166847	5142	33	29C
0005434244485	5142	34	29E
0005434244506	5142	35	30B
0005432104764	5141	1	1C
0005432104777	5141	2	1A
0005432104804	5141	3	1D
0005433613535	5141	4	2A
0005433613502	5141	5	1F
0005433613468	5141	6	2C
0005433613517	5141	7	2D
0005432104772	5141	8	3A
0005433613509	5141	9	2F
0005432104775	5141	10	3C
0005433613513	5141	11	3F
0005432104781	5141	12	3D
0005433784347	5141	13	4A
0005432104798	5141	14	4C
0005433613495	5141	15	4F
0005433613463	5141	16	4D
0005433784340	5141	17	5A
0005432104784	5141	18	5C
0005433613528	5141	19	5D
0005433613519	5141	20	6A
0005433613533	5141	21	5F
0005433613488	5141	22	6C
0005433613491	5141	23	6F
0005433613486	5141	24	6D
0005432104779	5141	25	7A
0005433613525	5141	26	7C
0005433613477	5141	27	7F
0005433784329	5141	28	7D
0005433784362	5141	29	8A
0005433613480	5141	30	8B
0005433613510	5141	31	8D
0005432666354	5141	32	8C
0005433613467	5141	33	8E
0005433613485	5141	34	8F
0005433613529	5141	35	9B
0005432104799	5141	36	9A
0005432104761	5141	37	9C
0005433784349	5141	38	9D
0005432667420	5141	39	9F
0005433784332	5141	40	9E
0005432667418	5141	41	10A
0005432104770	5141	42	10B
0005433784357	5141	43	10D
0005433784345	5141	44	10C
0005433613505	5141	45	10E
0005433784353	5141	46	10F
0005433613479	5141	47	11A
0005433613516	5141	48	11C
0005432104803	5141	49	11B
0005433784358	5141	50	11D
0005432104763	5141	51	11E
0005433613490	5141	52	11F
0005433784365	5141	53	12B
0005433613527	5141	54	12A
0005432104802	5141	55	12D
0005432104805	5141	56	12C
0005433613464	5141	57	12E
0005433613487	5141	58	12F
0005433784336	5141	59	13B
0005433613489	5141	60	13A
0005433613508	5141	61	13C
0005433784330	5141	62	13D
0005432104806	5141	63	13F
0005433613469	5141	64	13E
0005433613492	5141	65	14A
0005433613493	5141	66	14D
0005433613523	5141	67	14C
0005432104762	5141	68	14E
0005433613532	5141	69	14F
0005432104786	5141	70	15B
0005433784351	5141	71	15A
0005432104787	5141	72	15C
0005433784334	5141	73	15E
0005433613507	5141	74	15D
0005432104789	5141	75	16A
0005432104785	5141	76	15F
0005433613476	5141	77	16C
0005433784342	5141	78	16B
0005433784337	5141	79	16D
0005432145078	5141	80	16E
0005432104801	5141	81	16F
0005433613471	5141	82	17A
0005433613515	5141	83	17C
0005433613499	5141	84	17B
0005433613461	5141	85	17E
0005432104771	5141	86	17D
0005433613494	5141	87	17F
0005433784363	5141	88	18A
0005433784344	5141	89	18C
0005433613526	5141	90	18B
0005433784366	5141	91	18E
0005432104800	5141	92	18D
0005433784350	5141	93	19B
0005433613498	5141	94	18F
0005433784354	5141	95	19D
0005433613506	5141	96	19C
0005432104807	5141	97	20A
0005432104793	5141	98	19E
0005432104766	5141	99	20B
0005432104778	5141	100	20C
0005433784331	5141	101	20E
0005432104767	5141	102	20D
0005432104765	5141	103	20F
0005433613465	5141	104	21B
0005432104783	5141	105	21A
0005433613462	5141	106	21D
0005433613521	5141	107	21C
0005432104760	5141	108	21E
0005432104791	5141	109	21F
0005433613482	5141	110	22A
0005433613512	5141	111	22C
0005433784360	5141	112	22B
0005433613474	5141	113	22D
0005433613497	5141	114	22F
0005432104776	5141	115	22E
0005432104795	5141	116	23A
0005433613520	5141	117	23C
0005433784343	5141	118	23B
0005433613500	5141	119	23D
0005433784335	5141	120	23F
0005432104774	5141	121	23E
0005432104796	5141	122	24A
0005432104782	5141	123	24B
0005433613501	5141	124	24D
0005433784348	5141	125	24C
0005433613466	5141	126	24F
0005433613524	5141	127	24E
0005433613496	5141	128	25B
0005432104769	5141	129	25A
0005433613470	5141	130	25C
0005432104797	5141	131	25E
0005433784352	5141	132	25D
0005433613478	5141	133	25F
0005432104780	5141	134	26A
0005433613518	5141	135	26B
0005433613514	5141	136	26C
0005433784364	5141	137	26E
0005433784361	5141	138	26D
0005432665240	5141	139	26F
0005433784333	5141	140	27B
0005433784356	5141	141	27A
0005433613472	5141	142	27C
0005433784341	5141	143	27D
0005432104808	5141	144	27E
0005432104768	5141	145	28A
0005433613530	5141	146	27F
0005432104788	5141	147	28C
0005433613484	5141	148	28B
0005433613511	5141	149	28E
0005432104792	5141	150	28D
0005433784359	5141	151	28F
0005433613473	5141	152	29B
0005433613531	5141	153	29A
0005433613534	5141	154	29C
0005433613504	5141	155	29D
0005433784338	5141	156	29F
0005433613483	5141	157	29E
0005432104790	5141	158	30A
0005433784339	5141	159	30B
0005432104773	5141	160	30C
0005433613522	5141	161	30E
0005433613481	5141	162	30D
0005433613475	5141	163	30F
0005432667419	5141	164	31A
0005433784346	5141	165	31C
0005432104794	5141	166	31B
0005433613503	5141	167	31D
0005432665239	5141	168	31F
0005433784355	5141	169	31E
0005434229008	5137	1	1C
0005434149543	5137	2	1F
0005434264708	5137	3	2C
0005434149535	5137	4	2F
0005434228990	5137	5	4A
0005434149532	5137	6	4C
0005434229005	5137	7	5D
0005434264727	5137	8	5C
0005434229006	5137	9	5F
0005434173452	5137	10	6F
0005434264726	5137	11	7D
0005434228992	5137	12	8D
0005434264712	5137	13	8F
0005434149534	5137	14	9B
0005434229011	5137	15	9A
0005434264719	5137	16	9D
0005434264703	5137	17	10B
0005434229002	5137	18	10D
0005434264711	5137	19	11A
0005434228995	5137	20	11C
0005434264723	5137	21	11D
0005434264710	5137	22	11F
0005434264705	5137	23	12B
0005434264715	5137	24	12C
0005434228997	5137	25	12E
0005434173454	5137	26	12F
0005434229000	5137	27	13D
0005434264707	5137	28	13E
0005434264718	5137	29	14A
0005434229004	5137	30	14D
0005434228996	5137	31	14E
0005434264724	5137	32	15A
0005434229009	5137	33	15B
0005434149542	5137	34	15D
0005434149541	5137	35	15F
0005434228989	5137	36	16D
0005434264706	5137	37	17E
0005434264713	5137	38	17F
0005434149540	5137	39	18C
0005434149537	5137	40	18F
0005434149538	5137	41	19C
0005434228998	5137	42	20E
0005434264720	5137	43	21F
0005434173455	5137	44	22A
0005434264717	5137	45	22C
0005434229010	5137	46	22D
0005434264709	5137	47	23B
0005434264714	5137	48	23A
0005434228994	5137	49	24A
0005434264725	5137	50	25D
0005434264722	5137	51	26C
0005434229001	5137	52	26B
0005434149539	5137	53	27B
0005434229003	5137	54	27C
0005434173453	5137	55	28C
0005434264702	5137	56	29B
0005434228999	5137	57	29D
0005434229007	5137	58	29E
0005434264716	5137	59	29F
0005434264721	5137	60	30C
0005434264704	5137	61	30E
0005434149533	5137	62	30D
0005434228993	5137	63	30F
0005434228991	5137	64	31C
0005434149536	5137	65	31D
0005435269643	8602	1	4F
0005435269647	8602	2	8F
0005435269645	8602	3	10D
0005435269646	8602	4	12C
0005435269644	8602	5	15F
0005432034495	8600	1	1F
0005433815308	8600	2	2C
0005432034481	8600	3	2F
0005432335835	8600	4	2D
0005432034485	8600	5	3A
0005432034492	8600	6	3D
0005433689877	8600	7	3C
0005435286544	8600	8	4F
0005432335843	8600	9	5A
0005432034479	8600	10	5C
0005435006635	8600	11	6C
0005433690893	8600	12	6F
0005435006634	8600	13	6D
0005432335841	8600	14	7A
0005432034503	8600	15	7C
0005433688776	8600	16	7F
0005435286548	8600	17	8A
0005432047488	8600	18	8C
0005435006645	8600	19	8B
0005432047491	8600	20	8D
0005435286547	8600	21	8F
0005435006623	8600	22	9B
0005432034490	8600	23	10A
0005435006639	8600	24	10B
0005435006644	8600	25	10D
0005432335833	8600	26	10E
0005432034505	8600	27	11A
0005435006642	8600	28	10F
0005432034482	8600	29	11B
0005432335837	8600	30	11C
0005432335834	8600	31	11F
0005432335836	8600	32	11E
0005432034496	8600	33	12B
0005435006621	8600	34	12E
0005435006628	8600	35	12F
0005432034488	8600	36	13A
0005433815306	8600	37	13D
0005435286545	8600	38	14A
0005435286539	8600	39	13F
0005435006631	8600	40	14B
0005432034497	8600	41	14E
0005435006641	8600	42	15A
0005433815309	8600	43	14F
0005432034484	8600	44	16B
0005435006629	8600	45	16E
0005432034491	8600	46	17A
0005432034504	8600	47	16F
0005432034486	8600	48	17C
0005435006636	8600	49	17E
0005435286542	8600	50	18B
0005435286541	8600	51	18D
0005435006625	8600	52	18E
0005435006630	8600	53	18F
0005432335832	8600	54	19C
0005435006632	8600	55	19D
0005432047489	8600	56	20A
0005432034502	8600	57	20E
0005434311184	8600	58	21A
0005435286538	8600	59	20F
0005435286540	8600	60	21C
0005432335839	8600	61	22B
0005432034498	8600	62	22D
0005435006640	8600	63	22F
0005435006633	8600	64	23D
0005432034500	8600	65	23C
0005432034501	8600	66	23E
0005432335844	8600	67	23F
0005432034478	8600	68	24B
0005432335838	8600	69	24E
0005435006626	8600	70	24F
0005435286546	8600	71	25B
0005433815307	8600	72	25C
0005432034489	8600	73	25F
0005435006622	8600	74	25E
0005432034499	8600	75	26A
0005433689876	8600	76	26C
0005435006637	8600	77	26E
0005432047490	8600	78	27B
0005432034480	8600	79	27D
0005432047487	8600	80	28A
0005432335842	8600	81	28D
0005432034483	8600	82	28E
0005432335840	8600	83	28F
0005432034493	8600	84	29B
0005435006638	8600	85	29A
0005435006646	8600	86	29E
0005435006627	8600	87	29D
0005435006643	8600	88	29C
0005435006624	8600	89	30A
0005432034494	8600	90	30C
0005434311183	8600	91	30E
0005432034487	8600	92	30D
0005435286543	8600	93	31E
0005433202129	12625	1	1C
0005433202125	12625	2	2D
0005433202123	12625	3	3D
0005433202126	12625	4	4A
0005433202130	12625	5	4D
0005433202127	12625	6	5A
0005433202122	12625	7	5B
0005433202120	12625	8	5D
0005433202131	12625	9	6B
0005433202124	12625	10	7A
0005433202132	12625	11	19C
0005433202128	12625	12	21B
0005433202118	12625	13	21D
0005433202117	12625	14	22B
0005433202121	12625	15	23A
0005433202119	12625	16	23B
0005434638853	23345	1	1A
0005434638874	23345	2	1B
0005434638854	23345	3	1C
0005434638850	23345	4	1D
0005432290582	23345	5	2A
0005434638848	23345	6	2B
0005434638852	23345	7	2C
0005432290579	23345	8	3D
0005432290580	23345	9	4B
0005434638862	23345	10	4C
0005434638869	23345	11	5A
0005434638851	23345	12	4D
0005434638875	23345	13	5B
0005434638871	23345	14	5C
0005434638855	23345	15	5D
0005434638865	23345	16	6A
0005434638873	23345	17	6B
0005432290581	23345	18	6C
0005434638868	23345	19	6D
0005434638870	23345	20	7A
0005434638861	23345	21	7B
0005434638858	23345	22	18B
0005434638856	23345	23	18C
0005434638846	23345	24	19A
0005434638867	23345	25	19B
0005434638860	23345	26	19C
0005434638859	23345	27	20C
0005434638866	23345	28	20D
0005434638872	23345	29	21B
0005434638863	23345	30	21C
0005434638857	23345	31	22A
0005434638849	23345	32	22B
0005434638864	23345	33	22C
0005434638847	23345	34	23B
0005432054255	21096	1	9D
0005432054256	21096	2	12C
0005432054257	21096	3	14F
0005432327901	31264	1	1A
0005432287101	31264	2	1C
0005432327922	31264	3	1D
0005432382510	31264	4	1F
0005432327910	31264	5	2C
0005432327936	31264	6	2D
0005432382504	31264	7	2F
0005432327931	31264	8	3C
0005432327897	31264	9	3D
0005432382505	31264	10	3F
0005432327892	31264	11	4A
0005432327914	31264	12	4C
0005432382496	31264	13	4D
0005432382511	31264	14	4E
0005432382516	31264	15	4F
0005432382512	31264	16	5A
0005432327915	31264	17	5C
0005432327900	31264	18	5D
0005432382488	31264	19	5E
0005432382500	31264	20	5F
0005432327890	31264	21	6A
0005432382492	31264	22	6C
0005432382495	31264	23	6D
0005432327891	31264	24	6E
0005432382509	31264	25	6F
0005432327920	31264	26	7A
0005432382493	31264	27	7C
0005432327935	31264	28	7D
0005432382485	31264	29	7E
0005432327909	31264	30	7F
0005432327893	31264	31	8A
0005432327932	31264	32	8C
0005432327906	31264	33	8D
0005432327929	31264	34	8E
0005432382513	31264	35	8F
0005432327913	31264	36	9A
0005432327908	31264	37	9C
0005432327923	31264	38	9D
0005432327926	31264	39	9F
0005432382497	31264	40	10A
0005432327896	31264	41	10C
0005432287099	31264	42	10D
0005432327924	31264	43	10E
0005432382520	31264	44	10F
0005432327912	31264	45	11A
0005432382514	31264	46	11C
0005432287102	31264	47	11D
0005432382518	31264	48	11E
0005432382517	31264	49	11F
0005432327937	31264	50	12A
0005432287104	31264	51	12C
0005432327930	31264	52	12D
0005432382508	31264	53	12E
0005432382501	31264	54	12F
0005432287103	31264	55	13A
0005432382484	31264	56	13C
0005432382502	31264	57	13D
0005432382491	31264	58	13E
0005432382494	31264	59	13F
0005432327916	31264	60	14A
0005432327927	31264	61	14C
0005432327928	31264	62	14D
0005432382486	31264	63	14E
0005432382507	31264	64	14F
0005432327905	31264	65	15A
0005432287105	31264	66	15C
0005432382506	31264	67	15D
0005432382487	31264	68	15E
0005432327898	31264	69	15F
0005432382503	31264	70	16A
0005432327933	31264	71	16C
0005432327904	31264	72	16D
0005432382519	31264	73	16E
0005432327903	31264	74	16F
0005432327902	31264	75	17A
0005432327934	31264	76	17D
0005432327919	31264	77	17E
0005432327918	31264	78	17F
0005432382490	31264	79	18A
0005432327895	31264	80	18C
0005432382489	31264	81	18D
0005432382515	31264	82	18E
0005432327907	31264	83	18F
0005432327911	31264	84	19A
0005432327921	31264	85	19C
0005432287100	31264	86	19D
0005432327899	31264	87	19E
0005432382499	31264	88	19F
0005432327917	31264	89	20A
0005432327894	31264	90	20C
0005432382498	31264	91	20E
0005432327925	31264	92	20F
0005432423644	13305	1	1A
0005432423643	13305	2	1F
0005432423636	13305	3	2A
0005432423645	13305	4	3A
0005432423647	13305	5	3C
0005432423614	13305	6	4A
0005432423605	13305	7	4F
0005432423613	13305	8	5E
0005432423639	13305	9	5F
0005432423616	13305	10	6C
0005432423615	13305	11	6F
0005432423604	13305	12	7C
0005432423631	13305	13	7F
0005432423621	13305	14	8E
0005432423629	13305	15	8F
0005432423626	13305	16	9C
0005432423612	13305	17	9D
0005432423607	13305	18	9E
0005432423627	13305	19	10A
0005432423618	13305	20	10E
0005432423609	13305	21	11D
0005432423640	13305	22	12D
0005432423622	13305	23	13D
0005432423617	13305	24	13F
0005432423606	13305	25	14D
0005432423637	13305	26	15A
0005432423632	13305	27	15C
0005432423630	13305	28	15D
0005432423608	13305	29	16C
0005432423624	13305	30	16D
0005432423628	13305	31	16E
0005432423638	13305	32	16F
0005432423633	13305	33	17A
0005432423623	13305	34	17E
0005432423642	13305	35	17F
0005432423611	13305	36	18A
0005432423620	13305	37	18C
0005432423635	13305	38	18D
0005432423625	13305	39	18F
0005432423610	13305	40	19A
0005432423619	13305	41	19E
0005432423641	13305	42	20A
0005432423634	13305	43	20C
0005432423646	13305	44	20D
0005432816992	9586	1	1A
0005432822074	9586	2	1F
0005434448259	9586	3	2A
0005432816968	9586	4	2C
0005432816972	9586	5	2F
0005432822077	9586	6	3A
0005434448257	9586	7	4C
0005432816971	9586	8	5F
0005432816994	9586	9	6A
0005432816985	9586	10	6C
0005434448260	9586	11	6D
0005432816978	9586	12	7C
0005432288930	9586	13	7D
0005432816967	9586	14	7F
0005432816976	9586	15	8A
0005432816983	9586	16	8D
0005432816970	9586	17	9E
0005432288933	9586	18	9F
0005432822079	9586	19	10C
0005432822075	9586	20	10D
0005432816997	9586	21	11A
0005432816969	9586	22	10F
0005432816982	9586	23	11C
0005432816991	9586	24	12E
0005432816996	9586	25	12F
0005432816973	9586	26	13C
0005432816975	9586	27	13F
0005432816974	9586	28	14A
0005432816977	9586	29	14C
0005434448258	9586	30	14D
0005432816990	9586	31	14E
0005432816988	9586	32	15D
0005432822076	9586	33	15E
0005432816995	9586	34	15F
0005432816979	9586	35	16C
0005432816987	9586	36	16E
0005432822078	9586	37	17D
0005432288932	9586	38	18A
0005432816984	9586	39	18C
0005432822073	9586	40	18E
0005432816993	9586	41	18F
0005432816986	9586	42	19A
0005432288931	9586	43	20A
0005432816989	9586	44	20C
0005432816980	9586	45	20D
0005432816981	9586	46	20F
0005434157350	28956	1	1D
0005432901312	28956	2	2C
0005432901322	28956	3	2D
0005432901321	28956	4	2F
0005432901317	28956	5	3A
0005432901328	28956	6	3F
0005434186147	28956	7	4C
0005432901325	28956	8	4F
0005434157349	28956	9	5D
0005434157352	28956	10	6A
0005432002042	28956	11	6C
0005434157347	28956	12	6E
0005432002043	28956	13	7C
0005432901318	28956	14	7D
0005432901327	28956	15	8C
0005434157353	28956	16	9E
0005432901315	28956	17	9F
0005434157355	28956	18	10E
0005432901324	28956	19	12E
0005432901316	28956	20	13C
0005432901326	28956	21	13F
0005432901323	28956	22	14D
0005434157354	28956	23	14F
0005434186149	28956	24	15F
0005432901313	28956	25	17D
0005434186148	28956	26	17E
0005432901320	28956	27	17F
0005432901314	28956	28	19A
0005434157351	28956	29	20A
0005434157348	28956	30	20C
0005432901319	28956	31	20E
0005432613795	15046	1	1A
0005432611642	15046	2	2B
0005432613794	15046	3	2A
0005432613796	15046	4	3A
0005432611644	15046	5	3B
0005432611646	15046	6	4A
0005432611643	15046	7	5A
0005432611645	15046	8	5B
0005432613793	15046	9	6A
0005435842311	31614	1	1B
0005435842312	31614	2	3A
0005435842313	31614	3	3B
0005433568046	11845	1	1C
0005433568047	11845	2	2A
0005433568026	11845	3	3C
0005433568015	11845	4	4A
0005433568049	11845	5	3F
0005433568055	11845	6	4C
0005433568025	11845	7	5F
0005433568033	11845	8	6A
0005433568051	11845	9	6C
0005433568028	11845	10	6B
0005433568044	11845	11	6E
0005433568065	11845	12	7C
0005433568036	11845	13	7D
0005433568067	11845	14	8B
0005433568042	11845	15	8C
0005433568043	11845	16	8F
0005433568062	11845	17	9A
0005433568021	11845	18	9D
0005433568041	11845	19	9C
0005433568016	11845	20	9B
0005433568048	11845	21	9F
0005433568050	11845	22	10B
0005433568023	11845	23	10E
0005433568068	11845	24	10D
0005433568061	11845	25	10F
0005433568064	11845	26	11C
0005433568038	11845	27	11D
0005433568035	11845	28	12B
0005433568024	11845	29	12C
0005433568052	11845	30	12E
0005433568037	11845	31	13D
0005433568032	11845	32	13F
0005433568058	11845	33	14B
0005433568040	11845	34	14A
0005433568053	11845	35	14C
0005433568059	11845	36	15B
0005433568031	11845	37	15A
0005433568039	11845	38	15F
0005433568063	11845	39	16E
0005433568030	11845	40	16D
0005433568027	11845	41	17B
0005433568017	11845	42	17D
0005433568022	11845	43	17C
0005433568066	11845	44	17F
0005433568060	11845	45	18C
0005433568054	11845	46	19A
0005433568019	11845	47	19C
0005433568018	11845	48	19B
0005433568056	11845	49	19D
0005433568029	11845	50	19F
0005433568057	11845	51	20D
0005433568020	11845	52	20E
0005433568034	11845	53	21F
0005433568045	11845	54	21D
0005432947818	25291	1	2F
0005432947821	25291	2	3A
0005432947822	25291	3	3D
0005432947829	25291	4	3C
0005432947842	25291	5	3F
0005432947845	25291	6	5C
0005432947833	25291	7	5A
0005432947837	25291	8	6C
0005432947831	25291	9	6D
0005432947816	25291	10	7E
0005432947828	25291	11	8C
0005432947835	25291	12	8E
0005432947826	25291	13	9A
0005432947809	25291	14	9E
0005432947810	25291	15	10C
0005432947836	25291	16	10E
0005432947807	25291	17	10F
0005432947840	25291	18	11C
0005432947844	25291	19	11F
0005432947815	25291	20	11E
0005432947839	25291	21	12C
0005432947843	25291	22	12B
0005432947814	25291	23	13D
0005432947832	25291	24	13F
0005432947841	25291	25	14B
0005432947820	25291	26	14A
0005432947819	25291	27	14D
0005432947830	25291	28	14F
0005432947823	25291	29	15D
0005432947834	25291	30	16A
0005432947838	25291	31	16F
0005432947806	25291	32	17B
0005432947817	25291	33	17F
0005432947825	25291	34	18B
0005432947805	25291	35	18D
0005432947813	25291	36	19A
0005432947808	25291	37	19D
0005432947824	25291	38	20A
0005432947811	25291	39	20E
0005432947827	25291	40	21D
0005432947812	25291	41	21C
0005434654217	5367	1	1A
0005434654214	5367	2	1D
0005434654190	5367	3	1F
0005434654199	5367	4	2A
0005434654205	5367	5	2F
0005434654215	5367	6	4C
0005434654204	5367	7	4D
0005432114150	5367	8	4E
0005434654202	5367	9	4F
0005432114149	5367	10	5C
0005434654200	5367	11	5E
0005434656523	5367	12	6A
0005434654201	5367	13	6D
0005434654213	5367	14	6F
0005434654198	5367	15	7F
0005434656522	5367	16	9A
0005434654207	5367	17	9C
0005434654216	5367	18	9D
0005434654193	5367	19	9F
0005434654194	5367	20	10C
0005434654212	5367	21	10D
0005434654218	5367	22	10F
0005434654196	5367	23	11E
0005434654195	5367	24	12A
0005434654208	5367	25	14C
0005434654189	5367	26	14E
0005434654209	5367	27	14F
0005434654197	5367	28	15A
0005434654192	5367	29	16D
0005434654203	5367	30	16E
0005434654211	5367	31	19A
0005434654206	5367	32	19C
0005434654210	5367	33	20A
0005434654191	5367	34	20E
0005435340013	12534	1	2C
0005435340016	12534	2	3D
0005435340015	12534	3	4A
0005435340008	12534	4	4D
0005435340010	12534	5	5C
0005435340018	12534	6	9E
0005435340006	12534	7	10C
0005435555337	12534	8	11C
0005435340014	12534	9	13C
0005435340017	12534	10	14F
0005435340011	12534	11	15A
0005435340007	12534	12	15F
0005435340004	12534	13	16E
0005435340012	12534	14	18E
0005435340009	12534	15	19C
0005435340005	12534	16	19D
0005435555336	12534	17	19F
0005433689875	7431	1	1A
0005433715123	7431	2	1D
0005433715121	7431	3	2A
0005433715137	7431	4	2D
0005433715159	7431	5	2F
0005433715120	7431	6	3C
0005433722102	7431	7	4B
0005433715126	7431	8	4A
0005433715146	7431	9	4E
0005433715129	7431	10	4F
0005433715125	7431	11	5A
0005433715147	7431	12	5C
0005433715151	7431	13	5D
0005433715157	7431	14	5E
0005433715118	7431	15	5F
0005433722104	7431	16	6B
0005433688773	7431	17	6F
0005433722103	7431	18	7B
0005433715158	7431	19	7D
0005433715134	7431	20	7F
0005433715116	7431	21	8A
0005433656613	7431	22	8B
0005433715135	7431	23	8D
0005433715132	7431	24	8C
0005433715155	7431	25	8E
0005433715150	7431	26	8F
0005433715124	7431	27	9A
0005433690892	7431	28	9C
0005433715128	7431	29	9D
0005433715139	7431	30	9F
0005433715145	7431	31	10B
0005433715131	7431	32	10C
0005433715133	7431	33	10E
0005433688775	7431	34	11B
0005433715153	7431	35	11F
0005433715122	7431	36	12B
0005433715152	7431	37	12D
0005433715156	7431	38	12E
0005433715130	7431	39	12F
0005433715136	7431	40	13B
0005433715164	7431	41	13C
0005433715154	7431	42	13F
0005433715162	7431	43	14B
0005433715119	7431	44	14D
0005433715148	7431	45	14E
0005433656614	7431	46	14F
0005433688774	7431	47	15D
0005433715140	7431	48	15E
0005433715163	7431	49	15F
0005432078016	7431	50	16B
0005433715160	7431	51	16A
0005433719081	7431	52	16C
0005433719082	7431	53	16F
0005433715143	7431	54	17A
0005433722106	7431	55	17C
0005433715144	7431	56	17D
0005433719083	7431	57	17F
0005433715127	7431	58	18B
0005433715149	7431	59	18A
0005432078018	7431	60	18D
0005433689874	7431	61	18C
0005433715138	7431	62	18E
0005433715161	7431	63	18F
0005433715166	7431	64	19C
0005433690891	7431	65	19D
0005433690890	7431	66	19F
0005433715167	7431	67	20C
0005433715165	7431	68	20E
0005433722105	7431	69	21A
0005433715141	7431	70	21C
0005433715142	7431	71	21E
0005433715117	7431	72	21F
0005433719080	7431	73	22F
0005432078017	7431	74	23C
0005432006711	29207	1	1C
0005432428871	29207	2	7E
0005432428872	29207	3	12E
0005432006713	29207	4	19B
0005432428870	29207	5	19D
0005432006712	29207	6	19F
0005432428873	29207	7	20A
0005434095031	8697	1	1A
0005434095030	8697	2	3A
0005434095038	8697	3	6D
0005434095036	8697	4	7D
0005434095035	8697	5	8F
0005434095041	8697	6	9E
0005434095033	8697	7	10A
0005434095040	8697	8	11E
0005434095042	8697	9	12D
0005434095043	8697	10	14F
0005434095039	8697	11	15A
0005434095037	8697	12	16D
0005434095032	8697	13	20A
0005434095034	8697	14	20E
0005434181978	11638	1	1C
0005434181981	11638	2	3F
0005434183544	11638	3	4E
0005434181974	11638	4	4F
0005434181969	11638	5	6E
0005434183543	11638	6	6F
0005434181976	11638	7	7A
0005434184629	11638	8	8F
0005434181977	11638	9	9D
0005434184630	11638	10	10D
0005434181973	11638	11	12E
0005434181970	11638	12	13D
0005434183546	11638	13	13F
0005434181972	11638	14	14E
0005434181980	11638	15	16A
0005434181975	11638	16	17F
0005434181979	11638	17	18A
0005434183545	11638	18	19D
0005434181971	11638	19	20E
0005435732127	1430	1	7A
0005432297233	1430	2	8E
0005435732126	1430	3	10A
0005433456901	1430	4	10D
0005433456903	1430	5	10F
0005435732128	1430	6	15F
0005432297234	1430	7	16F
0005435732125	1430	8	17D
0005433456904	1430	9	17E
0005433456902	1430	10	20D
0005433397260	19277	1	1A
0005433397259	19277	2	1D
0005433397254	19277	3	1F
0005433397266	19277	4	2C
0005433397268	19277	5	2F
0005433397233	19277	6	3D
0005433397269	19277	7	4C
0005433397235	19277	8	4E
0005432906495	19277	9	4F
0005433397261	19277	10	6A
0005433397256	19277	11	6C
0005433397253	19277	12	6D
0005433397243	19277	13	6F
0005433397272	19277	14	7A
0005433397234	19277	15	7D
0005433397277	19277	16	7E
0005433397231	19277	17	7F
0005432906493	19277	18	8C
0005433397267	19277	19	8D
0005433397247	19277	20	8F
0005433397237	19277	21	9C
0005433397271	19277	22	9D
0005433397262	19277	23	9F
0005433397230	19277	24	10A
0005433397276	19277	25	10D
0005433397264	19277	26	10E
0005433397245	19277	27	10F
0005433397275	19277	28	11A
0005433397274	19277	29	11D
0005433397241	19277	30	11E
0005433397229	19277	31	11F
0005433397250	19277	32	12E
0005433397255	19277	33	12F
0005433397232	19277	34	13A
0005433397246	19277	35	13D
0005433397240	19277	36	14C
0005433397251	19277	37	14F
0005433397258	19277	38	15A
0005433397257	19277	39	15C
0005432906494	19277	40	15E
0005433397249	19277	41	16A
0005433397239	19277	42	16E
0005433397270	19277	43	16F
0005433397252	19277	44	17A
0005433397273	19277	45	17F
0005433397244	19277	46	18C
0005433397238	19277	47	18E
0005433397263	19277	48	19A
0005433397242	19277	49	19C
0005433397248	19277	50	19F
0005433397236	19277	51	20A
0005433397265	19277	52	20E
0005434443425	20554	1	2A
0005434443434	20554	2	2C
0005434443432	20554	3	3B
0005434443439	20554	4	3D
0005434443433	20554	5	4A
0005434443435	20554	6	5A
0005434443430	20554	7	5B
0005434443424	20554	8	5D
0005434443426	20554	9	6A
0005434443436	20554	10	7B
0005434443429	20554	11	18C
0005434443438	20554	12	20C
0005434443437	20554	13	21A
0005434443427	20554	14	21C
0005434443431	20554	15	22C
0005434443428	20554	16	22D
0005434954542	7285	1	1A
0005434954541	7285	2	2B
0005434954543	7285	3	3B
0005434954545	7285	4	4A
0005434954544	7285	5	6B
0005435377540	28343	1	2A
0005435377539	28343	2	6B
0005434351483	4494	1	2B
0005434351481	4494	2	2C
0005434351480	4494	3	2D
0005434351488	4494	4	4C
0005434351478	4494	5	5C
0005434351489	4494	6	6D
0005434351486	4494	7	18B
0005434351487	4494	8	18A
0005434351484	4494	9	19B
0005434351485	4494	10	20B
0005434351477	4494	11	21C
0005434351479	4494	12	21D
0005434351482	4494	13	22C
0005435893516	29644	1	1B
0005435893512	29644	2	2C
0005435893510	29644	3	5A
0005435893515	29644	4	5C
0005435893513	29644	5	7B
0005435893511	29644	6	7D
0005435893514	29644	7	22A
0005435893517	29644	8	22D
0005432293166	1076	1	1F
0005434446481	1076	2	2B
0005433463864	1076	3	5H
0005435091904	1076	4	11H
0005435091909	1076	5	12F
0005435091908	1076	6	13D
0005435091903	1076	7	13F
0005433463865	1076	8	14D
0005435091910	1076	9	15D
0005434446477	1076	10	15G
0005434445211	1076	11	17D
0005433462712	1076	12	17G
0005435091907	1076	13	17H
0005433462710	1076	14	18B
0005432293167	1076	15	18G
0005434446480	1076	16	20A
0005434446479	1076	17	20D
0005435091912	1076	18	27A
0005433462711	1076	19	27B
0005434446478	1076	20	28B
0005432293168	1076	21	30H
0005435091905	1076	22	33A
0005435091911	1076	23	33D
0005435091906	1076	24	34F
0005435091902	1076	25	35G
0005433341411	17071	1	1A
0005433341383	17071	2	2A
0005433341394	17071	3	2F
0005433341452	17071	4	2G
0005433341446	17071	5	2H
0005433341437	17071	6	3F
0005433341413	17071	7	3H
0005433341443	17071	8	4B
0005433341467	17071	9	4A
0005433159275	17071	10	4F
0005433341392	17071	11	4G
0005433341439	17071	12	5B
0005433341387	17071	13	5A
0005433341472	17071	14	5F
0005433341400	17071	15	5G
0005433341415	17071	16	9A
0005433341427	17071	17	5H
0005433341436	17071	18	9B
0005433341465	17071	19	11A
0005433341421	17071	20	11H
0005433341408	17071	21	12A
0005433341440	17071	22	12E
0005433341459	17071	23	12D
0005433341466	17071	24	12F
0005433341473	17071	25	13D
0005433269630	17071	26	13G
0005433341423	17071	27	13F
0005433341395	17071	28	14B
0005433341462	17071	29	14F
0005433341435	17071	30	14G
0005433341438	17071	31	15D
0005433341461	17071	32	15H
0005433341401	17071	33	16B
0005433159274	17071	34	16E
0005433269627	17071	35	16G
0005433341451	17071	36	16F
0005433341444	17071	37	16H
0005433341420	17071	38	17A
0005433341454	17071	39	17G
0005433341479	17071	40	18B
0005433341425	17071	41	18E
0005433159276	17071	42	18D
0005433269626	17071	43	19A
0005433341419	17071	44	19B
0005433341379	17071	45	19F
0005433341393	17071	46	19H
0005433341434	17071	47	19G
0005433341402	17071	48	20A
0005433341406	17071	49	20E
0005433341409	17071	50	20D
0005433341453	17071	51	20F
0005433341417	17071	52	20H
0005433341458	17071	53	21A
0005433341475	17071	54	21D
0005433341460	17071	55	21E
0005433341450	17071	56	21G
0005433341388	17071	57	21F
0005433341469	17071	58	22A
0005433341391	17071	59	22D
0005433341405	17071	60	22E
0005433341441	17071	61	22G
0005433341416	17071	62	22F
0005433341432	17071	63	22H
0005433341455	17071	64	24D
0005433341447	17071	65	24H
0005433341418	17071	66	25E
0005433341457	17071	67	27B
0005433341381	17071	68	27A
0005433341385	17071	69	27D
0005433341463	17071	70	27F
0005433341397	17071	71	28A
0005433269628	17071	72	28B
0005433341471	17071	73	28G
0005433341474	17071	74	29A
0005433341378	17071	75	28H
0005433341430	17071	76	29H
0005433341384	17071	77	30B
0005433341396	17071	78	30A
0005433341399	17071	79	30D
0005433341431	17071	80	30G
0005433341449	17071	81	30H
0005433341470	17071	82	31B
0005433341382	17071	83	31D
0005433341478	17071	84	31G
0005433341403	17071	85	31H
0005433341422	17071	86	32D
0005433341390	17071	87	32H
0005433341426	17071	88	32G
0005433341445	17071	89	33D
0005433341404	17071	90	33E
0005433341414	17071	91	33F
0005433341429	17071	92	33G
0005433341448	17071	93	34A
0005433341442	17071	94	34D
0005433341468	17071	95	34F
0005433341476	17071	96	35A
0005433269629	17071	97	35B
0005433269625	17071	98	35F
0005433341380	17071	99	35H
0005433341412	17071	100	36A
0005433341410	17071	101	36E
0005433341433	17071	102	36G
0005433341407	17071	103	37A
0005433341424	17071	104	37E
0005433341389	17071	105	37D
0005433341386	17071	106	37F
0005433341456	17071	107	37H
0005433341428	17071	108	38D
0005433341464	17071	109	38F
0005433341398	17071	110	38H
0005433341477	17071	111	39E
0005432433591	12791	1	4E
0005432433588	12791	2	6A
0005432433590	12791	3	6F
0005432159779	12791	4	7B
0005433812860	12791	5	7D
0005432161113	12791	6	8B
0005432161112	12791	7	10E
0005432159783	12791	8	11E
0005432159780	12791	9	12A
0005432159782	12791	10	15B
0005432433589	12791	11	16A
0005432433592	12791	12	18C
0005432159781	12791	13	19F
0005432433587	12791	14	21B
0005433812861	12791	15	23F
0005434066301	30652	1	1A
0005434066347	30652	2	1C
0005434066361	30652	3	1D
0005434081482	30652	4	1F
0005434081477	30652	5	2C
0005434066322	30652	6	2D
0005434066310	30652	7	2F
0005434066319	30652	8	3D
0005434066331	30652	9	3C
0005434066340	30652	10	3F
0005434066308	30652	11	4A
0005434066334	30652	12	4C
0005434081472	30652	13	4B
0005434066363	30652	14	4D
0005434066323	30652	15	4E
0005434066318	30652	16	5A
0005434066351	30652	17	4F
0005434066330	30652	18	5B
0005434066325	30652	19	5C
0005434026670	30652	20	5E
0005434066314	30652	21	5F
0005434066350	30652	22	6B
0005434066303	30652	23	6A
0005432186806	30652	24	6C
0005433989688	30652	25	6D
0005434066364	30652	26	6E
0005434066336	30652	27	6F
0005434081474	30652	28	7A
0005434066317	30652	29	7C
0005432150059	30652	30	7D
0005434066362	30652	31	7E
0005434066313	30652	32	8A
0005434066311	30652	33	7F
0005434066304	30652	34	8C
0005434066333	30652	35	8B
0005434066338	30652	36	8D
0005432150054	30652	37	8F
0005432150056	30652	38	9A
0005434066306	30652	39	9B
0005434066342	30652	40	9C
0005434081473	30652	41	9D
0005434066352	30652	42	9F
0005434066335	30652	43	10C
0005433989689	30652	44	10B
0005434066296	30652	45	10D
0005434066343	30652	46	11A
0005434066316	30652	47	11C
0005433989686	30652	48	11B
0005432150055	30652	49	11F
0005432150061	30652	50	11E
0005434066341	30652	51	12A
0005434066346	30652	52	12D
0005434081476	30652	53	12C
0005434026669	30652	54	12E
0005434066345	30652	55	12F
0005434081484	30652	56	13A
0005434066307	30652	57	13C
0005434066356	30652	58	13B
0005432186805	30652	59	13D
0005434066332	30652	60	13E
0005434066344	30652	61	14A
0005434066300	30652	62	13F
0005434066329	30652	63	14C
0005434066348	30652	64	14E
0005434066297	30652	65	14F
0005434066360	30652	66	15B
0005434066365	30652	67	15A
0005434026671	30652	68	15D
0005433989687	30652	69	15F
0005434066309	30652	70	15E
0005434081470	30652	71	16B
0005434066299	30652	72	16C
0005434081478	30652	73	16D
0005434081483	30652	74	16F
0005434081485	30652	75	16E
0005434066337	30652	76	17A
0005434066324	30652	77	17B
0005434066302	30652	78	17C
0005434066366	30652	79	17E
0005434066315	30652	80	17D
0005434066321	30652	81	18A
0005434081471	30652	82	17F
0005434066328	30652	83	18B
0005432150062	30652	84	18C
0005434066355	30652	85	18E
0005434066295	30652	86	18D
0005434066305	30652	87	19A
0005434066349	30652	88	19B
0005433989685	30652	89	19E
0005434066320	30652	90	19F
0005434066359	30652	91	20B
0005434066339	30652	92	20A
0005434066354	30652	93	20D
0005434066298	30652	94	20C
0005434066357	30652	95	20E
0005432186803	30652	96	20F
0005434066312	30652	97	21A
0005432150057	30652	98	21C
0005434066358	30652	99	21D
0005434081481	30652	100	21F
0005432150058	30652	101	22B
0005434081475	30652	102	22C
0005434081480	30652	103	22D
0005432186804	30652	104	22E
0005434081486	30652	105	23A
0005434066353	30652	106	23B
0005434066326	30652	107	23C
0005434081479	30652	108	23D
0005432150060	30652	109	23F
0005434066327	30652	110	23E
0005435765207	5500	1	1B
0005435723010	5500	2	1G
0005435735056	5500	3	2A
0005435765204	5500	4	3A
0005433527205	5500	5	3B
0005433529217	5500	6	3F
0005435765187	5500	7	3H
0005435765188	5500	8	3G
0005435765182	5500	9	4G
0005435765185	5500	10	5C
0005435765178	5500	11	5H
0005435765194	5500	12	9B
0005435765214	5500	13	9G
0005435735059	5500	14	9H
0005435765192	5500	15	11F
0005435722014	5500	16	11G
0005435765203	5500	17	12F
0005435765195	5500	18	13B
0005435765198	5500	19	13F
0005435725511	5500	20	14B
0005435765202	5500	21	14A
0005432140312	5500	22	14E
0005435725515	5500	23	15F
0005435725514	5500	24	15H
0005435765200	5500	25	16G
0005435765176	5500	26	17B
0005433529214	5500	27	17G
0005435765181	5500	28	17F
0005435765212	5500	29	17H
0005435765172	5500	30	18E
0005435765184	5500	31	18G
0005435725513	5500	32	19B
0005435765189	5500	33	19D
0005435765190	5500	34	19F
0005435765196	5500	35	21A
0005435765191	5500	36	21D
0005435765180	5500	37	21G
0005433527203	5500	38	22E
0005435765197	5500	39	22G
0005435725512	5500	40	23B
0005435765208	5500	41	23E
0005433529218	5500	42	23G
0005435765186	5500	43	24D
0005435765193	5500	44	24G
0005432140308	5500	45	24H
0005435722015	5500	46	25F
0005432140309	5500	47	25D
0005435765213	5500	48	27A
0005432140314	5500	49	27F
0005433527206	5500	50	28H
0005433529216	5500	51	29D
0005435765210	5500	52	29B
0005435765209	5500	53	29E
0005435723009	5500	54	29F
0005435735057	5500	55	30A
0005435765205	5500	56	31E
0005435765183	5500	57	32B
0005435765174	5500	58	32A
0005432140310	5500	59	32E
0005432140311	5500	60	32D
0005435765211	5500	61	32G
0005435765173	5500	62	33G
0005433529215	5500	63	34A
0005435720802	5500	64	35E
0005435765179	5500	65	36A
0005432140313	5500	66	35H
0005435765199	5500	67	36G
0005435735055	5500	68	37A
0005435765177	5500	69	36H
0005435765201	5500	70	37D
0005435735058	5500	71	37F
0005433527204	5500	72	38A
0005435720801	5500	73	38D
0005435725516	5500	74	38B
0005435765175	5500	75	38E
0005435722016	5500	76	38F
0005435765206	5500	77	39E
0005434831073	13477	1	1A
0005432194443	13477	2	1C
0005432535750	13477	3	1B
0005435461819	13477	4	1G
0005435461806	13477	5	3C
0005434264727	13477	6	4F
0005434264725	13477	7	4C
0005435461817	13477	8	4G
0005432535754	13477	9	9H
0005435461818	13477	10	9G
0005435461830	13477	11	11E
0005434264709	13477	12	11H
0005435461828	13477	13	11G
0005434264705	13477	14	12D
0005435461823	13477	15	12H
0005434264718	13477	16	13B
0005435461804	13477	17	13F
0005434264711	13477	18	13E
0005435461814	13477	19	15G
0005435461826	13477	20	15F
0005434831075	13477	21	15H
0005435461802	13477	22	16A
0005434264708	13477	23	16D
0005434264717	13477	24	16B
0005434264719	13477	25	16E
0005434264703	13477	26	16F
0005432535751	13477	27	16H
0005435461807	13477	28	17B
0005434264712	13477	29	17D
0005435461813	13477	30	17G
0005435461805	13477	31	17H
0005435461803	13477	32	18D
0005435461821	13477	33	18E
0005434264726	13477	34	18H
0005435461831	13477	35	19A
0005435461809	13477	36	19G
0005432194442	13477	37	20E
0005435461825	13477	38	20G
0005434264713	13477	39	22B
0005435461832	13477	40	22E
0005434264715	13477	41	22F
0005435461800	13477	42	23E
0005435461796	13477	43	23D
0005434264714	13477	44	23G
0005434264720	13477	45	25D
0005435461799	13477	46	27A
0005432194441	13477	47	27D
0005434264706	13477	48	27G
0005435461795	13477	49	28A
0005434264704	13477	50	28B
0005434831071	13477	51	28H
0005434264723	13477	52	29A
0005434264702	13477	53	29D
0005432535755	13477	54	30A
0005434264724	13477	55	29H
0005435461797	13477	56	30D
0005434831074	13477	57	30E
0005435461816	13477	58	30G
0005432535753	13477	59	31D
0005435461810	13477	60	31G
0005435461811	13477	61	31H
0005432535752	13477	62	32F
0005435461820	13477	63	32E
0005434264721	13477	64	32H
0005434264722	13477	65	32G
0005435461827	13477	66	33F
0005435461815	13477	67	34A
0005435461824	13477	68	34D
0005434264707	13477	69	34G
0005432194440	13477	70	35D
0005434831072	13477	71	35B
0005434264710	13477	72	36B
0005435461822	13477	73	36F
0005435461829	13477	74	36E
0005435461808	13477	75	37B
0005435461812	13477	76	37D
0005435461801	13477	77	37G
0005435461798	13477	78	38E
0005434264716	13477	79	39E
0005434514921	18702	1	2A
0005434513535	18702	2	2B
0005434514923	18702	3	3A
0005434513534	18702	4	3B
0005434514922	18702	5	5A
0005434513533	18702	6	5B
0005432632623	4108	1	1A
0005432632620	4108	2	1D
0005432632624	4108	3	1F
0005432649304	4108	4	2A
0005432632632	4108	5	2C
0005432632627	4108	6	2F
0005432632630	4108	7	3A
0005432649297	4108	8	3D
0005432632622	4108	9	3F
0005432649296	4108	10	5C
0005432632626	4108	11	6D
0005432649299	4108	12	8C
0005432632631	4108	13	9E
0005432649306	4108	14	10C
0005432632625	4108	15	10F
0005432632629	4108	16	11C
0005432632628	4108	17	11E
0005432649303	4108	18	13A
0005432632634	4108	19	13E
0005432649300	4108	20	13F
0005432649302	4108	21	14A
0005432632621	4108	22	15F
0005432649298	4108	23	17D
0005432649307	4108	24	18A
0005432649305	4108	25	18F
0005432649301	4108	26	19A
0005432632633	4108	27	20F
0005432295837	1798	1	2D
0005432295836	1798	2	3A
0005433810492	1798	3	3D
0005432295835	1798	4	5C
0005433007859	22549	1	1C
0005433007850	22549	2	1D
0005433007841	22549	3	1F
0005433284788	22549	4	2A
0005433007854	22549	5	2C
0005433284786	22549	6	2D
0005433284773	22549	7	2F
0005433007853	22549	8	3A
0005433007866	22549	9	3D
0005433007825	22549	10	4C
0005433284791	22549	11	4D
0005433007849	22549	12	4F
0005433007835	22549	13	5A
0005433284780	22549	14	5C
0005433007865	22549	15	5D
0005433284790	22549	16	5E
0005433007834	22549	17	5F
0005433007838	22549	18	6A
0005433007831	22549	19	6C
0005433007867	22549	20	6D
0005433007832	22549	21	6F
0005433284779	22549	22	7D
0005433284782	22549	23	7E
0005433284783	22549	24	8D
0005433007827	22549	25	8E
0005433007828	22549	26	8F
0005433284770	22549	27	9A
0005433284769	22549	28	9C
0005433007857	22549	29	9E
0005433007845	22549	30	9F
0005433007829	22549	31	10A
0005433007836	22549	32	10C
0005433284775	22549	33	10D
0005433007833	22549	34	10E
0005433284793	22549	35	10F
0005433284784	22549	36	11C
0005433284792	22549	37	11D
0005433007846	22549	38	11E
0005433284774	22549	39	11F
0005433007843	22549	40	12A
0005433007847	22549	41	12D
0005433007861	22549	42	12E
0005433007840	22549	43	12F
0005433284781	22549	44	13C
0005433007851	22549	45	13D
0005433007823	22549	46	13E
0005433007855	22549	47	13F
0005433007826	22549	48	14A
0005433007824	22549	49	14E
0005433007858	22549	50	14F
0005433284776	22549	51	15E
0005433007830	22549	52	15F
0005433007822	22549	53	16A
0005433284794	22549	54	16C
0005433284789	22549	55	16E
0005433284787	22549	56	16F
0005433284772	22549	57	17A
0005433007844	22549	58	17E
0005433007848	22549	59	17F
0005433284777	22549	60	18A
0005433284785	22549	61	18C
0005433007862	22549	62	18D
0005433007852	22549	63	18E
0005433007856	22549	64	18F
0005433007864	22549	65	19A
0005433007863	22549	66	19C
0005433284771	22549	67	19D
0005433007837	22549	68	19E
0005433007839	22549	69	19F
0005433007842	22549	70	20A
0005433007860	22549	71	20D
0005433284778	22549	72	20F
0005433845780	5568	1	1C
0005433845724	5568	2	1A
0005432081404	5568	3	2A
0005433845736	5568	4	1F
0005433845769	5568	5	2C
0005433845744	5568	6	3A
0005433845725	5568	7	2F
0005433845778	5568	8	3D
0005433845767	5568	9	4A
0005433815304	5568	10	3F
0005433845737	5568	11	4C
0005433845754	5568	12	5A
0005433845729	5568	13	4F
0005433845760	5568	14	5C
0005433845747	5568	15	5F
0005433815300	5568	16	5D
0005433845723	5568	17	7C
0005432081401	5568	18	7B
0005433845750	5568	19	7E
0005433845749	5568	20	7D
0005433845757	5568	21	8A
0005433845751	5568	22	8C
0005433845766	5568	23	8B
0005432081406	5568	24	8D
0005433845735	5568	25	8F
0005433845770	5568	26	8E
0005433845742	5568	27	9A
0005433845731	5568	28	9C
0005432081405	5568	29	9B
0005433845728	5568	30	9E
0005433845776	5568	31	9D
0005433845753	5568	32	10B
0005433845759	5568	33	10A
0005433845763	5568	34	10E
0005433845782	5568	35	10D
0005433845781	5568	36	11C
0005433845771	5568	37	11F
0005433845741	5568	38	11E
0005433845773	5568	39	12D
0005433845745	5568	40	12C
0005433845764	5568	41	12E
0005433845743	5568	42	13A
0005433845774	5568	43	13B
0005433845768	5568	44	13E
0005433845733	5568	45	14A
0005433845772	5568	46	14D
0005433845765	5568	47	14F
0005433845756	5568	48	15B
0005433845755	5568	49	15C
0005433845758	5568	50	15F
0005433815302	5568	51	15E
0005432081403	5568	52	15D
0005433815301	5568	53	16A
0005433845734	5568	54	16B
0005433815305	5568	55	17A
0005433815303	5568	56	16F
0005433845732	5568	57	17B
0005433845777	5568	58	17D
0005433845775	5568	59	17C
0005433845746	5568	60	17F
0005433845748	5568	61	17E
0005433845726	5568	62	18A
0005433845762	5568	63	18C
0005433845730	5568	64	19B
0005433845738	5568	65	19A
0005433845740	5568	66	19D
0005433845752	5568	67	20B
0005433845727	5568	68	20A
0005433845761	5568	69	20D
0005433845779	5568	70	21B
0005432081402	5568	71	21A
0005433845739	5568	72	21C
0005432003649	13885	1	1F
0005435282071	13885	2	2A
0005435282092	13885	3	2F
0005435282082	13885	4	3C
0005435282078	13885	5	3A
0005432003648	13885	6	4A
0005435282095	13885	7	5C
0005435282079	13885	8	5D
0005434173453	13885	9	6E
0005435282090	13885	10	7A
0005435282076	13885	11	6F
0005434173455	13885	12	7B
0005434173452	13885	13	7F
0005435282087	13885	14	8B
0005435282086	13885	15	8D
0005435282085	13885	16	9B
0005435282070	13885	17	9A
0005435282081	13885	18	11D
0005434173454	13885	19	11F
0005435282077	13885	20	12E
0005435282091	13885	21	13A
0005435282088	13885	22	13C
0005435282073	13885	23	13B
0005432003650	13885	24	16A
0005435282084	13885	25	16B
0005435282094	13885	26	17B
0005435282093	13885	27	17D
0005435282074	13885	28	17C
0005435282080	13885	29	17E
0005435282089	13885	30	18D
0005435282075	13885	31	18F
0005435282072	13885	32	19C
0005435282083	13885	33	20F
0005434620247	7828	1	1C
0005434620245	7828	2	2C
0005432112477	7828	3	2D
0005432112478	7828	4	3B
0005434620243	7828	5	3C
0005434620259	7828	6	4B
0005434620253	7828	7	4C
0005432112479	7828	8	5B
0005434620252	7828	9	5C
0005434620255	7828	10	5D
0005434620260	7828	11	7A
0005434620251	7828	12	7B
0005434620254	7828	13	7D
0005434620248	7828	14	18A
0005434620250	7828	15	19A
0005434620258	7828	16	19C
0005434620257	7828	17	20C
0005434620263	7828	18	21A
0005434620261	7828	19	21B
0005434620262	7828	20	21C
0005434620244	7828	21	22B
0005434620249	7828	22	22C
0005434620246	7828	23	23A
0005434620256	7828	24	23B
0005435332165	32999	1	1B
0005435332157	32999	2	2A
0005435332161	32999	3	2B
0005435332162	32999	4	4B
0005435332164	32999	5	6A
0005435332167	32999	6	6C
0005435332163	32999	7	7B
0005435332159	32999	8	18A
0005435332158	32999	9	18D
0005435332166	32999	10	20B
0005435332160	32999	11	23B
0005435784767	4273	1	1A
0005435784792	4273	2	1F
0005435784765	4273	3	2A
0005435784789	4273	4	2D
0005434993862	4273	5	2F
0005435784768	4273	6	3C
0005435787320	4273	7	3F
0005434993855	4273	8	5C
0005435787321	4273	9	5D
0005435784781	4273	10	5E
0005434993863	4273	11	5F
0005435784786	4273	12	6E
0005432190565	4273	13	7C
0005434993860	4273	14	7F
0005435784787	4273	15	8A
0005432190566	4273	16	8C
0005435784776	4273	17	8E
0005435784775	4273	18	9F
0005435784780	4273	19	10A
0005435784770	4273	20	10C
0005435784798	4273	21	10D
0005435784778	4273	22	11D
0005434993857	4273	23	11E
0005434993858	4273	24	11F
0005435784794	4273	25	12A
0005435784782	4273	26	12E
0005435784790	4273	27	13D
0005435784797	4273	28	13E
0005435784779	4273	29	14A
0005435784793	4273	30	14C
0005435784784	4273	31	14E
0005434993864	4273	32	14F
0005435784774	4273	33	15C
0005435784788	4273	34	16A
0005435784766	4273	35	16D
0005435784772	4273	36	16E
0005435784796	4273	37	17C
0005435784795	4273	38	17E
0005432190567	4273	39	17F
0005435784764	4273	40	18C
0005435784777	4273	41	18D
0005435784783	4273	42	18E
0005434993859	4273	43	18F
0005435784769	4273	44	19A
0005435784785	4273	45	19C
0005435784771	4273	46	19D
0005435784791	4273	47	19E
0005435784773	4273	48	20A
0005434993861	4273	49	20C
0005434993856	4273	50	20E
0005435937307	27288	1	1A
0005435918578	27288	2	3F
0005435937305	27288	3	6C
0005432195655	27288	4	8A
0005435918573	27288	5	8D
0005435937313	27288	6	8F
0005435918574	27288	7	9A
0005435937308	27288	8	9C
0005435937312	27288	9	9D
0005435937309	27288	10	10A
0005435918575	27288	11	12D
0005435918577	27288	12	14A
0005432195656	27288	13	14C
0005435937306	27288	14	15F
0005435918576	27288	15	16C
0005435937311	27288	16	16F
0005432195657	27288	17	18D
0005435937310	27288	18	19E
0005432146165	19872	1	3D
0005432146164	19872	2	4A
0005432146163	19872	3	21B
0005432566599	4693	1	1A
0005432458989	4693	2	1C
0005432566607	4693	3	1B
0005432458975	4693	4	1F
0005432566648	4693	5	1G
0005432566605	4693	6	2A
0005432566609	4693	7	1H
0005432566612	4693	8	2C
0005432566613	4693	9	2B
0005432458996	4693	10	2G
0005432571258	4693	11	2F
0005432566629	4693	12	3A
0005432459009	4693	13	3B
0005432566592	4693	14	3C
0005432459003	4693	15	3G
0005432458959	4693	16	3F
0005434081489	4693	17	3H
0005432458999	4693	18	4B
0005432186810	4693	19	4A
0005432566606	4693	20	4C
0005434081505	4693	21	4G
0005432186808	4693	22	4F
0005432458994	4693	23	5A
0005432566642	4693	24	5B
0005434081492	4693	25	5C
0005434081487	4693	26	5H
0005432566601	4693	27	9B
0005432458961	4693	28	9A
0005432458979	4693	29	9H
0005432458986	4693	30	11B
0005432566641	4693	31	11A
0005432566646	4693	32	11D
0005432566645	4693	33	11F
0005433726066	4693	34	11H
0005432566647	4693	35	12A
0005434081491	4693	36	12B
0005434081509	4693	37	12E
0005432459006	4693	38	12D
0005432566649	4693	39	12F
0005432458956	4693	40	12H
0005434081507	4693	41	13A
0005432566611	4693	42	13D
0005432566625	4693	43	13E
0005433451584	4693	44	13G
0005432170276	4693	45	13F
0005432566591	4693	46	13H
0005434081503	4693	47	14B
0005432566644	4693	48	14D
0005433452705	4693	49	14F
0005432566622	4693	50	14H
0005432458981	4693	51	15E
0005432458982	4693	52	15D
0005432458972	4693	53	15F
0005432458983	4693	54	15H
0005434081488	4693	55	15G
0005434081513	4693	56	16A
0005432170274	4693	57	16B
0005434081497	4693	58	16E
0005434081499	4693	59	16F
0005434081493	4693	60	16H
0005434081495	4693	61	17D
0005432458964	4693	62	17B
0005432566639	4693	63	17F
0005432566650	4693	64	17E
0005432566636	4693	65	17G
0005432566621	4693	66	17H
0005432566603	4693	67	18B
0005432566620	4693	68	18A
0005432458984	4693	69	18F
0005432458985	4693	70	18E
0005432458987	4693	71	18G
0005432566634	4693	72	19B
0005432458969	4693	73	19A
0005434081517	4693	74	19E
0005432458957	4693	75	19D
0005432186809	4693	76	19F
0005434081498	4693	77	19G
0005433726065	4693	78	20A
0005434081500	4693	79	19H
0005432571257	4693	80	20E
0005434081496	4693	81	20D
0005432566616	4693	82	20G
0005432566627	4693	83	20F
0005432458990	4693	84	20H
0005434081512	4693	85	21B
0005432459001	4693	86	21A
0005432458977	4693	87	21E
0005432459008	4693	88	21F
0005432566624	4693	89	22B
0005432566640	4693	90	22A
0005432566637	4693	91	22D
0005432458991	4693	92	22G
0005432458978	4693	93	22F
0005432566600	4693	94	23B
0005434081506	4693	95	23A
0005434081501	4693	96	23H
0005432566643	4693	97	23G
0005432566617	4693	98	24A
0005432458998	4693	99	24B
0005432458974	4693	100	24E
0005432566590	4693	101	24D
0005432571259	4693	102	24F
0005432458970	4693	103	24G
0005432458960	4693	104	25E
0005432170275	4693	105	25D
0005432458993	4693	106	25F
0005434081514	4693	107	27A
0005432566638	4693	108	27D
0005432458965	4693	109	27F
0005432458968	4693	110	27E
0005434081490	4693	111	28A
0005432170272	4693	112	27H
0005432566597	4693	113	28D
0005432566594	4693	114	28F
0005432170271	4693	115	28E
0005432458958	4693	116	28G
0005433726064	4693	117	29F
0005432458963	4693	118	29E
0005434081504	4693	119	29G
0005432566615	4693	120	29H
0005434081510	4693	121	30B
0005434081520	4693	122	30F
0005432458962	4693	123	30G
0005432458992	4693	124	31B
0005432566610	4693	125	31A
0005432458997	4693	126	31D
0005432566604	4693	127	31F
0005432566602	4693	128	31E
0005432566628	4693	129	31G
0005432566589	4693	130	32A
0005432459005	4693	131	32B
0005432566595	4693	132	32D
0005432566631	4693	133	32G
0005432458967	4693	134	32H
0005432170273	4693	135	33A
0005434081494	4693	136	33B
0005432571260	4693	137	33E
0005432566593	4693	138	33D
0005433451585	4693	139	33G
0005432566632	4693	140	33F
0005432458988	4693	141	33H
0005434081502	4693	142	34A
0005432566608	4693	143	34D
0005432566633	4693	144	34B
0005433452704	4693	145	34F
0005432566618	4693	146	34E
0005432459007	4693	147	35B
0005432458976	4693	148	35A
0005433451586	4693	149	35D
0005432566630	4693	150	35F
0005432459004	4693	151	35E
0005434081508	4693	152	35G
0005432566623	4693	153	35H
0005434081515	4693	154	36B
0005432458971	4693	155	36A
0005432566614	4693	156	36E
0005432566619	4693	157	36D
0005434081519	4693	158	36G
0005432458973	4693	159	37A
0005432458966	4693	160	36H
0005432566626	4693	161	37B
0005432186807	4693	162	37E
0005432459000	4693	163	37G
0005432566635	4693	164	37F
0005432566598	4693	165	37H
0005432458995	4693	166	38B
0005434081518	4693	167	38A
0005432170277	4693	168	38D
0005432566596	4693	169	38E
0005432458980	4693	170	38F
0005434081516	4693	171	38H
0005432459002	4693	172	38G
0005434081511	4693	173	39F
0005432213545	30541	1	9H
0005432161112	30541	2	18B
0005432161113	30541	3	20D
0005432213544	30541	4	22G
0005432213543	30541	5	27H
0005435720802	13628	1	1B
0005435722014	13628	2	2A
0005435722015	13628	3	3B
0005435722016	13628	4	5A
0005435720801	13628	5	5B
0005432295836	22802	1	7B
0005432295835	22802	2	19C
0005432295837	22802	3	19D
0005433341548	11081	1	1C
0005433341495	11081	2	1A
0005433341525	11081	3	1F
0005433341574	11081	4	1D
0005433341533	11081	5	2C
0005433341517	11081	6	2A
0005433341581	11081	7	2F
0005433341572	11081	8	3A
0005433341531	11081	9	3D
0005433341513	11081	10	3C
0005433341481	11081	11	4A
0005433341577	11081	12	4B
0005433341567	11081	13	4D
0005433341563	11081	14	4C
0005433341491	11081	15	4E
0005435097048	11081	16	4F
0005433341524	11081	17	5A
0005433341504	11081	18	5B
0005433341506	11081	19	5D
0005433341550	11081	20	5E
0005433341562	11081	21	5F
0005433341579	11081	22	6B
0005433341514	11081	23	6A
0005433341509	11081	24	6C
0005433341560	11081	25	6D
0005433341536	11081	26	6E
0005433341553	11081	27	6F
0005433341489	11081	28	7B
0005433341490	11081	29	7A
0005433341571	11081	30	7C
0005433341498	11081	31	7E
0005433341512	11081	32	8A
0005433341527	11081	33	7F
0005433341578	11081	34	8B
0005433341557	11081	35	8C
0005433341558	11081	36	8D
0005433341552	11081	37	8F
0005433341486	11081	38	9A
0005433341484	11081	39	9B
0005433341582	11081	40	9C
0005433341519	11081	41	9E
0005433341541	11081	42	9D
0005433341521	11081	43	9F
0005433341493	11081	44	10C
0005433341522	11081	45	10D
0005433341544	11081	46	11A
0005433341503	11081	47	11B
0005435097047	11081	48	11D
0005433341573	11081	49	11C
0005433341576	11081	50	11E
0005433341540	11081	51	11F
0005433341494	11081	52	12A
0005433341580	11081	53	12C
0005433341500	11081	54	12B
0005433341492	11081	55	13B
0005433341520	11081	56	13A
0005433341559	11081	57	13D
0005433341499	11081	58	13E
0005433341561	11081	59	14A
0005433341508	11081	60	13F
0005433341488	11081	61	14B
0005433341556	11081	62	14D
0005433341555	11081	63	14E
0005433341543	11081	64	15A
0005433341538	11081	65	15B
0005435097050	11081	66	15D
0005433341542	11081	67	15E
0005433341554	11081	68	16A
0005433341507	11081	69	16B
0005435097046	11081	70	16C
0005435097045	11081	71	16D
0005433341529	11081	72	16E
0005433341568	11081	73	17A
0005433341569	11081	74	16F
0005433341565	11081	75	17C
0005433341570	11081	76	17E
0005435097044	11081	77	17D
0005433341482	11081	78	18A
0005433341487	11081	79	17F
0005433341547	11081	80	18B
0005435097051	11081	81	18D
0005433341535	11081	82	18C
0005433341511	11081	83	18F
0005433341505	11081	84	18E
0005433341501	11081	85	19B
0005433341480	11081	86	19A
0005433341516	11081	87	19D
0005433341549	11081	88	19C
0005433341539	11081	89	19F
0005433341532	11081	90	19E
0005433341545	11081	91	20C
0005433341510	11081	92	20B
0005433341534	11081	93	20D
0005433341564	11081	94	20E
0005433341485	11081	95	21A
0005433341537	11081	96	20F
0005433341546	11081	97	21B
0005433341551	11081	98	21C
0005433341502	11081	99	21D
0005433341530	11081	100	21E
0005433341526	11081	101	22B
0005433341496	11081	102	22A
0005433341497	11081	103	22C
0005433341518	11081	104	22D
0005435097049	11081	105	22E
0005433341515	11081	106	23A
0005433341523	11081	107	22F
0005435097043	11081	108	23B
0005433341483	11081	109	23C
0005433341528	11081	110	23E
0005433341566	11081	111	23D
0005433341575	11081	112	23F
0005432293168	17128	1	7F
0005432293166	17128	2	12C
0005432293167	17128	3	21B
0005433481037	9088	1	1C
0005433506872	9088	2	2A
0005433506888	9088	3	2D
0005433481041	9088	4	4A
0005433506883	9088	5	4D
0005433506877	9088	6	5E
0005433506889	9088	7	6E
0005433506880	9088	8	7F
0005433506879	9088	9	8C
0005433506881	9088	10	8E
0005433506887	9088	11	9A
0005433481042	9088	12	9E
0005433506885	9088	13	10F
0005433481043	9088	14	11C
0005433506874	9088	15	12C
0005433506884	9088	16	14D
0005433506882	9088	17	14F
0005433481038	9088	18	15C
0005433481039	9088	19	15E
0005433481035	9088	20	16D
0005433481036	9088	21	16F
0005433506875	9088	22	17C
0005433481040	9088	23	17E
0005433506890	9088	24	17F
0005433506886	9088	25	18C
0005433506876	9088	26	18D
0005433506878	9088	27	18E
0005433506873	9088	28	20F
0005432919527	20483	1	2C
0005432919528	20483	2	2D
0005432919537	20483	3	4C
0005432919529	20483	4	5C
0005432919534	20483	5	6A
0005432919530	20483	6	6F
0005432919525	20483	7	7E
0005432919539	20483	8	9A
0005432919531	20483	9	9C
0005432919536	20483	10	10C
0005432919542	20483	11	11D
0005432919544	20483	12	12C
0005432919543	20483	13	14E
0005432919535	20483	14	15A
0005432919533	20483	15	16C
0005432919540	20483	16	17A
0005432919541	20483	17	17F
0005432919532	20483	18	18A
0005432919526	20483	19	18C
0005432919545	20483	20	19A
0005432919538	20483	21	19D
0005432396173	10149	1	1A
0005432394034	10149	2	1B
0005432396172	10149	3	2A
0005432394032	10149	4	2B
0005432394033	10149	5	4B
0005432396174	10149	6	4A
0005432394035	10149	7	5A
0005432396171	10149	8	5B
0005432396170	10149	9	6A
0005435179687	18337	1	3A
0005435179686	18337	2	4B
0005434928253	10991	1	1A
0005434411708	10991	2	2D
0005434928252	10991	3	11E
0005434411707	10991	4	12A
0005434411705	10991	5	12E
0005434411706	10991	6	15F
0005434411709	10991	7	19C
0005435125694	14692	1	1A
0005435125716	14692	2	1D
0005435125697	14692	3	1F
0005435125706	14692	4	2A
0005435625880	14692	5	2C
0005435125714	14692	6	2D
0005435554106	14692	7	3D
0005435625887	14692	8	3F
0005435554103	14692	9	4C
0005435125712	14692	10	4D
0005435125707	14692	11	4E
0005435125727	14692	12	5A
0005435625898	14692	13	5C
0005435125726	14692	14	5D
0005435625894	14692	15	5E
0005435625883	14692	16	5F
0005435625892	14692	17	6A
0005435625896	14692	18	6C
0005435554104	14692	19	6E
0005435125724	14692	20	6F
0005435125723	14692	21	7A
0005435125703	14692	22	7C
0005435125713	14692	23	7D
0005435125690	14692	24	7F
0005435125728	14692	25	8A
0005435625882	14692	26	8D
0005435125709	14692	27	8E
0005435125704	14692	28	8F
0005435556650	14692	29	9A
0005435554107	14692	30	9C
0005435125725	14692	31	9D
0005435125692	14692	32	9E
0005435125711	14692	33	9F
0005435125699	14692	34	10A
0005435125715	14692	35	10C
0005435125721	14692	36	10E
0005435125718	14692	37	11A
0005435125702	14692	38	11C
0005435125691	14692	39	11D
0005435125705	14692	40	12C
0005435625888	14692	41	12D
0005435625899	14692	42	12E
0005435625881	14692	43	12F
0005435125729	14692	44	13C
0005435625890	14692	45	13D
0005435625886	14692	46	13F
0005435625889	14692	47	14C
0005435625891	14692	48	14E
0005435125689	14692	49	14F
0005435125695	14692	50	15A
0005435125710	14692	51	15C
0005435125696	14692	52	16A
0005435125700	14692	53	16C
0005435125698	14692	54	17A
0005435625897	14692	55	17F
0005435125701	14692	56	18C
0005435125717	14692	57	18D
0005435125693	14692	58	18E
0005435625895	14692	59	18F
0005435554105	14692	60	19A
0005435125722	14692	61	19C
0005435125720	14692	62	19D
0005435625885	14692	63	19E
0005435625884	14692	64	20C
0005435125719	14692	65	20D
0005435625893	14692	66	20E
0005435125708	14692	67	20F
0005435715178	7144	1	2D
0005435715177	7144	2	2F
0005435715182	7144	3	4D
0005432400063	7144	4	5E
0005435715193	7144	5	7A
0005435715181	7144	6	8A
0005435715192	7144	7	8C
0005435715185	7144	8	8E
0005432400061	7144	9	9A
0005435715187	7144	10	9F
0005435715189	7144	11	10D
0005432400064	7144	12	13A
0005432398132	7144	13	13D
0005432400062	7144	14	15A
0005432398134	7144	15	16E
0005435715183	7144	16	17A
0005432398133	7144	17	17C
0005435715191	7144	18	17F
0005435715179	7144	19	18D
0005435715180	7144	20	18F
0005435715190	7144	21	19C
0005432398135	7144	22	19D
0005435715186	7144	23	19E
0005435715188	7144	24	19F
0005435715184	7144	25	20E
0005435443154	27074	1	3C
0005435443158	27074	2	5D
0005435216553	27074	3	6E
0005435217676	27074	4	7A
0005435443153	27074	5	7E
0005435443161	27074	6	7F
0005435217678	27074	7	10A
0005435218099	27074	8	10D
0005435216554	27074	9	10E
0005435443160	27074	10	12D
0005435443157	27074	11	13D
0005435443156	27074	12	14D
0005435443159	27074	13	15E
0005435217677	27074	14	16E
0005435443155	27074	15	18A
0005435443162	27074	16	18F
0005434084856	2758	1	3A
0005434084854	2758	2	3B
0005434084855	2758	3	4A
0005434084853	2758	4	5A
0005434084857	2758	5	5B
0005433060369	28478	1	1A
0005433060368	28478	2	2B
0005433788147	11165	1	4D
0005433788141	11165	2	6C
0005433788140	11165	3	7D
0005433788144	11165	4	18C
0005433788145	11165	5	19C
0005433788143	11165	6	20B
0005433788148	11165	7	22C
0005433788142	11165	8	23A
0005433788146	11165	9	23B
0005435528891	22263	1	1A
0005435528885	22263	2	2A
0005435540631	22263	3	2D
0005432294445	22263	4	3C
0005435528892	22263	5	3F
0005435540626	22263	6	4E
0005435528879	22263	7	5C
0005435528886	22263	8	5D
0005435540639	22263	9	5F
0005435540627	22263	10	6C
0005435540643	22263	11	6F
0005435528893	22263	12	7A
0005435540632	22263	13	7C
0005435528887	22263	14	7D
0005435528889	22263	15	7E
0005435528895	22263	16	8F
0005435540642	22263	17	9D
0005435540634	22263	18	9F
0005432294446	22263	19	10A
0005435540630	22263	20	10D
0005435540623	22263	21	11E
0005435528898	22263	22	12C
0005435540635	22263	23	12D
0005435540641	22263	24	12E
0005435528896	22263	25	12F
0005435528888	22263	26	13A
0005435528899	22263	27	13C
0005435540633	22263	28	13D
0005435540624	22263	29	13F
0005435528900	22263	30	14E
0005435528897	22263	31	15A
0005435528894	22263	32	15D
0005435528880	22263	33	16C
0005435540637	22263	34	16D
0005435540640	22263	35	16E
0005435540628	22263	36	17A
0005435528890	22263	37	17F
0005435540622	22263	38	18A
0005435528884	22263	39	18C
0005435540625	22263	40	18D
0005435528882	22263	41	19A
0005435528883	22263	42	19C
0005435540636	22263	43	20A
0005435540638	22263	44	20C
0005435528881	22263	45	20D
0005435540629	22263	46	20E
0005434906415	2299	1	1D
0005434906442	2299	2	1F
0005434906444	2299	3	2A
0005434906435	2299	4	3D
0005434906441	2299	5	4D
0005434906452	2299	6	4F
0005434906426	2299	7	5A
0005434906422	2299	8	5C
0005434906407	2299	9	6A
0005434906419	2299	10	7A
0005434906418	2299	11	7C
0005434906421	2299	12	8D
0005434906433	2299	13	8E
0005434906453	2299	14	10A
0005434906454	2299	15	10D
0005434906431	2299	16	10F
0005434906438	2299	17	11C
0005434906416	2299	18	11D
0005434906429	2299	19	11E
0005434906430	2299	20	12A
0005434906448	2299	21	12E
0005434906436	2299	22	13A
0005434906434	2299	23	13C
0005434906449	2299	24	13D
0005434906425	2299	25	13F
0005434906451	2299	26	14C
0005434906412	2299	27	14D
0005434906445	2299	28	14E
0005434906450	2299	29	14F
0005434906409	2299	30	15C
0005434906408	2299	31	15D
0005434906440	2299	32	15E
0005434906428	2299	33	16A
0005434906423	2299	34	16D
0005434906420	2299	35	17A
0005434906437	2299	36	17D
0005434906410	2299	37	17F
0005434906411	2299	38	18A
0005434906413	2299	39	18C
0005434906443	2299	40	18E
0005434906439	2299	41	18F
0005434906446	2299	42	19A
0005434906432	2299	43	19C
0005434906447	2299	44	19D
0005434906427	2299	45	19E
0005434906424	2299	46	19F
0005434906455	2299	47	20A
0005434906414	2299	48	20E
0005434906417	2299	49	20F
0005433250959	25619	1	1A
0005433250984	25619	2	1D
0005433400933	25619	3	3C
0005433250981	25619	4	3D
0005433400934	25619	5	4A
0005433250965	25619	6	4C
0005433250983	25619	7	4F
0005433250979	25619	8	6C
0005433250985	25619	9	6D
0005433250988	25619	10	6F
0005433250972	25619	11	7F
0005433250962	25619	12	10C
0005433250982	25619	13	11C
0005433250976	25619	14	11E
0005433250966	25619	15	12C
0005433250973	25619	16	12E
0005433250967	25619	17	12F
0005433250975	25619	18	14A
0005433250971	25619	19	14C
0005433250986	25619	20	14E
0005433250968	25619	21	14F
0005433250961	25619	22	15A
0005433250970	25619	23	15D
0005433250964	25619	24	16C
0005433250969	25619	25	17A
0005433250977	25619	26	17F
0005433250963	25619	27	18C
0005433250960	25619	28	18E
0005433250974	25619	29	18F
0005433250987	25619	30	19E
0005433250978	25619	31	19F
0005433250989	25619	32	20A
0005433250980	25619	33	20D
0005432620809	2540	1	1A
0005432620801	2540	2	2A
0005432620807	2540	3	5C
0005432620808	2540	4	5D
0005432620804	2540	5	6A
0005432620812	2540	6	6C
0005432620802	2540	7	7B
0005432620805	2540	8	18B
0005432620803	2540	9	18D
0005432620806	2540	10	21C
0005432620810	2540	11	21D
0005432620811	2540	12	22B
0005432620814	2540	13	22C
0005432620813	2540	14	23A
0005432862170	28089	1	2B
0005432862172	28089	2	3C
0005432862177	28089	3	4A
0005432862178	28089	4	4C
0005432862176	28089	5	21B
0005432862173	28089	6	21C
0005432862171	28089	7	21D
0005432862174	28089	8	22C
0005432862175	28089	9	23B
0005434097451	13104	1	1A
0005434097450	13104	2	1B
0005433452704	31011	1	1A
0005433451584	31011	2	1B
0005433451585	31011	3	4B
0005433452705	31011	4	5A
0005433451586	31011	5	6A
0005434183547	29840	1	1B
0005433131633	29840	2	3D
0005433134060	29840	3	4B
0005433131630	29840	4	4D
0005434184632	29840	5	5A
0005433131634	29840	6	5B
0005433134064	29840	7	5D
0005433134062	29840	8	6A
0005433134063	29840	9	6B
0005434142542	29840	10	6D
0005433134061	29840	11	7A
0005434142543	29840	12	19C
0005434142540	29840	13	19D
0005434184631	29840	14	21B
0005433131631	29840	15	21C
0005433131632	29840	16	22C
0005434142541	29840	17	22D
0005435696869	16466	1	1A
0005435696849	16466	2	1C
0005435696843	16466	3	1D
0005435696863	16466	4	2B
0005435696871	16466	5	2D
0005435696848	16466	6	3A
0005435696853	16466	7	3B
0005435696852	16466	8	3D
0005435696857	16466	9	5B
0005435696844	16466	10	6A
0005435696854	16466	11	6B
0005435696861	16466	12	6D
0005435696860	16466	13	7D
0005435696862	16466	14	18A
0005435696851	16466	15	18D
0005435696845	16466	16	19B
0005435696847	16466	17	19C
0005435696866	16466	18	19D
0005435696850	16466	19	20A
0005435696867	16466	20	20B
0005435696868	16466	21	20D
0005435696859	16466	22	21A
0005435696846	16466	23	21B
0005435696858	16466	24	21D
0005435696870	16466	25	22A
0005435696855	16466	26	22B
0005435696865	16466	27	22C
0005435696864	16466	28	23A
0005435696856	16466	29	23B
0005435934996	24731	1	2A
0005435934997	24731	2	2C
0005435934998	24731	3	6D
0005433724725	18809	1	1A
0005433724724	18809	2	3A
0005433724726	18809	3	4A
0005433724727	18809	4	5B
0005432968804	21605	1	4A
0005432968805	21605	2	6A
0005434136785	7295	1	1A
0005434136810	7295	2	1C
0005434136774	7295	3	1D
0005434087435	7295	4	1F
0005434136775	7295	5	2A
0005434136811	7295	6	2C
0005434136790	7295	7	2D
0005434136820	7295	8	2F
0005434136788	7295	9	3C
0005434136791	7295	10	3D
0005434136762	7295	11	3F
0005434136822	7295	12	4A
0005434136841	7295	13	4C
0005434136805	7295	14	4D
0005434136839	7295	15	4E
0005434136800	7295	16	4F
0005434087432	7295	17	5A
0005434136836	7295	18	5C
0005434136797	7295	19	5D
0005434136783	7295	20	5E
0005434136803	7295	21	5F
0005434136781	7295	22	6A
0005434136763	7295	23	6C
0005434136840	7295	24	6D
0005434136779	7295	25	6E
0005434136782	7295	26	7A
0005434136838	7295	27	6F
0005434136802	7295	28	7C
0005434136787	7295	29	7D
0005434136776	7295	30	7E
0005434136829	7295	31	7F
0005434136826	7295	32	8A
0005434136834	7295	33	8C
0005434136817	7295	34	8D
0005434136765	7295	35	8E
0005434136798	7295	36	8F
0005434136830	7295	37	9A
0005434136770	7295	38	9D
0005434087431	7295	39	9E
0005434136784	7295	40	9F
0005434087433	7295	41	10A
0005434136760	7295	42	10C
0005434136804	7295	43	10D
0005434136833	7295	44	10E
0005434136799	7295	45	10F
0005434136825	7295	46	11A
0005434136835	7295	47	11C
0005434136761	7295	48	11E
0005434087434	7295	49	11F
0005434136843	7295	50	12A
0005434136831	7295	51	12C
0005434136771	7295	52	12D
0005434136778	7295	53	12E
0005434136777	7295	54	12F
0005434136844	7295	55	13A
0005434136789	7295	56	13C
0005434136786	7295	57	13D
0005434136809	7295	58	13E
0005434136837	7295	59	13F
0005434136842	7295	60	14A
0005434136769	7295	61	14C
0005434136808	7295	62	14D
0005434136773	7295	63	14E
0005434136792	7295	64	14F
0005434136795	7295	65	15C
0005434136821	7295	66	15D
0005434136806	7295	67	15E
0005434136796	7295	68	15F
0005434136814	7295	69	16A
0005434136812	7295	70	16C
0005434136780	7295	71	16E
0005434136815	7295	72	17A
0005434136764	7295	73	17C
0005434136772	7295	74	17D
0005434136807	7295	75	17E
0005434136824	7295	76	17F
0005434136827	7295	77	18A
0005434136768	7295	78	18C
0005434136828	7295	79	18D
0005434136823	7295	80	18E
0005434136793	7295	81	18F
0005434136818	7295	82	19A
0005434136813	7295	83	19C
0005434136816	7295	84	19D
0005434136819	7295	85	19E
0005434136832	7295	86	20A
0005434136766	7295	87	20C
0005434136767	7295	88	20D
0005434136801	7295	89	20E
0005434136794	7295	90	20F
0005435808070	1904	1	1B
0005435808065	1904	2	1D
0005435808061	1904	3	2D
0005434610169	1904	4	3B
0005434610170	1904	5	4B
0005435808067	1904	6	5B
0005435808062	1904	7	6A
0005435808068	1904	8	6B
0005435808060	1904	9	6C
0005435808064	1904	10	7D
0005435808063	1904	11	18A
0005435808066	1904	12	19C
0005434610168	1904	13	21A
0005435808069	1904	14	22C
0005433407480	23062	1	1A
0005433407481	23062	2	3B
0005433407478	23062	3	3D
0005433407479	23062	4	4C
0005433407477	23062	5	4D
0005434503460	22907	1	1A
0005434503461	22907	2	1B
0005434503463	22907	3	2A
0005434503476	22907	4	2C
0005434503475	22907	5	2D
0005434503485	22907	6	3A
0005434503491	22907	7	3D
0005434503473	22907	8	4A
0005434503458	22907	9	4B
0005434503474	22907	10	4C
0005434503492	22907	11	4D
0005434503471	22907	12	5A
0005434503465	22907	13	5B
0005434503469	22907	14	5C
0005434503490	22907	15	5D
0005434503489	22907	16	6B
0005434503466	22907	17	6D
0005434503470	22907	18	7A
0005434503487	22907	19	7B
0005434503494	22907	20	7C
0005434503477	22907	21	7D
0005434503480	22907	22	18A
0005434503488	22907	23	18B
0005434503495	22907	24	18D
0005434503464	22907	25	19B
0005434503459	22907	26	19C
0005434503478	22907	27	20A
0005434503482	22907	28	20B
0005434503493	22907	29	20D
0005434503462	22907	30	21A
0005434503479	22907	31	21B
0005434503484	22907	32	21C
0005434503481	22907	33	21D
0005434503496	22907	34	22A
0005434503486	22907	35	22B
0005434503468	22907	36	22C
0005434503483	22907	37	22D
0005434503467	22907	38	23A
0005434503472	22907	39	23B
0005435078080	2196	1	1B
0005435078090	2196	2	1C
0005435078095	2196	3	2A
0005435078093	2196	4	2B
0005435078091	2196	5	2C
0005435078085	2196	6	3D
0005435078082	2196	7	5B
0005435078087	2196	8	5D
0005435078089	2196	9	7D
0005435078094	2196	10	20B
0005435078081	2196	11	20D
0005435078088	2196	12	21A
0005435078084	2196	13	21D
0005435078086	2196	14	22A
0005435078092	2196	15	22D
0005435078083	2196	16	23A
0005433266571	24332	1	2C
0005433266569	24332	2	3B
0005433266568	24332	3	6A
0005433266573	24332	4	7B
0005433266570	24332	5	18A
0005433266574	24332	6	19A
0005433266567	24332	7	19D
0005433266572	24332	8	21C
0005435803215	6651	1	1A
0005434988567	6651	2	1B
0005434988569	6651	3	2C
0005434988570	6651	4	4D
0005435803216	6651	5	6C
0005435803217	6651	6	19B
0005434988565	6651	7	19C
0005434988566	6651	8	19D
0005435803214	6651	9	21C
0005434988568	6651	10	22C
0005435464474	23613	1	2D
0005435464475	23613	2	4B
0005435464476	23613	3	6D
0005432382530	30510	1	1C
0005433449620	30510	2	1D
0005432382553	30510	3	1F
0005432382555	30510	4	2A
0005432382538	30510	5	2C
0005432382533	30510	6	2F
0005432382546	30510	7	3A
0005432382524	30510	8	3C
0005433449609	30510	9	3D
0005432382540	30510	10	3F
0005433449616	30510	11	4C
0005432382549	30510	12	4D
0005433449624	30510	13	4E
0005432382531	30510	14	4F
0005433454840	30510	15	5A
0005432382536	30510	16	5E
0005433449618	30510	17	6A
0005433449623	30510	18	6E
0005432382537	30510	19	6F
0005432382529	30510	20	7C
0005433449606	30510	21	7D
0005432382528	30510	22	7E
0005433449627	30510	23	7F
0005433449619	30510	24	8A
0005432382556	30510	25	8C
0005432382522	30510	26	8D
0005432382559	30510	27	8F
0005432382558	30510	28	9A
0005432382535	30510	29	9C
0005432382547	30510	30	9D
0005432382552	30510	31	9E
0005433453728	30510	32	9F
0005433449617	30510	33	10C
0005433449615	30510	34	10D
0005432382548	30510	35	10F
0005433449611	30510	36	11A
0005432382544	30510	37	11C
0005432382563	30510	38	11E
0005433449607	30510	39	11F
0005432382554	30510	40	12C
0005432382562	30510	41	12D
0005432382532	30510	42	12E
0005433449614	30510	43	12F
0005432382526	30510	44	13D
0005432382521	30510	45	13E
0005432382545	30510	46	13F
0005432382542	30510	47	14A
0005432382525	30510	48	14C
0005432382539	30510	49	14E
0005432382551	30510	50	15A
0005433449622	30510	51	15C
0005433449612	30510	52	15D
0005432382541	30510	53	15E
0005432382543	30510	54	15F
0005432382561	30510	55	16C
0005433454839	30510	56	16F
0005433449621	30510	57	17A
0005433449626	30510	58	17C
0005433449610	30510	59	17D
0005432382560	30510	60	17E
0005432382534	30510	61	17F
0005432382523	30510	62	18A
0005433453729	30510	63	18C
0005433449613	30510	64	18F
0005433449625	30510	65	19A
0005432382550	30510	66	19C
0005432382527	30510	67	19D
0005432382557	30510	68	20C
0005433449608	30510	69	20F
0005435302129	29702	1	1B
0005435302125	29702	2	1D
0005433129205	29702	3	2C
0005435302128	29702	4	3B
0005435299701	29702	5	3C
0005435302124	29702	6	4A
0005433126775	29702	7	4C
0005433129203	29702	8	5C
0005433126774	29702	9	5D
0005433126772	29702	10	6A
0005435299702	29702	11	6C
0005433126776	29702	12	6D
0005433126773	29702	13	7A
0005433129204	29702	14	7D
0005433129206	29702	15	18D
0005435302126	29702	16	19B
0005435299700	29702	17	20A
0005433129202	29702	18	21A
0005435302127	29702	19	21D
0005435299704	29702	20	22B
0005435299703	29702	21	22D
0005434286931	2406	1	1A
0005434286932	2406	2	1D
0005434286916	2406	3	2A
0005434286930	2406	4	2B
0005434286919	2406	5	2C
0005434286923	2406	6	2D
0005434286926	2406	7	3A
0005434286928	2406	8	4B
0005434286934	2406	9	5C
0005434286922	2406	10	5D
0005434286929	2406	11	6B
0005434286937	2406	12	6D
0005434286927	2406	13	7C
0005434286924	2406	14	18A
0005434286917	2406	15	18B
0005434286920	2406	16	18D
0005434286935	2406	17	19B
0005434286915	2406	18	19D
0005434286933	2406	19	20B
0005434286918	2406	20	20C
0005432264435	2406	21	20D
0005432264434	2406	22	21C
0005434286925	2406	23	22A
0005434286921	2406	24	22B
0005434286936	2406	25	23A
0005433109858	26820	1	1C
0005433109859	26820	2	1D
0005433109857	26820	3	3A
0005433109861	26820	4	4B
0005433109849	26820	5	4D
0005433109854	26820	6	5B
0005433109860	26820	7	5C
0005433109855	26820	8	7A
0005433109852	26820	9	18A
0005433109856	26820	10	19B
0005433109851	26820	11	19C
0005433109850	26820	12	21D
0005433109853	26820	13	22B
0005435856135	25466	1	7B
0005435856136	25466	2	18A
0005435856134	25466	3	19D
0005435856137	25466	4	20C
0005434273049	26634	1	1B
0005434272163	26634	2	3C
0005434272164	26634	3	5D
0005434273048	26634	4	22A
0005433867779	4766	1	1A
0005433867789	4766	2	1B
0005433867770	4766	3	1C
0005433867803	4766	4	2B
0005433867798	4766	5	2C
0005433867780	4766	6	2D
0005433867792	4766	7	3A
0005433867786	4766	8	3B
0005433867802	4766	9	3C
0005433867791	4766	10	3D
0005433867777	4766	11	4A
0005433867805	4766	12	4B
0005433867771	4766	13	4C
0005433867776	4766	14	4D
0005433867782	4766	15	5A
0005433867794	4766	16	5B
0005433867808	4766	17	5D
0005433867804	4766	18	6B
0005433867797	4766	19	6C
0005433867774	4766	20	7A
0005433867795	4766	21	7C
0005433867809	4766	22	7D
0005433867801	4766	23	18B
0005433867775	4766	24	18C
0005433867788	4766	25	18D
0005433867781	4766	26	19A
0005433867800	4766	27	19B
0005433867787	4766	28	19C
0005433867773	4766	29	19D
0005433867810	4766	30	20A
0005433867793	4766	31	20C
0005433867799	4766	32	20D
0005433867806	4766	33	21A
0005433867785	4766	34	21B
0005433867807	4766	35	21C
0005433867790	4766	36	21D
0005433867772	4766	37	22A
0005433867784	4766	38	22B
0005433867796	4766	39	22C
0005433867778	4766	40	23A
0005433867783	4766	41	23B
0005435860432	32564	1	21C
0005435860433	32564	2	22A
0005434663181	3447	1	1B
0005434460470	3447	2	2A
0005434663191	3447	3	3A
0005434663192	3447	4	3B
0005434460469	3447	5	3C
0005434461612	3447	6	3D
0005434663189	3447	7	4D
0005434663182	3447	8	7B
0005434663179	3447	9	7C
0005434663190	3447	10	18C
0005434663188	3447	11	18D
0005434461611	3447	12	20B
0005434663184	3447	13	20D
0005434663185	3447	14	21A
0005434663186	3447	15	21D
0005434663183	3447	16	22C
0005434663180	3447	17	22D
0005434663187	3447	18	23A
0005435911330	12464	1	2B
0005435911323	12464	2	4A
0005435911327	12464	3	4B
0005435911324	12464	4	6A
0005435911325	12464	5	6B
0005435911328	12464	6	6D
0005435911326	12464	7	7C
0005435911329	12464	8	19C
0005435860432	14525	1	1C
0005435860433	14525	2	6A
0005433867738	32643	1	1A
0005433867768	32643	2	1B
0005433867743	32643	3	1D
0005433867746	32643	4	2A
0005433867766	32643	5	2B
0005433867736	32643	6	2C
0005433867728	32643	7	2D
0005433867752	32643	8	3A
0005433867734	32643	9	3B
0005433867735	32643	10	3C
0005433867762	32643	11	4A
0005433867732	32643	12	4B
0005433867730	32643	13	4C
0005433867755	32643	14	4D
0005433867764	32643	15	5A
0005433867729	32643	16	5B
0005433867760	32643	17	5C
0005433867741	32643	18	6A
0005433867745	32643	19	6B
0005433867767	32643	20	6C
0005433867757	32643	21	6D
0005433867759	32643	22	7A
0005433867727	32643	23	7B
0005433867740	32643	24	7C
0005433867750	32643	25	7D
0005433867733	32643	26	18A
0005433867758	32643	27	18B
0005433867747	32643	28	18C
0005433867731	32643	29	19A
0005433867742	32643	30	19B
0005433867753	32643	31	19D
0005433867761	32643	32	20A
0005433867744	32643	33	20B
0005433867739	32643	34	20C
0005433867749	32643	35	21A
0005433867765	32643	36	21B
0005433867763	32643	37	21C
0005433867748	32643	38	21D
0005433867756	32643	39	22B
0005433867737	32643	40	22C
0005433867754	32643	41	22D
0005433867751	32643	42	23A
0005433867769	32643	43	23B
0005432798965	14823	1	1A
0005432798978	14823	2	1B
0005432798976	14823	3	1D
0005432798962	14823	4	3A
0005432798953	14823	5	3B
0005432798955	14823	6	3C
0005432798961	14823	7	4C
0005432798966	14823	8	5B
0005432798977	14823	9	5C
0005432798979	14823	10	6A
0005432798974	14823	11	6B
0005432798981	14823	12	6C
0005432798963	14823	13	7C
0005432798957	14823	14	7D
0005432798956	14823	15	18A
0005432798954	14823	16	19B
0005432798959	14823	17	19C
0005432798967	14823	18	19D
0005432798958	14823	19	20A
0005432798970	14823	20	20B
0005432798980	14823	21	20C
0005432798964	14823	22	20D
0005432798969	14823	23	21A
0005432798972	14823	24	21B
0005432798975	14823	25	21C
0005432798973	14823	26	22A
0005432798968	14823	27	22B
0005432798982	14823	28	22C
0005432798960	14823	29	22D
0005432798971	14823	30	23B
0005434406728	7054	1	1A
0005434299189	7054	2	1C
0005434299186	7054	3	1D
0005434406722	7054	4	2C
0005434299173	7054	5	2D
0005434406711	7054	6	2F
0005434406746	7054	7	3A
0005434406704	7054	8	3C
0005434406705	7054	9	3F
0005434299180	7054	10	4A
0005434299174	7054	11	4C
0005434406712	7054	12	4B
0005434299191	7054	13	4D
0005434406714	7054	14	4E
0005434406732	7054	15	4F
0005434406718	7054	16	5B
0005434406747	7054	17	5A
0005434299182	7054	18	5C
0005434406723	7054	19	5D
0005434406717	7054	20	5E
0005434406743	7054	21	6B
0005434406757	7054	22	6A
0005434406725	7054	23	6E
0005434406708	7054	24	6D
0005434299193	7054	25	7A
0005434406751	7054	26	6F
0005434406734	7054	27	7B
0005434406730	7054	28	7C
0005432153823	7054	29	7D
0005434299188	7054	30	7E
0005434406706	7054	31	8A
0005434299183	7054	32	8B
0005434406764	7054	33	8D
0005434299181	7054	34	8C
0005432153825	7054	35	8E
0005434406748	7054	36	9A
0005432153820	7054	37	9C
0005432153821	7054	38	9E
0005434406758	7054	39	9F
0005434406719	7054	40	10B
0005434406727	7054	41	10D
0005434406749	7054	42	10E
0005434406709	7054	43	11A
0005434406702	7054	44	11B
0005434406760	7054	45	11C
0005432153827	7054	46	11E
0005434406753	7054	47	11F
0005434406741	7054	48	12D
0005434406745	7054	49	12E
0005434299176	7054	50	12F
0005434406716	7054	51	13B
0005434406713	7054	52	13A
0005434406715	7054	53	13C
0005434406763	7054	54	13E
0005434406703	7054	55	14A
0005434406724	7054	56	14C
0005434299190	7054	57	14B
0005432153826	7054	58	14D
0005434299187	7054	59	14E
0005434406729	7054	60	15A
0005434406710	7054	61	15B
0005434406736	7054	62	15D
0005434406721	7054	63	15F
0005434299179	7054	64	15E
0005434406752	7054	65	16A
0005434406742	7054	66	16B
0005434406759	7054	67	16D
0005434406726	7054	68	17B
0005434406755	7054	69	17A
0005434299185	7054	70	17E
0005434406735	7054	71	18A
0005432153822	7054	72	18B
0005434406740	7054	73	18C
0005432108208	7054	74	18E
0005434406750	7054	75	18D
0005432108207	7054	76	18F
0005434406761	7054	77	19A
0005434406733	7054	78	19B
0005434406707	7054	79	19D
0005434406744	7054	80	19C
0005434299172	7054	81	19E
0005434299175	7054	82	19F
0005434299177	7054	83	20A
0005434406762	7054	84	20B
0005434406737	7054	85	20D
0005434299184	7054	86	21A
0005434299170	7054	87	21D
0005434299192	7054	88	21E
0005434406720	7054	89	22A
0005434406739	7054	90	21F
0005434406756	7054	91	22B
0005434406738	7054	92	22C
0005434299178	7054	93	22F
0005434299171	7054	94	23C
0005434406754	7054	95	23D
0005432153824	7054	96	23F
0005434406731	7054	97	23E
0005435310843	26926	1	1A
0005435310839	26926	2	1D
0005435310841	26926	3	4B
0005435293064	26926	4	5C
0005435310836	26926	5	6B
0005435310851	26926	6	6C
0005435310855	26926	7	7C
0005435293067	26926	8	7E
0005435293065	26926	9	8A
0005435310842	26926	10	8B
0005435293069	26926	11	8C
0005435310844	26926	12	8E
0005435293061	26926	13	9A
0005435310849	26926	14	10D
0005435310845	26926	15	10E
0005432058312	26926	16	11E
0005435293068	26926	17	12B
0005432058315	26926	18	13D
0005435310838	26926	19	13F
0005435293058	26926	20	14F
0005435293063	26926	21	15F
0005432058314	26926	22	16B
0005435310840	26926	23	16E
0005435310850	26926	24	17A
0005435310847	26926	25	17C
0005435310854	26926	26	17D
0005435293066	26926	27	17F
0005435293060	26926	28	18D
0005435293059	26926	29	18E
0005435310848	26926	30	19D
0005435310846	26926	31	19E
0005432058313	26926	32	19F
0005435293057	26926	33	20D
0005435293070	26926	34	22A
0005435310853	26926	35	21F
0005435310837	26926	36	22D
0005435310852	26926	37	23B
0005435293062	26926	38	23C
0005432603722	6465	1	1A
0005432603700	6465	2	1B
0005432603705	6465	3	1C
0005432603707	6465	4	1D
0005432603683	6465	5	2A
0005432603711	6465	6	2B
0005432603718	6465	7	2C
0005432603690	6465	8	2D
0005432603701	6465	9	3A
0005432603704	6465	10	3B
0005432603708	6465	11	3C
0005432603697	6465	12	4A
0005432603685	6465	13	4B
0005432603682	6465	14	4C
0005432603703	6465	15	4D
0005432603713	6465	16	5A
0005434512026	6465	17	5B
0005432603696	6465	18	5D
0005434512023	6465	19	6A
0005432603714	6465	20	6B
0005432603687	6465	21	6C
0005434512022	6465	22	6D
0005432603695	6465	23	7A
0005432603684	6465	24	7B
0005434512027	6465	25	7C
0005432603709	6465	26	7D
0005432603719	6465	27	18A
0005434512024	6465	28	18B
0005432603694	6465	29	18C
0005432603689	6465	30	18D
0005432603699	6465	31	19A
0005432603698	6465	32	19B
0005432603712	6465	33	19C
0005432603702	6465	34	19D
0005434512025	6465	35	20B
0005432603716	6465	36	20C
0005432603691	6465	37	20D
0005432603693	6465	38	21A
0005432603706	6465	39	21B
0005432603686	6465	40	21C
0005432603721	6465	41	21D
0005432603688	6465	42	22A
0005432603715	6465	43	22B
0005432603717	6465	44	22C
0005432603710	6465	45	22D
0005432603692	6465	46	23A
0005432603720	6465	47	23B
0005433250989	15002	1	1A
0005433250985	15002	2	2C
0005433250988	15002	3	3D
0005433250968	15002	4	4D
0005433250979	15002	5	5D
0005433250972	15002	6	5F
0005433250959	15002	7	6A
0005433250961	15002	8	6C
0005433250962	15002	9	6E
0005433250981	15002	10	7D
0005433250974	15002	11	7F
0005433250965	15002	12	8D
0005433250983	15002	13	8E
0005433250987	15002	14	9C
0005433250971	15002	15	9D
0005433250967	15002	16	11A
0005433250966	15002	17	11C
0005433250980	15002	18	12D
0005433250970	15002	19	12F
0005433250963	15002	20	13E
0005433250978	15002	21	14D
0005433250975	15002	22	15D
0005433250984	15002	23	15F
0005433250977	15002	24	16E
0005433250969	15002	25	17E
0005433250964	15002	26	17F
0005433250982	15002	27	19A
0005433250986	15002	28	20A
0005433250973	15002	29	20C
0005433250960	15002	30	20D
0005433250976	15002	31	20E
0005434906406	25859	1	1C
0005434906388	25859	2	1D
0005434906405	25859	3	2D
0005434906368	25859	4	3F
0005434906400	25859	5	4A
0005434906379	25859	6	4C
0005434906404	25859	7	4D
0005434906364	25859	8	4E
0005434906362	25859	9	5A
0005434906371	25859	10	5D
0005434906375	25859	11	5F
0005434906384	25859	12	6D
0005434906395	25859	13	6F
0005434906365	25859	14	7A
0005434906396	25859	15	7C
0005434906392	25859	16	8A
0005434906398	25859	17	8D
0005434906391	25859	18	8E
0005434906370	25859	19	9A
0005434906360	25859	20	9E
0005434906381	25859	21	10A
0005434906377	25859	22	10D
0005434906374	25859	23	10F
0005434906401	25859	24	11C
0005434906389	25859	25	11D
0005434906403	25859	26	11F
0005434906393	25859	27	12A
0005434906394	25859	28	12C
0005434906359	25859	29	13D
0005434906397	25859	30	13E
0005434906361	25859	31	13F
0005434906367	25859	32	14A
0005434906383	25859	33	14C
0005434906373	25859	34	14E
0005434906385	25859	35	15C
0005434906402	25859	36	15E
0005434906376	25859	37	15F
0005434906366	25859	38	16F
0005434906380	25859	39	17A
0005434906378	25859	40	17D
0005434906390	25859	41	17F
0005434906387	25859	42	18A
0005434906363	25859	43	18C
0005434906369	25859	44	18D
0005434906382	25859	45	18F
0005434906386	25859	46	19A
0005434906399	25859	47	19E
0005434906372	25859	48	20A
0005433007874	14193	1	1D
0005433007882	14193	2	2A
0005433007890	14193	3	3A
0005433007898	14193	4	4C
0005433007868	14193	5	5C
0005433007907	14193	6	5D
0005433007908	14193	7	5E
0005433007900	14193	8	5F
0005433007881	14193	9	6A
0005433007871	14193	10	6F
0005433007897	14193	11	7A
0005433007885	14193	12	7E
0005433007893	14193	13	8A
0005433007892	14193	14	8D
0005433007910	14193	15	8F
0005433007878	14193	16	9C
0005433007894	14193	17	10C
0005433007903	14193	18	10E
0005433007872	14193	19	11A
0005433007895	14193	20	12C
0005433007880	14193	21	12D
0005433007886	14193	22	12F
0005433007914	14193	23	13C
0005433007887	14193	24	13D
0005433007902	14193	25	13E
0005433007905	14193	26	13F
0005433007901	14193	27	14C
0005433007889	14193	28	14D
0005433007873	14193	29	14F
0005433007883	14193	30	15C
0005433007870	14193	31	15D
0005433007884	14193	32	15E
0005433007869	14193	33	16A
0005433007913	14193	34	16D
0005433007904	14193	35	16E
0005433007906	14193	36	16F
0005433007879	14193	37	17A
0005433007912	14193	38	17C
0005433007877	14193	39	17D
0005433007875	14193	40	17E
0005433007909	14193	41	17F
0005433007896	14193	42	18A
0005433007876	14193	43	18F
0005433007888	14193	44	19D
0005433007891	14193	45	19F
0005433007899	14193	46	20A
0005433007911	14193	47	20C
0005433810489	22824	1	2D
0005433810491	22824	2	6A
0005433810490	22824	3	7A
0005433810488	22824	4	16C
0005435718828	15523	1	1D
0005435718829	15523	2	3A
0005435718830	15523	3	11A
0005435718827	15523	4	12A
0005435718831	15523	5	16D
0005434925265	20535	1	1C
0005434925247	20535	2	3A
0005434925272	20535	3	3C
0005434925269	20535	4	3D
0005434925259	20535	5	4C
0005434925270	20535	6	4E
0005434925261	20535	7	5C
0005434925256	20535	8	5F
0005434925268	20535	9	6C
0005434925258	20535	10	6F
0005434925267	20535	11	7F
0005434925264	20535	12	8D
0005434925266	20535	13	8E
0005434925253	20535	14	8F
0005434925262	20535	15	10C
0005434925257	20535	16	10D
0005434925251	20535	17	12E
0005434925263	20535	18	13E
0005434925260	20535	19	14A
0005434925254	20535	20	14D
0005434925252	20535	21	15C
0005434925249	20535	22	16A
0005434925248	20535	23	17E
0005434925255	20535	24	18C
0005434925250	20535	25	20A
0005434925271	20535	26	20D
0005435487479	15793	1	1A
0005435487494	15793	2	2B
0005435487478	15793	3	2C
0005435487482	15793	4	2D
0005435487484	15793	5	3A
0005435487485	15793	6	3C
0005435487481	15793	7	4B
0005435487480	15793	8	4C
0005435487486	15793	9	5D
0005435487477	15793	10	7B
0005435487475	15793	11	7C
0005435487489	15793	12	7D
0005435487491	15793	13	18A
0005435487496	15793	14	18C
0005435487490	15793	15	18D
0005435487476	15793	16	19A
0005435487492	15793	17	19B
0005435487497	15793	18	20A
0005435487487	15793	19	20D
0005435487495	15793	20	21D
0005435487483	15793	21	22A
0005435487493	15793	22	22B
0005435487488	15793	23	23A
0005435998959	19673	1	1B
0005435998954	19673	2	1D
0005435998955	19673	3	2B
0005435998965	19673	4	2C
0005435998963	19673	5	2D
0005435998961	19673	6	3B
0005435998960	19673	7	4B
0005435998962	19673	8	5D
0005435998964	19673	9	6B
0005435998957	19673	10	18B
0005435998952	19673	11	18C
0005435998951	19673	12	19A
0005435998958	19673	13	19B
0005435998967	19673	14	19C
0005435998953	19673	15	20B
0005435998956	19673	16	22D
0005435998966	19673	17	23B
0005435838991	5984	1	1A
0005435839013	5984	2	1C
0005432660785	5984	3	2A
0005432660786	5984	4	1F
0005435838989	5984	5	3D
0005435838993	5984	6	3C
0005435838988	5984	7	3F
0005435839011	5984	8	4C
0005435838995	5984	9	6C
0005435839004	5984	10	6D
0005435838996	5984	11	7E
0005435839008	5984	12	7D
0005435838987	5984	13	9D
0005435839000	5984	14	9E
0005432658559	5984	15	10E
0005435839001	5984	16	12B
0005432659674	5984	17	12C
0005432660784	5984	18	12E
0005435838990	5984	19	13A
0005435839007	5984	20	13C
0005432658558	5984	21	13E
0005435838998	5984	22	13F
0005435838994	5984	23	14C
0005435838986	5984	24	15B
0005435839002	5984	25	15A
0005435839010	5984	26	16D
0005435839014	5984	27	16C
0005435839003	5984	28	16F
0005432660787	5984	29	16E
0005435839009	5984	30	17B
0005435838997	5984	31	17D
0005435838999	5984	32	17C
0005435839006	5984	33	18B
0005435838992	5984	34	20B
0005432659673	5984	35	20D
0005435839012	5984	36	20C
0005435839005	5984	37	21B
0005432142202	5984	38	21A
0005435472543	18086	1	1C
0005435472536	18086	2	1D
0005435472539	18086	3	8D
0005435472531	18086	4	8E
0005435472535	18086	5	9B
0005435472532	18086	6	10C
0005435472530	18086	7	10D
0005435472541	18086	8	11A
0005435472529	18086	9	11C
0005435472537	18086	10	11E
0005435472544	18086	11	12D
0005432537023	18086	12	12F
0005432537024	18086	13	15B
0005435472534	18086	14	15C
0005435472540	18086	15	17E
0005435472538	18086	16	19C
0005435472542	18086	17	20B
0005435472533	18086	18	21F
0005435103796	23047	1	1D
0005435103798	23047	2	1F
0005435103801	23047	3	2F
0005435103799	23047	4	4A
0005435103797	23047	5	4C
0005435103793	23047	6	12C
0005435103803	23047	7	13B
0005435103802	23047	8	18A
0005435103794	23047	9	18F
0005435103795	23047	10	20D
0005435103800	23047	11	23F
0005433284805	32049	1	1A
0005433284811	32049	2	2D
0005433284800	32049	3	3F
0005433284795	32049	4	4B
0005433284817	32049	5	4A
0005433284814	32049	6	5A
0005433284801	32049	7	5D
0005433284816	32049	8	5F
0005433284806	32049	9	6C
0005433284802	32049	10	6F
0005433284812	32049	11	7B
0005433284813	32049	12	8F
0005433284807	32049	13	9A
0005433284820	32049	14	9B
0005433284798	32049	15	10D
0005433284796	32049	16	11D
0005433284804	32049	17	12B
0005433284797	32049	18	13C
0005433284803	32049	19	13F
0005433284810	32049	20	15E
0005433284819	32049	21	16C
0005433284808	32049	22	17C
0005433284799	32049	23	18F
0005433284815	32049	24	21B
0005433284809	32049	25	22D
0005433284818	32049	26	23F
0005432802433	1478	1	4F
0005432802430	1478	2	13B
0005432802432	1478	3	15C
0005432802429	1478	4	16F
0005432802434	1478	5	17C
0005432802431	1478	6	18B
0005432802435	1478	7	20D
0005435852529	23856	1	3A
0005435852528	23856	2	3D
0005435852530	23856	3	4B
0005435852532	23856	4	18A
0005435852533	23856	5	20D
0005435852526	23856	6	21B
0005435852525	23856	7	21C
0005435852527	23856	8	22A
0005435852531	23856	9	22B
0005435212498	30585	1	1H
0005432211384	30585	2	2A
0005435212476	30585	3	2G
0005435212468	30585	4	2H
0005435212519	30585	5	3G
0005435212501	30585	6	3C
0005435212482	30585	7	5D
0005432159785	30585	8	11E
0005435212473	30585	9	11F
0005435212485	30585	10	11G
0005435725525	30585	11	12F
0005435725523	30585	12	12D
0005435212520	30585	13	12G
0005435212495	30585	14	13A
0005435212504	30585	15	13F
0005435212507	30585	16	13K
0005432211383	30585	17	14D
0005432211385	30585	18	14F
0005435212516	30585	19	14H
0005435212523	30585	20	15F
0005435212472	30585	21	15E
0005435725524	30585	22	16F
0005435212503	30585	23	17C
0005435212496	30585	24	17G
0005435212497	30585	25	17H
0005435212502	30585	26	18C
0005435212494	30585	27	18K
0005435212470	30585	28	19H
0005435212530	30585	29	19J
0005435212489	30585	30	20K
0005435212514	30585	31	21A
0005435212499	30585	32	21H
0005435212500	30585	33	22C
0005435212481	30585	34	22G
0005435212521	30585	35	22K
0005433656618	30585	36	23H
0005435212491	30585	37	25B
0005435725522	30585	38	25F
0005435212510	30585	39	25J
0005435212526	30585	40	25H
0005435212512	30585	41	26E
0005432211388	30585	42	27B
0005435212487	30585	43	28B
0005435212480	30585	44	28G
0005432211382	30585	45	29F
0005433656619	30585	46	29G
0005432159786	30585	47	29K
0005435212492	30585	48	29J
0005435212467	30585	49	30B
0005435212531	30585	50	30C
0005435212532	30585	51	30G
0005435630920	30585	52	31H
0005435212505	30585	53	32G
0005435212478	30585	54	33A
0005435212483	30585	55	33D
0005435725526	30585	56	33B
0005435212477	30585	57	33K
0005435212534	30585	58	34D
0005435212479	30585	59	34F
0005435212513	30585	60	36A
0005435212490	30585	61	36D
0005435212471	30585	62	36C
0005435212469	30585	63	36F
0005432211386	30585	64	37B
0005432159784	30585	65	37C
0005435212509	30585	66	37E
0005435212533	30585	67	38B
0005435212508	30585	68	38A
0005435212528	30585	69	38K
0005435212524	30585	70	39F
0005435630919	30585	71	39H
0005435725521	30585	72	40C
0005435212511	30585	73	40H
0005432211381	30585	74	40K
0005435212522	30585	75	40J
0005435212517	30585	76	41E
0005435212493	30585	77	42C
0005432159787	30585	78	42F
0005435212474	30585	79	42H
0005435212488	30585	80	43B
0005435212486	30585	81	43F
0005435212515	30585	82	43E
0005435630922	30585	83	44B
0005433656620	30585	84	44E
0005432211387	30585	85	45B
0005435212475	30585	86	44K
0005435212525	30585	87	45K
0005435212484	30585	88	45J
0005435212506	30585	89	47A
0005435212527	30585	90	46K
0005435212535	30585	91	50A
0005435212529	30585	92	51D
0005435630921	30585	93	50K
0005435212518	30585	94	51F
0005433367304	24816	1	2A
0005433367329	24816	2	2D
0005433367328	24816	3	3D
0005433367312	24816	4	4A
0005433367315	24816	5	4D
0005433367300	24816	6	4E
0005433367317	24816	7	4F
0005433367314	24816	8	5A
0005433367301	24816	9	5C
0005433367326	24816	10	5F
0005433367320	24816	11	6A
0005433367309	24816	12	6C
0005433367324	24816	13	7C
0005433367299	24816	14	7D
0005433367321	24816	15	7E
0005433367316	24816	16	8A
0005433367305	24816	17	8F
0005433367331	24816	18	9D
0005433367330	24816	19	11A
0005433367307	24816	20	12D
0005433367313	24816	21	12F
0005433367297	24816	22	13F
0005433367303	24816	23	14A
0005433367295	24816	24	14C
0005433367318	24816	25	14D
0005433367308	24816	26	14F
0005433367319	24816	27	15D
0005433367323	24816	28	16A
0005433367332	24816	29	16F
0005433367310	24816	30	17C
0005433367306	24816	31	18A
0005433367296	24816	32	18C
0005433367325	24816	33	19C
0005433367298	24816	34	19D
0005433367322	24816	35	19E
0005433367311	24816	36	19F
0005433367302	24816	37	20A
0005433367327	24816	38	20E
0005434979340	2019	1	1B
0005434979325	2019	2	2B
0005434979330	2019	3	2C
0005434979317	2019	4	2D
0005434979342	2019	5	3A
0005434979315	2019	6	3C
0005434979334	2019	7	3D
0005434979319	2019	8	4C
0005435801650	2019	9	4D
0005434979320	2019	10	5A
0005434979314	2019	11	5B
0005434979339	2019	12	5D
0005434979322	2019	13	6A
0005434979318	2019	14	6D
0005434979338	2019	15	7A
0005434979326	2019	16	7B
0005434979324	2019	17	18A
0005434979333	2019	18	18B
0005434979323	2019	19	18C
0005434979336	2019	20	18D
0005435801649	2019	21	19A
0005434979321	2019	22	19B
0005434979329	2019	23	19D
0005434979328	2019	24	20A
0005434979341	2019	25	20B
0005434979316	2019	26	20C
0005434979332	2019	27	20D
0005434979327	2019	28	21A
0005434979337	2019	29	21B
0005434979335	2019	30	21D
0005434979343	2019	31	22A
0005435801648	2019	32	22C
0005434979344	2019	33	22D
0005434979331	2019	34	23B
0005434952471	2662	1	3A
0005434952474	2662	2	3B
0005434952472	2662	3	5B
0005434952473	2662	4	6B
0005433256387	28207	1	3A
0005433256386	28207	2	5A
0005433112351	19839	1	4A
0005433112352	19839	2	5A
0005433111472	19839	3	5B
0005433111473	19839	4	6B
0005434136781	28755	1	1A
0005434136822	28755	2	1D
0005434136785	28755	3	1F
0005434136775	28755	4	2A
0005434136799	28755	5	2C
0005434136800	28755	6	2D
0005434136844	28755	7	2F
0005434136811	28755	8	3A
0005434136810	28755	9	3C
0005434136786	28755	10	3D
0005434136790	28755	11	3F
0005434136766	28755	12	4A
0005434136813	28755	13	4C
0005434136784	28755	14	4D
0005434136824	28755	15	4F
0005434136778	28755	16	4E
0005434136830	28755	17	5C
0005434136821	28755	18	5D
0005434136795	28755	19	5E
0005434136793	28755	20	5F
0005434136823	28755	21	6A
0005434136768	28755	22	6C
0005434136843	28755	23	6D
0005434136839	28755	24	6E
0005434136802	28755	25	6F
0005434136794	28755	26	7A
0005434136774	28755	27	7C
0005434136776	28755	28	7D
0005434136796	28755	29	7E
0005434136838	28755	30	7F
0005434136819	28755	31	8A
0005434136764	28755	32	8C
0005434136835	28755	33	8D
0005434136825	28755	34	8E
0005434136797	28755	35	8F
0005434136771	28755	36	9A
0005434136767	28755	37	9C
0005434136832	28755	38	9D
0005434136801	28755	39	9E
0005434136831	28755	40	9F
0005434136782	28755	41	10A
0005434136816	28755	42	10C
0005434136803	28755	43	10D
0005434136836	28755	44	10E
0005434136792	28755	45	10F
0005434136834	28755	46	11A
0005434136762	28755	47	11C
0005434136814	28755	48	11D
0005434136828	28755	49	11F
0005434136808	28755	50	12A
0005434136773	28755	51	12C
0005434136770	28755	52	12D
0005434136837	28755	53	12E
0005434136765	28755	54	12F
0005434136761	28755	55	13A
0005434136818	28755	56	13C
0005434136809	28755	57	13D
0005434136783	28755	58	13F
0005434136807	28755	59	14A
0005434136842	28755	60	14C
0005434136841	28755	61	14D
0005434136760	28755	62	14E
0005434136780	28755	63	14F
0005434136805	28755	64	15A
0005434136791	28755	65	15C
0005434136815	28755	66	15D
0005434136806	28755	67	15F
0005434136829	28755	68	16A
0005434136779	28755	69	16D
0005434136820	28755	70	16E
0005434136840	28755	71	16F
0005434136812	28755	72	17E
0005434136827	28755	73	17F
0005434136769	28755	74	18A
0005434136798	28755	75	18C
0005434136788	28755	76	18E
0005434136826	28755	77	18F
0005434136777	28755	78	19A
0005434136787	28755	79	19C
0005434136789	28755	80	19D
0005434136817	28755	81	20A
0005434136772	28755	82	20C
0005434136804	28755	83	20D
0005434136833	28755	84	20E
0005434136763	28755	85	20F
0005434466385	6571	1	4C
0005434466384	6571	2	4D
0005434466380	6571	3	5A
0005434466383	6571	4	6A
0005434466373	6571	5	6B
0005434466375	6571	6	7B
0005434466387	6571	7	7D
0005434466386	6571	8	18C
0005434466376	6571	9	19A
0005434466379	6571	10	19C
0005434466382	6571	11	20A
0005434466378	6571	12	21D
0005434466381	6571	13	22B
0005434466377	6571	14	22C
0005434466372	6571	15	22D
0005434466374	6571	16	23B
0005433534466	6781	1	3B
0005433538738	6781	2	4B
0005433538740	6781	3	4D
0005433538734	6781	4	5A
0005433534465	6781	5	5C
0005433538741	6781	6	6A
0005433534464	6781	7	7B
0005433538739	6781	8	18B
0005433538736	6781	9	20A
0005433538737	6781	10	21A
0005433538735	6781	11	22A
0005435259690	25036	1	4B
0005435259688	25036	2	20B
0005435259689	25036	3	23B
0005433511818	852	1	3C
0005433511824	852	2	3D
0005433511823	852	3	4A
0005433511825	852	4	4C
0005433511819	852	5	6D
0005433511820	852	6	7A
0005433511822	852	7	21D
0005433511821	852	8	23B
0005432922460	16155	1	2A
0005432922462	16155	2	2D
0005432922463	16155	3	18A
0005432922461	16155	4	21D
0005432922464	16155	5	23A
0005433475638	4026	1	1D
0005433475635	4026	2	2C
0005433475634	4026	3	4D
0005433475640	4026	4	6A
0005433475641	4026	5	18A
0005433475642	4026	6	20D
0005433475636	4026	7	22C
0005433475639	4026	8	22D
0005433475637	4026	9	23A
0005435696918	3686	1	1A
0005435696924	3686	2	1B
0005435696912	3686	3	2A
0005435696902	3686	4	2B
0005435696917	3686	5	2C
0005435696904	3686	6	3D
0005435696927	3686	7	4A
0005435696919	3686	8	4B
0005435696901	3686	9	4C
0005435696905	3686	10	4D
0005434950460	3686	11	5A
0005435696928	3686	12	5B
0005435696925	3686	13	5C
0005435696915	3686	14	6A
0005435696926	3686	15	6B
0005435696914	3686	16	6C
0005435696910	3686	17	7C
0005434950462	3686	18	7D
0005435696911	3686	19	18A
0005435696923	3686	20	18B
0005435696916	3686	21	19A
0005435696909	3686	22	19B
0005435696913	3686	23	19C
0005435696920	3686	24	19D
0005435696921	3686	25	20B
0005434950459	3686	26	20D
0005435696907	3686	27	21A
0005435696922	3686	28	21C
0005434950461	3686	29	22A
0005435696908	3686	30	22C
0005435696903	3686	31	22D
0005435696906	3686	32	23B
0005435934997	16282	1	3C
0005435916125	16282	2	5D
0005435916126	16282	3	18C
0005435934998	16282	4	21A
0005435916123	16282	5	21C
0005435916124	16282	6	23A
0005435934996	16282	7	23B
0005433519386	3948	1	1A
0005432607504	3948	2	1B
0005432609671	3948	3	1C
0005432607502	3948	4	3A
0005434606770	3948	5	3B
0005433519389	3948	6	4D
0005434606769	3948	7	5A
0005433519388	3948	8	5B
0005432609670	3948	9	6A
0005432607505	3948	10	6D
0005434606771	3948	11	18B
0005434604845	3948	12	18D
0005434606768	3948	13	19C
0005432609669	3948	14	20B
0005433519387	3948	15	21C
0005432609667	3948	16	22A
0005432609668	3948	17	22D
0005432607503	3948	18	23B
0005435853581	22043	1	1B
0005435853584	22043	2	6C
0005435853582	22043	3	7C
0005435853583	22043	4	18B
0005435628673	767	1	1A
0005435628674	767	2	2A
0005435628675	767	3	1B
0005435628676	767	4	3B
0005433348901	15913	1	1B
0005433348903	15913	2	2B
0005433348899	15913	3	3A
0005433348900	15913	4	3B
0005433348902	15913	5	5A
0005433348898	15913	6	6B
0005434446480	17216	1	1A
0005434446479	17216	2	3A
0005434446477	17216	3	3B
0005434446481	17216	4	4A
0005434445211	17216	5	5A
0005434446478	17216	6	5B
0005433159279	17681	1	4A
0005433159280	17681	2	4B
0005435132716	7894	1	1C
0005435132723	7894	2	3C
0005435132717	7894	3	6A
0005435132725	7894	4	7B
0005435132721	7894	5	19A
0005435132719	7894	6	19B
0005435132718	7894	7	21A
0005435132715	7894	8	21D
0005435132722	7894	9	22A
0005435132724	7894	10	22B
0005435132720	7894	11	22D
0005435383069	33110	1	1A
0005435383068	33110	2	4A
0005435383070	33110	3	18C
0005435383067	33110	4	22C
0005435160131	7530	1	1C
0005435160134	7530	2	1D
0005435160136	7530	3	2C
0005435160132	7530	4	2D
0005435160127	7530	5	4B
0005435160129	7530	6	4C
0005435160128	7530	7	5B
0005435160135	7530	8	6D
0005435160126	7530	9	19C
0005435160133	7530	10	21D
0005435160130	7530	11	23A
0005435390137	29568	1	2D
0005435390131	29568	2	5A
0005435390138	29568	3	6C
0005435390133	29568	4	18C
0005435390132	29568	5	19D
0005435390134	29568	6	20D
0005435390136	29568	7	21A
0005435390135	29568	8	22C
0005435178473	18443	1	1B
0005435178471	18443	2	2A
0005435178978	18443	3	3B
0005435178472	18443	4	5A
0005432400062	27181	1	1A
0005432398135	27181	2	1B
0005432400061	27181	3	3A
0005432400063	27181	4	3B
0005432398133	27181	5	4A
0005432400064	27181	6	4B
0005432398132	27181	7	5A
0005432398134	27181	8	6A
0005432638939	2243	1	2A
0005432638937	2243	2	2D
0005432638932	2243	3	3D
0005432638929	2243	4	4A
0005432638923	2243	5	5E
0005432638922	2243	6	6E
0005432638943	2243	7	6F
0005432638936	2243	8	7A
0005432638917	2243	9	7C
0005432638948	2243	10	8A
0005432638934	2243	11	8C
0005432638925	2243	12	8D
0005432638924	2243	13	8F
0005432638947	2243	14	9D
0005432638926	2243	15	9E
0005432638919	2243	16	10C
0005432638928	2243	17	10E
0005432638951	2243	18	10F
0005432638949	2243	19	11D
0005432638935	2243	20	11F
0005432638933	2243	21	12E
0005432638941	2243	22	13A
0005432638945	2243	23	13C
0005432638942	2243	24	14C
0005432638944	2243	25	14F
0005432638920	2243	26	14E
0005432638938	2243	27	15A
0005432638915	2243	28	15D
0005432638930	2243	29	15E
0005432638921	2243	30	16C
0005432638927	2243	31	16E
0005432638918	2243	32	16F
0005432638950	2243	33	17A
0005432638952	2243	34	17D
0005432638916	2243	35	17F
0005432638931	2243	36	18C
0005432638940	2243	37	19C
0005432638946	2243	38	20E
0005434503566	6528	1	1A
0005434503547	6528	2	1F
0005434503553	6528	3	2D
0005435103819	6528	4	3A
0005434503560	6528	5	3D
0005434503544	6528	6	3F
0005434503540	6528	7	4A
0005434503549	6528	8	4D
0005434503557	6528	9	5D
0005434503568	6528	10	5E
0005434503565	6528	11	6D
0005434503552	6528	12	6E
0005434503548	6528	13	6F
0005434503563	6528	14	7C
0005434503550	6528	15	7E
0005434503562	6528	16	7F
0005434503554	6528	17	8C
0005434503564	6528	18	9A
0005434503556	6528	19	9C
0005434503573	6528	20	9D
0005434503569	6528	21	9F
0005434503541	6528	22	10C
0005434503555	6528	23	10E
0005434503574	6528	24	10F
0005434503542	6528	25	11A
0005434503559	6528	26	11D
0005435103820	6528	27	11E
0005434503571	6528	28	12F
0005434503558	6528	29	13A
0005434503567	6528	30	13C
0005434503570	6528	31	13D
0005434503546	6528	32	14A
0005434503537	6528	33	14D
0005434503572	6528	34	14F
0005434503545	6528	35	15D
0005434503576	6528	36	15F
0005434503575	6528	37	16D
0005434503551	6528	38	16E
0005435103822	6528	39	17A
0005434503539	6528	40	17C
0005435103823	6528	41	17F
0005434503543	6528	42	18A
0005435103821	6528	43	18C
0005434503577	6528	44	18E
0005435103824	6528	45	19D
0005434503538	6528	46	20A
0005434503561	6528	47	20C
0005435800080	6423	1	1B
0005435800079	6423	2	18C
0005435800077	6423	3	20D
0005435800081	6423	4	21C
0005435800078	6423	5	22D
0005435652367	1644	1	1D
0005435652382	1644	2	2D
0005435652351	1644	3	2F
0005435652365	1644	4	3A
0005435652357	1644	5	3F
0005435652340	1644	6	4A
0005435652354	1644	7	4C
0005435652377	1644	8	4D
0005435652374	1644	9	5E
0005435652348	1644	10	6C
0005435652373	1644	11	6D
0005435652376	1644	12	6E
0005435652350	1644	13	7A
0005435652343	1644	14	7C
0005435652379	1644	15	8C
0005435652341	1644	16	8E
0005435652349	1644	17	9A
0005435652383	1644	18	9E
0005435652352	1644	19	10D
0005435652355	1644	20	10E
0005435652346	1644	21	10F
0005435652381	1644	22	11A
0005435652364	1644	23	11D
0005435652370	1644	24	11E
0005435652358	1644	25	12A
0005435652366	1644	26	12C
0005435652344	1644	27	12E
0005435652372	1644	28	13A
0005435652380	1644	29	13D
0005435652368	1644	30	14C
0005435652342	1644	31	14E
0005435652359	1644	32	14F
0005435652345	1644	33	15D
0005435652361	1644	34	15F
0005435652375	1644	35	16C
0005435652353	1644	36	16F
0005435652362	1644	37	17C
0005435652356	1644	38	17D
0005435652347	1644	39	17F
0005435652360	1644	40	18D
0005435652378	1644	41	18F
0005435652369	1644	42	19D
0005435652371	1644	43	19F
0005435652363	1644	44	20C
0005433367308	21718	1	1C
0005433367332	21718	2	2A
0005433367295	21718	3	2C
0005433367299	21718	4	4C
0005433367315	21718	5	4E
0005433367311	21718	6	5A
0005433367314	21718	7	5C
0005433367306	21718	8	5E
0005433367302	21718	9	5F
0005433367319	21718	10	6A
0005433367317	21718	11	6C
0005433367310	21718	12	6F
0005433367307	21718	13	7F
0005433367331	21718	14	8C
0005433367312	21718	15	8E
0005433367304	21718	16	9A
0005433367326	21718	17	9C
0005433367330	21718	18	9D
0005433367329	21718	19	11E
0005433367300	21718	20	11F
0005433367320	21718	21	13C
0005433367327	21718	22	13D
0005433367305	21718	23	13F
0005433367322	21718	24	15A
0005433367297	21718	25	15D
0005433367321	21718	26	15E
0005433367298	21718	27	16E
0005433367313	21718	28	17C
0005433367323	21718	29	17E
0005433367324	21718	30	18A
0005433367296	21718	31	18D
0005433367316	21718	32	18F
0005433367303	21718	33	19A
0005433367309	21718	34	19C
0005433367301	21718	35	19D
0005433367318	21718	36	19E
0005433367325	21718	37	19F
0005433367328	21718	38	20A
0005435312764	23227	1	1A
0005435312766	23227	2	3B
0005435312765	23227	3	4B
0005435312767	23227	4	19D
0005435312769	23227	5	20B
0005435312768	23227	6	23A
0005433985218	4172	1	3C
0005433985216	4172	2	3D
0005433985250	4172	3	4A
0005433985231	4172	4	4E
0005433985255	4172	5	5C
0005433985247	4172	6	5D
0005433985215	4172	7	5E
0005433985259	4172	8	5F
0005433985234	4172	9	6A
0005433985230	4172	10	6C
0005433985239	4172	11	6D
0005433985222	4172	12	7A
0005433985219	4172	13	7C
0005433985225	4172	14	7E
0005433985252	4172	15	7F
0005433985256	4172	16	8A
0005433985238	4172	17	8C
0005433985236	4172	18	8E
0005433985243	4172	19	8F
0005433985242	4172	20	9A
0005433985257	4172	21	9C
0005433985213	4172	22	9D
0005433985253	4172	23	9E
0005433985224	4172	24	10A
0005433985229	4172	25	10D
0005433985246	4172	26	11A
0005433985260	4172	27	11C
0005433985248	4172	28	11E
0005433985227	4172	29	11F
0005433985232	4172	30	12A
0005433985228	4172	31	12D
0005433985240	4172	32	12E
0005433985244	4172	33	12F
0005435788731	4172	34	13C
0005433985249	4172	35	13D
0005433985235	4172	36	13E
0005433985233	4172	37	14E
0005433985237	4172	38	14F
0005433985254	4172	39	15E
0005433985223	4172	40	15F
0005433985220	4172	41	16A
0005433985217	4172	42	16D
0005433985226	4172	43	16E
0005433985245	4172	44	17F
0005433985221	4172	45	18D
0005433985251	4172	46	18E
0005433985241	4172	47	19D
0005433985214	4172	48	19F
0005435788732	4172	49	20A
0005433985212	4172	50	20D
0005433985258	4172	51	20E
0005433168309	21336	1	3A
0005433168303	21336	2	3C
0005433168306	21336	3	4A
0005433168305	21336	4	7A
0005433168308	21336	5	18B
0005433168311	21336	6	20D
0005433168304	21336	7	21A
0005433168307	21336	8	22D
0005433168310	21336	9	23B
0005434151662	17837	1	1F
0005432869429	17837	2	2D
0005432869426	17837	3	3A
0005432869425	17837	4	8D
0005434151660	17837	5	11E
0005432869428	17837	6	12F
0005432869424	17837	7	13A
0005434151661	17837	8	13C
0005432869427	17837	9	13F
0005432869430	17837	10	17E
0005432665240	26337	1	1C
0005432657399	26337	2	2A
0005432655336	26337	3	2F
0005432655337	26337	4	3C
0005432655330	26337	5	4A
0005432655326	26337	6	4E
0005432655335	26337	7	5D
0005432658556	26337	8	7A
0005432665239	26337	9	7F
0005432657396	26337	10	10E
0005432667419	26337	11	10F
0005432657397	26337	12	11D
0005432655328	26337	13	12C
0005432655331	26337	14	12F
0005432659672	26337	15	13F
0005432667418	26337	16	14A
0005432655332	26337	17	14C
0005432658555	26337	18	15A
0005432658557	26337	19	15C
0005432655333	26337	20	16C
0005432655334	26337	21	16E
0005432655327	26337	22	17E
0005432667420	26337	23	18D
0005432657398	26337	24	18E
0005432655329	26337	25	19C
0005432659671	26337	26	20E
0005432666354	26337	27	20F
0005432328001	3075	1	1A
0005432328023	3075	2	1C
0005432328006	3075	3	1D
0005433438780	3075	4	1F
0005432328017	3075	5	2C
0005432328009	3075	6	2D
0005432327987	3075	7	3A
0005432328004	3075	8	3C
0005432328024	3075	9	3D
0005432328027	3075	10	3F
0005432328005	3075	11	4D
0005432328000	3075	12	4E
0005432327993	3075	13	5A
0005432327995	3075	14	5C
0005432328030	3075	15	5D
0005432328016	3075	16	5F
0005433438784	3075	17	6A
0005432327988	3075	18	6D
0005432328011	3075	19	6F
0005432328014	3075	20	7A
0005432328008	3075	21	7C
0005432328002	3075	22	7D
0005432327986	3075	23	7F
0005432328029	3075	24	8A
0005432287112	3075	25	8C
0005432328022	3075	26	8D
0005432327989	3075	27	8E
0005432328013	3075	28	9A
0005432327991	3075	29	9C
0005432287115	3075	30	9D
0005433438781	3075	31	9F
0005433438779	3075	32	10A
0005433438783	3075	33	10E
0005432328028	3075	34	10F
0005433438777	3075	35	11C
0005432327998	3075	36	11E
0005432287110	3075	37	11F
0005432327985	3075	38	12D
0005432287113	3075	39	12E
0005432287114	3075	40	13A
0005432328025	3075	41	13F
0005432328021	3075	42	14A
0005432328020	3075	43	14C
0005432327997	3075	44	14E
0005432328031	3075	45	14F
0005432328010	3075	46	15E
0005432287111	3075	47	15F
0005432328003	3075	48	16D
0005433438782	3075	49	16E
0005432328015	3075	50	16F
0005432328019	3075	51	17E
0005432327994	3075	52	17F
0005432328018	3075	53	18A
0005432328012	3075	54	18D
0005432328007	3075	55	18E
0005432327996	3075	56	18F
0005432327990	3075	57	19C
0005432328026	3075	58	19D
0005432327992	3075	59	19F
0005433438778	3075	60	20E
0005432327999	3075	61	20F
0005432905034	31102	1	3C
0005432054261	31102	2	9C
0005432905029	31102	3	9F
0005432054258	31102	4	10C
0005432905035	31102	5	13F
0005432054259	31102	6	14C
0005432905030	31102	7	16A
0005432905033	31102	8	16D
0005432054260	31102	9	16F
0005432905032	31102	10	17C
0005432905031	31102	11	18D
0005432848836	31102	12	20E
0005434309530	6232	1	1A
0005434309531	6232	2	3A
0005434309538	6232	3	3D
0005435998992	6232	4	3F
0005434309537	6232	5	4E
0005434309534	6232	6	6A
0005435998993	6232	7	6C
0005434309539	6232	8	7A
0005434309540	6232	9	7B
0005434309541	6232	10	7C
0005432146168	6232	11	7D
0005434309532	6232	12	8E
0005435998986	6232	13	9B
0005435998998	6232	14	9E
0005435998994	6232	15	9F
0005435998991	6232	16	10B
0005435998997	6232	17	11B
0005435998987	6232	18	12A
0005432146169	6232	19	12D
0005434309533	6232	20	14E
0005435998990	6232	21	15A
0005434309542	6232	22	14F
0005434309535	6232	23	16E
0005435998988	6232	24	16F
0005435998996	6232	25	18A
0005432146167	6232	26	18B
0005434309536	6232	27	19C
0005432146170	6232	28	19B
0005435998995	6232	29	20F
0005435998985	6232	30	22C
0005435998989	6232	31	23B
0005435487480	19534	1	1D
0005435487495	19534	2	3A
0005435487491	19534	3	3D
0005435487476	19534	4	4F
0005435487478	19534	5	5A
0005435487489	19534	6	6A
0005435487493	19534	7	6E
0005435296953	19534	8	7A
0005435487484	19534	9	7F
0005435487488	19534	10	10B
0005435487479	19534	11	11D
0005435487486	19534	12	11F
0005435487483	19534	13	13A
0005435296952	19534	14	13C
0005435487490	19534	15	14E
0005435487496	19534	16	14F
0005435487494	19534	17	15C
0005435296955	19534	18	15B
0005435487487	19534	19	15D
0005435296951	19534	20	15E
0005435296957	19534	21	16E
0005435487482	19534	22	17A
0005435487485	19534	23	17F
0005435487481	19534	24	18D
0005435296954	19534	25	19C
0005435487497	19534	26	19D
0005435487475	19534	27	20B
0005435487492	19534	28	20D
0005435487477	19534	29	21B
0005435296956	19534	30	22E
0005433158098	17533	1	2A
0005433158095	17533	2	21B
0005433158097	17533	3	21C
0005433158096	17533	4	23A
0005435501986	1548	1	1A
0005435501989	1548	2	1F
0005434565708	1548	3	2C
0005435501997	1548	4	2D
0005434565715	1548	5	3D
0005435517637	1548	6	3F
0005435501988	1548	7	4A
0005435517647	1548	8	4C
0005435508189	1548	9	4E
0005434565713	1548	10	4F
0005435517630	1548	11	5A
0005434565716	1548	12	5C
0005434565711	1548	13	5D
0005435501983	1548	14	5E
0005435517640	1548	15	5F
0005435501993	1548	16	6A
0005435508190	1548	17	6C
0005435517646	1548	18	6D
0005435501982	1548	19	6E
0005434565709	1548	20	6F
0005435517644	1548	21	7E
0005435501991	1548	22	7F
0005435501984	1548	23	8A
0005434565710	1548	24	8C
0005435501992	1548	25	8D
0005435501980	1548	26	8F
0005435517634	1548	27	9A
0005435501978	1548	28	9C
0005434565717	1548	29	9D
0005435508195	1548	30	10C
0005435501985	1548	31	10D
0005435517635	1548	32	10E
0005435508196	1548	33	11A
0005435517645	1548	34	11C
0005435517636	1548	35	11D
0005435501979	1548	36	11E
0005435508197	1548	37	11F
0005435517641	1548	38	12A
0005435501995	1548	39	12C
0005435517629	1548	40	12E
0005435508198	1548	41	12F
0005435508194	1548	42	13C
0005435508188	1548	43	13D
0005435501994	1548	44	13E
0005435508185	1548	45	13F
0005432291893	1548	46	14E
0005435517631	1548	47	14F
0005434565707	1548	48	15A
0005435517633	1548	49	15F
0005435508186	1548	50	16A
0005434565714	1548	51	16D
0005435517638	1548	52	16E
0005435501990	1548	53	17A
0005435508191	1548	54	17C
0005435508187	1548	55	17D
0005435501996	1548	56	17E
0005435508193	1548	57	17F
0005435517632	1548	58	18C
0005434565706	1548	59	18D
0005435517642	1548	60	18E
0005435501977	1548	61	19A
0005435517639	1548	62	19C
0005435517643	1548	63	19D
0005435501976	1548	64	19E
0005434565712	1548	65	19F
0005435508192	1548	66	20A
0005435501987	1548	67	20C
0005432291894	1548	68	20D
0005435501975	1548	69	20E
0005435501981	1548	70	20F
0005433185989	20867	1	1A
0005433185987	20867	2	2C
0005433185988	20867	3	4E
0005433185985	20867	4	4F
0005433185993	20867	5	5F
0005433185994	20867	6	7C
0005433185992	20867	7	10F
0005433185986	20867	8	12A
0005433185990	20867	9	13E
0005433185991	20867	10	14E
0005435153643	3901	1	3A
0005435153645	3901	2	4D
0005435153644	3901	3	5A
0005435153640	3901	4	6A
0005435153641	3901	5	7C
0005435153642	3901	6	21C
0005435931544	21850	1	6B
0005435931545	21850	2	6C
0005435931543	21850	3	21C
0005432628622	7186	1	2A
0005432628619	7186	2	2C
0005432628617	7186	3	3C
0005432628624	7186	4	3D
0005432628628	7186	5	5A
0005432628620	7186	6	5D
0005432628625	7186	7	7A
0005432628621	7186	8	18A
0005432628623	7186	9	18B
0005432628630	7186	10	20B
0005432628626	7186	11	20D
0005432628618	7186	12	21A
0005432628629	7186	13	22D
0005432628627	7186	14	23B
0005435225466	28099	1	1C
0005435225465	28099	2	1B
0005435225460	28099	3	3C
0005435225464	28099	4	3D
0005435225462	28099	5	5A
0005435225463	28099	6	5D
0005435225459	28099	7	20D
0005435225461	28099	8	23A
0005435959992	8746	1	4A
0005435959991	8746	2	4B
0005435959993	8746	3	4D
0005435959990	8746	4	5A
0005434267891	15265	1	1C
0005434267892	15265	2	4C
0005434267893	15265	3	6D
0005432692589	1194	1	1C
0005432674897	1194	2	1D
0005432692567	1194	3	3A
0005432674899	1194	4	3D
0005432692570	1194	5	3C
0005432692566	1194	6	4D
0005432674895	1194	7	4C
0005432677508	1194	8	4F
0005432692575	1194	9	5A
0005432674901	1194	10	6D
0005432692584	1194	11	6B
0005432692586	1194	12	6E
0005432692559	1194	13	7C
0005432692563	1194	14	7B
0005432692569	1194	15	7D
0005432692574	1194	16	8C
0005432692581	1194	17	8F
0005432692585	1194	18	9B
0005432692576	1194	19	9A
0005432677507	1194	20	9D
0005432677510	1194	21	10C
0005432692587	1194	22	10E
0005432692571	1194	23	10D
0005432692577	1194	24	11A
0005432674908	1194	25	11C
0005432677509	1194	26	11F
0005432692578	1194	27	12A
0005432674894	1194	28	12D
0005432674906	1194	29	12C
0005432692561	1194	30	12F
0005432692560	1194	31	13A
0005432674902	1194	32	13C
0005432692588	1194	33	14B
0005432674893	1194	34	14E
0005432674898	1194	35	14C
0005432692568	1194	36	15B
0005432674903	1194	37	15A
0005432674905	1194	38	15C
0005432692582	1194	39	15E
0005432674907	1194	40	15F
0005432692579	1194	41	16C
0005432692564	1194	42	16E
0005432674900	1194	43	16D
0005432692562	1194	44	17A
0005432692573	1194	45	16F
0005432692565	1194	46	19A
0005432674904	1194	47	19C
0005432692572	1194	48	19D
0005432692583	1194	49	21C
0005432692580	1194	50	21E
0005432674896	1194	51	21F
0005432873186	17508	1	1C
0005432873183	17508	2	1A
0005432873184	17508	3	4D
0005432873181	17508	4	11C
0005432873182	17508	5	12E
0005432873185	17508	6	13C
0005432873180	17508	7	15C
0005434434954	1140	1	2C
0005434434951	1140	2	3B
0005434434942	1140	3	3C
0005434434943	1140	4	4C
0005434434945	1140	5	5A
0005434434944	1140	6	5B
0005434434949	1140	7	5C
0005434434953	1140	8	7A
0005434434950	1140	9	7D
0005434434952	1140	10	18C
0005434434955	1140	11	18D
0005434434948	1140	12	19D
0005434434946	1140	13	21A
0005434434947	1140	14	21B
0005434434941	1140	15	21D
0005433156621	17317	1	1B
0005433156618	17317	2	4D
0005433156613	17317	3	6D
0005433156620	17317	4	7C
0005433156614	17317	5	18B
0005433156617	17317	6	19A
0005433156616	17317	7	20A
0005433156619	17317	8	20D
0005433156615	17317	9	21D
0005435086719	4079	1	5B
0005435086717	4079	2	5C
0005435086720	4079	3	6A
0005435086721	4079	4	7B
0005435086716	4079	5	20B
0005435086718	4079	6	20C
0005435086722	4079	7	22B
0005435928071	24401	1	3B
0005435928068	24401	2	5A
0005435928069	24401	3	21B
0005435928070	24401	4	23A
0005435706133	2450	1	1D
0005435706113	2450	2	1F
0005435706132	2450	3	2C
0005435706100	2450	4	3C
0005435706135	2450	5	4A
0005435706114	2450	6	4C
0005435706122	2450	7	4E
0005435706112	2450	8	5A
0005435706127	2450	9	5C
0005435706108	2450	10	5F
0005435706105	2450	11	6A
0005435706118	2450	12	6D
0005435706134	2450	13	6F
0005435706125	2450	14	7A
0005435706110	2450	15	7C
0005435706121	2450	16	7D
0005435706144	2450	17	7E
0005435706129	2450	18	7F
0005435706119	2450	19	8A
0005435706103	2450	20	8D
0005435706120	2450	21	8F
0005435706101	2450	22	9C
0005435706141	2450	23	9D
0005435706130	2450	24	10A
0005435706097	2450	25	10C
0005435706139	2450	26	10D
0005435706143	2450	27	10E
0005435706138	2450	28	10F
0005435706106	2450	29	11A
0005435706126	2450	30	11D
0005435706136	2450	31	11E
0005435706109	2450	32	11F
0005435706142	2450	33	12A
0005435706131	2450	34	12F
0005435706140	2450	35	13A
0005435706123	2450	36	13E
0005435706124	2450	37	13F
0005435706107	2450	38	14E
0005435706096	2450	39	15C
0005435706128	2450	40	15D
0005435706115	2450	41	16C
0005435706099	2450	42	16F
0005435706117	2450	43	17C
0005435706116	2450	44	17D
0005435706098	2450	45	18A
0005435706095	2450	46	18C
0005435706111	2450	47	19E
0005435706102	2450	48	20A
0005435706104	2450	49	20D
0005435706137	2450	50	20E
0005433373382	27019	1	1C
0005433373397	27019	2	2C
0005433373395	27019	3	2D
0005433373392	27019	4	3A
0005433373375	27019	5	4C
0005433373391	27019	6	4F
0005433373378	27019	7	5C
0005433373377	27019	8	5F
0005433373389	27019	9	6C
0005433373374	27019	10	6F
0005433373379	27019	11	7C
0005433373399	27019	12	7E
0005433373402	27019	13	9A
0005433373400	27019	14	9E
0005433373381	27019	15	10A
0005433373380	27019	16	11C
0005433373387	27019	17	11D
0005433373376	27019	18	11F
0005433373394	27019	19	12C
0005433373388	27019	20	12E
0005433373385	27019	21	13A
0005433373398	27019	22	14A
0005433373386	27019	23	17C
0005433373393	27019	24	17D
0005433373384	27019	25	17F
0005433373401	27019	26	18F
0005433373383	27019	27	19F
0005433373396	27019	28	20D
0005433373390	27019	29	20E
0005434625813	4843	1	1A
0005434625821	4843	2	4C
0005434625815	4843	3	5D
0005434625818	4843	4	6D
0005434625819	4843	5	9A
0005434625814	4843	6	10A
0005434625822	4843	7	17C
0005434625817	4843	8	18E
0005434625820	4843	9	19C
0005434625816	4843	10	20D
0005435907430	32899	1	4C
0005435907429	32899	2	11E
0005435907431	32899	3	15E
0005435907428	32899	4	15F
0005435907426	32899	5	16A
0005435907427	32899	6	17D
0005432195660	13756	1	2D
0005432195661	13756	2	3B
0005435937326	13756	3	4D
0005435937323	13756	4	5C
0005435937325	13756	5	6C
0005435937319	13756	6	18B
0005435937322	13756	7	19B
0005435937321	13756	8	20C
0005435937320	13756	9	21B
0005435937324	13756	10	22A
0005435784780	27426	1	1A
0005435784789	27426	2	1B
0005432190566	27426	3	1C
0005435784776	27426	4	1D
0005435784792	27426	5	2A
0005435787320	27426	6	2B
0005435784794	27426	7	2C
0005435784796	27426	8	2D
0005435784790	27426	9	3C
0005435784768	27426	10	4A
0005435784765	27426	11	4B
0005435784774	27426	12	4C
0005435784797	27426	13	4D
0005435784766	27426	14	5B
0005435784775	27426	15	5C
0005435784798	27426	16	5D
0005432190567	27426	17	6A
0005435784767	27426	18	6B
0005435784793	27426	19	6C
0005435784784	27426	20	7A
0005432190565	27426	21	18A
0005435784779	27426	22	18B
0005435784785	27426	23	18C
0005435787321	27426	24	18D
0005435784783	27426	25	19B
0005435784791	27426	26	19C
0005435784772	27426	27	19D
0005435784769	27426	28	20B
0005435784788	27426	29	20C
0005435784764	27426	30	20D
0005435784786	27426	31	21A
0005435784787	27426	32	21B
0005435784777	27426	33	21C
0005435784781	27426	34	21D
0005435784795	27426	35	22A
0005435784773	27426	36	22B
0005435784782	27426	37	22C
0005435784778	27426	38	22D
0005435784771	27426	39	23A
0005435784770	27426	40	23B
0005432058323	20258	1	1F
0005435310876	20258	2	3F
0005435310890	20258	3	5A
0005432058322	20258	4	5D
0005435310883	20258	5	5E
0005435310893	20258	6	6A
0005435310882	20258	7	6D
0005435310879	20258	8	6F
0005432058320	20258	9	9C
0005435310888	20258	10	9F
0005435310881	20258	11	10C
0005435310880	20258	12	12C
0005432058321	20258	13	12D
0005435310894	20258	14	12E
0005435310878	20258	15	13C
0005435310885	20258	16	13F
0005435310877	20258	17	14C
0005435310884	20258	18	14D
0005432058324	20258	19	14F
0005435310887	20258	20	17A
0005435310891	20258	21	19C
0005435310892	20258	22	20D
0005435310886	20258	23	20E
0005435310889	20258	24	20F
0005434406774	26961	1	1A
0005434406769	26961	2	1C
0005434406770	26961	3	1D
0005434406790	26961	4	2A
0005432153832	26961	5	2F
0005434406829	26961	6	3A
0005434406809	26961	7	3C
0005434406824	26961	8	3F
0005434406784	26961	9	4A
0005434406817	26961	10	4C
0005434406772	26961	11	4D
0005434406810	26961	12	4E
0005434406822	26961	13	4F
0005434406777	26961	14	5C
0005432153831	26961	15	5D
0005434406799	26961	16	5E
0005434406807	26961	17	5F
0005434406825	26961	18	6A
0005434406785	26961	19	6C
0005434406818	26961	20	6D
0005434406828	26961	21	6E
0005434406773	26961	22	6F
0005434406795	26961	23	7A
0005434406797	26961	24	7C
0005434406826	26961	25	7E
0005434406811	26961	26	7F
0005434406793	26961	27	8A
0005434406796	26961	28	8C
0005434406791	26961	29	8F
0005434406804	26961	30	9C
0005434406806	26961	31	9D
0005434406765	26961	32	9E
0005434406812	26961	33	10A
0005434406801	26961	34	10C
0005434406768	26961	35	10D
0005434406767	26961	36	10E
0005434406814	26961	37	10F
0005434406775	26961	38	11A
0005434406823	26961	39	11C
0005434406808	26961	40	11D
0005432153833	26961	41	11E
0005434406815	26961	42	12A
0005434406800	26961	43	12E
0005434406802	26961	44	12F
0005434406782	26961	45	13A
0005434406794	26961	46	13D
0005434406827	26961	47	13E
0005434406787	26961	48	14A
0005434406778	26961	49	14C
0005434406803	26961	50	14E
0005434406821	26961	51	14F
0005434406789	26961	52	15A
0005434406816	26961	53	15E
0005434406780	26961	54	15F
0005434406820	26961	55	16F
0005434406792	26961	56	17A
0005432153828	26961	57	17C
0005434406781	26961	58	17D
0005434406771	26961	59	17F
0005434406813	26961	60	18A
0005434406805	26961	61	18C
0005434406819	26961	62	18D
0005434406788	26961	63	18F
0005434406786	26961	64	19A
0005434406783	26961	65	19C
0005432153829	26961	66	19D
0005434406766	26961	67	19E
0005432153830	26961	68	20A
0005434406779	26961	69	20D
0005434406776	26961	70	20E
0005434406798	26961	71	20F
0005434319179	5674	1	1D
0005434319177	5674	2	2C
0005434319171	5674	3	4A
0005434319173	5674	4	4D
0005434319169	5674	5	5A
0005434319183	5674	6	5F
0005434311187	5674	7	6D
0005432109661	5674	8	8C
0005434319172	5674	9	9C
0005434319170	5674	10	9D
0005434319182	5674	11	9E
0005434319180	5674	12	10A
0005434319178	5674	13	11A
0005434319167	5674	14	11D
0005434311185	5674	15	12E
0005434319166	5674	16	13E
0005434319164	5674	17	14C
0005434311186	5674	18	14D
0005434319176	5674	19	14F
0005432109660	5674	20	15C
0005434319168	5674	21	16F
0005434319185	5674	22	17D
0005434319165	5674	23	17E
0005434319181	5674	24	18A
0005434319175	5674	25	18E
0005434319174	5674	26	19C
0005434319184	5674	27	19E
0005433123623	15701	1	1D
0005433123624	15701	2	2A
0005433123613	15701	3	3C
0005433123629	15701	4	4A
0005433123619	15701	5	5E
0005433123626	15701	6	6A
0005433123611	15701	7	6D
0005433123614	15701	8	6F
0005433123616	15701	9	7D
0005433123618	15701	10	9D
0005433123627	15701	11	9E
0005433123617	15701	12	10F
0005433123633	15701	13	11D
0005433123622	15701	14	11E
0005433123620	15701	15	13C
0005433123615	15701	16	14E
0005433123632	15701	17	15D
0005433123631	15701	18	18A
0005433123625	15701	19	17F
0005433123612	15701	20	18D
0005433123621	15701	21	19D
0005433123628	15701	22	20D
0005433123630	15701	23	20F
0005435220289	31757	1	1A
0005435219167	31757	2	2B
0005435220288	31757	3	3C
0005435219169	31757	4	5A
0005435219170	31757	5	5B
0005435220287	31757	6	5D
0005435220488	31757	7	18A
0005435219166	31757	8	18B
0005435220290	31757	9	20B
0005435220286	31757	10	20C
0005435219168	31757	11	20D
0005435220285	31757	12	22B
0005434484250	8994	1	2A
0005434484246	8994	2	3C
0005434484247	8994	3	4A
0005434484248	8994	4	19C
0005434484245	8994	5	20D
0005434484249	8994	6	22A
0005434484251	8994	7	22D
0005434189088	16641	1	5C
0005434189091	16641	2	7A
0005434189092	16641	3	7C
0005434189087	16641	4	18A
0005434189089	16641	5	19A
0005434189090	16641	6	21B
0005433123624	7706	1	1A
0005433123617	7706	2	1F
0005433123611	7706	3	2A
0005433123632	7706	4	2F
0005433123620	7706	5	3C
0005433123623	7706	6	4C
0005433123627	7706	7	6A
0005433123625	7706	8	7A
0005433123612	7706	9	8F
0005433123622	7706	10	12D
0005433123618	7706	11	13C
0005433123629	7706	12	13E
0005433123615	7706	13	14E
0005433123630	7706	14	15C
0005433123621	7706	15	15E
0005433123619	7706	16	17C
0005433123633	7706	17	18C
0005433123614	7706	18	18D
0005433123631	7706	19	18E
0005433123616	7706	20	19A
0005433123628	7706	21	19C
0005433123626	7706	22	19D
0005433123613	7706	23	20F
0005432692613	7705	1	1A
0005432692616	7705	2	1C
0005433449641	7705	3	1D
0005432692599	7705	4	1F
0005433449646	7705	5	2A
0005432692592	7705	6	2C
0005433449628	7705	7	2D
0005432720502	7705	8	3A
0005432071528	7705	9	3C
0005432692602	7705	10	3D
0005432071530	7705	11	3F
0005433449636	7705	12	4A
0005432692620	7705	13	4C
0005432692617	7705	14	4D
0005432720491	7705	15	4F
0005432720497	7705	16	5A
0005432720500	7705	17	5D
0005432720492	7705	18	5E
0005432692612	7705	19	5F
0005432720485	7705	20	6A
0005433449645	7705	21	6C
0005433449640	7705	22	6E
0005432692615	7705	23	6F
0005432720493	7705	24	7A
0005432720508	7705	25	7C
0005432720496	7705	26	7D
0005432720509	7705	27	7E
0005432720489	7705	28	7F
0005432720486	7705	29	8C
0005432720488	7705	30	8F
0005432720498	7705	31	9C
0005432720494	7705	32	9D
0005432720504	7705	33	9E
0005432692605	7705	34	9F
0005432692609	7705	35	10A
0005432720501	7705	36	10C
0005433449633	7705	37	10D
0005432692595	7705	38	10E
0005433449644	7705	39	11C
0005433449631	7705	40	11D
0005432692600	7705	41	11E
0005432692598	7705	42	11F
0005432720487	7705	43	12A
0005432692596	7705	44	12C
0005432692606	7705	45	12D
0005433449635	7705	46	12E
0005432692594	7705	47	12F
0005432692590	7705	48	13A
0005433449629	7705	49	13C
0005433449639	7705	50	13E
0005432692610	7705	51	13F
0005433449637	7705	52	14A
0005433449632	7705	53	14C
0005433449643	7705	54	14D
0005432692593	7705	55	14E
0005433449642	7705	56	14F
0005432692597	7705	57	15A
0005432720506	7705	58	15C
0005432692608	7705	59	15D
0005433449647	7705	60	15E
0005433449634	7705	61	15F
0005432692601	7705	62	16A
0005432720495	7705	63	16C
0005433449638	7705	64	16D
0005432071529	7705	65	16E
0005432720483	7705	66	16F
0005433449648	7705	67	17A
0005432720499	7705	68	17C
0005432720507	7705	69	17D
0005432692604	7705	70	17E
0005432692619	7705	71	17F
0005432692607	7705	72	18A
0005432692621	7705	73	18C
0005432692591	7705	74	18D
0005433449649	7705	75	18F
0005432692611	7705	76	18E
0005432071527	7705	77	19A
0005432720490	7705	78	19C
0005432720484	7705	79	19E
0005432692614	7705	80	19F
0005433449630	7705	81	20A
0005432692618	7705	82	20C
0005432720503	7705	83	20D
0005432692603	7705	84	20E
0005432720505	7705	85	20F
0005433722118	30434	1	5D
0005433722120	30434	2	9F
0005433722119	30434	3	11A
0005434586218	1365	1	1D
0005434586233	1365	2	2A
0005434586222	1365	3	2F
0005434514927	1365	4	3A
0005434586228	1365	5	3C
0005434513539	1365	6	3D
0005434586234	1365	7	3F
0005433524874	1365	8	4A
0005434586211	1365	9	4C
0005434514926	1365	10	4D
0005433524870	1365	11	4F
0005433724736	1365	12	5C
0005434586223	1365	13	5D
0005433524876	1365	14	5E
0005434586225	1365	15	5F
0005434586217	1365	16	6C
0005434586216	1365	17	6D
0005433524878	1365	18	6E
0005434586229	1365	19	7A
0005434586232	1365	20	7D
0005433524879	1365	21	7F
0005433724734	1365	22	8A
0005434586210	1365	23	8C
0005434514928	1365	24	8E
0005434586209	1365	25	9D
0005433724735	1365	26	9E
0005434586213	1365	27	9F
0005433524875	1365	28	10C
0005433524880	1365	29	10D
0005434586221	1365	30	10F
0005434586230	1365	31	11D
0005433524877	1365	32	11E
0005433724738	1365	33	12E
0005434586219	1365	34	12F
0005434586231	1365	35	13E
0005434586215	1365	36	14C
0005434586227	1365	37	14E
0005432270960	1365	38	14F
0005433724733	1365	39	15C
0005433724737	1365	40	15E
0005434586226	1365	41	16A
0005433524873	1365	42	16C
0005434586212	1365	43	17C
0005433524872	1365	44	17E
0005434513538	1365	45	17F
0005434586224	1365	46	18A
0005432270961	1365	47	18E
0005434586214	1365	48	19C
0005434513540	1365	49	19D
0005434586235	1365	50	19E
0005433524871	1365	51	20A
0005434586220	1365	52	20C
0005433192844	18521	1	1A
0005433192848	18521	2	2C
0005433192847	18521	3	3C
0005433192842	18521	4	4C
0005432927890	18521	5	4F
0005432927892	18521	6	5F
0005432927893	18521	7	6F
0005433192845	18521	8	8F
0005432968804	18521	9	9C
0005433192846	18521	10	10A
0005432968805	18521	11	12A
0005433192840	18521	12	13D
0005432927891	18521	13	13F
0005433192839	18521	14	15A
0005432927896	18521	15	16E
0005433192843	18521	16	17C
0005433192841	18521	17	17D
0005432927895	18521	18	18E
0005433192838	18521	19	19C
0005432927894	18521	20	19E
0005433192849	18521	21	20A
0005434142549	11424	1	1A
0005434343626	11424	2	1B
0005434343628	11424	3	1C
0005434343624	11424	4	1D
0005434142551	11424	5	2A
0005434343640	11424	6	2B
0005434343647	11424	7	2C
0005434343648	11424	8	3A
0005434343632	11424	9	3B
0005434343625	11424	10	3D
0005434343631	11424	11	4A
0005434343636	11424	12	4C
0005434343637	11424	13	4D
0005434343634	11424	14	5B
0005434343650	11424	15	5C
0005434142550	11424	16	5D
0005434343629	11424	17	6B
0005434343646	11424	18	6D
0005434343649	11424	19	7A
0005434142553	11424	20	7B
0005434343633	11424	21	7C
0005434343645	11424	22	18A
0005434142548	11424	23	18B
0005434343642	11424	24	18C
0005434343630	11424	25	18D
0005434343641	11424	26	19A
0005434343618	11424	27	19C
0005434343620	11424	28	19D
0005434343619	11424	29	20A
0005434343643	11424	30	20B
0005434343622	11424	31	20C
0005434343638	11424	32	20D
0005434343617	11424	33	21A
0005434343635	11424	34	21C
0005434343639	11424	35	21D
0005434142552	11424	36	22A
0005434343627	11424	37	22B
0005434343623	11424	38	22C
0005434343621	11424	39	22D
0005434343644	11424	40	23A
0005435304102	29759	1	2B
0005435304990	29759	2	3B
0005435304101	29759	3	6A
0005435304099	29759	4	6C
0005435304991	29759	5	7A
0005435304994	29759	6	18B
0005435304103	29759	7	19B
0005435304992	29759	8	20B
0005435304100	29759	9	20D
0005435304993	29759	10	21C
0005435824221	1253	1	2C
0005435824212	1253	2	4F
0005435824209	1253	3	5D
0005435824216	1253	4	5A
0005435824219	1253	5	6B
0005435824211	1253	6	6D
0005435824217	1253	7	7B
0005435824207	1253	8	7D
0005435824228	1253	9	8B
0005435824206	1253	10	10D
0005435824220	1253	11	11B
0005432284514	1253	12	11D
0005435824231	1253	13	11F
0005435824224	1253	14	12D
0005435824227	1253	15	14C
0005435824225	1253	16	14A
0005435824223	1253	17	14E
0005435824229	1253	18	16A
0005435824214	1253	19	16B
0005435824230	1253	20	17E
0005432284513	1253	21	17F
0005435824222	1253	22	18C
0005435824215	1253	23	18D
0005435824210	1253	24	19A
0005435824226	1253	25	19E
0005435824208	1253	26	20B
0005435824213	1253	27	20E
0005435824218	1253	28	21B
0005435824232	1253	29	21E
0005433415426	17975	1	1D
0005433415420	17975	2	5A
0005433415423	17975	3	6B
0005433415419	17975	4	6E
0005433415412	17975	5	8C
0005433415415	17975	6	9B
0005433415418	17975	7	10C
0005433415411	17975	8	10D
0005433415422	17975	9	12A
0005433415414	17975	10	14D
0005433415413	17975	11	15B
0005433415416	17975	12	16A
0005433415424	17975	13	18B
0005433415421	17975	14	19A
0005433415425	17975	15	19D
0005433415417	17975	16	21A
0005432782957	5660	1	1A
0005432782958	5660	2	1C
0005432782953	5660	3	2D
0005432782984	5660	4	2F
0005432782987	5660	5	3A
0005432782962	5660	6	3C
0005432782955	5660	7	4A
0005432782968	5660	8	4E
0005432783000	5660	9	4F
0005432783002	5660	10	5A
0005432143936	5660	11	5C
0005432782981	5660	12	5E
0005432782982	5660	13	5F
0005432782977	5660	14	6A
0005432782994	5660	15	6C
0005432782961	5660	16	6E
0005432782989	5660	17	6F
0005432782965	5660	18	7D
0005432782949	5660	19	8A
0005432782990	5660	20	8C
0005432782998	5660	21	8D
0005432782979	5660	22	8E
0005432782975	5660	23	8F
0005432782997	5660	24	9A
0005432782950	5660	25	9C
0005432782964	5660	26	9D
0005432782996	5660	27	9E
0005432143937	5660	28	9F
0005432782983	5660	29	10A
0005432782978	5660	30	10E
0005432782985	5660	31	10F
0005432782952	5660	32	11C
0005432782993	5660	33	11D
0005432782992	5660	34	12E
0005432782972	5660	35	12F
0005432782956	5660	36	13A
0005432782969	5660	37	13C
0005432782970	5660	38	13E
0005432782967	5660	39	14D
0005432782986	5660	40	14F
0005432782991	5660	41	15D
0005432782951	5660	42	16D
0005432782976	5660	43	16E
0005432782973	5660	44	16F
0005432782959	5660	45	17A
0005432782995	5660	46	17C
0005432782974	5660	47	17D
0005432782960	5660	48	17E
0005432782966	5660	49	18A
0005432782963	5660	50	18E
0005432782954	5660	51	19A
0005432143938	5660	52	19C
0005432782999	5660	53	19D
0005432782980	5660	54	19E
0005432782988	5660	55	19F
0005432783001	5660	56	20A
0005432782971	5660	57	20D
0005435242429	15358	1	1D
0005435476654	15358	2	1F
0005435242421	15358	3	2A
0005435242424	15358	4	2F
0005435242426	15358	5	3A
0005435242419	15358	6	3F
0005435242417	15358	7	4C
0005435242438	15358	8	4E
0005435242420	15358	9	4F
0005435242442	15358	10	5C
0005435242436	15358	11	6F
0005435242425	15358	12	7A
0005435242435	15358	13	7F
0005435242432	15358	14	8A
0005435242430	15358	15	8C
0005435242439	15358	16	8D
0005435476653	15358	17	8E
0005435242416	15358	18	9F
0005435476652	15358	19	10D
0005435242440	15358	20	11A
0005435242434	15358	21	12A
0005435242431	15358	22	12E
0005435242427	15358	23	13D
0005435242441	15358	24	13E
0005435242422	15358	25	14C
0005435242437	15358	26	14E
0005435242423	15358	27	15D
0005435242428	15358	28	17D
0005435242418	15358	29	18F
0005435242433	15358	30	19C
0005432848089	4372	1	1C
0005432848094	4372	2	2D
0005432848086	4372	3	4A
0005432848099	4372	4	4D
0005432848092	4372	5	5A
0005434462756	4372	6	5C
0005432848098	4372	7	6B
0005434462757	4372	8	7A
0005434463897	4372	9	18A
0005432848097	4372	10	18C
0005432848093	4372	11	19B
0005432848091	4372	12	20A
0005434463896	4372	13	20C
0005434462758	4372	14	20D
0005432848090	4372	15	21A
0005432848087	4372	16	21B
0005432848095	4372	17	21D
0005432848096	4372	18	22A
0005432848085	4372	19	23A
0005432848088	4372	20	23B
0005435850773	28836	1	1B
0005435850774	28836	2	3A
0005435850775	28836	3	4B
0005435850768	28836	4	5A
0005435850772	28836	5	5D
0005435850771	28836	6	6D
0005435850770	28836	7	7B
0005435850769	28836	8	19A
0005435850767	28836	9	21C
0005434925336	6349	1	1A
0005434925321	6349	2	1C
0005433496502	6349	3	1D
0005432075178	6349	4	2A
0005434925337	6349	5	2D
0005433496504	6349	6	2F
0005433496507	6349	7	3A
0005433496490	6349	8	3C
0005434925327	6349	9	3F
0005434443467	6349	10	4A
0005434925332	6349	11	4C
0005434925307	6349	12	4D
0005434443459	6349	13	4E
0005434443456	6349	14	4F
0005433496508	6349	15	5A
0005434925308	6349	16	5C
0005434443465	6349	17	5D
0005434443464	6349	18	5E
0005434925339	6349	19	5F
0005433496510	6349	20	6A
0005434925326	6349	21	6C
0005433496499	6349	22	6D
0005433496513	6349	23	6E
0005432075177	6349	24	6F
0005433496511	6349	25	7A
0005434925323	6349	26	7C
0005433496494	6349	27	7D
0005434925329	6349	28	7E
0005434925311	6349	29	7F
0005434925318	6349	30	8C
0005434925306	6349	31	8D
0005434925333	6349	32	8E
0005434925317	6349	33	8F
0005433496483	6349	34	9A
0005434443458	6349	35	9C
0005434443466	6349	36	9D
0005433496500	6349	37	9E
0005434443470	6349	38	9F
0005434925319	6349	39	10A
0005433496489	6349	40	10D
0005433496496	6349	41	10E
0005433496512	6349	42	10F
0005434925310	6349	43	11A
0005433496492	6349	44	11C
0005434443472	6349	45	11D
0005434925320	6349	46	11E
0005432075176	6349	47	11F
0005434925325	6349	48	12A
0005433496488	6349	49	12C
0005434443463	6349	50	12D
0005434925342	6349	51	12E
0005434443460	6349	52	12F
0005433496486	6349	53	13A
0005432075179	6349	54	13E
0005433496506	6349	55	13F
0005434443471	6349	56	14A
0005434925314	6349	57	14C
0005434443462	6349	58	14D
0005433496509	6349	59	14E
0005433496485	6349	60	14F
0005433496498	6349	61	15A
0005434925312	6349	62	15C
0005434925341	6349	63	15D
0005434925338	6349	64	15E
0005434925315	6349	65	15F
0005434925340	6349	66	16A
0005434925330	6349	67	16C
0005434925313	6349	68	16D
0005434925334	6349	69	16E
0005433496487	6349	70	16F
0005433496505	6349	71	17A
0005434925335	6349	72	17C
0005433496484	6349	73	17D
0005433496493	6349	74	17E
0005433496495	6349	75	17F
0005434925309	6349	76	18A
0005434925324	6349	77	18C
0005433496491	6349	78	18D
0005434925328	6349	79	18E
0005434925316	6349	80	18F
0005433496501	6349	81	19A
0005434443461	6349	82	19C
0005434925322	6349	83	19D
0005433496497	6349	84	19E
0005434443468	6349	85	19F
0005433496503	6349	86	20A
0005434443457	6349	87	20C
0005434925331	6349	88	20D
0005434443469	6349	89	20E
0005433496443	20394	1	12D
0005433496444	20394	2	18F
0005435242445	12174	1	1A
0005435242453	12174	2	1F
0005435242459	12174	3	2D
0005435242467	12174	4	4A
0005435242456	12174	5	6C
0005435242469	12174	6	7C
0005435242461	12174	7	8A
0005435242451	12174	8	8C
0005435242444	12174	9	8D
0005435242460	12174	10	8E
0005435242455	12174	11	9F
0005435242454	12174	12	10E
0005435242466	12174	13	11C
0005435242463	12174	14	12E
0005435242443	12174	15	13F
0005435242449	12174	16	14D
0005435242470	12174	17	14F
0005435242465	12174	18	15C
0005435242446	12174	19	15D
0005435242457	12174	20	16C
0005435242448	12174	21	17A
0005435242452	12174	22	17C
0005435242447	12174	23	18F
0005435242464	12174	24	19A
0005435242450	12174	25	19E
0005435242462	12174	26	20A
0005435242468	12174	27	20C
0005435242458	12174	28	20D
0005432782926	15400	1	2D
0005432782903	15400	2	2F
0005432782915	15400	3	3A
0005432782897	15400	4	3C
0005432782895	15400	5	3F
0005432782904	15400	6	4A
0005432782913	15400	7	4C
0005432782916	15400	8	4D
0005432782932	15400	9	5A
0005432782896	15400	10	5C
0005432782914	15400	11	5F
0005432782930	15400	12	6A
0005432782921	15400	13	6D
0005432782948	15400	14	6E
0005432782901	15400	15	6F
0005432782900	15400	16	7A
0005432782927	15400	17	7C
0005432782905	15400	18	7F
0005432782909	15400	19	8E
0005432782893	15400	20	8F
0005432782943	15400	21	9C
0005432782935	15400	22	9D
0005432782923	15400	23	9E
0005432782941	15400	24	9F
0005432782939	15400	25	10D
0005432782931	15400	26	10E
0005432782918	15400	27	10F
0005432782912	15400	28	11A
0005432782908	15400	29	11D
0005432782947	15400	30	11E
0005432782911	15400	31	12A
0005432782942	15400	32	12C
0005432782899	15400	33	12E
0005432782928	15400	34	13A
0005432782938	15400	35	13C
0005432782945	15400	36	13D
0005432782940	15400	37	14A
0005432782898	15400	38	14F
0005432782946	15400	39	15A
0005432782920	15400	40	15C
0005432782907	15400	41	15D
0005432782933	15400	42	15E
0005432782906	15400	43	15F
0005432782919	15400	44	16A
0005432782894	15400	45	16F
0005432782937	15400	46	17A
0005432782917	15400	47	17D
0005432782929	15400	48	18C
0005432782922	15400	49	18F
0005432782925	15400	50	19A
0005432782910	15400	51	19E
0005432782936	15400	52	19F
0005432782944	15400	53	20C
0005432782924	15400	54	20D
0005432782934	15400	55	20E
0005432782902	15400	56	20F
0005434876770	14596	1	1A
0005434876824	14596	2	1F
0005434876800	14596	3	1D
0005434876807	14596	4	2A
0005434876777	14596	5	2F
0005434876830	14596	6	2D
0005434876789	14596	7	3A
0005434876813	14596	8	3D
0005434876811	14596	9	3C
0005434876835	14596	10	4A
0005434876787	14596	11	3F
0005434876804	14596	12	4D
0005434876771	14596	13	4C
0005434876797	14596	14	5A
0005434876844	14596	15	4F
0005434876776	14596	16	5C
0005434876815	14596	17	5D
0005434876798	14596	18	6B
0005434876758	14596	19	6A
0005434876793	14596	20	5F
0005434876790	14596	21	6D
0005434876832	14596	22	6F
0005434876806	14596	23	6E
0005434876827	14596	24	7A
0005434876750	14596	25	7C
0005434876751	14596	26	7B
0005434876765	14596	27	7E
0005434876836	14596	28	7D
0005434876839	14596	29	7F
0005434876753	14596	30	8B
0005434876846	14596	31	8E
0005434876773	14596	32	8C
0005434876814	14596	33	9A
0005434876761	14596	34	9C
0005434876796	14596	35	9B
0005434876818	14596	36	9E
0005434876780	14596	37	9D
0005434876762	14596	38	10A
0005434876756	14596	39	10C
0005434876799	14596	40	10B
0005434876759	14596	41	10E
0005434876826	14596	42	10D
0005434876794	14596	43	11A
0005434876841	14596	44	10F
0005434876840	14596	45	11D
0005434876825	14596	46	11C
0005434876833	14596	47	11F
0005434876779	14596	48	11E
0005434876769	14596	49	12A
0005434876831	14596	50	12D
0005434876795	14596	51	12C
0005434876767	14596	52	12F
0005434876782	14596	53	12E
0005434876752	14596	54	13A
0005434876809	14596	55	13C
0005434876791	14596	56	13D
0005434876828	14596	57	14A
0005434876805	14596	58	13F
0005434758858	14596	59	14B
0005434876816	14596	60	14D
0005434876786	14596	61	14C
0005434876763	14596	62	14F
0005434876819	14596	63	14E
0005434876801	14596	64	15B
0005434876781	14596	65	15A
0005434876803	14596	66	15D
0005434876838	14596	67	15C
0005434876785	14596	68	15F
0005434876842	14596	69	15E
0005434876757	14596	70	16A
0005434876802	14596	71	16C
0005434876768	14596	72	16D
0005434876764	14596	73	16F
0005434876837	14596	74	17B
0005434876792	14596	75	17A
0005434876775	14596	76	17D
0005434876820	14596	77	17C
0005434876843	14596	78	17F
0005434876783	14596	79	17E
0005434876778	14596	80	18A
0005434876754	14596	81	18C
0005434876784	14596	82	18E
0005434876810	14596	83	18D
0005434876749	14596	84	19A
0005434876766	14596	85	18F
0005434758857	14596	86	19C
0005434876755	14596	87	19B
0005434876774	14596	88	19E
0005434876808	14596	89	19D
0005434876822	14596	90	19F
0005434876829	14596	91	20B
0005434876772	14596	92	20D
0005434876788	14596	93	20C
0005434876812	14596	94	20F
0005434876821	14596	95	20E
0005434876760	14596	96	21B
0005434876834	14596	97	21D
0005434876823	14596	98	21C
0005434876845	14596	99	21E
0005434876817	14596	100	21F
0005435659962	9233	1	1A
0005435659965	9233	2	4A
0005435659964	9233	3	4C
0005435659968	9233	4	6C
0005435659970	9233	5	6D
0005435659963	9233	6	7D
0005435659960	9233	7	18B
0005435659966	9233	8	20A
0005435659961	9233	9	20C
0005435659967	9233	10	21B
0005435659969	9233	11	21C
0005434251824	24661	1	1B
0005434251822	24661	2	1C
0005434251817	24661	3	1D
0005434251815	24661	4	3B
0005434251823	24661	5	3D
0005434251821	24661	6	18C
0005434251820	24661	7	19C
0005434251818	24661	8	20C
0005434251819	24661	9	21D
0005434251816	24661	10	23B
0005433679820	2767	1	1A
0005433679841	2767	2	1C
0005433679812	2767	3	1D
0005433679853	2767	4	2A
0005433679813	2767	5	2C
0005433679834	2767	6	3A
0005433679835	2767	7	2F
0005433679815	2767	8	3D
0005433679842	2767	9	4C
0005432222701	2767	10	4E
0005432222699	2767	11	4F
0005433679816	2767	12	5A
0005433679849	2767	13	5C
0005433679819	2767	14	5D
0005432222700	2767	15	5E
0005433679817	2767	16	6C
0005433679822	2767	17	8A
0005433679850	2767	18	8D
0005433679847	2767	19	8F
0005433679809	2767	20	9C
0005433679827	2767	21	9D
0005433679839	2767	22	9E
0005432222702	2767	23	10A
0005433679845	2767	24	10C
0005433679848	2767	25	10E
0005433679823	2767	26	10F
0005433679808	2767	27	11C
0005433679844	2767	28	11E
0005433679825	2767	29	11F
0005433679821	2767	30	12C
0005433684387	2767	31	12D
0005433679826	2767	32	12E
0005433679829	2767	33	12F
0005433679838	2767	34	13A
0005433679852	2767	35	13C
0005433679830	2767	36	13D
0005433679811	2767	37	13E
0005433679807	2767	38	14A
0005433679843	2767	39	14C
0005432222698	2767	40	14D
0005433679828	2767	41	15C
0005433684386	2767	42	15E
0005433679818	2767	43	15F
0005433679854	2767	44	17A
0005433679851	2767	45	17D
0005433679837	2767	46	17E
0005433684388	2767	47	17F
0005433679833	2767	48	18A
0005433679840	2767	49	18E
0005433679832	2767	50	19A
0005433679824	2767	51	19C
0005433679846	2767	52	19D
0005433679814	2767	53	19E
0005433679831	2767	54	19F
0005433679810	2767	55	20E
0005433679836	2767	56	20F
0005432966533	29178	1	2D
0005432966534	29178	2	3D
0005432966536	29178	3	3F
0005432966547	29178	4	4C
0005432966538	29178	5	4E
0005432966537	29178	6	5C
0005432966535	29178	7	5D
0005432005171	29178	8	5E
0005432966553	29178	9	6C
0005432966546	29178	10	6E
0005432966539	29178	11	6F
0005432966541	29178	12	7A
0005432966542	29178	13	8F
0005432005172	29178	14	10C
0005432966554	29178	15	10E
0005432966540	29178	16	10F
0005432005170	29178	17	11C
0005432005169	29178	18	12C
0005432966555	29178	19	12D
0005432966549	29178	20	12F
0005432966545	29178	21	13C
0005432966552	29178	22	13D
0005432966557	29178	23	14D
0005432966544	29178	24	14F
0005432966550	29178	25	15D
0005432966551	29178	26	16E
0005432966556	29178	27	17C
0005432966548	29178	28	19C
0005432966543	29178	29	19D
0005432966532	29178	30	19E
0005433633268	9276	1	1A
0005433613521	9276	2	1F
0005433577590	9276	3	2A
0005433613486	9276	4	2D
0005433613477	9276	5	2C
0005433633250	9276	6	2F
0005433613475	9276	7	3C
0005433577589	9276	8	3F
0005433633280	9276	9	3D
0005433613495	9276	10	4A
0005433613516	9276	11	4C
0005433613481	9276	12	5A
0005433613530	9276	13	5F
0005433633272	9276	14	5D
0005433633256	9276	15	6A
0005433577591	9276	16	6D
0005433633270	9276	17	6F
0005433613527	9276	18	7F
0005433613507	9276	19	8B
0005433613469	9276	20	8D
0005433613534	9276	21	8C
0005433633276	9276	22	8E
0005433577595	9276	23	8F
0005433633271	9276	24	9A
0005433613498	9276	25	9C
0005433613482	9276	26	9D
0005433613470	9276	27	9E
0005433633265	9276	28	10A
0005433633277	9276	29	10B
0005433613518	9276	30	10D
0005433613526	9276	31	10C
0005433613480	9276	32	10F
0005433633259	9276	33	10E
0005433613461	9276	34	11B
0005433633279	9276	35	11C
0005433613522	9276	36	11D
0005433613512	9276	37	11F
0005433633253	9276	38	11E
0005433613485	9276	39	12A
0005433613483	9276	40	12B
0005433577597	9276	41	12C
0005433613532	9276	42	12D
0005433633258	9276	43	12F
0005433633261	9276	44	12E
0005433613519	9276	45	13A
0005433577588	9276	46	13C
0005433613506	9276	47	13D
0005433633278	9276	48	13E
0005432756795	9276	49	14A
0005433633266	9276	50	13F
0005432756796	9276	51	14D
0005433633251	9276	52	14C
0005432755025	9276	53	14E
0005433633262	9276	54	14F
0005433633273	9276	55	15A
0005433633252	9276	56	15C
0005433633263	9276	57	15B
0005433613523	9276	58	15E
0005433633281	9276	59	16A
0005433577593	9276	60	15F
0005433633267	9276	61	16C
0005433613478	9276	62	16D
0005433613465	9276	63	17B
0005433613490	9276	64	17A
0005433613535	9276	65	17D
0005433577601	9276	66	17F
0005433613515	9276	67	17E
0005433633257	9276	68	18A
0005433613476	9276	69	18B
0005433613517	9276	70	18D
0005433633249	9276	71	18C
0005433613505	9276	72	18E
0005433613468	9276	73	19B
0005433613502	9276	74	19C
0005433613493	9276	75	19E
0005433613508	9276	76	20B
0005433613471	9276	77	20A
0005432145078	9276	78	20C
0005433613467	9276	79	20D
0005433613513	9276	80	20F
0005433613510	9276	81	21D
0005433613474	9276	82	21C
0005433633248	9276	83	21E
0005433613499	9276	84	21F
0005433613511	9276	85	22B
0005432756794	9276	86	22D
0005433613533	9276	87	22C
0005433613472	9276	88	22E
0005433633254	9276	89	23B
0005433633255	9276	90	23D
0005433613524	9276	91	23E
0005433613491	9276	92	24B
0005433577598	9276	93	24A
0005433613466	9276	94	24D
0005433633260	9276	95	24C
0005433577592	9276	96	24F
0005433613463	9276	97	24E
0005433613525	9276	98	25B
0005433577594	9276	99	25A
0005433613509	9276	100	25C
0005433613462	9276	101	25D
0005433613504	9276	102	25E
0005433613464	9276	103	26A
0005433577599	9276	104	25F
0005433613492	9276	105	26C
0005433613479	9276	106	26B
0005433633275	9276	107	26E
0005433613487	9276	108	26D
0005433633274	9276	109	27B
0005433613528	9276	110	27A
0005433613494	9276	111	27C
0005433613529	9276	112	27D
0005433613520	9276	113	27E
0005433577596	9276	114	28A
0005433633269	9276	115	27F
0005433633282	9276	116	28B
0005433613496	9276	117	28C
0005433613500	9276	118	28E
0005432755023	9276	119	28D
0005433577600	9276	120	28F
0005433613489	9276	121	29A
0005432755021	9276	122	29E
0005432755022	9276	123	29D
0005433633264	9276	124	30A
0005433613514	9276	125	30B
0005433613488	9276	126	30C
0005433613501	9276	127	30E
0005432755024	9276	128	30D
0005433613473	9276	129	30F
0005433613531	9276	130	31B
0005433577602	9276	131	31A
0005433613497	9276	132	31E
0005433613503	9276	133	31D
0005433613484	9276	134	31F
0005434163474	25237	1	3C
0005434163477	25237	2	5D
0005434273049	25237	3	8D
0005434163471	25237	4	9F
0005434163472	25237	5	10A
0005434273048	25237	6	12F
0005434163480	25237	7	13C
0005434163473	25237	8	13B
0005434272163	25237	9	16D
0005434163470	25237	10	17D
0005434163479	25237	11	21C
0005434272164	25237	12	25C
0005434163475	25237	13	27D
0005434163476	25237	14	30A
0005434163478	25237	15	31D
0005435986658	4205	1	1F
0005432184906	4205	2	1H
0005435986657	4205	3	3H
0005435986663	4205	4	9B
0005435986660	4205	5	18G
0005435986667	4205	6	23B
0005432184907	4205	7	23F
0005435986665	4205	8	24A
0005435986662	4205	9	24F
0005435986668	4205	10	25F
0005435986669	4205	11	28A
0005435986664	4205	12	29H
0005435986659	4205	13	33D
0005432184908	4205	14	36D
0005435986666	4205	15	36H
0005435986661	4205	16	38E
0005435947032	26564	1	1H
0005435947029	26564	2	4A
0005435947040	26564	3	4B
0005435947038	26564	4	12H
0005435947034	26564	5	15D
0005435947033	26564	6	17A
0005435856138	26564	7	19H
0005435947030	26564	8	23A
0005435947035	26564	9	22H
0005432571265	26564	10	28G
0005435856139	26564	11	28F
0005435947028	26564	12	29D
0005435947026	26564	13	30F
0005435947039	26564	14	30H
0005435947027	26564	15	31G
0005432571264	26564	16	33B
0005435947031	26564	17	33E
0005432571266	26564	18	35B
0005435856141	26564	19	35A
0005435947036	26564	20	36A
0005435947041	26564	21	37B
0005432571267	26564	22	37H
0005435856140	26564	23	39E
0005435947037	26564	24	39F
0005433568188	358	1	1A
0005433568187	358	2	1D
0005433568134	358	3	3F
0005433568126	358	4	4A
0005432238840	358	5	4F
0005433568165	358	6	4D
0005433568190	358	7	5A
0005433568173	358	8	5C
0005433568147	358	9	5D
0005433568135	358	10	6C
0005433568136	358	11	6F
0005433568144	358	12	6D
0005433568183	358	13	7D
0005433568129	358	14	8A
0005433568167	358	15	8B
0005433568162	358	16	8E
0005433568164	358	17	9D
0005433568139	358	18	9E
0005433568184	358	19	10A
0005433568149	358	20	10D
0005433568142	358	21	10C
0005433568163	358	22	10E
0005433568185	358	23	11B
0005433568157	358	24	11C
0005433568156	358	25	12D
0005433568125	358	26	13C
0005433568160	358	27	13D
0005433568170	358	28	13E
0005433568153	358	29	14C
0005433568189	358	30	14E
0005433568152	358	31	15A
0005433568151	358	32	15D
0005433568180	358	33	15E
0005433568186	358	34	16A
0005433568182	358	35	16D
0005433568140	358	36	16C
0005433568141	358	37	16E
0005433568169	358	38	16F
0005433568158	358	39	17A
0005433568178	358	40	17B
0005433568159	358	41	17D
0005433568150	358	42	18A
0005433568138	358	43	19B
0005433568176	358	44	20A
0005433568128	358	45	20C
0005433568191	358	46	21B
0005432238843	358	47	21C
0005433568168	358	48	21F
0005433568175	358	49	22E
0005433568143	358	50	22D
0005433568132	358	51	23B
0005433568181	358	52	23D
0005433568161	358	53	23F
0005433568145	358	54	24C
0005433568172	358	55	24E
0005433568127	358	56	25C
0005433568137	358	57	25F
0005433568179	358	58	25E
0005433568130	358	59	26A
0005433568154	358	60	26B
0005433568177	358	61	26D
0005432238845	358	62	27A
0005432238842	358	63	27D
0005433568166	358	64	27F
0005433568171	358	65	28B
0005433568131	358	66	29A
0005432238844	358	67	29E
0005433568146	358	68	29F
0005432238841	358	69	30B
0005433568155	358	70	30C
0005433568148	358	71	30E
0005433568124	358	72	30F
0005433568174	358	73	31B
0005433568133	358	74	31E
0005433074278	11570	1	1D
0005433074283	11570	2	2C
0005432947812	11570	3	3A
0005432947834	11570	4	2F
0005432947842	11570	5	4A
0005432947839	11570	6	4C
0005432192270	11570	7	5A
0005433074267	11570	8	4F
0005433074264	11570	9	5C
0005432947811	11570	10	6F
0005432947829	11570	11	7A
0005432947840	11570	12	7F
0005432947809	11570	13	7D
0005432947832	11570	14	8A
0005433131635	11570	15	8B
0005432192272	11570	16	8F
0005433074280	11570	17	9A
0005432947820	11570	18	9E
0005433134065	11570	19	10A
0005433134069	11570	20	10B
0005432947805	11570	21	10C
0005432947830	11570	22	10E
0005432947831	11570	23	10F
0005432947838	11570	24	11A
0005433074260	11570	25	11F
0005433074276	11570	26	12A
0005433074269	11570	27	12D
0005433074263	11570	28	13A
0005432947836	11570	29	12F
0005432947843	11570	30	13C
0005433074282	11570	31	13F
0005432947833	11570	32	13E
0005432947841	11570	33	14A
0005432947845	11570	34	14B
0005433074274	11570	35	14D
0005433131637	11570	36	14C
0005433074262	11570	37	14E
0005433074271	11570	38	14F
0005433074272	11570	39	15E
0005433131638	11570	40	16D
0005432947837	11570	41	16F
0005432947814	11570	42	17B
0005433131636	11570	43	19B
0005433074268	11570	44	19D
0005433074266	11570	45	20A
0005432947835	11570	46	20C
0005433134068	11570	47	20D
0005432947808	11570	48	21A
0005432947823	11570	49	20F
0005432947844	11570	50	21B
0005432947806	11570	51	21D
0005432947815	11570	52	21C
0005433074256	11570	53	22A
0005432947826	11570	54	21F
0005433134066	11570	55	22D
0005432947828	11570	56	22F
0005433074275	11570	57	23B
0005432947816	11570	58	23D
0005433074270	11570	59	23E
0005432947827	11570	60	24A
0005432192271	11570	61	24B
0005432947822	11570	62	24D
0005433074281	11570	63	24C
0005432947824	11570	64	25A
0005433074279	11570	65	25C
0005432947817	11570	66	25D
0005432947807	11570	67	26F
0005432947813	11570	68	26E
0005433074258	11570	69	27B
0005433074261	11570	70	27D
0005433074277	11570	71	28B
0005433131639	11570	72	28C
0005433134067	11570	73	28E
0005432947818	11570	74	28F
0005432947819	11570	75	29B
0005433074273	11570	76	29C
0005432947825	11570	77	29D
0005432947821	11570	78	29E
0005433074259	11570	79	30C
0005432947810	11570	80	30E
0005433074257	11570	81	30D
0005433074265	11570	82	30F
0005433074255	11570	83	31F
0005433817414	10009	1	1B
0005433817413	10009	2	5A
0005433817412	10009	3	5B
0005434732928	13932	1	2B
0005434732927	13932	2	4A
0005434732926	13932	3	5A
0005435981616	2324	1	1A
0005435981603	2324	2	1C
0005433753383	2324	3	1F
0005435981630	2324	4	1H
0005433753337	2324	5	1G
0005435981600	2324	6	2A
0005433753389	2324	7	2B
0005433753358	2324	8	2F
0005435981622	2324	9	2C
0005433753354	2324	10	2G
0005432300177	2324	11	3B
0005433753342	2324	12	3A
0005435981629	2324	13	3C
0005432655362	2324	14	3G
0005433753361	2324	15	3F
0005433753364	2324	16	3H
0005432225962	2324	17	4B
0005433753385	2324	18	4F
0005435981626	2324	19	4H
0005433753351	2324	20	5A
0005433753391	2324	21	5F
0005433753371	2324	22	5C
0005435981628	2324	23	5G
0005433753360	2324	24	5H
0005433753349	2324	25	9B
0005433753375	2324	26	9G
0005433753379	2324	27	9H
0005432655361	2324	28	11B
0005433764647	2324	29	11E
0005435981632	2324	30	11F
0005435981633	2324	31	11H
0005435981606	2324	32	12A
0005433753359	2324	33	12D
0005435981624	2324	34	12B
0005435981607	2324	35	12F
0005435981638	2324	36	13B
0005433753390	2324	37	13A
0005433753382	2324	38	13D
0005433753363	2324	39	13E
0005432300173	2324	40	13H
0005433753357	2324	41	14A
0005433753388	2324	42	14D
0005433753347	2324	43	14F
0005432225963	2324	44	14G
0005433753340	2324	45	15A
0005433766583	2324	46	15B
0005435981612	2324	47	15E
0005433753352	2324	48	15D
0005433753374	2324	49	15H
0005433753386	2324	50	15G
0005432225961	2324	51	16A
0005435981604	2324	52	16B
0005435981631	2324	53	16F
0005435981597	2324	54	16H
0005435981625	2324	55	16G
0005435981635	2324	56	17B
0005435981641	2324	57	17D
0005435981618	2324	58	17F
0005432300176	2324	59	18A
0005433764648	2324	60	18D
0005432225965	2324	61	18F
0005433753392	2324	62	18E
0005435981608	2324	63	18G
0005435981594	2324	64	19A
0005435981615	2324	65	19E
0005435981627	2324	66	19F
0005433753365	2324	67	20A
0005433753373	2324	68	19H
0005433753338	2324	69	20B
0005432655353	2324	70	20E
0005432655360	2324	71	20D
0005433753355	2324	72	20F
0005433753344	2324	73	21A
0005433753387	2324	74	21B
0005433753377	2324	75	21E
0005435981598	2324	76	21D
0005433766581	2324	77	21H
0005433753378	2324	78	22E
0005433753393	2324	79	22F
0005433753339	2324	80	23A
0005433753366	2324	81	22H
0005433753350	2324	82	23B
0005433753384	2324	83	23D
0005435981642	2324	84	23F
0005433753345	2324	85	23E
0005433753369	2324	86	23G
0005432300175	2324	87	23H
0005435981636	2324	88	24E
0005435981610	2324	89	24F
0005433753381	2324	90	24G
0005435981596	2324	91	25D
0005432655357	2324	92	25F
0005435981617	2324	93	27D
0005435981613	2324	94	27B
0005432300172	2324	95	27A
0005433753336	2324	96	27E
0005432655351	2324	97	28A
0005435981639	2324	98	28D
0005435981634	2324	99	28G
0005432655355	2324	100	29B
0005435981609	2324	101	29E
0005435981619	2324	102	29G
0005433766584	2324	103	29F
0005435981601	2324	104	29H
0005433753362	2324	105	30F
0005433753346	2324	106	31B
0005433764649	2324	107	31D
0005433766582	2324	108	31E
0005433753372	2324	109	31H
0005435981614	2324	110	31G
0005433753343	2324	111	32A
0005435981623	2324	112	33A
0005433753353	2324	113	32H
0005435981640	2324	114	33E
0005432300174	2324	115	33F
0005433753367	2324	116	33H
0005435981602	2324	117	34D
0005432655358	2324	118	34B
0005432655350	2324	119	34E
0005435981621	2324	120	34G
0005433753380	2324	121	34H
0005435981620	2324	122	35B
0005435981644	2324	123	35D
0005433753376	2324	124	35F
0005433753356	2324	125	35E
0005432225960	2324	126	35H
0005435981595	2324	127	36B
0005432655356	2324	128	36A
0005433753348	2324	129	36E
0005433753370	2324	130	36F
0005432655354	2324	131	36H
0005432225964	2324	132	37D
0005435981643	2324	133	37E
0005435981637	2324	134	37F
0005435981605	2324	135	38A
0005432655359	2324	136	38D
0005435981599	2324	137	38E
0005433753368	2324	138	38G
0005433753341	2324	139	38F
0005432655352	2324	140	39D
0005435981611	2324	141	39E
0005432984567	26195	1	1F
0005433434250	26195	2	1G
0005433434265	26195	3	2A
0005433434252	26195	4	2B
0005432869419	26195	5	3G
0005433434253	26195	6	4B
0005432984573	26195	7	4C
0005432984596	26195	8	4H
0005432984591	26195	9	4F
0005432984578	26195	10	9A
0005432984569	26195	11	5H
0005432984572	26195	12	9G
0005432984590	26195	13	11E
0005432984597	26195	14	11D
0005432869418	26195	15	11F
0005432984571	26195	16	12E
0005433434257	26195	17	12H
0005432984595	26195	18	13B
0005432984576	26195	19	13D
0005432984592	26195	20	13E
0005432869421	26195	21	13G
0005434731108	26195	22	14B
0005432984574	26195	23	14D
0005433434254	26195	24	15A
0005433434239	26195	25	15G
0005432984581	26195	26	15H
0005432984568	26195	27	16G
0005434731105	26195	28	17A
0005432984599	26195	29	17D
0005433434237	26195	30	17E
0005433434262	26195	31	18B
0005432984588	26195	32	18H
0005434731107	26195	33	19B
0005433434249	26195	34	19E
0005433434246	26195	35	19D
0005434731106	26195	36	20A
0005433434258	26195	37	20E
0005433434251	26195	38	20G
0005432984570	26195	39	21E
0005432984589	26195	40	22D
0005432869422	26195	41	22E
0005433434263	26195	42	22G
0005432984598	26195	43	23A
0005433434238	26195	44	24A
0005432984575	26195	45	24D
0005432984579	26195	46	24F
0005432984594	26195	47	24H
0005432049407	26195	48	27B
0005432984584	26195	49	27E
0005433434244	26195	50	27G
0005432984593	26195	51	28D
0005433434256	26195	52	28B
0005433434242	26195	53	28H
0005432049410	26195	54	29A
0005432984583	26195	55	29B
0005432984577	26195	56	29E
0005432869420	26195	57	29H
0005432049409	26195	58	30A
0005433434259	26195	59	30D
0005432051079	26195	60	30G
0005433434261	26195	61	31D
0005432984586	26195	62	31F
0005432869417	26195	63	32E
0005432984580	26195	64	32H
0005432051080	26195	65	33G
0005434731104	26195	66	33F
0005433434248	26195	67	33H
0005433434240	26195	68	34A
0005433434243	26195	69	34D
0005433434247	26195	70	34H
0005432984585	26195	71	35D
0005433434241	26195	72	35F
0005433434260	26195	73	36A
0005433434264	26195	74	35H
0005432051081	26195	75	36B
0005432984582	26195	76	36E
0005432984587	26195	77	38A
0005432049408	26195	78	38D
0005432051082	26195	79	38E
0005433434255	26195	80	38F
0005433434245	26195	81	38H
0005432869423	26195	82	39F
0005434373955	1494	1	1C
0005434373948	1494	2	2C
0005434373984	1494	3	2A
0005434373988	1494	4	4E
0005434373987	1494	5	4F
0005432267795	1494	6	5A
0005432267792	1494	7	5C
0005434373994	1494	8	5E
0005434373974	1494	9	5F
0005434373973	1494	10	6C
0005432267791	1494	11	6B
0005434373968	1494	12	6F
0005434373977	1494	13	7C
0005434373978	1494	14	7D
0005434373966	1494	15	8A
0005434373956	1494	16	8C
0005434373991	1494	17	8E
0005434373964	1494	18	8D
0005434373975	1494	19	9A
0005432267790	1494	20	9B
0005434373957	1494	21	9E
0005434373971	1494	22	9D
0005433150827	1494	23	11A
0005434373952	1494	24	11D
0005434373963	1494	25	11E
0005434373979	1494	26	12A
0005434373993	1494	27	12B
0005434373945	1494	28	12F
0005434373960	1494	29	13C
0005434373958	1494	30	13B
0005434373982	1494	31	13E
0005434373970	1494	32	13F
0005434373967	1494	33	14A
0005433461554	1494	34	14C
0005434373983	1494	35	14B
0005434373959	1494	36	14D
0005434373986	1494	37	14E
0005434373950	1494	38	15A
0005434373962	1494	39	14F
0005434373980	1494	40	15B
0005433460403	1494	41	15E
0005433460404	1494	42	15F
0005434373961	1494	43	16B
0005432267793	1494	44	16C
0005432267796	1494	45	16E
0005434373969	1494	46	16F
0005434373965	1494	47	17B
0005434373976	1494	48	17C
0005434373990	1494	49	17D
0005433461555	1494	50	18C
0005434373989	1494	51	19A
0005434373953	1494	52	18F
0005432267794	1494	53	19C
0005433460402	1494	54	20A
0005434373954	1494	55	20D
0005434373985	1494	56	20E
0005434373981	1494	57	21B
0005434373949	1494	58	21D
0005434373946	1494	59	21E
0005434373992	1494	60	22B
0005434373951	1494	61	22F
0005434373947	1494	62	23C
0005434373972	1494	63	23F
0005433764648	20123	1	1C
0005433150874	20123	2	1F
0005433150884	20123	3	2F
0005433150877	20123	4	3F
0005433150893	20123	5	4E
0005433150896	20123	6	5A
0005433150885	20123	7	5C
0005433150873	20123	8	5D
0005433150864	20123	9	5E
0005433150897	20123	10	7A
0005434029619	20123	11	7F
0005433150871	20123	12	8D
0005432056239	20123	13	9B
0005434029620	20123	14	9C
0005433150889	20123	15	9E
0005433150882	20123	16	10C
0005433150891	20123	17	10D
0005433931421	20123	18	11A
0005433764649	20123	19	11D
0005433150892	20123	20	12A
0005433150883	20123	21	12C
0005433150868	20123	22	12B
0005433150869	20123	23	12F
0005433931420	20123	24	13D
0005433150895	20123	25	13E
0005433150887	20123	26	14A
0005432056240	20123	27	14D
0005433150867	20123	28	14F
0005433150890	20123	29	15F
0005433150886	20123	30	16B
0005433150894	20123	31	16E
0005433150875	20123	32	17A
0005433150898	20123	33	17B
0005433150865	20123	34	17F
0005433150866	20123	35	18D
0005433150879	20123	36	19B
0005433150881	20123	37	19E
0005432056241	20123	38	20A
0005433931422	20123	39	21A
0005432056242	20123	40	21D
0005433150876	20123	41	21E
0005433150878	20123	42	22B
0005433150872	20123	43	22C
0005433150880	20123	44	22D
0005433764647	20123	45	23B
0005433150888	20123	46	23C
0005433150870	20123	47	23F
0005432423717	508	1	1C
0005432423737	508	2	1D
0005432282759	508	3	2C
0005432423720	508	4	2F
0005432423730	508	5	3C
0005432282756	508	6	4D
0005432423713	508	7	5A
0005432423695	508	8	5F
0005432423716	508	9	6C
0005432423755	508	10	7A
0005432423761	508	11	7C
0005432423709	508	12	8B
0005432282757	508	13	8D
0005432423714	508	14	8E
0005432423728	508	15	9B
0005432423722	508	16	9D
0005432423757	508	17	9E
0005432423754	508	18	10A
0005432423742	508	19	9F
0005432282755	508	20	10E
0005432423707	508	21	10D
0005432423701	508	22	11D
0005432423702	508	23	12A
0005432423705	508	24	12B
0005432423731	508	25	12C
0005432423747	508	26	12F
0005432423724	508	27	13B
0005432423740	508	28	13A
0005432423725	508	29	13D
0005432423734	508	30	14A
0005432423718	508	31	14B
0005432423756	508	32	14D
0005432423715	508	33	15C
0005432423745	508	34	16C
0005432423752	508	35	16F
0005432423760	508	36	17B
0005432423694	508	37	17A
0005432423719	508	38	17D
0005432423711	508	39	17F
0005432423736	508	40	18A
0005432423741	508	41	18D
0005432423710	508	42	19E
0005432423753	508	43	20F
0005432423762	508	44	20E
0005432423697	508	45	21C
0005432423735	508	46	21B
0005432423723	508	47	21D
0005432423704	508	48	21E
0005432423706	508	49	22D
0005432423738	508	50	23A
0005432282758	508	51	23C
0005432423739	508	52	23B
0005432423744	508	53	23D
0005432423733	508	54	23E
0005432423703	508	55	23F
0005432423708	508	56	24C
0005432423743	508	57	24D
0005432423751	508	58	24F
0005432423712	508	59	25B
0005432423759	508	60	25C
0005432423749	508	61	26A
0005432423700	508	62	25F
0005432423727	508	63	26B
0005432423726	508	64	26F
0005432423729	508	65	27D
0005432423696	508	66	27E
0005432423746	508	67	27F
0005432423732	508	68	28B
0005432423748	508	69	28F
0005432423758	508	70	29E
0005432423699	508	71	29D
0005432423721	508	72	30A
0005432423750	508	73	29F
0005432423698	508	74	31E
0005432302273	12905	1	10A
0005432302274	12905	2	19C
0005432302272	12905	3	21F
0005433158096	12905	4	22F
0005433158098	12905	5	26C
0005433158095	12905	6	30E
0005433158097	12905	7	31E
0005434022696	440	1	1A
0005434022694	440	2	1B
0005434022671	440	3	1G
0005434022664	440	4	2F
0005434029616	440	5	2H
0005434022684	440	6	2G
0005434022695	440	7	3B
0005434022652	440	8	3F
0005434022673	440	9	3H
0005434022643	440	10	4A
0005434022707	440	11	4G
0005432235520	440	12	4F
0005434022700	440	13	4H
0005432235522	440	14	5F
0005434022670	440	15	9A
0005432235525	440	16	9G
0005434022649	440	17	11A
0005432235526	440	18	9H
0005432045582	440	19	11D
0005434022647	440	20	11H
0005434022686	440	21	12B
0005434022682	440	22	12E
0005434022685	440	23	13B
0005434022693	440	24	13A
0005434022698	440	25	13D
0005434022680	440	26	14B
0005434022672	440	27	14A
0005434022669	440	28	14D
0005434031951	440	29	14G
0005434022656	440	30	15B
0005434028252	440	31	15A
0005434022704	440	32	16A
0005434022676	440	33	16B
0005434022645	440	34	16G
0005434022642	440	35	16H
0005434022678	440	36	17D
0005432235519	440	37	17G
0005434022651	440	38	17F
0005434022702	440	39	18D
0005434022697	440	40	18F
0005434028251	440	41	18G
0005434022701	440	42	19B
0005434022644	440	43	19A
0005434022691	440	44	19D
0005434022662	440	45	20A
0005434022667	440	46	20D
0005434022692	440	47	20F
0005432045583	440	48	20G
0005432235523	440	49	21A
0005434022677	440	50	21B
0005434022654	440	51	21F
0005434022703	440	52	22A
0005434022668	440	53	22D
0005434031950	440	54	22E
0005434022659	440	55	23B
0005434022679	440	56	23D
0005434022705	440	57	23F
0005434022706	440	58	23G
0005434022699	440	59	24E
0005434029617	440	60	24D
0005434022674	440	61	24F
0005434022640	440	62	25F
0005434028250	440	63	27A
0005434022648	440	64	27E
0005434022688	440	65	27G
0005434029618	440	66	28B
0005434022660	440	67	28D
0005434022708	440	68	29D
0005434022663	440	69	29G
0005434022683	440	70	30F
0005434022687	440	71	30E
0005434022681	440	72	30G
0005434031949	440	73	31E
0005434022653	440	74	31G
0005434028253	440	75	32E
0005434022661	440	76	32G
0005434022690	440	77	33A
0005434022658	440	78	33G
0005434022666	440	79	33F
0005434022641	440	80	33H
0005434031948	440	81	34E
0005434022657	440	82	34G
0005434022655	440	83	35E
0005434022646	440	84	35F
0005434022650	440	85	36A
0005432235521	440	86	37A
0005434022689	440	87	37E
0005434022639	440	88	38B
0005432235524	440	89	38A
0005434031952	440	90	37H
0005434022675	440	91	38F
0005434022665	440	92	39D
0005433057258	12671	1	1F
0005432156298	12671	2	2A
0005433057263	12671	3	2B
0005433929550	12671	4	4G
0005433057262	12671	5	4F
0005433057252	12671	6	5B
0005433057280	12671	7	5F
0005433057277	12671	8	5H
0005433684389	12671	9	11A
0005433057251	12671	10	11E
0005433057284	12671	11	12D
0005432156299	12671	12	12F
0005433057267	12671	13	13F
0005432157462	12671	14	14B
0005433057274	12671	15	14F
0005433057264	12671	16	14G
0005433929547	12671	17	14H
0005433057270	12671	18	16E
0005432157461	12671	19	17B
0005433057285	12671	20	17A
0005432157463	12671	21	17E
0005433057281	12671	22	17G
0005433057287	12671	23	18A
0005433057256	12671	24	19A
0005433057289	12671	25	20A
0005433057288	12671	26	20B
0005433929552	12671	27	21B
0005434735612	12671	28	21F
0005432156297	12671	29	21H
0005432156295	12671	30	22A
0005433057255	12671	31	23E
0005433057266	12671	32	23F
0005433057259	12671	33	24A
0005433057282	12671	34	24G
0005433057290	12671	35	27B
0005433057278	12671	36	28A
0005433057250	12671	37	28H
0005433057268	12671	38	28G
0005433929548	12671	39	29E
0005433057276	12671	40	30A
0005434735611	12671	41	29H
0005433057260	12671	42	30B
0005433057265	12671	43	30G
0005433057283	12671	44	31A
0005434735608	12671	45	31D
0005433057271	12671	46	32B
0005433057261	12671	47	33B
0005433057257	12671	48	33E
0005433929551	12671	49	33G
0005432156296	12671	50	33H
0005433057269	12671	51	34E
0005433057253	12671	52	34F
0005434735609	12671	53	35A
0005433057272	12671	54	34H
0005433929549	12671	55	35D
0005434735610	12671	56	35H
0005433057279	12671	57	36A
0005433057254	12671	58	36F
0005433057286	12671	59	37D
0005433057273	12671	60	37E
0005433057275	12671	61	38D
0005434735607	12671	62	39E
0005433921847	2113	1	1A
0005433921824	2113	2	1C
0005433921826	2113	3	1B
0005433921836	2113	4	1G
0005433921830	2113	5	2A
0005433921842	2113	6	3A
0005433921827	2113	7	2H
0005433921865	2113	8	3C
0005433921875	2113	9	3F
0005432231401	2113	10	3G
0005433921816	2113	11	3H
0005433921880	2113	12	4B
0005432044482	2113	13	4A
0005432231403	2113	14	4F
0005433921796	2113	15	4H
0005433921807	2113	16	5B
0005433921799	2113	17	5F
0005433921806	2113	18	5C
0005433921848	2113	19	5G
0005433921783	2113	20	5H
0005433929550	2113	21	9A
0005433921860	2113	22	9G
0005433921797	2113	23	11A
0005433921789	2113	24	11B
0005433921868	2113	25	11E
0005433921873	2113	26	11F
0005432231397	2113	27	11H
0005433921863	2113	28	11G
0005432231399	2113	29	12A
0005433921820	2113	30	13D
0005433921801	2113	31	13G
0005433921853	2113	32	14B
0005433921794	2113	33	14D
0005433921791	2113	34	14F
0005433921817	2113	35	14H
0005433921792	2113	36	15E
0005433875353	2113	37	15H
0005433921855	2113	38	16B
0005433921843	2113	39	16E
0005433921822	2113	40	16H
0005433921864	2113	41	17A
0005433921858	2113	42	17D
0005433921874	2113	43	17B
0005433921869	2113	44	17F
0005433921844	2113	45	17G
0005432231405	2113	46	18A
0005433921784	2113	47	18E
0005433921814	2113	48	18D
0005433921845	2113	49	18B
0005433921840	2113	50	18F
0005433921835	2113	51	18H
0005433921839	2113	52	19E
0005433921857	2113	53	19G
0005433929548	2113	54	20A
0005433921825	2113	55	20D
0005433929551	2113	56	20G
0005433921804	2113	57	21B
0005432231404	2113	58	21E
0005433921861	2113	59	21G
0005433921819	2113	60	22D
0005433931420	2113	61	22E
0005433921795	2113	62	22G
0005433921832	2113	63	22H
0005433921810	2113	64	23B
0005433921859	2113	65	23F
0005433921877	2113	66	23H
0005433921821	2113	67	24A
0005433921808	2113	68	24B
0005433929552	2113	69	24D
0005433921829	2113	70	24F
0005433921879	2113	71	24G
0005433921809	2113	72	25E
0005433921818	2113	73	25F
0005433921793	2113	74	27B
0005433921841	2113	75	27E
0005433921790	2113	76	27F
0005433931422	2113	77	28B
0005433921785	2113	78	28F
0005432231400	2113	79	28H
0005433921872	2113	80	28G
0005433921870	2113	81	29B
0005433921823	2113	82	29A
0005433921856	2113	83	29D
0005433921838	2113	84	29F
0005433875354	2113	85	29H
0005432231406	2113	86	29G
0005433921837	2113	87	30E
0005432044481	2113	88	30D
0005433929547	2113	89	30F
0005433921862	2113	90	31B
0005433921786	2113	91	31D
0005433921802	2113	92	31G
0005433921787	2113	93	32D
0005433921867	2113	94	32B
0005433921878	2113	95	32E
0005433921812	2113	96	32F
0005432231402	2113	97	33D
0005433921876	2113	98	33E
0005433921833	2113	99	33F
0005433921803	2113	100	33H
0005433921871	2113	101	34A
0005433921846	2113	102	34F
0005433921834	2113	103	34H
0005433921851	2113	104	35D
0005433921815	2113	105	35H
0005433921854	2113	106	35G
0005433921850	2113	107	36A
0005432231398	2113	108	36E
0005433921798	2113	109	36D
0005433921813	2113	110	36F
0005433921788	2113	111	36G
0005433929549	2113	112	37A
0005433931421	2113	113	36H
0005433921866	2113	114	37F
0005433921831	2113	115	37G
0005433921800	2113	116	38E
0005433921805	2113	117	38G
0005433921828	2113	118	38F
0005433921849	2113	119	39D
0005433921852	2113	120	39F
0005433921811	2113	121	39E
0005433035507	24135	1	1C
0005433035511	24135	2	1B
0005433035515	24135	3	1F
0005433035466	24135	4	1H
0005433035476	24135	5	1G
0005433035494	24135	6	2A
0005433035469	24135	7	2F
0005432749752	24135	8	5B
0005433035484	24135	9	9H
0005433035514	24135	10	11G
0005433035468	24135	11	11F
0005433035495	24135	12	12A
0005433035490	24135	13	12B
0005433035474	24135	14	12E
0005433035516	24135	15	13G
0005433035491	24135	16	14G
0005433035488	24135	17	15D
0005433035475	24135	18	15G
0005433035506	24135	19	16E
0005433035499	24135	20	17A
0005432206103	24135	21	17D
0005433035512	24135	22	17E
0005433035497	24135	23	17H
0005433035485	24135	24	18B
0005433035510	24135	25	18A
0005433035472	24135	26	18E
0005433035489	24135	27	18G
0005433035513	24135	28	18F
0005433035501	24135	29	18H
0005432749751	24135	30	19B
0005433035465	24135	31	19G
0005433035500	24135	32	20A
0005433035478	24135	33	20D
0005432206108	24135	34	20H
0005433035481	24135	35	21F
0005433035493	24135	36	21G
0005434028254	24135	37	22B
0005432207623	24135	38	22H
0005434028256	24135	39	22G
0005432206109	24135	40	23G
0005432207622	24135	41	24A
0005433035477	24135	42	25D
0005433035464	24135	43	27B
0005433035487	24135	44	27D
0005433035473	24135	45	27F
0005433035509	24135	46	27G
0005433035480	24135	47	28D
0005433035498	24135	48	28H
0005433035518	24135	49	28G
0005433035503	24135	50	29F
0005433035496	24135	51	29H
0005433035517	24135	52	29G
0005433035504	24135	53	30G
0005433035471	24135	54	31B
0005433035505	24135	55	31H
0005433035482	24135	56	31G
0005432206105	24135	57	32B
0005433035470	24135	58	33A
0005433035479	24135	59	33H
0005432206104	24135	60	33G
0005433035467	24135	61	34B
0005434028255	24135	62	36A
0005433035492	24135	63	36B
0005433035483	24135	64	36E
0005432206106	24135	65	37A
0005433035502	24135	66	37H
0005433035486	24135	67	38B
0005433035508	24135	68	38G
0005432206107	24135	69	38H
0005432277598	245	1	1D
0005434550379	245	2	1K
0005434723600	245	3	2A
0005434550397	245	4	2H
0005434550391	245	5	2G
0005435142369	245	6	3A
0005434550377	245	7	2K
0005434550416	245	8	3D
0005434723570	245	9	3H
0005434723625	245	10	4C
0005434723680	245	11	4A
0005434723633	245	12	4D
0005434550392	245	13	4K
0005434550409	245	14	5C
0005434723663	245	15	5G
0005434550407	245	16	11C
0005435142367	245	17	11F
0005434723589	245	18	11E
0005434723656	245	19	11K
0005434723669	245	20	11H
0005434723575	245	21	12C
0005432277600	245	22	12A
0005434550412	245	23	12H
0005434550393	245	24	13A
0005434550373	245	25	12K
0005435142374	245	26	13F
0005434723594	245	27	13E
0005432277609	245	28	13G
0005434723557	245	29	14A
0005434723559	245	30	13K
0005434723562	245	31	14E
0005434723657	245	32	14D
0005432277608	245	33	14C
0005434550371	245	34	14G
0005435142373	245	35	14F
0005434723627	245	36	14K
0005434723558	245	37	15A
0005434723621	245	38	15D
0005434723564	245	39	15G
0005434735606	245	40	15K
0005434723672	245	41	15H
0005434735605	245	42	16C
0005434723666	245	43	16E
0005434723642	245	44	16H
0005434550411	245	45	17C
0005434723606	245	46	16K
0005434723643	245	47	17D
0005434723580	245	48	17G
0005434723639	245	49	18C
0005434723602	245	50	18B
0005434723645	245	51	18A
0005434550374	245	52	18D
0005434723662	245	53	18G
0005434723665	245	54	18J
0005434723597	245	55	19B
0005434723628	245	56	19A
0005434550389	245	57	18K
0005434723572	245	58	19D
0005434550406	245	59	19C
0005434723566	245	60	19F
0005434723631	245	61	19J
0005432277606	245	62	19K
0005434550417	245	63	20C
0005434550418	245	64	20D
0005434723664	245	65	20F
0005434723649	245	66	20K
0005434723567	245	67	21D
0005434723578	245	68	21C
0005434550420	245	69	21F
0005434550399	245	70	21E
0005434723626	245	71	21H
0005434723682	245	72	21G
0005434723622	245	73	21J
0005434723652	245	74	22E
0005434723583	245	75	22H
0005434302391	245	76	22G
0005434723667	245	77	22K
0005435142371	245	78	22J
0005434723620	245	79	23B
0005434723614	245	80	23A
0005434550376	245	81	23D
0005434723582	245	82	23C
0005434550403	245	83	23G
0005435142372	245	84	23F
0005434723584	245	85	23E
0005435142366	245	86	23H
0005434550402	245	87	23K
0005434723660	245	88	24E
0005434731101	245	89	24G
0005432277607	245	90	25D
0005434723679	245	91	25H
0005435142370	245	92	26A
0005432277597	245	93	25K
0005434550380	245	94	25J
0005434723637	245	95	26D
0005434550424	245	96	26H
0005432277602	245	97	26G
0005434723595	245	98	26J
0005434723560	245	99	27B
0005434723644	245	100	27A
0005434723613	245	101	26K
0005434723585	245	102	27C
0005434723617	245	103	27E
0005434550370	245	104	28A
0005432277601	245	105	28E
0005434723571	245	106	28J
0005434550404	245	107	28H
0005434550369	245	108	29B
0005434723648	245	109	29A
0005434723563	245	110	28K
0005432277599	245	111	29D
0005432277605	245	112	29F
0005434731102	245	113	29E
0005434723615	245	114	29K
0005434723681	245	115	30G
0005432277604	245	116	30F
0005434735604	245	117	30J
0005434723587	245	118	31A
0005434723610	245	119	30K
0005434723673	245	120	31F
0005434550408	245	121	31H
0005434723588	245	122	31G
0005434550394	245	123	32A
0005434550372	245	124	31K
0005434723674	245	125	32C
0005434723640	245	126	32B
0005434723561	245	127	32D
0005434735603	245	128	32G
0005434723647	245	129	33C
0005434550375	245	130	33G
0005434723675	245	131	33K
0005434550423	245	132	34C
0005434723601	245	133	34B
0005434550405	245	134	34F
0005435142364	245	135	34J
0005435142363	245	136	34H
0005434723629	245	137	35A
0005434550396	245	138	34K
0005434550395	245	139	35D
0005434735602	245	140	35C
0005434550378	245	141	35F
0005434723579	245	142	35E
0005434723659	245	143	36C
0005434723586	245	144	36B
0005434723607	245	145	36E
0005434723670	245	146	36D
0005434723611	245	147	36G
0005435142365	245	148	36F
0005434731100	245	149	36K
0005434723612	245	150	36J
0005435142375	245	151	37C
0005434723576	245	152	37D
0005434723641	245	153	37F
0005434550410	245	154	37E
0005434723646	245	155	37J
0005434723609	245	156	37G
0005434723593	245	157	37K
0005434550413	245	158	38C
0005434723636	245	159	38B
0005434723632	245	160	38K
0005434550383	245	161	39B
0005434723604	245	162	39A
0005434723568	245	163	39C
0005434723658	245	164	39F
0005434550401	245	165	39E
0005434723653	245	166	39J
0005434723596	245	167	40B
0005434723661	245	168	40E
0005434550381	245	169	40H
0005434723603	245	170	40F
0005434723565	245	171	41A
0005434723573	245	172	41C
0005434723592	245	173	41F
0005434723650	245	174	41H
0005434550415	245	175	41K
0005434723676	245	176	41J
0005434723671	245	177	42E
0005434550386	245	178	42D
0005434302394	245	179	42H
0005432277603	245	180	42G
0005434723634	245	181	42K
0005434723608	245	182	43B
0005434723655	245	183	43D
0005434723654	245	184	43F
0005434723623	245	185	43E
0005434723581	245	186	43H
0005434550422	245	187	43J
0005434723678	245	188	44B
0005434550419	245	189	44A
0005434550421	245	190	44G
0005434723616	245	191	44F
0005434302392	245	192	44H
0005434723651	245	193	45B
0005434723569	245	194	45D
0005434723677	245	195	45C
0005434731103	245	196	45F
0005434723638	245	197	45H
0005434550387	245	198	45K
0005434723590	245	199	46B
0005434550398	245	200	46A
0005434723619	245	201	46E
0005434723624	245	202	46D
0005434550384	245	203	46G
0005434723630	245	204	46J
0005434723605	245	205	47D
0005434723635	245	206	47F
0005435142376	245	207	47E
0005434550414	245	208	48C
0005435142368	245	209	48A
0005434723598	245	210	48F
0005434302393	245	211	48E
0005434723618	245	212	48H
0005434550382	245	213	48G
0005434723668	245	214	49E
0005434550400	245	215	49G
0005434723577	245	216	49K
0005434723574	245	217	50E
0005434550388	245	218	50D
0005434550390	245	219	51D
0005434723591	245	220	50K
0005434550385	245	221	51F
0005434723599	245	222	51E
0005433233261	9858	1	1D
0005433233254	9858	2	1K
0005433180706	9858	3	2C
0005433233263	9858	4	3A
0005433233238	9858	5	3D
0005433766582	9858	6	3C
0005433233211	9858	7	4C
0005433180707	9858	8	11A
0005433233236	9858	9	11D
0005433233244	9858	10	11C
0005432199139	9858	11	11H
0005433233270	9858	12	12E
0005433180704	9858	13	12D
0005433233231	9858	14	13E
0005433289732	9858	15	14D
0005433180702	9858	16	15C
0005433113500	9858	17	15D
0005433129203	9858	18	15F
0005433233262	9858	19	16K
0005433233233	9858	20	17C
0005432199142	9858	21	18D
0005433113501	9858	22	18G
0005433233256	9858	23	19B
0005433180705	9858	24	19A
0005433129204	9858	25	19F
0005433180725	9858	26	20C
0005433126772	9858	27	20B
0005433289735	9858	28	20F
0005433129202	9858	29	21B
0005433129206	9858	30	21C
0005433289734	9858	31	22B
0005433233218	9858	32	22F
0005433233227	9858	33	23B
0005433233248	9858	34	23E
0005432199143	9858	35	23G
0005432199137	9858	36	24D
0005432199138	9858	37	24F
0005433233217	9858	38	24G
0005433180703	9858	39	25C
0005433233221	9858	40	25B
0005433233249	9858	41	25E
0005433233222	9858	42	25J
0005433180722	9858	43	26A
0005433180709	9858	44	26E
0005433180712	9858	45	26D
0005433233228	9858	46	26J
0005433233271	9858	47	27A
0005433233268	9858	48	27B
0005433180719	9858	49	27E
0005433289738	9858	50	27G
0005433233247	9858	51	27K
0005433233266	9858	52	27J
0005433233232	9858	53	28E
0005433233219	9858	54	28K
0005433233209	9858	55	29D
0005432199144	9858	56	29C
0005434031954	9858	57	29F
0005433233259	9858	58	30C
0005432199141	9858	59	30B
0005433233251	9858	60	30A
0005433289733	9858	61	30E
0005433289731	9858	62	30H
0005433233267	9858	63	31B
0005433233210	9858	64	31E
0005433233250	9858	65	32G
0005433180708	9858	66	33B
0005433233214	9858	67	32K
0005433233264	9858	68	33G
0005433180710	9858	69	33J
0005433180724	9858	70	33H
0005433233272	9858	71	34E
0005433233229	9858	72	34D
0005433233260	9858	73	35D
0005434031956	9858	74	35H
0005433180718	9858	75	36C
0005433129205	9858	76	36F
0005433233213	9858	77	36E
0005433233226	9858	78	36H
0005433233241	9858	79	36J
0005434031953	9858	80	37D
0005433233253	9858	81	37G
0005433126774	9858	82	37H
0005433180717	9858	83	38B
0005433180721	9858	84	39A
0005433233257	9858	85	39D
0005433233220	9858	86	40A
0005433180720	9858	87	39K
0005433766581	9858	88	40E
0005433233212	9858	89	40D
0005433766583	9858	90	40K
0005433233239	9858	91	41B
0005433233243	9858	92	41F
0005433233269	9858	93	41G
0005433180713	9858	94	42C
0005433180715	9858	95	42B
0005433126773	9858	96	42E
0005433233255	9858	97	42D
0005433180716	9858	98	42H
0005433180711	9858	99	42J
0005433233242	9858	100	43D
0005433233223	9858	101	44A
0005433233265	9858	102	43J
0005432199140	9858	103	44E
0005433233246	9858	104	44G
0005433233258	9858	105	44F
0005433233235	9858	106	45C
0005433233224	9858	107	45G
0005433126775	9858	108	45K
0005433180723	9858	109	45J
0005433233237	9858	110	46H
0005433766584	9858	111	46G
0005433233234	9858	112	46J
0005433180714	9858	113	46K
0005433126776	9858	114	47E
0005433233240	9858	115	47G
0005433289737	9858	116	47K
0005433233216	9858	117	49A
0005433233230	9858	118	49D
0005433180701	9858	119	50E
0005433289736	9858	120	50D
0005434031955	9858	121	50G
0005433233215	9858	122	50H
0005433233252	9858	123	51F
0005433233245	9858	124	51E
0005433233225	9858	125	51D
0005432428876	7723	1	1C
0005432069438	7723	2	1H
0005432526024	7723	3	1G
0005432069432	7723	4	2A
0005434066476	7723	5	1K
0005434066486	7723	6	2C
0005432526012	7723	7	2G
0005434066468	7723	8	3A
0005432526004	7723	9	2K
0005432525982	7723	10	3C
0005432526032	7723	11	4A
0005434066496	7723	12	4G
0005432069431	7723	13	4D
0005432525938	7723	14	4K
0005432525989	7723	15	5C
0005432069427	7723	16	5A
0005434066458	7723	17	5H
0005432526027	7723	18	5G
0005432428878	7723	19	11A
0005432069437	7723	20	5K
0005432525929	7723	21	11C
0005432526015	7723	22	11F
0005432525948	7723	23	11E
0005432526025	7723	24	11K
0005432525915	7723	25	11H
0005432535757	7723	26	12A
0005432526028	7723	27	12E
0005432526019	7723	28	12D
0005432525957	7723	29	12G
0005434066492	7723	30	12F
0005432428874	7723	31	12K
0005432069426	7723	32	12H
0005432525980	7723	33	13C
0005432525987	7723	34	13F
0005432525928	7723	35	13E
0005432150077	7723	36	13G
0005434066490	7723	37	13K
0005434066470	7723	38	14D
0005434066453	7723	39	14C
0005432525942	7723	40	14F
0005432525947	7723	41	14H
0005432525995	7723	42	14G
0005432526006	7723	43	15A
0005434066450	7723	44	15D
0005432526003	7723	45	15G
0005432525936	7723	46	15F
0005434066471	7723	47	15K
0005432526001	7723	48	16D
0005432525984	7723	49	16A
0005432525976	7723	50	16F
0005432533247	7723	51	16E
0005432525933	7723	52	17A
0005434066488	7723	53	16K
0005434066443	7723	54	17E
0005432069435	7723	55	17D
0005432525966	7723	56	17C
0005432525959	7723	57	17G
0005432525972	7723	58	17F
0005434066440	7723	59	17K
0005432525998	7723	60	17H
0005432525992	7723	61	18E
0005432525926	7723	62	18G
0005432526005	7723	63	18F
0005434066457	7723	64	18J
0005432526011	7723	65	18H
0005432525999	7723	66	19B
0005432525918	7723	67	19A
0005434066465	7723	68	19C
0005432526033	7723	69	19G
0005432525967	7723	70	19F
0005432525950	7723	71	19E
0005432525975	7723	72	19K
0005432069433	7723	73	20A
0005432525968	7723	74	20D
0005432525943	7723	75	20G
0005432525907	7723	76	21B
0005432526030	7723	77	20K
0005432525997	7723	78	21D
0005434066491	7723	79	21G
0005434066462	7723	80	21J
0005434066483	7723	81	21H
0005432069429	7723	82	22A
0005434066454	7723	83	21K
0005434066466	7723	84	22C
0005432150076	7723	85	22F
0005434066493	7723	86	22G
0005432525964	7723	87	22J
0005432526026	7723	88	22H
0005434066469	7723	89	23B
0005432069436	7723	90	23D
0005432525979	7723	91	23C
0005434066442	7723	92	23F
0005432525912	7723	93	23E
0005434066459	7723	94	23J
0005434066464	7723	95	24D
0005432525914	7723	96	23K
0005432525911	7723	97	24F
0005434066489	7723	98	24G
0005432525974	7723	99	25C
0005434066475	7723	100	25B
0005434066460	7723	101	25K
0005432069434	7723	102	26C
0005434066495	7723	103	26B
0005432069425	7723	104	26E
0005432428875	7723	105	26D
0005432525986	7723	106	26G
0005432526000	7723	107	26F
0005432525958	7723	108	26H
0005434066447	7723	109	26K
0005432526031	7723	110	27C
0005432526034	7723	111	27F
0005432525937	7723	112	27H
0005434066499	7723	113	27G
0005432526035	7723	114	27K
0005432525973	7723	115	27J
0005432525906	7723	116	28C
0005434066480	7723	117	28B
0005434066485	7723	118	28A
0005434066478	7723	119	28E
0005432526023	7723	120	28D
0005434066507	7723	121	28F
0005432525965	7723	122	28J
0005432525935	7723	123	29D
0005434066445	7723	124	29F
0005432525905	7723	125	29G
0005432525949	7723	126	30B
0005434066503	7723	127	30A
0005432526018	7723	128	30E
0005432525922	7723	129	30D
0005432535758	7723	130	30K
0005434066473	7723	131	31D
0005432525994	7723	132	31C
0005434066448	7723	133	31E
0005434066509	7723	134	31H
0005432526022	7723	135	31K
0005432525910	7723	136	32C
0005432526020	7723	137	32A
0005434066487	7723	138	32E
0005434066479	7723	139	32G
0005432525962	7723	140	33B
0005432150074	7723	141	33A
0005434066501	7723	142	32K
0005432525945	7723	143	33D
0005432525940	7723	144	33H
0005432525963	7723	145	33G
0005432525913	7723	146	33K
0005432525944	7723	147	34C
0005432525955	7723	148	34D
0005432525925	7723	149	34G
0005434066508	7723	150	34F
0005432525981	7723	151	34K
0005434066441	7723	152	34J
0005434066451	7723	153	34H
0005432525941	7723	154	35B
0005432526014	7723	155	35D
0005434066467	7723	156	35C
0005432069424	7723	157	35J
0005432525924	7723	158	35G
0005434066444	7723	159	35K
0005434066506	7723	160	36B
0005434066463	7723	161	36E
0005434066484	7723	162	36D
0005432525988	7723	163	36K
0005432150071	7723	164	37B
0005432526002	7723	165	37D
0005432526007	7723	166	37G
0005434066482	7723	167	37F
0005434066472	7723	168	37J
0005434066474	7723	169	38A
0005432525952	7723	170	37K
0005432525971	7723	171	38H
0005434066502	7723	172	38J
0005432525991	7723	173	39B
0005432525921	7723	174	39A
0005434066477	7723	175	38K
0005432150073	7723	176	39D
0005432525993	7723	177	39C
0005432525977	7723	178	39G
0005432526013	7723	179	39E
0005432526029	7723	180	39J
0005432537024	7723	181	40D
0005434066498	7723	182	40G
0005434066456	7723	183	40J
0005432533248	7723	184	41B
0005432526010	7723	185	41D
0005432525916	7723	186	41C
0005432069430	7723	187	41F
0005432525927	7723	188	41E
0005432525919	7723	189	41H
0005432525917	7723	190	41K
0005434066494	7723	191	41J
0005432525983	7723	192	42C
0005432525920	7723	193	42B
0005432525996	7723	194	42E
0005432525961	7723	195	42H
0005432525932	7723	196	42F
0005434066455	7723	197	42J
0005432428877	7723	198	43B
0005432525985	7723	199	43C
0005434066481	7723	200	43E
0005432535756	7723	201	43J
0005432525954	7723	202	43H
0005432526008	7723	203	43K
0005432150072	7723	204	44B
0005432525956	7723	205	44D
0005432526009	7723	206	44H
0005432525990	7723	207	44G
0005432525970	7723	208	44K
0005434066511	7723	209	45B
0005434066497	7723	210	45F
0005432525969	7723	211	45E
0005432525930	7723	212	45G
0005434066449	7723	213	46A
0005432526017	7723	214	46F
0005432525960	7723	215	46J
0005432525934	7723	216	46H
0005432525923	7723	217	47A
0005432535759	7723	218	46K
0005432526021	7723	219	47E
0005432525951	7723	220	47D
0005434066500	7723	221	47G
0005432525978	7723	222	47F
0005434066505	7723	223	48F
0005432150075	7723	224	48K
0005434066510	7723	225	49E
0005434066504	7723	226	49D
0005432525908	7723	227	49C
0005432525904	7723	228	49G
0005434066446	7723	229	49F
0005434066452	7723	230	49H
0005432525946	7723	231	50C
0005432525939	7723	232	49K
0005432525909	7723	233	50E
0005432526016	7723	234	50D
0005432537023	7723	235	50G
0005432525953	7723	236	51F
0005434066461	7723	237	51E
0005432525931	7723	238	51D
0005432069428	7723	239	51G
0005432132982	5305	1	1G
0005434573143	5305	2	1H
0005435611891	5305	3	2H
0005435611946	5305	4	2G
0005435611964	5305	5	2D
0005434343654	5305	6	3C
0005435611919	5305	7	3A
0005435611978	5305	8	2K
0005434343666	5305	9	3G
0005435611917	5305	10	3K
0005434343672	5305	11	4D
0005435611971	5305	12	5C
0005435097062	5305	13	5H
0005435611924	5305	14	5G
0005434343677	5305	15	11D
0005435611983	5305	16	11E
0005434343679	5305	17	11K
0005434573141	5305	18	11H
0005435611961	5305	19	12C
0005435097061	5305	20	12F
0005435611896	5305	21	12E
0005435611948	5305	22	12D
0005435490176	5305	23	13A
0005435611906	5305	24	13F
0005434343678	5305	25	13E
0005432047493	5305	26	13D
0005435611951	5305	27	13G
0005434573135	5305	28	14A
0005434573140	5305	29	14E
0005435611879	5305	30	14D
0005435611979	5305	31	14G
0005434573136	5305	32	14H
0005435611895	5305	33	15A
0005434343670	5305	34	15D
0005435611936	5305	35	16A
0005435611888	5305	36	15K
0005435423603	5305	37	15H
0005432132974	5305	38	16D
0005434343684	5305	39	16E
0005435555337	5305	40	16K
0005432132976	5305	41	17E
0005435611928	5305	42	17D
0005435555336	5305	43	17G
0005435611959	5305	44	18D
0005434343673	5305	45	18C
0005434343664	5305	46	18F
0005435611882	5305	47	18J
0005434343658	5305	48	18H
0005435611965	5305	49	19B
0005434343653	5305	50	18K
0005435611933	5305	51	19E
0005435611981	5305	52	19H
0005432132972	5305	53	19K
0005435097065	5305	54	20C
0005435611954	5305	55	20E
0005434343685	5305	56	20D
0005432132980	5305	57	20H
0005435611908	5305	58	20G
0005435423636	5305	59	21A
0005434343665	5305	60	21C
0005434343675	5305	61	21F
0005435611957	5305	62	21E
0005435611911	5305	63	21J
0005435611922	5305	64	22A
0005432132981	5305	65	21K
0005432047492	5305	66	22B
0005434573142	5305	67	22D
0005435611913	5305	68	22H
0005435611877	5305	69	22G
0005435611909	5305	70	22K
0005435611966	5305	71	22J
0005435611907	5305	72	23B
0005435611943	5305	73	23A
0005435611956	5305	74	23D
0005435611982	5305	75	23F
0005435611898	5305	76	23H
0005435611883	5305	77	23G
0005434343651	5305	78	23K
0005435611925	5305	79	24F
0005435611926	5305	80	24E
0005434573133	5305	81	24G
0005435611880	5305	82	25D
0005435611955	5305	83	25G
0005435611890	5305	84	26E
0005435611885	5305	85	26D
0005435611973	5305	86	26H
0005435097066	5305	87	26G
0005434343663	5305	88	26F
0005434343674	5305	89	26J
0005434573130	5305	90	27B
0005435491409	5305	91	26K
0005435611984	5305	92	27D
0005435611901	5305	93	27H
0005435611927	5305	94	27G
0005435611900	5305	95	28A
0005435611967	5305	96	27K
0005434573138	5305	97	28C
0005435611914	5305	98	28B
0005434343681	5305	99	28F
0005435611892	5305	100	28K
0005435490175	5305	101	28J
0005434343680	5305	102	30A
0005435611970	5305	103	30C
0005435611953	5305	104	30B
0005435611889	5305	105	30E
0005435611975	5305	106	30K
0005434573132	5305	107	30J
0005432132978	5305	108	31B
0005435611938	5305	109	31A
0005435611941	5305	110	31C
0005434573137	5305	111	31E
0005435611949	5305	112	31D
0005435611920	5305	113	31K
0005435611931	5305	114	32C
0005434343668	5305	115	32D
0005435611963	5305	116	32G
0005435611899	5305	117	32F
0005435611972	5305	118	32J
0005432132977	5305	119	32H
0005434573139	5305	120	32K
0005432132983	5305	121	33E
0005435611916	5305	122	33H
0005435611939	5305	123	33G
0005435611934	5305	124	33J
0005435611912	5305	125	34A
0005435611893	5305	126	34F
0005434343662	5305	127	35D
0005432047494	5305	128	35F
0005435097068	5305	129	35H
0005435097063	5305	130	35G
0005434343657	5305	131	36C
0005435423635	5305	132	36B
0005435097064	5305	133	36K
0005435611897	5305	134	37D
0005435611980	5305	135	37F
0005432132975	5305	136	38A
0005434343661	5305	137	37K
0005435611947	5305	138	37J
0005435611944	5305	139	38C
0005435611950	5305	140	39E
0005435611969	5305	141	39H
0005435611968	5305	142	40A
0005435611905	5305	143	39K
0005435611942	5305	144	40C
0005434343656	5305	145	40D
0005434343671	5305	146	40F
0005435611958	5305	147	41B
0005435611881	5305	148	41D
0005435611902	5305	149	41E
0005434573131	5305	150	41H
0005434343652	5305	151	42C
0005435611929	5305	152	42B
0005432132973	5305	153	42A
0005435611918	5305	154	42E
0005432132985	5305	155	42K
0005435611930	5305	156	42H
0005435491408	5305	157	43A
0005435611923	5305	158	43D
0005435611940	5305	159	43E
0005435097067	5305	160	44H
0005435490174	5305	161	44G
0005435611977	5305	162	44F
0005434343676	5305	163	44K
0005435423602	5305	164	44J
0005435611962	5305	165	45A
0005435611960	5305	166	45C
0005432132986	5305	167	45H
0005434343683	5305	168	45J
0005432132984	5305	169	46C
0005435611945	5305	170	46B
0005435611935	5305	171	46E
0005435611884	5305	172	46J
0005435611878	5305	173	46H
0005435611921	5305	174	47C
0005435097060	5305	175	47A
0005434343667	5305	176	46K
0005435611932	5305	177	47D
0005435611903	5305	178	47E
0005432132979	5305	179	47K
0005435611894	5305	180	48C
0005435611910	5305	181	48A
0005435611976	5305	182	48E
0005435611974	5305	183	48G
0005434343660	5305	184	49A
0005435611887	5305	185	49C
0005434343659	5305	186	49F
0005435611904	5305	187	49E
0005435611886	5305	188	49K
0005434343669	5305	189	49H
0005435611876	5305	190	50C
0005435611937	5305	191	50A
0005434343655	5305	192	50E
0005435611915	5305	193	50D
0005434573134	5305	194	50G
0005435611952	5305	195	50K
0005434343682	5305	196	50H
0005435423746	10910	1	1K
0005435042825	10910	2	3D
0005435423763	10910	3	4G
0005434244527	10910	4	4H
0005435423780	10910	5	5D
0005432164920	10910	6	11A
0005435423724	10910	7	11H
0005433719089	10910	8	12C
0005432164919	10910	9	12A
0005435423778	10910	10	12K
0005435423733	10910	11	13E
0005432166852	10910	12	13G
0005434244529	10910	13	14D
0005435423742	10910	14	14F
0005435423757	10910	15	15C
0005435423764	10910	16	15A
0005435423772	10910	17	15E
0005434244519	10910	18	16G
0005434244532	10910	19	17A
0005435304097	10910	20	16K
0005435423768	10910	21	17E
0005435423717	10910	22	18A
0005435319437	10910	23	17H
0005435423752	10910	24	18B
0005435423785	10910	25	18J
0005433719091	10910	26	18K
0005435423781	10910	27	19G
0005435423759	10910	28	20C
0005434244540	10910	29	20D
0005435042824	10910	30	20G
0005435423767	10910	31	21D
0005435423761	10910	32	21F
0005435423730	10910	33	21E
0005432166851	10910	34	22B
0005435423750	10910	35	22D
0005434244517	10910	36	22H
0005435423734	10910	37	22G
0005432164917	10910	38	23C
0005434244521	10910	39	23H
0005435423744	10910	40	24D
0005434244524	10910	41	23K
0005435423740	10910	42	24E
0005435423783	10910	43	24G
0005434244531	10910	44	25D
0005435423762	10910	45	25F
0005434244536	10910	46	25G
0005435423729	10910	47	26B
0005432166850	10910	48	26G
0005432164918	10910	49	26K
0005435423749	10910	50	26J
0005434244542	10910	51	26H
0005434244541	10910	52	27B
0005435423718	10910	53	27A
0005435423758	10910	54	27C
0005435319440	10910	55	27F
0005434244530	10910	56	27H
0005435423784	10910	57	28B
0005434244526	10910	58	28D
0005435319433	10910	59	28C
0005434244533	10910	60	28G
0005435423723	10910	61	28F
0005435423735	10910	62	28H
0005435423766	10910	63	29B
0005435423777	10910	64	28K
0005435423716	10910	65	29F
0005435423751	10910	66	30F
0005434244538	10910	67	30K
0005432363365	10910	68	31D
0005435423760	10910	69	31F
0005435423722	10910	70	31G
0005434244543	10910	71	32E
0005435319436	10910	72	32H
0005435423721	10910	73	33B
0005435423786	10910	74	33A
0005435423756	10910	75	33F
0005434244539	10910	76	33E
0005434244523	10910	77	34C
0005432363366	10910	78	34A
0005435423726	10910	79	34J
0005435423753	10910	80	34H
0005435423743	10910	81	35D
0005432840980	10910	82	35G
0005433719088	10910	83	35F
0005434244515	10910	84	35K
0005435423745	10910	85	36C
0005435423776	10910	86	36B
0005435319432	10910	87	36D
0005433719090	10910	88	36H
0005432164923	10910	89	37D
0005435423770	10910	90	37C
0005435423748	10910	91	37G
0005434244534	10910	92	38A
0005432164921	10910	93	38J
0005435423737	10910	94	38H
0005435423732	10910	95	39C
0005434244522	10910	96	39J
0005435423774	10910	97	39G
0005435319438	10910	98	40A
0005435423773	10910	99	39K
0005435423739	10910	100	40B
0005435423782	10910	101	40E
0005435423754	10910	102	40D
0005435423736	10910	103	40H
0005435423779	10910	104	41B
0005435423765	10910	105	40K
0005435423775	10910	106	41C
0005432164922	10910	107	41F
0005435304098	10910	108	41J
0005432840981	10910	109	42C
0005434244516	10910	110	42E
0005434244518	10910	111	42D
0005435423727	10910	112	42G
0005435423741	10910	113	42J
0005435319435	10910	114	44A
0005434244528	10910	115	44C
0005434656525	10910	116	44K
0005435423747	10910	117	44H
0005432840982	10910	118	45C
0005435423755	10910	119	46E
0005435319434	10910	120	46H
0005434244535	10910	121	47A
0005435423725	10910	122	47D
0005434244537	10910	123	47G
0005435423769	10910	124	47F
0005435423731	10910	125	47E
0005435423720	10910	126	48C
0005434244525	10910	127	48E
0005435423738	10910	128	49D
0005435319439	10910	129	49C
0005435423728	10910	130	49H
0005434244520	10910	131	50C
0005434656524	10910	132	50E
0005435423719	10910	133	50D
0005435423771	10910	134	50G
0005432181366	3246	1	1A
0005432181374	3246	2	1C
0005433506902	3246	3	1D
0005433633287	3246	4	2A
0005432181370	3246	5	2C
0005433804838	3246	6	2F
0005433804852	3246	7	3D
0005432181377	3246	8	4A
0005433804849	3246	9	3F
0005432181373	3246	10	4C
0005433633313	3246	11	4D
0005433804840	3246	12	5A
0005433506898	3246	13	5C
0005433506903	3246	14	5F
0005433506910	3246	15	6A
0005433633301	3246	16	6F
0005433633316	3246	17	6D
0005432181384	3246	18	7D
0005432181379	3246	19	8A
0005433804853	3246	20	8B
0005432181386	3246	21	8D
0005433633310	3246	22	8C
0005433506911	3246	23	8E
0005433804846	3246	24	9B
0005433633288	3246	25	9A
0005433804847	3246	26	9C
0005433506908	3246	27	9D
0005433633308	3246	28	9E
0005432181383	3246	29	10A
0005433633302	3246	30	9F
0005433804851	3246	31	10B
0005433804834	3246	32	10C
0005433804850	3246	33	10D
0005433804857	3246	34	10F
0005433633291	3246	35	11B
0005432181381	3246	36	11A
0005433804854	3246	37	11C
0005433633290	3246	38	12A
0005433804856	3246	39	12B
0005432181367	3246	40	12D
0005433506909	3246	41	12F
0005433633303	3246	42	12E
0005433633294	3246	43	13A
0005433633297	3246	44	13D
0005433633311	3246	45	13E
0005433506900	3246	46	14A
0005433506904	3246	47	14B
0005432181368	3246	48	14D
0005432181372	3246	49	14E
0005433633283	3246	50	15C
0005433633317	3246	51	15F
0005433804858	3246	52	15E
0005433633292	3246	53	16A
0005433633286	3246	54	16B
0005433804836	3246	55	16F
0005433506905	3246	56	17B
0005433633300	3246	57	17C
0005433506907	3246	58	17E
0005433633309	3246	59	18A
0005433506892	3246	60	18D
0005433633295	3246	61	18C
0005433804835	3246	62	18F
0005433804832	3246	63	19C
0005432181382	3246	64	19E
0005432181385	3246	65	20F
0005433804842	3246	66	21B
0005433633306	3246	67	21C
0005433506906	3246	68	21E
0005433506896	3246	69	22A
0005433506893	3246	70	21F
0005433633299	3246	71	22B
0005433804848	3246	72	23A
0005433804830	3246	73	23C
0005432181364	3246	74	23D
0005433633296	3246	75	23F
0005433633304	3246	76	24C
0005432181376	3246	77	24D
0005432181375	3246	78	24F
0005433804839	3246	79	24E
0005433804855	3246	80	25D
0005433633315	3246	81	25C
0005433804845	3246	82	26A
0005433633289	3246	83	25F
0005433804841	3246	84	26B
0005433506891	3246	85	26D
0005433633314	3246	86	26F
0005433804837	3246	87	27A
0005433633285	3246	88	27C
0005433633312	3246	89	27B
0005432181371	3246	90	27F
0005433633293	3246	91	27E
0005433633305	3246	92	28D
0005433633298	3246	93	28C
0005433804843	3246	94	28E
0005433804831	3246	95	28F
0005433804833	3246	96	29B
0005433506901	3246	97	29A
0005432181378	3246	98	29C
0005433506899	3246	99	29E
0005433804844	3246	100	29D
0005433506897	3246	101	30C
0005432181380	3246	102	30B
0005433804829	3246	103	30D
0005432181365	3246	104	30F
0005433633307	3246	105	31B
0005433633284	3246	106	31A
0005433506895	3246	107	31C
0005433506894	3246	108	31D
0005432181369	3246	109	31E
0005435884392	3247	1	7C
0005435884408	3247	2	14F
0005435884393	3247	3	19E
0005435884409	3247	4	25D
0005435884391	3247	5	29B
0005432459106	8287	1	1C
0005432459110	8287	2	1D
0005432459086	8287	3	1F
0005435884524	8287	4	2A
0005432459078	8287	5	2D
0005435884523	8287	6	3A
0005435884521	8287	7	2F
0005435884494	8287	8	3C
0005432042507	8287	9	3D
0005432459088	8287	10	4A
0005432459063	8287	11	4C
0005432459070	8287	12	5A
0005435884506	8287	13	5C
0005435884501	8287	14	5D
0005432459112	8287	15	6C
0005435884497	8287	16	6D
0005432459075	8287	17	7C
0005432042509	8287	18	8E
0005435884505	8287	19	8F
0005432459101	8287	20	9A
0005432459073	8287	21	9C
0005435884509	8287	22	9B
0005432459100	8287	23	9F
0005432459077	8287	24	9E
0005435884484	8287	25	10A
0005435884498	8287	26	10B
0005435884525	8287	27	10C
0005435884516	8287	28	10E
0005432459091	8287	29	11B
0005435884504	8287	30	11C
0005435884486	8287	31	11E
0005435884485	8287	32	11D
0005432042503	8287	33	11F
0005435884496	8287	34	12C
0005432459065	8287	35	12D
0005432459089	8287	36	12E
0005432459092	8287	37	12F
0005435884507	8287	38	13A
0005432042504	8287	39	13F
0005435884488	8287	40	13E
0005435884499	8287	41	14A
0005435884510	8287	42	14B
0005432042502	8287	43	14D
0005435884500	8287	44	14F
0005432459109	8287	45	15A
0005432459071	8287	46	15C
0005432459102	8287	47	15B
0005434312287	8287	48	15E
0005432042495	8287	49	15D
0005432459098	8287	50	15F
0005435884491	8287	51	16C
0005432459081	8287	52	16B
0005432459080	8287	53	16D
0005432042506	8287	54	16E
0005432042505	8287	55	16F
0005432459067	8287	56	17A
0005432459115	8287	57	17C
0005434312288	8287	58	17F
0005432042501	8287	59	18A
0005432459076	8287	60	18C
0005432459095	8287	61	18E
0005432042496	8287	62	18F
0005435884514	8287	63	19C
0005432042508	8287	64	20A
0005432459093	8287	65	19E
0005432042497	8287	66	20B
0005432042500	8287	67	20D
0005432459084	8287	68	20C
0005435884518	8287	69	20E
0005435884503	8287	70	20F
0005432459087	8287	71	21A
0005435884511	8287	72	21D
0005432459111	8287	73	21C
0005435884495	8287	74	22A
0005432459094	8287	75	21F
0005432459105	8287	76	22B
0005432459104	8287	77	22C
0005435884502	8287	78	22D
0005435884489	8287	79	22E
0005432459103	8287	80	23B
0005432459108	8287	81	23C
0005435884493	8287	82	23D
0005435884517	8287	83	24A
0005432459107	8287	84	24B
0005432459099	8287	85	24C
0005432459090	8287	86	24E
0005432459066	8287	87	24D
0005435884519	8287	88	24F
0005435884492	8287	89	25A
0005432459083	8287	90	25C
0005432459074	8287	91	25B
0005435884483	8287	92	25D
0005432459079	8287	93	25E
0005432459097	8287	94	26A
0005435884520	8287	95	26D
0005435884487	8287	96	26F
0005432459068	8287	97	27A
0005432459085	8287	98	27D
0005432459113	8287	99	27F
0005432459064	8287	100	27E
0005432459069	8287	101	28B
0005435884522	8287	102	28D
0005435884513	8287	103	29A
0005435884512	8287	104	28F
0005432459114	8287	105	29C
0005435884490	8287	106	29D
0005435884508	8287	107	29E
0005432042498	8287	108	30A
0005432042499	8287	109	30B
0005432459082	8287	110	30E
0005435884482	8287	111	30F
0005435884515	8287	112	31C
0005432459072	8287	113	31B
0005432459096	8287	114	31E
0005432727752	4603	1	1C
0005433194822	4603	2	1D
0005432382598	4603	3	2A
0005432382581	4603	4	2C
0005432382570	4603	5	2D
0005432382576	4603	6	2F
0005432382588	4603	7	3A
0005432382601	4603	8	4A
0005433453731	4603	9	4D
0005432382604	4603	10	4E
0005432727745	4603	11	4F
0005432727741	4603	12	5A
0005432382591	4603	13	5C
0005433194821	4603	14	5E
0005432727743	4603	15	5F
0005432382571	4603	16	6A
0005432382575	4603	17	6C
0005432382577	4603	18	6D
0005432382589	4603	19	6E
0005433194823	4603	20	7C
0005432382578	4603	21	7D
0005432382599	4603	22	7F
0005432382580	4603	23	8A
0005432727750	4603	24	8C
0005432727753	4603	25	8D
0005432382565	4603	26	9A
0005432382596	4603	27	9C
0005432382600	4603	28	9E
0005433453732	4603	29	10E
0005432382568	4603	30	10F
0005432382592	4603	31	11A
0005432382566	4603	32	11C
0005432382595	4603	33	11D
0005432727742	4603	34	11F
0005433453730	4603	35	12A
0005432727751	4603	36	12D
0005433722119	4603	37	12E
0005432382586	4603	38	12F
0005432382572	4603	39	13A
0005432382585	4603	40	13C
0005432382587	4603	41	13D
0005433722118	4603	42	13E
0005432382567	4603	43	14A
0005433454841	4603	44	14C
0005432382579	4603	45	14D
0005432382574	4603	46	14E
0005432727748	4603	47	14F
0005432382597	4603	48	15A
0005432382573	4603	49	15D
0005432382590	4603	50	16A
0005432382582	4603	51	16D
0005432382594	4603	52	16E
0005432382593	4603	53	16F
0005433722120	4603	54	17A
0005432382602	4603	55	17C
0005432382583	4603	56	17D
0005432382605	4603	57	17F
0005432727744	4603	58	18C
0005432382584	4603	59	18D
0005432727747	4603	60	18F
0005432382564	4603	61	19C
0005432727746	4603	62	19D
0005433454842	4603	63	19E
0005433194820	4603	64	19F
0005432382569	4603	65	20C
0005432727749	4603	66	20D
0005432382603	4603	67	20E
0005432727754	4603	68	20F
0005433516748	1729	1	1C
0005435528926	1729	2	1D
0005435540684	1729	3	2A
0005433516743	1729	4	2C
0005435540689	1729	5	2D
0005435528923	1729	6	3A
0005435540678	1729	7	3D
0005432294452	1729	8	4D
0005435528935	1729	9	4F
0005435540669	1729	10	5C
0005435528924	1729	11	5D
0005435528941	1729	12	5E
0005433516744	1729	13	5F
0005435540674	1729	14	6A
0005435540682	1729	15	6C
0005435528929	1729	16	6D
0005435540668	1729	17	6E
0005435540672	1729	18	6F
0005435528945	1729	19	7C
0005435540679	1729	20	7D
0005435540685	1729	21	7E
0005433516746	1729	22	7F
0005435540683	1729	23	8C
0005435540670	1729	24	8D
0005435540673	1729	25	9A
0005435528940	1729	26	9D
0005435528928	1729	27	10A
0005433516747	1729	28	10C
0005435540667	1729	29	10E
0005435528927	1729	30	11C
0005435528936	1729	31	11D
0005435528937	1729	32	11E
0005435540688	1729	33	11F
0005435528944	1729	34	12A
0005435528938	1729	35	12D
0005435528922	1729	36	13A
0005435540676	1729	37	13C
0005432294451	1729	38	13D
0005435528939	1729	39	13E
0005435528942	1729	40	14F
0005432294450	1729	41	15C
0005435540671	1729	42	15D
0005433516742	1729	43	15E
0005435540675	1729	44	15F
0005435528932	1729	45	16C
0005433516740	1729	46	16D
0005435528925	1729	47	16E
0005433516745	1729	48	16F
0005435540686	1729	49	17A
0005435540687	1729	50	17C
0005435540681	1729	51	17E
0005435528946	1729	52	17F
0005435528943	1729	53	18C
0005435540680	1729	54	18D
0005435540677	1729	55	18E
0005435528931	1729	56	19A
0005433516741	1729	57	19C
0005435528933	1729	58	19D
0005435528930	1729	59	19F
0005435528934	1729	60	20A
0005432924963	22011	1	1F
0005432924965	22011	2	8D
0005432924961	22011	3	10A
0005432924964	22011	4	12A
0005432924966	22011	5	16C
0005432924962	22011	6	16D
0005434458486	7377	1	1A
0005434458495	7377	2	1C
0005432838547	7377	3	1F
0005432823417	7377	4	2F
0005432838575	7377	5	3A
0005432823418	7377	6	3C
0005432838566	7377	7	4A
0005432840979	7377	8	4C
0005434458479	7377	9	5A
0005434458488	7377	10	5F
0005434458485	7377	11	6A
0005432838572	7377	12	6C
0005432838552	7377	13	6E
0005432073338	7377	14	7D
0005432838555	7377	15	7E
0005434458494	7377	16	7F
0005432838546	7377	17	8A
0005432838554	7377	18	8C
0005432838549	7377	19	8E
0005432838563	7377	20	9C
0005434458478	7377	21	9E
0005432838553	7377	22	9F
0005434458482	7377	23	10A
0005432838571	7377	24	10E
0005432838573	7377	25	10F
0005434458489	7377	26	11D
0005432073336	7377	27	11E
0005434458491	7377	28	11F
0005432838561	7377	29	12A
0005432838560	7377	30	12C
0005432838574	7377	31	12D
0005434458487	7377	32	12E
0005432838562	7377	33	12F
0005432838556	7377	34	13A
0005432838568	7377	35	13C
0005434458477	7377	36	13D
0005434458492	7377	37	13E
0005432840977	7377	38	14A
0005434458483	7377	39	14C
0005432838569	7377	40	14D
0005432838557	7377	41	14E
0005432073337	7377	42	15A
0005432823416	7377	43	15C
0005432838545	7377	44	15E
0005434458493	7377	45	16C
0005434458480	7377	46	16E
0005432838558	7377	47	16F
0005432838565	7377	48	17C
0005432838564	7377	49	17E
0005434458484	7377	50	17F
0005432838559	7377	51	18C
0005434458490	7377	52	18D
0005432840978	7377	53	18E
0005434458476	7377	54	19A
0005434458496	7377	55	19C
0005432838570	7377	56	19D
0005432838550	7377	57	19E
0005432838548	7377	58	19F
0005432838567	7377	59	20A
0005434458481	7377	60	20D
0005432838551	7377	61	20E
0005432000991	28913	1	1D
0005435252431	28913	2	3C
0005435252422	28913	3	3F
0005435252424	28913	4	4D
0005435252418	28913	5	4E
0005432000992	28913	6	5F
0005435252429	28913	7	6D
0005435252420	28913	8	7D
0005435252432	28913	9	8A
0005435252419	28913	10	8C
0005435252427	28913	11	8D
0005435491411	28913	12	9C
0005435252423	28913	13	11D
0005435252421	28913	14	13E
0005435252430	28913	15	15D
0005435491410	28913	16	15E
0005435252433	28913	17	15F
0005435252426	28913	18	16C
0005435252425	28913	19	16E
0005435252434	28913	20	17F
0005434664925	28913	21	18C
0005435491412	28913	22	18D
0005435252428	28913	23	19C
0005432000993	28913	24	19E
0005435990514	8810	1	4C
0005435990518	8810	2	7A
0005435990515	8810	3	8B
0005435990516	8810	4	9E
0005435990513	8810	5	18C
0005435990517	8810	6	18E
0005434275939	15733	1	9B
0005434275938	15733	2	13E
0005434275941	15733	3	17E
0005434275940	15733	4	19F
0005433468194	2083	1	1C
0005433468195	2083	2	2A
0005433468198	2083	3	2C
0005433468203	2083	4	3B
0005433468200	2083	5	3D
0005433468206	2083	6	4A
0005433468190	2083	7	4C
0005433468197	2083	8	6A
0005433468202	2083	9	6D
0005433468201	2083	10	7B
0005433468193	2083	11	7C
0005433468205	2083	12	18C
0005433468196	2083	13	19A
0005433468204	2083	14	19C
0005433468192	2083	15	20C
0005433468189	2083	16	20D
0005433468191	2083	17	21A
0005433468199	2083	18	23A
0005432909206	23838	1	1C
0005432909200	23838	2	1D
0005432909204	23838	3	2B
0005432909197	23838	4	3D
0005432909196	23838	5	5A
0005432909191	23838	6	6A
0005432909194	23838	7	7A
0005432909195	23838	8	7D
0005432909198	23838	9	18B
0005432909193	23838	10	18C
0005432909189	23838	11	18D
0005432909205	23838	12	20A
0005432909190	23838	13	20B
0005432909202	23838	14	20C
0005432909201	23838	15	20D
0005432909199	23838	16	21D
0005432909203	23838	17	23A
0005432909192	23838	18	22D
0005432359622	6363	1	1A
0005432359621	6363	2	1D
0005432359636	6363	3	1F
0005432359637	6363	4	2C
0005432359611	6363	5	3C
0005432359642	6363	6	4B
0005432363366	6363	7	4D
0005432359630	6363	8	4E
0005432335850	6363	9	5A
0005432359643	6363	10	5D
0005432359645	6363	11	5E
0005432359639	6363	12	5F
0005432062144	6363	13	6A
0005432359632	6363	14	6C
0005432359648	6363	15	6E
0005432359614	6363	16	6D
0005432359617	6363	17	6F
0005432363365	6363	18	7C
0005432359608	6363	19	7D
0005432359627	6363	20	7F
0005432359635	6363	21	7E
0005432359629	6363	22	8A
0005432359631	6363	23	8F
0005432359626	6363	24	9C
0005432359610	6363	25	9E
0005432359623	6363	26	10C
0005432335849	6363	27	10E
0005432359628	6363	28	11C
0005432359607	6363	29	11B
0005432359606	6363	30	11D
0005432359634	6363	31	11F
0005432359640	6363	32	11E
0005432335857	6363	33	12A
0005432359612	6363	34	12C
0005432359644	6363	35	13D
0005432335856	6363	36	13C
0005432335846	6363	37	14A
0005432062146	6363	38	14D
0005432359649	6363	39	15C
0005432359641	6363	40	16B
0005432062147	6363	41	16A
0005432335848	6363	42	16C
0005432359625	6363	43	16E
0005432335855	6363	44	16D
0005432062150	6363	45	17A
0005432335845	6363	46	16F
0005432359647	6363	47	17B
0005432359615	6363	48	17E
0005432062149	6363	49	18D
0005432359618	6363	50	18C
0005432359613	6363	51	18F
0005432359638	6363	52	19A
0005432359619	6363	53	19B
0005432359651	6363	54	19D
0005432359652	6363	55	19F
0005432359609	6363	56	20A
0005432335851	6363	57	20C
0005432359624	6363	58	20E
0005432335854	6363	59	20D
0005432062145	6363	60	21B
0005432335847	6363	61	21A
0005432359633	6363	62	21D
0005432359653	6363	63	21E
0005432335853	6363	64	21F
0005432359616	6363	65	22E
0005432359620	6363	66	23A
0005432359646	6363	67	23D
0005432359650	6363	68	23C
0005432335852	6363	69	23E
0005432062148	6363	70	23F
0005435176662	21041	1	1D
0005435176664	21041	2	1C
0005435176643	21041	3	1F
0005435176653	21041	4	3D
0005435176649	21041	5	4B
0005434149546	21041	6	4A
0005434149549	21041	7	4C
0005435176656	21041	8	4D
0005435176642	21041	9	4E
0005435176644	21041	10	5A
0005435176668	21041	11	5C
0005434149550	21041	12	5D
0005434149545	21041	13	5E
0005435176647	21041	14	6A
0005435490179	21041	15	6F
0005435490178	21041	16	7B
0005435176648	21041	17	7A
0005435176659	21041	18	7E
0005432052699	21041	19	8A
0005435723015	21041	20	8B
0005435176665	21041	21	8D
0005435176663	21041	22	8E
0005434149547	21041	23	9B
0005434149551	21041	24	9F
0005435176657	21041	25	10C
0005434149556	21041	26	10E
0005435176667	21041	27	11A
0005435176655	21041	28	11D
0005434149555	21041	29	11E
0005432052700	21041	30	11F
0005435723013	21041	31	12A
0005435176652	21041	32	12E
0005434149548	21041	33	12F
0005435176646	21041	34	13E
0005435176645	21041	35	14A
0005435176661	21041	36	14C
0005435723014	21041	37	15D
0005435490180	21041	38	16F
0005435176669	21041	39	18F
0005435176666	21041	40	18E
0005435490177	21041	41	19F
0005435176660	21041	42	20B
0005434149553	21041	43	20C
0005434149544	21041	44	21C
0005434149552	21041	45	21D
0005435176658	21041	46	22A
0005434149554	21041	47	21F
0005435176654	21041	48	22E
0005435176651	21041	49	23C
0005435176650	21041	50	23D
0005434186154	17694	1	6A
0005434186153	17694	2	6C
0005434186155	17694	3	6D
0005434186156	17694	4	19A
0005434458476	29115	1	1A
0005434448259	29115	2	1B
0005434458494	29115	3	1C
0005434458484	29115	4	2C
0005434458486	29115	5	2D
0005434458487	29115	6	3B
0005434463894	29115	7	3D
0005434448257	29115	8	4A
0005434458477	29115	9	4C
0005434458496	29115	10	4D
0005434458485	29115	11	5A
0005434458495	29115	12	5B
0005434463893	29115	13	5C
0005434462754	29115	14	6D
0005434463895	29115	15	7A
0005434458482	29115	16	7D
0005434458480	29115	17	18B
0005434458483	29115	18	18C
0005434458478	29115	19	18D
0005434458488	29115	20	19A
0005434458492	29115	21	19B
0005434448260	29115	22	19D
0005434458479	29115	23	20A
0005434448258	29115	24	20B
0005434458491	29115	25	20C
0005434458490	29115	26	20D
0005434462755	29115	27	22A
0005434458481	29115	28	22C
0005434458489	29115	29	22D
0005434458493	29115	30	23B
0005432603717	21469	1	1B
0005432603716	21469	2	1C
0005432603699	21469	3	1D
0005432603704	21469	4	2A
0005432603720	21469	5	2B
0005432603683	21469	6	2C
0005432603695	21469	7	2D
0005432603706	21469	8	3A
0005432603703	21469	9	3B
0005432603697	21469	10	3C
0005432603718	21469	11	3D
0005432603709	21469	12	4A
0005432603719	21469	13	4B
0005432603686	21469	14	4C
0005432603708	21469	15	5B
0005432603701	21469	16	5C
0005432603693	21469	17	6A
0005432603711	21469	18	6B
0005432603712	21469	19	6C
0005432603684	21469	20	6D
0005432603700	21469	21	7A
0005432603713	21469	22	7B
0005432603691	21469	23	7D
0005432603715	21469	24	18A
0005432603714	21469	25	18D
0005432603682	21469	26	19A
0005432603696	21469	27	19B
0005432603692	21469	28	20A
0005432603687	21469	29	20B
0005432603722	21469	30	20C
0005432603698	21469	31	20D
0005432603705	21469	32	21A
0005432603721	21469	33	21B
0005432603702	21469	34	21C
0005432603710	21469	35	21D
0005432603707	21469	36	22A
0005432603685	21469	37	22B
0005432603690	21469	38	22C
0005432603694	21469	39	23A
0005432603689	21469	40	22D
0005432603688	21469	41	23B
0005435221498	31659	1	2B
0005435221500	31659	2	2C
0005435221037	31659	3	20B
0005435221499	31659	4	22A
0005433293148	29611	1	1A
0005433293155	29611	2	2C
0005433293150	29611	3	2D
0005433293149	29611	4	3A
0005433293158	29611	5	3D
0005433293152	29611	6	4B
0005433293154	29611	7	5B
0005433293161	29611	8	5C
0005433293157	29611	9	6B
0005433293159	29611	10	6C
0005433293162	29611	11	6D
0005433293151	29611	12	7D
0005433293153	29611	13	20B
0005433293156	29611	14	21B
0005433293160	29611	15	22A
0005433293163	29611	16	22D
0005433473113	6678	1	1A
0005433473111	6678	2	2A
0005433473109	6678	3	2B
0005433473110	6678	4	2D
0005433473118	6678	5	3B
0005433473119	6678	6	3C
0005433473121	6678	7	4A
0005433473114	6678	8	6B
0005433473122	6678	9	6C
0005433473126	6678	10	6D
0005433473112	6678	11	7B
0005433473117	6678	12	7D
0005433473125	6678	13	19C
0005433473127	6678	14	19D
0005433473116	6678	15	20A
0005433473120	6678	16	20C
0005433473123	6678	17	21B
0005433473115	6678	18	22A
0005433473124	6678	19	22C
0005435257149	23897	1	1A
0005435257151	23897	2	1B
0005435257153	23897	3	4B
0005435257145	23897	4	4D
0005435257148	23897	5	5D
0005435257147	23897	6	6D
0005435257154	23897	7	7A
0005435257157	23897	8	19A
0005435257144	23897	9	19D
0005435257155	23897	10	20A
0005435257150	23897	11	20B
0005435257143	23897	12	21A
0005435257146	23897	13	21C
0005435257152	23897	14	22C
0005435257156	23897	15	23A
0005434604843	22401	1	1A
0005434606764	22401	2	3A
0005434604844	22401	3	3B
0005434606767	22401	4	4B
0005434604840	22401	5	4A
0005434604842	22401	6	5A
0005434606765	22401	7	5B
0005434606766	22401	8	6A
0005434604841	22401	9	6B
0005434602867	3837	1	1A
0005434602864	3837	2	1D
0005434522380	3837	3	2B
0005434602865	3837	4	2D
0005434602863	3837	5	3C
0005434602862	3837	6	4B
0005434602860	3837	7	4C
0005434602858	3837	8	4D
0005434522381	3837	9	5A
0005434602861	3837	10	5C
0005434522379	3837	11	5D
0005434522383	3837	12	6B
0005434522377	3837	13	7B
0005434602859	3837	14	18A
0005434522386	3837	15	18C
0005434522382	3837	16	19B
0005434522378	3837	17	19C
0005434522385	3837	18	19D
0005434522387	3837	19	20A
0005434522376	3837	20	21D
0005434602866	3837	21	22B
0005434522384	3837	22	23A
0005435904370	19059	1	1D
0005435904369	19059	2	4A
0005435904368	19059	3	4D
0005435904371	19059	4	18A
0005435904366	19059	5	20C
0005435904367	19059	6	21B
0005435904365	19059	7	21C
0005435904372	19059	8	23B
0005432746953	382	1	1A
0005432746962	382	2	1F
0005432746945	382	3	2C
0005432746973	382	4	3A
0005435154583	382	5	3F
0005432753245	382	6	4A
0005432746959	382	7	4D
0005432746968	382	8	4E
0005432219934	382	9	5D
0005435154584	382	10	5E
0005432746972	382	11	5F
0005432746963	382	12	6A
0005432746948	382	13	6F
0005432746969	382	14	7A
0005432746955	382	15	7D
0005432749749	382	16	7F
0005432746954	382	17	8D
0005432746975	382	18	8F
0005432219938	382	19	9A
0005432751473	382	20	9E
0005432219937	382	21	9F
0005432746952	382	22	10C
0005432746956	382	23	10F
0005432746949	382	24	11A
0005432751470	382	25	11C
0005432746971	382	26	11D
0005432746981	382	27	12A
0005432749750	382	28	12C
0005432753246	382	29	13A
0005432746965	382	30	13C
0005432746946	382	31	13F
0005432746979	382	32	14A
0005432746964	382	33	14E
0005435154585	382	34	14F
0005432746970	382	35	15A
0005432746978	382	36	15C
0005432219936	382	37	15D
0005432746967	382	38	15F
0005432746961	382	39	16A
0005432746960	382	40	16C
0005432219935	382	41	16E
0005432746950	382	42	16F
0005432746957	382	43	17A
0005432746977	382	44	17C
0005432746966	382	45	17E
0005432746976	382	46	17F
0005432753247	382	47	18A
0005432746958	382	48	18E
0005432746974	382	49	19A
0005432746980	382	50	19D
0005432751472	382	51	19E
0005432746947	382	52	19F
0005432751471	382	53	20C
0005432746951	382	54	20F
0005432890723	12085	1	1C
0005432890727	12085	2	2C
0005432890728	12085	3	4C
0005433875356	12085	4	5A
0005432890717	12085	5	5C
0005432890711	12085	6	5F
0005434153515	12085	7	6A
0005432890718	12085	8	6F
0005432890721	12085	9	7C
0005432890720	12085	10	10A
0005432890714	12085	11	11A
0005432890712	12085	12	11F
0005432890719	12085	13	12C
0005432890713	12085	14	12F
0005432214769	12085	15	13E
0005432890726	12085	16	14A
0005433875355	12085	17	14E
0005432890715	12085	18	14F
0005432890724	12085	19	15C
0005432890716	12085	20	17E
0005432890722	12085	21	19D
0005432890725	12085	22	19F
0005432890710	12085	23	20A
0005432214770	12085	24	20F
0005433524858	18960	1	1B
0005433533244	18960	2	2C
0005433524865	18960	3	2D
0005433531233	18960	4	3A
0005433524860	18960	5	4A
0005433524867	18960	6	4B
0005433524866	18960	7	5A
0005433524861	18960	8	5B
0005433524869	18960	9	5C
0005433533247	18960	10	6B
0005433524857	18960	11	6D
0005433524868	18960	12	7A
0005433524856	18960	13	7D
0005433524859	18960	14	18A
0005433533246	18960	15	18B
0005433531230	18960	16	18D
0005433524863	18960	17	19C
0005433531232	18960	18	20A
0005433533245	18960	19	20C
0005433524864	18960	20	21A
0005433524862	18960	21	21B
0005433531231	18960	22	22A
0005433531229	18960	23	22B
0005432927897	32484	1	2D
0005432927898	32484	2	3D
0005432927902	32484	3	5B
0005432927899	32484	4	6C
0005432927901	32484	5	7C
0005432927900	32484	6	21B
0005434821646	5302	1	1C
0005434821614	5302	2	1D
0005434558150	5302	3	2D
0005434821661	5302	4	2H
0005434831073	5302	5	2G
0005432396181	5302	6	2K
0005434821579	5302	7	3C
0005432121121	5302	8	3H
0005434831075	5302	9	3G
0005434821580	5302	10	4G
0005432121118	5302	11	4K
0005434821583	5302	12	5D
0005434821635	5302	13	5C
0005434821677	5302	14	5A
0005434821654	5302	15	5G
0005435149825	5302	16	11E
0005434821637	5302	17	12C
0005434821679	5302	18	12A
0005434821698	5302	19	12D
0005434821616	5302	20	12G
0005434821607	5302	21	13A
0005434821652	5302	22	12K
0005434821599	5302	23	12H
0005434821680	5302	24	13D
0005434821629	5302	25	13F
0005434821572	5302	26	13G
0005434821595	5302	27	13K
0005434821673	5302	28	14D
0005434821587	5302	29	14C
0005434821645	5302	30	14F
0005434821669	5302	31	14K
0005434664923	5302	32	15A
0005435149813	5302	33	15F
0005434821641	5302	34	15D
0005434821697	5302	35	16A
0005434821684	5302	36	15K
0005434821648	5302	37	16H
0005434664924	5302	38	17C
0005434821597	5302	39	17A
0005434821658	5302	40	17G
0005434821601	5302	41	17F
0005434821626	5302	42	18A
0005432394040	5302	43	18E
0005435149824	5302	44	18J
0005434821582	5302	45	19A
0005432121117	5302	46	19C
0005434821590	5302	47	19F
0005434821577	5302	48	19H
0005434558153	5302	49	19G
0005434821603	5302	50	19K
0005434821682	5302	51	20C
0005435149817	5302	52	20B
0005434821651	5302	53	20A
0005434821574	5302	54	20E
0005434821624	5302	55	20G
0005434821620	5302	56	20K
0005434821585	5302	57	21A
0005434558149	5302	58	21D
0005434821586	5302	59	21F
0005434821691	5302	60	21G
0005434821605	5302	61	22A
0005432121116	5302	62	22B
0005435149815	5302	63	22E
0005434821578	5302	64	22D
0005434821699	5302	65	22G
0005434821647	5302	66	22K
0005434821666	5302	67	22J
0005434821685	5302	68	23F
0005434828651	5302	69	23H
0005434821619	5302	70	23G
0005434821628	5302	71	23K
0005434821689	5302	72	24G
0005434821664	5302	73	25E
0005434558151	5302	74	25H
0005432121112	5302	75	25G
0005434821692	5302	76	26A
0005434821631	5302	77	25K
0005432121114	5302	78	26C
0005434821694	5302	79	26E
0005435149822	5302	80	26G
0005432121119	5302	81	26F
0005434821676	5302	82	26H
0005432394042	5302	83	27C
0005434821672	5302	84	27F
0005434821592	5302	85	27E
0005434821695	5302	86	27H
0005432121115	5302	87	28C
0005434821611	5302	88	28A
0005434831071	5302	89	28E
0005434558154	5302	90	28F
0005434821674	5302	91	28K
0005434821632	5302	92	28J
0005432396182	5302	93	29A
0005434821623	5302	94	29D
0005434821589	5302	95	29F
0005434821596	5302	96	29E
0005434821653	5302	97	29K
0005435149816	5302	98	29J
0005434821622	5302	99	30B
0005434821591	5302	100	30A
0005434821642	5302	101	30H
0005434821667	5302	102	30G
0005435149820	5302	103	30K
0005434821604	5302	104	31A
0005434821576	5302	105	31G
0005432396180	5302	106	31K
0005434821696	5302	107	32B
0005434821606	5302	108	32A
0005434821675	5302	109	33A
0005434821665	5302	110	33J
0005434821593	5302	111	34B
0005432396179	5302	112	34E
0005434831072	5302	113	35D
0005434821655	5302	114	35J
0005434821687	5302	115	36A
0005434821598	5302	116	36E
0005434664922	5302	117	36H
0005434821693	5302	118	36G
0005434821615	5302	119	36F
0005434821594	5302	120	36K
0005432121122	5302	121	37B
0005434828652	5302	122	37A
0005434821659	5302	123	37F
0005432121120	5302	124	37E
0005434821639	5302	125	37J
0005434821636	5302	126	37G
0005434821613	5302	127	38C
0005434831074	5302	128	38K
0005432394041	5302	129	38J
0005434821668	5302	130	39A
0005435149818	5302	131	39C
0005434821625	5302	132	39F
0005434821571	5302	133	39H
0005434821671	5302	134	39J
0005432394043	5302	135	40A
0005435149826	5302	136	40D
0005434821644	5302	137	40G
0005434821683	5302	138	41A
0005432121113	5302	139	40K
0005434821600	5302	140	41D
0005432121123	5302	141	41C
0005434664921	5302	142	41H
0005434821575	5302	143	42B
0005434821588	5302	144	42A
0005432121124	5302	145	42E
0005434821630	5302	146	42D
0005434821610	5302	147	42H
0005434821612	5302	148	42F
0005434821618	5302	149	42K
0005434821617	5302	150	43A
0005434821662	5302	151	43C
0005434821573	5302	152	43F
0005434821656	5302	153	43E
0005434828653	5302	154	43J
0005434821643	5302	155	44C
0005434821584	5302	156	44B
0005434821690	5302	157	44A
0005434821688	5302	158	44E
0005434821649	5302	159	44G
0005434821633	5302	160	44K
0005434821640	5302	161	44J
0005435149821	5302	162	44H
0005434821657	5302	163	45B
0005435149819	5302	164	45C
0005434821650	5302	165	45H
0005434821670	5302	166	45G
0005434558152	5302	167	46D
0005434821663	5302	168	46C
0005434821678	5302	169	46H
0005434821608	5302	170	46F
0005434821681	5302	171	47A
0005435149814	5302	172	47E
0005434821660	5302	173	47G
0005434821627	5302	174	48H
0005434821609	5302	175	48G
0005434821686	5302	176	48F
0005432121111	5302	177	49E
0005435386455	5302	178	49F
0005434821581	5302	179	50C
0005435149823	5302	180	50A
0005434821638	5302	181	50E
0005434821634	5302	182	50F
0005434821621	5302	183	50K
0005434821602	5302	184	51G
0005435372265	9879	1	1C
0005435372280	9879	2	1A
0005435179688	9879	3	1H
0005435299704	9879	4	2C
0005435372270	9879	5	2A
0005432202953	9879	6	2G
0005435372256	9879	7	3D
0005435372244	9879	8	3K
0005432202955	9879	9	4G
0005435372248	9879	10	5C
0005432202952	9879	11	5A
0005435661885	9879	12	5H
0005435372260	9879	13	11A
0005432823421	9879	14	5K
0005435372236	9879	15	11D
0005435661887	9879	16	11C
0005435372227	9879	17	11F
0005435372232	9879	18	11E
0005435372233	9879	19	12A
0005432202950	9879	20	12E
0005435372259	9879	21	12K
0005435372257	9879	22	12H
0005435372250	9879	23	14A
0005435735069	9879	24	14E
0005435372253	9879	25	14C
0005435372282	9879	26	15C
0005435372243	9879	27	14K
0005435372246	9879	28	15D
0005435372271	9879	29	16A
0005435661889	9879	30	16H
0005435372230	9879	31	17C
0005435735067	9879	32	16K
0005435386472	9879	33	17D
0005435372237	9879	34	18C
0005435372272	9879	35	19H
0005435372228	9879	36	20G
0005435372291	9879	37	21F
0005435299700	9879	38	21J
0005435302124	9879	39	23D
0005435372267	9879	40	24D
0005435372273	9879	41	25C
0005435372290	9879	42	25B
0005435386471	9879	43	26D
0005435299702	9879	44	26F
0005435372266	9879	45	26K
0005435372255	9879	46	26H
0005435386468	9879	47	27B
0005435372264	9879	48	27D
0005432202956	9879	49	28G
0005435372226	9879	50	28F
0005435386467	9879	51	28H
0005435372241	9879	52	29A
0005435299703	9879	53	29D
0005435179383	9879	54	29E
0005435299701	9879	55	29H
0005435302128	9879	56	29G
0005435372276	9879	57	30A
0005435372292	9879	58	29K
0005435735066	9879	59	30D
0005435661888	9879	60	31C
0005435372240	9879	61	31H
0005435302129	9879	62	32A
0005435735065	9879	63	31K
0005435372247	9879	64	32H
0005435372269	9879	65	32G
0005435386470	9879	66	32F
0005435372289	9879	67	33E
0005435179384	9879	68	34G
0005435302125	9879	69	35H
0005435302126	9879	70	35G
0005435372277	9879	71	35K
0005435372284	9879	72	36F
0005435372268	9879	73	37B
0005435372231	9879	74	37D
0005435372252	9879	75	37G
0005435372286	9879	76	38A
0005435372274	9879	77	38H
0005435735068	9879	78	39C
0005435386466	9879	79	39E
0005435372251	9879	80	39D
0005435372238	9879	81	39K
0005435372254	9879	82	40H
0005435372258	9879	83	40K
0005435372235	9879	84	41D
0005435372263	9879	85	41C
0005435372287	9879	86	41J
0005435372279	9879	87	41G
0005432823420	9879	88	41K
0005432823419	9879	89	42G
0005435372275	9879	90	42J
0005435372262	9879	91	42H
0005435372245	9879	92	43J
0005435372242	9879	93	44C
0005435372288	9879	94	44G
0005435372249	9879	95	44J
0005435372239	9879	96	44H
0005435372285	9879	97	44K
0005435372234	9879	98	45D
0005435372283	9879	99	45C
0005435386465	9879	100	45F
0005432202954	9879	101	45J
0005435372261	9879	102	46C
0005432202951	9879	103	46E
0005435372281	9879	104	46H
0005435372278	9879	105	47G
0005432202949	9879	106	48D
0005435661886	9879	107	49A
0005435372229	9879	108	49F
0005435386469	9879	109	49E
0005435302127	9879	110	51E
0005435082662	7020	1	1A
0005435790262	7020	2	1B
0005435082663	7020	3	1C
0005435790263	7020	4	4B
0005435082667	7020	5	6A
0005435082666	7020	6	6B
0005435082669	7020	7	19B
0005435082664	7020	8	20A
0005435790260	7020	9	20B
0005435082665	7020	10	20D
0005435082668	7020	11	22A
0005435790261	7020	12	22C
0005434755807	9553	1	1A
0005434755822	9553	2	1F
0005434755806	9553	3	2D
0005434755793	9553	4	3C
0005434755814	9553	5	4A
0005434755809	9553	6	4D
0005434755785	9553	7	5A
0005434755820	9553	8	5C
0005434755801	9553	9	5D
0005434755796	9553	10	6F
0005434755798	9553	11	7A
0005434755788	9553	12	7D
0005434755783	9553	13	7E
0005434755790	9553	14	8A
0005434755808	9553	15	8E
0005434755819	9553	16	9A
0005434755802	9553	17	9D
0005434755810	9553	18	9E
0005434755792	9553	19	10A
0005434755812	9553	20	10D
0005434755797	9553	21	10F
0005434755804	9553	22	12D
0005434755782	9553	23	12E
0005434755818	9553	24	13C
0005434755800	9553	25	13D
0005434755795	9553	26	13F
0005434755815	9553	27	14C
0005434755786	9553	28	14D
0005434755823	9553	29	14F
0005434755803	9553	30	15A
0005434755787	9553	31	15C
0005434755794	9553	32	15F
0005434755811	9553	33	16C
0005434755805	9553	34	16E
0005434755813	9553	35	16F
0005434755791	9553	36	17A
0005434755789	9553	37	18C
0005434755817	9553	38	19C
0005434755784	9553	39	19D
0005434755816	9553	40	20A
0005434755821	9553	41	20D
0005434755799	9553	42	20F
0005434213748	28608	1	1A
0005434213766	28608	2	1D
0005434213771	28608	3	2A
0005434213770	28608	4	2C
0005434213764	28608	5	2D
0005434213793	28608	6	2F
0005434213760	28608	7	3A
0005434213779	28608	8	4A
0005434213787	28608	9	4E
0005434213789	28608	10	5C
0005434213746	28608	11	5E
0005434213780	28608	12	5F
0005434213752	28608	13	6A
0005434213749	28608	14	6E
0005434213753	28608	15	6F
0005434213761	28608	16	7C
0005434213782	28608	17	7D
0005434213758	28608	18	7E
0005434213776	28608	19	7F
0005434213788	28608	20	8A
0005434213763	28608	21	8C
0005434213768	28608	22	8D
0005434213755	28608	23	9D
0005434213769	28608	24	10A
0005434213765	28608	25	10D
0005434213754	28608	26	10F
0005434213792	28608	27	11A
0005434213791	28608	28	11C
0005434213756	28608	29	12F
0005434213762	28608	30	13A
0005434213775	28608	31	13C
0005434213790	28608	32	13F
0005434213747	28608	33	14A
0005434213785	28608	34	14D
0005434213777	28608	35	14E
0005434213773	28608	36	14F
0005434213759	28608	37	16A
0005434213784	28608	38	16D
0005434213767	28608	39	17D
0005434213750	28608	40	18C
0005434213772	28608	41	18D
0005434213783	28608	42	18E
0005434213781	28608	43	18F
0005434213786	28608	44	19A
0005434213774	28608	45	19C
0005434213751	28608	46	19F
0005434213757	28608	47	20D
0005434213778	28608	48	20E
0005435100076	10805	1	5B
0005435100077	10805	2	6C
0005435100075	10805	3	20B
0005434760160	31808	1	3C
0005434760158	31808	2	20C
0005434760159	31808	3	21D
0005434638906	2010	1	1C
0005434638914	2010	2	2A
0005434638920	2010	3	2C
0005434638921	2010	4	3A
0005434638911	2010	5	3B
0005434638903	2010	6	4A
0005434638918	2010	7	5A
0005434638905	2010	8	5B
0005434638904	2010	9	5C
0005434638919	2010	10	5D
0005432290587	2010	11	6A
0005434638915	2010	12	6B
0005434638908	2010	13	6C
0005434638913	2010	14	6D
0005434638925	2010	15	7B
0005434638916	2010	16	7D
0005434638924	2010	17	18A
0005432290585	2010	18	18C
0005434638907	2010	19	18D
0005434638926	2010	20	19A
0005434638927	2010	21	19B
0005434638923	2010	22	19C
0005434638917	2010	23	20A
0005434638909	2010	24	20B
0005434638910	2010	25	20C
0005434638912	2010	26	22A
0005432290586	2010	27	22B
0005434638922	2010	28	22C
0005433202131	23246	1	1A
0005433202127	23246	2	2D
0005433202118	23246	3	3B
0005433202120	23246	4	4A
0005433202125	23246	5	5B
0005433202117	23246	6	6A
0005433202119	23246	7	6C
0005433202132	23246	8	6D
0005433202130	23246	9	7C
0005433202129	23246	10	7D
0005433202123	23246	11	18A
0005433202128	23246	12	20A
0005433202121	23246	13	20B
0005433202126	23246	14	20D
0005433202124	23246	15	21A
0005433202122	23246	16	22B
0005434600404	6093	1	1C
0005433531235	6093	2	1D
0005434600384	6093	3	2A
0005432111232	6093	4	1F
0005434600388	6093	5	3A
0005433533250	6093	6	3C
0005434600382	6093	7	4C
0005434600405	6093	8	5A
0005434600395	6093	9	5C
0005432111231	6093	10	5D
0005434600406	6093	11	6A
0005434600389	6093	12	6D
0005434600402	6093	13	6E
0005434600400	6093	14	7C
0005434600407	6093	15	7D
0005434600385	6093	16	8A
0005434600394	6093	17	8C
0005433531234	6093	18	8D
0005433531236	6093	19	8E
0005434600408	6093	20	9C
0005434600409	6093	21	9D
0005434600397	6093	22	9F
0005434600403	6093	23	10A
0005434600386	6093	24	10E
0005434600392	6093	25	10F
0005434600390	6093	26	13C
0005434600391	6093	27	13D
0005434600401	6093	28	13F
0005434600387	6093	29	14E
0005433533251	6093	30	14F
0005434600399	6093	31	15C
0005432111233	6093	32	16E
0005434600398	6093	33	17E
0005434600383	6093	34	17F
0005433533249	6093	35	18C
0005434600396	6093	36	18F
0005434600393	6093	37	19C
0005433533248	6093	38	19D
0005433533252	6093	39	19E
0005435326533	18572	1	1C
0005435326535	18572	2	3D
0005435326536	18572	3	5A
0005435326532	18572	4	5E
0005435326525	18572	5	6D
0005435326529	18572	6	10A
0005435326527	18572	7	10D
0005435326531	18572	8	10F
0005435326538	18572	9	11D
0005435326530	18572	10	14F
0005435326537	18572	11	16C
0005435326534	18572	12	17D
0005435326528	18572	13	18D
0005435326526	18572	14	19D
0005434550356	10571	1	1A
0005434550347	10571	2	1C
0005434550327	10571	3	1D
0005434550335	10571	4	1F
0005434550343	10571	5	2A
0005434558145	10571	6	2C
0005434558142	10571	7	2F
0005434550338	10571	8	3A
0005434550340	10571	9	3C
0005434550329	10571	10	3D
0005434550362	10571	11	3F
0005434550367	10571	12	4C
0005434550366	10571	13	4D
0005434550360	10571	14	4E
0005434550316	10571	15	5A
0005434550336	10571	16	5C
0005434550326	10571	17	5D
0005434550318	10571	18	5F
0005434550322	10571	19	6A
0005434550337	10571	20	6D
0005434550333	10571	21	6F
0005434550353	10571	22	7C
0005434550321	10571	23	7E
0005434558141	10571	24	7F
0005434550361	10571	25	8A
0005434550345	10571	26	8C
0005434550352	10571	27	8D
0005434554028	10571	28	8E
0005434550325	10571	29	8F
0005434550349	10571	30	9A
0005434550359	10571	31	9D
0005434550357	10571	32	9E
0005434550315	10571	33	10A
0005434550323	10571	34	10C
0005434550313	10571	35	10E
0005434550351	10571	36	10F
0005434550320	10571	37	11A
0005434550339	10571	38	11C
0005434550328	10571	39	11D
0005434550324	10571	40	11F
0005434550358	10571	41	12A
0005434558139	10571	42	12C
0005434550312	10571	43	12D
0005434550341	10571	44	12E
0005434550348	10571	45	13A
0005434550334	10571	46	13C
0005434550368	10571	47	13D
0005434550344	10571	48	13E
0005434550355	10571	49	13F
0005434558147	10571	50	14A
0005434550330	10571	51	14C
0005434550317	10571	52	14E
0005434558146	10571	53	14F
0005434558143	10571	54	15A
0005434550331	10571	55	15C
0005434550354	10571	56	15D
0005434550319	10571	57	15E
0005434550346	10571	58	16E
0005434550342	10571	59	17A
0005434558148	10571	60	17C
0005434558144	10571	61	17F
0005434550314	10571	62	18A
0005434550365	10571	63	18E
0005434550363	10571	64	18F
0005434550364	10571	65	19D
0005434554029	10571	66	19E
0005434550350	10571	67	20A
0005434550332	10571	68	20E
0005434558140	10571	69	20F
0005433180710	27775	1	1A
0005433180703	27775	2	2F
0005433180719	27775	3	4A
0005433180723	27775	4	7A
0005433180701	27775	5	7F
0005433180720	27775	6	8A
0005433180709	27775	7	8D
0005433180705	27775	8	9D
0005433180716	27775	9	9E
0005433180702	27775	10	10D
0005433180718	27775	11	10F
0005433180724	27775	12	11C
0005433180712	27775	13	12A
0005433180714	27775	14	12D
0005433180722	27775	15	12E
0005433180708	27775	16	12F
0005433180707	27775	17	15F
0005433180704	27775	18	17C
0005433180713	27775	19	17F
0005433180711	27775	20	18A
0005433180706	27775	21	18D
0005433180715	27775	22	18E
0005433180721	27775	23	19D
0005433180725	27775	24	19E
0005433180717	27775	25	20D
0005433459152	6161	1	1A
0005433459155	6161	2	2B
0005433459153	6161	3	5A
0005433459154	6161	4	6A
0005435254434	19290	1	4A
0005435254435	19290	2	5A
0005435254436	19290	3	6B
0005435661883	6723	1	1C
0005435681477	6723	2	1D
0005435719551	6723	3	1F
0005435661884	6723	4	2A
0005435681487	6723	5	2F
0005435681475	6723	6	3A
0005435681498	6723	7	3C
0005435681489	6723	8	4D
0005435681491	6723	9	5A
0005435681476	6723	10	5C
0005435681474	6723	11	5D
0005435681501	6723	12	5E
0005435681492	6723	13	6A
0005435681507	6723	14	6C
0005435681468	6723	15	6D
0005435681480	6723	16	6E
0005435681481	6723	17	6F
0005435681470	6723	18	7C
0005435681467	6723	19	7E
0005435681473	6723	20	8F
0005435681485	6723	21	9A
0005432136093	6723	22	10A
0005435681482	6723	23	10D
0005435630918	6723	24	10E
0005435681504	6723	25	10F
0005435217677	6723	26	11A
0005435681494	6723	27	11C
0005435681506	6723	28	11D
0005435719550	6723	29	11E
0005435681493	6723	30	11F
0005435681497	6723	31	12C
0005435681479	6723	32	12D
0005435681505	6723	33	12F
0005435681486	6723	34	13E
0005435681469	6723	35	13F
0005435681484	6723	36	14A
0005435681483	6723	37	14F
0005435681471	6723	38	15A
0005432136091	6723	39	15C
0005435681503	6723	40	15D
0005432136092	6723	41	15F
0005435681488	6723	42	16A
0005435681500	6723	43	16D
0005435681502	6723	44	16E
0005435661882	6723	45	16F
0005435681496	6723	46	17E
0005435630917	6723	47	18D
0005435681472	6723	48	18F
0005435681478	6723	49	19A
0005435681490	6723	50	19C
0005432136090	6723	51	19E
0005435681495	6723	52	20D
0005435681499	6723	53	20F
0005435437599	24618	1	2D
0005435437613	24618	2	3F
0005435437601	24618	3	5A
0005432305711	24618	4	5C
0005435437605	24618	5	5E
0005435437615	24618	6	6E
0005432533247	24618	7	6F
0005434828654	24618	8	8E
0005435437617	24618	9	9F
0005435437616	24618	10	10D
0005435437619	24618	11	11C
0005435437603	24618	12	12E
0005435437600	24618	13	13D
0005435437606	24618	14	13E
0005432533248	24618	15	13F
0005432305709	24618	16	14A
0005435437604	24618	17	14D
0005435437602	24618	18	15A
0005435437609	24618	19	15C
0005435437610	24618	20	15D
0005435437612	24618	21	15E
0005435437618	24618	22	16A
0005435437597	24618	23	17A
0005435437614	24618	24	17C
0005435437607	24618	25	17E
0005435437598	24618	26	17F
0005434828655	24618	27	18C
0005435437608	24618	28	18D
0005435437611	24618	29	18F
0005432305710	24618	30	20C
0005435125693	11538	1	1C
0005435125725	11538	2	1D
0005435125691	11538	3	1F
0005435125727	11538	4	2A
0005435125719	11538	5	2D
0005435125701	11538	6	3D
0005435125709	11538	7	3F
0005435125712	11538	8	4E
0005435125716	11538	9	5A
0005435125695	11538	10	6E
0005435125707	11538	11	6F
0005435125706	11538	12	7D
0005435125696	11538	13	7F
0005435125692	11538	14	8A
0005435125705	11538	15	8C
0005435105930	11538	16	8E
0005435125721	11538	17	9F
0005435125689	11538	18	10A
0005435125704	11538	19	10E
0005435125711	11538	20	11A
0005435125723	11538	21	11D
0005435125714	11538	22	11E
0005435125697	11538	23	12E
0005435125690	11538	24	13C
0005435125698	11538	25	13D
0005435125700	11538	26	13E
0005435125726	11538	27	13F
0005435125718	11538	28	14C
0005435125713	11538	29	14D
0005435125729	11538	30	14E
0005435105931	11538	31	15C
0005435125724	11538	32	15D
0005435125694	11538	33	15F
0005435125710	11538	34	17F
0005435125715	11538	35	18A
0005435125708	11538	36	18D
0005435125703	11538	37	18E
0005435125717	11538	38	19A
0005435125702	11538	39	19D
0005435125699	11538	40	19F
0005435125728	11538	41	20A
0005435125720	11538	42	20C
0005435125722	11538	43	20D
0005435558047	31848	1	6D
0005433397283	13558	1	1A
0005433397286	13558	2	1C
0005433397321	13558	3	2A
0005433397295	13558	4	2C
0005433397318	13558	5	2F
0005433397311	13558	6	3D
0005433397327	13558	7	3F
0005433397307	13558	8	4C
0005433397282	13558	9	5C
0005433397290	13558	10	5E
0005433397287	13558	11	6A
0005433397314	13558	12	6E
0005433397291	13558	13	6F
0005433397324	13558	14	7D
0005433397278	13558	15	7E
0005433397296	13558	16	7F
0005433397297	13558	17	8C
0005433397293	13558	18	9A
0005433397294	13558	19	9C
0005433397306	13558	20	9D
0005433397325	13558	21	10A
0005433397320	13558	22	10C
0005433397284	13558	23	10E
0005433397281	13558	24	10F
0005433397292	13558	25	11F
0005433397298	13558	26	12A
0005433397315	13558	27	12C
0005433397289	13558	28	12D
0005433397317	13558	29	12E
0005433397288	13558	30	12F
0005433397305	13558	31	13A
0005433397303	13558	32	13F
0005433397299	13558	33	14D
0005433397323	13558	34	14E
0005433397300	13558	35	15C
0005433397304	13558	36	15F
0005433397302	13558	37	16A
0005433397308	13558	38	16D
0005433397285	13558	39	17A
0005433397326	13558	40	17D
0005433397313	13558	41	17E
0005433397319	13558	42	17F
0005433397316	13558	43	18C
0005433397312	13558	44	18E
0005433397309	13558	45	19A
0005433397322	13558	46	19C
0005433397279	13558	47	19D
0005433397301	13558	48	20C
0005433397280	13558	49	20D
0005433397310	13558	50	20F
0005435732132	19385	1	1D
0005435732147	19385	2	1F
0005432297237	19385	3	2D
0005435732148	19385	4	3C
0005435732135	19385	5	4A
0005432297236	19385	6	4C
0005435732131	19385	7	5E
0005435732138	19385	8	6A
0005433397219	19385	9	6C
0005435732149	19385	10	6D
0005435732142	19385	11	6F
0005435732134	19385	12	7D
0005432297235	19385	13	7E
0005435732151	19385	14	7F
0005435732139	19385	15	8A
0005435732144	19385	16	9A
0005435732141	19385	17	10A
0005435732129	19385	18	10F
0005435732136	19385	19	11A
0005435732133	19385	20	13D
0005435732140	19385	21	15C
0005435732146	19385	22	15D
0005435732145	19385	23	17A
0005435732137	19385	24	19A
0005435732130	19385	25	19C
0005435732150	19385	26	20A
0005435732143	19385	27	20E
0005435925084	13144	1	1D
0005435925094	13144	2	2C
0005435925093	13144	3	2D
0005435925087	13144	4	4A
0005435925095	13144	5	5A
0005435925090	13144	6	5F
0005435925092	13144	7	6A
0005435925085	13144	8	6C
0005435925081	13144	9	8C
0005435925079	13144	10	9E
0005435925080	13144	11	10C
0005435925089	13144	12	13F
0005435925088	13144	13	15E
0005435925091	13144	14	16C
0005435925078	13144	15	16D
0005435925082	13144	16	17D
0005435925086	13144	17	17F
0005435925083	13144	18	20E
0005435068254	15500	1	1A
0005435068256	15500	2	1C
0005435068219	15500	3	1F
0005435068248	15500	4	2C
0005435068262	15500	5	2F
0005435068250	15500	6	3A
0005435068252	15500	7	3C
0005435068236	15500	8	3F
0005435068243	15500	9	4E
0005435068230	15500	10	5A
0005435068238	15500	11	5D
0005435068220	15500	12	5E
0005435068213	15500	13	6A
0005435068215	15500	14	6C
0005435068235	15500	15	6D
0005435068218	15500	16	6E
0005435068263	15500	17	7A
0005435068245	15500	18	7C
0005435068260	15500	19	7F
0005435068224	15500	20	8A
0005435068253	15500	21	8F
0005435068211	15500	22	9A
0005435068223	15500	23	9C
0005435068229	15500	24	9E
0005435068258	15500	25	9F
0005435068232	15500	26	10A
0005435068246	15500	27	10D
0005435068234	15500	28	10C
0005435068216	15500	29	10E
0005435068261	15500	30	10F
0005435068217	15500	31	11A
0005435068242	15500	32	11C
0005435068228	15500	33	11D
0005435068237	15500	34	12A
0005435068247	15500	35	12E
0005435068226	15500	36	13A
0005435068249	15500	37	13C
0005435068212	15500	38	13D
0005435068222	15500	39	13E
0005435068221	15500	40	14A
0005435068241	15500	41	14D
0005435068255	15500	42	15F
0005435068233	15500	43	16E
0005435068251	15500	44	16F
0005435068227	15500	45	17A
0005435068244	15500	46	17C
0005435068225	15500	47	17E
0005435068257	15500	48	18A
0005435068239	15500	49	18D
0005435068214	15500	50	18E
0005435068240	15500	51	18F
0005435068231	15500	52	19E
0005435068259	15500	53	19F
0005433407490	29484	1	2C
0005433407485	29484	2	2D
0005433407487	29484	3	4C
0005433407489	29484	4	6B
0005433407488	29484	5	7B
0005433407482	29484	6	19C
0005433407483	29484	7	19D
0005433407484	29484	8	20C
0005433407486	29484	9	22B
0005433407491	29484	10	22C
0005434213794	10710	1	1A
0005434213800	10710	2	1C
0005434213823	10710	3	2D
0005434213818	10710	4	2F
0005434213810	10710	5	3D
0005434213837	10710	6	3F
0005434213832	10710	7	4A
0005434213820	10710	8	4C
0005434213807	10710	9	4D
0005434213827	10710	10	4E
0005434213808	10710	11	4F
0005434213840	10710	12	5D
0005434213824	10710	13	6E
0005434213825	10710	14	6F
0005434213809	10710	15	7E
0005434213828	10710	16	8A
0005434213816	10710	17	8F
0005434213799	10710	18	9D
0005434213813	10710	19	9E
0005434213797	10710	20	10C
0005434213836	10710	21	11A
0005434213796	10710	22	11F
0005434213798	10710	23	12C
0005434213826	10710	24	13A
0005434213805	10710	25	13C
0005434213822	10710	26	13E
0005434213804	10710	27	13F
0005434213801	10710	28	14A
0005434213819	10710	29	14C
0005434213806	10710	30	14F
0005434213835	10710	31	15A
0005434213795	10710	32	15C
0005434213803	10710	33	15E
0005434213812	10710	34	16C
0005434213821	10710	35	16D
0005434213830	10710	36	16F
0005434213833	10710	37	17F
0005434213834	10710	38	18A
0005434213811	10710	39	18C
0005434213802	10710	40	18D
0005434213829	10710	41	18E
0005434213831	10710	42	18F
0005434213838	10710	43	19A
0005434213817	10710	44	19D
0005434213814	10710	45	19E
0005434213815	10710	46	20C
0005434213839	10710	47	20E
0005434755739	28655	1	1A
0005434755754	28655	2	1C
0005434755737	28655	3	2A
0005434755738	28655	4	2D
0005434755760	28655	5	2F
0005434755742	28655	6	3A
0005434755746	28655	7	3D
0005434755743	28655	8	3F
0005434755774	28655	9	4A
0005434755756	28655	10	4C
0005434755773	28655	11	4D
0005434755775	28655	12	4F
0005434755740	28655	13	5C
0005434755762	28655	14	6D
0005434755748	28655	15	6E
0005434755781	28655	16	7A
0005434755736	28655	17	7C
0005434755758	28655	18	7E
0005434755749	28655	19	8A
0005434755770	28655	20	8D
0005434755751	28655	21	8E
0005434755772	28655	22	9A
0005434755764	28655	23	9C
0005434755778	28655	24	9E
0005434755769	28655	25	9F
0005434755761	28655	26	10D
0005434755767	28655	27	10F
0005434755757	28655	28	11A
0005434755763	28655	29	11E
0005434755755	28655	30	12E
0005434755777	28655	31	12F
0005434755753	28655	32	13E
0005434755765	28655	33	14E
0005434755780	28655	34	16E
0005434755750	28655	35	17A
0005434755759	28655	36	17D
0005434755752	28655	37	17E
0005434755747	28655	38	17F
0005434755741	28655	39	18E
0005434755771	28655	40	19A
0005434755779	28655	41	19D
0005434755745	28655	42	19F
0005434755766	28655	43	20C
0005434755744	28655	44	20D
0005434755768	28655	45	20E
0005434755776	28655	46	20F
0005435038748	5431	1	1A
0005435038781	5431	2	1C
0005435038762	5431	3	1F
0005435038774	5431	4	2C
0005435038753	5431	5	2D
0005435038742	5431	6	3A
0005435038780	5431	7	2F
0005435038761	5431	8	3C
0005435038771	5431	9	3F
0005435038797	5431	10	4B
0005435006659	5431	11	4C
0005435038741	5431	12	4E
0005435038788	5431	13	5A
0005435006669	5431	14	4F
0005435006655	5431	15	5B
0005435038783	5431	16	5D
0005435038765	5431	17	5E
0005435038752	5431	18	6A
0005435042825	5431	19	5F
0005435038793	5431	20	6C
0005435006667	5431	21	6B
0005435038764	5431	22	6D
0005435038801	5431	23	6E
0005435038767	5431	24	6F
0005435038776	5431	25	7B
0005435038800	5431	26	7D
0005435006656	5431	27	8A
0005435038751	5431	28	7F
0005435006649	5431	29	8B
0005435038747	5431	30	8D
0005435006650	5431	31	8E
0005435038766	5431	32	9A
0005435038775	5431	33	8F
0005435038778	5431	34	9B
0005432125339	5431	35	9D
0005435038740	5431	36	9C
0005435038779	5431	37	9E
0005435038744	5431	38	9F
0005435038789	5431	39	10B
0005435038757	5431	40	10E
0005435038784	5431	41	11A
0005435038773	5431	42	11C
0005435006648	5431	43	11B
0005435038777	5431	44	11D
0005435038770	5431	45	11F
0005435038772	5431	46	11E
0005435038768	5431	47	12A
0005435038749	5431	48	12B
0005432125334	5431	49	12E
0005435038760	5431	50	13A
0005435006663	5431	51	12F
0005435038791	5431	52	13D
0005435038787	5431	53	13C
0005435006654	5431	54	13E
0005435038759	5431	55	13F
0005435038750	5431	56	14B
0005435006671	5431	57	14A
0005435006657	5431	58	14C
0005435038799	5431	59	14D
0005435006660	5431	60	14E
0005435038796	5431	61	14F
0005435038794	5431	62	15B
0005432125340	5431	63	15A
0005435038755	5431	64	15D
0005432125335	5431	65	15C
0005435006666	5431	66	15E
0005435006665	5431	67	16A
0005435038745	5431	68	15F
0005435038769	5431	69	16E
0005435038756	5431	70	16F
0005435006658	5431	71	17A
0005435038754	5431	72	17B
0005435043273	5431	73	17C
0005432125338	5431	74	17E
0005435038803	5431	75	18A
0005435006662	5431	76	18E
0005435006647	5431	77	18D
0005435006668	5431	78	18F
0005435038739	5431	79	19A
0005435006664	5431	80	19B
0005435043275	5431	81	19C
0005435038790	5431	82	19D
0005435006652	5431	83	19F
0005435006653	5431	84	20A
0005435006670	5431	85	20C
0005432125337	5431	86	20D
0005435006661	5431	87	21A
0005432125336	5431	88	21B
0005435038785	5431	89	21D
0005435038798	5431	90	21C
0005435043274	5431	91	21E
0005435038786	5431	92	21F
0005435038792	5431	93	22B
0005435038743	5431	94	22D
0005435038782	5431	95	22C
0005435038795	5431	96	22E
0005435038758	5431	97	22F
0005435038763	5431	98	23B
0005435038804	5431	99	23A
0005435038746	5431	100	23C
0005435006651	5431	101	23D
0005435038802	5431	102	23E
0005435042824	5431	103	23F
0005432304338	12991	1	2D
0005434229028	12991	2	3A
0005434229034	12991	3	5B
0005434229029	12991	4	5A
0005434229021	12991	5	6C
0005434229027	12991	6	10B
0005434229014	12991	7	10E
0005434229026	12991	8	11D
0005434229012	12991	9	12A
0005434229020	12991	10	12B
0005434229022	12991	11	12C
0005434229016	12991	12	12E
0005434229023	12991	13	14A
0005434229017	12991	14	14C
0005434229031	12991	15	16A
0005434229013	12991	16	16C
0005434229024	12991	17	17B
0005434229018	12991	18	17C
0005434229030	12991	19	18B
0005434229025	12991	20	19C
0005434229033	12991	21	21D
0005434229015	12991	22	22B
0005434229032	12991	23	22A
0005434229019	12991	24	22E
0005432304339	12991	25	23A
0005434426129	14871	1	1A
0005434426114	14871	2	1C
0005434411705	14871	3	2C
0005434426117	14871	4	3F
0005434426140	14871	5	4E
0005434411706	14871	6	5C
0005432188556	14871	7	5E
0005434426128	14871	8	6C
0005434426144	14871	9	6D
0005434426134	14871	10	6E
0005434426142	14871	11	6F
0005434426136	14871	12	7C
0005434426139	14871	13	7D
0005434411707	14871	14	7E
0005432188555	14871	15	8A
0005434426141	14871	16	8C
0005434426132	14871	17	8E
0005434426131	14871	18	9D
0005434426137	14871	19	9E
0005434426135	14871	20	10C
0005434426145	14871	21	10D
0005434426115	14871	22	10E
0005434426120	14871	23	11C
0005434426122	14871	24	12C
0005434426121	14871	25	12D
0005434426124	14871	26	12E
0005434426123	14871	27	12F
0005434426143	14871	28	13A
0005434426116	14871	29	14A
0005434411708	14871	30	14C
0005434426130	14871	31	15D
0005434411709	14871	32	16A
0005434426133	14871	33	16D
0005434426127	14871	34	18A
0005434426118	14871	35	18F
0005434426126	14871	36	19A
0005434426119	14871	37	19C
0005434426125	14871	38	19D
0005432188554	14871	39	19F
0005434426138	14871	40	20C
0005432059474	20205	1	2D
0005435902432	20205	2	3C
0005435902422	20205	3	4D
0005435902431	20205	4	4F
0005432059475	20205	5	6A
0005435902436	20205	6	6F
0005435902425	20205	7	7C
0005435902435	20205	8	8C
0005435902421	20205	9	8D
0005435554115	20205	10	11A
0005435902430	20205	11	11E
0005435902427	20205	12	12C
0005435554114	20205	13	13C
0005432059473	20205	14	13E
0005435902428	20205	15	13F
0005435902433	20205	16	15A
0005435902424	20205	17	15C
0005435902434	20205	18	15E
0005435554113	20205	19	17A
0005435554117	20205	20	17F
0005435902437	20205	21	18C
0005435902426	20205	22	19F
0005435554116	20205	23	20A
0005435902429	20205	24	20D
0005435902423	20205	25	20E
0005432462483	28016	1	5D
0005432462480	28016	2	12F
0005432462484	28016	3	16D
0005432462478	28016	4	19A
0005432462479	28016	5	19B
0005432462481	28016	6	21A
0005432462482	28016	7	22D
0005435981551	26526	1	1A
0005435981592	26526	2	1C
0005435981589	26526	3	1F
0005432300170	26526	4	2A
0005435981549	26526	5	2C
0005432300169	26526	6	2D
0005435981557	26526	7	3C
0005435981565	26526	8	3D
0005435981574	26526	9	3F
0005435981566	26526	10	4A
0005432300166	26526	11	4C
0005435981573	26526	12	5D
0005435981579	26526	13	5E
0005435981561	26526	14	5F
0005435981555	26526	15	6C
0005435981569	26526	16	6D
0005435981582	26526	17	6E
0005435981577	26526	18	8D
0005435981567	26526	19	8F
0005435981560	26526	20	8E
0005435981585	26526	21	9E
0005435981559	26526	22	10A
0005432300171	26526	23	10C
0005435981571	26526	24	11A
0005435981548	26526	25	11C
0005435981562	26526	26	12A
0005432300168	26526	27	12D
0005435981576	26526	28	12E
0005435981553	26526	29	13C
0005432300167	26526	30	14A
0005435981581	26526	31	14C
0005435981563	26526	32	14D
0005435981568	26526	33	14E
0005435981554	26526	34	14F
0005435981580	26526	35	15C
0005435981552	26526	36	15D
0005435981591	26526	37	15F
0005435981587	26526	38	16A
0005435981550	26526	39	16D
0005435981572	26526	40	16F
0005435981584	26526	41	17A
0005435981558	26526	42	17C
0005435981590	26526	43	17E
0005435981556	26526	44	17F
0005435981583	26526	45	18C
0005435981575	26526	46	18A
0005435981564	26526	47	18D
0005435981593	26526	48	19A
0005435981588	26526	49	19C
0005435981586	26526	50	19E
0005435981578	26526	51	20C
0005435981570	26526	52	20D
0005433434265	26681	1	2A
0005434269070	26681	2	2C
0005434269073	26681	3	2F
0005433434248	26681	4	3D
0005433434258	26681	5	3C
0005433434244	26681	6	4A
0005433434246	26681	7	4C
0005433434240	26681	8	4D
0005433434238	26681	9	4F
0005432051080	26681	10	5A
0005433434243	26681	11	5C
0005433434239	26681	12	5F
0005434269072	26681	13	6A
0005433434254	26681	14	6E
0005433434260	26681	15	7A
0005432051079	26681	16	9A
0005433434237	26681	17	9E
0005433434247	26681	18	10C
0005433434252	26681	19	12A
0005433434241	26681	20	12D
0005433434242	26681	21	12E
0005433434256	26681	22	12F
0005433434262	26681	23	13E
0005434270176	26681	24	14E
0005433434263	26681	25	15C
0005433434251	26681	26	15E
0005433434264	26681	27	15F
0005433434245	26681	28	16A
0005433434259	26681	29	16C
0005434270175	26681	30	16E
0005433434257	26681	31	16F
0005432051082	26681	32	17A
0005433434249	26681	33	17D
0005434269071	26681	34	18E
0005433434261	26681	35	19E
0005432051081	26681	36	20A
0005433434255	26681	37	20C
0005433434250	26681	38	20D
0005434270174	26681	39	20E
0005433434253	26681	40	20F
0005432583656	3190	1	1B
0005432583646	3190	2	1D
0005432583651	3190	3	2B
0005432583657	3190	4	2D
0005432583645	3190	5	3D
0005432583635	3190	6	4A
0005432583654	3190	7	4B
0005432583641	3190	8	4C
0005432583659	3190	9	4D
0005432583649	3190	10	5B
0005432583655	3190	11	5C
0005432583644	3190	12	6A
0005432216229	3190	13	6B
0005432216228	3190	14	6C
0005432583636	3190	15	7A
0005432583653	3190	16	7B
0005432583638	3190	17	7D
0005432216230	3190	18	18A
0005432583642	3190	19	18B
0005432583643	3190	20	19A
0005432583640	3190	21	19B
0005432583648	3190	22	19C
0005432583639	3190	23	20B
0005432583658	3190	24	20C
0005432583660	3190	25	20D
0005432583652	3190	26	21A
0005432583647	3190	27	22A
0005432583650	3190	28	22B
0005432583637	3190	29	22D
0005432857880	31491	1	1B
0005432857881	31491	2	3C
0005432857875	31491	3	4B
0005432857878	31491	4	4D
0005432857883	31491	5	5B
0005432857882	31491	6	6A
0005432857884	31491	7	6C
0005432857877	31491	8	7C
0005432857874	31491	9	20B
0005432857885	31491	10	21C
0005432857876	31491	11	22A
0005432857886	31491	12	22C
0005432857879	31491	13	23B
0005434943210	899	1	1A
0005434943207	899	2	1D
0005434943211	899	3	1C
0005434943212	899	4	2A
0005434943206	899	5	3A
0005434943209	899	6	5A
0005434943205	899	7	7C
0005434943208	899	8	18C
0005434943204	899	9	23A
0005433255032	16212	1	1B
0005433255034	16212	2	5D
0005433255035	16212	3	6B
0005433255036	16212	4	6C
0005433255033	16212	5	7C
0005435652322	21757	1	1C
0005435652323	21757	2	1F
0005435652319	21757	3	3A
0005435652338	21757	4	3F
0005435652315	21757	5	4A
0005435652330	21757	6	4C
0005435652324	21757	7	4D
0005435652318	21757	8	4F
0005435652320	21757	9	6C
0005435652306	21757	10	6D
0005435652297	21757	11	7C
0005435652316	21757	12	7E
0005435652314	21757	13	8A
0005435652312	21757	14	8D
0005435652317	21757	15	9A
0005435652321	21757	16	9C
0005435652304	21757	17	9D
0005435652336	21757	18	9F
0005435652326	21757	19	10C
0005435652311	21757	20	11A
0005435652325	21757	21	11D
0005435652313	21757	22	11E
0005435652327	21757	23	11F
0005435652299	21757	24	12A
0005435652302	21757	25	12C
0005435652328	21757	26	12D
0005435652305	21757	27	12E
0005435652329	21757	28	13A
0005435652303	21757	29	13C
0005435652310	21757	30	13E
0005435652300	21757	31	14E
0005435652339	21757	32	14F
0005435652334	21757	33	15C
0005435652332	21757	34	15F
0005435652308	21757	35	16A
0005435652331	21757	36	16D
0005435652335	21757	37	17F
0005435652301	21757	38	19A
0005435652307	21757	39	19C
0005435652298	21757	40	19D
0005435652337	21757	41	20C
0005435652333	21757	42	20D
0005435652309	21757	43	20F
0005433784393	9359	1	1H
0005433784400	9359	2	2H
0005433762980	9359	3	3A
0005433804856	9359	4	3G
0005433784396	9359	5	3H
0005433762974	9359	6	4B
0005432665243	9359	7	4F
0005433784372	9359	8	4C
0005433804849	9359	9	5B
0005433804836	9359	10	5H
0005433762979	9359	11	9B
0005432657401	9359	12	9H
0005433762982	9359	13	11A
0005433784379	9359	14	11F
0005433804835	9359	15	11H
0005433784373	9359	16	12B
0005433804854	9359	17	12F
0005433784368	9359	18	12D
0005433762985	9359	19	12G
0005432667422	9359	20	13B
0005433784392	9359	21	13G
0005433804850	9359	22	14A
0005432657400	9359	23	14E
0005433804841	9359	24	14D
0005432666355	9359	25	15A
0005433804832	9359	26	15D
0005433804851	9359	27	15B
0005433804845	9359	28	15G
0005433784369	9359	29	16A
0005433784399	9359	30	16D
0005433804840	9359	31	17A
0005433804837	9359	32	17F
0005433784387	9359	33	17D
0005433784384	9359	34	17G
0005433804831	9359	35	18D
0005433804847	9359	36	18B
0005433804842	9359	37	18E
0005433804855	9359	38	19A
0005433784391	9359	39	19F
0005432665242	9359	40	20A
0005433762983	9359	41	20B
0005433804829	9359	42	20F
0005433762984	9359	43	20H
0005433784367	9359	44	20G
0005433784378	9359	45	21F
0005432666357	9359	46	22D
0005433784377	9359	47	23B
0005433762977	9359	48	23E
0005433784389	9359	49	23G
0005433804846	9359	50	23F
0005433804834	9359	51	24B
0005433784374	9359	52	24E
0005433804857	9359	53	25D
0005433804848	9359	54	25F
0005433784380	9359	55	27A
0005433784397	9359	56	27F
0005433784394	9359	57	28B
0005433762976	9359	58	28D
0005433804833	9359	59	28H
0005433784375	9359	60	28G
0005433784390	9359	61	29A
0005433784370	9359	62	29F
0005433804852	9359	63	29E
0005433784398	9359	64	29G
0005433784382	9359	65	30B
0005433804844	9359	66	30F
0005433784386	9359	67	30E
0005433804838	9359	68	30G
0005432665241	9359	69	31D
0005433762981	9359	70	31F
0005433784376	9359	71	32A
0005433804830	9359	72	31H
0005433762975	9359	73	32D
0005433804843	9359	74	32G
0005433762978	9359	75	33D
0005433784371	9359	76	34E
0005433784381	9359	77	34H
0005432666356	9359	78	35A
0005433804853	9359	79	35F
0005433762973	9359	80	35H
0005433762986	9359	81	36B
0005433784383	9359	82	36G
0005433784385	9359	83	37A
0005433804839	9359	84	37G
0005433784388	9359	85	38D
0005433804858	9359	86	38G
0005433784395	9359	87	38H
0005432667421	9359	88	39E
0005434170838	26218	1	4H
0005434170828	26218	2	5B
0005434170837	26218	3	11G
0005434170831	26218	4	12E
0005434170839	26218	5	12G
0005434270172	26218	6	13F
0005434270173	26218	7	13G
0005434170830	26218	8	14B
0005434170836	26218	9	15F
0005434170832	26218	10	17D
0005434170826	26218	11	17G
0005434170835	26218	12	17H
0005434271278	26218	13	18E
0005434170840	26218	14	20B
0005434170827	26218	15	20E
0005434170829	26218	16	20H
0005434151658	26218	17	22D
0005434151657	26218	18	23F
0005434271279	26218	19	24D
0005434271277	26218	20	27F
0005434170834	26218	21	29D
0005434271280	26218	22	32B
0005434170833	26218	23	33B
0005434151659	26218	24	37A
0005435135592	4934	1	2A
0005435135594	4934	2	4B
0005435135591	4934	3	4C
0005435135593	4934	4	6D
0005435135595	4934	5	19D
0005435929601	33042	1	4B
0005435929600	33042	2	6B
0005435929602	33042	3	21C
0005434983205	9503	1	3A
0005434983207	9503	2	7A
0005434983204	9503	3	18C
0005434983208	9503	4	20A
0005434983206	9503	5	22C
0005434217907	27374	1	1B
0005434217903	27374	2	2D
0005434217906	27374	3	4C
0005434217905	27374	4	5D
0005434217904	27374	5	18A
0005434217902	27374	6	18B
0005433959920	25910	1	1A
0005433959908	25910	2	1C
0005433959940	25910	3	1H
0005433985169	25910	4	1G
0005433959944	25910	5	2B
0005433959925	25910	6	2G
0005433959926	25910	7	2H
0005433985173	25910	8	3A
0005433959904	25910	9	3G
0005433985184	25910	10	4A
0005433985201	25910	11	4G
0005433959922	25910	12	4F
0005433985202	25910	13	5A
0005433985178	25910	14	5F
0005433985171	25910	15	9A
0005433959918	25910	16	11A
0005433985179	25910	17	11D
0005433985209	25910	18	11E
0005433985206	25910	19	11G
0005433959912	25910	20	12A
0005433985183	25910	21	12E
0005433985194	25910	22	13A
0005433959931	25910	23	13D
0005433985207	25910	24	13B
0005433959955	25910	25	13E
0005433985199	25910	26	13F
0005433959935	25910	27	13H
0005433959951	25910	28	14B
0005433959942	25910	29	14A
0005433959919	25910	30	14D
0005433985167	25910	31	14E
0005433959939	25910	32	14G
0005433959927	25910	33	14H
0005433985208	25910	34	16A
0005433959960	25910	35	16D
0005433985211	25910	36	16B
0005433959929	25910	37	16E
0005433959910	25910	38	17D
0005433959946	25910	39	17E
0005433959907	25910	40	17G
0005433959924	25910	41	17H
0005433985168	25910	42	18B
0005433985174	25910	43	18A
0005433985188	25910	44	18D
0005433985192	25910	45	18F
0005433985197	25910	46	18G
0005433985162	25910	47	19E
0005433985166	25910	48	19F
0005433985195	25910	49	19G
0005433985163	25910	50	20A
0005433985190	25910	51	20B
0005433959914	25910	52	20D
0005433985196	25910	53	21G
0005433959913	25910	54	21F
0005433959916	25910	55	22G
0005433985172	25910	56	22F
0005433985177	25910	57	23A
0005433985189	25910	58	22H
0005433959915	25910	59	23B
0005433985182	25910	60	23H
0005433959963	25910	61	24D
0005433985165	25910	62	24F
0005433959906	25910	63	25E
0005433959950	25910	64	27A
0005433959928	25910	65	27D
0005433959936	25910	66	27F
0005433985187	25910	67	27H
0005433959923	25910	68	27G
0005433959945	25910	69	28A
0005433985181	25910	70	28D
0005433985204	25910	71	28B
0005433985205	25910	72	28E
0005433985185	25910	73	28H
0005433959943	25910	74	29B
0005433959957	25910	75	29G
0005433985175	25910	76	29F
0005433985180	25910	77	29H
0005433959962	25910	78	30A
0005433959953	25910	79	30D
0005433985170	25910	80	30G
0005433959917	25910	81	30F
0005433985203	25910	82	32A
0005433985210	25910	83	31H
0005433959905	25910	84	32E
0005433985164	25910	85	32D
0005433959949	25910	86	33A
0005433959958	25910	87	33B
0005433959934	25910	88	33E
0005433959932	25910	89	33G
0005433985198	25910	90	34A
0005433985193	25910	91	34B
0005433959921	25910	92	34F
0005433959948	25910	93	34G
0005433959930	25910	94	34H
0005433959941	25910	95	35G
0005433985186	25910	96	36B
0005433959909	25910	97	36D
0005433959938	25910	98	36F
0005433959911	25910	99	36G
0005433959952	25910	100	37A
0005433959959	25910	101	37E
0005433985200	25910	102	37D
0005433959937	25910	103	37F
0005433959956	25910	104	37H
0005433959954	25910	105	37G
0005433985191	25910	106	38D
0005433985176	25910	107	38B
0005433959933	25910	108	38E
0005433959947	25910	109	39E
0005433959961	25910	110	39F
0005434479942	941	1	1B
0005434479937	941	2	1C
0005434479948	941	3	1D
0005434479936	941	4	2C
0005434479938	941	5	2D
0005434479934	941	6	3B
0005434479926	941	7	3C
0005432269452	941	8	3D
0005434479931	941	9	4D
0005434479946	941	10	5A
0005432269451	941	11	5C
0005432269454	941	12	5D
0005434479949	941	13	6B
0005434479945	941	14	7A
0005434479935	941	15	7B
0005434479939	941	16	7C
0005434479928	941	17	7D
0005434479944	941	18	18A
0005434479932	941	19	18C
0005434479951	941	20	19A
0005434479943	941	21	19C
0005434479947	941	22	20A
0005432269453	941	23	19D
0005434479930	941	24	20B
0005434479929	941	25	20C
0005434479933	941	26	21B
0005434479950	941	27	21D
0005434479927	941	28	22A
0005434479940	941	29	22C
0005434479941	941	30	22D
0005433165701	16576	1	1D
0005433165702	16576	2	2D
0005433165696	16576	3	4B
0005433165697	16576	4	4D
0005433165703	16576	5	5C
0005433165705	16576	6	6A
0005433165708	16576	7	6B
0005433165695	16576	8	7A
0005433165698	16576	9	7D
0005433165706	16576	10	19D
0005433165700	16576	11	20D
0005433165704	16576	12	21B
0005433165699	16576	13	21D
0005433165707	16576	14	23A
0005433872432	3213	1	1C
0005433872435	3213	2	5B
0005433872430	3213	3	7B
0005433872434	3213	4	19C
0005433872431	3213	5	21B
0005433872429	3213	6	22A
0005433872433	3213	7	23A
0005435149801	10349	1	1B
0005435149806	10349	2	1C
0005435142361	10349	3	2B
0005435142357	10349	4	2C
0005435149800	10349	5	2D
0005435142360	10349	6	3C
0005435142350	10349	7	3D
0005435149812	10349	8	4B
0005435149807	10349	9	4C
0005435142356	10349	10	4D
0005435142354	10349	11	5A
0005435142352	10349	12	5B
0005435142359	10349	13	5C
0005435142355	10349	14	5D
0005435149810	10349	15	6A
0005435149803	10349	16	6B
0005435149808	10349	17	18A
0005435142362	10349	18	7D
0005435142351	10349	19	18B
0005435149798	10349	20	18C
0005435149799	10349	21	18D
0005435149809	10349	22	19C
0005435142349	10349	23	20A
0005435149804	10349	24	21B
0005435142358	10349	25	21C
0005435149811	10349	26	21D
0005435142353	10349	27	22B
0005435149805	10349	28	22C
0005435149802	10349	29	22D
0005433289745	21947	1	1B
0005435386472	21947	2	2A
0005435386466	21947	3	2B
0005433289743	21947	4	2D
0005433289744	21947	5	3B
0005433289740	21947	6	3D
0005433289741	21947	7	5C
0005435386471	21947	8	7D
0005435386467	21947	9	18A
0005435386469	21947	10	19A
0005435386468	21947	11	19B
0005433289742	21947	12	21A
0005433289739	21947	13	21D
0005435386465	21947	14	23A
0005435386470	21947	15	23B
0005434573128	11214	1	3C
0005434573121	11214	2	3F
0005434573129	11214	3	4A
0005434573117	11214	4	4C
0005434573125	11214	5	4E
0005434573127	11214	6	5D
0005434573126	11214	7	5F
0005434573116	11214	8	7C
0005434573122	11214	9	7F
0005434573118	11214	10	9A
0005434573124	11214	11	12E
0005434573119	11214	12	14A
0005434573120	11214	13	15E
0005434573123	11214	14	16E
0005432291891	20939	1	1C
0005435501958	20939	2	1D
0005435517625	20939	3	1F
0005435319446	20939	4	2A
0005435501966	20939	5	2D
0005435501955	20939	6	2F
0005435517612	20939	7	3A
0005435319441	20939	8	3D
0005435517608	20939	9	3F
0005435517622	20939	10	4D
0005435501957	20939	11	4E
0005435501964	20939	12	4F
0005435319444	20939	13	5A
0005435501968	20939	14	5C
0005435517624	20939	15	5D
0005435517611	20939	16	5E
0005435501974	20939	17	6A
0005435517617	20939	18	6C
0005435319449	20939	19	6E
0005435517618	20939	20	6F
0005435501962	20939	21	7A
0005435501973	20939	22	7C
0005435501963	20939	23	7D
0005435508178	20939	24	7E
0005435517615	20939	25	8C
0005435508177	20939	26	8D
0005435501972	20939	27	9A
0005435319448	20939	28	9C
0005435501970	20939	29	9D
0005432291892	20939	30	9E
0005435517616	20939	31	10C
0005435501969	20939	32	10D
0005435319445	20939	33	10E
0005435501961	20939	34	10F
0005435517619	20939	35	11A
0005435508182	20939	36	11C
0005435508183	20939	37	11D
0005435517610	20939	38	11E
0005435517626	20939	39	12A
0005435508180	20939	40	12D
0005435508181	20939	41	12E
0005435517627	20939	42	12F
0005435319447	20939	43	13A
0005435508184	20939	44	13C
0005435501953	20939	45	13E
0005435501971	20939	46	14C
0005435508179	20939	47	14D
0005435501956	20939	48	14E
0005435501960	20939	49	15D
0005435501967	20939	50	15F
0005435501959	20939	51	16A
0005435501965	20939	52	16D
0005435517614	20939	53	16E
0005435517609	20939	54	17E
0005435319443	20939	55	17F
0005435517621	20939	56	18A
0005435319442	20939	57	18E
0005435517607	20939	58	18F
0005435517620	20939	59	19A
0005435517623	20939	60	19E
0005435501954	20939	61	20D
0005435517628	20939	62	20E
0005435517613	20939	63	20F
0005432706385	2968	1	1A
0005432706370	2968	2	1D
0005432706383	2968	3	2C
0005432706364	2968	4	2F
0005432706381	2968	5	3D
0005432706369	2968	6	4C
0005432706377	2968	7	4E
0005432706380	2968	8	5C
0005432706367	2968	9	5D
0005432706373	2968	10	6A
0005432706360	2968	11	6D
0005432706368	2968	12	7F
0005432706372	2968	13	8D
0005432706362	2968	14	8E
0005432706366	2968	15	9C
0005432217731	2968	16	10A
0005432706363	2968	17	10D
0005432706365	2968	18	11A
0005432706378	2968	19	11C
0005432706379	2968	20	12C
0005432706374	2968	21	13F
0005432706361	2968	22	14C
0005432706375	2968	23	14F
0005432217732	2968	24	16A
0005432706382	2968	25	18C
0005432706376	2968	26	19A
0005432706384	2968	27	20A
0005432706371	2968	28	20E
0005432692604	30081	1	1A
0005432692613	30081	2	1C
0005432880581	30081	3	1F
0005432692607	30081	4	2A
0005432692614	30081	5	2C
0005432692621	30081	6	2F
0005432880591	30081	7	3A
0005433123588	30081	8	3C
0005432880593	30081	9	3D
0005432692612	30081	10	3F
0005432692608	30081	11	4C
0005433123593	30081	12	4D
0005432880584	30081	13	4E
0005432692598	30081	14	5A
0005433123598	30081	15	5C
0005432692597	30081	16	5E
0005432692616	30081	17	5F
0005432692609	30081	18	6A
0005433123599	30081	19	6D
0005432880594	30081	20	6E
0005433123597	30081	21	6F
0005432880582	30081	22	7A
0005433123603	30081	23	7C
0005433123606	30081	24	7D
0005433123604	30081	25	7E
0005432692602	30081	26	7F
0005433123591	30081	27	8A
0005433123596	30081	28	8D
0005432692615	30081	29	8E
0005432880586	30081	30	8F
0005432692596	30081	31	9A
0005432706344	30081	32	9C
0005432692617	30081	33	9D
0005432692620	30081	34	9F
0005432880587	30081	35	10C
0005433194820	30081	36	10D
0005432692601	30081	37	10E
0005433123592	30081	38	10F
0005433123594	30081	39	11E
0005432692593	30081	40	11F
0005433194823	30081	41	12A
0005432692591	30081	42	12C
0005433123605	30081	43	12D
0005433123602	30081	44	12E
0005432692590	30081	45	12F
0005433123590	30081	46	13D
0005432692605	30081	47	13E
0005432880589	30081	48	13F
0005432692595	30081	49	14A
0005432880595	30081	50	14C
0005432692606	30081	51	14E
0005432692618	30081	52	14F
0005432692592	30081	53	15C
0005432880583	30081	54	15A
0005433123589	30081	55	15D
0005433123608	30081	56	15F
0005432880592	30081	57	16A
0005432692600	30081	58	16C
0005432692603	30081	59	16E
0005433194821	30081	60	16F
0005432692619	30081	61	17A
0005433123595	30081	62	17C
0005433194822	30081	63	17E
0005432880588	30081	64	17F
0005432692594	30081	65	18A
0005433123609	30081	66	18E
0005433123600	30081	67	18F
0005433123601	30081	68	19A
0005433123607	30081	69	19C
0005432692599	30081	70	19D
0005432880585	30081	71	19E
0005432880590	30081	72	19F
0005432692611	30081	73	20A
0005432692610	30081	74	20E
0005433123610	30081	75	20F
0005434979296	23647	1	1B
0005434979283	23647	2	1C
0005434979292	23647	3	2A
0005434979290	23647	4	2B
0005434979308	23647	5	2C
0005434988565	23647	6	2D
0005434979313	23647	7	3A
0005434979297	23647	8	3B
0005434979312	23647	9	3C
0005434979299	23647	10	3D
0005434979311	23647	11	4A
0005434979310	23647	12	4B
0005434979284	23647	13	4C
0005434979295	23647	14	4D
0005434979303	23647	15	5A
0005434988567	23647	16	5B
0005434979286	23647	17	5C
0005434979288	23647	18	5D
0005434979309	23647	19	6A
0005434979285	23647	20	6D
0005434988566	23647	21	7A
0005434988568	23647	22	7C
0005434979287	23647	23	7D
0005434979294	23647	24	18A
0005434979304	23647	25	18B
0005434988570	23647	26	18C
0005434979305	23647	27	18D
0005434979289	23647	28	19B
0005434979307	23647	29	19D
0005434979301	23647	30	20A
0005434979291	23647	31	20B
0005434979306	23647	32	20D
0005434979298	23647	33	21B
0005434979293	23647	34	21D
0005434988569	23647	35	22A
0005434979300	23647	36	22C
0005434979302	23647	37	22D
0005434302388	10280	1	4D
0005434302387	10280	2	6B
0005434302390	10280	3	18A
0005434302386	10280	4	20A
0005434302389	10280	5	22C
0005433113500	19598	1	2D
0005433113501	19598	2	7B
0005435068273	3523	1	1C
0005435068294	3523	2	1F
0005435068309	3523	3	2D
0005435068306	3523	4	2F
0005435068311	3523	5	3C
0005435068299	3523	6	3F
0005435068275	3523	7	4A
0005435068285	3523	8	4C
0005435068292	3523	9	4D
0005435068282	3523	10	4E
0005435068288	3523	11	4F
0005435068307	3523	12	5A
0005435068297	3523	13	5C
0005435068277	3523	14	5D
0005435068316	3523	15	6C
0005435068286	3523	16	6D
0005435718842	3523	17	7D
0005435718838	3523	18	7E
0005435068312	3523	19	7F
0005435068315	3523	20	8A
0005435068317	3523	21	8C
0005435068308	3523	22	8D
0005435068313	3523	23	8E
0005435068272	3523	24	9A
0005435068265	3523	25	9C
0005435068267	3523	26	9D
0005435068290	3523	27	9F
0005435068314	3523	28	10A
0005435068264	3523	29	10C
0005435068291	3523	30	10D
0005435068301	3523	31	10E
0005435068271	3523	32	10F
0005435718839	3523	33	11A
0005435068298	3523	34	12A
0005435068304	3523	35	12C
0005435718844	3523	36	12D
0005435068302	3523	37	12E
0005435068280	3523	38	13A
0005435068279	3523	39	13C
0005435718847	3523	40	13E
0005435718845	3523	41	13F
0005435068287	3523	42	14A
0005435718843	3523	43	14D
0005435068276	3523	44	14F
0005435068274	3523	45	15C
0005435068268	3523	46	15D
0005435068270	3523	47	16A
0005435068296	3523	48	16C
0005435718841	3523	49	16D
0005435068305	3523	50	16E
0005435068293	3523	51	17A
0005435068283	3523	52	17C
0005435068281	3523	53	17D
0005435068278	3523	54	17E
0005435068269	3523	55	18A
0005435068300	3523	56	18C
0005435068284	3523	57	18D
0005435068289	3523	58	18E
0005435718840	3523	59	19D
0005435068295	3523	60	19E
0005435068303	3523	61	19F
0005435718846	3523	62	20C
0005435068266	3523	63	20E
0005435068310	3523	64	20F
0005435925089	15298	1	1A
0005435925079	15298	2	2A
0005435925081	15298	3	2D
0005435925090	15298	4	3A
0005435925085	15298	5	4D
0005435925080	15298	6	4F
0005435925086	15298	7	6D
0005435925082	15298	8	7D
0005435925095	15298	9	8C
0005435939861	15298	10	9C
0005435925088	15298	11	9F
0005435939860	15298	12	11A
0005435939859	15298	13	11D
0005435925094	15298	14	13E
0005435925078	15298	15	14A
0005435925093	15298	16	15C
0005435925083	15298	17	17F
0005435925092	15298	18	18E
0005435925084	15298	19	19C
0005435925091	15298	20	19D
0005435925087	15298	21	20C
0005432660784	18167	1	2A
0005432658558	18167	2	2B
0005432660785	18167	3	4B
0005432660787	18167	4	4A
0005432659673	18167	5	5A
0005432658559	18167	6	5B
0005432659674	18167	7	6A
0005432660786	18167	8	6B
0005432157461	55	1	15E
0005432157463	55	2	24A
0005432157462	55	3	28F
0005432817007	54	1	1D
0005432261189	54	2	1A
0005432817010	54	3	2C
0005432261208	54	4	2A
0005432261219	54	5	3A
0005432261185	54	6	3F
0005432207621	54	7	5C
0005432261217	54	8	5F
0005432817008	54	9	5D
0005432817017	54	10	7F
0005432261193	54	11	8A
0005432817020	54	12	8C
0005432261206	54	13	8B
0005432817022	54	14	8E
0005432817027	54	15	9E
0005432261184	54	16	10B
0005432261209	54	17	10D
0005432261197	54	18	10E
0005432261204	54	19	10F
0005432817014	54	20	11B
0005432817000	54	21	11A
0005432261226	54	22	12C
0005432261214	54	23	12E
0005432817005	54	24	12D
0005432261200	54	25	13A
0005432817016	54	26	12F
0005432261188	54	27	13B
0005432261225	54	28	13F
0005432261205	54	29	14C
0005432261216	54	30	14F
0005432261203	54	31	15B
0005432261194	54	32	15F
0005432817021	54	33	15E
0005432261207	54	34	16C
0005432261202	54	35	16E
0005432817018	54	36	16D
0005432817012	54	37	17A
0005432817013	54	38	17E
0005432207620	54	39	17D
0005432261223	54	40	17F
0005432817024	54	41	18A
0005432261192	54	42	18B
0005432261221	54	43	18C
0005432817011	54	44	18E
0005432261213	54	45	18D
0005432261198	54	46	20B
0005432817015	54	47	20F
0005432817001	54	48	21B
0005432261183	54	49	21A
0005432817025	54	50	21C
0005432207619	54	51	21E
0005432261201	54	52	22A
0005432261220	54	53	22B
0005432261186	54	54	22E
0005432816999	54	55	22D
0005432288934	54	56	23D
0005432817009	54	57	23C
0005432261212	54	58	23E
0005432261190	54	59	24B
0005432288935	54	60	25A
0005432261182	54	61	25B
0005432817002	54	62	25D
0005432817019	54	63	25C
0005432261187	54	64	25F
0005432261211	54	65	26A
0005432261191	54	66	26E
0005432817006	54	67	26D
0005432816998	54	68	27A
0005432261196	54	69	27C
0005432261227	54	70	27D
0005432261199	54	71	28A
0005432261215	54	72	27F
0005432261222	54	73	28C
0005432261218	54	74	28E
0005432817026	54	75	29B
0005432817003	54	76	29E
0005432817004	54	77	30B
0005432288936	54	78	30C
0005432817023	54	79	30D
0005432261181	54	80	30F
0005432261195	54	81	30E
0005432261210	54	82	31D
0005432261224	54	83	31E
0005433101340	7988	1	1A
0005433101302	7988	2	1F
0005432391952	7988	3	1D
0005433101295	7988	4	2A
0005432919536	7988	5	2F
0005433101328	7988	6	3D
0005433101316	7988	7	3F
0005432019858	7988	8	4A
0005433101293	7988	9	4D
0005432919545	7988	10	4C
0005433101345	7988	11	5A
0005432019842	7988	12	5C
0005432019835	7988	13	5D
0005432019844	7988	14	6D
0005433101341	7988	15	7A
0005432019839	7988	16	6F
0005433101317	7988	17	7C
0005432019840	7988	18	7F
0005433101298	7988	19	7D
0005432019846	7988	20	8B
0005432019852	7988	21	8D
0005433101336	7988	22	8C
0005432019834	7988	23	9B
0005432753251	7988	24	9A
0005433101327	7988	25	9C
0005432019855	7988	26	9D
0005432753250	7988	27	9F
0005433101306	7988	28	9E
0005432019847	7988	29	10A
0005433101326	7988	30	10D
0005432019850	7988	31	10C
0005432919538	7988	32	10E
0005433101323	7988	33	10F
0005433101303	7988	34	11C
0005433101335	7988	35	11E
0005432919535	7988	36	12B
0005433101301	7988	37	12C
0005433101333	7988	38	12E
0005432753249	7988	39	13C
0005432019849	7988	40	13B
0005433101325	7988	41	13D
0005433101299	7988	42	13E
0005432019845	7988	43	14A
0005433101300	7988	44	14B
0005432919543	7988	45	14C
0005433101343	7988	46	14E
0005433101292	7988	47	14D
0005432019833	7988	48	15A
0005432019848	7988	49	14F
0005432019856	7988	50	15B
0005432919527	7988	51	15C
0005433101337	7988	52	15D
0005432919528	7988	53	15E
0005433101339	7988	54	16A
0005432677511	7988	55	15F
0005433101321	7988	56	16B
0005433101310	7988	57	16D
0005432019836	7988	58	16E
0005432019843	7988	59	17A
0005433101322	7988	60	17B
0005433101319	7988	61	17E
0005432919534	7988	62	17D
0005433101330	7988	63	17F
0005433101318	7988	64	18B
0005432677514	7988	65	18C
0005432919542	7988	66	18F
0005433101304	7988	67	19C
0005432919541	7988	68	19B
0005432751474	7988	69	19D
0005432919533	7988	70	19E
0005433101338	7988	71	20B
0005433101344	7988	72	20C
0005432019838	7988	73	20D
0005432919531	7988	74	21C
0005433101297	7988	75	21B
0005433101294	7988	76	21D
0005433101320	7988	77	21E
0005432044481	7988	78	22B
0005433101291	7988	79	22C
0005432391953	7988	80	22E
0005433101329	7988	81	22D
0005433101331	7988	82	23A
0005432919544	7988	83	23C
0005432919537	7988	84	23E
0005432753248	7988	85	23F
0005433101315	7988	86	24C
0005432677513	7988	87	24E
0005433101324	7988	88	24D
0005432019859	7988	89	25B
0005433101296	7988	90	25E
0005433101334	7988	91	25F
0005432677512	7988	92	26B
0005432919526	7988	93	26A
0005433101311	7988	94	26C
0005433101332	7988	95	26D
0005433101312	7988	96	26F
0005432919532	7988	97	26E
0005432751475	7988	98	27A
0005432919539	7988	99	27C
0005432751476	7988	100	27F
0005433101305	7988	101	27E
0005432044482	7988	102	28A
0005432019854	7988	103	28B
0005433101307	7988	104	28D
0005432919530	7988	105	28C
0005432019857	7988	106	28E
0005432919540	7988	107	28F
0005433101313	7988	108	29B
0005432019853	7988	109	29C
0005432919525	7988	110	29D
0005433101342	7988	111	29F
0005432019841	7988	112	30B
0005432391954	7988	113	30C
0005433101314	7988	114	30D
0005432045584	7988	115	30F
0005432919529	7988	116	30E
0005433101309	7988	117	31B
0005433101308	7988	118	31C
0005432019851	7988	119	31D
0005432019837	7988	120	31F
0005432901330	7989	1	2C
0005432901336	7989	2	6F
0005432901340	7989	3	8C
0005432901342	7989	4	8B
0005432901343	7989	5	8F
0005432002045	7989	6	10B
0005432901339	7989	7	10C
0005432901333	7989	8	11E
0005432901329	7989	9	14F
0005432901332	7989	10	15C
0005432901338	7989	11	21A
0005432901344	7989	12	22B
0005432901341	7989	13	23C
0005432901331	7989	14	23D
0005432901345	7989	15	24B
0005432901337	7989	16	24F
0005432901335	7989	17	25F
0005432002044	7989	18	27B
0005432901346	7989	19	27F
0005432901334	7989	20	30F
0005433870698	9656	1	1A
0005433870696	9656	2	1B
0005433870697	9656	3	5B
0005434175690	32343	1	2A
0005434175688	32343	2	4A
0005434175687	32343	3	5A
0005434175689	32343	4	6A
0005434426152	3512	1	1C
0005434876775	3512	2	1H
0005434876819	3512	3	1D
0005434426162	3512	4	2D
0005432799016	3512	5	2C
0005434426169	3512	6	2A
0005435625911	3512	7	2G
0005435125733	3512	8	3A
0005432799036	3512	9	3H
0005434876776	3512	10	4A
0005435125739	3512	11	4G
0005435125766	3512	12	4K
0005432799024	3512	13	5A
0005434876785	3512	14	5H
0005434937835	3512	15	11A
0005434426172	3512	16	5K
0005434426156	3512	17	11C
0005434876780	3512	18	11F
0005434876808	3512	19	11K
0005434876760	3512	20	11H
0005434876834	3512	21	12C
0005434426157	3512	22	12E
0005434937847	3512	23	12G
0005434876809	3512	24	12F
0005434937851	3512	25	12K
0005432613800	3512	26	13A
0005434876797	3512	27	13F
0005432799018	3512	28	13E
0005434876822	3512	29	13H
0005434876778	3512	30	13G
0005434876829	3512	31	14A
0005434876801	3512	32	13K
0005434876828	3512	33	14C
0005434876799	3512	34	14G
0005432611649	3512	35	14F
0005434876761	3512	36	14K
0005434426146	3512	37	14H
0005434876831	3512	38	15C
0005434876750	3512	39	15E
0005434876759	3512	40	15D
0005434876754	3512	41	15H
0005435125731	3512	42	15F
0005432799017	3512	43	15K
0005432799022	3512	44	16C
0005434876764	3512	45	16H
0005432183435	3512	46	16G
0005434876820	3512	47	17C
0005432188560	3512	48	16K
0005432799031	3512	49	17D
0005434876836	3512	50	17H
0005432799028	3512	51	17G
0005434876786	3512	52	17F
0005434876752	3512	53	17K
0005434876788	3512	54	18E
0005435125751	3512	55	18C
0005434876832	3512	56	18J
0005434937844	3512	57	18H
0005434426155	3512	58	19A
0005435125730	3512	59	19D
0005434876777	3512	60	19C
0005432799023	3512	61	19E
0005435125764	3512	62	19H
0005434426171	3512	63	19G
0005434876804	3512	64	19K
0005435125736	3512	65	19J
0005434876802	3512	66	20C
0005434426165	3512	67	20B
0005435625909	3512	68	20E
0005435125757	3512	69	20D
0005432799034	3512	70	20G
0005435625910	3512	71	20F
0005434876782	3512	72	20J
0005434426167	3512	73	21B
0005432183433	3512	74	20K
0005434876755	3512	75	21D
0005434426161	3512	76	21C
0005434876846	3512	77	21F
0005435625902	3512	78	21E
0005432188559	3512	79	21J
0005432799030	3512	80	21H
0005432799039	3512	81	22B
0005432611647	3512	82	22E
0005434876805	3512	83	22D
0005432799019	3512	84	22H
0005434876787	3512	85	22K
0005434426147	3512	86	23B
0005432799011	3512	87	23G
0005434426148	3512	88	23J
0005434876781	3512	89	23H
0005435625912	3512	90	24D
0005434426170	3512	91	25C
0005435125768	3512	92	25G
0005434876806	3512	93	25K
0005434426166	3512	94	25J
0005435125732	3512	95	26B
0005434876763	3512	96	26D
0005432799037	3512	97	26F
0005435625901	3512	98	26J
0005432188557	3512	99	27A
0005434876774	3512	100	27C
0005435125760	3512	101	27F
0005432183434	3512	102	27H
0005434876792	3512	103	27G
0005434876771	3512	104	28A
0005434876758	3512	105	27J
0005432799020	3512	106	28B
0005435125737	3512	107	28E
0005434426153	3512	108	28D
0005435125742	3512	109	28F
0005434876751	3512	110	28J
0005435625900	3512	111	28H
0005435125752	3512	112	29B
0005432613797	3512	113	29A
0005434876770	3512	114	29C
0005434937840	3512	115	29F
0005435125767	3512	116	29E
0005434876837	3512	117	29H
0005435625905	3512	118	29K
0005435125734	3512	119	30B
0005432611648	3512	120	30A
0005432188558	3512	121	30E
0005432799015	3512	122	30F
0005434876793	3512	123	31A
0005432799021	3512	124	30K
0005435125753	3512	125	31F
0005434426159	3512	126	31E
0005434876757	3512	127	31H
0005432799013	3512	128	31G
0005434876823	3512	129	32A
0005434426149	3512	130	32E
0005435625907	3512	131	32D
0005435125754	3512	132	32J
0005435125770	3512	133	33A
0005434876844	3512	134	33D
0005434876773	3512	135	33E
0005434876821	3512	136	33G
0005434426164	3512	137	34A
0005435125738	3512	138	33J
0005434876803	3512	139	34C
0005432799035	3512	140	34B
0005435125749	3512	141	34E
0005434876817	3512	142	34F
0005434426158	3512	143	34J
0005434876825	3512	144	35G
0005435125740	3512	145	35F
0005434937846	3512	146	35E
0005434876824	3512	147	35H
0005434876810	3512	148	35K
0005434876766	3512	149	35J
0005432799025	3512	150	36D
0005434937839	3512	151	36C
0005434426151	3512	152	36F
0005432799027	3512	153	36H
0005434876753	3512	154	36K
0005435125759	3512	155	37B
0005434876800	3512	156	37E
0005432799014	3512	157	37D
0005434876768	3512	158	37C
0005435625906	3512	159	37G
0005432799033	3512	160	37F
0005434876827	3512	161	37J
0005434876769	3512	162	38A
0005434426160	3512	163	37K
0005435125765	3512	164	38C
0005432613798	3512	165	38J
0005434426150	3512	166	38H
0005434876765	3512	167	39B
0005435125741	3512	168	38K
0005434876813	3512	169	39E
0005435625903	3512	170	39H
0005434876833	3512	171	39G
0005434937849	3512	172	39J
0005435125747	3512	173	40C
0005434876767	3512	174	40B
0005435125769	3512	175	40G
0005434937841	3512	176	40F
0005434876789	3512	177	40J
0005434937842	3512	178	40H
0005434937833	3512	179	41A
0005434937838	3512	180	41D
0005434876784	3512	181	41C
0005435125748	3512	182	41F
0005432799038	3512	183	41H
0005435125756	3512	184	42A
0005434937834	3512	185	41K
0005435125758	3512	186	42C
0005434876762	3512	187	42B
0005434937850	3512	188	42E
0005434876826	3512	189	42D
0005434876749	3512	190	42G
0005434876796	3512	191	42F
0005434876790	3512	192	42J
0005435125744	3512	193	42H
0005435125746	3512	194	43B
0005435125755	3512	195	42K
0005432611650	3512	196	43C
0005434876794	3512	197	43E
0005432799029	3512	198	43J
0005435125761	3512	199	44C
0005434876795	3512	200	44A
0005435125735	3512	201	44E
0005434876815	3512	202	44D
0005435125762	3512	203	44H
0005434876798	3512	204	44G
0005435125771	3512	205	44F
0005434937848	3512	206	44K
0005434876842	3512	207	44J
0005432613799	3512	208	45A
0005434876835	3512	209	45C
0005435625904	3512	210	45B
0005434876756	3512	211	45D
0005434937837	3512	212	45H
0005434426173	3512	213	45G
0005435625908	3512	214	45K
0005435125750	3512	215	45J
0005434937845	3512	216	46A
0005434876816	3512	217	46E
0005434876812	3512	218	46D
0005435125743	3512	219	46F
0005434937836	3512	220	47A
0005434876818	3512	221	46K
0005434876838	3512	222	47E
0005434876814	3512	223	47D
0005434876840	3512	224	47H
0005434876772	3512	225	48D
0005434426168	3512	226	48A
0005432799032	3512	227	48F
0005434426163	3512	228	48E
0005434876779	3512	229	48H
0005434937843	3512	230	48G
0005434876843	3512	231	49A
0005434876811	3512	232	48K
0005435125745	3512	233	49D
0005434876783	3512	234	49C
0005434876830	3512	235	49F
0005432799012	3512	236	49E
0005434876807	3512	237	49H
0005432183432	3512	238	50A
0005434426154	3512	239	50D
0005435125763	3512	240	50G
0005434876791	3512	241	50F
0005434876841	3512	242	50H
0005434876839	3512	243	51E
0005432799026	3512	244	51D
0005434876845	3512	245	51G
0005435902434	14543	1	2A
0005435902429	14543	2	14K
0005435902437	14543	3	18H
0005435902431	14543	4	20G
0005435902426	14543	5	21E
0005435902427	14543	6	21K
0005435902433	14543	7	23C
0005435902430	14543	8	23F
0005435902436	14543	9	26E
0005432059475	14543	10	27B
0005432059473	14543	11	28E
0005435842314	14543	12	28H
0005435902435	14543	13	29B
0005435902425	14543	14	33C
0005432059474	14543	15	36C
0005435902428	14543	16	36F
0005435902424	14543	17	37E
0005435902422	14543	18	39C
0005435841810	14543	19	42E
0005435902421	14543	20	43F
0005435902432	14543	21	44G
0005435902423	14543	22	48K
0005434325469	3589	1	2C
0005434312286	3589	2	4B
0005434312285	3589	3	4D
0005434325477	3589	4	5A
0005434325473	3589	5	5C
0005434325467	3589	6	5D
0005434325471	3589	7	6B
0005434325468	3589	8	7A
0005434325476	3589	9	18A
0005434325474	3589	10	19C
0005434325470	3589	11	19D
0005434325472	3589	12	20B
0005434325466	3589	13	22A
0005434325475	3589	14	22D
0005435889804	15604	1	2B
0005435889805	15604	2	2C
0005435889802	15604	3	3C
0005435889803	15604	4	5A
0005435889806	15604	5	21B
0005435889801	15604	6	23A
0005435957471	666	1	1C
0005435957470	666	2	1D
0005435957474	666	3	2B
0005435957483	666	4	2C
0005435957477	666	5	3C
0005435957476	666	6	3D
0005435957473	666	7	6A
0005435957472	666	8	7A
0005435957469	666	9	18D
0005435957480	666	10	19A
0005435957475	666	11	19D
0005435957482	666	12	20C
0005435957481	666	13	20D
0005435957478	666	14	21D
0005435957479	666	15	22D
0005433420270	15173	1	1C
0005433420268	15173	2	1D
0005433420274	15173	3	2B
0005433420267	15173	4	2D
0005433420273	15173	5	4A
0005433420272	15173	6	4D
0005433420269	15173	7	7B
0005433420266	15173	8	7C
0005433420271	15173	9	21C
0005433420275	15173	10	22C
0005435629386	8905	1	1A
0005435629387	8905	2	3A
0005435629385	8905	3	3B
0005434247110	16087	1	1A
0005434247106	16087	2	3B
0005434247108	16087	3	4A
0005434247109	16087	4	5B
0005434247107	16087	5	6A
0005434247105	16087	6	6B
0005435163148	4446	1	1C
0005435163145	4446	2	2C
0005435163147	4446	3	3A
0005435163149	4446	4	3C
0005435163154	4446	5	3D
0005435163151	4446	6	4B
0005435163150	4446	7	5B
0005435163146	4446	8	18C
0005435163153	4446	9	19A
0005435163152	4446	10	20A
0005435163155	4446	11	23A
0005435933396	29518	1	1B
0005435933403	29518	2	3A
0005435933400	29518	3	3C
0005435933402	29518	4	7C
0005435933397	29518	5	20C
0005435933399	29518	6	22A
0005435933398	29518	7	22B
0005435933401	29518	8	22D
0005435797262	2862	1	1F
0005435797257	2862	2	2C
0005435797252	2862	3	7C
0005435797263	2862	4	7E
0005435797261	2862	5	8A
0005435797260	2862	6	8D
0005435797256	2862	7	9D
0005435797253	2862	8	9E
0005435797255	2862	9	11C
0005435797254	2862	10	12F
0005435797259	2862	11	13A
0005435797258	2862	12	14E
0005435797264	2862	13	19F
0005433404691	29310	1	2D
0005433404695	29310	2	4C
0005433404698	29310	3	5D
0005433404692	29310	4	9C
0005433404697	29310	5	10D
0005433404696	29310	6	11E
0005433404693	29310	7	12A
0005433404694	29310	8	20D
0005434947892	5762	1	1A
0005434947888	5762	2	1B
0005434947885	5762	3	2A
0005434947890	5762	4	2B
0005434947887	5762	5	4A
0005434947893	5762	6	4B
0005434947889	5762	7	6A
0005434947891	5762	8	5B
0005434947886	5762	9	6B
0005435376316	16423	1	2B
0005435376315	16423	2	5A
0005435376317	16423	3	5B
0005433960020	6919	1	1A
0005433959993	6919	2	1C
0005433959970	6919	3	1D
0005433959981	6919	4	2A
0005433959992	6919	5	2C
0005433960017	6919	6	2D
0005433960003	6919	7	2F
0005433960001	6919	8	3C
0005433960024	6919	9	3D
0005433959978	6919	10	3F
0005433959998	6919	11	4A
0005433959994	6919	12	4C
0005433959972	6919	13	4D
0005433959973	6919	14	4E
0005433960022	6919	15	5A
0005433959974	6919	16	5C
0005433959983	6919	17	5F
0005433959990	6919	18	6A
0005433960013	6919	19	6C
0005433960014	6919	20	6E
0005433959967	6919	21	7A
0005433960007	6919	22	7C
0005433959997	6919	23	7D
0005433959995	6919	24	7E
0005433959985	6919	25	7F
0005433960010	6919	26	8C
0005433960027	6919	27	8D
0005433959996	6919	28	8E
0005433959982	6919	29	9A
0005433959968	6919	30	9C
0005433960016	6919	31	9D
0005433960000	6919	32	9E
0005433960023	6919	33	10C
0005433959976	6919	34	10D
0005433960002	6919	35	10F
0005433959980	6919	36	11A
0005433959966	6919	37	11C
0005433960019	6919	38	11E
0005433959969	6919	39	11F
0005433960026	6919	40	12A
0005433959988	6919	41	12D
0005433960012	6919	42	12E
0005433960025	6919	43	13A
0005433960006	6919	44	13C
0005433959965	6919	45	13F
0005433959987	6919	46	14D
0005433959991	6919	47	15A
0005433959984	6919	48	15C
0005433960021	6919	49	15E
0005433959975	6919	50	16A
0005433960009	6919	51	16C
0005433960011	6919	52	16E
0005433959989	6919	53	16F
0005433959964	6919	54	17A
0005433959971	6919	55	17C
0005433959999	6919	56	17E
0005433960004	6919	57	17F
0005433960008	6919	58	18A
0005433960005	6919	59	18C
0005433959986	6919	60	18E
0005433959979	6919	61	19E
0005433959977	6919	62	19F
0005433960018	6919	63	20A
0005433960015	6919	64	20C
0005435082652	26095	1	1A
0005435082656	26095	2	1B
0005435082655	26095	3	2A
0005435082661	26095	4	2B
0005435082653	26095	5	3B
0005435082654	26095	6	3A
0005435082651	26095	7	4A
0005435082659	26095	8	5A
0005435082650	26095	9	4B
0005435082658	26095	10	5B
0005435082657	26095	11	6A
0005435082660	26095	12	6B
0005434244534	5036	1	2D
0005434244524	5036	2	5A
0005434244520	5036	3	6A
0005434244527	5036	4	6F
0005434244533	5036	5	9C
0005434244516	5036	6	10E
0005434244526	5036	7	12D
0005434244525	5036	8	14A
0005432166850	5036	9	13F
0005434244519	5036	10	14D
0005434244515	5036	11	15F
0005434244532	5036	12	16B
0005434244522	5036	13	17C
0005434244538	5036	14	17F
0005434244521	5036	15	17E
0005434244523	5036	16	18C
0005434244530	5036	17	18F
0005434244539	5036	18	21A
0005432166851	5036	19	21E
0005434244542	5036	20	22E
0005434244535	5036	21	23B
0005434244537	5036	22	24A
0005432166852	5036	23	24F
0005434244531	5036	24	25E
0005434244518	5036	25	26B
0005434244517	5036	26	26F
0005434244529	5036	27	26E
0005434244541	5036	28	27B
0005434244528	5036	29	28D
0005434244543	5036	30	28F
0005434244536	5036	31	30C
0005434244540	5036	32	31E
0005433613582	5035	1	1A
0005433613543	5035	2	1C
0005433784383	5035	3	1D
0005432667421	5035	4	2A
0005433613546	5035	5	1F
0005433784384	5035	6	2C
0005433613554	5035	7	2F
0005433613557	5035	8	2D
0005433613544	5035	9	3A
0005433613552	5035	10	3C
0005433784397	5035	11	3D
0005432104821	5035	12	4A
0005433784368	5035	13	3F
0005433613606	5035	14	4C
0005433613571	5035	15	4D
0005433784393	5035	16	5A
0005433613547	5035	17	4F
0005433613570	5035	18	5C
0005432104840	5035	19	5F
0005433613592	5035	20	5D
0005433613541	5035	21	6A
0005432104855	5035	22	6D
0005433613590	5035	23	6C
0005432145081	5035	24	6F
0005432104844	5035	25	7A
0005433784385	5035	26	7C
0005432104842	5035	27	7D
0005432104822	5035	28	8A
0005433784388	5035	29	7F
0005433613558	5035	30	8B
0005433784391	5035	31	8C
0005432104857	5035	32	8E
0005433613561	5035	33	8D
0005433784370	5035	34	8F
0005433784386	5035	35	9B
0005433613566	5035	36	9A
0005433613560	5035	37	9C
0005432104814	5035	38	9D
0005432666357	5035	39	9F
0005432665241	5035	40	9E
0005432145079	5035	41	10A
0005433784396	5035	42	10C
0005433613593	5035	43	10B
0005433613605	5035	44	10D
0005432104832	5035	45	10E
0005433784387	5035	46	10F
0005433613537	5035	47	11B
0005433613550	5035	48	11A
0005432104853	5035	49	11C
0005433613584	5035	50	11D
0005433784374	5035	51	11F
0005433784376	5035	52	11E
0005433784400	5035	53	12A
0005432104816	5035	54	12B
0005432104847	5035	55	12D
0005432104830	5035	56	12C
0005433613598	5035	57	12E
0005432666355	5035	58	12F
0005433784379	5035	59	13A
0005432666356	5035	60	13C
0005433784395	5035	61	13B
0005432104825	5035	62	13D
0005433613538	5035	63	13F
0005433613572	5035	64	13E
0005433784390	5035	65	14A
0005433613607	5035	66	14B
0005433784372	5035	67	14C
0005433613540	5035	68	14E
0005433613587	5035	69	14D
0005432104851	5035	70	14F
0005432104812	5035	71	15B
0005433613604	5035	72	15A
0005432104829	5035	73	15C
0005432104838	5035	74	15D
0005433613549	5035	75	15E
0005432104811	5035	76	16A
0005432104839	5035	77	15F
0005433613563	5035	78	16B
0005433784389	5035	79	16D
0005433613562	5035	80	16C
0005433613602	5035	81	16E
0005433613595	5035	82	17A
0005432667422	5035	83	16F
0005433613565	5035	84	17B
0005433784392	5035	85	17C
0005432104831	5035	86	17D
0005433613548	5035	87	17E
0005433784371	5035	88	18A
0005432104837	5035	89	17F
0005432104843	5035	90	18B
0005433613559	5035	91	18D
0005433784398	5035	92	18C
0005433784399	5035	93	18E
0005432145080	5035	94	18F
0005432104856	5035	95	19C
0005433613545	5035	96	19B
0005433613555	5035	97	19D
0005433784381	5035	98	19E
0005433613574	5035	99	20B
0005433613601	5035	100	20A
0005432104841	5035	101	20C
0005432104834	5035	102	20D
0005433784378	5035	103	20E
0005432104850	5035	104	21B
0005433613576	5035	105	21A
0005433613539	5035	106	20F
0005432104836	5035	107	21D
0005432104826	5035	108	21C
0005433613600	5035	109	21E
0005432104833	5035	110	21F
0005433784375	5035	111	22B
0005433613583	5035	112	22A
0005433613588	5035	113	22C
0005432104849	5035	114	22E
0005433613597	5035	115	22D
0005433613577	5035	116	22F
0005432104846	5035	117	23B
0005433613564	5035	118	23A
0005432104827	5035	119	23C
0005433613585	5035	120	23D
0005433784373	5035	121	23F
0005433613603	5035	122	23E
0005432104818	5035	123	24A
0005433613610	5035	124	24B
0005433613556	5035	125	24D
0005433784377	5035	126	24C
0005433613591	5035	127	24F
0005432104809	5035	128	24E
0005433613579	5035	129	25A
0005432104820	5035	130	25C
0005432104835	5035	131	25B
0005432104858	5035	132	25D
0005432104815	5035	133	25F
0005433784369	5035	134	25E
0005433784394	5035	135	26A
0005433613575	5035	136	26B
0005433784367	5035	137	26C
0005433613608	5035	138	26E
0005433613567	5035	139	26D
0005432104810	5035	140	26F
0005433613568	5035	141	27A
0005432104823	5035	142	27C
0005433613581	5035	143	27B
0005432665242	5035	144	27D
0005432104813	5035	145	27F
0005433613609	5035	146	27E
0005432665243	5035	147	28A
0005433613553	5035	148	28B
0005433613594	5035	149	28C
0005433613569	5035	150	28E
0005433613596	5035	151	28D
0005433613580	5035	152	28F
0005432104828	5035	153	29B
0005432104845	5035	154	29A
0005433613536	5035	155	29C
0005433613573	5035	156	29E
0005433784382	5035	157	29D
0005432104848	5035	158	29F
0005432104824	5035	159	30A
0005433613542	5035	160	30B
0005432104852	5035	161	30C
0005432104819	5035	162	30E
0005433613586	5035	163	30D
0005433613578	5035	164	30F
0005432104854	5035	165	31A
0005433613599	5035	166	31C
0005433784380	5035	167	31B
0005433613589	5035	168	31D
0005433613551	5035	169	31E
0005432104817	5035	170	31F
0005434173456	5033	1	1A
0005434229015	5033	2	1F
0005434229017	5033	3	2F
0005434229028	5033	4	3C
0005434264752	5033	5	3D
0005434149555	5033	6	5C
0005434149545	5033	7	5D
0005434264740	5033	8	6C
0005434264745	5033	9	7A
0005434229031	5033	10	7D
0005434173458	5033	11	8A
0005434173457	5033	12	8F
0005434264731	5033	13	9C
0005434229016	5033	14	9F
0005434229018	5033	15	10B
0005434229021	5033	16	10D
0005434149550	5033	17	10E
0005434264736	5033	18	10F
0005434264753	5033	19	11B
0005434264743	5033	20	11A
0005434149547	5033	21	11D
0005434149556	5033	22	12C
0005434264747	5033	23	12B
0005434229032	5033	24	12E
0005434229030	5033	25	12D
0005434264749	5033	26	13B
0005434264733	5033	27	13D
0005434264748	5033	28	14A
0005434149552	5033	29	14E
0005434264730	5033	30	15B
0005434264737	5033	31	15C
0005434229026	5033	32	15E
0005434149549	5033	33	16D
0005434229033	5033	34	16E
0005434149553	5033	35	17B
0005434229029	5033	36	17A
0005434264741	5033	37	17E
0005434229013	5033	38	17D
0005434264732	5033	39	17F
0005434229034	5033	40	18D
0005434264729	5033	41	19C
0005434229019	5033	42	20A
0005434229014	5033	43	20D
0005434149544	5033	44	20C
0005434264750	5033	45	20E
0005434229020	5033	46	21B
0005434229027	5033	47	22B
0005434229022	5033	48	22A
0005434149551	5033	49	22F
0005434149554	5033	50	23C
0005434229025	5033	51	24D
0005434264742	5033	52	24C
0005434229012	5033	53	25D
0005434264735	5033	54	25F
0005434264728	5033	55	26A
0005434264746	5033	56	26C
0005434149548	5033	57	27B
0005434264744	5033	58	29A
0005434149546	5033	59	29E
0005434264734	5033	60	30A
0005434229023	5033	61	30C
0005434264739	5033	62	30D
0005434264751	5033	63	31B
0005434229024	5033	64	31C
0005434264738	5033	65	31E
0005434173459	5033	66	31D
0005432034525	8570	1	1A
0005432034517	8570	2	1C
0005432335854	8570	3	1D
0005432034509	8570	4	2A
0005432034533	8570	5	2F
0005432034521	8570	6	3C
0005433534464	8570	7	3F
0005435006668	8570	8	3D
0005433534465	8570	9	4A
0005432335857	8570	10	4C
0005433815310	8570	11	4F
0005432034514	8570	12	5C
0005432034523	8570	13	5D
0005433690896	8570	14	5F
0005435006648	8570	15	6A
0005432034508	8570	16	6F
0005432335849	8570	17	7A
0005432034510	8570	18	7D
0005433689878	8570	19	8A
0005432034515	8570	20	7F
0005435006662	8570	21	8D
0005432034527	8570	22	8F
0005435006652	8570	23	9C
0005433815313	8570	24	9E
0005432034528	8570	25	10A
0005433815314	8570	26	10C
0005432047492	8570	27	10E
0005434311187	8570	28	10D
0005435006653	8570	29	10F
0005435286552	8570	30	11C
0005435006666	8570	31	11B
0005432034529	8570	32	11D
0005435006664	8570	33	12A
0005432335845	8570	34	12B
0005432335853	8570	35	12D
0005432047493	8570	36	12C
0005432335852	8570	37	13A
0005435006649	8570	38	13D
0005435006656	8570	39	13E
0005434311186	8570	40	14C
0005432034531	8570	41	14B
0005432034522	8570	42	14A
0005435006665	8570	43	14E
0005432034507	8570	44	14D
0005433689881	8570	45	15A
0005432034532	8570	46	15B
0005433690894	8570	47	15F
0005433690895	8570	48	16A
0005432335847	8570	49	16E
0005432335855	8570	50	17A
0005435006650	8570	51	17D
0005432034516	8570	52	17F
0005435006651	8570	53	17E
0005435006659	8570	54	18B
0005433689879	8570	55	18C
0005432034520	8570	56	18D
0005435286551	8570	57	19D
0005435006669	8570	58	19E
0005435006654	8570	59	20A
0005434311185	8570	60	20C
0005432335851	8570	61	21A
0005432034518	8570	62	21B
0005432034526	8570	63	21D
0005432335848	8570	64	21F
0005432034511	8570	65	22A
0005435286553	8570	66	22B
0005433815311	8570	67	22D
0005435006670	8570	68	22F
0005432047494	8570	69	22E
0005432034513	8570	70	23B
0005435006663	8570	71	24D
0005435286549	8570	72	24E
0005435006667	8570	73	24F
0005435006658	8570	74	25A
0005432034506	8570	75	26A
0005433688778	8570	76	25F
0005433815312	8570	77	26F
0005433534466	8570	78	27C
0005432335850	8570	79	27E
0005435006671	8570	80	28B
0005433688777	8570	81	29A
0005435006647	8570	82	28F
0005432335846	8570	83	29C
0005435006661	8570	84	29D
0005433689880	8570	85	29E
0005435286550	8570	86	30A
0005435006655	8570	87	30B
0005435006657	8570	88	30D
0005432034530	8570	89	30C
0005432034512	8570	90	30E
0005432034519	8570	91	30F
0005432034524	8570	92	31A
0005435006660	8570	93	31C
0005432335856	8570	94	31D
0005433202137	12637	1	1C
0005433202141	12637	2	4C
0005433202142	12637	3	5A
0005433202145	12637	4	5B
0005433202140	12637	5	5D
0005433202139	12637	6	6B
0005433202133	12637	7	7A
0005433202144	12637	8	7D
0005433202136	12637	9	18B
0005433202135	12637	10	18C
0005433202143	12637	11	19A
0005433202134	12637	12	20C
0005433202138	12637	13	22A
0005433202146	12637	14	22C
0005434638899	23344	1	1A
0005432290583	23344	2	1B
0005434638888	23344	3	1C
0005434638890	23344	4	1D
0005434638893	23344	5	2B
0005434638883	23344	6	2C
0005434638882	23344	7	3A
0005434638894	23344	8	3B
0005434638897	23344	9	3D
0005434638898	23344	10	4A
0005434638878	23344	11	4C
0005434638885	23344	12	5D
0005434638879	23344	13	6A
0005432290584	23344	14	6C
0005434638881	23344	15	7A
0005434638901	23344	16	7B
0005434638876	23344	17	7D
0005434638877	23344	18	18B
0005434638887	23344	19	19A
0005434638892	23344	20	19B
0005434638895	23344	21	19C
0005434638886	23344	22	20A
0005434638896	23344	23	20C
0005434638902	23344	24	20D
0005434638880	23344	25	21A
0005434638900	23344	26	21D
0005434638891	23344	27	22C
0005434638884	23344	28	22D
0005434638889	23344	29	23B
0005432054258	21084	1	2A
0005432848836	21084	2	4F
0005432054260	21084	3	8D
0005432054259	21084	4	14D
0005432054261	21084	5	17F
0005432327978	31230	1	1A
0005432287109	31230	2	1C
0005432327981	31230	3	1D
0005432382526	31230	4	1F
0005432382543	31230	5	2A
0005432382521	31230	6	2C
0005432327973	31230	7	2D
0005432382561	31230	8	2F
0005432327940	31230	9	3A
0005432382531	31230	10	3C
0005432327969	31230	11	3D
0005432382541	31230	12	3F
0005432327959	31230	13	4A
0005432327948	31230	14	4C
0005432327938	31230	15	4E
0005432382529	31230	16	4F
0005432327960	31230	17	5A
0005432382551	31230	18	5C
0005432382528	31230	19	5D
0005432382540	31230	20	5E
0005432382562	31230	21	5F
0005432327968	31230	22	6A
0005432382549	31230	23	6D
0005432327957	31230	24	6E
0005432382558	31230	25	6F
0005432382544	31230	26	7A
0005432382524	31230	27	7C
0005432327945	31230	28	7D
0005432327963	31230	29	7E
0005432382535	31230	30	7F
0005432327976	31230	31	8A
0005432382527	31230	32	8C
0005432327971	31230	33	8D
0005432327982	31230	34	8E
0005432327949	31230	35	8F
0005432327983	31230	36	9A
0005432382559	31230	37	9C
0005432382539	31230	38	9D
0005432327979	31230	39	9E
0005432382522	31230	40	9F
0005432327953	31230	41	10A
0005432327967	31230	42	10C
0005432327952	31230	43	10D
0005432382532	31230	44	10E
0005432382557	31230	45	10F
0005432327943	31230	46	11A
0005432327975	31230	47	11C
0005432382552	31230	48	11D
0005432382523	31230	49	11E
0005432327939	31230	50	11F
0005432382563	31230	51	12A
0005432382553	31230	52	12C
0005432382545	31230	53	12D
0005432327956	31230	54	12E
0005432327942	31230	55	12F
0005432327964	31230	56	13A
0005432382547	31230	57	13C
0005432287108	31230	58	13D
0005432327941	31230	59	13E
0005432327961	31230	60	13F
0005432382546	31230	61	14A
0005432382525	31230	62	14C
0005432382548	31230	63	14D
0005432327965	31230	64	14E
0005432327954	31230	65	14F
0005432382536	31230	66	15A
0005432327946	31230	67	15C
0005432327950	31230	68	15D
0005432382554	31230	69	15E
0005432382550	31230	70	15F
0005432382556	31230	71	16A
0005432287106	31230	72	16C
0005432327980	31230	73	16D
0005432382555	31230	74	16E
0005432382537	31230	75	16F
0005432382534	31230	76	17A
0005432327955	31230	77	17C
0005432327944	31230	78	17D
0005432327962	31230	79	17E
0005432327970	31230	80	17F
0005432327977	31230	81	18A
0005432327951	31230	82	18C
0005432382538	31230	83	18D
0005432287107	31230	84	18F
0005432382560	31230	85	19A
0005432327966	31230	86	19C
0005432327984	31230	87	19D
0005432382530	31230	88	19E
0005432327972	31230	89	20A
0005432327958	31230	90	19F
0005432382533	31230	91	20C
0005432327947	31230	92	20D
0005432382542	31230	93	20E
0005432327974	31230	94	20F
0005433642091	2491	1	1A
0005433642100	2491	2	2D
0005433642109	2491	3	2F
0005433642114	2491	4	3A
0005433642117	2491	5	3F
0005433642108	2491	6	4E
0005433642119	2491	7	5D
0005433642090	2491	8	6C
0005433642088	2491	9	7A
0005433642112	2491	10	7C
0005433642102	2491	11	7D
0005433642106	2491	12	8D
0005433642095	2491	13	9A
0005433642103	2491	14	9C
0005433642092	2491	15	10C
0005433642118	2491	16	11E
0005433642115	2491	17	12F
0005433642101	2491	18	13C
0005433642110	2491	19	13F
0005433642097	2491	20	14A
0005433642094	2491	21	14C
0005433642098	2491	22	14E
0005433642104	2491	23	14F
0005433642113	2491	24	15A
0005433642116	2491	25	15E
0005433642111	2491	26	16D
0005433642105	2491	27	16E
0005433642093	2491	28	16F
0005433642089	2491	29	18A
0005433642099	2491	30	20A
0005433642096	2491	31	20C
0005433642107	2491	32	20E
0005432953791	27596	1	1C
0005432953802	27596	2	1D
0005432953798	27596	3	1F
0005432953808	27596	4	2A
0005432953811	27596	5	2D
0005432953809	27596	6	3D
0005432953807	27596	7	3F
0005432953806	27596	8	4C
0005432953796	27596	9	4D
0005432953793	27596	10	5F
0005432953799	27596	11	7F
0005432953785	27596	12	8C
0005432953801	27596	13	8D
0005432953797	27596	14	9C
0005432953803	27596	15	10D
0005432953795	27596	16	11C
0005432953788	27596	17	11E
0005432953810	27596	18	12E
0005432953805	27596	19	15A
0005432953790	27596	20	14F
0005432953789	27596	21	15C
0005432953794	27596	22	15D
0005432953786	27596	23	16E
0005432953804	27596	24	17E
0005432953787	27596	25	18E
0005432953800	27596	26	19A
0005432953792	27596	27	19D
0005432423649	13331	1	1C
0005432423656	13331	2	1D
0005432423682	13331	3	2A
0005432423671	13331	4	2C
0005432423652	13331	5	2D
0005432423658	13331	6	2F
0005432423690	13331	7	3D
0005432423677	13331	8	4C
0005432423657	13331	9	4D
0005432423660	13331	10	4E
0005432423664	13331	11	4F
0005432423665	13331	12	5C
0005432423670	13331	13	5D
0005432423663	13331	14	5E
0005432423667	13331	15	5F
0005432423668	13331	16	6A
0005432423693	13331	17	6E
0005432423674	13331	18	6F
0005432423653	13331	19	7A
0005432423662	13331	20	7F
0005432423650	13331	21	9A
0005432423679	13331	22	9C
0005432423681	13331	23	9D
0005432423684	13331	24	9E
0005432423687	13331	25	9F
0005432423661	13331	26	10C
0005432423675	13331	27	10D
0005432423685	13331	28	10F
0005432423666	13331	29	11A
0005432423659	13331	30	11C
0005432423654	13331	31	13A
0005432423651	13331	32	13C
0005432423655	13331	33	13E
0005432423678	13331	34	13F
0005432423672	13331	35	14C
0005432423673	13331	36	14E
0005432423648	13331	37	15D
0005432423683	13331	38	16D
0005432423676	13331	39	16E
0005432423691	13331	40	17D
0005432423688	13331	41	17E
0005432423692	13331	42	18E
0005432423669	13331	43	19C
0005432423680	13331	44	19D
0005432423689	13331	45	20C
0005432423686	13331	46	20E
0005434448261	9596	1	1F
0005432822084	9596	2	2A
0005432817020	9596	3	2D
0005432817013	9596	4	3A
0005432817004	9596	5	3C
0005432816998	9596	6	3D
0005434448264	9596	7	4F
0005434448263	9596	8	5A
0005432817018	9596	9	5D
0005432817011	9596	10	5F
0005432288936	9596	11	6A
0005432288935	9596	12	6C
0005432817003	9596	13	6D
0005432822087	9596	14	6E
0005432817000	9596	15	6F
0005432817016	9596	16	7A
0005432817024	9596	17	7C
0005432817007	9596	18	7E
0005432817025	9596	19	8C
0005432822085	9596	20	8D
0005432817010	9596	21	9A
0005432817019	9596	22	9C
0005434448262	9596	23	10A
0005432817006	9596	24	10D
0005432817026	9596	25	10F
0005432817017	9596	26	11C
0005432817015	9596	27	11F
0005432816999	9596	28	12D
0005432822082	9596	29	12E
0005432822086	9596	30	13D
0005432817009	9596	31	14A
0005432817027	9596	32	14D
0005432288934	9596	33	14F
0005432822080	9596	34	16C
0005432817005	9596	35	16D
0005432822081	9596	36	16E
0005432817002	9596	37	17C
0005432817023	9596	38	18A
0005432817014	9596	39	18C
0005432817022	9596	40	18D
0005432817001	9596	41	18E
0005432817021	9596	42	19C
0005432817012	9596	43	19E
0005432822083	9596	44	19F
0005432817008	9596	45	20C
0005432901346	28993	1	1A
0005434157356	28993	2	1F
0005432002045	28993	3	2A
0005432901345	28993	4	2C
0005432901335	28993	5	3C
0005434157360	28993	6	3D
0005432901331	28993	7	3F
0005434157358	28993	8	4E
0005434157361	28993	9	6F
0005432901342	28993	10	7A
0005432901336	28993	11	8F
0005434157362	28993	12	9C
0005432901330	28993	13	9D
0005434186152	28993	14	9E
0005432901344	28993	15	10E
0005432901339	28993	16	11F
0005432901341	28993	17	12A
0005432901333	28993	18	12C
0005432901338	28993	19	13F
0005432901332	28993	20	14A
0005434186150	28993	21	14D
0005432901337	28993	22	16C
0005432901329	28993	23	16E
0005434157359	28993	24	16F
0005432901340	28993	25	17A
0005432901334	28993	26	18E
0005432002044	28993	27	18F
0005434186151	28993	28	19A
0005434157357	28993	29	19E
0005432901343	28993	30	20E
0005432613797	15058	1	1B
0005432611647	15058	2	2A
0005432611650	15058	3	2B
0005432611649	15058	4	3B
0005432613799	15058	5	4A
0005432613800	15058	6	5A
0005432611648	15058	7	4B
0005432613798	15058	8	6A
0005435842314	31644	1	1B
0005435841810	31644	2	4B
0005433568088	11866	1	1A
0005433568084	11866	2	2A
0005433568117	11866	3	2D
0005433568079	11866	4	3C
0005433568102	11866	5	4A
0005433568122	11866	6	4D
0005433568076	11866	7	5F
0005433568087	11866	8	5D
0005433568069	11866	9	6D
0005433568072	11866	10	7C
0005433568090	11866	11	7D
0005433568121	11866	12	7F
0005433568113	11866	13	8B
0005433568112	11866	14	8F
0005433568114	11866	15	9B
0005433568110	11866	16	9A
0005433568104	11866	17	9D
0005433568095	11866	18	9C
0005433568101	11866	19	9F
0005433568085	11866	20	10B
0005433568119	11866	21	10E
0005433568073	11866	22	10D
0005433568107	11866	23	11A
0005433568094	11866	24	11B
0005433568070	11866	25	11D
0005433568118	11866	26	12B
0005433568091	11866	27	12A
0005433568081	11866	28	12C
0005433568086	11866	29	12E
0005433568115	11866	30	13A
0005433568108	11866	31	13C
0005433568093	11866	32	13F
0005433568120	11866	33	14C
0005433568123	11866	34	14E
0005433568099	11866	35	14D
0005433568083	11866	36	15B
0005433568097	11866	37	15E
0005433568071	11866	38	15D
0005433568075	11866	39	16A
0005433568080	11866	40	15F
0005433568089	11866	41	16E
0005433568106	11866	42	16D
0005433568078	11866	43	17A
0005433568100	11866	44	17B
0005433568082	11866	45	17C
0005433568096	11866	46	18A
0005433568109	11866	47	18B
0005433568105	11866	48	18D
0005433568074	11866	49	18F
0005433568111	11866	50	19B
0005433568103	11866	51	19E
0005433568098	11866	52	19C
0005433568092	11866	53	20C
0005433568077	11866	54	21B
0005433568116	11866	55	21F
0005432947850	25328	1	1A
0005432947868	25328	2	1F
0005432947885	25328	3	1C
0005432947873	25328	4	2C
0005432947877	25328	5	2F
0005432947874	25328	6	3D
0005432947855	25328	7	4C
0005432947852	25328	8	6B
0005432947861	25328	9	6A
0005432947860	25328	10	6D
0005432947875	25328	11	6C
0005432947853	25328	12	7C
0005432947872	25328	13	7E
0005432947849	25328	14	7D
0005432947876	25328	15	7F
0005432947883	25328	16	8B
0005432947888	25328	17	8C
0005432947863	25328	18	8E
0005432947882	25328	19	9A
0005432947862	25328	20	9E
0005432947857	25328	21	9D
0005432947856	25328	22	10D
0005432947879	25328	23	10F
0005432947869	25328	24	11B
0005432947866	25328	25	11D
0005432947880	25328	26	11E
0005432947871	25328	27	12B
0005432947847	25328	28	12C
0005432947851	25328	29	12F
0005432947878	25328	30	13C
0005432947864	25328	31	13B
0005432947887	25328	32	13E
0005432947865	25328	33	15D
0005432947858	25328	34	17D
0005432947846	25328	35	18B
0005432947884	25328	36	18D
0005432947867	25328	37	18F
0005432947870	25328	38	19C
0005432947881	25328	39	19B
0005432947848	25328	40	20C
0005432947886	25328	41	20F
0005432947854	25328	42	21B
0005432947859	25328	43	21F
0005434654244	5387	1	1C
0005434654239	5387	2	1F
0005434654225	5387	3	2F
0005434654221	5387	4	3D
0005434654236	5387	5	4F
0005434654228	5387	6	5E
0005434654241	5387	7	7A
0005434654223	5387	8	7F
0005434654230	5387	9	8E
0005434654248	5387	10	8F
0005434654232	5387	11	9F
0005434654240	5387	12	10A
0005434656525	5387	13	10C
0005434654224	5387	14	10D
0005434654243	5387	15	10F
0005432114151	5387	16	11C
0005434654234	5387	17	11E
0005434654235	5387	18	12A
0005434654245	5387	19	12C
0005434654229	5387	20	12D
0005434654231	5387	21	12F
0005434654227	5387	22	13D
0005434654246	5387	23	13F
0005434654226	5387	24	14E
0005432114154	5387	25	14F
0005432114153	5387	26	15C
0005434654222	5387	27	15D
0005434654242	5387	28	16E
0005432114152	5387	29	18A
0005434656524	5387	30	18C
0005434654220	5387	31	18D
0005434654233	5387	32	19A
0005434654238	5387	33	19C
0005434654237	5387	34	19E
0005434654247	5387	35	19F
0005434654219	5387	36	20C
0005435340019	12533	1	3F
0005435555340	12533	2	5F
0005435340024	12533	3	6A
0005435340028	12533	4	6C
0005435340032	12533	5	6D
0005435340029	12533	6	8D
0005435340034	12533	7	9E
0005435340021	12533	8	10A
0005435340023	12533	9	11A
0005435555339	12533	10	11C
0005435555338	12533	11	11D
0005435340026	12533	12	11E
0005435340027	12533	13	12D
0005435340022	12533	14	12E
0005435340025	12533	15	16D
0005435340030	12533	16	17D
0005435340031	12533	17	18A
0005435340020	12533	18	18D
0005435340033	12533	19	19F
0005433715170	7422	1	1A
0005433722113	7422	2	1C
0005433715197	7422	3	1D
0005433722107	7422	4	1F
0005433722109	7422	5	2F
0005433715216	7422	6	3F
0005433715202	7422	7	4A
0005433715179	7422	8	4C
0005433715201	7422	9	4D
0005433715188	7422	10	4E
0005432078019	7422	11	5B
0005433715219	7422	12	5A
0005433715213	7422	13	5D
0005433715194	7422	14	6B
0005432078024	7422	15	6D
0005433715184	7422	16	6F
0005433715168	7422	17	6E
0005433715178	7422	18	7B
0005433722110	7422	19	7E
0005433715186	7422	20	8B
0005433722115	7422	21	8E
0005433722111	7422	22	8D
0005433715173	7422	23	9A
0005433715205	7422	24	9C
0005433715189	7422	25	9B
0005432078023	7422	26	9E
0005433719085	7422	27	10B
0005433715212	7422	28	10D
0005433715176	7422	29	10C
0005433715171	7422	30	10E
0005433715182	7422	31	11B
0005433715180	7422	32	11C
0005433722108	7422	33	11F
0005433715215	7422	34	12A
0005433719084	7422	35	12B
0005433715199	7422	36	12C
0005433715187	7422	37	12E
0005433715191	7422	38	13B
0005433715209	7422	39	13D
0005433715198	7422	40	13F
0005433722112	7422	41	14D
0005433715183	7422	42	14C
0005433690893	7422	43	14E
0005433715172	7422	44	15A
0005433715169	7422	45	15B
0005433719086	7422	46	15C
0005433689877	7422	47	15D
0005433689876	7422	48	15E
0005433715196	7422	49	16E
0005432078021	7422	50	16D
0005433715211	7422	51	17A
0005433715190	7422	52	16F
0005433715203	7422	53	17F
0005433656615	7422	54	18A
0005433656616	7422	55	18C
0005433715217	7422	56	18E
0005433715192	7422	57	18F
0005433715204	7422	58	19C
0005433715218	7422	59	19E
0005433715195	7422	60	19F
0005433715185	7422	61	20A
0005433722117	7422	62	20C
0005433719087	7422	63	20B
0005433688776	7422	64	20D
0005433715177	7422	65	20E
0005433715181	7422	66	21A
0005433715208	7422	67	21C
0005432078022	7422	68	21B
0005433715210	7422	69	21E
0005433715193	7422	70	21F
0005433715200	7422	71	22C
0005433722114	7422	72	22B
0005433715175	7422	73	22D
0005433656617	7422	74	22E
0005432078020	7422	75	23A
0005433715214	7422	76	23B
0005433722116	7422	77	23C
0005433715207	7422	78	23D
0005433715206	7422	79	23F
0005433715174	7422	80	23E
0005432006714	29231	1	3A
0005432006718	29231	2	5A
0005432428874	29231	3	5E
0005432006717	29231	4	7A
0005432428876	29231	5	6F
0005432006715	29231	6	8B
0005432006716	29231	7	14A
0005432428878	29231	8	14C
0005432428877	29231	9	22B
0005432428875	29231	10	22E
0005434095051	8672	1	2D
0005434095054	8672	2	5F
0005434095049	8672	3	7D
0005434095057	8672	4	8A
0005434095048	8672	5	9F
0005434095045	8672	6	10C
0005434095046	8672	7	10D
0005434095052	8672	8	12A
0005434095058	8672	9	12F
0005434095047	8672	10	13C
0005434181964	8672	11	13F
0005434181963	8672	12	14E
0005434095050	8672	13	16A
0005434095053	8672	14	17C
0005434095055	8672	15	18A
0005434095044	8672	16	18E
0005434095056	8672	17	20E
0005434181986	11683	1	1A
0005434181984	11683	2	3C
0005434181993	11683	3	3D
0005434181983	11683	4	5D
0005434181987	11683	5	6D
0005434184632	11683	6	8F
0005434181988	11683	7	9F
0005434181994	11683	8	10F
0005434181990	11683	9	12C
0005434181982	11683	10	14F
0005434181989	11683	11	15A
0005434181992	11683	12	16C
0005434181985	11683	13	16F
0005434183547	11683	14	17A
0005434181991	11683	15	18D
0005434184631	11683	16	19F
0005433456906	1449	1	1C
0005435732145	1449	2	1D
0005433456908	1449	3	1F
0005435732148	1449	4	2A
0005435732137	1449	5	2F
0005433456907	1449	6	3D
0005435732149	1449	7	4A
0005435732140	1449	8	4C
0005435732151	1449	9	4D
0005435732138	1449	10	4E
0005435732135	1449	11	5C
0005435732141	1449	12	6A
0005433456905	1449	13	6D
0005435732131	1449	14	8D
0005435732134	1449	15	8E
0005435732133	1449	16	9D
0005435732129	1449	17	10A
0005435732142	1449	18	10E
0005433397219	1449	19	11A
0005432297235	1449	20	12A
0005435732132	1449	21	12E
0005432297237	1449	22	13D
0005435732144	1449	23	14A
0005435732130	1449	24	14D
0005435732147	1449	25	14F
0005435732146	1449	26	17E
0005435732143	1449	27	18E
0005435732139	1449	28	18F
0005432297236	1449	29	19C
0005435732136	1449	30	19E
0005435732150	1449	31	20A
0005433397327	19260	1	1A
0005433397310	19260	2	1C
0005433397312	19260	3	1D
0005433397324	19260	4	2A
0005433397304	19260	5	2D
0005433397311	19260	6	2F
0005433397296	19260	7	3A
0005433397282	19260	8	3C
0005433397285	19260	9	4C
0005433397306	19260	10	4E
0005433397317	19260	11	4F
0005433397295	19260	12	6A
0005433397318	19260	13	6D
0005433397281	19260	14	6E
0005433397278	19260	15	6F
0005433397279	19260	16	7F
0005433397292	19260	17	8A
0005433397319	19260	18	8C
0005433397287	19260	19	8D
0005433397322	19260	20	8E
0005433397305	19260	21	8F
0005433397299	19260	22	9C
0005433397298	19260	23	9E
0005433397288	19260	24	9F
0005433397316	19260	25	10A
0005433397314	19260	26	10C
0005433397280	19260	27	10F
0005433397326	19260	28	11C
0005433397286	19260	29	11D
0005433397313	19260	30	11F
0005433397315	19260	31	12C
0005433397291	19260	32	12F
0005433397320	19260	33	13A
0005433397321	19260	34	13C
0005433397323	19260	35	13D
0005433397303	19260	36	13F
0005432906496	19260	37	16A
0005433397309	19260	38	16C
0005433397301	19260	39	16E
0005432906497	19260	40	16F
0005433397307	19260	41	17A
0005433397300	19260	42	17C
0005433397302	19260	43	17D
0005433397283	19260	44	17E
0005433397284	19260	45	18C
0005433397308	19260	46	18D
0005433397297	19260	47	19A
0005433397294	19260	48	19C
0005433397293	19260	49	19F
0005433397325	19260	50	20A
0005433397290	19260	51	20D
0005433397289	19260	52	20E
0005434443455	20576	1	1A
0005434443452	20576	2	1C
0005434443454	20576	3	2A
0005434443446	20576	4	3A
0005434443453	20576	5	3B
0005434443451	20576	6	3D
0005434443449	20576	7	4B
0005434443443	20576	8	4D
0005434443447	20576	9	5D
0005434443448	20576	10	6B
0005434443444	20576	11	19B
0005434443440	20576	12	20D
0005434443450	20576	13	21C
0005434443445	20576	14	21D
0005434443442	20576	15	22D
0005434443441	20576	16	23A
0005435377537	7246	1	1B
0005434954546	7246	2	3A
0005434954549	7246	3	4A
0005434954548	7246	4	4B
0005434954547	7246	5	5A
0005434954550	7246	6	6B
0005435377543	28360	1	3B
0005435377542	28360	2	4B
0005435377541	28360	3	6B
0005434351501	4486	1	2B
0005434351493	4486	2	2C
0005434351502	4486	3	2D
0005434351497	4486	4	3B
0005434351499	4486	5	3C
0005434351492	4486	6	4A
0005434351498	4486	7	4B
0005434351491	4486	8	7C
0005434351494	4486	9	19A
0005434351496	4486	10	19B
0005434351490	4486	11	21A
0005434351495	4486	12	21D
0005434351500	4486	13	23A
0005435893521	29685	1	3C
0005435893519	29685	2	4B
0005435893523	29685	3	5B
0005435893522	29685	4	6A
0005435893520	29685	5	7C
0005435893518	29685	6	21B
0005432293170	1050	1	2F
0005435545615	1050	2	12A
0005434445212	1050	3	15G
0005435091922	1050	4	16F
0005435091917	1050	5	17A
0005434446485	1050	6	17D
0005433463867	1050	7	17E
0005435545614	1050	8	17F
0005433462713	1050	9	18B
0005435091921	1050	10	20H
0005435091918	1050	11	20G
0005434445213	1050	12	22B
0005435091914	1050	13	22H
0005435091915	1050	14	23B
0005433463866	1050	15	23A
0005435091920	1050	16	24A
0005435091919	1050	17	27A
0005432293169	1050	18	25F
0005435545613	1050	19	28E
0005435091923	1050	20	31H
0005434446486	1050	21	32A
0005435545616	1050	22	34F
0005434446483	1050	23	37A
0005435091916	1050	24	37E
0005435091913	1050	25	38B
0005434446484	1050	26	38E
0005434446482	1050	27	39E
0005433269633	17031	1	1C
0005433341526	17031	2	1G
0005433341517	17031	3	1H
0005433341497	17031	4	2C
0005433341571	17031	5	2B
0005433341550	17031	6	2F
0005433341480	17031	7	3A
0005433341507	17031	8	3F
0005433341546	17031	9	3C
0005433341523	17031	10	3G
0005433341555	17031	11	4F
0005433341541	17031	12	5C
0005433341529	17031	13	5H
0005433341561	17031	14	9G
0005433159277	17031	15	11B
0005433341494	17031	16	11A
0005433341558	17031	17	11E
0005433269632	17031	18	11G
0005433341481	17031	19	11F
0005433341499	17031	20	11H
0005433341506	17031	21	12D
0005433341537	17031	22	12G
0005433341553	17031	23	12F
0005433341493	17031	24	14H
0005433269631	17031	25	14G
0005433341578	17031	26	15B
0005433341524	17031	27	15F
0005433341569	17031	28	15H
0005433341581	17031	29	16B
0005433341536	17031	30	16F
0005433341522	17031	31	16E
0005433341579	17031	32	17B
0005433341498	17031	33	17D
0005433341514	17031	34	17E
0005433341518	17031	35	17G
0005433341551	17031	36	17H
0005433341580	17031	37	18D
0005433341534	17031	38	18B
0005433341531	17031	39	18E
0005433341491	17031	40	19D
0005433341508	17031	41	19F
0005433341548	17031	42	19H
0005433341503	17031	43	19G
0005433341510	17031	44	20A
0005433341484	17031	45	20D
0005433341485	17031	46	20H
0005433341504	17031	47	20G
0005433269634	17031	48	21E
0005433341511	17031	49	22B
0005433341512	17031	50	22A
0005433341542	17031	51	22D
0005433341502	17031	52	22E
0005433341528	17031	53	22G
0005433341574	17031	54	22H
0005433341545	17031	55	23E
0005433341519	17031	56	23G
0005433341577	17031	57	24E
0005433341554	17031	58	24D
0005433341505	17031	59	24F
0005433341544	17031	60	24H
0005433341488	17031	61	24G
0005433341525	17031	62	25D
0005433341582	17031	63	25F
0005433341532	17031	64	27D
0005433341564	17031	65	27F
0005433341500	17031	66	28A
0005433341576	17031	67	27H
0005433341516	17031	68	28E
0005433341568	17031	69	29B
0005433341549	17031	70	28H
0005433341501	17031	71	29G
0005433341560	17031	72	29H
0005433341492	17031	73	30D
0005433269635	17031	74	30B
0005433341572	17031	75	30F
0005433341557	17031	76	30E
0005433341483	17031	77	31B
0005433341486	17031	78	31D
0005433341515	17031	79	32A
0005433341565	17031	80	32F
0005433159278	17031	81	32G
0005433341575	17031	82	33A
0005433341513	17031	83	33E
0005433341547	17031	84	33D
0005433341482	17031	85	33H
0005433341521	17031	86	33G
0005433341527	17031	87	34B
0005433341496	17031	88	34A
0005433341562	17031	89	34D
0005433341559	17031	90	34F
0005433341563	17031	91	34E
0005433341556	17031	92	34G
0005433341530	17031	93	35A
0005433341540	17031	94	34H
0005433341538	17031	95	35B
0005433341533	17031	96	35E
0005433341495	17031	97	35G
0005433341490	17031	98	35H
0005433341543	17031	99	36G
0005433341566	17031	100	37A
0005433341487	17031	101	37B
0005433341573	17031	102	37D
0005433341539	17031	103	38B
0005433341520	17031	104	38A
0005433341567	17031	105	38E
0005433341552	17031	106	38D
0005433341489	17031	107	38F
0005433341535	17031	108	38G
0005433341570	17031	109	39E
0005433341509	17031	110	39F
0005432389938	1341	1	1C
0005432389958	1341	2	2A
0005432389962	1341	3	2C
0005432391951	1341	4	3A
0005432389935	1341	5	4A
0005432389963	1341	6	3F
0005432389966	1341	7	5F
0005432389942	1341	8	6B
0005432389954	1341	9	6D
0005432389933	1341	10	7B
0005432389936	1341	11	8C
0005432389961	1341	12	8E
0005432389967	1341	13	9C
0005432389956	1341	14	9B
0005432389941	1341	15	10E
0005432389943	1341	16	10D
0005432389934	1341	17	11A
0005432389946	1341	18	11B
0005432391946	1341	19	11C
0005432389944	1341	20	11E
0005432389952	1341	21	12E
0005432389949	1341	22	13B
0005432389939	1341	23	13D
0005432389955	1341	24	15A
0005432389957	1341	25	15E
0005432389945	1341	26	15F
0005432389964	1341	27	16B
0005432391945	1341	28	17A
0005432389959	1341	29	17D
0005432389960	1341	30	17C
0005432389950	1341	31	17E
0005432389951	1341	32	18A
0005432391947	1341	33	18D
0005432389953	1341	34	19C
0005432389948	1341	35	19D
0005432389937	1341	36	19F
0005432389947	1341	37	20B
0005432389965	1341	38	20D
0005432389940	1341	39	20E
0005432391950	1341	40	21C
0005432391949	1341	41	21E
0005432391948	1341	42	21F
0005432159784	12786	1	1C
0005432159786	12786	2	1F
0005432433597	12786	3	2D
0005432159785	12786	4	3A
0005432433593	12786	5	4B
0005432159787	12786	6	5B
0005432161116	12786	7	7B
0005432433594	12786	8	9F
0005433812863	12786	9	16C
0005433812862	12786	10	18D
0005432433595	12786	11	20F
0005432433596	12786	12	21A
0005432161115	12786	13	22B
0005432161114	12786	14	23E
0005432150064	30689	1	1D
0005434066407	30689	2	1C
0005432150066	30689	3	1A
0005434081509	30689	4	1F
0005434066410	30689	5	2C
0005434081498	30689	6	2A
0005434081504	30689	7	2D
0005434066417	30689	8	2F
0005434081487	30689	9	3C
0005434081520	30689	10	3A
0005432150070	30689	11	3F
0005433989690	30689	12	4B
0005434081495	30689	13	4C
0005434066427	30689	14	4D
0005432150067	30689	15	4F
0005434081505	30689	16	4E
0005434081511	30689	17	5A
0005434066383	30689	18	5B
0005434066411	30689	19	5D
0005434066423	30689	20	5C
0005434066430	30689	21	5F
0005434081496	30689	22	5E
0005434081512	30689	23	6A
0005432186808	30689	24	6B
0005434081490	30689	25	6C
0005434066387	30689	26	6D
0005434066436	30689	27	6E
0005434066385	30689	28	6F
0005434066439	30689	29	7B
0005434081507	30689	30	7A
0005434066429	30689	31	7C
0005434066416	30689	32	7D
0005434081497	30689	33	7F
0005434066425	30689	34	7E
0005434066406	30689	35	8A
0005434066400	30689	36	8B
0005434066379	30689	37	8C
0005434066396	30689	38	8D
0005433989694	30689	39	8F
0005434066434	30689	40	8E
0005434066402	30689	41	9A
0005434066403	30689	42	9B
0005434066369	30689	43	9C
0005434066432	30689	44	9D
0005434081513	30689	45	9F
0005434081493	30689	46	10B
0005434066422	30689	47	10D
0005434066404	30689	48	10C
0005434066386	30689	49	10E
0005434081508	30689	50	11A
0005434066375	30689	51	11B
0005433989692	30689	52	11C
0005434081499	30689	53	11D
0005434066437	30689	54	11F
0005434066392	30689	55	11E
0005434066367	30689	56	12A
0005434066426	30689	57	12B
0005434066412	30689	58	12C
0005434081500	30689	59	12E
0005434066389	30689	60	12F
0005434081510	30689	61	13B
0005434066397	30689	62	13A
0005434066408	30689	63	13C
0005434066413	30689	64	13D
0005434066368	30689	65	13E
0005434081515	30689	66	13F
0005434066409	30689	67	14A
0005434066380	30689	68	14C
0005434066390	30689	69	14B
0005434066415	30689	70	14D
0005434066435	30689	71	14E
0005434066421	30689	72	14F
0005434066393	30689	73	15A
0005433989693	30689	74	15C
0005434081503	30689	75	15B
0005434066428	30689	76	15E
0005432150065	30689	77	15D
0005434066395	30689	78	15F
0005434066414	30689	79	16B
0005432150063	30689	80	16C
0005434066424	30689	81	16D
0005434066370	30689	82	16F
0005434081514	30689	83	16E
0005434066377	30689	84	17A
0005434066431	30689	85	17B
0005434081491	30689	86	17C
0005434066391	30689	87	17E
0005434066378	30689	88	17D
0005432150069	30689	89	17F
0005434066381	30689	90	18A
0005434066388	30689	91	18B
0005432150068	30689	92	18C
0005434081488	30689	93	18D
0005434066405	30689	94	18F
0005434081506	30689	95	18E
0005434081489	30689	96	19A
0005434066371	30689	97	19B
0005434081519	30689	98	19D
0005434081494	30689	99	19C
0005434066394	30689	100	19E
0005434066419	30689	101	19F
0005434066418	30689	102	20B
0005434081492	30689	103	20A
0005434081501	30689	104	20C
0005434066384	30689	105	20E
0005434066438	30689	106	20D
0005434066373	30689	107	20F
0005434081517	30689	108	21B
0005434066399	30689	109	21A
0005434066374	30689	110	21C
0005434066420	30689	111	21D
0005433989691	30689	112	21E
0005434066398	30689	113	21F
0005434066382	30689	114	22A
0005432186810	30689	115	22B
0005434081516	30689	116	22E
0005434066433	30689	117	22D
0005434066376	30689	118	23A
0005434066401	30689	119	22F
0005434081502	30689	120	23B
0005432186807	30689	121	23C
0005434081518	30689	122	23E
0005434066372	30689	123	23D
0005432186809	30689	124	23F
0005435765234	5507	1	1A
0005435765237	5507	2	1C
0005435765287	5507	3	2A
0005435765222	5507	4	1H
0005435765221	5507	5	2G
0005435765267	5507	6	3A
0005435765220	5507	7	3B
0005435765275	5507	8	3F
0005435735060	5507	9	3C
0005435720806	5507	10	3G
0005435765230	5507	11	3H
0005432140315	5507	12	4B
0005435765266	5507	13	4C
0005435765274	5507	14	4H
0005435765257	5507	15	5C
0005435722019	5507	16	5G
0005435765235	5507	17	5F
0005435765270	5507	18	9G
0005432140317	5507	19	11E
0005435720804	5507	20	12A
0005435720805	5507	21	12B
0005435765240	5507	22	12E
0005433527209	5507	23	13B
0005435765223	5507	24	13A
0005435765271	5507	25	13D
0005433529219	5507	26	13E
0005433529220	5507	27	13F
0005435765286	5507	28	13H
0005432140322	5507	29	14B
0005435765268	5507	30	14E
0005435765279	5507	31	14G
0005435765219	5507	32	15D
0005435765254	5507	33	15F
0005432140319	5507	34	15H
0005435765278	5507	35	16B
0005435765285	5507	36	16F
0005435720803	5507	37	16G
0005435765248	5507	38	17B
0005435765226	5507	39	17D
0005435765233	5507	40	17E
0005435735062	5507	41	17G
0005435765288	5507	42	18A
0005435765249	5507	43	18G
0005435765250	5507	44	19F
0005435765283	5507	45	19E
0005435725517	5507	46	19G
0005435765215	5507	47	20A
0005435765277	5507	48	20B
0005435765264	5507	49	20D
0005435765261	5507	50	20H
0005435765252	5507	51	21E
0005435765262	5507	52	21F
0005435765258	5507	53	21H
0005435765218	5507	54	22A
0005435735064	5507	55	22D
0005435765280	5507	56	22E
0005433529221	5507	57	22G
0005435765253	5507	58	23A
0005432140318	5507	59	23E
0005435765229	5507	60	23D
0005435723012	5507	61	23H
0005435765260	5507	62	24A
0005435723011	5507	63	24D
0005435722017	5507	64	24F
0005435725519	5507	65	25D
0005435765265	5507	66	24H
0005435725518	5507	67	25F
0005435765225	5507	68	25E
0005435722018	5507	69	27G
0005435765269	5507	70	28D
0005433527208	5507	71	28E
0005435765259	5507	72	28H
0005435765236	5507	73	29A
0005435765256	5507	74	29D
0005432140321	5507	75	29B
0005435765255	5507	76	30B
0005435765241	5507	77	30A
0005435765244	5507	78	30D
0005435765243	5507	79	30E
0005433527207	5507	80	30G
0005435735061	5507	81	30F
0005435765284	5507	82	31A
0005432140316	5507	83	31B
0005435765232	5507	84	31E
0005435765239	5507	85	31D
0005435765238	5507	86	31F
0005435765245	5507	87	31G
0005435765231	5507	88	31H
0005435765276	5507	89	32B
0005435765251	5507	90	32F
0005435765272	5507	91	32E
0005433527210	5507	92	32G
0005435765228	5507	93	32H
0005435765227	5507	94	33E
0005435765282	5507	95	33D
0005435765273	5507	96	33F
0005435765246	5507	97	33H
0005435765247	5507	98	34D
0005435765242	5507	99	34G
0005435765263	5507	100	34F
0005435765281	5507	101	34H
0005435765216	5507	102	36B
0005435725520	5507	103	36G
0005432140320	5507	104	37E
0005435735063	5507	105	38B
0005435765224	5507	106	38E
0005435765217	5507	107	39F
0005432535756	13451	1	1B
0005434264733	13451	2	1H
0005432194445	13451	3	1G
0005434264731	13451	4	2F
0005435461847	13451	5	3A
0005434264728	13451	6	3G
0005435461835	13451	7	3F
0005434264750	13451	8	4A
0005435461855	13451	9	5G
0005435461857	13451	10	5F
0005434264742	13451	11	9B
0005434264748	13451	12	9G
0005435461858	13451	13	11A
0005435461865	13451	14	11D
0005435461843	13451	15	11G
0005435461868	13451	16	12B
0005435461862	13451	17	12E
0005434264744	13451	18	12H
0005435461844	13451	19	12G
0005434264738	13451	20	13A
0005435461852	13451	21	13B
0005435461853	13451	22	13E
0005434264743	13451	23	14D
0005435461860	13451	24	14F
0005434264734	13451	25	14E
0005434264753	13451	26	14G
0005435043274	13451	27	15B
0005435461842	13451	28	15E
0005435461845	13451	29	15D
0005435043273	13451	30	16E
0005434264739	13451	31	18F
0005435461833	13451	32	18G
0005435461854	13451	33	18H
0005434831079	13451	34	19E
0005434831078	13451	35	20D
0005434831081	13451	36	20E
0005434264740	13451	37	20G
0005435461872	13451	38	21D
0005434264735	13451	39	21E
0005434264732	13451	40	21G
0005432535758	13451	41	22E
0005434264729	13451	42	22G
0005435043275	13451	43	23E
0005435461859	13451	44	23G
0005434264746	13451	45	24A
0005435461863	13451	46	24D
0005434264749	13451	47	24G
0005435461838	13451	48	25D
0005435461848	13451	49	27B
0005435461870	13451	50	27D
0005434264752	13451	51	28B
0005432535759	13451	52	28F
0005435461839	13451	53	29D
0005435461849	13451	54	29B
0005432535757	13451	55	29G
0005434831077	13451	56	29H
0005435461840	13451	57	30D
0005432194446	13451	58	31B
0005432194444	13451	59	31A
0005435461867	13451	60	31H
0005435461834	13451	61	32B
0005435461837	13451	62	32E
0005434264747	13451	63	32G
0005434264751	13451	64	32H
0005435461866	13451	65	33A
0005434264737	13451	66	33G
0005435461856	13451	67	34B
0005435461836	13451	68	34A
0005435461846	13451	69	34D
0005434264730	13451	70	34G
0005432194447	13451	71	35B
0005435461871	13451	72	35A
0005434831076	13451	73	35H
0005435461841	13451	74	36B
0005434264736	13451	75	36E
0005435461861	13451	76	36D
0005434264741	13451	77	36F
0005435461869	13451	78	36G
0005434264745	13451	79	37A
0005435461850	13451	80	37E
0005434831080	13451	81	37H
0005435461851	13451	82	38D
0005435461864	13451	83	38G
0005434513537	18735	1	1A
0005434514925	18735	2	2B
0005434513536	18735	3	3A
0005434514924	18735	4	5B
0005435846195	25092	1	5F
0005435846194	25092	2	6C
0005435846197	25092	3	8D
0005435846199	25092	4	9F
0005435846192	25092	5	10D
0005435846196	25092	6	12A
0005435846198	25092	7	15E
0005435846193	25092	8	18A
0005432295838	1846	1	3C
0005433810494	1846	2	11D
0005433810493	1846	3	14A
0005433810495	1846	4	15E
0005432295839	1846	5	16F
0005433007907	22565	1	1A
0005433007888	22565	2	1D
0005433284803	22565	3	1F
0005433284806	22565	4	2A
0005433007910	22565	5	2D
0005433284810	22565	6	3A
0005433007909	22565	7	3C
0005433007900	22565	8	3F
0005433284813	22565	9	4D
0005433007897	22565	10	4F
0005433007878	22565	11	5A
0005433007872	22565	12	5C
0005433007871	22565	13	5D
0005433284808	22565	14	5E
0005433007882	22565	15	5F
0005433007895	22565	16	6C
0005433007911	22565	17	6D
0005433284818	22565	18	6E
0005433007874	22565	19	6F
0005433007912	22565	20	7C
0005433007913	22565	21	7D
0005433007903	22565	22	7E
0005433007886	22565	23	7F
0005433284812	22565	24	8A
0005433284804	22565	25	8C
0005433284798	22565	26	8D
0005433007902	22565	27	9A
0005433007870	22565	28	9C
0005433284815	22565	29	9E
0005433284795	22565	30	10A
0005433007914	22565	31	10C
0005433284802	22565	32	10D
0005433007875	22565	33	10E
0005433007883	22565	34	10F
0005433007908	22565	35	11A
0005433007879	22565	36	11D
0005433007898	22565	37	11E
0005433007881	22565	38	11F
0005433007904	22565	39	12A
0005433284797	22565	40	12D
0005433284801	22565	41	12E
0005433284807	22565	42	12F
0005433284800	22565	43	13A
0005433007891	22565	44	13C
0005433007901	22565	45	13D
0005433284817	22565	46	13E
0005433007896	22565	47	13F
0005433007884	22565	48	14A
0005433284811	22565	49	14C
0005433007905	22565	50	14D
0005433284805	22565	51	14E
0005433007869	22565	52	15A
0005433007876	22565	53	15D
0005433284819	22565	54	15E
0005433007880	22565	55	15F
0005433007906	22565	56	16A
0005433007877	22565	57	16C
0005433007894	22565	58	16F
0005433007873	22565	59	17A
0005433284816	22565	60	17C
0005433007885	22565	61	17E
0005433007887	22565	62	17F
0005433007889	22565	63	18A
0005433284814	22565	64	18D
0005433007893	22565	65	18F
0005433007892	22565	66	19A
0005433007890	22565	67	19C
0005433284809	22565	68	19E
0005433284796	22565	69	19F
0005433007899	22565	70	20A
0005433284799	22565	71	20D
0005433007868	22565	72	20E
0005433284820	22565	73	20F
0005434152757	12285	1	3A
0005434152751	12285	2	5A
0005434152754	12285	3	6A
0005434152752	12285	4	10A
0005434152756	12285	5	10C
0005434152753	12285	6	11A
0005434152759	12285	7	12C
0005434152755	12285	8	19F
0005434152758	12285	9	20F
0005433845820	5596	1	1C
0005433845814	5596	2	1A
0005432081410	5596	3	1F
0005433845819	5596	4	2C
0005433845836	5596	5	2A
0005433845796	5596	6	2F
0005433845823	5596	7	3D
0005433845826	5596	8	3F
0005433815307	5596	9	4D
0005433845808	5596	10	4C
0005433845797	5596	11	4F
0005433845831	5596	12	5A
0005432081407	5596	13	5F
0005432081413	5596	14	5D
0005433845807	5596	15	6D
0005433845839	5596	16	6E
0005433845815	5596	17	7C
0005433845813	5596	18	7E
0005433845828	5596	19	7D
0005433845818	5596	20	8A
0005433845821	5596	21	8F
0005433845789	5596	22	9D
0005433845783	5596	23	9C
0005433845834	5596	24	9F
0005433845794	5596	25	9E
0005433845799	5596	26	10A
0005433845829	5596	27	10C
0005433845842	5596	28	10B
0005433845812	5596	29	10E
0005433845809	5596	30	10D
0005433845803	5596	31	11A
0005433845801	5596	32	10F
0005433845805	5596	33	11D
0005433845840	5596	34	11F
0005433845788	5596	35	12A
0005433845835	5596	36	12E
0005433845784	5596	37	12D
0005433845804	5596	38	13B
0005433845827	5596	39	12F
0005433845837	5596	40	13C
0005433845790	5596	41	13D
0005432081412	5596	42	13F
0005433845822	5596	43	14D
0005433845833	5596	44	14C
0005433845798	5596	45	14F
0005433845786	5596	46	15B
0005433815309	5596	47	15A
0005432081409	5596	48	15C
0005433845841	5596	49	15E
0005433845810	5596	50	15D
0005433845793	5596	51	16C
0005433845830	5596	52	16B
0005433845787	5596	53	16D
0005433845817	5596	54	17A
0005433845824	5596	55	16E
0005432081408	5596	56	17C
0005433845806	5596	57	17E
0005433845816	5596	58	18B
0005433845838	5596	59	18C
0005433845792	5596	60	18F
0005433845802	5596	61	18E
0005433815306	5596	62	19C
0005433845800	5596	63	19B
0005433845795	5596	64	19E
0005433815308	5596	65	19F
0005433845785	5596	66	20D
0005433845791	5596	67	20E
0005433845825	5596	68	21C
0005432081411	5596	69	21B
0005433845811	5596	70	21E
0005433845832	5596	71	21F
0005435282119	13836	1	3D
0005435282100	13836	2	4C
0005435282105	13836	3	6A
0005432003653	13836	4	6F
0005435282103	13836	5	6E
0005435282108	13836	6	7C
0005435282113	13836	7	8A
0005435282114	13836	8	9E
0005435282121	13836	9	10A
0005435282102	13836	10	10C
0005435282111	13836	11	11A
0005434173459	13836	12	11B
0005435282120	13836	13	11E
0005434173458	13836	14	12B
0005435282099	13836	15	12E
0005432003652	13836	16	13A
0005435282118	13836	17	13B
0005434173456	13836	18	14A
0005435282112	13836	19	14E
0005435282096	13836	20	15C
0005435282101	13836	21	15B
0005435282110	13836	22	15E
0005435282115	13836	23	16A
0005432003654	13836	24	15F
0005435282097	13836	25	16E
0005435282117	13836	26	16D
0005435282116	13836	27	17A
0005435282106	13836	28	16F
0005435282098	13836	29	17B
0005435282123	13836	30	17D
0005432003651	13836	31	18B
0005435282122	13836	32	18C
0005435282107	13836	33	19C
0005435282104	13836	34	20F
0005434173457	13836	35	21C
0005432003655	13836	36	21D
0005435282109	13836	37	21F
0005434620274	7815	1	1B
0005434620282	7815	2	3A
0005434620272	7815	3	3C
0005434620270	7815	4	3D
0005434620268	7815	5	4A
0005434620276	7815	6	4D
0005434620275	7815	7	5A
0005434620265	7815	8	5C
0005434620281	7815	9	5D
0005434620269	7815	10	6A
0005434620273	7815	11	6B
0005434620284	7815	12	6D
0005432112481	7815	13	18C
0005434620271	7815	14	18D
0005434620266	7815	15	19A
0005434620279	7815	16	20D
0005434620283	7815	17	21D
0005434620277	7815	18	22A
0005434620267	7815	19	22B
0005434620264	7815	20	22C
0005432112480	7815	21	22D
0005434620278	7815	22	23A
0005434620280	7815	23	23B
0005435332170	32978	1	2B
0005435332168	32978	2	3B
0005435332173	32978	3	5C
0005435332172	32978	4	6D
0005435332169	32978	5	18C
0005435332175	32978	6	19A
0005435332171	32978	7	21A
0005435332174	32978	8	21B
0005435332176	32978	9	21C
0005435332177	32978	10	22C
0005435784808	4285	1	1D
0005435784804	4285	2	2C
0005435784821	4285	3	2D
0005435784827	4285	4	3D
0005435784807	4285	5	3F
0005435784799	4285	6	4C
0005434993872	4285	7	4E
0005435784805	4285	8	5C
0005435784829	4285	9	5E
0005435784809	4285	10	6C
0005435784819	4285	11	6D
0005435784824	4285	12	7A
0005435784820	4285	13	7E
0005435784831	4285	14	8A
0005435784811	4285	15	8D
0005435784816	4285	16	9A
0005435784814	4285	17	9C
0005435784832	4285	18	9E
0005434993865	4285	19	10A
0005434993874	4285	20	10C
0005434993869	4285	21	10D
0005435784815	4285	22	10E
0005432190570	4285	23	11C
0005435784801	4285	24	12A
0005435784806	4285	25	12C
0005434993870	4285	26	12D
0005435784800	4285	27	12F
0005435784818	4285	28	13C
0005435784825	4285	29	13F
0005434993867	4285	30	14C
0005435784830	4285	31	15C
0005434993875	4285	32	15D
0005435784817	4285	33	15E
0005435784812	4285	34	15F
0005435787323	4285	35	16A
0005435784810	4285	36	16C
0005435787322	4285	37	16D
0005435784822	4285	38	16E
0005435784823	4285	39	17D
0005432190568	4285	40	17F
0005435784828	4285	41	18A
0005434993871	4285	42	18D
0005434993873	4285	43	18E
0005432190569	4285	44	19A
0005435784826	4285	45	19C
0005435784813	4285	46	19D
0005434993866	4285	47	19E
0005435784802	4285	48	19F
0005434993868	4285	49	20A
0005435784833	4285	50	20D
0005435784803	4285	51	20F
0005435918581	27290	1	2A
0005435918580	27290	2	2C
0005432195659	27290	3	3F
0005432195658	27290	4	4F
0005435937316	27290	5	6C
0005435937315	27290	6	7A
0005435918582	27290	7	9A
0005435937318	27290	8	11E
0005435918579	27290	9	12A
0005435937317	27290	10	13F
0005435918583	27290	11	14A
0005435937314	27290	12	14C
0005432146166	19858	1	20B
0005432459054	4705	1	1A
0005434081531	4705	2	1C
0005432170279	4705	3	1H
0005432170281	4705	4	2B
0005432170278	4705	5	2F
0005434081538	4705	6	2G
0005432170283	4705	7	3A
0005432566708	4705	8	2H
0005432571261	4705	9	3B
0005432566661	4705	10	3C
0005432459032	4705	11	3G
0005432459038	4705	12	4A
0005432566681	4705	13	3H
0005434081539	4705	14	4B
0005432566687	4705	15	4G
0005432186811	4705	16	4H
0005434081549	4705	17	5B
0005432459015	4705	18	5A
0005434081526	4705	19	5F
0005432566690	4705	20	5C
0005432566682	4705	21	5G
0005432566684	4705	22	5H
0005432566657	4705	23	9B
0005433452707	4705	24	9A
0005432459016	4705	25	9G
0005432566664	4705	26	9H
0005432566702	4705	27	11G
0005432459010	4705	28	11F
0005432459027	4705	29	11E
0005432459035	4705	30	11H
0005432566700	4705	31	12A
0005432459050	4705	32	12D
0005432459037	4705	33	12B
0005432566653	4705	34	12E
0005434081525	4705	35	12H
0005432566674	4705	36	13A
0005432566656	4705	37	13D
0005432459033	4705	38	13E
0005432459030	4705	39	13G
0005434081544	4705	40	13H
0005432459029	4705	41	14B
0005434081536	4705	42	14E
0005433451588	4705	43	14D
0005432459055	4705	44	14G
0005434081541	4705	45	15A
0005432566695	4705	46	15B
0005432459043	4705	47	15D
0005432186812	4705	48	15F
0005432566678	4705	49	15E
0005432459062	4705	50	15H
0005432566703	4705	51	16B
0005432459013	4705	52	16A
0005434081546	4705	53	16D
0005432566677	4705	54	16F
0005432459040	4705	55	16G
0005434081540	4705	56	17B
0005432566706	4705	57	17A
0005432566676	4705	58	17D
0005432459057	4705	59	17E
0005432459046	4705	60	17G
0005434081521	4705	61	17F
0005432566671	4705	62	17H
0005432566683	4705	63	18B
0005432566693	4705	64	18A
0005432459023	4705	65	18E
0005434081534	4705	66	18D
0005434081543	4705	67	18G
0005434081547	4705	68	19A
0005432566712	4705	69	19B
0005432170280	4705	70	19E
0005432566651	4705	71	19F
0005432566663	4705	72	19G
0005432566705	4705	73	20A
0005432566699	4705	74	20B
0005432459017	4705	75	20D
0005433726067	4705	76	20G
0005432566679	4705	77	20F
0005432459028	4705	78	21A
0005432459025	4705	79	20H
0005432566692	4705	80	21D
0005432459060	4705	81	21B
0005432459044	4705	82	21G
0005432566696	4705	83	21F
0005432459022	4705	84	21H
0005432566710	4705	85	22A
0005432459056	4705	86	22E
0005432566697	4705	87	22H
0005432459026	4705	88	23B
0005434081528	4705	89	23A
0005432566673	4705	90	23D
0005432566652	4705	91	23F
0005432459048	4705	92	23E
0005432566701	4705	93	23G
0005434081523	4705	94	24B
0005432566670	4705	95	24A
0005434081542	4705	96	24E
0005432571263	4705	97	24D
0005432459014	4705	98	24F
0005433452706	4705	99	24G
0005432459020	4705	100	25D
0005433451587	4705	101	25E
0005432459011	4705	102	27A
0005432459012	4705	103	27D
0005432459051	4705	104	27B
0005432566658	4705	105	27F
0005432170282	4705	106	27E
0005432459047	4705	107	27H
0005432566711	4705	108	27G
0005432566689	4705	109	28A
0005432566659	4705	110	28B
0005434081529	4705	111	28E
0005432566655	4705	112	28D
0005432459031	4705	113	28F
0005432459036	4705	114	28H
0005434081535	4705	115	28G
0005432566704	4705	116	29A
0005432459053	4705	117	29D
0005432566707	4705	118	29B
0005432459019	4705	119	29E
0005432459058	4705	120	29G
0005432566669	4705	121	29F
0005432459021	4705	122	29H
0005432459041	4705	123	30B
0005432459024	4705	124	30D
0005432459059	4705	125	30E
0005434081530	4705	126	30G
0005432459039	4705	127	30F
0005432566672	4705	128	31A
0005432459042	4705	129	30H
0005432566665	4705	130	31B
0005432170284	4705	131	31E
0005432186813	4705	132	31D
0005434081545	4705	133	31F
0005432459018	4705	134	31H
0005434081550	4705	135	31G
0005432566688	4705	136	32E
0005432566666	4705	137	32D
0005432186814	4705	138	32H
0005434081527	4705	139	33A
0005432566698	4705	140	33D
0005432566660	4705	141	33F
0005434081524	4705	142	34A
0005434081537	4705	143	34D
0005432566709	4705	144	34B
0005432459052	4705	145	34E
0005432571262	4705	146	34G
0005432566686	4705	147	35B
0005432566694	4705	148	35D
0005434081533	4705	149	35F
0005434081548	4705	150	35G
0005432459049	4705	151	36A
0005434081532	4705	152	35H
0005432459045	4705	153	36B
0005432566691	4705	154	36F
0005434081522	4705	155	36E
0005432566680	4705	156	36G
0005432566668	4705	157	36H
0005432566685	4705	158	37B
0005432566654	4705	159	37D
0005433726069	4705	160	37F
0005432459034	4705	161	38A
0005432566675	4705	162	38B
0005432566667	4705	163	38E
0005432566662	4705	164	38G
0005432459061	4705	165	38F
0005433726068	4705	166	39E
0005432213546	30559	1	1C
0005432213547	30559	2	4F
0005432213549	30559	3	23H
0005432161114	30559	4	29G
0005432213548	30559	5	30A
0005432161115	30559	6	33D
0005432161116	30559	7	38F
0005435720805	13618	1	1B
0005435722018	13618	2	2B
0005435720803	13618	3	3B
0005435720804	13618	4	4A
0005435722019	13618	5	5A
0005435722017	13618	6	6A
0005435720806	13618	7	6B
0005432295838	22779	1	7D
0005432295839	22779	2	18A
0005433341645	11079	1	1C
0005433341680	11079	2	1D
0005433341601	11079	3	1F
0005433341661	11079	4	2A
0005435097058	11079	5	2D
0005433341666	11079	6	3A
0005433341646	11079	7	2F
0005433341608	11079	8	3C
0005433341596	11079	9	3F
0005433341595	11079	10	3D
0005433341616	11079	11	4C
0005433341617	11079	12	4B
0005433341642	11079	13	4E
0005433341648	11079	14	4F
0005433341650	11079	15	5B
0005433341638	11079	16	5A
0005433341583	11079	17	5C
0005433341618	11079	18	5D
0005433341677	11079	19	5E
0005433341673	11079	20	6A
0005433341678	11079	21	5F
0005433341637	11079	22	6B
0005433341656	11079	23	6D
0005433341681	11079	24	6E
0005433341667	11079	25	7A
0005433341647	11079	26	6F
0005433341672	11079	27	7B
0005433341633	11079	28	7C
0005433341652	11079	29	7D
0005433341599	11079	30	7F
0005433341655	11079	31	7E
0005433341603	11079	32	8C
0005433341622	11079	33	8D
0005435097059	11079	34	8F
0005433341620	11079	35	8E
0005433341636	11079	36	9A
0005433341671	11079	37	9B
0005433341676	11079	38	9D
0005433341659	11079	39	9C
0005433341590	11079	40	9E
0005433341589	11079	41	10C
0005435097053	11079	42	10B
0005433341682	11079	43	10D
0005433341651	11079	44	10E
0005433341594	11079	45	11A
0005433341598	11079	46	11B
0005433341630	11079	47	11D
0005433341613	11079	48	11C
0005433341624	11079	49	11E
0005433341629	11079	50	11F
0005433341649	11079	51	12A
0005435097052	11079	52	12B
0005433341597	11079	53	12C
0005433341610	11079	54	12E
0005435097056	11079	55	12F
0005433341658	11079	56	13A
0005433341611	11079	57	13B
0005433341607	11079	58	13D
0005433341631	11079	59	13C
0005433341587	11079	60	13E
0005433341621	11079	61	13F
0005433341604	11079	62	14B
0005433341668	11079	63	14A
0005433341593	11079	64	14C
0005433341606	11079	65	14D
0005433341644	11079	66	14F
0005433341632	11079	67	15A
0005433341614	11079	68	15C
0005433341635	11079	69	15B
0005435097057	11079	70	15D
0005433341584	11079	71	15E
0005433341665	11079	72	15F
0005433341628	11079	73	16B
0005433341634	11079	74	16A
0005433341679	11079	75	16E
0005433341663	11079	76	16D
0005433341605	11079	77	16F
0005433341653	11079	78	17B
0005433341627	11079	79	17C
0005433341625	11079	80	17D
0005433341641	11079	81	17E
0005433341600	11079	82	18A
0005435097055	11079	83	17F
0005433341602	11079	84	18B
0005433341623	11079	85	18D
0005433341615	11079	86	18E
0005433341669	11079	87	19B
0005433341683	11079	88	19A
0005433341674	11079	89	19C
0005433341662	11079	90	19D
0005433341643	11079	91	20A
0005433341640	11079	92	20B
0005433341619	11079	93	20D
0005433341639	11079	94	20C
0005435097054	11079	95	20E
0005433341592	11079	96	21A
0005433341660	11079	97	21C
0005433341586	11079	98	21F
0005433341670	11079	99	21E
0005433341654	11079	100	22A
0005433341591	11079	101	22C
0005433341609	11079	102	22B
0005433341664	11079	103	23A
0005433341657	11079	104	22F
0005433341626	11079	105	23B
0005433341612	11079	106	23D
0005433341588	11079	107	23C
0005433341675	11079	108	23E
0005433341585	11079	109	23F
0005432293170	17107	1	5A
0005432293169	17107	2	7A
0005435545614	17107	3	8E
0005435545613	17107	4	10C
0005435380227	17107	5	14A
0005435545616	17107	6	15B
0005435380226	17107	7	16D
0005435380224	17107	8	17E
0005435380225	17107	9	20B
0005435545615	17107	10	21C
0005433481047	9085	1	1C
0005433506909	9085	2	1D
0005433506911	9085	3	1F
0005433506908	9085	4	3A
0005433506897	9085	5	3D
0005433481048	9085	6	4A
0005433506898	9085	7	5F
0005433481045	9085	8	6E
0005433506893	9085	9	9A
0005433506910	9085	10	9C
0005433506896	9085	11	10F
0005433506903	9085	12	11D
0005433506891	9085	13	11E
0005433506895	9085	14	11F
0005433506904	9085	15	12A
0005433506892	9085	16	13C
0005433506906	9085	17	13D
0005433481049	9085	18	13E
0005433506902	9085	19	14A
0005433481044	9085	20	14F
0005433506901	9085	21	15C
0005433506905	9085	22	15E
0005433481046	9085	23	16C
0005433506894	9085	24	18C
0005433481050	9085	25	18D
0005433506899	9085	26	18E
0005433506900	9085	27	19E
0005433506907	9085	28	20D
0005432919558	20475	1	1F
0005432919550	20475	2	2A
0005432919565	20475	3	3F
0005432919548	20475	4	4E
0005434158950	20475	5	4F
0005432919555	20475	6	5D
0005432919564	20475	7	6A
0005434158949	20475	8	6C
0005432919566	20475	9	7E
0005432919551	20475	10	8A
0005432919562	20475	11	8D
0005432919559	20475	12	8E
0005432919557	20475	13	9A
0005432919561	20475	14	9F
0005432919553	20475	15	10C
0005434158947	20475	16	12D
0005432919560	20475	17	13C
0005434158948	20475	18	13F
0005432919549	20475	19	14A
0005432919547	20475	20	14E
0005432919554	20475	21	15D
0005432919552	20475	22	16A
0005432919546	20475	23	18D
0005432919563	20475	24	19A
0005432919556	20475	25	20C
0005432394036	10164	1	1A
0005432394037	10164	2	1B
0005432396178	10164	3	2B
0005432396175	10164	4	3A
0005432394038	10164	5	3B
0005432396176	10164	6	4B
0005432396177	10164	7	5B
0005432394039	10164	8	6B
0005435179384	18304	1	1B
0005435179688	18304	2	3B
0005435179383	18304	3	6B
0005434928257	10935	1	3C
0005434411713	10935	2	4E
0005434928255	10935	3	4F
0005434411714	10935	4	5A
0005434411712	10935	5	10F
0005434411711	10935	6	15F
0005434928256	10935	7	16A
0005434411710	10935	8	17E
0005434928254	10935	9	19A
0005435125740	14726	1	1C
0005435554112	14726	2	1D
0005435125732	14726	3	2C
0005435125765	14726	4	2D
0005435125735	14726	5	2F
0005435125739	14726	6	3A
0005435125748	14726	7	3C
0005435125753	14726	8	3F
0005435125771	14726	9	4D
0005435125733	14726	10	4E
0005435125744	14726	11	4F
0005435625909	14726	12	5A
0005435125760	14726	13	5C
0005435125734	14726	14	5F
0005435125743	14726	15	6A
0005435625911	14726	16	6C
0005435554109	14726	17	6D
0005435125756	14726	18	7A
0005435625906	14726	19	7C
0005435556653	14726	20	7D
0005435625908	14726	21	8C
0005435125761	14726	22	8D
0005435554110	14726	23	9A
0005435625904	14726	24	9C
0005435625902	14726	25	9E
0005435125736	14726	26	10A
0005435125755	14726	27	10C
0005435125730	14726	28	10D
0005435625905	14726	29	10E
0005435125768	14726	30	11A
0005435125737	14726	31	11C
0005435625900	14726	32	11F
0005435125759	14726	33	12C
0005435125751	14726	34	12D
0005435554111	14726	35	13D
0005435556651	14726	36	13E
0005435125754	14726	37	13F
0005435625912	14726	38	14E
0005435556652	14726	39	14F
0005435625903	14726	40	15A
0005435125747	14726	41	15C
0005435554108	14726	42	15D
0005435125752	14726	43	15E
0005435125749	14726	44	16A
0005435125763	14726	45	16C
0005435125764	14726	46	16E
0005435125766	14726	47	16F
0005435125769	14726	48	17A
0005435125746	14726	49	17C
0005435125767	14726	50	17D
0005435125745	14726	51	17E
0005435125731	14726	52	17F
0005435125741	14726	53	18A
0005435125770	14726	54	18D
0005435125742	14726	55	18E
0005435125762	14726	56	19A
0005435125738	14726	57	19C
0005435625901	14726	58	19D
0005435625910	14726	59	19E
0005435625907	14726	60	19F
0005435125750	14726	61	20A
0005435125758	14726	62	20D
0005435125757	14726	63	20F
0005435715199	7107	1	1C
0005435715201	7107	2	1D
0005432398138	7107	3	2A
0005432398136	7107	4	2D
0005432400067	7107	5	3C
0005432400065	7107	6	3D
0005432400066	7107	7	4C
0005432398141	7107	8	4D
0005435715203	7107	9	4E
0005435715206	7107	10	5A
0005435715197	7107	11	5D
0005435715204	7107	12	6A
0005435715209	7107	13	6E
0005435715210	7107	14	7E
0005432398137	7107	15	8F
0005435715198	7107	16	9D
0005435715196	7107	17	10A
0005435715194	7107	18	10D
0005432398139	7107	19	12D
0005435715195	7107	20	13F
0005435715208	7107	21	14D
0005435715205	7107	22	16F
0005435715211	7107	23	18A
0005432400068	7107	24	18E
0005432398140	7107	25	19D
0005435715202	7107	26	20C
0005435715207	7107	27	20E
0005435715200	7107	28	20F
0005435178470	27100	1	1C
0005435443164	27100	2	2A
0005435443165	27100	3	7C
0005435178977	27100	4	7E
0005435443168	27100	5	10C
0005435443171	27100	6	12F
0005435443163	27100	7	13F
0005435443169	27100	8	16C
0005435178469	27100	9	17C
0005435443170	27100	10	18A
0005435443172	27100	11	18C
0005435443166	27100	12	18F
0005435443167	27100	13	20A
0005434084859	2734	1	1A
0005434084860	2734	2	4B
0005434084858	2734	3	6B
0005433060371	28467	1	2B
0005433060370	28467	2	3A
0005433060372	28467	3	5A
0005435528913	22230	1	1D
0005435528920	22230	2	1F
0005435528912	22230	3	2A
0005435540649	22230	4	2C
0005435540646	22230	5	2D
0005435540644	22230	6	3A
0005435540653	22230	7	3D
0005435540664	22230	8	4E
0005435528905	22230	9	4F
0005435540647	22230	10	5A
0005435528917	22230	11	5F
0005435540645	22230	12	6D
0005435540659	22230	13	6F
0005435528907	22230	14	7A
0005435540657	22230	15	7F
0005432294448	22230	16	8C
0005435528921	22230	17	8F
0005432294449	22230	18	9D
0005435540656	22230	19	10A
0005435528919	22230	20	10F
0005435540663	22230	21	11C
0005435540648	22230	22	11D
0005435528908	22230	23	11E
0005435540661	22230	24	11F
0005435540658	22230	25	12A
0005435528901	22230	26	12D
0005435540650	22230	27	12E
0005435528915	22230	28	12F
0005435528902	22230	29	13C
0005435540666	22230	30	13D
0005435540665	22230	31	14D
0005435540651	22230	32	15A
0005435528906	22230	33	15C
0005435528909	22230	34	15D
0005435540655	22230	35	15E
0005435540662	22230	36	17A
0005435528914	22230	37	17C
0005435528910	22230	38	17D
0005435528918	22230	39	17E
0005435528916	22230	40	18A
0005435528911	22230	41	18C
0005435540654	22230	42	18D
0005432294447	22230	43	19D
0005435528904	22230	44	19E
0005435540652	22230	45	19F
0005435528903	22230	46	20A
0005435540660	22230	47	20E
0005434906472	2261	1	1A
0005434906460	2261	2	1C
0005434906480	2261	3	1D
0005434906471	2261	4	1F
0005434906511	2261	5	2C
0005434906470	2261	6	2D
0005434906494	2261	7	2F
0005434906500	2261	8	3A
0005434906482	2261	9	4A
0005434906490	2261	10	4D
0005434906496	2261	11	4F
0005434906499	2261	12	5D
0005434906501	2261	13	5E
0005434906465	2261	14	6C
0005434906486	2261	15	6F
0005434906469	2261	16	7C
0005434906468	2261	17	7D
0005434906492	2261	18	8A
0005434906458	2261	19	8D
0005434906485	2261	20	8F
0005434906457	2261	21	9D
0005434906515	2261	22	9E
0005434906479	2261	23	10C
0005434906497	2261	24	10E
0005434906476	2261	25	11A
0005434906493	2261	26	11C
0005434906504	2261	27	11D
0005434906508	2261	28	11E
0005434906513	2261	29	12C
0005434906489	2261	30	12E
0005434906506	2261	31	12F
0005434906510	2261	32	13A
0005434906466	2261	33	13C
0005434906507	2261	34	14A
0005434906491	2261	35	14D
0005434906478	2261	36	14E
0005434906459	2261	37	14F
0005434906484	2261	38	15A
0005434906473	2261	39	15C
0005434906474	2261	40	15E
0005434906498	2261	41	15F
0005433400929	2261	42	16A
0005434906505	2261	43	16C
0005434906488	2261	44	16D
0005434906509	2261	45	16F
0005434906456	2261	46	17A
0005434906503	2261	47	17C
0005434906481	2261	48	17D
0005434906512	2261	49	17E
0005434906463	2261	50	17F
0005434906461	2261	51	18A
0005434906483	2261	52	18E
0005434906477	2261	53	18F
0005434906487	2261	54	19A
0005434906502	2261	55	19C
0005434906475	2261	56	19E
0005434906464	2261	57	19F
0005434906495	2261	58	20C
0005434906514	2261	59	20D
0005434906467	2261	60	20E
0005434906462	2261	61	20F
0005433250991	25615	1	1A
0005433400939	25615	2	1D
0005433250990	25615	3	4A
0005433251004	25615	4	4C
0005433250994	25615	5	4D
0005433251018	25615	6	5E
0005433400938	25615	7	6A
0005433250995	25615	8	6E
0005433251007	25615	9	6F
0005433251012	25615	10	7E
0005433251019	25615	11	8A
0005433251000	25615	12	8C
0005433251002	25615	13	9C
0005433251014	25615	14	9F
0005433400935	25615	15	10C
0005433251008	25615	16	10E
0005433251020	25615	17	11C
0005433400936	25615	18	12A
0005433250997	25615	19	12C
0005433251001	25615	20	12D
0005433251003	25615	21	12E
0005433251010	25615	22	12F
0005433251006	25615	23	13A
0005433251015	25615	24	13D
0005433251011	25615	25	13E
0005433250998	25615	26	14E
0005433251013	25615	27	14F
0005433250993	25615	28	16A
0005433400937	25615	29	16E
0005433250992	25615	30	17D
0005433251021	25615	31	18A
0005433250996	25615	32	18E
0005433251017	25615	33	19C
0005433251016	25615	34	19D
0005433251009	25615	35	20A
0005433250999	25615	36	20C
0005433251005	25615	37	20F
0005432620817	2520	1	1A
0005432620818	2520	2	1D
0005432620825	2520	3	3D
0005432620819	2520	4	4C
0005432620826	2520	5	4D
0005432620821	2520	6	5A
0005432620822	2520	7	5D
0005432620827	2520	8	6B
0005432620824	2520	9	6C
0005432620816	2520	10	6D
0005432620828	2520	11	18C
0005432620820	2520	12	19D
0005432620815	2520	13	20C
0005432620823	2520	14	21B
0005432862184	28051	1	5A
0005432862185	28051	2	7D
0005432862183	28051	3	18B
0005432862181	28051	4	20C
0005432862179	28051	5	21C
0005432862182	28051	6	22C
0005432862180	28051	7	22D
0005434097452	13122	1	5A
0005434097453	13122	2	6B
0005433452706	31090	1	4B
0005433451588	31090	2	5A
0005433451587	31090	3	6A
0005433452707	31090	4	6B
0005434142547	29837	1	1B
0005433134067	29837	2	2D
0005434142546	29837	3	3C
0005433134066	29837	4	3D
0005433131637	29837	5	4A
0005434142544	29837	6	4B
0005433134065	29837	7	5B
0005434183548	29837	8	5D
0005434184634	29837	9	6A
0005433134069	29837	10	7C
0005433134068	29837	11	7D
0005434183549	29837	12	18B
0005433131638	29837	13	18C
0005433131635	29837	14	20C
0005433131636	29837	15	20D
0005434142545	29837	16	21B
0005434184633	29837	17	22A
0005434184635	29837	18	22B
0005433131639	29837	19	22D
0005435696892	16463	1	1B
0005435696878	16463	2	1C
0005435696899	16463	3	2A
0005435696874	16463	4	2C
0005435696890	16463	5	2D
0005435696894	16463	6	3A
0005435696889	16463	7	3C
0005435696893	16463	8	4B
0005435696884	16463	9	5D
0005435696886	16463	10	6A
0005435696900	16463	11	6B
0005435696898	16463	12	6C
0005435696876	16463	13	6D
0005435696885	16463	14	7C
0005435696888	16463	15	7D
0005435696879	16463	16	18A
0005435696873	16463	17	18B
0005435696881	16463	18	18D
0005435696887	16463	19	19B
0005435696882	16463	20	19D
0005435696897	16463	21	20A
0005435696896	16463	22	20B
0005435696891	16463	23	20C
0005435696883	16463	24	21A
0005435696872	16463	25	21B
0005435696895	16463	26	21C
0005435696880	16463	27	22A
0005435696877	16463	28	22B
0005435696875	16463	29	22C
0005435934999	24720	1	5B
0005435935002	24720	2	19B
0005435935001	24720	3	21C
0005435935000	24720	4	22C
0005433724728	18772	1	1A
0005433724731	18772	2	2B
0005433724730	18772	3	3B
0005433724732	18772	4	6A
0005433724729	18772	5	6B
0005432968806	21600	1	3B
0005432968807	21600	2	5B
0005434087437	7309	1	1A
0005434136884	7309	2	1C
0005434136876	7309	3	1D
0005434136859	7309	4	1F
0005434136865	7309	5	2A
0005434136908	7309	6	2D
0005434136888	7309	7	2C
0005434136889	7309	8	2F
0005434136855	7309	9	3A
0005434136848	7309	10	3C
0005434136854	7309	11	3D
0005434136926	7309	12	3F
0005434136914	7309	13	4A
0005434136882	7309	14	4C
0005434136858	7309	15	4D
0005434136863	7309	16	4E
0005434136900	7309	17	4F
0005434136890	7309	18	5A
0005434136849	7309	19	5C
0005434136852	7309	20	5D
0005434136929	7309	21	5E
0005434136886	7309	22	5F
0005434136877	7309	23	6A
0005434087436	7309	24	6C
0005434136857	7309	25	6D
0005434136924	7309	26	6E
0005434136898	7309	27	6F
0005434136879	7309	28	7A
0005434136846	7309	29	7C
0005434136916	7309	30	7D
0005434087440	7309	31	7E
0005434136918	7309	32	8A
0005434136861	7309	33	8C
0005434136921	7309	34	8D
0005434136903	7309	35	8E
0005434136869	7309	36	8F
0005434136845	7309	37	9A
0005434136860	7309	38	9C
0005434087439	7309	39	9D
0005434136868	7309	40	9E
0005434136907	7309	41	9F
0005434136925	7309	42	10A
0005434136883	7309	43	10C
0005434136913	7309	44	10E
0005434136931	7309	45	10F
0005434136894	7309	46	11A
0005434136871	7309	47	11C
0005434136901	7309	48	11D
0005434136878	7309	49	11E
0005434136875	7309	50	11F
0005434136862	7309	51	12A
0005434136870	7309	52	12C
0005434136934	7309	53	12D
0005434136895	7309	54	12E
0005434136912	7309	55	12F
0005434136927	7309	56	13A
0005434136897	7309	57	13C
0005434136919	7309	58	13D
0005434136885	7309	59	13E
0005434136891	7309	60	13F
0005434136853	7309	61	14A
0005434136881	7309	62	14C
0005434136917	7309	63	14D
0005434136872	7309	64	14E
0005434136899	7309	65	14F
0005434136873	7309	66	15A
0005434136911	7309	67	15C
0005434136851	7309	68	15D
0005434136906	7309	69	15E
0005434136864	7309	70	15F
0005434136887	7309	71	16A
0005434136893	7309	72	16C
0005434136915	7309	73	16D
0005434136930	7309	74	16E
0005434136905	7309	75	16F
0005434136932	7309	76	17A
0005434136847	7309	77	17C
0005434136922	7309	78	17D
0005434136904	7309	79	17E
0005434136902	7309	80	17F
0005434136910	7309	81	18A
0005434136920	7309	82	18C
0005434087438	7309	83	18D
0005434136933	7309	84	18E
0005434136880	7309	85	18F
0005434136850	7309	86	19A
0005434136909	7309	87	19C
0005434136928	7309	88	19D
0005434136896	7309	89	19E
0005434136856	7309	90	19F
0005434136923	7309	91	20A
0005434136874	7309	92	20C
0005434136866	7309	93	20D
0005434136867	7309	94	20E
0005434136892	7309	95	20F
0005435808077	1923	1	1A
0005434610172	1923	2	1C
0005435808072	1923	3	1D
0005435808074	1923	4	3A
0005435808075	1923	5	6C
0005435808071	1923	6	7C
0005434610171	1923	7	7D
0005434610174	1923	8	18B
0005435808079	1923	9	18C
0005435808073	1923	10	18D
0005434610173	1923	11	19A
0005434610175	1923	12	19B
0005435808076	1923	13	19C
0005435808078	1923	14	20D
0005435808080	1923	15	21C
0005434503528	22906	1	1A
0005434503497	22906	2	1B
0005434503519	22906	3	1C
0005434503505	22906	4	1D
0005434503525	22906	5	2A
0005434503527	22906	6	2C
0005434503499	22906	7	2D
0005434503535	22906	8	3A
0005434503530	22906	9	3B
0005434503518	22906	10	3D
0005434503520	22906	11	4A
0005434503515	22906	12	4B
0005434503508	22906	13	4C
0005434503506	22906	14	5A
0005434503524	22906	15	5B
0005434503532	22906	16	5C
0005434503513	22906	17	6C
0005434503512	22906	18	6D
0005434503534	22906	19	7A
0005434503507	22906	20	7B
0005434503517	22906	21	7C
0005434503521	22906	22	18A
0005434503536	22906	23	18B
0005434503502	22906	24	18C
0005434503498	22906	25	19A
0005434503522	22906	26	19B
0005434503504	22906	27	19C
0005434503500	22906	28	19D
0005434503526	22906	29	20A
0005434503516	22906	30	20B
0005434503531	22906	31	20C
0005434503529	22906	32	20D
0005434503501	22906	33	21B
0005434503523	22906	34	21C
0005434503510	22906	35	21D
0005434503533	22906	36	22A
0005434503509	22906	37	22B
0005434503511	22906	38	22C
0005434503503	22906	39	22D
0005434503514	22906	40	23B
0005435078101	2171	1	1B
0005435078105	2171	2	1C
0005435078096	2171	3	2B
0005435078110	2171	4	3A
0005435078109	2171	5	3B
0005435078108	2171	6	4B
0005435078098	2171	7	4C
0005435078097	2171	8	4D
0005435078100	2171	9	6C
0005435078111	2171	10	6D
0005435078102	2171	11	18D
0005435078107	2171	12	19C
0005435078103	2171	13	19D
0005435078106	2171	14	20B
0005435078112	2171	15	21B
0005435078104	2171	16	22C
0005435078099	2171	17	22D
0005433266583	24373	1	2A
0005433266584	24373	2	3C
0005433266580	24373	3	4A
0005433266575	24373	4	5C
0005433266578	24373	5	7B
0005433266579	24373	6	18B
0005433266577	24373	7	19B
0005433266582	24373	8	20A
0005433266581	24373	9	22B
0005433266576	24373	10	23A
0005434988576	6641	1	1D
0005434988579	6641	2	4A
0005435803218	6641	3	4C
0005434988578	6641	4	5A
0005434988572	6641	5	5B
0005434988573	6641	6	6C
0005434988575	6641	7	7B
0005435803219	6641	8	7D
0005434988577	6641	9	20A
0005434988571	6641	10	22C
0005434988574	6641	11	22D
0005435464477	23624	1	2B
0005432382585	30473	1	1D
0005433449647	30473	2	1F
0005433454842	30473	3	2C
0005432382584	30473	4	2D
0005432382570	30473	5	2F
0005433449645	30473	6	3D
0005432382598	30473	7	3F
0005432382603	30473	8	4A
0005432382590	30473	9	4E
0005432382594	30473	10	4D
0005432382592	30473	11	5C
0005433449640	30473	12	5D
0005433449637	30473	13	5F
0005433449646	30473	14	6C
0005433449638	30473	15	6D
0005432382605	30473	16	6E
0005432382569	30473	17	6F
0005433449634	30473	18	7C
0005433449649	30473	19	7E
0005432382574	30473	20	7F
0005433449639	30473	21	8A
0005432382572	30473	22	8D
0005432382599	30473	23	8E
0005433454841	30473	24	8F
0005432382566	30473	25	9A
0005432382595	30473	26	9D
0005432382601	30473	27	9E
0005432382576	30473	28	10A
0005433449632	30473	29	10E
0005432382593	30473	30	11C
0005433449631	30473	31	11D
0005432382575	30473	32	11F
0005433449643	30473	33	12A
0005432382583	30473	34	12C
0005432382588	30473	35	12D
0005433449635	30473	36	12F
0005433453731	30473	37	13C
0005433449628	30473	38	13E
0005432382581	30473	39	13F
0005432382589	30473	40	14A
0005433449630	30473	41	14C
0005432382567	30473	42	14E
0005432382568	30473	43	15C
0005433453730	30473	44	15E
0005432382586	30473	45	15F
0005433449642	30473	46	16A
0005432382564	30473	47	16C
0005433449641	30473	48	16D
0005432382604	30473	49	16E
0005433453732	30473	50	16F
0005432382577	30473	51	17A
0005432382571	30473	52	17C
0005432382602	30473	53	17D
0005433449633	30473	54	17E
0005433449644	30473	55	17F
0005433449629	30473	56	18A
0005432382573	30473	57	18C
0005432382597	30473	58	18D
0005432382600	30473	59	18E
0005433449636	30473	60	18F
0005432382591	30473	61	19A
0005432382579	30473	62	19C
0005433449648	30473	63	19D
0005432382596	30473	64	19E
0005432382565	30473	65	19F
0005432382580	30473	66	20A
0005432382587	30473	67	20C
0005432382578	30473	68	20D
0005432382582	30473	69	20F
0005433788147	20813	1	1B
0005433788145	20813	2	2C
0005433788148	20813	3	4C
0005433788146	20813	4	7A
0005433788144	20813	5	7D
0005433788142	20813	6	19A
0005433788140	20813	7	21A
0005433788143	20813	8	21D
0005433788141	20813	9	23A
0005435548427	26479	1	2B
0005435548418	26479	2	3A
0005435548431	26479	3	4D
0005435548428	26479	4	5A
0005435548429	26479	5	5D
0005435548424	26479	6	6A
0005435548421	26479	7	6C
0005435548430	26479	8	6D
0005435548420	26479	9	7A
0005435548423	26479	10	7D
0005435548432	26479	11	19C
0005435548425	26479	12	19D
0005435548426	26479	13	20C
0005435548417	26479	14	21B
0005435548422	26479	15	22A
0005435548419	26479	16	22D
0005433126778	29722	1	1A
0005433129209	29722	2	1D
0005435299705	29722	3	3A
0005435299707	29722	4	3D
0005433126780	29722	5	4B
0005433129207	29722	6	4C
0005435302132	29722	7	5A
0005433129208	29722	8	5B
0005435302131	29722	9	5D
0005435299706	29722	10	6A
0005433129211	29722	11	7B
0005433126777	29722	12	18C
0005435299709	29722	13	19B
0005433126779	29722	14	19C
0005435299708	29722	15	20D
0005435302133	29722	16	21D
0005435302130	29722	17	22C
0005433129210	29722	18	23A
0005434286955	2431	1	1B
0005434286942	2431	2	1C
0005434286947	2431	3	2A
0005434286956	2431	4	2C
0005434286941	2431	5	2D
0005434286943	2431	6	3C
0005432264436	2431	7	3D
0005432264437	2431	8	4A
0005434286944	2431	9	4C
0005434286959	2431	10	5A
0005434286953	2431	11	5B
0005434286939	2431	12	5C
0005432264438	2431	13	5D
0005434286951	2431	14	6C
0005434286946	2431	15	7C
0005434286948	2431	16	7D
0005434286952	2431	17	18A
0005434286957	2431	18	18C
0005434286954	2431	19	19C
0005434286958	2431	20	20C
0005434286938	2431	21	21A
0005434286940	2431	22	21B
0005434286949	2431	23	22B
0005434286945	2431	24	23A
0005434286950	2431	25	23B
0005433109872	26854	1	1B
0005433109870	26854	2	2D
0005433109871	26854	3	4B
0005433109868	26854	4	4D
0005433109862	26854	5	6A
0005433109865	26854	6	7B
0005433109864	26854	7	7C
0005433109873	26854	8	18A
0005433109867	26854	9	19D
0005433109869	26854	10	20D
0005433109863	26854	11	21D
0005433109866	26854	12	22D
0005435856140	25456	1	2B
0005435856138	25456	2	2C
0005435856141	25456	3	4C
0005435856139	25456	4	7B
0005434273050	26623	1	1D
0005434273051	26623	2	3B
0005434272165	26623	3	4D
0005434272166	26623	4	22C
0005434520144	6099	1	1B
0005434520128	6099	2	1C
0005434520134	6099	3	1D
0005434520138	6099	4	2A
0005434520149	6099	5	2B
0005434520147	6099	6	2C
0005434520131	6099	7	2D
0005434520127	6099	8	3C
0005434520139	6099	9	4A
0005434520129	6099	10	5A
0005434520150	6099	11	6A
0005434520136	6099	12	6D
0005434520151	6099	13	7B
0005434520146	6099	14	7C
0005434520130	6099	15	18A
0005434520148	6099	16	18C
0005434520145	6099	17	18D
0005434520143	6099	18	19A
0005434520137	6099	19	19B
0005434520132	6099	20	19C
0005434520140	6099	21	19D
0005434520135	6099	22	20A
0005434520126	6099	23	20C
0005434520133	6099	24	21D
0005434520141	6099	25	22D
0005434520142	6099	26	23B
0005433650389	7160	1	1A
0005433650379	7160	2	1C
0005433650365	7160	3	1D
0005433650373	7160	4	1F
0005433650371	7160	5	2A
0005433650393	7160	6	3A
0005433650381	7160	7	3C
0005433650406	7160	8	3D
0005433650408	7160	9	3F
0005433650387	7160	10	4F
0005433650376	7160	11	5C
0005433650411	7160	12	5F
0005433650404	7160	13	6A
0005433650390	7160	14	6C
0005433650401	7160	15	7C
0005433650410	7160	16	7D
0005433650412	7160	17	7E
0005433650375	7160	18	8A
0005433650367	7160	19	8E
0005433650409	7160	20	9E
0005433650380	7160	21	9F
0005433650400	7160	22	10A
0005433650403	7160	23	10D
0005433650398	7160	24	10E
0005433650402	7160	25	11C
0005433650377	7160	26	11F
0005433650384	7160	27	12A
0005433650407	7160	28	12F
0005433650391	7160	29	13C
0005433650392	7160	30	13D
0005433650369	7160	31	13E
0005433650370	7160	32	13F
0005433650374	7160	33	14E
0005433650372	7160	34	15C
0005433650368	7160	35	15F
0005433650399	7160	36	16D
0005433650386	7160	37	16E
0005433650405	7160	38	17A
0005433650366	7160	39	17C
0005433650388	7160	40	18A
0005433650378	7160	41	18D
0005433650382	7160	42	18E
0005433650394	7160	43	18F
0005433650397	7160	44	19A
0005433650385	7160	45	19D
0005433650396	7160	46	19F
0005433650395	7160	47	20C
0005433650383	7160	48	20E
0005435263502	27622	1	1C
0005435263492	27622	2	1D
0005435263494	27622	3	2F
0005435263484	27622	4	3C
0005435263483	27622	5	4E
0005435263495	27622	6	5C
0005435263488	27622	7	5D
0005435263490	27622	8	5F
0005435263501	27622	9	10C
0005435263485	27622	10	10D
0005435263491	27622	11	10E
0005435263487	27622	12	11A
0005435263497	27622	13	11C
0005435263479	27622	14	12D
0005435263481	27622	15	12F
0005435263489	27622	16	13C
0005435263482	27622	17	13D
0005435263480	27622	18	13E
0005435263486	27622	19	17A
0005435263493	27622	20	18C
0005435263496	27622	21	19E
0005435263499	27622	22	19F
0005435263500	27622	23	20D
0005435263498	27622	24	20F
0005433867823	4782	1	1A
0005433867845	4782	2	1B
0005433867824	4782	3	1C
0005433867821	4782	4	1D
0005433867837	4782	5	2A
0005433867829	4782	6	2B
0005433867847	4782	7	2C
0005433867838	4782	8	2D
0005433867818	4782	9	3A
0005433867835	4782	10	3B
0005433867830	4782	11	4A
0005433867826	4782	12	4B
0005433867833	4782	13	4D
0005433867850	4782	14	5A
0005433867844	4782	15	5B
0005433867842	4782	16	5C
0005433867836	4782	17	5D
0005433867828	4782	18	6A
0005433867834	4782	19	6B
0005433867831	4782	20	7A
0005433867849	4782	21	7B
0005433867841	4782	22	7C
0005433867811	4782	23	7D
0005433867817	4782	24	18B
0005433867839	4782	25	18C
0005433867832	4782	26	18D
0005433867820	4782	27	19B
0005433867812	4782	28	19C
0005433867827	4782	29	20A
0005433867819	4782	30	20B
0005433867822	4782	31	20C
0005433867843	4782	32	21A
0005433867840	4782	33	21C
0005433867813	4782	34	21B
0005433867825	4782	35	21D
0005433867814	4782	36	22A
0005433867816	4782	37	22B
0005433867846	4782	38	22C
0005433867815	4782	39	22D
0005433867848	4782	40	23A
0005435860436	32574	1	3B
0005435860435	32574	2	6B
0005435860434	32574	3	7A
0005435860437	32574	4	20D
0005434663205	3417	1	2B
0005434663200	3417	2	2D
0005434663201	3417	3	3C
0005434461613	3417	4	3D
0005434663203	3417	5	5C
0005434663206	3417	6	5D
0005434663196	3417	7	6D
0005434460472	3417	8	7D
0005434663194	3417	9	18A
0005434460471	3417	10	18C
0005434663202	3417	11	20A
0005434663199	3417	12	20B
0005434461614	3417	13	21A
0005434663193	3417	14	21C
0005434663195	3417	15	22A
0005434663197	3417	16	21D
0005434663204	3417	17	22B
0005434663198	3417	18	23B
0005435911334	12500	1	1B
0005435911336	12500	2	2A
0005435911332	12500	3	4C
0005435911339	12500	4	4D
0005435911333	12500	5	7C
0005435911337	12500	6	7D
0005435911338	12500	7	19C
0005435911331	12500	8	19D
0005435911335	12500	9	22B
0005435860437	14488	1	2B
0005435860434	14488	2	19A
0005435860436	14488	3	19D
0005435860435	14488	4	23A
0005433867810	32675	1	1A
0005433867781	32675	2	1D
0005433867783	32675	3	2B
0005433867772	32675	4	2C
0005433867793	32675	5	2D
0005433867804	32675	6	3A
0005433867808	32675	7	3B
0005433867774	32675	8	3C
0005433867806	32675	9	3D
0005433867777	32675	10	4A
0005433867807	32675	11	4B
0005433867802	32675	12	4D
0005433867787	32675	13	4C
0005433867773	32675	14	5A
0005433867800	32675	15	5B
0005433867797	32675	16	5C
0005433867792	32675	17	5D
0005433867791	32675	18	6C
0005433867798	32675	19	6D
0005433867801	32675	20	7A
0005433867775	32675	21	7C
0005433867786	32675	22	7D
0005433867795	32675	23	18A
0005433867794	32675	24	18B
0005433867778	32675	25	19A
0005433867782	32675	26	19C
0005433867771	32675	27	19B
0005433867805	32675	28	19D
0005433867784	32675	29	20A
0005433867770	32675	30	20B
0005433867788	32675	31	20C
0005433867779	32675	32	20D
0005433867796	32675	33	21A
0005433867785	32675	34	21B
0005433867790	32675	35	21C
0005433867776	32675	36	21D
0005433867789	32675	37	22A
0005433867799	32675	38	22B
0005433867809	32675	39	22C
0005433867780	32675	40	22D
0005433867803	32675	41	23A
0005432798984	14837	1	1A
0005432798985	14837	2	1B
0005432798992	14837	3	1C
0005432799004	14837	4	1D
0005432798990	14837	5	2A
0005432798996	14837	6	2B
0005432799000	14837	7	2C
0005432798991	14837	8	4A
0005432798983	14837	9	4B
0005432799009	14837	10	4C
0005432798986	14837	11	5A
0005432798999	14837	12	5B
0005432799007	14837	13	5C
0005432798997	14837	14	5D
0005432799005	14837	15	6D
0005432798987	14837	16	7B
0005432799002	14837	17	7C
0005432798993	14837	18	18B
0005432799006	14837	19	18C
0005432798995	14837	20	19C
0005432799003	14837	21	19D
0005432799010	14837	22	20A
0005432799008	14837	23	20B
0005432799001	14837	24	20C
0005432798989	14837	25	21A
0005432798994	14837	26	21C
0005432798998	14837	27	22B
0005432798988	14837	28	23B
0005434406788	7036	1	1A
0005434406822	7036	2	1C
0005434406816	7036	3	1D
0005434406767	7036	4	1F
0005434406813	7036	5	2C
0005434406817	7036	6	2D
0005434406821	7036	7	2F
0005432108210	7036	8	3C
0005432153832	7036	9	3A
0005434299198	7036	10	3D
0005434406773	7036	11	3F
0005434406827	7036	12	4C
0005434299199	7036	13	4B
0005434299214	7036	14	4D
0005434406776	7036	15	4F
0005434406787	7036	16	4E
0005434299216	7036	17	5A
0005434299208	7036	18	5B
0005434406815	7036	19	5D
0005434406793	7036	20	5C
0005434299202	7036	21	5F
0005434406774	7036	22	5E
0005434406779	7036	23	6A
0005434406792	7036	24	6E
0005434406794	7036	25	6D
0005434299215	7036	26	7A
0005434406771	7036	27	6F
0005434406795	7036	28	7E
0005434406809	7036	29	7D
0005434299200	7036	30	8B
0005432153833	7036	31	8C
0005434299205	7036	32	8E
0005434299210	7036	33	8D
0005434406790	7036	34	8F
0005434299204	7036	35	9A
0005434406812	7036	36	9C
0005434406819	7036	37	9B
0005434406825	7036	38	9E
0005434406811	7036	39	9D
0005434299206	7036	40	9F
0005432108211	7036	41	10B
0005432108212	7036	42	10C
0005434406828	7036	43	11A
0005432153831	7036	44	10E
0005434299201	7036	45	11B
0005434406775	7036	46	11C
0005434406778	7036	47	11E
0005432153828	7036	48	11F
0005434406784	7036	49	12B
0005434406814	7036	50	12A
0005434299209	7036	51	12D
0005434406768	7036	52	12E
0005434299196	7036	53	12F
0005434406783	7036	54	13A
0005434406786	7036	55	13C
0005432108209	7036	56	13E
0005434406781	7036	57	13D
0005434406777	7036	58	14A
0005432153830	7036	59	13F
0005434406796	7036	60	14B
0005434406801	7036	61	14D
0005434406797	7036	62	14C
0005434406810	7036	63	14F
0005434406789	7036	64	15E
0005434406804	7036	65	15C
0005434406791	7036	66	15F
0005434406766	7036	67	16B
0005434406803	7036	68	16A
0005434299213	7036	69	16F
0005434406772	7036	70	16E
0005434299197	7036	71	17A
0005434406808	7036	72	17B
0005434299207	7036	73	17C
0005434406780	7036	74	17D
0005434406765	7036	75	17E
0005434406770	7036	76	18A
0005434406826	7036	77	18C
0005434299212	7036	78	19A
0005434406802	7036	79	19D
0005434406782	7036	80	19C
0005434406818	7036	81	19E
0005434406823	7036	82	19F
0005434406785	7036	83	20A
0005434299211	7036	84	20C
0005434406799	7036	85	20D
0005432153829	7036	86	21A
0005434406805	7036	87	21C
0005434406820	7036	88	21B
0005434299194	7036	89	21E
0005434406807	7036	90	21D
0005434406798	7036	91	22A
0005434406806	7036	92	21F
0005434299203	7036	93	22B
0005434406829	7036	94	22C
0005434406800	7036	95	22E
0005434299195	7036	96	23B
0005434406824	7036	97	23A
0005434406769	7036	98	23E
0005435293075	26880	1	1A
0005432058318	26880	2	2F
0005435310874	26880	3	3D
0005435310873	26880	4	4B
0005435293073	26880	5	4C
0005435310865	26880	6	5B
0005435293078	26880	7	5E
0005435310868	26880	8	6C
0005435310860	26880	9	6D
0005435310861	26880	10	7F
0005435310869	26880	11	7E
0005435310859	26880	12	8B
0005435310863	26880	13	8E
0005435293077	26880	14	10D
0005435293080	26880	15	12D
0005435310862	26880	16	13B
0005432058319	26880	17	13D
0005432058316	26880	18	13C
0005435293072	26880	19	13E
0005435310856	26880	20	13F
0005435310872	26880	21	14B
0005435310858	26880	22	16C
0005435310871	26880	23	16E
0005435310867	26880	24	17C
0005435293071	26880	25	17F
0005435310864	26880	26	18C
0005432058317	26880	27	18D
0005435310866	26880	28	18E
0005435293076	26880	29	18F
0005435293081	26880	30	19A
0005435293082	26880	31	19D
0005435310875	26880	32	19C
0005435310857	26880	33	20B
0005435310870	26880	34	20D
0005435293079	26880	35	22E
0005435293074	26880	36	23E
0005434512033	6483	1	1A
0005432603754	6483	2	1B
0005432603752	6483	3	1C
0005432603740	6483	4	1D
0005432603738	6483	5	2A
0005432603728	6483	6	2B
0005432603749	6483	7	2C
0005432603758	6483	8	2D
0005434512034	6483	9	3A
0005432603762	6483	10	3B
0005432603745	6483	11	3C
0005434512030	6483	12	3D
0005432603731	6483	13	4A
0005432603746	6483	14	4B
0005432603747	6483	15	4C
0005432603761	6483	16	4D
0005432603757	6483	17	5A
0005432603736	6483	18	5C
0005432603750	6483	19	5D
0005432603730	6483	20	6A
0005432603723	6483	21	6B
0005432603753	6483	22	6C
0005432603725	6483	23	6D
0005432603759	6483	24	7A
0005434512029	6483	25	7B
0005432603742	6483	26	7C
0005432603727	6483	27	7D
0005432603732	6483	28	18A
0005432603737	6483	29	18B
0005432603751	6483	30	18C
0005432603756	6483	31	18D
0005432603748	6483	32	19A
0005432603733	6483	33	19B
0005432603741	6483	34	19C
0005434512028	6483	35	19D
0005432603734	6483	36	20A
0005432603743	6483	37	20B
0005432603729	6483	38	20C
0005432603755	6483	39	21A
0005432603735	6483	40	21B
0005432603724	6483	41	21C
0005432603760	6483	42	22A
0005434512031	6483	43	22B
0005432603744	6483	44	22C
0005434512032	6483	45	22D
0005432603726	6483	46	23A
0005432603739	6483	47	23B
0005435221037	21346	1	1D
0005435221500	21346	2	7C
0005435221499	21346	3	20B
0005435221498	21346	4	22C
0005433251014	15007	1	1A
0005433250990	15007	2	2A
0005433251018	15007	3	2F
0005433251016	15007	4	3A
0005433251011	15007	5	4A
0005433251003	15007	6	4C
0005433251001	15007	7	4E
0005433250998	15007	8	5E
0005433251006	15007	9	5F
0005433251013	15007	10	6E
0005433251005	15007	11	6F
0005433251004	15007	12	7A
0005433250997	15007	13	8D
0005433250996	15007	14	8E
0005433251012	15007	15	9A
0005433251015	15007	16	9C
0005433250999	15007	17	9E
0005433250992	15007	18	12A
0005433251008	15007	19	12C
0005433250994	15007	20	13A
0005433251002	15007	21	13E
0005433251000	15007	22	13F
0005433251019	15007	23	14C
0005433251020	15007	24	14F
0005433250993	15007	25	16D
0005433251009	15007	26	17A
0005433250995	15007	27	17C
0005433251007	15007	28	17E
0005433251017	15007	29	18D
0005433251021	15007	30	20A
0005433250991	15007	31	20E
0005433251010	15007	32	20F
0005434906447	25822	1	1D
0005434906418	25822	2	2A
0005434906443	25822	3	2C
0005434906412	25822	4	2D
0005434906428	25822	5	3A
0005434906423	25822	6	3F
0005434906411	25822	7	4C
0005434906432	25822	8	4F
0005434906427	25822	9	5D
0005434906453	25822	10	5E
0005434906407	25822	11	6C
0005434906417	25822	12	7C
0005434906449	25822	13	8A
0005434906420	25822	14	8C
0005434906425	25822	15	8E
0005434906441	25822	16	9D
0005434906429	25822	17	10D
0005434906437	25822	18	10E
0005434906448	25822	19	10F
0005434906408	25822	20	11A
0005434906414	25822	21	11C
0005434906450	25822	22	11D
0005434906416	25822	23	12A
0005434906446	25822	24	12C
0005434906436	25822	25	12D
0005434906421	25822	26	12E
0005434906431	25822	27	13D
0005434906434	25822	28	13E
0005434906442	25822	29	13F
0005434906433	25822	30	14A
0005434906438	25822	31	14C
0005434906439	25822	32	14F
0005434906454	25822	33	15D
0005434906413	25822	34	16A
0005434906455	25822	35	16C
0005434906440	25822	36	16D
0005434906419	25822	37	16F
0005434906426	25822	38	17A
0005434906445	25822	39	17C
0005434906452	25822	40	18C
0005434906410	25822	41	18D
0005434906415	25822	42	18E
0005434906451	25822	43	18F
0005434906409	25822	44	19A
0005434906444	25822	45	19C
0005434906435	25822	46	19D
0005434906424	25822	47	19E
0005434906430	25822	48	20D
0005434906422	25822	49	20E
0005433007939	14152	1	2D
0005433007958	14152	2	2F
0005433007959	14152	3	3A
0005433007923	14152	4	3F
0005433007953	14152	5	4C
0005433007938	14152	6	4D
0005433007933	14152	7	4E
0005433007934	14152	8	4F
0005433007952	14152	9	5A
0005433007922	14152	10	5C
0005433007928	14152	11	5D
0005433007948	14152	12	5E
0005433007929	14152	13	5F
0005433007955	14152	14	6C
0005433007951	14152	15	6F
0005433007930	14152	16	7A
0005433007926	14152	17	7C
0005433007919	14152	18	7D
0005433007946	14152	19	8A
0005433007915	14152	20	8D
0005433007935	14152	21	9E
0005433007918	14152	22	10A
0005433007945	14152	23	10C
0005433007925	14152	24	10F
0005433007943	14152	25	12C
0005433007937	14152	26	13D
0005433007942	14152	27	13E
0005433007944	14152	28	14A
0005433007932	14152	29	14C
0005433007954	14152	30	14E
0005433007960	14152	31	15D
0005433007936	14152	32	15E
0005433007949	14152	33	16C
0005433007917	14152	34	16D
0005433007921	14152	35	16F
0005433007924	14152	36	17C
0005433007950	14152	37	17E
0005433007931	14152	38	18A
0005433007920	14152	39	18C
0005433007916	14152	40	18D
0005433007957	14152	41	18E
0005433007927	14152	42	19D
0005433007947	14152	43	19E
0005433007941	14152	44	20A
0005433007940	14152	45	20C
0005433007956	14152	46	20D
0005433810492	22853	1	15A
0005434925302	20549	1	1C
0005434925286	20549	2	1F
0005434925274	20549	3	2A
0005434925295	20549	4	2C
0005434925275	20549	5	2D
0005434925282	20549	6	2F
0005434925290	20549	7	3F
0005434925303	20549	8	5C
0005434925294	20549	9	5D
0005434925289	20549	10	6A
0005434925281	20549	11	6E
0005434925284	20549	12	7D
0005434925304	20549	13	7E
0005434925296	20549	14	8D
0005434925297	20549	15	9A
0005434925279	20549	16	9C
0005434925278	20549	17	9D
0005434925283	20549	18	9E
0005434925277	20549	19	10D
0005434925285	20549	20	11A
0005434925300	20549	21	11C
0005434925288	20549	22	12A
0005434925298	20549	23	13E
0005434925273	20549	24	14D
0005434925293	20549	25	15D
0005434925301	20549	26	15F
0005434925291	20549	27	16E
0005434925305	20549	28	16F
0005434925276	20549	29	18D
0005434925280	20549	30	18E
0005434925292	20549	31	18F
0005434925287	20549	32	19C
0005434925299	20549	33	20A
0005435487515	15798	1	1B
0005435487503	15798	2	1C
0005435487499	15798	3	2A
0005435487500	15798	4	2C
0005435487511	15798	5	3A
0005435487508	15798	6	3B
0005435487514	15798	7	4A
0005435487516	15798	8	4B
0005435487506	15798	9	4C
0005435487513	15798	10	4D
0005435487519	15798	11	6A
0005435487501	15798	12	6D
0005435487502	15798	13	7A
0005435487507	15798	14	7B
0005435487509	15798	15	7C
0005435487518	15798	16	18B
0005435487510	15798	17	18D
0005435487504	15798	18	19A
0005435487505	15798	19	19C
0005435487512	15798	20	20B
0005435487498	15798	21	22B
0005435487517	15798	22	23B
0005435998970	19680	1	1B
0005435998969	19680	2	1C
0005435998975	19680	3	1D
0005435998981	19680	4	3A
0005435998979	19680	5	3C
0005435998972	19680	6	3D
0005435998984	19680	7	4A
0005435998971	19680	8	4C
0005435998978	19680	9	5A
0005435998976	19680	10	5B
0005435998974	19680	11	5D
0005435998968	19680	12	18A
0005435998977	19680	13	18C
0005435998980	19680	14	18D
0005435998973	19680	15	21A
0005435998983	19680	16	21D
0005435998982	19680	17	23A
0005435839044	5993	1	1F
0005435839028	5993	2	3C
0005435839043	5993	3	4F
0005435839027	5993	4	6A
0005435839026	5993	5	6D
0005435839040	5993	6	6F
0005432659676	5993	7	7C
0005432658561	5993	8	7B
0005435839042	5993	9	7D
0005432142204	5993	10	8A
0005435839039	5993	11	7F
0005435839030	5993	12	8B
0005432658560	5993	13	9E
0005432660788	5993	14	9F
0005435839031	5993	15	10C
0005435839029	5993	16	10F
0005432142203	5993	17	11C
0005435839023	5993	18	12B
0005435839032	5993	19	12C
0005432142205	5993	20	12E
0005432659675	5993	21	12F
0005435839017	5993	22	13C
0005435839020	5993	23	13F
0005435839034	5993	24	14B
0005435839015	5993	25	14D
0005435839019	5993	26	14E
0005435839035	5993	27	15B
0005435839021	5993	28	15A
0005435839038	5993	29	15F
0005435839018	5993	30	17D
0005435839033	5993	31	18A
0005435839041	5993	32	18E
0005435839036	5993	33	18F
0005435839016	5993	34	19C
0005435839024	5993	35	19E
0005435839037	5993	36	21B
0005435839025	5993	37	21E
0005435839022	5993	38	21D
0005432660789	5993	39	21F
0005432537026	18044	1	1D
0005435472547	18044	2	7F
0005435472556	18044	3	8F
0005435472558	18044	4	9D
0005435472559	18044	5	11D
0005435472545	18044	6	11F
0005432537025	18044	7	12A
0005435472560	18044	8	14E
0005435472548	18044	9	15B
0005435472557	18044	10	15E
0005435472550	18044	11	16C
0005435472549	18044	12	16B
0005435472552	18044	13	16D
0005435472546	18044	14	17A
0005435472555	18044	15	19A
0005435472554	18044	16	18F
0005435472553	18044	17	19B
0005432537027	18044	18	19E
0005435472551	18044	19	20F
0005435472561	18044	20	21F
0005435103811	23007	1	5D
0005435103814	23007	2	6B
0005435103816	23007	3	8C
0005435103817	23007	4	9A
0005435103806	23007	5	9C
0005435103815	23007	6	11B
0005435103808	23007	7	13F
0005435103813	23007	8	15A
0005435103809	23007	9	16F
0005435103804	23007	10	16E
0005435103818	23007	11	17E
0005435103807	23007	12	20B
0005435103810	23007	13	20C
0005435103805	23007	14	22E
0005435103812	23007	15	23F
0005433284831	32052	1	1C
0005433284838	32052	2	2F
0005433284847	32052	3	4C
0005433284839	32052	4	5D
0005433284844	32052	5	5F
0005433284833	32052	6	6B
0005433284836	32052	7	6F
0005433284834	32052	8	7D
0005433284837	32052	9	8A
0005433284824	32052	10	8F
0005433284821	32052	11	9F
0005433284832	32052	12	10B
0005433284848	32052	13	11A
0005433284846	32052	14	11C
0005433284830	32052	15	11D
0005433284835	32052	16	11E
0005433284841	32052	17	12A
0005433284825	32052	18	12C
0005433284823	32052	19	14C
0005433284826	32052	20	15C
0005433284827	32052	21	16B
0005433284822	32052	22	16F
0005433284828	32052	23	17F
0005433284840	32052	24	18B
0005433284842	32052	25	19D
0005433284845	32052	26	20C
0005433284829	32052	27	20D
0005433284843	32052	28	23A
0005433111468	19951	1	1A
0005432892721	19951	2	2F
0005433111470	19951	3	5F
0005432892724	19951	4	10E
0005433112350	19951	5	14D
0005432892722	19951	6	15B
0005432892720	19951	7	16B
0005432892719	19951	8	17E
0005432892723	19951	9	18B
0005433111471	19951	10	18E
0005432892725	19951	11	18F
0005433111469	19951	12	20B
0005433111467	19951	13	20E
0005435630923	30595	1	1A
0005435212545	30595	2	1H
0005433656624	30595	3	2D
0005435212587	30595	4	2C
0005432159792	30595	5	3G
0005435212539	30595	6	3D
0005435212561	30595	7	4A
0005435212552	30595	8	4C
0005435630924	30595	9	5C
0005435212600	30595	10	5D
0005435212603	30595	11	11D
0005435725530	30595	12	12E
0005432159789	30595	13	12D
0005435212536	30595	14	13D
0005435212560	30595	15	13H
0005435212583	30595	16	14D
0005435212572	30595	17	15A
0005435212566	30595	18	17E
0005435212537	30595	19	18E
0005435212590	30595	20	18G
0005435212593	30595	21	18H
0005435212565	30595	22	19F
0005432159790	30595	23	20D
0005435212549	30595	24	20J
0005435212555	30595	25	21B
0005432211396	30595	26	20K
0005435212540	30595	27	21D
0005435212597	30595	28	22D
0005435725529	30595	29	22B
0005435212550	30595	30	22J
0005435212547	30595	31	24G
0005435725527	30595	32	25D
0005435212576	30595	33	25B
0005435212541	30595	34	25E
0005432211389	30595	35	26C
0005435212592	30595	36	26B
0005435212581	30595	37	26A
0005435212596	30595	38	26E
0005435212562	30595	39	27A
0005435212553	30595	40	26K
0005435212554	30595	41	27B
0005435212582	30595	42	27H
0005432211394	30595	43	28A
0005435212579	30595	44	28G
0005435212605	30595	45	29A
0005435212595	30595	46	28K
0005435212570	30595	47	29K
0005435212580	30595	48	30G
0005435212602	30595	49	30J
0005435212575	30595	50	31A
0005435212544	30595	51	32D
0005435212543	30595	52	32K
0005432159788	30595	53	33E
0005433656623	30595	54	34J
0005435212591	30595	55	35F
0005435212568	30595	56	36A
0005435212604	30595	57	36H
0005435212563	30595	58	37B
0005435212585	30595	59	37A
0005435212571	30595	60	37D
0005435212567	30595	61	37G
0005435212556	30595	62	37H
0005435630925	30595	63	38C
0005435212601	30595	64	38B
0005435212578	30595	65	39D
0005432211391	30595	66	39B
0005435212584	30595	67	40C
0005435212557	30595	68	40D
0005435725528	30595	69	40J
0005432211392	30595	70	40K
0005435212559	30595	71	42A
0005435212589	30595	72	42F
0005435212577	30595	73	43F
0005435212588	30595	74	43E
0005435212594	30595	75	43H
0005432159791	30595	76	44C
0005432211395	30595	77	44H
0005435212574	30595	78	44K
0005435212569	30595	79	44J
0005435212551	30595	80	45D
0005435212586	30595	81	45G
0005432211390	30595	82	45K
0005435212542	30595	83	46C
0005432211393	30595	84	46B
0005435212546	30595	85	46A
0005435212598	30595	86	46G
0005435212599	30595	87	46H
0005435212538	30595	88	47A
0005435212558	30595	89	48A
0005433656622	30595	90	49D
0005433656621	30595	91	49K
0005435725531	30595	92	49H
0005435212548	30595	93	50E
0005435212564	30595	94	50D
0005435212573	30595	95	50G
0005433367355	24854	1	1D
0005433367334	24854	2	2C
0005433367361	24854	3	2F
0005433367367	24854	4	3A
0005433367333	24854	5	3D
0005433367341	24854	6	3F
0005433367336	24854	7	4D
0005433367362	24854	8	5C
0005433367353	24854	9	5F
0005433367358	24854	10	6D
0005433367350	24854	11	6E
0005433367337	24854	12	6F
0005433367368	24854	13	7A
0005433367338	24854	14	7C
0005433367371	24854	15	7F
0005433367342	24854	16	8A
0005433367339	24854	17	8D
0005433367359	24854	18	8E
0005433367349	24854	19	9D
0005433367348	24854	20	10A
0005433367363	24854	21	10D
0005433367369	24854	22	10E
0005433367344	24854	23	11C
0005433367357	24854	24	12D
0005433367356	24854	25	13C
0005433367370	24854	26	13D
0005433367364	24854	27	13E
0005433367354	24854	28	13F
0005433367346	24854	29	14D
0005433367343	24854	30	15F
0005433367360	24854	31	16A
0005433367347	24854	32	16C
0005433367365	24854	33	16D
0005433367340	24854	34	17E
0005433367352	24854	35	18D
0005433367351	24854	36	18F
0005433367366	24854	37	19A
0005433367345	24854	38	20C
0005433367335	24854	39	20E
0005435949736	6594	1	1C
0005435949735	6594	2	4B
0005435949739	6594	3	4D
0005435949742	6594	4	5A
0005435949740	6594	5	6A
0005435949734	6594	6	6D
0005435949733	6594	7	7D
0005435949738	6594	8	19D
0005435949741	6594	9	20D
0005435949732	6594	10	21C
0005435949737	6594	11	22B
0005434979362	2031	1	1A
0005434979371	2031	2	1B
0005434979363	2031	3	1D
0005434979352	2031	4	2A
0005434979359	2031	5	2B
0005434979357	2031	6	2C
0005434979350	2031	7	2D
0005434979368	2031	8	3A
0005434979349	2031	9	3D
0005434979358	2031	10	4D
0005434979353	2031	11	5A
0005434979346	2031	12	5C
0005434979360	2031	13	6A
0005434979356	2031	14	6C
0005434979364	2031	15	7A
0005434979367	2031	16	6D
0005435801654	2031	17	7C
0005434979373	2031	18	7D
0005434979354	2031	19	18B
0005434979351	2031	20	18D
0005434979348	2031	21	19A
0005434979361	2031	22	19B
0005434979372	2031	23	19C
0005434979365	2031	24	19D
0005434979355	2031	25	20A
0005434979345	2031	26	20B
0005435801651	2031	27	20D
0005435801653	2031	28	21A
0005434979366	2031	29	21B
0005434979369	2031	30	21D
0005434979370	2031	31	22B
0005434979374	2031	32	22C
0005435801652	2031	33	23A
0005434979347	2031	34	23B
0005434952479	2561	1	1A
0005434952478	2561	2	3A
0005434952475	2561	3	3B
0005434952477	2561	4	5B
0005434952476	2561	5	6B
0005433256388	28264	1	1A
0005433256389	28264	2	2A
0005433256390	28264	3	4B
0005433112355	19830	1	2A
0005433111474	19830	2	3A
0005433111475	19830	3	4A
0005433112354	19830	4	5A
0005433112353	19830	5	6B
0005434136853	28769	1	1A
0005434136869	28769	2	1C
0005434136933	28769	3	1D
0005434136916	28769	4	1F
0005434136856	28769	5	2A
0005434136898	28769	6	2C
0005434136881	28769	7	2F
0005434136885	28769	8	3A
0005434136863	28769	9	3C
0005434136896	28769	10	3D
0005434136934	28769	11	3F
0005434136901	28769	12	4A
0005434136922	28769	13	4C
0005434136919	28769	14	4D
0005434136884	28769	15	4E
0005434136889	28769	16	4F
0005434136907	28769	17	5A
0005434136923	28769	18	5C
0005434136908	28769	19	5D
0005434136877	28769	20	5E
0005434136859	28769	21	5F
0005434136893	28769	22	6A
0005434136850	28769	23	6C
0005434136880	28769	24	6E
0005434136906	28769	25	6F
0005434136852	28769	26	7A
0005434136847	28769	27	7C
0005434136854	28769	28	7D
0005434136861	28769	29	7E
0005434136900	28769	30	7F
0005434136855	28769	31	8C
0005434136888	28769	32	8D
0005434136873	28769	33	8F
0005434136883	28769	34	9A
0005434136845	28769	35	9C
0005434136904	28769	36	9D
0005434136913	28769	37	9E
0005434136930	28769	38	9F
0005434136912	28769	39	10A
0005434136932	28769	40	10C
0005434136886	28769	41	10D
0005434136862	28769	42	10E
0005434136903	28769	43	10F
0005434136914	28769	44	11A
0005434136909	28769	45	11C
0005434136925	28769	46	11D
0005434136890	28769	47	11E
0005434136915	28769	48	11F
0005434136874	28769	49	12A
0005434136848	28769	50	12C
0005434136860	28769	51	12D
0005434136899	28769	52	12E
0005434136910	28769	53	12F
0005434136858	28769	54	13C
0005434136917	28769	55	13D
0005434136868	28769	56	13E
0005434136870	28769	57	13F
0005434136921	28769	58	14A
0005434136851	28769	59	14D
0005434136864	28769	60	14C
0005434136882	28769	61	14E
0005434136887	28769	62	14F
0005434136902	28769	63	15A
0005434136927	28769	64	15C
0005434136875	28769	65	15D
0005434136878	28769	66	15E
0005434136867	28769	67	15F
0005434136924	28769	68	16A
0005434136931	28769	69	16C
0005434136879	28769	70	16D
0005434136894	28769	71	16E
0005434136846	28769	72	16F
0005434136895	28769	73	17A
0005434136876	28769	74	17C
0005434136926	28769	75	17D
0005434136891	28769	76	17E
0005434136849	28769	77	17F
0005434136897	28769	78	18C
0005434136866	28769	79	18D
0005434136911	28769	80	18E
0005434136918	28769	81	19A
0005434136929	28769	82	19C
0005434136928	28769	83	19D
0005434136872	28769	84	19E
0005434136857	28769	85	19F
0005434136920	28769	86	20A
0005434136905	28769	87	20C
0005434136892	28769	88	20D
0005434136865	28769	89	20E
0005434136871	28769	90	20F
0005433538750	6785	1	1A
0005433538746	6785	2	1B
0005433534468	6785	3	2B
0005433538749	6785	4	4B
0005433538743	6785	5	4D
0005433534467	6785	6	5B
0005433538744	6785	7	5D
0005433538747	6785	8	6B
0005433538745	6785	9	18B
0005433538742	6785	10	19D
0005433538748	6785	11	21B
0005435259695	25027	1	4D
0005435259694	25027	2	6A
0005435259692	25027	3	18D
0005435259691	25027	4	21C
0005435259693	25027	5	22C
0005433511834	800	1	3C
0005433511830	800	2	3D
0005433511831	800	3	5A
0005433511828	800	4	7B
0005433511835	800	5	18C
0005433511833	800	6	19D
0005433511829	800	7	20B
0005433511826	800	8	21C
0005433511827	800	9	22B
0005433511832	800	10	22C
0005432922467	16130	1	6B
0005432922468	16130	2	6D
0005432922466	16130	3	7A
0005432922465	16130	4	22D
0005435696931	3664	1	1A
0005435696952	3664	2	1B
0005434950467	3664	3	1C
0005434950465	3664	4	2A
0005435696940	3664	5	2D
0005435696943	3664	6	3B
0005435696944	3664	7	3C
0005435696937	3664	8	3D
0005435696954	3664	9	5A
0005435696955	3664	10	5B
0005435696953	3664	11	5C
0005435696938	3664	12	5D
0005435696947	3664	13	6A
0005435696930	3664	14	6B
0005435696929	3664	15	6C
0005434950466	3664	16	6D
0005435696949	3664	17	7A
0005435696956	3664	18	7B
0005435696932	3664	19	7D
0005435696939	3664	20	18A
0005435696933	3664	21	18B
0005435696948	3664	22	18C
0005435696951	3664	23	18D
0005435696934	3664	24	19C
0005434950464	3664	25	20A
0005435696936	3664	26	20C
0005435696941	3664	27	21A
0005435696935	3664	28	21B
0005435696957	3664	29	21C
0005434950463	3664	30	21D
0005435696942	3664	31	22A
0005435696950	3664	32	22B
0005435696946	3664	33	22C
0005435696945	3664	34	22D
0005435916128	16270	1	3A
0005435916127	16270	2	7D
0005435935001	16270	3	18A
0005435935000	16270	4	18C
0005435935002	16270	5	19D
0005435934999	16270	6	20A
0005434606772	3980	1	1A
0005432609675	3980	2	2C
0005433519391	3980	3	2D
0005435842312	3980	4	3A
0005432609674	3980	5	3D
0005432609673	3980	6	4D
0005432609672	3980	7	5A
0005432607507	3980	8	6C
0005434606775	3980	9	7B
0005432607506	3980	10	18A
0005433519393	3980	11	18C
0005433519390	3980	12	18D
0005433519394	3980	13	19A
0005434604846	3980	14	19B
0005433519392	3980	15	19C
0005434604847	3980	16	20A
0005435842313	3980	17	20B
0005432607509	3980	18	20C
0005434604848	3980	19	20D
0005434606773	3980	20	21D
0005432607508	3980	21	22A
0005434606774	3980	22	23B
0005435853586	22041	1	4A
0005435853585	22041	2	21C
0005435628678	680	1	3A
0005435628677	680	2	3B
0005433348906	15963	1	1A
0005433348907	15963	2	1B
0005433348905	15963	3	2A
0005433348908	15963	4	3B
0005433348909	15963	5	4B
0005433348904	15963	6	5B
0005434446482	17243	1	1A
0005434446485	17243	2	1B
0005434446483	17243	3	2A
0005434446484	17243	4	3A
0005434445213	17243	5	3B
0005434446486	17243	6	4B
0005434445212	17243	7	5B
0005433159281	17640	1	5B
0005433159282	17640	2	6B
0005435132728	7871	1	2B
0005435132732	7871	2	3B
0005435132734	7871	3	3D
0005435132733	7871	4	5B
0005435132737	7871	5	6A
0005435132727	7871	6	6B
0005435132736	7871	7	6D
0005435132726	7871	8	18B
0005435132730	7871	9	18C
0005435132735	7871	10	20C
0005435132729	7871	11	21C
0005435132731	7871	12	22C
0005435383073	33105	1	2D
0005435132702	33105	2	4B
0005435383075	33105	3	6C
0005435132704	33105	4	6D
0005435132699	33105	5	7A
0005435383072	33105	6	18B
0005435132703	33105	7	20B
0005435383074	33105	8	21A
0005435132700	33105	9	22B
0005435383071	33105	10	23B
0005435160145	7478	1	3C
0005435160149	7478	2	3D
0005435160144	7478	3	5B
0005435160146	7478	4	5D
0005435160142	7478	5	6C
0005435160138	7478	6	7A
0005435160139	7478	7	18B
0005435160148	7478	8	19B
0005435160140	7478	9	19A
0005435160141	7478	10	20A
0005435160137	7478	11	20C
0005435160143	7478	12	21A
0005435160147	7478	13	22D
0005435390144	29543	1	1B
0005435390143	29543	2	1C
0005435390141	29543	3	2A
0005435390142	29543	4	2C
0005435390140	29543	5	6B
0005435390139	29543	6	22C
0005435178475	18437	1	1A
0005435178474	18437	2	4A
0005432398138	27180	1	1B
0005432398139	27180	2	2A
0005432398140	27180	3	2B
0005432398141	27180	4	3A
0005432398136	27180	5	3B
0005432400066	27180	6	4A
0005432400067	27180	7	5A
0005432398137	27180	8	5B
0005432400065	27180	9	6A
0005432400068	27180	10	6B
0005434503607	6520	1	1F
0005434503612	6520	2	2A
0005434503600	6520	3	2C
0005434503584	6520	4	3A
0005434503592	6520	5	4C
0005434503595	6520	6	4D
0005435103826	6520	7	4F
0005434503591	6520	8	5D
0005434503613	6520	9	6C
0005434503601	6520	10	6D
0005434503589	6520	11	7A
0005434503581	6520	12	7C
0005434503585	6520	13	8D
0005434503582	6520	14	8F
0005434503611	6520	15	9E
0005434503596	6520	16	10C
0005434503616	6520	17	10D
0005434503579	6520	18	10E
0005434503608	6520	19	11C
0005434503602	6520	20	11F
0005434503618	6520	21	12F
0005435103827	6520	22	13D
0005434503609	6520	23	13E
0005434503605	6520	24	14A
0005434503606	6520	25	14E
0005434503604	6520	26	14F
0005434503598	6520	27	15A
0005434503597	6520	28	15C
0005435103825	6520	29	15D
0005434503587	6520	30	16A
0005434503617	6520	31	16C
0005434503599	6520	32	17A
0005434503586	6520	33	17C
0005434503593	6520	34	17D
0005434503614	6520	35	17E
0005434503603	6520	36	18A
0005434503580	6520	37	18C
0005434503615	6520	38	18D
0005434503588	6520	39	18F
0005434503590	6520	40	19A
0005434503583	6520	41	19C
0005434503578	6520	42	19E
0005434503594	6520	43	20A
0005434503610	6520	44	20C
0005435652390	1683	1	1A
0005435652385	1683	2	1D
0005435652388	1683	3	2D
0005435652400	1683	4	3C
0005435652427	1683	5	3D
0005435652397	1683	6	3F
0005435652406	1683	7	4A
0005435652408	1683	8	4C
0005435652414	1683	9	4E
0005435652415	1683	10	4F
0005435652420	1683	11	5A
0005435652425	1683	12	5E
0005435652434	1683	13	6A
0005435652391	1683	14	6D
0005435652392	1683	15	6E
0005435652410	1683	16	7D
0005435652401	1683	17	7F
0005435652430	1683	18	8E
0005435652384	1683	19	8F
0005435652403	1683	20	9A
0005435652432	1683	21	9D
0005435652404	1683	22	9F
0005435652429	1683	23	10A
0005435652407	1683	24	10C
0005435652435	1683	25	11C
0005435652409	1683	26	12C
0005435652398	1683	27	12D
0005435652424	1683	28	12E
0005435652389	1683	29	13C
0005435652393	1683	30	13F
0005435652402	1683	31	14A
0005435652418	1683	32	14C
0005435652399	1683	33	14D
0005435652428	1683	34	14E
0005435652416	1683	35	14F
0005435652387	1683	36	15A
0005435652413	1683	37	15D
0005435652422	1683	38	15E
0005435652396	1683	39	16C
0005435652433	1683	40	16E
0005435652417	1683	41	16F
0005435652421	1683	42	17C
0005435652431	1683	43	17E
0005435652386	1683	44	17F
0005435652426	1683	45	18A
0005435652411	1683	46	18D
0005435652405	1683	47	18E
0005435652412	1683	48	19C
0005435652395	1683	49	19D
0005435652394	1683	50	20A
0005435652419	1683	51	20D
0005435652423	1683	52	20F
0005433367363	21689	1	1C
0005433367343	21689	2	2C
0005433367345	21689	3	2F
0005433367371	21689	4	3C
0005433367357	21689	5	3F
0005433367370	21689	6	4C
0005433367347	21689	7	4E
0005433367349	21689	8	5D
0005433367341	21689	9	5E
0005433367353	21689	10	6A
0005433367342	21689	11	7E
0005433367358	21689	12	8A
0005433367362	21689	13	8E
0005433367336	21689	14	8F
0005433367350	21689	15	9A
0005433367368	21689	16	9E
0005433367352	21689	17	10F
0005433367335	21689	18	11C
0005433367355	21689	19	11F
0005433367367	21689	20	12A
0005433367348	21689	21	12D
0005433367365	21689	22	12E
0005433367351	21689	23	12F
0005433367366	21689	24	14E
0005433367369	21689	25	15A
0005433367360	21689	26	15E
0005433367344	21689	27	15F
0005433367361	21689	28	16E
0005433367356	21689	29	17C
0005433367337	21689	30	17D
0005433367338	21689	31	17E
0005433367359	21689	32	18A
0005433367364	21689	33	18E
0005433367346	21689	34	18F
0005433367354	21689	35	19C
0005433367340	21689	36	19E
0005433367334	21689	37	20C
0005433367333	21689	38	20D
0005433367339	21689	39	20F
0005433985263	4159	1	1D
0005435788735	4159	2	1F
0005433985287	4159	3	2A
0005433985301	4159	4	2F
0005433985288	4159	5	3A
0005433985275	4159	6	3D
0005433985267	4159	7	4C
0005433985268	4159	8	4D
0005433985262	4159	9	4F
0005433985272	4159	10	5D
0005433985299	4159	11	5F
0005433985279	4159	12	6C
0005433985266	4159	13	6F
0005433985261	4159	14	7C
0005435788733	4159	15	7E
0005433985273	4159	16	7F
0005433985265	4159	17	8A
0005433985264	4159	18	8D
0005433985282	4159	19	8E
0005433985297	4159	20	9A
0005433985294	4159	21	9C
0005433985280	4159	22	9E
0005433985269	4159	23	10C
0005433985302	4159	24	10D
0005433985270	4159	25	10E
0005433985281	4159	26	10F
0005433985303	4159	27	11A
0005433985289	4159	28	11C
0005433985293	4159	29	11D
0005433985286	4159	30	11E
0005433985290	4159	31	12A
0005433985296	4159	32	12D
0005433985271	4159	33	13A
0005433985278	4159	34	13C
0005433985298	4159	35	13F
0005433985284	4159	36	14D
0005433985291	4159	37	14F
0005433985274	4159	38	15A
0005433985277	4159	39	15D
0005433985276	4159	40	15F
0005435788734	4159	41	16D
0005433985295	4159	42	17A
0005433985285	4159	43	17D
0005433985306	4159	44	17E
0005433985292	4159	45	17F
0005433985305	4159	46	18A
0005433985300	4159	47	18E
0005433985283	4159	48	19C
0005433985304	4159	49	20C
0005433985307	4159	50	20D
0005435719551	24767	1	7A
0005435719550	24767	2	21D
0005434516045	9024	1	2D
0005434516043	9024	2	3C
0005434516049	9024	3	3D
0005434516051	9024	4	4C
0005434516047	9024	5	4D
0005434516048	9024	6	5A
0005434516050	9024	7	5B
0005434516052	9024	8	5D
0005434516046	9024	9	6B
0005434516044	9024	10	23A
0005434151664	17850	1	1F
0005432869433	17850	2	2C
0005432869434	17850	3	5F
0005432869432	17850	4	6C
0005432869431	17850	5	7C
0005432869435	17850	6	8A
0005434151663	17850	7	8C
0005432869436	17850	8	8D
0005432869437	17850	9	11F
0005434151665	17850	10	14E
0005432657400	26329	1	1C
0005432659673	26329	2	1F
0005432666356	26329	3	2A
0005432655345	26329	4	2C
0005432665241	26329	5	3A
0005432660787	26329	6	4C
0005432659674	26329	7	4D
0005432660785	26329	8	4E
0005432655342	26329	9	5A
0005432655341	26329	10	5C
0005432660784	26329	11	6A
0005432655347	26329	12	6C
0005432657401	26329	13	6F
0005432658558	26329	14	7F
0005432655343	26329	15	8E
0005432655340	26329	16	8F
0005432665243	26329	17	9C
0005432655344	26329	18	9E
0005432655338	26329	19	10E
0005432658559	26329	20	10F
0005432667421	26329	21	11A
0005432655348	26329	22	13C
0005432666357	26329	23	13D
0005432655346	26329	24	15C
0005432655339	26329	25	15E
0005432655349	26329	26	16A
0005432667422	26329	27	17A
0005432660786	26329	28	17C
0005432666355	26329	29	19D
0005432665242	26329	30	20C
0005432328052	3129	1	1A
0005432287116	3129	2	1D
0005432328060	3129	3	1F
0005432328070	3129	4	2A
0005432328073	3129	5	3A
0005432328058	3129	6	3C
0005432328039	3129	7	3D
0005432328047	3129	8	3F
0005432328059	3129	9	4A
0005432328043	3129	10	4D
0005432328076	3129	11	4E
0005432328042	3129	12	5C
0005432328044	3129	13	5D
0005432328038	3129	14	6C
0005432328066	3129	15	6D
0005432328048	3129	16	6F
0005432328041	3129	17	7F
0005432328051	3129	18	8D
0005432328033	3129	19	8E
0005432328067	3129	20	9C
0005432328056	3129	21	9D
0005432328050	3129	22	9F
0005432328036	3129	23	10A
0005432328032	3129	24	10F
0005432328037	3129	25	11E
0005432328054	3129	26	11F
0005432287118	3129	27	12A
0005432328046	3129	28	12F
0005432328065	3129	29	13C
0005432328061	3129	30	13D
0005432328069	3129	31	13E
0005432328063	3129	32	14D
0005432328077	3129	33	15C
0005432328057	3129	34	15D
0005432328055	3129	35	15E
0005432328071	3129	36	16A
0005432328072	3129	37	16C
0005432328075	3129	38	16D
0005432287119	3129	39	17A
0005432328062	3129	40	17D
0005432328053	3129	41	17E
0005432328068	3129	42	18A
0005432328064	3129	43	18C
0005432328035	3129	44	18F
0005432328045	3129	45	19A
0005432287117	3129	46	19D
0005432328049	3129	47	19E
0005432328040	3129	48	20D
0005432328034	3129	49	20E
0005432328074	3129	50	20F
0005432905037	31154	1	1D
0005432054262	31154	2	2A
0005432905041	31154	3	2F
0005432905040	31154	4	5D
0005432905036	31154	5	6E
0005432327965	31154	6	10C
0005432905038	31154	7	13A
0005432905039	31154	8	19E
0005432054263	31154	9	20A
0005434309554	6196	1	1D
0005434309548	6196	2	2C
0005434309543	6196	3	3A
0005434309553	6196	4	3F
0005434309547	6196	5	4B
0005435999008	6196	6	4E
0005435998999	6196	7	7D
0005435999002	6196	8	8C
0005435999003	6196	9	8F
0005435999011	6196	10	9A
0005435999007	6196	11	9E
0005435999000	6196	12	9F
0005434309544	6196	13	12B
0005434309555	6196	14	12F
0005434309545	6196	15	13B
0005435999005	6196	16	13E
0005434309546	6196	17	14A
0005435999010	6196	18	14D
0005435999006	6196	19	14C
0005435999001	6196	20	16B
0005434309550	6196	21	17A
0005434309551	6196	22	17F
0005435999004	6196	23	18F
0005435999009	6196	24	19B
0005434309552	6196	25	20D
0005434309549	6196	26	20F
0005435999012	6196	27	22E
0005435296958	19581	1	2C
0005435487507	19581	2	5D
0005435487517	19581	3	5F
0005435487519	19581	4	6F
0005435487500	19581	5	8C
0005435296960	19581	6	8E
0005435487512	19581	7	9C
0005435296959	19581	8	10B
0005435487511	19581	9	10E
0005435487514	19581	10	12F
0005435296963	19581	11	13F
0005435487499	19581	12	14B
0005435296964	19581	13	15E
0005435487510	19581	14	16C
0005435487501	19581	15	16F
0005435487518	19581	16	16E
0005435487515	19581	17	17B
0005435296961	19581	18	17E
0005435487504	19581	19	18E
0005435487505	19581	20	18F
0005435296962	19581	21	19A
0005435487509	19581	22	20B
0005435487506	19581	23	20C
0005435487508	19581	24	21E
0005435487513	19581	25	21F
0005435487498	19581	26	22C
0005435487503	19581	27	22E
0005435487516	19581	28	23A
0005435487502	19581	29	23D
0005435517661	1563	1	1C
0005434565728	1563	2	1A
0005434565724	1563	3	1D
0005435502012	1563	4	1F
0005435517650	1563	5	2A
0005434565725	1563	6	2D
0005435517666	1563	7	2F
0005432291896	1563	8	3A
0005435501998	1563	9	3C
0005435502019	1563	10	3D
0005435517656	1563	11	4A
0005434565729	1563	12	4C
0005434565720	1563	13	4F
0005435517657	1563	14	5A
0005434565726	1563	15	5C
0005435502000	1563	16	5D
0005435502004	1563	17	5E
0005435517648	1563	18	5F
0005435517649	1563	19	6A
0005435502011	1563	20	6D
0005435502005	1563	21	6E
0005435508205	1563	22	6F
0005435502015	1563	23	7A
0005434565722	1563	24	7D
0005435502017	1563	25	7E
0005435508206	1563	26	8A
0005435508200	1563	27	8D
0005435517665	1563	28	8F
0005435517654	1563	29	8E
0005435517662	1563	30	9A
0005435502020	1563	31	9C
0005435502008	1563	32	9D
0005435517655	1563	33	9F
0005435517660	1563	34	10A
0005435502009	1563	35	10D
0005435502010	1563	36	10E
0005435508204	1563	37	10F
0005434565721	1563	38	11A
0005432291895	1563	39	11C
0005435508203	1563	40	11D
0005434565730	1563	41	11E
0005434565733	1563	42	12A
0005435517663	1563	43	12C
0005434565723	1563	44	12D
0005435502001	1563	45	13A
0005435502016	1563	46	13C
0005435508208	1563	47	13D
0005435502014	1563	48	13E
0005435508209	1563	49	14A
0005435508199	1563	50	14C
0005435517667	1563	51	14D
0005435517664	1563	52	14F
0005435517658	1563	53	15A
0005432291897	1563	54	15C
0005435517653	1563	55	15E
0005435502006	1563	56	15F
0005435508202	1563	57	16A
0005435517652	1563	58	16C
0005435502013	1563	59	16D
0005434565727	1563	60	16F
0005435502003	1563	61	17A
0005435502018	1563	62	17C
0005434565731	1563	63	17E
0005435502007	1563	64	18A
0005434565719	1563	65	18C
0005434565732	1563	66	18D
0005434565718	1563	67	18F
0005435501999	1563	68	19A
0005435502002	1563	69	19D
0005435517651	1563	70	19F
0005435508201	1563	71	20A
0005435517659	1563	72	20D
0005435508207	1563	73	20F
0005433186000	20894	1	4F
0005433185999	20894	2	5F
0005433185996	20894	3	6F
0005433185998	20894	4	10D
0005433186002	20894	5	12A
0005433186001	20894	6	12C
0005433185995	20894	7	18E
0005433185997	20894	8	19A
0005433186003	20894	9	19D
0005435153652	3926	1	1B
0005435153646	3926	2	2B
0005435153648	3926	3	4D
0005435153651	3926	4	5C
0005435153647	3926	5	7A
0005435153649	3926	6	20A
0005435153650	3926	7	21A
0005435931548	21851	1	7C
0005435931550	21851	2	19B
0005435931549	21851	3	20B
0005435931551	21851	4	21B
0005435931547	21851	5	21D
0005435931546	21851	6	22B
0005432628635	7193	1	1A
0005432628642	7193	2	1B
0005432628646	7193	3	2B
0005432628643	7193	4	2D
0005432628639	7193	5	3A
0005432628640	7193	6	3D
0005432628644	7193	7	4A
0005432628634	7193	8	5A
0005432628632	7193	9	5B
0005432628645	7193	10	6A
0005432628633	7193	11	6D
0005432628638	7193	12	18B
0005432628631	7193	13	19B
0005432628641	7193	14	20A
0005432628636	7193	15	21A
0005432628637	7193	16	21B
0005435225468	28110	1	2A
0005435225469	28110	2	3D
0005435225470	28110	3	4D
0005435225474	28110	4	7A
0005435225467	28110	5	7B
0005435225471	28110	6	20B
0005435225473	28110	7	22D
0005435225472	28110	8	23B
0005435959995	8724	1	1C
0005435959994	8724	2	1D
0005435959996	8724	3	4D
0005435959997	8724	4	20D
0005434267894	15270	1	1D
0005434267895	15270	2	3D
0005434267897	15270	3	4C
0005434267898	15270	4	22B
0005434267896	15270	5	22D
0005432692598	1162	1	1D
0005432692619	1162	2	1F
0005432692605	1162	3	2C
0005432692614	1162	4	2F
0005432674911	1162	5	4C
0005432692611	1162	6	4F
0005432674919	1162	7	5D
0005432674923	1162	8	6B
0005432674909	1162	9	6A
0005432692613	1162	10	6C
0005432692591	1162	11	6E
0005432692608	1162	12	7D
0005432692615	1162	13	8B
0005432692621	1162	14	8D
0005432674913	1162	15	8C
0005432677514	1162	16	9B
0005432674914	1162	17	9A
0005432677511	1162	18	9D
0005432692606	1162	19	10A
0005432692600	1162	20	10C
0005432674920	1162	21	11A
0005432692609	1162	22	11F
0005432692601	1162	23	12B
0005432692602	1162	24	12A
0005432692610	1162	25	12D
0005432692612	1162	26	12C
0005432677512	1162	27	12E
0005432692599	1162	28	13C
0005432692595	1162	29	13B
0005432692618	1162	30	13D
0005432692620	1162	31	13E
0005432674917	1162	32	14A
0005432692617	1162	33	14F
0005432674910	1162	34	14E
0005432692616	1162	35	15A
0005432692597	1162	36	15D
0005432674916	1162	37	15E
0005432692594	1162	38	15F
0005432674922	1162	39	16C
0005432692590	1162	40	16B
0005432674921	1162	41	16E
0005432674912	1162	42	17A
0005432692603	1162	43	17F
0005432692596	1162	44	18D
0005432692592	1162	45	19A
0005432692607	1162	46	19D
0005432674918	1162	47	20F
0005432692604	1162	48	21A
0005432692593	1162	49	21C
0005432674915	1162	50	21B
0005432677513	1162	51	21F
0005432873187	17463	1	3C
0005432873195	17463	2	5D
0005432873190	17463	3	12D
0005432873188	17463	4	14A
0005432674872	17463	5	14E
0005432873189	17463	6	18F
0005432873192	17463	7	19B
0005432873191	17463	8	19F
0005432873193	17463	9	20C
0005432873194	17463	10	20E
0005434434963	1132	1	2D
0005434434959	1132	2	4D
0005434434956	1132	3	5B
0005434434958	1132	4	6C
0005434434970	1132	5	6D
0005434434965	1132	6	7A
0005434434960	1132	7	7B
0005434434967	1132	8	19A
0005434434969	1132	9	19C
0005434434968	1132	10	20B
0005434434961	1132	11	20D
0005434434964	1132	12	21D
0005434434957	1132	13	22A
0005434434962	1132	14	22B
0005434434966	1132	15	23B
0005433156623	17312	1	2A
0005433156629	17312	2	2D
0005433156625	17312	3	3A
0005433156627	17312	4	5B
0005433156626	17312	5	5C
0005433156628	17312	6	6A
0005433156630	17312	7	20B
0005433156622	17312	8	21A
0005433156624	17312	9	22D
0005435086724	4063	1	1D
0005435086727	4063	2	2A
0005435086725	4063	3	2C
0005435086726	4063	4	3D
0005435086730	4063	5	4D
0005435086728	4063	6	20A
0005435086723	4063	7	20B
0005435086729	4063	8	20C
0005435928077	24402	1	2D
0005435928076	24402	2	3C
0005435928075	24402	3	5B
0005435928072	24402	4	20D
0005435928073	24402	5	22C
0005435928074	24402	6	22D
0005435551509	17011	1	1A
0005435098524	17011	2	1G
0005435551495	17011	3	3F
0005435551500	17011	4	3H
0005435098525	17011	5	4G
0005435551511	17011	6	5B
0005435098526	17011	7	9A
0005435551498	17011	8	9G
0005435551499	17011	9	13D
0005435098527	17011	10	14A
0005435551504	17011	11	15D
0005435098528	17011	12	18D
0005435551497	17011	13	22F
0005435551506	17011	14	23A
0005435098523	17011	15	24A
0005435551505	17011	16	25D
0005435551496	17011	17	25E
0005435551512	17011	18	25F
0005435551507	17011	19	29H
0005435551501	17011	20	30A
0005435551494	17011	21	32E
0005435551510	17011	22	33E
0005435551503	17011	23	36G
0005435551502	17011	24	37D
0005435551508	17011	25	39E
0005433261414	18242	1	2C
0005433261427	18242	2	11E
0005433261423	18242	3	11G
0005433261410	18242	4	12F
0005433261425	18242	5	13F
0005433261417	18242	6	13E
0005433261419	18242	7	14D
0005433261428	18242	8	15E
0005433261411	18242	9	16H
0005433261422	18242	10	18B
0005433261420	18242	11	19A
0005433261424	18242	12	19E
0005433261413	18242	13	20A
0005433261426	18242	14	21H
0005433261415	18242	15	27B
0005433261412	18242	16	27E
0005433261409	18242	17	29D
0005433261421	18242	18	29G
0005433261416	18242	19	30B
0005434963906	18242	20	34E
0005433261418	18242	21	35F
0005433261429	18242	22	36D
0005434625824	4849	1	3F
0005434625830	4849	2	7C
0005434625825	4849	3	7F
0005434625831	4849	4	10E
0005434625823	4849	5	15E
0005434625827	4849	6	15F
0005434625828	4849	7	16A
0005434625829	4849	8	16D
0005434625832	4849	9	18D
0005434625826	4849	10	19D
0005435907436	32884	1	1F
0005435907437	32884	2	8E
0005435907433	32884	3	10A
0005435907435	32884	4	15D
0005433194824	32884	5	16A
0005435907434	32884	6	16D
0005433194825	32884	7	16F
0005435907432	32884	8	20E
0005432195662	13752	1	2C
0005435937328	13752	2	4C
0005435937327	13752	3	5C
0005432195663	13752	4	21A
0005435784803	27423	1	1A
0005435784817	27423	2	1B
0005435784809	27423	3	1C
0005435784815	27423	4	1D
0005432190570	27423	5	2A
0005435784804	27423	6	2B
0005435784818	27423	7	2C
0005435784828	27423	8	2D
0005435784824	27423	9	3A
0005435784801	27423	10	3B
0005435784810	27423	11	3C
0005435784805	27423	12	4A
0005435787322	27423	13	4B
0005435784832	27423	14	4C
0005432190568	27423	15	4D
0005435784808	27423	16	5A
0005435784831	27423	17	5B
0005435784812	27423	18	5C
0005435784813	27423	19	5D
0005435784820	27423	20	6B
0005435784829	27423	21	6C
0005435784825	27423	22	6D
0005435784800	27423	23	7A
0005435787323	27423	24	7B
0005435784802	27423	25	7C
0005435784814	27423	26	7D
0005435784821	27423	27	18A
0005435784816	27423	28	18B
0005435784833	27423	29	18C
0005435784823	27423	30	19C
0005435784830	27423	31	19D
0005435784826	27423	32	20A
0005435784819	27423	33	20D
0005435784807	27423	34	21B
0005435784822	27423	35	21C
0005435784806	27423	36	21D
0005432190569	27423	37	22C
0005435784827	27423	38	22D
0005435784811	27423	39	23A
0005435784799	27423	40	23B
0005435310903	20251	1	3C
0005435310900	20251	2	4F
0005435310901	20251	3	5C
0005435310904	20251	4	10C
0005435310896	20251	5	11D
0005435310895	20251	6	11E
0005432058326	20251	7	12C
0005435310897	20251	8	14D
0005435310899	20251	9	15C
0005432058327	20251	10	15F
0005435310905	20251	11	17A
0005435310902	20251	12	17D
0005435310898	20251	13	18A
0005432058325	20251	14	18C
0005434406850	26959	1	1A
0005434406877	26959	2	1C
0005432153838	26959	3	1F
0005434406856	26959	4	2A
0005434406830	26959	5	2C
0005434406858	26959	6	3A
0005432153834	26959	7	3C
0005434406865	26959	8	4A
0005434406894	26959	9	4C
0005434406870	26959	10	4D
0005434406881	26959	11	5C
0005434406886	26959	12	5D
0005434406879	26959	13	5E
0005432153840	26959	14	5F
0005434406889	26959	15	6A
0005434406866	26959	16	6C
0005434406857	26959	17	6D
0005434406864	26959	18	6E
0005434406837	26959	19	6F
0005434406835	26959	20	7A
0005434406892	26959	21	7C
0005434406884	26959	22	7D
0005434406832	26959	23	7E
0005432153842	26959	24	8C
0005434406855	26959	25	8D
0005434406851	26959	26	8E
0005434406867	26959	27	8F
0005434406842	26959	28	9A
0005434406847	26959	29	9D
0005434406831	26959	30	9E
0005434406836	26959	31	10D
0005434406844	26959	32	10E
0005434406846	26959	33	11C
0005434406868	26959	34	11D
0005432153837	26959	35	11E
0005434406882	26959	36	11F
0005434406839	26959	37	12A
0005434406880	26959	38	12C
0005434406853	26959	39	12D
0005434406890	26959	40	12E
0005434406888	26959	41	12F
0005434406860	26959	42	13A
0005434406862	26959	43	13C
0005432153836	26959	44	13D
0005434406852	26959	45	13E
0005434406887	26959	46	13F
0005434406873	26959	47	14A
0005434406875	26959	48	14E
0005432153835	26959	49	14F
0005434406840	26959	50	15C
0005434406878	26959	51	15D
0005434406833	26959	52	15E
0005434406863	26959	53	15F
0005434406859	26959	54	16C
0005434406883	26959	55	16D
0005434406885	26959	56	16E
0005434406874	26959	57	16F
0005434406854	26959	58	17A
0005434406838	26959	59	17D
0005434406845	26959	60	17E
0005434406861	26959	61	17F
0005434406841	26959	62	18A
0005434406893	26959	63	18C
0005434406849	26959	64	18D
0005432153839	26959	65	18E
0005434406876	26959	66	18F
0005434406848	26959	67	19A
0005432153841	26959	68	19D
0005434406834	26959	69	19E
0005434406871	26959	70	19F
0005434406843	26959	71	20C
0005434406869	26959	72	20D
0005434406872	26959	73	20E
0005434406891	26959	74	20F
0005432109664	5676	1	2F
0005434319190	5676	2	3C
0005432109662	5676	3	6F
0005434319191	5676	4	7E
0005432109666	5676	5	8D
0005434319187	5676	6	9E
0005434319192	5676	7	11F
0005434319189	5676	8	12C
0005432109663	5676	9	12D
0005432109665	5676	10	14E
0005432109667	5676	11	16C
0005434319186	5676	12	17D
0005434319188	5676	13	17E
0005434311188	5676	14	19D
0005433123640	15679	1	1A
0005433123648	15679	2	1C
0005433123638	15679	3	2C
0005433123634	15679	4	4C
0005433123645	15679	5	5C
0005433123642	15679	6	5E
0005433123646	15679	7	6A
0005433123650	15679	8	7D
0005433123641	15679	9	7F
0005433123636	15679	10	9A
0005433123635	15679	11	11D
0005433123644	15679	12	12E
0005433123643	15679	13	13F
0005433123651	15679	14	14E
0005433123655	15679	15	15E
0005433123653	15679	16	18A
0005433123649	15679	17	18D
0005433123652	15679	18	18E
0005433123637	15679	19	18F
0005433123647	15679	20	19A
0005433123654	15679	21	19D
0005433123639	15679	22	19E
0005435217677	24965	1	21D
0005434484253	8997	1	1A
0005434484252	8997	2	2C
0005434484257	8997	3	2D
0005434484256	8997	4	3C
0005434484254	8997	5	4C
0005434484255	8997	6	5C
0005434189097	16669	1	3A
0005434189094	16669	2	6A
0005434189096	16669	3	6C
0005434189095	16669	4	7A
0005434189098	16669	5	19C
0005434189093	16669	6	21B
0005433123649	7599	1	1A
0005433123651	7599	2	1C
0005433123638	7599	3	1F
0005433123636	7599	4	2D
0005433123654	7599	5	2F
0005433123640	7599	6	4D
0005433123639	7599	7	5A
0005433123647	7599	8	6D
0005433123646	7599	9	7A
0005433123645	7599	10	8A
0005433123643	7599	11	10F
0005433123641	7599	12	11D
0005433123642	7599	13	12A
0005433123653	7599	14	13D
0005433123634	7599	15	13F
0005433123655	7599	16	14F
0005433123648	7599	17	15A
0005433123644	7599	18	15D
0005433123637	7599	19	17A
0005433123635	7599	20	19A
0005433123652	7599	21	20A
0005433123650	7599	22	20C
0005432692630	7598	1	1A
0005432720518	7598	2	1D
0005433449656	7598	3	1F
0005433449666	7598	4	2A
0005432720515	7598	5	2C
0005433449667	7598	6	2D
0005432692627	7598	7	2F
0005433449650	7598	8	3A
0005433449652	7598	9	3C
0005433449657	7598	10	3D
0005432071531	7598	11	3F
0005432692652	7598	12	4A
0005432720514	7598	13	4D
0005433449659	7598	14	4E
0005432692622	7598	15	5A
0005432720534	7598	16	5C
0005432720510	7598	17	5D
0005432720521	7598	18	5E
0005432692635	7598	19	5F
0005433449662	7598	20	6A
0005433449658	7598	21	6C
0005432720511	7598	22	6E
0005433449669	7598	23	6F
0005432692648	7598	24	7A
0005432692637	7598	25	7C
0005432720532	7598	26	7D
0005432720523	7598	27	7E
0005432071532	7598	28	7F
0005433449661	7598	29	8A
0005432720527	7598	30	8C
0005432692642	7598	31	8D
0005432692625	7598	32	8F
0005432720530	7598	33	9A
0005432720535	7598	34	9C
0005432692650	7598	35	9D
0005432692641	7598	36	9E
0005432720516	7598	37	10A
0005432720519	7598	38	10C
0005432692651	7598	39	10D
0005432720520	7598	40	10E
0005432692643	7598	41	10F
0005432692645	7598	42	11A
0005432692631	7598	43	11C
0005432720522	7598	44	11D
0005432720513	7598	45	11E
0005432692640	7598	46	12C
0005432692636	7598	47	12D
0005432720533	7598	48	12F
0005432720528	7598	49	13A
0005432692632	7598	50	13C
0005432692633	7598	51	13D
0005432692639	7598	52	13E
0005432720524	7598	53	13F
0005432692638	7598	54	14C
0005433449651	7598	55	14D
0005432720526	7598	56	14E
0005432692629	7598	57	14F
0005432692623	7598	58	15A
0005432692634	7598	59	15C
0005432720517	7598	60	15D
0005433449663	7598	61	15E
0005432720537	7598	62	15F
0005432720536	7598	63	16A
0005432692626	7598	64	16C
0005432692647	7598	65	16D
0005433449660	7598	66	16F
0005432692628	7598	67	17A
0005432720512	7598	68	17C
0005433449671	7598	69	17D
0005433449668	7598	70	17F
0005432720525	7598	71	18A
0005432692624	7598	72	18D
0005433449665	7598	73	18E
0005432720531	7598	74	18F
0005433449655	7598	75	19A
0005432692644	7598	76	19C
0005433449670	7598	77	19D
0005433449654	7598	78	19E
0005433449664	7598	79	19F
0005432720529	7598	80	20A
0005432692649	7598	81	20D
0005433449653	7598	82	20E
0005432692646	7598	83	20F
0005433722127	30428	1	2F
0005433722125	30428	2	4A
0005432720477	30428	3	4C
0005433722124	30428	4	6A
0005433722121	30428	5	9A
0005433722126	30428	6	11F
0005433722123	30428	7	12A
0005433722122	30428	8	13E
0005434586238	1357	1	1A
0005434586239	1357	2	1D
0005434586251	1357	3	1F
0005433524881	1357	4	2A
0005434586260	1357	5	2F
0005434586261	1357	6	3A
0005433524888	1357	7	3C
0005433524885	1357	8	3D
0005434586259	1357	9	4A
0005433524886	1357	10	4C
0005433524889	1357	11	4D
0005434586252	1357	12	4F
0005432270965	1357	13	5A
0005432270962	1357	14	5C
0005433724741	1357	15	5D
0005434586243	1357	16	6A
0005434586244	1357	17	6D
0005434586242	1357	18	7A
0005434513541	1357	19	8F
0005434586247	1357	20	9A
0005434586250	1357	21	9F
0005434586249	1357	22	10E
0005434586253	1357	23	11A
0005434586256	1357	24	11C
0005433724739	1357	25	11E
0005434514930	1357	26	12C
0005434586257	1357	27	13A
0005433524887	1357	28	13C
0005434514929	1357	29	13D
0005434586241	1357	30	14A
0005434586258	1357	31	14D
0005433524882	1357	32	14F
0005434586236	1357	33	15C
0005433724740	1357	34	15D
0005433524883	1357	35	15E
0005434513542	1357	36	16A
0005434586245	1357	37	16F
0005434586240	1357	38	17A
0005433524884	1357	39	17F
0005432270963	1357	40	18A
0005434586248	1357	41	18D
0005432270964	1357	42	18F
0005434586246	1357	43	19C
0005433724742	1357	44	19E
0005434586237	1357	45	19F
0005434586255	1357	46	20A
0005434514931	1357	47	20E
0005434586254	1357	48	20F
0005434586165	18548	1	1D
0005432927901	18548	2	1F
0005432968807	18548	3	3D
0005433192857	18548	4	3F
0005433192854	18548	5	4C
0005432927898	18548	6	5A
0005433192855	18548	7	6A
0005434586164	18548	8	6F
0005433192863	18548	9	7A
0005433192851	18548	10	7E
0005433192852	18548	11	8D
0005433192856	18548	12	10D
0005432927902	18548	13	10F
0005433192861	18548	14	12C
0005433192853	18548	15	12D
0005433192850	18548	16	13D
0005433192858	18548	17	13E
0005433192860	18548	18	14E
0005432968806	18548	19	15C
0005432927900	18548	20	15E
0005434586177	18548	21	15F
0005432927897	18548	22	16A
0005433192862	18548	23	17D
0005432927899	18548	24	17F
0005433192859	18548	25	18E
0005434343680	11444	1	1A
0005434343671	11444	2	1D
0005434343677	11444	3	2A
0005434343681	11444	4	2B
0005434343659	11444	5	2C
0005434142554	11444	6	2D
0005434343668	11444	7	3A
0005434343670	11444	8	3B
0005434343683	11444	9	3C
0005434343678	11444	10	3D
0005434343682	11444	11	4C
0005434343665	11444	12	4D
0005434343667	11444	13	5A
0005434343654	11444	14	5B
0005434343679	11444	15	5C
0005434343660	11444	16	6A
0005434343662	11444	17	6C
0005434343669	11444	18	6D
0005434343664	11444	19	7A
0005434343676	11444	20	7C
0005434343674	11444	21	7D
0005434343661	11444	22	18B
0005434343685	11444	23	18D
0005434343652	11444	24	19A
0005434343675	11444	25	19C
0005434343651	11444	26	19D
0005434343656	11444	27	20A
0005434343684	11444	28	20B
0005434343663	11444	29	20C
0005434343653	11444	30	20D
0005434142555	11444	31	21B
0005434343672	11444	32	21C
0005434343673	11444	33	21D
0005434343655	11444	34	22A
0005434343657	11444	35	22B
0005434343658	11444	36	22D
0005434343666	11444	37	23B
0005435304995	29782	1	1B
0005435304107	29782	2	5D
0005435304105	29782	3	6A
0005435304996	29782	4	6D
0005435304106	29782	5	7B
0005435304104	29782	6	19A
0005435304108	29782	7	22C
0005435304997	29782	8	22D
0005435824253	1302	1	2F
0005435824259	1302	2	4F
0005435824243	1302	3	5F
0005435824242	1302	4	5D
0005435824248	1302	5	6A
0005435824236	1302	6	7C
0005435824235	1302	7	7B
0005435824257	1302	8	7D
0005435824247	1302	9	8A
0005435824254	1302	10	8C
0005435824233	1302	11	8F
0005432284516	1302	12	9A
0005432284515	1302	13	9D
0005435824255	1302	14	9F
0005435824244	1302	15	10B
0005435824239	1302	16	11A
0005435824246	1302	17	12A
0005435824234	1302	18	12B
0005435824249	1302	19	13A
0005435824237	1302	20	12F
0005435824258	1302	21	13E
0005435824241	1302	22	13D
0005435824245	1302	23	17B
0005435824260	1302	24	18B
0005435824240	1302	25	18E
0005435824250	1302	26	18D
0005435824251	1302	27	19A
0005435824252	1302	28	19C
0005435824261	1302	29	20A
0005435824256	1302	30	20D
0005435824238	1302	31	21B
0005432284517	1302	32	21F
0005433415429	17995	1	3D
0005433415433	17995	2	6D
0005433415427	17995	3	6C
0005433415435	17995	4	6E
0005433415442	17995	5	7A
0005433415441	17995	6	7E
0005433415431	17995	7	9C
0005433415434	17995	8	9B
0005433415438	17995	9	9F
0005433415430	17995	10	14C
0005433415428	17995	11	14E
0005433415444	17995	12	15F
0005433415437	17995	13	17B
0005433415439	17995	14	17C
0005433415443	17995	15	18E
0005433415436	17995	16	18F
0005433415440	17995	17	20B
0005433415432	17995	18	21C
0005432783047	5634	1	1C
0005432143942	5634	2	1D
0005432783043	5634	3	2A
0005432783017	5634	4	2D
0005432783024	5634	5	2F
0005432783003	5634	6	3A
0005432783051	5634	7	3C
0005432783029	5634	8	3D
0005432783005	5634	9	3F
0005432143941	5634	10	4A
0005432783028	5634	11	4D
0005432783048	5634	12	4E
0005432783046	5634	13	4F
0005432783031	5634	14	5D
0005432783035	5634	15	5F
0005432783006	5634	16	6D
0005432783033	5634	17	6E
0005432783007	5634	18	7C
0005432783011	5634	19	7D
0005432783056	5634	20	7E
0005432783038	5634	21	7F
0005432783041	5634	22	8A
0005432783012	5634	23	8D
0005432783004	5634	24	9A
0005432783015	5634	25	9E
0005432783053	5634	26	9F
0005432783016	5634	27	10A
0005432783008	5634	28	10C
0005432783057	5634	29	10D
0005432783019	5634	30	10E
0005432783049	5634	31	10F
0005432783025	5634	32	11A
0005432783023	5634	33	11E
0005432783037	5634	34	12A
0005432783014	5634	35	12C
0005432783018	5634	36	12D
0005432783040	5634	37	12F
0005432783009	5634	38	13D
0005432783020	5634	39	14E
0005432783034	5634	40	14F
0005432783027	5634	41	15A
0005432783022	5634	42	15C
0005432783026	5634	43	15D
0005432783030	5634	44	15F
0005432783055	5634	45	16C
0005432783013	5634	46	16D
0005432143939	5634	47	16F
0005432783042	5634	48	17D
0005432783039	5634	49	17E
0005432783010	5634	50	17F
0005432783050	5634	51	18A
0005432783021	5634	52	18D
0005432783054	5634	53	18E
0005432143940	5634	54	19A
0005432783032	5634	55	19D
0005432783036	5634	56	19E
0005432783044	5634	57	20A
0005432783052	5634	58	20C
0005432783045	5634	59	20D
0005435242453	15392	1	1A
0005435242455	15392	2	1D
0005435242460	15392	3	2D
0005435242463	15392	4	2F
0005435242449	15392	5	4A
0005435242456	15392	6	4D
0005435242464	15392	7	4E
0005435242448	15392	8	6D
0005435476655	15392	9	7C
0005435242443	15392	10	7E
0005435242451	15392	11	7D
0005435242458	15392	12	9F
0005435242445	15392	13	10C
0005435242469	15392	14	10F
0005435242452	15392	15	11F
0005435242446	15392	16	12A
0005435242462	15392	17	13D
0005435476656	15392	18	13E
0005435242459	15392	19	13F
0005435242465	15392	20	14C
0005435242468	15392	21	14D
0005435242447	15392	22	14E
0005435242450	15392	23	15A
0005435242467	15392	24	14F
0005435242461	15392	25	15E
0005435242457	15392	26	16C
0005435242470	15392	27	17A
0005435242444	15392	28	17F
0005435476657	15392	29	18C
0005435476658	15392	30	19E
0005435242454	15392	31	19F
0005435242466	15392	32	20F
0005432848105	4364	1	1C
0005432848111	4364	2	1D
0005434463899	4364	3	2A
0005432848103	4364	4	2D
0005432848112	4364	5	3C
0005432848101	4364	6	3D
0005432848107	4364	7	4A
0005432848106	4364	8	4B
0005432848113	4364	9	4D
0005432848109	4364	10	5A
0005434463898	4364	11	5B
0005434462760	4364	12	6D
0005434462759	4364	13	18A
0005432848108	4364	14	18B
0005432848100	4364	15	18D
0005432848104	4364	16	19C
0005432848102	4364	17	20D
0005432848110	4364	18	22A
0005435850784	28859	1	1D
0005435850779	28859	2	2B
0005435850781	28859	3	2D
0005435850783	28859	4	4C
0005435850780	28859	5	6A
0005435850785	28859	6	6B
0005435850786	28859	7	7C
0005435850776	28859	8	19C
0005435850778	28859	9	20A
0005435850777	28859	10	20C
0005435850782	28859	11	23A
0005433496528	6244	1	1A
0005433496517	6244	2	1C
0005434443484	6244	3	2A
0005434925357	6244	4	3C
0005433496535	6244	5	3F
0005433496529	6244	6	4A
0005433496532	6244	7	4C
0005433496521	6244	8	4E
0005433496543	6244	9	5A
0005434925347	6244	10	5C
0005434443478	6244	11	5D
0005434925358	6244	12	5E
0005433496514	6244	13	5F
0005433496519	6244	14	6A
0005434925353	6244	15	6C
0005433496526	6244	16	6D
0005434925345	6244	17	6E
0005433496536	6244	18	6F
0005434925343	6244	19	7D
0005433496544	6244	20	7E
0005433496522	6244	21	7F
0005433496525	6244	22	8A
0005434925359	6244	23	8D
0005433496530	6244	24	8F
0005434443479	6244	25	9A
0005434925348	6244	26	9C
0005433496516	6244	27	9D
0005434925351	6244	28	9F
0005433496533	6244	29	10A
0005434443485	6244	30	10C
0005433496545	6244	31	10D
0005433496542	6244	32	10E
0005433496540	6244	33	10F
0005433496524	6244	34	11D
0005434925363	6244	35	11E
0005433496527	6244	36	11F
0005434925352	6244	37	12A
0005434443473	6244	38	12C
0005434925362	6244	39	12D
0005433496531	6244	40	12E
0005434925355	6244	41	12F
0005434925361	6244	42	13A
0005432075181	6244	43	13D
0005433496541	6244	44	13F
0005434925346	6244	45	14A
0005434925349	6244	46	14C
0005434443476	6244	47	14D
0005434925354	6244	48	15C
0005434443480	6244	49	15D
0005434443488	6244	50	15E
0005434443477	6244	51	15F
0005434443487	6244	52	16A
0005434443481	6244	53	16C
0005434925356	6244	54	16D
0005434925344	6244	55	16E
0005434443474	6244	56	16F
0005434925350	6244	57	17A
0005433496537	6244	58	17C
0005433496534	6244	59	17D
0005433496523	6244	60	17E
0005433496538	6244	61	17F
0005433496515	6244	62	18C
0005434443483	6244	63	18D
0005432075180	6244	64	18E
0005432075182	6244	65	18F
0005433496539	6244	66	19A
0005434443486	6244	67	19C
0005434925360	6244	68	19D
0005433496520	6244	69	19E
0005434925364	6244	70	19F
0005433496546	6244	71	20A
0005434443482	6244	72	20C
0005434443475	6244	73	20E
0005433496518	6244	74	20F
0005433496476	20371	1	11C
0005433496477	20371	2	20D
0005435242495	12168	1	1A
0005435242483	12168	2	1C
0005435242491	12168	3	2A
0005435242474	12168	4	2C
0005435242484	12168	5	3A
0005435242496	12168	6	3C
0005435242497	12168	7	4A
0005435242490	12168	8	4E
0005435242477	12168	9	5F
0005435242475	12168	10	6D
0005435242488	12168	11	7C
0005435242471	12168	12	9A
0005435242481	12168	13	10C
0005435242493	12168	14	11A
0005435242478	12168	15	11F
0005435242473	12168	16	12C
0005435242485	12168	17	12E
0005432782839	12168	18	13A
0005435242479	12168	19	13C
0005435242492	12168	20	14A
0005435242489	12168	21	15A
0005435242472	12168	22	15C
0005435242487	12168	23	15E
0005435242476	12168	24	16C
0005435242480	12168	25	16D
0005435242486	12168	26	16F
0005435242494	12168	27	17A
0005435242482	12168	28	18E
0005432783000	15401	1	2A
0005432782970	15401	2	2D
0005432782958	15401	3	3C
0005432782993	15401	4	3F
0005432782965	15401	5	4A
0005432782961	15401	6	4D
0005432782975	15401	7	4E
0005432782978	15401	8	5C
0005432782988	15401	9	5E
0005432782998	15401	10	6A
0005432782986	15401	11	6C
0005432782972	15401	12	6D
0005432783002	15401	13	6F
0005432783001	15401	14	7C
0005432782983	15401	15	7E
0005432782992	15401	16	7F
0005432782999	15401	17	8A
0005432782959	15401	18	8C
0005432782966	15401	19	8D
0005432782982	15401	20	8E
0005432782962	15401	21	8F
0005432782980	15401	22	9A
0005432782956	15401	23	9E
0005432782976	15401	24	10A
0005432782981	15401	25	10C
0005432782950	15401	26	10D
0005432782964	15401	27	10E
0005432782951	15401	28	11A
0005432782996	15401	29	11C
0005432782974	15401	30	11D
0005432782985	15401	31	11F
0005432782995	15401	32	12D
0005432782969	15401	33	12E
0005432782977	15401	34	12F
0005432782953	15401	35	13C
0005432782997	15401	36	13F
0005432782967	15401	37	14A
0005432782979	15401	38	14C
0005432782960	15401	39	15C
0005432782954	15401	40	15D
0005432782971	15401	41	15E
0005432782989	15401	42	15F
0005432782957	15401	43	16A
0005432782990	15401	44	16D
0005432782991	15401	45	16E
0005432782987	15401	46	16F
0005432782984	15401	47	17D
0005432782968	15401	48	17F
0005432782963	15401	49	18C
0005432782949	15401	50	19C
0005432782994	15401	51	19D
0005432782955	15401	52	19F
0005432782973	15401	53	20E
0005432782952	15401	54	20F
0005434910075	10122	1	2D
0005435913865	10122	2	4F
0005435913862	10122	3	6F
0005435913859	10122	4	7E
0005435913864	10122	5	7D
0005434876642	10122	6	9C
0005435913858	10122	7	9E
0005435913861	10122	8	11E
0005434910073	10122	9	13C
0005435913863	10122	10	14D
0005435913860	10122	11	20A
0005434910074	10122	12	20E
0005434876917	14624	1	1C
0005434876859	14624	2	1A
0005434876877	14624	3	1D
0005434876874	14624	4	2A
0005434876924	14624	5	1F
0005434876925	14624	6	2F
0005434876868	14624	7	2D
0005434876921	14624	8	3C
0005434876910	14624	9	4A
0005434876848	14624	10	3F
0005434876928	14624	11	3D
0005434876909	14624	12	4D
0005434876931	14624	13	4C
0005434876914	14624	14	5D
0005434876911	14624	15	5C
0005434876922	14624	16	5A
0005434758860	14624	17	5F
0005434876847	14624	18	6B
0005434876915	14624	19	6A
0005434876861	14624	20	6C
0005434876857	14624	21	6F
0005434876938	14624	22	6E
0005434876900	14624	23	6D
0005434876934	14624	24	7A
0005434876899	14624	25	7C
0005434876869	14624	26	7B
0005434876932	14624	27	7E
0005434876881	14624	28	8A
0005434876865	14624	29	8C
0005434876940	14624	30	8B
0005434876903	14624	31	8D
0005434876892	14624	32	8F
0005434758861	14624	33	8E
0005434876871	14624	34	9B
0005434876916	14624	35	9A
0005434876885	14624	36	9D
0005434876860	14624	37	9C
0005434876893	14624	38	10A
0005434876858	14624	39	9F
0005434876930	14624	40	10B
0005434876912	14624	41	10E
0005434876913	14624	42	10D
0005434876895	14624	43	11A
0005434876849	14624	44	10F
0005434876937	14624	45	11B
0005434876887	14624	46	11C
0005434876862	14624	47	11F
0005434876908	14624	48	11E
0005434758859	14624	49	12B
0005434876918	14624	50	12A
0005434876853	14624	51	12C
0005434876920	14624	52	12F
0005434876904	14624	53	12E
0005434876866	14624	54	13B
0005434876883	14624	55	13A
0005434876856	14624	56	13C
0005434876876	14624	57	13E
0005434876863	14624	58	13D
0005434876870	14624	59	13F
0005434876850	14624	60	14C
0005434876878	14624	61	14B
0005434876927	14624	62	14A
0005434876867	14624	63	14D
0005434876901	14624	64	14E
0005434876851	14624	65	15B
0005434876855	14624	66	15A
0005434876854	14624	67	15D
0005434876872	14624	68	15C
0005434876902	14624	69	15E
0005434876942	14624	70	15F
0005434876879	14624	71	16C
0005434876923	14624	72	16B
0005434876935	14624	73	16D
0005434876939	14624	74	16F
0005434876882	14624	75	16E
0005434876891	14624	76	17B
0005434876896	14624	77	17A
0005434876941	14624	78	17D
0005434876919	14624	79	17C
0005434876886	14624	80	18B
0005434876889	14624	81	18A
0005434876852	14624	82	18C
0005434876894	14624	83	18F
0005434876907	14624	84	18E
0005434876933	14624	85	18D
0005434876898	14624	86	19A
0005434876906	14624	87	19C
0005434876936	14624	88	19B
0005434876897	14624	89	19D
0005434876873	14624	90	19F
0005434876864	14624	91	19E
0005434876905	14624	92	20C
0005434876890	14624	93	20B
0005434876926	14624	94	20D
0005434876884	14624	95	21B
0005434876875	14624	96	21A
0005434876880	14624	97	20F
0005434876929	14624	98	21C
0005434876888	14624	99	21E
0005435659972	9217	1	1D
0005435659976	9217	2	2D
0005435659974	9217	3	3A
0005435659979	9217	4	4C
0005435659975	9217	5	4D
0005435659971	9217	6	6B
0005435659981	9217	7	6C
0005435659980	9217	8	19D
0005435659978	9217	9	20A
0005435659973	9217	10	21A
0005435659977	9217	11	21D
0005435659982	9217	12	22A
0005434251831	24640	1	2C
0005434251830	24640	2	2D
0005434251825	24640	3	3D
0005434251828	24640	4	4B
0005434251827	24640	5	5B
0005434251834	24640	6	6D
0005434251829	24640	7	18C
0005434251826	24640	8	20A
0005434251832	24640	9	20C
0005434251833	24640	10	23B
0005433679887	2821	1	1A
0005432222704	2821	2	1C
0005433679863	2821	3	1F
0005433679870	2821	4	2D
0005433679861	2821	5	2F
0005433679881	2821	6	3A
0005433679859	2821	7	3C
0005433679896	2821	8	4A
0005433679874	2821	9	4D
0005433679892	2821	10	4E
0005432222706	2821	11	4F
0005432222705	2821	12	5A
0005433679880	2821	13	5C
0005433684389	2821	14	5D
0005433679860	2821	15	5F
0005433679904	2821	16	6A
0005433679897	2821	17	6C
0005432222707	2821	18	7C
0005433679894	2821	19	7D
0005433679871	2821	20	7E
0005433679875	2821	21	8A
0005433679873	2821	22	8C
0005433679867	2821	23	8D
0005433679868	2821	24	8F
0005433679878	2821	25	9A
0005433679857	2821	26	10C
0005433679900	2821	27	10E
0005432222703	2821	28	10F
0005432222708	2821	29	11C
0005433679855	2821	30	11E
0005433679899	2821	31	12C
0005433679877	2821	32	12E
0005433679869	2821	33	13A
0005433679866	2821	34	13C
0005433679864	2821	35	13D
0005433679883	2821	36	13E
0005433679879	2821	37	14A
0005433679898	2821	38	14E
0005433679890	2821	39	14F
0005433679888	2821	40	15A
0005433679872	2821	41	15D
0005433679889	2821	42	15E
0005433679865	2821	43	15F
0005433679862	2821	44	16C
0005433679884	2821	45	16E
0005433679886	2821	46	17E
0005433679902	2821	47	17F
0005433679891	2821	48	18A
0005433679856	2821	49	18D
0005433679876	2821	50	18E
0005433679858	2821	51	18F
0005433679895	2821	52	19A
0005433679893	2821	53	19C
0005433679901	2821	54	19E
0005433679903	2821	55	20A
0005433679885	2821	56	20C
0005433679882	2821	57	20F
0005432966579	29142	1	1C
0005432966566	29142	2	1F
0005432966565	29142	3	2A
0005432966562	29142	4	2D
0005432966573	29142	5	3A
0005433679729	29142	6	3F
0005432966577	29142	7	4E
0005432966581	29142	8	6F
0005432966563	29142	9	7A
0005432005173	29142	10	7E
0005432966560	29142	11	8D
0005432966582	29142	12	8E
0005432966572	29142	13	9F
0005432966559	29142	14	10A
0005432966564	29142	15	11D
0005432966561	29142	16	11F
0005432966575	29142	17	12A
0005432966578	29142	18	12F
0005432966568	29142	19	13C
0005432966571	29142	20	13D
0005432966569	29142	21	13F
0005432966576	29142	22	14D
0005432966567	29142	23	14F
0005432966574	29142	24	15C
0005432966570	29142	25	18C
0005432966580	29142	26	20A
0005432966558	29142	27	20C
0005432966583	29142	28	20E
0005433613594	9290	1	1A
0005433613542	9290	2	1C
0005433613593	9290	3	1F
0005433613552	9290	4	1D
0005433613564	9290	5	2A
0005433613558	9290	6	2C
0005433613545	9290	7	2D
0005433577611	9290	8	3A
0005433577604	9290	9	3C
0005433613568	9290	10	3D
0005433633304	9290	11	4A
0005433633301	9290	12	4C
0005433633292	9290	13	4F
0005433613576	9290	14	4D
0005433613547	9290	15	5A
0005433613539	9290	16	5C
0005433633310	9290	17	5D
0005433613598	9290	18	6F
0005433613575	9290	19	6D
0005433613587	9290	20	7A
0005433633300	9290	21	7D
0005433613573	9290	22	7C
0005433613604	9290	23	7F
0005433633295	9290	24	8A
0005433613560	9290	25	8B
0005433613557	9290	26	8D
0005433613544	9290	27	8C
0005433633313	9290	28	8E
0005433613580	9290	29	8F
0005433633288	9290	30	9B
0005433633285	9290	31	9A
0005433633289	9290	32	9C
0005433577608	9290	33	9E
0005433613596	9290	34	9D
0005433613599	9290	35	9F
0005433613574	9290	36	10A
0005432756799	9290	37	10E
0005433633296	9290	38	10F
0005433633303	9290	39	11B
0005433633293	9290	40	11A
0005433613554	9290	41	11E
0005433613548	9290	42	12A
0005433613543	9290	43	11F
0005433577603	9290	44	12B
0005433633283	9290	45	12C
0005433613572	9290	46	13A
0005433577607	9290	47	12E
0005433613588	9290	48	13C
0005433633308	9290	49	13B
0005433613536	9290	50	13D
0005432755028	9290	51	13E
0005433613608	9290	52	14B
0005433613582	9290	53	14A
0005433577610	9290	54	14C
0005433613553	9290	55	14E
0005433633306	9290	56	14D
0005433613592	9290	57	14F
0005433613559	9290	58	15A
0005433577605	9290	59	15C
0005433633307	9290	60	16B
0005433613566	9290	61	16C
0005433633314	9290	62	16F
0005433633316	9290	63	17B
0005433613595	9290	64	17A
0005433613567	9290	65	17C
0005432756798	9290	66	17D
0005432145081	9290	67	17F
0005433613562	9290	68	17E
0005433613538	9290	69	18B
0005433613597	9290	70	18D
0005433613603	9290	71	18F
0005433613609	9290	72	19B
0005433577613	9290	73	19D
0005433613563	9290	74	19C
0005433633284	9290	75	20B
0005433613607	9290	76	20C
0005433613585	9290	77	20E
0005433633286	9290	78	20D
0005433613555	9290	79	20F
0005433577609	9290	80	21A
0005433633315	9290	81	21D
0005433613577	9290	82	21C
0005433577614	9290	83	21E
0005433613586	9290	84	22B
0005433613584	9290	85	22D
0005433633297	9290	86	22C
0005433613583	9290	87	22E
0005433613537	9290	88	23A
0005433633290	9290	89	23C
0005433613579	9290	90	23B
0005432755027	9290	91	23E
0005433613590	9290	92	23D
0005433613589	9290	93	23F
0005433613540	9290	94	24B
0005432145080	9290	95	24D
0005433613550	9290	96	24E
0005432756800	9290	97	25A
0005433613610	9290	98	25C
0005433613569	9290	99	25D
0005433633294	9290	100	25E
0005433613570	9290	101	26A
0005433613602	9290	102	25F
0005433633311	9290	103	26B
0005433613546	9290	104	26C
0005433633302	9290	105	26D
0005432755026	9290	106	26F
0005433633291	9290	107	26E
0005433613565	9290	108	27B
0005433577606	9290	109	27A
0005433613591	9290	110	27C
0005433633298	9290	111	27D
0005433613541	9290	112	27E
0005433613606	9290	113	28A
0005433633287	9290	114	27F
0005433613581	9290	115	28B
0005433613600	9290	116	28D
0005433577612	9290	117	28C
0005433613561	9290	118	28E
0005433633305	9290	119	28F
0005432145079	9290	120	29B
0005433613551	9290	121	29C
0005433633299	9290	122	29E
0005433613571	9290	123	30A
0005433613556	9290	124	29F
0005433613601	9290	125	30D
0005433613578	9290	126	30C
0005433633317	9290	127	30F
0005432756797	9290	128	31B
0005433633312	9290	129	31A
0005433613549	9290	130	31C
0005433633309	9290	131	31D
0005433613605	9290	132	31F
0005434152751	25223	1	1C
0005434152757	25223	2	1D
0005434163488	25223	3	1F
0005434273050	25223	4	2C
0005434152758	25223	5	3A
0005434163484	25223	6	3D
0005434163486	25223	7	5A
0005434163490	25223	8	8D
0005434163487	25223	9	9E
0005434152752	25223	10	10C
0005434163489	25223	11	12C
0005434163491	25223	12	12D
0005434273051	25223	13	13B
0005434163482	25223	14	14D
0005434152759	25223	15	14C
0005434152756	25223	16	17E
0005434152755	25223	17	18A
0005434272165	25223	18	21A
0005434163481	25223	19	26B
0005434152753	25223	20	26D
0005434163485	25223	21	27B
0005434152754	25223	22	28C
0005434163483	25223	23	28F
0005434272166	25223	24	29F
0005432184909	4241	1	16F
0005432184910	4241	2	22E
0005432184911	4241	3	37D
0005435856143	26598	1	2F
0005435856145	26598	2	11E
0005435856146	26598	3	11D
0005435947045	26598	4	12D
0005435947053	26598	5	13F
0005435856144	26598	6	16D
0005432571268	26598	7	17B
0005435947052	26598	8	19E
0005435947054	26598	9	19F
0005435947056	26598	10	24D
0005435947044	26598	11	24E
0005435947046	26598	12	27A
0005435947049	26598	13	27D
0005435856142	26598	14	27F
0005435947042	26598	15	31H
0005435787324	26598	16	32E
0005435947055	26598	17	32D
0005435947047	26598	18	33E
0005432571269	26598	19	33G
0005432571271	26598	20	33F
0005435947043	26598	21	34E
0005435947051	26598	22	34G
0005432571270	26598	23	35B
0005435787325	26598	24	35G
0005435947050	26598	25	36G
0005435947048	26598	26	39D
0005433568195	352	1	1A
0005433568219	352	2	2A
0005433568224	352	3	2F
0005433568202	352	4	2D
0005433568194	352	5	3D
0005433568201	352	6	3C
0005433568244	352	7	3F
0005432238847	352	8	5A
0005433568208	352	9	4F
0005432238850	352	10	5C
0005433568197	352	11	5F
0005433568234	352	12	6A
0005433568207	352	13	7C
0005433568227	352	14	7D
0005433568214	352	15	8E
0005433568230	352	16	8D
0005433568210	352	17	9B
0005433568206	352	18	9F
0005433568239	352	19	10E
0005433568249	352	20	11B
0005433568228	352	21	11C
0005433568245	352	22	11D
0005433568225	352	23	11E
0005433568218	352	24	12A
0005433568257	352	25	12C
0005432238849	352	26	12E
0005433568192	352	27	13B
0005433568196	352	28	13C
0005433568251	352	29	13E
0005433568233	352	30	13D
0005433568220	352	31	13F
0005433568212	352	32	14A
0005433568209	352	33	15A
0005433568236	352	34	15E
0005433568252	352	35	15D
0005433568247	352	36	15F
0005433568231	352	37	17F
0005432238848	352	38	17E
0005433568204	352	39	18A
0005433568222	352	40	18B
0005433568248	352	41	18C
0005433568226	352	42	18E
0005433568203	352	43	18D
0005433568229	352	44	18F
0005432238851	352	45	20C
0005433568215	352	46	20E
0005433568193	352	47	20F
0005433568200	352	48	22C
0005433568237	352	49	22E
0005433568213	352	50	22D
0005433568243	352	51	23B
0005433568246	352	52	23E
0005433568221	352	53	24B
0005433568235	352	54	24C
0005433568253	352	55	24E
0005433568199	352	56	24D
0005433568258	352	57	25A
0005433568205	352	58	26B
0005433568211	352	59	26C
0005433568241	352	60	26D
0005433568198	352	61	27A
0005433568254	352	62	27C
0005433568216	352	63	27D
0005433568223	352	64	28D
0005432238846	352	65	28E
0005433568255	352	66	29C
0005433568238	352	67	29D
0005433568242	352	68	30A
0005433568232	352	69	30C
0005433568250	352	70	30D
0005433568240	352	71	30F
0005433568217	352	72	31A
0005433568256	352	73	31C
0005433074301	11603	1	1D
0005433074291	11603	2	2D
0005433074300	11603	3	2F
0005432947881	11603	4	3C
0005433074313	11603	5	4A
0005432947884	11603	6	3F
0005433074296	11603	7	4C
0005432947859	11603	8	4D
0005432947861	11603	9	4F
0005432947876	11603	10	5D
0005433074307	11603	11	5F
0005433134071	11603	12	6C
0005432947849	11603	13	6A
0005432947879	11603	14	7A
0005432947854	11603	15	7C
0005432947863	11603	16	7F
0005432947868	11603	17	8A
0005432947867	11603	18	8B
0005432947886	11603	19	8C
0005432947864	11603	20	9A
0005432947860	11603	21	9B
0005433134075	11603	22	10B
0005433074284	11603	23	10D
0005432947870	11603	24	10C
0005433074308	11603	25	10F
0005432947858	11603	26	11C
0005432947888	11603	27	12A
0005433074304	11603	28	11F
0005432947877	11603	29	12C
0005433074303	11603	30	12E
0005432947855	11603	31	12F
0005432947885	11603	32	13E
0005432947865	11603	33	14A
0005432947874	11603	34	13F
0005433074289	11603	35	14D
0005432947852	11603	36	15A
0005433074302	11603	37	15B
0005433074294	11603	38	15E
0005433131643	11603	39	15F
0005433074287	11603	40	16A
0005433074292	11603	41	16B
0005432192274	11603	42	16D
0005432947862	11603	43	16E
0005432947887	11603	44	16F
0005433131642	11603	45	17A
0005433074286	11603	46	17F
0005432192276	11603	47	18A
0005432947872	11603	48	18E
0005433134070	11603	49	19C
0005433134072	11603	50	20A
0005432947856	11603	51	20B
0005432192275	11603	52	20C
0005433131640	11603	53	20D
0005433074290	11603	54	21D
0005433074305	11603	55	21E
0005433131641	11603	56	21F
0005433074295	11603	57	22D
0005432947866	11603	58	22F
0005432947869	11603	59	23A
0005432947853	11603	60	23B
0005433074293	11603	61	23D
0005433074312	11603	62	23E
0005432947857	11603	63	24A
0005433074306	11603	64	23F
0005433134073	11603	65	24B
0005433074285	11603	66	24D
0005432947875	11603	67	24C
0005432947848	11603	68	24E
0005432947882	11603	69	25A
0005433074309	11603	70	25E
0005433074310	11603	71	26D
0005432947851	11603	72	27A
0005432947846	11603	73	26F
0005432947878	11603	74	27C
0005433074297	11603	75	27D
0005433074288	11603	76	27F
0005432947883	11603	77	28A
0005432947873	11603	78	28D
0005432947850	11603	79	29A
0005432192273	11603	80	29C
0005432947847	11603	81	29D
0005433131644	11603	82	29F
0005432947871	11603	83	30B
0005433074314	11603	84	30D
0005432947880	11603	85	30E
0005433074298	11603	86	31A
0005433074311	11603	87	31C
0005433074299	11603	88	31D
0005433134074	11603	89	31F
0005433817418	9940	1	4B
0005433817416	9940	2	5A
0005433817417	9940	3	6A
0005433817415	9940	4	5B
0005434732929	13948	1	3A
0005434732932	13948	2	3B
0005434732930	13948	3	4A
0005434732931	13948	4	6A
0005435981656	2342	1	1F
0005435981658	2342	2	1G
0005432984502	2342	3	1H
0005432225966	2342	4	2C
0005433753423	2342	5	2F
0005435981673	2342	6	3A
0005432300180	2342	7	3B
0005435981653	2342	8	3C
0005433753435	2342	9	3F
0005435981681	2342	10	4B
0005433753430	2342	11	4F
0005435981678	2342	12	5A
0005435981659	2342	13	4H
0005433766587	2342	14	5B
0005435981687	2342	15	5G
0005435981654	2342	16	5H
0005432655364	2342	17	9A
0005435981667	2342	18	9H
0005435981677	2342	19	9G
0005435981671	2342	20	11A
0005433753420	2342	21	11D
0005433753412	2342	22	11F
0005433753403	2342	23	11G
0005435981686	2342	24	11H
0005432655370	2342	25	12D
0005433753395	2342	26	12B
0005435981646	2342	27	12E
0005435981664	2342	28	12G
0005433753436	2342	29	13A
0005432300184	2342	30	13D
0005432655363	2342	31	13B
0005433753397	2342	32	13H
0005432655371	2342	33	14D
0005432655373	2342	34	14F
0005435981660	2342	35	15A
0005435981668	2342	36	14H
0005435981652	2342	37	15E
0005433753399	2342	38	15D
0005433753410	2342	39	15H
0005433753434	2342	40	16B
0005433753406	2342	41	16E
0005433753401	2342	42	16G
0005432225970	2342	43	16F
0005433753402	2342	44	17A
0005433766586	2342	45	17D
0005435981674	2342	46	17F
0005433764650	2342	47	17G
0005432984501	2342	48	18B
0005433753400	2342	49	18D
0005433753426	2342	50	18E
0005432225967	2342	51	18G
0005433753415	2342	52	19A
0005433753424	2342	53	19D
0005433753432	2342	54	19G
0005435981684	2342	55	20A
0005433753408	2342	56	19H
0005433753443	2342	57	20D
0005433753409	2342	58	20B
0005435981651	2342	59	20H
0005433753447	2342	60	21B
0005433753438	2342	61	21A
0005432655369	2342	62	21E
0005432300181	2342	63	21F
0005435981665	2342	64	21H
0005433753414	2342	65	21G
0005433753418	2342	66	22A
0005435981661	2342	67	22D
0005433753416	2342	68	22F
0005432225969	2342	69	22E
0005433753425	2342	70	22G
0005435981675	2342	71	23A
0005435981685	2342	72	23E
0005432300179	2342	73	23G
0005433753445	2342	74	24A
0005435981647	2342	75	24E
0005435981683	2342	76	24D
0005433753427	2342	77	24F
0005433753450	2342	78	25E
0005433753411	2342	79	27A
0005433753404	2342	80	25F
0005433753437	2342	81	27D
0005435981645	2342	82	27F
0005435981672	2342	83	27E
0005435981676	2342	84	27H
0005435981682	2342	85	28D
0005433753413	2342	86	28E
0005432655367	2342	87	28G
0005433753444	2342	88	28H
0005433753449	2342	89	29A
0005435981648	2342	90	29D
0005433753394	2342	91	29E
0005433766585	2342	92	29G
0005435981689	2342	93	30A
0005433753428	2342	94	30D
0005435981669	2342	95	30E
0005432655372	2342	96	30G
0005432300183	2342	97	31A
0005433753429	2342	98	31D
0005432300178	2342	99	31F
0005433753419	2342	100	31G
0005435981680	2342	101	32D
0005433753407	2342	102	32G
0005435981662	2342	103	32F
0005432300182	2342	104	32E
0005433753405	2342	105	32H
0005433753417	2342	106	33D
0005433753398	2342	107	33H
0005433753421	2342	108	33G
0005435981688	2342	109	34A
0005433753448	2342	110	34E
0005433753422	2342	111	34G
0005435981657	2342	112	34H
0005435981655	2342	113	35B
0005432655365	2342	114	35A
0005433753431	2342	115	35D
0005432655366	2342	116	35F
0005433753396	2342	117	36A
0005432225968	2342	118	35H
0005435981670	2342	119	36D
0005435981649	2342	120	36E
0005435981666	2342	121	37D
0005433753446	2342	122	37B
0005432655368	2342	123	37F
0005433753442	2342	124	37H
0005433753441	2342	125	38A
0005435981679	2342	126	38B
0005433753433	2342	127	38D
0005433753440	2342	128	38F
0005432655374	2342	129	38H
0005435981663	2342	130	38G
0005435981650	2342	131	39D
0005433753439	2342	132	39F
0005432051085	26206	1	1F
0005433434290	26206	2	2G
0005432984615	26206	3	3C
0005433434277	26206	4	3B
0005432984618	26206	5	3G
0005433434284	26206	6	3F
0005432984609	26206	7	4F
0005433434275	26206	8	4C
0005432984621	26206	9	5A
0005432984612	26206	10	5F
0005432984631	26206	11	5C
0005432984600	26206	12	9A
0005433434292	26206	13	5H
0005433434267	26206	14	11A
0005432984617	26206	15	9H
0005432049413	26206	16	11E
0005433434273	26206	17	11D
0005433434272	26206	18	11F
0005432984619	26206	19	11H
0005432984616	26206	20	12B
0005433434266	26206	21	12H
0005432984604	26206	22	13D
0005433434286	26206	23	13E
0005432049412	26206	24	14G
0005432984613	26206	25	15D
0005433434285	26206	26	15F
0005432984606	26206	27	16A
0005433434276	26206	28	16B
0005432869429	26206	29	16E
0005432869426	26206	30	16F
0005433434279	26206	31	16H
0005432984602	26206	32	17D
0005433434278	26206	33	17E
0005433434287	26206	34	18H
0005434731112	26206	35	19B
0005432869430	26206	36	19A
0005432984627	26206	37	19F
0005433753280	26206	38	20A
0005432049411	26206	39	20E
0005433434288	26206	40	20G
0005432984630	26206	41	21A
0005432984622	26206	42	21B
0005432984607	26206	43	21H
0005432984611	26206	44	22E
0005433434281	26206	45	23B
0005432984601	26206	46	23E
0005433434282	26206	47	23D
0005432051083	26206	48	23F
0005432869425	26206	49	24A
0005433434274	26206	50	24D
0005433434270	26206	51	25D
0005434731111	26206	52	27A
0005433434269	26206	53	27F
0005433434289	26206	54	28B
0005433434294	26206	55	28G
0005433434283	26206	56	29A
0005432984614	26206	57	29F
0005432984623	26206	58	30A
0005434731110	26206	59	30E
0005432984608	26206	60	31B
0005432984610	26206	61	31F
0005432984629	26206	62	31G
0005433434280	26206	63	32D
0005432984620	26206	64	33A
0005433753227	26206	65	33E
0005433434271	26206	66	33D
0005432869424	26206	67	33F
0005433434293	26206	68	33H
0005432984632	26206	69	34B
0005432984605	26206	70	34A
0005432984625	26206	71	34D
0005432984603	26206	72	35B
0005432869427	26206	73	35H
0005432984624	26206	74	36D
0005432869428	26206	75	37A
0005432984628	26206	76	37G
0005433434268	26206	77	38D
0005432984626	26206	78	38E
0005433434291	26206	79	38H
0005432051084	26206	80	39F
0005434731109	26206	81	39E
0005434374028	1486	1	1A
0005434374016	1486	2	1C
0005433460405	1486	3	2A
0005434374015	1486	4	1F
0005434374010	1486	5	2C
0005434374011	1486	6	2F
0005434374005	1486	7	4B
0005434374041	1486	8	4D
0005434374043	1486	9	4F
0005432267797	1486	10	5C
0005434374006	1486	11	5F
0005434374034	1486	12	6B
0005432267803	1486	13	6D
0005433460407	1486	14	7C
0005434374036	1486	15	7E
0005434374019	1486	16	7D
0005434374021	1486	17	8A
0005434374032	1486	18	7F
0005434373997	1486	19	8B
0005434374050	1486	20	8D
0005434374004	1486	21	8C
0005434374025	1486	22	8E
0005434374024	1486	23	9A
0005434374030	1486	24	9C
0005433460406	1486	25	9F
0005434374031	1486	26	10B
0005433461556	1486	27	10D
0005434374040	1486	28	11A
0005434374049	1486	29	11E
0005434374017	1486	30	11F
0005434374046	1486	31	12A
0005434374035	1486	32	12C
0005434374047	1486	33	12D
0005433461558	1486	34	12F
0005432267802	1486	35	13B
0005434374013	1486	36	13C
0005432267801	1486	37	13D
0005433150857	1486	38	13E
0005434373998	1486	39	14A
0005434374045	1486	40	14B
0005434373996	1486	41	14C
0005434374020	1486	42	14F
0005434374037	1486	43	14E
0005434374002	1486	44	15F
0005434374003	1486	45	16D
0005434374027	1486	46	17B
0005434374012	1486	47	17A
0005433461557	1486	48	17C
0005434374007	1486	49	17D
0005434374029	1486	50	18A
0005434374026	1486	51	18B
0005434374038	1486	52	18D
0005434374023	1486	53	18F
0005433150826	1486	54	19A
0005434374022	1486	55	19C
0005434373999	1486	56	19E
0005434374044	1486	57	20B
0005432267800	1486	58	20A
0005434374009	1486	59	20D
0005434374042	1486	60	20C
0005434374001	1486	61	21D
0005432267799	1486	62	22A
0005434374008	1486	63	21F
0005433150825	1486	64	22C
0005434374018	1486	65	22D
0005434374048	1486	66	22E
0005434374039	1486	67	22F
0005434374033	1486	68	23B
0005434374000	1486	69	23C
0005434373995	1486	70	23E
0005434374014	1486	71	23D
0005432267798	1486	72	23F
0005433150923	20131	1	1A
0005433150904	20131	2	1F
0005433150920	20131	3	2C
0005433150916	20131	4	2F
0005433150922	20131	5	3C
0005433150927	20131	6	4B
0005433150899	20131	7	4D
0005433150907	20131	8	4E
0005434029623	20131	9	4F
0005433150933	20131	10	5D
0005433150925	20131	11	5C
0005433150917	20131	12	6C
0005433150912	20131	13	7A
0005432056245	20131	14	7E
0005433150926	20131	15	7D
0005433764650	20131	16	8B
0005432056246	20131	17	8C
0005433150928	20131	18	8D
0005433150905	20131	19	8F
0005433150924	20131	20	9B
0005434029621	20131	21	9C
0005433150902	20131	22	12B
0005433150903	20131	23	12D
0005433150915	20131	24	12C
0005433150930	20131	25	12E
0005433150929	20131	26	13B
0005433150919	20131	27	13E
0005433931424	20131	28	13F
0005433150921	20131	29	14A
0005433150932	20131	30	14E
0005432056247	20131	31	15A
0005433150913	20131	32	15D
0005433150908	20131	33	15F
0005434029622	20131	34	16B
0005433150906	20131	35	16C
0005433150910	20131	36	16F
0005433931423	20131	37	19B
0005433150900	20131	38	19C
0005433150918	20131	39	20C
0005433150909	20131	40	20F
0005433150901	20131	41	21B
0005432056244	20131	42	22B
0005433150911	20131	43	22A
0005433150914	20131	44	22D
0005433150931	20131	45	22F
0005433931425	20131	46	23B
0005432056243	20131	47	23E
0005432282764	536	1	1D
0005432423776	536	2	2F
0005432423778	536	3	3A
0005432423767	536	4	3C
0005432423784	536	5	3D
0005432423796	536	6	4C
0005432423806	536	7	5A
0005432423774	536	8	5F
0005432423807	536	9	7A
0005432423789	536	10	8A
0005432423809	536	11	8D
0005432423793	536	12	8E
0005432423764	536	13	8F
0005432423794	536	14	9C
0005432423766	536	15	10A
0005432423797	536	16	10D
0005432423763	536	17	10F
0005432423800	536	18	11A
0005432423770	536	19	11E
0005432423781	536	20	12F
0005432423773	536	21	13C
0005432423765	536	22	13D
0005432423780	536	23	14F
0005432423790	536	24	15B
0005432423803	536	25	15A
0005432423768	536	26	15C
0005432423779	536	27	15F
0005432423775	536	28	15E
0005432423769	536	29	17C
0005432423795	536	30	18C
0005432423802	536	31	20A
0005432423798	536	32	19E
0005432423792	536	33	21A
0005432282767	536	34	21D
0005432282760	536	35	22A
0005432423788	536	36	22D
0005432423777	536	37	22F
0005432423782	536	38	22E
0005432282762	536	39	23D
0005432423799	536	40	24D
0005432282761	536	41	24E
0005432423808	536	42	24F
0005432423783	536	43	25A
0005432423786	536	44	25F
0005432423804	536	45	26A
0005432423772	536	46	26B
0005432423787	536	47	27C
0005432423805	536	48	28E
0005432423785	536	49	28D
0005432282765	536	50	29A
0005432423801	536	51	30E
0005432282763	536	52	31A
0005432282766	536	53	31B
0005432423791	536	54	31F
0005432423771	536	55	31E
0005432302277	12877	1	1A
0005432302275	12877	2	2F
0005432302276	12877	3	9C
0005432302278	12877	4	17A
0005434022725	465	1	1C
0005434022724	465	2	1H
0005434031953	465	3	1G
0005434022713	465	4	2B
0005434022736	465	5	2F
0005434022721	465	6	2G
0005432235532	465	7	3C
0005434029620	465	8	3G
0005434022774	465	9	4B
0005434022734	465	10	4H
0005434022729	465	11	5B
0005434022714	465	12	5G
0005434029619	465	13	9B
0005434028255	465	14	11D
0005434022718	465	15	11G
0005434022711	465	16	12A
0005434022762	465	17	12E
0005434022709	465	18	12F
0005434022763	465	19	12H
0005434022732	465	20	12G
0005434022756	465	21	13B
0005434031955	465	22	13E
0005434022772	465	23	13F
0005434022722	465	24	13H
0005434022717	465	25	14F
0005434022752	465	26	14E
0005434022712	465	27	14H
0005434022768	465	28	15D
0005434028254	465	29	15E
0005434022715	465	30	16D
0005434022748	465	31	16E
0005434022746	465	32	16F
0005434022735	465	33	17D
0005434022723	465	34	17H
0005434022726	465	35	18E
0005434022710	465	36	19F
0005432235533	465	37	19E
0005434022720	465	38	19H
0005434022753	465	39	20B
0005434022730	465	40	20F
0005434022731	465	41	20G
0005434022773	465	42	21B
0005434022737	465	43	21H
0005434028256	465	44	22D
0005434022716	465	45	22B
0005434022751	465	46	23A
0005434022767	465	47	23D
0005433057197	465	48	23B
0005434022754	465	49	23F
0005434022760	465	50	23G
0005434022750	465	51	24A
0005434022719	465	52	24D
0005434031956	465	53	24F
0005434022742	465	54	25D
0005434022757	465	55	27B
0005434022777	465	56	27D
0005434022741	465	57	27F
0005434022740	465	58	27E
0005432235530	465	59	27H
0005434022758	465	60	28G
0005434022744	465	61	28H
0005434022743	465	62	29D
0005434031954	465	63	29B
0005434022761	465	64	29F
0005434022739	465	65	29H
0005432235527	465	66	30A
0005434022764	465	67	31G
0005432235531	465	68	32B
0005434022759	465	69	32E
0005432045584	465	70	32F
0005434022766	465	71	32H
0005432235528	465	72	33B
0005434022738	465	73	33D
0005432235534	465	74	33H
0005434022775	465	75	34A
0005434022733	465	76	34D
0005432235529	465	77	34B
0005433057196	465	78	34F
0005434022755	465	79	34G
0005434022769	465	80	34H
0005434022771	465	81	35B
0005434022728	465	82	35E
0005434022749	465	83	36B
0005434022747	465	84	37D
0005433057195	465	85	37F
0005434022776	465	86	37E
0005434022745	465	87	37H
0005434022765	465	88	38H
0005434022770	465	89	38G
0005434022727	465	90	39E
0005433684392	12677	1	1F
0005434735614	12677	2	1H
0005433057293	12677	3	1G
0005434022545	12677	4	3H
0005432156303	12677	5	4B
0005433057291	12677	6	4C
0005432156302	12677	7	4G
0005434735613	12677	8	9A
0005433057299	12677	9	9H
0005433684390	12677	10	11F
0005433929553	12677	11	13D
0005433057320	12677	12	15G
0005433057316	12677	13	16F
0005433057303	12677	14	16G
0005433057305	12677	15	17G
0005433057323	12677	16	18A
0005433057296	12677	17	18D
0005433057332	12677	18	18H
0005434735616	12677	19	20F
0005433057322	12677	20	20G
0005433057327	12677	21	21D
0005432157464	12677	22	21E
0005434735617	12677	23	21G
0005433057317	12677	24	22B
0005434735615	12677	25	22D
0005433057306	12677	26	22H
0005433057326	12677	27	24B
0005433057297	12677	28	24E
0005433057294	12677	29	24G
0005433057328	12677	30	25D
0005433057324	12677	31	25F
0005433057292	12677	32	27D
0005433057311	12677	33	27H
0005433057308	12677	34	29G
0005433929554	12677	35	29H
0005433684391	12677	36	30E
0005433057330	12677	37	31A
0005432156300	12677	38	31E
0005433057321	12677	39	32A
0005433057309	12677	40	32F
0005433057314	12677	41	33A
0005433057310	12677	42	33E
0005433057307	12677	43	33G
0005433057304	12677	44	34A
0005433057300	12677	45	34B
0005433057319	12677	46	34E
0005433057295	12677	47	34F
0005433057325	12677	48	35A
0005433929555	12677	49	34H
0005433057315	12677	50	35D
0005433057329	12677	51	35G
0005433057331	12677	52	36A
0005433057301	12677	53	36E
0005433057298	12677	54	36H
0005432156301	12677	55	38A
0005433057302	12677	56	38D
0005433057318	12677	57	38E
0005433057313	12677	58	38F
0005433057312	12677	59	39E
0005433529216	13824	1	1A
0005433527207	13824	2	1F
0005433527200	13824	3	2A
0005433529211	13824	4	4C
0005433527203	13824	5	5C
0005433527205	13824	6	7A
0005433529219	13824	7	7D
0005433527202	13824	8	7F
0005433529214	13824	9	8B
0005433529218	13824	10	8F
0005433527199	13824	11	10B
0005433527210	13824	12	10E
0005433529213	13824	13	11C
0005433529215	13824	14	12B
0005433529210	13824	15	12D
0005433529220	13824	16	12C
0005433527201	13824	17	12F
0005433529221	13824	18	13E
0005433529212	13824	19	15C
0005433527206	13824	20	15F
0005433527208	13824	21	17B
0005433527209	13824	22	18F
0005433529217	13824	23	21C
0005433527204	13824	24	21D
0005433921964	2142	1	1A
0005433921888	2142	2	1C
0005433921899	2142	3	1H
0005433921950	2142	4	2A
0005433921893	2142	5	2B
0005433921926	2142	6	2F
0005433929555	2142	7	3B
0005433921937	2142	8	3A
0005432231410	2142	9	3G
0005432231415	2142	10	3H
0005433921975	2142	11	4C
0005433921890	2142	12	4A
0005433921883	2142	13	4G
0005433921898	2142	14	5C
0005433931423	2142	15	5F
0005433921911	2142	16	5H
0005433921885	2142	17	9B
0005433921927	2142	18	11A
0005433921948	2142	19	11D
0005432044485	2142	20	11F
0005433921921	2142	21	11G
0005433921925	2142	22	12A
0005433921979	2142	23	12E
0005433921952	2142	24	12F
0005433921961	2142	25	12H
0005433921908	2142	26	13A
0005432231414	2142	27	13E
0005433921906	2142	28	13G
0005433921959	2142	29	13H
0005433921946	2142	30	14B
0005433921918	2142	31	14H
0005433921960	2142	32	15B
0005433875355	2142	33	15E
0005433921936	2142	34	15D
0005433921943	2142	35	16B
0005433921882	2142	36	16A
0005433921969	2142	37	16F
0005433921938	2142	38	16E
0005433921892	2142	39	16D
0005433921903	2142	40	16H
0005433931424	2142	41	16G
0005433921919	2142	42	17B
0005432044484	2142	43	17A
0005433929554	2142	44	17D
0005433921970	2142	45	17F
0005433921913	2142	46	17E
0005433921958	2142	47	18A
0005433921945	2142	48	18E
0005433921956	2142	49	18F
0005433921957	2142	50	18G
0005433921884	2142	51	19A
0005433921891	2142	52	19D
0005433921909	2142	53	19G
0005433921972	2142	54	20A
0005433921933	2142	55	20D
0005433921977	2142	56	20B
0005433921910	2142	57	20F
0005433921942	2142	58	20E
0005433921915	2142	59	20G
0005433921973	2142	60	21A
0005433921955	2142	61	21D
0005433931425	2142	62	21E
0005433921914	2142	63	21F
0005433921967	2142	64	21H
0005433921889	2142	65	21G
0005433921941	2142	66	22A
0005432231412	2142	67	22D
0005433921904	2142	68	22B
0005433921887	2142	69	22E
0005432231409	2142	70	22G
0005433921917	2142	71	22H
0005433921901	2142	72	23B
0005433921968	2142	73	23A
0005433921895	2142	74	23E
0005433921894	2142	75	24D
0005433921932	2142	76	24F
0005433921929	2142	77	24G
0005432231408	2142	78	25D
0005433921940	2142	79	24H
0005432231413	2142	80	27B
0005433921939	2142	81	27A
0005433921920	2142	82	27F
0005433921971	2142	83	28A
0005433921949	2142	84	28B
0005433921922	2142	85	28D
0005432231407	2142	86	29A
0005433921897	2142	87	29D
0005433921907	2142	88	30B
0005433921928	2142	89	30A
0005433921976	2142	90	30F
0005433921935	2142	91	31B
0005433921962	2142	92	31G
0005433921931	2142	93	31F
0005433921963	2142	94	31H
0005433921912	2142	95	32B
0005433921923	2142	96	32E
0005433921881	2142	97	32H
0005433921947	2142	98	32G
0005432044483	2142	99	33A
0005433921924	2142	100	33D
0005433921896	2142	101	33F
0005433921934	2142	102	33H
0005433921953	2142	103	34A
0005432231416	2142	104	34D
0005433921965	2142	105	34E
0005433921905	2142	106	35B
0005433921954	2142	107	35D
0005433921900	2142	108	35F
0005433921966	2142	109	35E
0005433921978	2142	110	35G
0005433921886	2142	111	36B
0005432231411	2142	112	36A
0005433929553	2142	113	36D
0005433921916	2142	114	36F
0005433875356	2142	115	36G
0005433921974	2142	116	37D
0005433921930	2142	117	37F
0005433921944	2142	118	37E
0005433921951	2142	119	37H
0005433921902	2142	120	39D
0005433035558	24117	1	1A
0005432206114	24117	2	1F
0005433035552	24117	3	1H
0005433035521	24117	4	2B
0005433035547	24117	5	2C
0005433035524	24117	6	2H
0005434028258	24117	7	2F
0005433035565	24117	8	3B
0005433035548	24117	9	3C
0005432749753	24117	10	3G
0005433035569	24117	11	3H
0005433035536	24117	12	4G
0005433035527	24117	13	4H
0005433035543	24117	14	5B
0005433035523	24117	15	5C
0005433035519	24117	16	9B
0005432206111	24117	17	11A
0005433035531	24117	18	12F
0005433035540	24117	19	13A
0005433035563	24117	20	13G
0005433035526	24117	21	14H
0005432206110	24117	22	15B
0005433035532	24117	23	15G
0005433035553	24117	24	15F
0005432207626	24117	25	16B
0005433035525	24117	26	16E
0005433035562	24117	27	16G
0005433035535	24117	28	17B
0005433035530	24117	29	17D
0005434028260	24117	30	17H
0005433035557	24117	31	18B
0005432749754	24117	32	21H
0005433035554	24117	33	22E
0005433035546	24117	34	23B
0005433035537	24117	35	23A
0005433035522	24117	36	23D
0005433035566	24117	37	23H
0005434028259	24117	38	24G
0005433035550	24117	39	27D
0005432206112	24117	40	28A
0005433035551	24117	41	28B
0005433035533	24117	42	28D
0005433035549	24117	43	28F
0005433035568	24117	44	28E
0005433035528	24117	45	29A
0005432206113	24117	46	30B
0005433035567	24117	47	30F
0005433035571	24117	48	31D
0005433035545	24117	49	32A
0005433035520	24117	50	33A
0005433035534	24117	51	33B
0005434028257	24117	52	33F
0005433035561	24117	53	33H
0005433035539	24117	54	34A
0005433035560	24117	55	34D
0005433035570	24117	56	34F
0005432207625	24117	57	34H
0005432207624	24117	58	36A
0005433035564	24117	59	36B
0005433035541	24117	60	36D
0005433035542	24117	61	36H
0005433035555	24117	62	37D
0005433035559	24117	63	37F
0005433035538	24117	64	37G
0005433035556	24117	65	38A
0005433035544	24117	66	38G
0005433035529	24117	67	39E
0005434723801	251	1	1C
0005434723687	251	2	1A
0005434723791	251	3	1H
0005434723695	251	4	1G
0005434550440	251	5	1D
0005434723782	251	6	2C
0005435142380	251	7	2A
0005434723768	251	8	2D
0005434723796	251	9	3A
0005434723795	251	10	2K
0005434550470	251	11	2H
0005432277616	251	12	3C
0005434723743	251	13	3H
0005432277611	251	14	4C
0005434735610	251	15	4A
0005434723731	251	16	4K
0005434723765	251	17	5C
0005435142384	251	18	5A
0005434550432	251	19	11A
0005434723778	251	20	11D
0005434723720	251	21	11K
0005434723751	251	22	12C
0005435142387	251	23	12F
0005434723771	251	24	12E
0005434550436	251	25	12G
0005434723692	251	26	12H
0005434723774	251	27	13C
0005434723735	251	28	13F
0005434550425	251	29	13E
0005434723757	251	30	13D
0005434723721	251	31	14A
0005434550449	251	32	13K
0005434550434	251	33	14C
0005432277618	251	34	14F
0005434550448	251	35	14H
0005434723775	251	36	15C
0005434723736	251	37	15A
0005434723754	251	38	15F
0005434550469	251	39	15E
0005434723724	251	40	16A
0005434550451	251	41	15K
0005434550444	251	42	16D
0005434723730	251	43	16K
0005434723688	251	44	17F
0005432277610	251	45	17H
0005434723714	251	46	18C
0005434723694	251	47	18F
0005434550426	251	48	18K
0005434723710	251	49	19A
0005434723733	251	50	19E
0005434550471	251	51	19G
0005434550464	251	52	20A
0005434723793	251	53	19K
0005434723685	251	54	20C
0005434550476	251	55	20D
0005434550473	251	56	20G
0005434550437	251	57	20F
0005434302397	251	58	20K
0005434731108	251	59	20J
0005434550455	251	60	21B
0005434550465	251	61	21A
0005434731106	251	62	21D
0005434550458	251	63	21C
0005434723698	251	64	21J
0005434550481	251	65	21G
0005434723707	251	66	22A
0005434723752	251	67	21K
0005434723763	251	68	22B
0005434302396	251	69	22E
0005434723725	251	70	22H
0005434550463	251	71	23A
0005434723717	251	72	23D
0005435142379	251	73	23C
0005434550438	251	74	24D
0005435142389	251	75	23J
0005434723729	251	76	24F
0005434550478	251	77	24E
0005434723781	251	78	25A
0005434550453	251	79	25C
0005434550456	251	80	25F
0005434550452	251	81	25E
0005434550475	251	82	25H
0005432277620	251	83	25K
0005434731104	251	84	26G
0005434731107	251	85	26F
0005434723705	251	86	26J
0005434723804	251	87	26H
0005432277612	251	88	27A
0005434723691	251	89	27C
0005434723715	251	90	27D
0005434735609	251	91	27H
0005434550468	251	92	27G
0005434550435	251	93	27K
0005434723683	251	94	27J
0005434723789	251	95	28B
0005434731105	251	96	28C
0005434723776	251	97	28J
0005434723699	251	98	29D
0005434723784	251	99	29C
0005434550442	251	100	29E
0005434723690	251	101	29J
0005434723734	251	102	30C
0005432277614	251	103	30B
0005434723684	251	104	30D
0005434550461	251	105	30H
0005434723709	251	106	30G
0005434723756	251	107	30J
0005434550460	251	108	31B
0005434723758	251	109	31A
0005434723788	251	110	30K
0005434723786	251	111	31D
0005434723693	251	112	31E
0005434723708	251	113	31H
0005434550427	251	114	31K
0005434723728	251	115	32C
0005434723779	251	116	32E
0005434550447	251	117	32G
0005434723719	251	118	32F
0005434723700	251	119	32K
0005434723803	251	120	33C
0005434723802	251	121	33B
0005434723746	251	122	33E
0005434302398	251	123	33H
0005434550459	251	124	33K
0005434723732	251	125	33J
0005434723742	251	126	34B
0005434723761	251	127	34E
0005434550429	251	128	34F
0005434723738	251	129	35B
0005434550477	251	130	35A
0005434723773	251	131	34K
0005434723718	251	132	35D
0005434723777	251	133	35C
0005432277622	251	134	35G
0005434723759	251	135	35F
0005434723712	251	136	35H
0005434735611	251	137	35J
0005434550431	251	138	36C
0005434723740	251	139	36F
0005434723722	251	140	36D
0005434723794	251	141	36H
0005434723696	251	142	36G
0005434550467	251	143	36K
0005434723797	251	144	36J
0005434550428	251	145	37A
0005434723780	251	146	37C
0005434723769	251	147	37F
0005434550479	251	148	37K
0005434723744	251	149	38J
0005434550443	251	150	38K
0005434723783	251	151	39D
0005432277615	251	152	39C
0005432277621	251	153	39B
0005435142377	251	154	39G
0005434550433	251	155	39F
0005434723739	251	156	39H
0005434723745	251	157	39J
0005434735612	251	158	40C
0005434723689	251	159	40B
0005434550462	251	160	40G
0005434723747	251	161	40F
0005434723755	251	162	40J
0005434550445	251	163	41C
0005434723716	251	164	41G
0005434723711	251	165	41F
0005434550439	251	166	41E
0005435142383	251	167	41H
0005434550466	251	168	42A
0005434723702	251	169	41J
0005434723767	251	170	42C
0005434302395	251	171	42E
0005434723753	251	172	42D
0005434723785	251	173	42F
0005435142385	251	174	42J
0005434723737	251	175	42H
0005435142378	251	176	43B
0005434723766	251	177	43A
0005434723741	251	178	42K
0005434723790	251	179	43D
0005434550457	251	180	43E
0005434723706	251	181	43H
0005434550454	251	182	44C
0005434723760	251	183	44B
0005434723727	251	184	44E
0005434723772	251	185	44D
0005434723750	251	186	44G
0005434550446	251	187	45A
0005434723764	251	188	45C
0005434735607	251	189	45F
0005434723799	251	190	45E
0005432277613	251	191	45H
0005434550450	251	192	46A
0005434550480	251	193	45K
0005435142381	251	194	46C
0005434550472	251	195	46B
0005434550430	251	196	46G
0005434723713	251	197	46F
0005434723787	251	198	46K
0005435142382	251	199	47A
0005435142386	251	200	47E
0005434723762	251	201	47F
0005433233099	251	202	47H
0005434723726	251	203	48C
0005434723800	251	204	48E
0005434723770	251	205	48G
0005434735608	251	206	48F
0005434723703	251	207	48K
0005434723748	251	208	49C
0005434723686	251	209	49F
0005434550474	251	210	49E
0005434723798	251	211	49K
0005434723723	251	212	49H
0005434723701	251	213	50A
0005434723697	251	214	50F
0005434723749	251	215	50D
0005432277619	251	216	50H
0005435142388	251	217	50G
0005434723792	251	218	50K
0005432277617	251	219	51F
0005434550441	251	220	51E
0005433233100	251	221	51D
0005434723704	251	222	51G
0005433233332	9861	1	2D
0005433766586	9861	2	2C
0005433233310	9861	3	3D
0005433233304	9861	4	4A
0005433233328	9861	5	4G
0005433289742	9861	6	5D
0005433180745	9861	7	11D
0005434031958	9861	8	11C
0005433180735	9861	9	12A
0005433233294	9861	10	13D
0005433129208	9861	11	13F
0005433233333	9861	12	13E
0005434723311	9861	13	13H
0005433233287	9861	14	13G
0005433233290	9861	15	13K
0005433233288	9861	16	14C
0005433233300	9861	17	14K
0005432199145	9861	18	14G
0005433180727	9861	19	15E
0005432199146	9861	20	15D
0005433233281	9861	21	15G
0005433129211	9861	22	15K
0005432199148	9861	23	18C
0005433113504	9861	24	18B
0005433289743	9861	25	18A
0005433233320	9861	26	18G
0005433233318	9861	27	18K
0005433233327	9861	28	19H
0005433129210	9861	29	20A
0005433233283	9861	30	19K
0005433180733	9861	31	20C
0005433126777	9861	32	20D
0005433233286	9861	33	20F
0005433233311	9861	34	22C
0005433233282	9861	35	22B
0005433233317	9861	36	22H
0005433233331	9861	37	22K
0005434031960	9861	38	22J
0005433180730	9861	39	23A
0005433233303	9861	40	23C
0005433126779	9861	41	23G
0005433233334	9861	42	24D
0005433233316	9861	43	24E
0005433233284	9861	44	25A
0005433180747	9861	45	25B
0005433233309	9861	46	25D
0005433766587	9861	47	25H
0005433233321	9861	48	25G
0005433180732	9861	49	26A
0005433233336	9861	50	26C
0005433233277	9861	51	26G
0005433233280	9861	52	26H
0005433233326	9861	53	27D
0005432199147	9861	54	27E
0005433233308	9861	55	27H
0005433126778	9861	56	27K
0005433233323	9861	57	27J
0005433289745	9861	58	28C
0005432199149	9861	59	28G
0005433180744	9861	60	29D
0005434031961	9861	61	29F
0005433233324	9861	62	30B
0005433113503	9861	63	30K
0005433233301	9861	64	31B
0005433233298	9861	65	31C
0005433233291	9861	66	31G
0005433180736	9861	67	31K
0005433180729	9861	68	32B
0005433233293	9861	69	32G
0005433233306	9861	70	32F
0005433180741	9861	71	33A
0005433233289	9861	72	33D
0005433233299	9861	73	33E
0005433233302	9861	74	33G
0005432199152	9861	75	34C
0005433233278	9861	76	34E
0005433289740	9861	77	34D
0005433180726	9861	78	34G
0005433180743	9861	79	35J
0005433180738	9861	80	36F
0005433233296	9861	81	36E
0005433233285	9861	82	36H
0005433180739	9861	83	36J
0005433233275	9861	84	37G
0005433180737	9861	85	37F
0005433233297	9861	86	37E
0005433180728	9861	87	37K
0005432199150	9861	88	39D
0005433233307	9861	89	39J
0005433233292	9861	90	40A
0005433129209	9861	91	40E
0005434031959	9861	92	40J
0005433766585	9861	93	41A
0005433289739	9861	94	41E
0005433233335	9861	95	41H
0005433233313	9861	96	42D
0005433233312	9861	97	42F
0005433180746	9861	98	42K
0005433129207	9861	99	42J
0005433180742	9861	100	43A
0005434031957	9861	101	43E
0005433233274	9861	102	44E
0005433289744	9861	103	44F
0005433233279	9861	104	44J
0005433180749	9861	105	45D
0005433233276	9861	106	45C
0005433233295	9861	107	46A
0005433289741	9861	108	46G
0005433233319	9861	109	46F
0005433126780	9861	110	47A
0005433233329	9861	111	47F
0005433233330	9861	112	47H
0005433233315	9861	113	48A
0005433233325	9861	114	48K
0005433180731	9861	115	49C
0005433233322	9861	116	49G
0005433233273	9861	117	49F
0005433233305	9861	118	49K
0005434723312	9861	119	50C
0005433113502	9861	120	50A
0005432199151	9861	121	50E
0005433180748	9861	122	50D
0005433233314	9861	123	50F
0005433180740	9861	124	50K
0005433180750	9861	125	50H
0005433180734	9861	126	51G
0005435212331	7763	1	1A
0005432069440	7763	2	1H
0005434066551	7763	3	1G
0005432069444	7763	4	1D
0005434066531	7763	5	2C
0005434066564	7763	6	2A
0005432526090	7763	7	2G
0005434066524	7763	8	2D
0005432526135	7763	9	2K
0005432150085	7763	10	2H
0005432526110	7763	11	3D
0005432526136	7763	12	3C
0005432535761	7763	13	3H
0005432535764	7763	14	4H
0005434066575	7763	15	4G
0005432526126	7763	16	4D
0005434066579	7763	17	5C
0005432526077	7763	18	5A
0005432526042	7763	19	11C
0005432526153	7763	20	11F
0005432526082	7763	21	11E
0005432526078	7763	22	11H
0005434066553	7763	23	12A
0005432526115	7763	24	12E
0005434066565	7763	25	12G
0005432150082	7763	26	12F
0005434066567	7763	27	12K
0005432069446	7763	28	12H
0005432526166	7763	29	13A
0005432069445	7763	30	13K
0005432526137	7763	31	14E
0005432526105	7763	32	14C
0005434066583	7763	33	14F
0005432533249	7763	34	14K
0005432069447	7763	35	14H
0005432526049	7763	36	15C
0005432150083	7763	37	15A
0005434066532	7763	38	15K
0005434066577	7763	39	15H
0005434066528	7763	40	16C
0005434066554	7763	41	16A
0005432526104	7763	42	16F
0005432526051	7763	43	16E
0005434066574	7763	44	16H
0005434066530	7763	45	17A
0005432526121	7763	46	17E
0005432526095	7763	47	17D
0005432535762	7763	48	17H
0005432526168	7763	49	17G
0005432533250	7763	50	18C
0005432069439	7763	51	18B
0005432526036	7763	52	18D
0005432526160	7763	53	18E
0005432526107	7763	54	18H
0005434066563	7763	55	19B
0005432526145	7763	56	18K
0005432526099	7763	57	19C
0005434066544	7763	58	19H
0005432526098	7763	59	19G
0005432526119	7763	60	20A
0005432526056	7763	61	19K
0005432526144	7763	62	19J
0005434066578	7763	63	20C
0005432526059	7763	64	20B
0005432526112	7763	65	20E
0005432526162	7763	66	20D
0005432526155	7763	67	20H
0005432069451	7763	68	20G
0005434066519	7763	69	20K
0005432526054	7763	70	20J
0005432526152	7763	71	21B
0005432428880	7763	72	21E
0005432526109	7763	73	21C
0005434066522	7763	74	22C
0005432526062	7763	75	22F
0005432526118	7763	76	22K
0005432526103	7763	77	23C
0005432526123	7763	78	23F
0005432535763	7763	79	23E
0005432526061	7763	80	23H
0005432526128	7763	81	23K
0005432526066	7763	82	25A
0005432526125	7763	83	24G
0005432526124	7763	84	25C
0005432535760	7763	85	25E
0005432526106	7763	86	25D
0005432150080	7763	87	25G
0005432526080	7763	88	25J
0005432526130	7763	89	26C
0005432069443	7763	90	26A
0005432526132	7763	91	26E
0005432526169	7763	92	26G
0005432428879	7763	93	26F
0005432526093	7763	94	26K
0005432526113	7763	95	26J
0005432526140	7763	96	26H
0005432526040	7763	97	27F
0005434066537	7763	98	27E
0005434066570	7763	99	27D
0005434066549	7763	100	27H
0005432526122	7763	101	27K
0005432150079	7763	102	28B
0005434066560	7763	103	28D
0005434066536	7763	104	28H
0005434066539	7763	105	28G
0005432526094	7763	106	28F
0005434066566	7763	107	28E
0005432526111	7763	108	28K
0005432526089	7763	109	28J
0005434066558	7763	110	29E
0005432526075	7763	111	29D
0005434066526	7763	112	29H
0005432526043	7763	113	29K
0005434066547	7763	114	29J
0005432150084	7763	115	30C
0005432526092	7763	116	30B
0005434066516	7763	117	30A
0005432526100	7763	118	30E
0005432526148	7763	119	30H
0005432526046	7763	120	30G
0005432526055	7763	121	30F
0005432069448	7763	122	30K
0005432526101	7763	123	31D
0005432537025	7763	124	31C
0005432526045	7763	125	31B
0005434066556	7763	126	31E
0005432526142	7763	127	31J
0005432526053	7763	128	31H
0005432526087	7763	129	31G
0005434066512	7763	130	32A
0005432526131	7763	131	31K
0005432150078	7763	132	32C
0005434066535	7763	133	32B
0005432526167	7763	134	32E
0005434066562	7763	135	32H
0005432526079	7763	136	32G
0005434066582	7763	137	32F
0005434066517	7763	138	33B
0005432526057	7763	139	33C
0005434066542	7763	140	33F
0005432526129	7763	141	33E
0005434066545	7763	142	33J
0005432526037	7763	143	34C
0005432526097	7763	144	34A
0005432526070	7763	145	34E
0005434066559	7763	146	35B
0005432069449	7763	147	35A
0005432069450	7763	148	34K
0005432526146	7763	149	35D
0005434066523	7763	150	35E
0005432526091	7763	151	35J
0005432526143	7763	152	35H
0005432526084	7763	153	35K
0005434066576	7763	154	36A
0005432526151	7763	155	36F
0005432526074	7763	156	36E
0005434066534	7763	157	36D
0005432526139	7763	158	36G
0005432526076	7763	159	36H
0005434066569	7763	160	37B
0005432526047	7763	161	37A
0005434066572	7763	162	36K
0005432526065	7763	163	37D
0005434066521	7763	164	37C
0005432526083	7763	165	37G
0005432526058	7763	166	37F
0005432526086	7763	167	37E
0005434066552	7763	168	37H
0005432526158	7763	169	38A
0005432537027	7763	170	37J
0005432526088	7763	171	38C
0005432526044	7763	172	38J
0005434066541	7763	173	38H
0005434066525	7763	174	38K
0005432537026	7763	175	39B
0005432526165	7763	176	39F
0005432526060	7763	177	39G
0005434066527	7763	178	40A
0005434066513	7763	179	39J
0005434066561	7763	180	40C
0005434066580	7763	181	40D
0005432526141	7763	182	40H
0005432526068	7763	183	40G
0005434066520	7763	184	40J
0005434066548	7763	185	41B
0005432526048	7763	186	41A
0005434066514	7763	187	41C
0005434066518	7763	188	41F
0005432526069	7763	189	41E
0005432526164	7763	190	41H
0005434066546	7763	191	42E
0005432069441	7763	192	42G
0005432526163	7763	193	42F
0005434066581	7763	194	42H
0005432526052	7763	195	43B
0005434066573	7763	196	43A
0005434066550	7763	197	42K
0005432535765	7763	198	43D
0005432526138	7763	199	43C
0005432526081	7763	200	43E
0005432526127	7763	201	43G
0005434066533	7763	202	44A
0005432526096	7763	203	44E
0005432526117	7763	204	44F
0005434066515	7763	205	44K
0005432526039	7763	206	44J
0005432150081	7763	207	45B
0005434066543	7763	208	45F
0005432526108	7763	209	45E
0005432526073	7763	210	46C
0005432526041	7763	211	46B
0005432526102	7763	212	46A
0005432526156	7763	213	46D
0005432526085	7763	214	46G
0005432526120	7763	215	46J
0005434066540	7763	216	46H
0005432526072	7763	217	46K
0005432526134	7763	218	47E
0005432526149	7763	219	47D
0005432526038	7763	220	47C
0005432526116	7763	221	47F
0005432526159	7763	222	48A
0005432526154	7763	223	47H
0005432069452	7763	224	48D
0005434066529	7763	225	48C
0005434066568	7763	226	48E
0005432069453	7763	227	48H
0005432526147	7763	228	49C
0005432526063	7763	229	49A
0005432526157	7763	230	49E
0005432069442	7763	231	49D
0005434066555	7763	232	49F
0005432526133	7763	233	49K
0005434066571	7763	234	49H
0005432526150	7763	235	49G
0005432526067	7763	236	50C
0005432526050	7763	237	50A
0005432526114	7763	238	50G
0005432526071	7763	239	50F
0005432526064	7763	240	51D
0005434066538	7763	241	50K
0005434066584	7763	242	50H
0005432526161	7763	243	51F
0005432533251	7763	244	51E
0005434066557	7763	245	51G
0005435612094	5352	1	1D
0005435612060	5352	2	1C
0005435612075	5352	3	1G
0005435612026	5352	4	1K
0005435612013	5352	5	1H
0005435611988	5352	6	2H
0005432132996	5352	7	2D
0005435097077	5352	8	3A
0005434343716	5352	9	3G
0005434343701	5352	10	3D
0005435490179	5352	11	3C
0005435612022	5352	12	3H
0005434343715	5352	13	4C
0005434343686	5352	14	4A
0005435611997	5352	15	4D
0005434343724	5352	16	4K
0005435611995	5352	17	4H
0005435612027	5352	18	5D
0005435612098	5352	19	11A
0005435612076	5352	20	5K
0005435612007	5352	21	11E
0005432047495	5352	22	11K
0005434573153	5352	23	11H
0005435097069	5352	24	12A
0005435612067	5352	25	12G
0005435491411	5352	26	13A
0005435423580	5352	27	12K
0005435611994	5352	28	13D
0005435612082	5352	29	13F
0005435612001	5352	30	13E
0005434343705	5352	31	13G
0005435612086	5352	32	13K
0005435611991	5352	33	14C
0005435097078	5352	34	14F
0005435612059	5352	35	14E
0005434343717	5352	36	15C
0005435612025	5352	37	15A
0005435611992	5352	38	15E
0005432132987	5352	39	15D
0005435612079	5352	40	16A
0005435612011	5352	41	16D
0005435612044	5352	42	16C
0005435612045	5352	43	16G
0005434343703	5352	44	16F
0005435612042	5352	45	16E
0005435612019	5352	46	16H
0005434343694	5352	47	17A
0005435555338	5352	48	17E
0005435612017	5352	49	17G
0005434573149	5352	50	17F
0005435612012	5352	51	17K
0005435612064	5352	52	17H
0005435612088	5352	53	18C
0005434343698	5352	54	18B
0005435097076	5352	55	18A
0005434343687	5352	56	18E
0005434343714	5352	57	18G
0005435612084	5352	58	19B
0005435555340	5352	59	19A
0005435490180	5352	60	19C
0005435612029	5352	61	19E
0005432133002	5352	62	19H
0005432132994	5352	63	19G
0005435612093	5352	64	20A
0005432133003	5352	65	19K
0005435612078	5352	66	20C
0005434343723	5352	67	20B
0005435612052	5352	68	20E
0005432132995	5352	69	20D
0005435612072	5352	70	20F
0005435612102	5352	71	20K
0005435423585	5352	72	20H
0005435612038	5352	73	21B
0005435612100	5352	74	21D
0005435612080	5352	75	21C
0005434343722	5352	76	21G
0005435612090	5352	77	21F
0005434343692	5352	78	22B
0005434343695	5352	79	22D
0005434343691	5352	80	22G
0005434573157	5352	81	22K
0005434343713	5352	82	22H
0005435423579	5352	83	23B
0005435612023	5352	84	23A
0005435612018	5352	85	23D
0005434343709	5352	86	23F
0005435612062	5352	87	23H
0005434573154	5352	88	23K
0005435612085	5352	89	24F
0005435612014	5352	90	24E
0005435612041	5352	91	25A
0005435612005	5352	92	25C
0005435612083	5352	93	25H
0005434573150	5352	94	25G
0005435612034	5352	95	25K
0005435612058	5352	96	25J
0005435612077	5352	97	26A
0005435612000	5352	98	26G
0005435612089	5352	99	26F
0005435612016	5352	100	27D
0005432132999	5352	101	27C
0005432132998	5352	102	27B
0005432132993	5352	103	27K
0005435612095	5352	104	27J
0005435612040	5352	105	28C
0005435612092	5352	106	28B
0005435097073	5352	107	28A
0005435612036	5352	108	28G
0005432133000	5352	109	28J
0005435611989	5352	110	28H
0005434573156	5352	111	29A
0005435612104	5352	112	28K
0005434343718	5352	113	29E
0005435612028	5352	114	29J
0005435612065	5352	115	30G
0005434343719	5352	116	31B
0005432132991	5352	117	31C
0005435612054	5352	118	31E
0005435612037	5352	119	31H
0005435612020	5352	120	31G
0005434343688	5352	121	31K
0005435612099	5352	122	31J
0005434343721	5352	123	32C
0005435097074	5352	124	32B
0005434573146	5352	125	32E
0005435612069	5352	126	32H
0005435612033	5352	127	32G
0005435612043	5352	128	32F
0005435612003	5352	129	32K
0005435612103	5352	130	33A
0005434343704	5352	131	34A
0005435611999	5352	132	34B
0005434343711	5352	133	34C
0005432132992	5352	134	34G
0005435612051	5352	135	34J
0005434343707	5352	136	35B
0005435612050	5352	137	35A
0005434573158	5352	138	34K
0005435612032	5352	139	35F
0005435097070	5352	140	35J
0005434343712	5352	141	35H
0005434343706	5352	142	35G
0005435612068	5352	143	36C
0005435612024	5352	144	36B
0005435612105	5352	145	36A
0005435490177	5352	146	36E
0005434573148	5352	147	36D
0005435612091	5352	148	36G
0005435612008	5352	149	36F
0005435555339	5352	150	36J
0005435612047	5352	151	37B
0005435612056	5352	152	36K
0005435611990	5352	153	37D
0005435612073	5352	154	37C
0005432132990	5352	155	37F
0005435490178	5352	156	37J
0005435423578	5352	157	37H
0005435612004	5352	158	37G
0005435611996	5352	159	39B
0005435612039	5352	160	38K
0005435612101	5352	161	39F
0005434343697	5352	162	39E
0005435612048	5352	163	39D
0005435612015	5352	164	39H
0005434343689	5352	165	39G
0005435612002	5352	166	40A
0005435612061	5352	167	39J
0005435097071	5352	168	40C
0005432132988	5352	169	40H
0005435612010	5352	170	40G
0005434343696	5352	171	40K
0005434343699	5352	172	40J
0005435612074	5352	173	41B
0005435611987	5352	174	41D
0005434343700	5352	175	41G
0005435612063	5352	176	41K
0005435612066	5352	177	42E
0005434573151	5352	178	42F
0005434573145	5352	179	42K
0005434573152	5352	180	42J
0005432047497	5352	181	42H
0005435612070	5352	182	43J
0005434343720	5352	183	43H
0005435612035	5352	184	43G
0005435611993	5352	185	44B
0005434573155	5352	186	44E
0005435612031	5352	187	44D
0005435611986	5352	188	44H
0005435491412	5352	189	45D
0005435611985	5352	190	45C
0005435612049	5352	191	45H
0005434343710	5352	192	45K
0005434573144	5352	193	46B
0005435612053	5352	194	46E
0005435612081	5352	195	46G
0005435612097	5352	196	46F
0005435423584	5352	197	46K
0005432047496	5352	198	46J
0005435097075	5352	199	47C
0005432133001	5352	200	47D
0005432132989	5352	201	47G
0005435612096	5352	202	47F
0005435612030	5352	203	47K
0005435612006	5352	204	47H
0005435612021	5352	205	48C
0005435612046	5352	206	48A
0005434343690	5352	207	48E
0005434343702	5352	208	48D
0005435612071	5352	209	48G
0005435611998	5352	210	48K
0005434343693	5352	211	49D
0005434573147	5352	212	49C
0005435491410	5352	213	49H
0005435612009	5352	214	50A
0005435612055	5352	215	49K
0005435612087	5352	216	50F
0005435097072	5352	217	50E
0005435612057	5352	218	50D
0005432132997	5352	219	50G
0005434343708	5352	220	51G
0005435423857	10920	1	1C
0005435423798	10920	2	2C
0005433719092	10920	3	2G
0005435423832	10920	4	2D
0005435380227	10920	5	3A
0005434244558	10920	6	3D
0005435423853	10920	7	3K
0005435423816	10920	8	11A
0005435423794	10920	9	5K
0005432166854	10920	10	11C
0005435423829	10920	11	11G
0005435423850	10920	12	12C
0005435423789	10920	13	12F
0005434656526	10920	14	14C
0005435304102	10920	15	14E
0005432164931	10920	16	14K
0005432164928	10920	17	15C
0005435423806	10920	18	15A
0005435423822	10920	19	15E
0005435319443	10920	20	15K
0005435423793	10920	21	17E
0005434244555	10920	22	17D
0005434244569	10920	23	17G
0005435423819	10920	24	17K
0005434244564	10920	25	18B
0005435319446	10920	26	18D
0005434244561	10920	27	18F
0005432164925	10920	28	18E
0005435423800	10920	29	18J
0005432840983	10920	30	19C
0005435423796	10920	31	19B
0005435319441	10920	32	19K
0005435423826	10920	33	19J
0005434656527	10920	34	20C
0005435319442	10920	35	20D
0005434244559	10920	36	20K
0005435423847	10920	37	21B
0005435380225	10920	38	21D
0005435423795	10920	39	21C
0005435319448	10920	40	21F
0005435423841	10920	41	21H
0005435304101	10920	42	22A
0005435423790	10920	43	21K
0005435423839	10920	44	22C
0005435319445	10920	45	22D
0005432164927	10920	46	22F
0005435423818	10920	47	22H
0005435423835	10920	48	23B
0005435304099	10920	49	23A
0005435423814	10920	50	23F
0005435304992	10920	51	23E
0005435423856	10920	52	24D
0005435423807	10920	53	23K
0005434244565	10920	54	24F
0005435423824	10920	55	24E
0005435423845	10920	56	25B
0005434244568	10920	57	25C
0005432164930	10920	58	25K
0005434244554	10920	59	26C
0005435319444	10920	60	26A
0005435423849	10920	61	26D
0005432363368	10920	62	26J
0005432840984	10920	63	26H
0005435423788	10920	64	27D
0005435423804	10920	65	27F
0005435304993	10920	66	27E
0005435423791	10920	67	28A
0005435423808	10920	68	28F
0005435423810	10920	69	28J
0005435423787	10920	70	29B
0005435423851	10920	71	29H
0005434244550	10920	72	29K
0005435423805	10920	73	30B
0005434244548	10920	74	30H
0005434244553	10920	75	31E
0005435423797	10920	76	31J
0005435423809	10920	77	31K
0005435423801	10920	78	32E
0005434244549	10920	79	32D
0005434244560	10920	80	32C
0005434244571	10920	81	32K
0005434244566	10920	82	33C
0005435423817	10920	83	33F
0005434244552	10920	84	34G
0005434244545	10920	85	34K
0005435423848	10920	86	34J
0005435423840	10920	87	35B
0005434244557	10920	88	35A
0005435423823	10920	89	35D
0005434244547	10920	90	35F
0005435423844	10920	91	35H
0005434244544	10920	92	35G
0005435423843	10920	93	35J
0005432166853	10920	94	36C
0005435423828	10920	95	36F
0005435423838	10920	96	36G
0005435423799	10920	97	36J
0005435423827	10920	98	37B
0005435319447	10920	99	38B
0005435423831	10920	100	39B
0005435304994	10920	101	39D
0005435423846	10920	102	39G
0005435423803	10920	103	40A
0005434244567	10920	104	39K
0005435423836	10920	105	39J
0005435319449	10920	106	40C
0005434244546	10920	107	40B
0005435423834	10920	108	40H
0005432363370	10920	109	41A
0005434244563	10920	110	41F
0005435423820	10920	111	41G
0005435423837	10920	112	42A
0005435423842	10920	113	42B
0005435423833	10920	114	42E
0005435304100	10920	115	42K
0005434244572	10920	116	43D
0005435423852	10920	117	43E
0005435423802	10920	118	43G
0005432164929	10920	119	44A
0005435304990	10920	120	43J
0005432164924	10920	121	44B
0005435423815	10920	122	44E
0005435423825	10920	123	44D
0005432164926	10920	124	44G
0005433719093	10920	125	44F
0005434244556	10920	126	44K
0005435423811	10920	127	45A
0005435423813	10920	128	45C
0005432363371	10920	129	45F
0005432363367	10920	130	46C
0005435423854	10920	131	46B
0005434244551	10920	132	46D
0005435423830	10920	133	46F
0005435423812	10920	134	47C
0005435423821	10920	135	47A
0005435304103	10920	136	47K
0005435423792	10920	137	47H
0005434244570	10920	138	48E
0005435423855	10920	139	49C
0005432363369	10920	140	49A
0005435380224	10920	141	48K
0005434244562	10920	142	49D
0005435380226	10920	143	49G
0005432166855	10920	144	50D
0005435304991	10920	145	51F
0005433633331	3264	1	1A
0005433633334	3264	2	1D
0005433633339	3264	3	1F
0005432181393	3264	4	2A
0005433506928	3264	5	2C
0005433506923	3264	6	2F
0005433804865	3264	7	2D
0005433633348	3264	8	3C
0005433633332	3264	9	3F
0005433804881	3264	10	3D
0005433506924	3264	11	4C
0005433633333	3264	12	4F
0005433804886	3264	13	4D
0005433633342	3264	14	5A
0005433633350	3264	15	5C
0005433633351	3264	16	5F
0005433804887	3264	17	5D
0005432181388	3264	18	6A
0005433633354	3264	19	6C
0005432181409	3264	20	6D
0005433804885	3264	21	6F
0005432181394	3264	22	7C
0005433633340	3264	23	7D
0005432181404	3264	24	8B
0005433633324	3264	25	8C
0005433804890	3264	26	8E
0005433804873	3264	27	8F
0005433804877	3264	28	9B
0005433506922	3264	29	9C
0005433633318	3264	30	9E
0005433633321	3264	31	9D
0005433633322	3264	32	9F
0005433804891	3264	33	10A
0005432181401	3264	34	10D
0005433804868	3264	35	10C
0005433804883	3264	36	10E
0005433804878	3264	37	11B
0005433633353	3264	38	11C
0005433804871	3264	39	11D
0005433633341	3264	40	11F
0005433804884	3264	41	11E
0005433804861	3264	42	12B
0005432181402	3264	43	12D
0005433804874	3264	44	12C
0005433506914	3264	45	13A
0005433506926	3264	46	13B
0005433804869	3264	47	13D
0005433633346	3264	48	13E
0005432181398	3264	49	14B
0005433804888	3264	50	14D
0005433633326	3264	51	14E
0005433804875	3264	52	14F
0005433633328	3264	53	15C
0005433804872	3264	54	15D
0005433804864	3264	55	15F
0005432181389	3264	56	16A
0005433633352	3264	57	16B
0005432181396	3264	58	16D
0005433633327	3264	59	16F
0005432181403	3264	60	17B
0005433506921	3264	61	17D
0005433506929	3264	62	17F
0005433804892	3264	63	18A
0005433633338	3264	64	18B
0005433506920	3264	65	18C
0005433633343	3264	66	18E
0005432181390	3264	67	19B
0005433506925	3264	68	19C
0005432181387	3264	69	20A
0005433804862	3264	70	20C
0005433506915	3264	71	20F
0005433804860	3264	72	21A
0005433804866	3264	73	21C
0005433506913	3264	74	21B
0005432181406	3264	75	22A
0005433633319	3264	76	22C
0005433633337	3264	77	22F
0005433804870	3264	78	23B
0005433506919	3264	79	23A
0005432181408	3264	80	23C
0005433804879	3264	81	23D
0005432181392	3264	82	23E
0005432181400	3264	83	24B
0005433804876	3264	84	24C
0005433804863	3264	85	24E
0005433506927	3264	86	24F
0005433633330	3264	87	25A
0005433804882	3264	88	25C
0005432181399	3264	89	25B
0005432181407	3264	90	25E
0005433633336	3264	91	26B
0005433506917	3264	92	26A
0005433633349	3264	93	26C
0005433633344	3264	94	26F
0005433804867	3264	95	28A
0005432181391	3264	96	27F
0005433633329	3264	97	28D
0005433633345	3264	98	28C
0005433506916	3264	99	28F
0005432181397	3264	100	29B
0005433633323	3264	101	29C
0005433506918	3264	102	29E
0005433633347	3264	103	29D
0005433633320	3264	104	30C
0005433804859	3264	105	30D
0005433804889	3264	106	30F
0005433633325	3264	107	31A
0005432181405	3264	108	31C
0005433804880	3264	109	31B
0005433506912	3264	110	31D
0005433633335	3264	111	31F
0005432181395	3264	112	31E
0005432459154	8226	1	1C
0005432459136	8226	2	1D
0005432459119	8226	3	2A
0005435884558	8226	4	1F
0005435884555	8226	5	2C
0005432459169	8226	6	2F
0005435884563	8226	7	2D
0005432042522	8226	8	3A
0005435884528	8226	9	3F
0005432459155	8226	10	3D
0005435884532	8226	11	4A
0005435884572	8226	12	4F
0005432042511	8226	13	4D
0005432042517	8226	14	5A
0005432042520	8226	15	5D
0005432459116	8226	16	5C
0005435884540	8226	17	6C
0005432459132	8226	18	6F
0005432459156	8226	19	6D
0005432459143	8226	20	7A
0005432459164	8226	21	7C
0005435884543	8226	22	8A
0005432459158	8226	23	8B
0005435884560	8226	24	8C
0005432459127	8226	25	8E
0005435884571	8226	26	8F
0005435884545	8226	27	9A
0005434312289	8226	28	9C
0005435884547	8226	29	9F
0005432042510	8226	30	9E
0005432459134	8226	31	10C
0005435884565	8226	32	10E
0005432459152	8226	33	10D
0005432459117	8226	34	11A
0005432042523	8226	35	10F
0005435884541	8226	36	11B
0005435884534	8226	37	11C
0005435884574	8226	38	11D
0005432459140	8226	39	11E
0005435884575	8226	40	12A
0005432459129	8226	41	11F
0005434312291	8226	42	12C
0005435884548	8226	43	12B
0005432459120	8226	44	12D
0005432459142	8226	45	12E
0005432459148	8226	46	13B
0005434326260	8226	47	13A
0005435884542	8226	48	13C
0005432459126	8226	49	13E
0005432459157	8226	50	13D
0005435884553	8226	51	13F
0005435884527	8226	52	14A
0005432042524	8226	53	14C
0005435884561	8226	54	14E
0005435884533	8226	55	14F
0005435884577	8226	56	15E
0005432042521	8226	57	15D
0005432459130	8226	58	16A
0005432459160	8226	59	16E
0005435884530	8226	60	16D
0005432459163	8226	61	16F
0005435884566	8226	62	17A
0005432042513	8226	63	17C
0005432459121	8226	64	17E
0005432459146	8226	65	18A
0005435884556	8226	66	17F
0005435884544	8226	67	18B
0005432459144	8226	68	18C
0005435884539	8226	69	18E
0005435884529	8226	70	18D
0005435884537	8226	71	18F
0005432042515	8226	72	19C
0005432459170	8226	73	19D
0005435884570	8226	74	20B
0005435884538	8226	75	20C
0005432459123	8226	76	20F
0005435884576	8226	77	21B
0005432042514	8226	78	21A
0005432459124	8226	79	21C
0005435884526	8226	80	21D
0005435884573	8226	81	21E
0005435884567	8226	82	21F
0005432459159	8226	83	22B
0005435884569	8226	84	22A
0005432459141	8226	85	22E
0005435884568	8226	86	22F
0005432459131	8226	87	23A
0005434312290	8226	88	23C
0005432459135	8226	89	23B
0005435884552	8226	90	23D
0005435884551	8226	91	23E
0005432459125	8226	92	23F
0005435884554	8226	93	24B
0005432042519	8226	94	24E
0005432459122	8226	95	24D
0005432459167	8226	96	25B
0005434326259	8226	97	25C
0005432042512	8226	98	25D
0005435884557	8226	99	25E
0005432459153	8226	100	26A
0005432459166	8226	101	26B
0005435884536	8226	102	26C
0005432459162	8226	103	26E
0005432459139	8226	104	26F
0005432459151	8226	105	27A
0005432459137	8226	106	27C
0005435884562	8226	107	27B
0005432459150	8226	108	27D
0005435884578	8226	109	27E
0005435884549	8226	110	28A
0005432459128	8226	111	27F
0005435884546	8226	112	28B
0005432042518	8226	113	28D
0005432459118	8226	114	28C
0005435884559	8226	115	28E
0005435884531	8226	116	29A
0005432042516	8226	117	29B
0005432459138	8226	118	29D
0005435884535	8226	119	29E
0005435884564	8226	120	30A
0005435884550	8226	121	29F
0005432459161	8226	122	30B
0005432459145	8226	123	30C
0005432459165	8226	124	30E
0005432459147	8226	125	30D
0005432459133	8226	126	30F
0005432459149	8226	127	31D
0005432459168	8226	128	31E
0005432382623	4515	1	1C
0005432382637	4515	2	1D
0005432382607	4515	3	2D
0005432727762	4515	4	2F
0005432727755	4515	5	3A
0005432727759	4515	6	3C
0005432382639	4515	7	3D
0005433453733	4515	8	3F
0005432382606	4515	9	4A
0005432382636	4515	10	4D
0005432382629	4515	11	4E
0005432382608	4515	12	4F
0005432382630	4515	13	5C
0005432382619	4515	14	5E
0005432382628	4515	15	5F
0005432727766	4515	16	6A
0005433453734	4515	17	6C
0005432382634	4515	18	6D
0005432382620	4515	19	6F
0005432382611	4515	20	7A
0005432727765	4515	21	7C
0005432382644	4515	22	7D
0005433454846	4515	23	8A
0005433722122	4515	24	8E
0005432382631	4515	25	9C
0005432382643	4515	26	9E
0005432727763	4515	27	10A
0005432727760	4515	28	10C
0005432382618	4515	29	10D
0005432382613	4515	30	10E
0005433722126	4515	31	10F
0005432382627	4515	32	11A
0005432382622	4515	33	11C
0005432382641	4515	34	11D
0005432382610	4515	35	11E
0005432727757	4515	36	11F
0005432382624	4515	37	12A
0005433722121	4515	38	12D
0005432382646	4515	39	12E
0005432382617	4515	40	12F
0005433454843	4515	41	13A
0005432382640	4515	42	13C
0005432382621	4515	43	13D
0005432727761	4515	44	13E
0005432382635	4515	45	13F
0005432727764	4515	46	14C
0005433454844	4515	47	14D
0005433722124	4515	48	14F
0005432382615	4515	49	15C
0005433722127	4515	50	15E
0005432382633	4515	51	16A
0005432382648	4515	52	16D
0005432382642	4515	53	16E
0005432382647	4515	54	17D
0005432382626	4515	55	17E
0005432382612	4515	56	18A
0005433722125	4515	57	18C
0005432382632	4515	58	18D
0005432727756	4515	59	18E
0005432382614	4515	60	18F
0005433454845	4515	61	19A
0005432382616	4515	62	19C
0005432382645	4515	63	19D
0005432382609	4515	64	19F
0005432727758	4515	65	20A
0005433722123	4515	66	20D
0005432382625	4515	67	20E
0005432382638	4515	68	20F
0005435540691	1738	1	1A
0005435540704	1738	2	1C
0005435528958	1738	3	1D
0005435540697	1738	4	2C
0005435528949	1738	5	3A
0005435528964	1738	6	3D
0005435540709	1738	7	3F
0005435540705	1738	8	4F
0005435540708	1738	9	5C
0005435540695	1738	10	5D
0005433516750	1738	11	5E
0005432294453	1738	12	5F
0005435540710	1738	13	6C
0005433516751	1738	14	6D
0005435528960	1738	15	6F
0005435528952	1738	16	7E
0005435528961	1738	17	7F
0005435540696	1738	18	8A
0005435528955	1738	19	8D
0005435540706	1738	20	8F
0005435540692	1738	21	9C
0005435528950	1738	22	9F
0005435528959	1738	23	10D
0005435540690	1738	24	10E
0005435528947	1738	25	10F
0005435528957	1738	26	11A
0005433516755	1738	27	11E
0005433516749	1738	28	12A
0005435528953	1738	29	12D
0005435528965	1738	30	12F
0005433516757	1738	31	13D
0005433516754	1738	32	13F
0005435540693	1738	33	14C
0005435540698	1738	34	14D
0005435540700	1738	35	14E
0005435528956	1738	36	14F
0005435540694	1738	37	15A
0005435528948	1738	38	15C
0005435540699	1738	39	15E
0005435540701	1738	40	15F
0005435540702	1738	41	16C
0005432294454	1738	42	17E
0005435540707	1738	43	17F
0005435528966	1738	44	18A
0005435528951	1738	45	18D
0005435540703	1738	46	18F
0005433516752	1738	47	19A
0005435528962	1738	48	19D
0005435528963	1738	49	19E
0005435528954	1738	50	19F
0005433516753	1738	51	20E
0005433516756	1738	52	20F
0005432924968	21993	1	7C
0005432924967	21993	2	14F
0005432924969	21993	3	19E
0005432924970	21993	4	20D
0005432838583	7354	1	1A
0005434458499	7354	2	1C
0005432838593	7354	3	1D
0005432838581	7354	4	2C
0005434458518	7354	5	3A
0005432838598	7354	6	3C
0005432823419	7354	7	4A
0005432838597	7354	8	4C
0005432838588	7354	9	4F
0005432073339	7354	10	5A
0005432838596	7354	11	5C
0005432838578	7354	12	5D
0005434458505	7354	13	5E
0005432838582	7354	14	5F
0005434458510	7354	15	6A
0005434458500	7354	16	6C
0005434458501	7354	17	6D
0005432838604	7354	18	6E
0005432838585	7354	19	7A
0005434458511	7354	20	7D
0005434458509	7354	21	7F
0005432838592	7354	22	8D
0005432838580	7354	23	8E
0005432073340	7354	24	9A
0005432838594	7354	25	9D
0005434458506	7354	26	9E
0005434458513	7354	27	9F
0005434458516	7354	28	10A
0005434458512	7354	29	10F
0005434458508	7354	30	11D
0005432840982	7354	31	11F
0005434458515	7354	32	11E
0005432838576	7354	33	12A
0005432838586	7354	34	12D
0005432073341	7354	35	12E
0005432838601	7354	36	12F
0005432838602	7354	37	13A
0005434458504	7354	38	13D
0005432823421	7354	39	13E
0005432840981	7354	40	13F
0005432838579	7354	41	14C
0005432073342	7354	42	14D
0005434458498	7354	43	14E
0005432838577	7354	44	14F
0005432838589	7354	45	15C
0005432823420	7354	46	15D
0005432840980	7354	47	15E
0005434458503	7354	48	15F
0005432838587	7354	49	16A
0005432838591	7354	50	16C
0005432838599	7354	51	16E
0005434458502	7354	52	16F
0005432838605	7354	53	17D
0005432838606	7354	54	17F
0005432838600	7354	55	18A
0005432838590	7354	56	18C
0005434458507	7354	57	19A
0005432838595	7354	58	19C
0005434458514	7354	59	19D
0005432838603	7354	60	19E
0005434458497	7354	61	19F
0005432838584	7354	62	20C
0005434458517	7354	63	20D
0005435252443	28912	1	1C
0005435252445	28912	2	2C
0005435252439	28912	3	4E
0005435491414	28912	4	5D
0005434664927	28912	5	5C
0005435252441	28912	6	5F
0005435252448	28912	7	6D
0005432000994	28912	8	6F
0005434664929	28912	9	8D
0005432838505	28912	10	9F
0005435252437	28912	11	10A
0005435252440	28912	12	10C
0005435252449	28912	13	10E
0005435252451	28912	14	11C
0005435252444	28912	15	11D
0005435252435	28912	16	11E
0005435252436	28912	17	12D
0005434664928	28912	18	12E
0005435252442	28912	19	13A
0005435252447	28912	20	13D
0005435252446	28912	21	13F
0005435252438	28912	22	14A
0005435252452	28912	23	14C
0005435252450	28912	24	15C
0005432838480	28912	25	15E
0005432000995	28912	26	17A
0005432838504	28912	27	18D
0005434664926	28912	28	19D
0005435491413	28912	29	19E
0005435990523	8786	1	1A
0005435990519	8786	2	4C
0005435990521	8786	3	4A
0005435990520	8786	4	6C
0005435990522	8786	5	9C
0005435990524	8786	6	12D
0005435990525	8786	7	14C
0005435990526	8786	8	18A
0005434275944	15722	1	4D
0005434275943	15722	2	6E
0005434275942	15722	3	8F
0005434275945	15722	4	17A
0005434275946	15722	5	21B
0005432427113	20635	1	1B
0005432427112	20635	2	3D
0005432427111	20635	3	4C
0005432427110	20635	4	5A
0005432427114	20635	5	5B
0005432359667	6381	1	1C
0005432359690	6381	2	1A
0005432335860	6381	3	2D
0005432363371	6381	4	3A
0005432359688	6381	5	3F
0005432359664	6381	6	4C
0005432335865	6381	7	4E
0005432363367	6381	8	5B
0005432359702	6381	9	5C
0005432359679	6381	10	5E
0005432359683	6381	11	6A
0005432359682	6381	12	6C
0005432359676	6381	13	6D
0005432062152	6381	14	6E
0005432359658	6381	15	6F
0005432359654	6381	16	7D
0005432363368	6381	17	7B
0005432359668	6381	18	7F
0005432359670	6381	19	8A
0005432359672	6381	20	8B
0005432359693	6381	21	8D
0005432359656	6381	22	9A
0005432359663	6381	23	9F
0005432359681	6381	24	10E
0005432359700	6381	25	11B
0005432359685	6381	26	11C
0005432359671	6381	27	11E
0005432359695	6381	28	11D
0005432359699	6381	29	11F
0005432335863	6381	30	12A
0005432359657	6381	31	12D
0005432335861	6381	32	12E
0005432359674	6381	33	12F
0005432359665	6381	34	13A
0005432359660	6381	35	13C
0005432359662	6381	36	13B
0005432359689	6381	37	13D
0005432359703	6381	38	13E
0005432359698	6381	39	13F
0005432359684	6381	40	14B
0005435176604	6381	41	14C
0005432335867	6381	42	14D
0005432335864	6381	43	15A
0005432363370	6381	44	15C
0005432359692	6381	45	16B
0005432359678	6381	46	16E
0005432359680	6381	47	17D
0005432335862	6381	48	17C
0005432359675	6381	49	17E
0005432335859	6381	50	17F
0005432359659	6381	51	18B
0005432359694	6381	52	18D
0005432359677	6381	53	18C
0005432359661	6381	54	18F
0005432062151	6381	55	19A
0005432335858	6381	56	19F
0005432359655	6381	57	19E
0005435176603	6381	58	20B
0005432363369	6381	59	20A
0005432359691	6381	60	20C
0005432359669	6381	61	20D
0005432359696	6381	62	20E
0005432359701	6381	63	21B
0005432335868	6381	64	21D
0005432062153	6381	65	21E
0005432359687	6381	66	21F
0005432359666	6381	67	22B
0005432335866	6381	68	22A
0005432359697	6381	69	22D
0005432359686	6381	70	22F
0005432062154	6381	71	23C
0005432359673	6381	72	23E
0005435176689	21014	1	1D
0005435490183	21014	2	4B
0005435176688	21014	3	4E
0005435176692	21014	4	4F
0005434149561	21014	5	5E
0005435176675	21014	6	5F
0005435176677	21014	7	6F
0005434149560	21014	8	7C
0005434149566	21014	9	7E
0005434149563	21014	10	8D
0005435176674	21014	11	9F
0005435176683	21014	12	9E
0005434149557	21014	13	10C
0005435176691	21014	14	10B
0005435490181	21014	15	10E
0005435176693	21014	16	11B
0005432052702	21014	17	12C
0005435490182	21014	18	12F
0005435723017	21014	19	13A
0005435176680	21014	20	13E
0005435176684	21014	21	14C
0005435176673	21014	22	14E
0005432052701	21014	23	15A
0005434149567	21014	24	15C
0005432052703	21014	25	15D
0005435176671	21014	26	16B
0005435723018	21014	27	16C
0005435176685	21014	28	16D
0005435176695	21014	29	16F
0005435176694	21014	30	16E
0005435723019	21014	31	18A
0005434149562	21014	32	18B
0005435176682	21014	33	18C
0005435176676	21014	34	18D
0005434149558	21014	35	18F
0005435176686	21014	36	18E
0005435176679	21014	37	19E
0005434149564	21014	38	20B
0005435176678	21014	39	20A
0005435723016	21014	40	20D
0005435176672	21014	41	20F
0005434149565	21014	42	21A
0005435176687	21014	43	21D
0005435176681	21014	44	22A
0005435176697	21014	45	23A
0005435176670	21014	46	22F
0005434149559	21014	47	23B
0005435176696	21014	48	23E
0005435176690	21014	49	23F
0005434186158	17720	1	3B
0005434186157	17720	2	6A
0005434186159	17720	3	6C
0005434458499	29085	1	1A
0005434458505	29085	2	1B
0005434458513	29085	3	1C
0005434458512	29085	4	1D
0005434448262	29085	5	2A
0005434458500	29085	6	2B
0005434458514	29085	7	2C
0005434458507	29085	8	2D
0005434458508	29085	9	3A
0005434448263	29085	10	3C
0005434458502	29085	11	3D
0005434458503	29085	12	5A
0005434448261	29085	13	5B
0005434458515	29085	14	5C
0005434463897	29085	15	6A
0005434448264	29085	16	6D
0005434458517	29085	17	7A
0005434458511	29085	18	7B
0005434458498	29085	19	7D
0005434458510	29085	20	18A
0005434458509	29085	21	18C
0005434462757	29085	22	19C
0005434462758	29085	23	20B
0005434463896	29085	24	20C
0005434458504	29085	25	20D
0005434458516	29085	26	21A
0005434458518	29085	27	21B
0005434458497	29085	28	21C
0005434462756	29085	29	21D
0005434458506	29085	30	22C
0005434458501	29085	31	22D
0005432603737	21458	1	1A
0005432603760	21458	2	1C
0005432603751	21458	3	1D
0005432603734	21458	4	2A
0005432603724	21458	5	2C
0005432603745	21458	6	2D
0005432603750	21458	7	3A
0005432603744	21458	8	3B
0005432603743	21458	9	3C
0005432603742	21458	10	3D
0005432603740	21458	11	4B
0005432603727	21458	12	4C
0005432603736	21458	13	4D
0005432603733	21458	14	5A
0005432603728	21458	15	5B
0005432603753	21458	16	5C
0005432603747	21458	17	5D
0005432603738	21458	18	6A
0005432603735	21458	19	6C
0005432603758	21458	20	6D
0005432603752	21458	21	7B
0005432603739	21458	22	7C
0005432603757	21458	23	7D
0005432603726	21458	24	18A
0005432603725	21458	25	18B
0005432603732	21458	26	18C
0005432603746	21458	27	18D
0005432603748	21458	28	19A
0005432603729	21458	29	19D
0005432603749	21458	30	20B
0005432603723	21458	31	20C
0005432603731	21458	32	20D
0005432603754	21458	33	21A
0005432603761	21458	34	21B
0005432603759	21458	35	21C
0005432603762	21458	36	21D
0005432603730	21458	37	22B
0005432603741	21458	38	22C
0005432603755	21458	39	23A
0005432603756	21458	40	23B
0005435221501	31665	1	2B
0005435221502	31665	2	2D
0005435221040	31665	3	3B
0005435221038	31665	4	6B
0005435221039	31665	5	18B
0005435154580	12304	1	1D
0005435154583	12304	2	2D
0005435154581	12304	3	3B
0005435154582	12304	4	4A
0005435154584	12304	5	5C
0005435154585	12304	6	18B
0005434606769	22389	1	2B
0005434604845	22389	2	3B
0005434606768	22389	3	4A
0005434606770	22389	4	4B
0005434606771	22389	5	5B
0005432747005	387	1	1C
0005432751476	387	2	1F
0005432747013	387	3	2D
0005432747016	387	4	2F
0005432219942	387	5	3A
0005432751474	387	6	3C
0005432747006	387	7	3D
0005432747008	387	8	3F
0005432746995	387	9	4C
0005432747019	387	10	4E
0005432746990	387	11	4F
0005432746985	387	12	5D
0005432746994	387	13	5F
0005432753248	387	14	6A
0005435154587	387	15	6D
0005432749752	387	16	6E
0005432746997	387	17	6F
0005432746999	387	18	7C
0005432747002	387	19	7E
0005432219941	387	20	8A
0005432219940	387	21	8E
0005432747012	387	22	8F
0005432747010	387	23	9C
0005432746984	387	24	9D
0005432753250	387	25	9E
0005432747001	387	26	11A
0005432747020	387	27	11D
0005432746988	387	28	11E
0005432751475	387	29	12A
0005432747021	387	30	12D
0005432747011	387	31	13A
0005432749751	387	32	13D
0005432746986	387	33	13F
0005432746998	387	34	14A
0005432746982	387	35	14C
0005432746993	387	36	14D
0005432747017	387	37	14E
0005435154588	387	38	15F
0005432746992	387	39	16A
0005435154586	387	40	16C
0005432746996	387	41	16D
0005432747018	387	42	16F
0005432747004	387	43	17A
0005432753249	387	44	17C
0005432746989	387	45	17D
0005432746991	387	46	17F
0005432747015	387	47	18A
0005432746987	387	48	18D
0005432747003	387	49	18E
0005432219939	387	50	19A
0005432753251	387	51	19C
0005432747007	387	52	19E
0005432746983	387	53	19F
0005432747009	387	54	20A
0005432747014	387	55	20C
0005432747000	387	56	20D
0005433293157	12074	1	1C
0005432890743	12074	2	1F
0005432890748	12074	3	2A
0005432890731	12074	4	2F
0005432890735	12074	5	3D
0005432890739	12074	6	3F
0005433293156	12074	7	4A
0005433293152	12074	8	4C
0005432890745	12074	9	4D
0005433293148	12074	10	4F
0005432890730	12074	11	5A
0005432890741	12074	12	5C
0005433293149	12074	13	5E
0005433293150	12074	14	6F
0005433293158	12074	15	7C
0005432214771	12074	16	7F
0005432890747	12074	17	8A
0005432890736	12074	18	8D
0005432890737	12074	19	8F
0005434153517	12074	20	9C
0005432214772	12074	21	9E
0005432890733	12074	22	9F
0005432890746	12074	23	10D
0005432746864	12074	24	10E
0005434153516	12074	25	11A
0005432890734	12074	26	11C
0005433293153	12074	27	11D
0005432890742	12074	28	12A
0005433293163	12074	29	12E
0005432890744	12074	30	12F
0005433293159	12074	31	14F
0005433293155	12074	32	14E
0005432890732	12074	33	15A
0005433875357	12074	34	15E
0005432890738	12074	35	16F
0005433293154	12074	36	17A
0005433293162	12074	37	18A
0005433293161	12074	38	18C
0005432890729	12074	39	18E
0005433293151	12074	40	19A
0005432890740	12074	41	19E
0005433293160	12074	42	20A
0005433524879	18940	1	1B
0005433524880	18940	2	1D
0005433533249	18940	3	2D
0005433533248	18940	4	4B
0005433533250	18940	5	4C
0005433524876	18940	6	4D
0005433524873	18940	7	5A
0005433524877	18940	8	5D
0005433524874	18940	9	6A
0005433533251	18940	10	6C
0005433524871	18940	11	7B
0005433524875	18940	12	7D
0005433531235	18940	13	18B
0005433533252	18940	14	19C
0005433524870	18940	15	20A
0005433531236	18940	16	20C
0005433524872	18940	17	20D
0005433524878	18940	18	21B
0005433531234	18940	19	22A
0005432927906	32458	1	1B
0005432927903	32458	2	5D
0005432927904	32458	3	6D
0005432927907	32458	4	7B
0005432927908	32458	5	18D
0005432927905	32458	6	23A
0005434821732	5286	1	1G
0005434821742	5286	2	2A
0005434821726	5286	3	1K
0005434821706	5286	4	2H
0005434821757	5286	5	2G
0005434821777	5286	6	3A
0005434821767	5286	7	3D
0005434821704	5286	8	4C
0005434821790	5286	9	4A
0005435149840	5286	10	4G
0005434821703	5286	11	5A
0005434821756	5286	12	11A
0005434821785	5286	13	5K
0005434821824	5286	14	11E
0005434821759	5286	15	11F
0005434821774	5286	16	11H
0005434821710	5286	17	12C
0005434821723	5286	18	12F
0005434821739	5286	19	12E
0005432396185	5286	20	13A
0005434821713	5286	21	13D
0005434821709	5286	22	13G
0005434828654	5286	23	14A
0005434558158	5286	24	14D
0005432396183	5286	25	14F
0005434821809	5286	26	14E
0005434821735	5286	27	14K
0005434821720	5286	28	14G
0005432121126	5286	29	15C
0005434821789	5286	30	15A
0005434821778	5286	31	15K
0005434821734	5286	32	16C
0005435372139	5286	33	16F
0005434821718	5286	34	16E
0005434821754	5286	35	16H
0005434821803	5286	36	16K
0005434821702	5286	37	17E
0005432121136	5286	38	17C
0005434821729	5286	39	17G
0005434821725	5286	40	17K
0005434821769	5286	41	18A
0005434821764	5286	42	18E
0005434821822	5286	43	18D
0005435149832	5286	44	18H
0005435149831	5286	45	19J
0005434821804	5286	46	19H
0005434821708	5286	47	20A
0005434821793	5286	48	20B
0005434821786	5286	49	20J
0005434821750	5286	50	21A
0005434821808	5286	51	21D
0005432394046	5286	52	21B
0005432121125	5286	53	21F
0005434821755	5286	54	21J
0005434821727	5286	55	22A
0005434821773	5286	56	22G
0005434821768	5286	57	22K
0005435149833	5286	58	23B
0005434821807	5286	59	23A
0005434821795	5286	60	23D
0005435149837	5286	61	23C
0005434821766	5286	62	23J
0005434821744	5286	63	25C
0005434821771	5286	64	25E
0005434821775	5286	65	25H
0005434821783	5286	66	25G
0005434821797	5286	67	25J
0005434831079	5286	68	26E
0005434821811	5286	69	26D
0005435149836	5286	70	26C
0005434821707	5286	71	26G
0005432121132	5286	72	26F
0005432121134	5286	73	26H
0005434821736	5286	74	27A
0005434821737	5286	75	26K
0005434821782	5286	76	27C
0005432121135	5286	77	27B
0005432121128	5286	78	27F
0005434821792	5286	79	27E
0005434821753	5286	80	27H
0005434821788	5286	81	27G
0005434821776	5286	82	28E
0005434821714	5286	83	28C
0005434821794	5286	84	28H
0005432121138	5286	85	28G
0005432121130	5286	86	29A
0005434558159	5286	87	29D
0005432121139	5286	88	29E
0005432394045	5286	89	29H
0005435149827	5286	90	30B
0005434828655	5286	91	30E
0005434821801	5286	92	30C
0005434821825	5286	93	31E
0005434821791	5286	94	31G
0005434821760	5286	95	31K
0005434831076	5286	96	31J
0005432394044	5286	97	32A
0005434821712	5286	98	32G
0005434821780	5286	99	32F
0005435149830	5286	100	32K
0005432396184	5286	101	33D
0005434821762	5286	102	33J
0005434821823	5286	103	34A
0005434821813	5286	104	34B
0005434821716	5286	105	34D
0005434558157	5286	106	34C
0005434821814	5286	107	34H
0005434831080	5286	108	34G
0005434821829	5286	109	34F
0005434821711	5286	110	35B
0005434821733	5286	111	34K
0005435149828	5286	112	35C
0005434821802	5286	113	35F
0005434821724	5286	114	35E
0005434821799	5286	115	35G
0005434821806	5286	116	36A
0005434821815	5286	117	35J
0005434821743	5286	118	36B
0005434821800	5286	119	36H
0005432121127	5286	120	36K
0005435149838	5286	121	37B
0005434821701	5286	122	37G
0005434821748	5286	123	37F
0005434831077	5286	124	37J
0005434821763	5286	125	37H
0005434821700	5286	126	38A
0005434821705	5286	127	38C
0005434821821	5286	128	38K
0005432394047	5286	129	39B
0005434558155	5286	130	39A
0005434821761	5286	131	39G
0005434821745	5286	132	39H
0005434821818	5286	133	39J
0005432396186	5286	134	40C
0005434821749	5286	135	40E
0005434821798	5286	136	40H
0005434821731	5286	137	41B
0005434821751	5286	138	41A
0005432121129	5286	139	41C
0005434821784	5286	140	41G
0005435149829	5286	141	42B
0005434821741	5286	142	42E
0005434821819	5286	143	42D
0005434821826	5286	144	42H
0005434821738	5286	145	42K
0005434821820	5286	146	42J
0005434821715	5286	147	43B
0005434821817	5286	148	43F
0005434821728	5286	149	43K
0005432121137	5286	150	44B
0005434821721	5286	151	44E
0005434821779	5286	152	44D
0005434821747	5286	153	44G
0005434821812	5286	154	44J
0005434558156	5286	155	45A
0005434821746	5286	156	45D
0005434821781	5286	157	45C
0005434831081	5286	158	45B
0005434821772	5286	159	45E
0005434821758	5286	160	45H
0005434821787	5286	161	45K
0005434821717	5286	162	46A
0005432121133	5286	163	46E
0005435149834	5286	164	46F
0005432121131	5286	165	46H
0005434821828	5286	166	47C
0005434831078	5286	167	47A
0005434821719	5286	168	46K
0005434821827	5286	169	47G
0005434821740	5286	170	47F
0005434821730	5286	171	48A
0005434821796	5286	172	47H
0005434821722	5286	173	48H
0005434821816	5286	174	48G
0005435149835	5286	175	49A
0005434821765	5286	176	49D
0005434664925	5286	177	49C
0005434821752	5286	178	49G
0005434821805	5286	179	49F
0005434821810	5286	180	50F
0005435149839	5286	181	51E
0005434821770	5286	182	51G
0005435735074	9929	1	1C
0005435372344	9929	2	1G
0005435735070	9929	3	1D
0005435386476	9929	4	2D
0005435372298	9929	5	2C
0005435735073	9929	6	2K
0005435372354	9929	7	4H
0005435372345	9929	8	11E
0005435386479	9929	9	12F
0005435386475	9929	10	13A
0005435372300	9929	11	13G
0005435372333	9929	12	14A
0005435372324	9929	13	14E
0005435372327	9929	14	14G
0005435372330	9929	15	14K
0005435386480	9929	16	17C
0005435372309	9929	17	18A
0005435372336	9929	18	17K
0005435372359	9929	19	18C
0005435372355	9929	20	18D
0005435372341	9929	21	18K
0005435372329	9929	22	19A
0005435372358	9929	23	19E
0005435372337	9929	24	19H
0005435372296	9929	25	20D
0005435302130	9929	26	20G
0005435372319	9929	27	22E
0005435302131	9929	28	22G
0005435372304	9929	29	23C
0005435372360	9929	30	25A
0005435386477	9929	31	24G
0005435372356	9929	32	25D
0005435372348	9929	33	25F
0005432823423	9929	34	26A
0005435372328	9929	35	26G
0005432202958	9929	36	26F
0005435372299	9929	37	26H
0005435372318	9929	38	27A
0005435372347	9929	39	27F
0005432202962	9929	40	27H
0005435372294	9929	41	27K
0005435372315	9929	42	29A
0005435372308	9929	43	29F
0005435372340	9929	44	29H
0005435372331	9929	45	29K
0005435372310	9929	46	29J
0005435372313	9929	47	30H
0005435372334	9929	48	31F
0005435386473	9929	49	31E
0005432202959	9929	50	31H
0005435299709	9929	51	32D
0005435372349	9929	52	32H
0005435299707	9929	53	32G
0005435372312	9929	54	33C
0005435735071	9929	55	33B
0005435372295	9929	56	33E
0005435372338	9929	57	34A
0005435372352	9929	58	34K
0005432202960	9929	59	34J
0005432202961	9929	60	35G
0005435372332	9929	61	36C
0005435372316	9929	62	36G
0005435372323	9929	63	37D
0005435372305	9929	64	37F
0005435372335	9929	65	38A
0005435372346	9929	66	37J
0005432202957	9929	67	38B
0005435372351	9929	68	39A
0005435372357	9929	69	40A
0005435302133	9929	70	40F
0005435386478	9929	71	40E
0005435372322	9929	72	40H
0005434821415	9929	73	40K
0005435302132	9929	74	41F
0005435372297	9929	75	41G
0005435372314	9929	76	41K
0005435372303	9929	77	41J
0005435372311	9929	78	42J
0005435372307	9929	79	43D
0005435372302	9929	80	43F
0005435372321	9929	81	43G
0005435372293	9929	82	44A
0005435372353	9929	83	44C
0005435372326	9929	84	44K
0005435372343	9929	85	45H
0005435299708	9929	86	46A
0005435372317	9929	87	46E
0005435372342	9929	88	46F
0005435372301	9929	89	46K
0005435299706	9929	90	47D
0005432823422	9929	91	47G
0005435372350	9929	92	48C
0005435735072	9929	93	48A
0005435372320	9929	94	48H
0005435661890	9929	95	49D
0005435299705	9929	96	49C
0005435386474	9929	97	49G
0005435372325	9929	98	50E
0005435372339	9929	99	50H
0005435372306	9929	100	51F
0005435082674	7014	1	1A
0005435082671	7014	2	4C
0005435082673	7014	3	7B
0005435082672	7014	4	7C
0005435790265	7014	5	18B
0005435082670	7014	6	19B
0005435082676	7014	7	19C
0005435082675	7014	8	20B
0005435790264	7014	9	22B
0005435082677	7014	10	22C
0005434755845	9563	1	1C
0005434755824	9563	2	2A
0005434755865	9563	3	2C
0005434755844	9563	4	2D
0005434755830	9563	5	3A
0005434755855	9563	6	3F
0005434755857	9563	7	4D
0005434755869	9563	8	4E
0005434755851	9563	9	4F
0005434755862	9563	10	5A
0005434755849	9563	11	5E
0005434755836	9563	12	5F
0005434755864	9563	13	6A
0005434755868	9563	14	6D
0005434755867	9563	15	7C
0005434755861	9563	16	7D
0005434755853	9563	17	7F
0005434755856	9563	18	8C
0005434755841	9563	19	8F
0005434755852	9563	20	9F
0005434755854	9563	21	10A
0005434755827	9563	22	10E
0005434755834	9563	23	10F
0005434755831	9563	24	11C
0005434755866	9563	25	12A
0005434755835	9563	26	12E
0005434755850	9563	27	12F
0005434755826	9563	28	13D
0005434755837	9563	29	13E
0005434755825	9563	30	13F
0005434755860	9563	31	14A
0005434755828	9563	32	14D
0005434755838	9563	33	14E
0005434755843	9563	34	15E
0005434755832	9563	35	15F
0005434755840	9563	36	16C
0005434755847	9563	37	16E
0005434755863	9563	38	17A
0005434755858	9563	39	17C
0005434755846	9563	40	17D
0005434755870	9563	41	17E
0005434755859	9563	42	18F
0005434755829	9563	43	19A
0005434755842	9563	44	19D
0005434755839	9563	45	19E
0005434755833	9563	46	20D
0005434755848	9563	47	20E
0005434213798	28612	1	1C
0005434213805	28612	2	1F
0005434213801	28612	3	2A
0005434213809	28612	4	2C
0005434213833	28612	5	2D
0005434213835	28612	6	2F
0005434213810	28612	7	3D
0005434213807	28612	8	4A
0005434213797	28612	9	4C
0005434213832	28612	10	4E
0005434213837	28612	11	4F
0005434213795	28612	12	5A
0005434213840	28612	13	5C
0005434213827	28612	14	5D
0005434213802	28612	15	5E
0005434213816	28612	16	6A
0005434213824	28612	17	6E
0005434213817	28612	18	7A
0005434213829	28612	19	7E
0005434213839	28612	20	7F
0005434213823	28612	21	8C
0005434213808	28612	22	8D
0005434213815	28612	23	9A
0005434213831	28612	24	9D
0005434213814	28612	25	10A
0005434213803	28612	26	10F
0005434213820	28612	27	11D
0005434213819	28612	28	11E
0005434213821	28612	29	12C
0005434213800	28612	30	13C
0005434213818	28612	31	13D
0005434213830	28612	32	13F
0005434213828	28612	33	14C
0005434213838	28612	34	14D
0005434213806	28612	35	14E
0005434213796	28612	36	15E
0005434213804	28612	37	15F
0005434213836	28612	38	16D
0005434213834	28612	39	17A
0005434213822	28612	40	17E
0005434213813	28612	41	17F
0005434213811	28612	42	18D
0005434213825	28612	43	18E
0005434213794	28612	44	18F
0005434213799	28612	45	19A
0005434213812	28612	46	19C
0005434213826	28612	47	19D
0005435100079	10828	1	7C
0005435100080	10828	2	19D
0005435100078	10828	3	21D
0005434760161	31809	1	1A
0005434760162	31809	2	2B
0005434638938	1965	1	1B
0005434638944	1965	2	1C
0005434638933	1965	3	1D
0005434638939	1965	4	2A
0005434638942	1965	5	2B
0005435948308	1965	6	3A
0005434638941	1965	7	3B
0005435948310	1965	8	3C
0005434638929	1965	9	3D
0005434638952	1965	10	4B
0005434638935	1965	11	4C
0005434638936	1965	12	4D
0005432290589	1965	13	5A
0005435948309	1965	14	5B
0005434638937	1965	15	5D
0005434638953	1965	16	6A
0005434638947	1965	17	6B
0005434638943	1965	18	6D
0005434638934	1965	19	7B
0005434638945	1965	20	7D
0005434638954	1965	21	18C
0005434638931	1965	22	18D
0005434638928	1965	23	19A
0005432290590	1965	24	19D
0005434638949	1965	25	20C
0005434638948	1965	26	20D
0005434638946	1965	27	21A
0005432290588	1965	28	21B
0005434638950	1965	29	21C
0005434638951	1965	30	21D
0005434638940	1965	31	22C
0005434638932	1965	32	22D
0005434638955	1965	33	23A
0005434638930	1965	34	23B
0005433202134	23256	1	1B
0005433202135	23256	2	1D
0005433202133	23256	3	2B
0005433202145	23256	4	3C
0005433202143	23256	5	4D
0005433202142	23256	6	5D
0005433202140	23256	7	6A
0005433202141	23256	8	6D
0005433202139	23256	9	18A
0005433202144	23256	10	18B
0005433202138	23256	11	19A
0005433202146	23256	12	20D
0005433202136	23256	13	23A
0005433202137	23256	14	23B
0005434600411	6040	1	1C
0005434600410	6040	2	1D
0005432111234	6040	3	1F
0005434600424	6040	4	2A
0005434600428	6040	5	3A
0005432111236	6040	6	5C
0005434600429	6040	7	5D
0005434600433	6040	8	6C
0005433531238	6040	9	6D
0005434600430	6040	10	6F
0005434600423	6040	11	7A
0005434600427	6040	12	8A
0005433533253	6040	13	8C
0005433531237	6040	14	8D
0005434600425	6040	15	9F
0005434600418	6040	16	10E
0005433531240	6040	17	11D
0005434600422	6040	18	11E
0005434600415	6040	19	11F
0005432111235	6040	20	12C
0005434600414	6040	21	12F
0005433533254	6040	22	13A
0005434600417	6040	23	13D
0005434600412	6040	24	13F
0005433533255	6040	25	14D
0005433533256	6040	26	14E
0005434600420	6040	27	14F
0005434600419	6040	28	16A
0005434600426	6040	29	16C
0005434600413	6040	30	17D
0005433531239	6040	31	17F
0005434600432	6040	32	18A
0005434600421	6040	33	18F
0005434600434	6040	34	19A
0005434600416	6040	35	19D
0005434600436	6040	36	20C
0005434600431	6040	37	20A
0005434600435	6040	38	20F
0005435326553	18579	1	2D
0005435326547	18579	2	3C
0005435326551	18579	3	4C
0005435326549	18579	4	5A
0005435326543	18579	5	5D
0005435326548	18579	6	5E
0005435326539	18579	7	7E
0005435326542	18579	8	8D
0005435326544	18579	9	10C
0005435326540	18579	10	11A
0005435326552	18579	11	12A
0005435326546	18579	12	14C
0005435326541	18579	13	17C
0005435326550	18579	14	18C
0005435326545	18579	15	20A
0005434550388	10640	1	1C
0005434550394	10640	2	1F
0005434550415	10640	3	2A
0005434550400	10640	4	2C
0005434550404	10640	5	2D
0005434550420	10640	6	3A
0005434550407	10640	7	3D
0005434554030	10640	8	3F
0005434550372	10640	9	4A
0005434554031	10640	10	4C
0005434550381	10640	11	4D
0005434550369	10640	12	4E
0005434550393	10640	13	4F
0005434550376	10640	14	5A
0005434550380	10640	15	5C
0005434550386	10640	16	5D
0005434550373	10640	17	5E
0005434550375	10640	18	5F
0005434550423	10640	19	6A
0005434550398	10640	20	6D
0005434550387	10640	21	6E
0005434550410	10640	22	6F
0005434550418	10640	23	7C
0005434550411	10640	24	7D
0005434550370	10640	25	8C
0005434550396	10640	26	9A
0005434550378	10640	27	9D
0005434550374	10640	28	9E
0005434550402	10640	29	9F
0005434550403	10640	30	10A
0005434550408	10640	31	10F
0005434550379	10640	32	11A
0005434550382	10640	33	11C
0005434550424	10640	34	11E
0005434558154	10640	35	11F
0005434550377	10640	36	12A
0005434550417	10640	37	12C
0005434558151	10640	38	12D
0005434558150	10640	39	13A
0005434550416	10640	40	13C
0005434550392	10640	41	14A
0005434550390	10640	42	14C
0005434558152	10640	43	14D
0005434550422	10640	44	14F
0005434558153	10640	45	15D
0005434550385	10640	46	15F
0005434550389	10640	47	16C
0005434550397	10640	48	16D
0005434550405	10640	49	16E
0005434550406	10640	50	16F
0005434550384	10640	51	17A
0005434558149	10640	52	17E
0005434550414	10640	53	17F
0005434550409	10640	54	18C
0005434550399	10640	55	18D
0005434550383	10640	56	19A
0005434550421	10640	57	19C
0005434550395	10640	58	19D
0005434550412	10640	59	19E
0005434550413	10640	60	19F
0005434550371	10640	61	20A
0005434550401	10640	62	20C
0005434550391	10640	63	20D
0005434550419	10640	64	20E
0005433180734	27727	1	2C
0005433180736	27727	2	3F
0005433180730	27727	3	5A
0005433180749	27727	4	5C
0005433180738	27727	5	5D
0005433180726	27727	6	5F
0005433180739	27727	7	8A
0005433180735	27727	8	8E
0005433180744	27727	9	9D
0005433180727	27727	10	10A
0005433180745	27727	11	10C
0005433180728	27727	12	11A
0005433180750	27727	13	11E
0005433180737	27727	14	13D
0005433180729	27727	15	14A
0005433180743	27727	16	14C
0005433180748	27727	17	14F
0005433180740	27727	18	15C
0005433180742	27727	19	15D
0005433180733	27727	20	17A
0005433180746	27727	21	19C
0005433180731	27727	22	19D
0005433180732	27727	23	19F
0005433180741	27727	24	20A
0005433180747	27727	25	20E
0005434550291	27726	1	8C
0005434550290	27726	2	10E
0005433459157	6133	1	1B
0005433459158	6133	2	3A
0005433459156	6133	3	5A
0005433459159	6133	4	5B
0005435254437	19297	1	2A
0005435254439	19297	2	3B
0005435254438	19297	3	4A
0005435661887	6750	1	1C
0005435681542	6750	2	1D
0005435681513	6750	3	1F
0005435681526	6750	4	2A
0005432136095	6750	5	2F
0005435661888	6750	6	3A
0005435681548	6750	7	3F
0005435681533	6750	8	4A
0005435661885	6750	9	4C
0005435681518	6750	10	4D
0005435681547	6750	11	4E
0005435681525	6750	12	5A
0005435720120	6750	13	5D
0005435681535	6750	14	6A
0005435681541	6750	15	6E
0005435630922	6750	16	7A
0005435681540	6750	17	7C
0005435681508	6750	18	7D
0005435681522	6750	19	7E
0005435681523	6750	20	8E
0005435681543	6750	21	8F
0005435681517	6750	22	9A
0005435681524	6750	23	9E
0005435681544	6750	24	9F
0005435681530	6750	25	10D
0005432136094	6750	26	10E
0005435681531	6750	27	11A
0005435681515	6750	28	11E
0005435681537	6750	29	12A
0005435681534	6750	30	12C
0005435681546	6750	31	12D
0005435630921	6750	32	12E
0005432136096	6750	33	13A
0005435681511	6750	34	13C
0005435681520	6750	35	13D
0005432136097	6750	36	14A
0005435681545	6750	37	14C
0005432136099	6750	38	14D
0005435681529	6750	39	14F
0005435681528	6750	40	15A
0005435681536	6750	41	15C
0005435681532	6750	42	15D
0005435681514	6750	43	15E
0005435681538	6750	44	16A
0005435661886	6750	45	16C
0005435681509	6750	46	16F
0005435681521	6750	47	17A
0005435681519	6750	48	17C
0005435681527	6750	49	17D
0005435720121	6750	50	18C
0005435661889	6750	51	18D
0005435681516	6750	52	18E
0005432136098	6750	53	19A
0005435681510	6750	54	19D
0005432136100	6750	55	19E
0005435630919	6750	56	19F
0005435681512	6750	57	20A
0005435681539	6750	58	20C
0005435719552	6750	59	20D
0005435630920	6750	60	20E
0005435219169	24609	1	1A
0005435437621	24609	2	1C
0005435437620	24609	3	1D
0005435437639	24609	4	2A
0005435220286	24609	5	3A
0005435437623	24609	6	4A
0005435437630	24609	7	4E
0005432533250	24609	8	5D
0005432305713	24609	9	5E
0005434828656	24609	10	5F
0005435220289	24609	11	6A
0005435219166	24609	12	6E
0005435219167	24609	13	6F
0005434828657	24609	14	7A
0005435437638	24609	15	7D
0005435437629	24609	16	8D
0005435437640	24609	17	9F
0005435437634	24609	18	10A
0005435437636	24609	19	10C
0005435437632	24609	20	10D
0005435220288	24609	21	11F
0005435437633	24609	22	12C
0005435220488	24609	23	13A
0005435437625	24609	24	13D
0005435220287	24609	25	13E
0005435220285	24609	26	13F
0005432533249	24609	27	14D
0005435437622	24609	28	14E
0005435437631	24609	29	14F
0005434828658	24609	30	15A
0005432305712	24609	31	15E
0005435219168	24609	32	16A
0005435437637	24609	33	16D
0005432533251	24609	34	16E
0005435437628	24609	35	17D
0005435437641	24609	36	17E
0005435437642	24609	37	18C
0005435437624	24609	38	18D
0005435220290	24609	39	18F
0005435437626	24609	40	19E
0005435219170	24609	41	19F
0005435437635	24609	42	20C
0005435437627	24609	43	20D
0005435125733	11543	1	1A
0005435125759	11543	2	1D
0005435125758	11543	3	1F
0005435125750	11543	4	2D
0005435125731	11543	5	3C
0005435125756	11543	6	3D
0005435125769	11543	7	5A
0005435125765	11543	8	5C
0005435125734	11543	9	5D
0005435105933	11543	10	6A
0005435125745	11543	11	6C
0005435125738	11543	12	6D
0005435125749	11543	13	6E
0005435125763	11543	14	7A
0005435125743	11543	15	7E
0005435125762	11543	16	7F
0005435125737	11543	17	8C
0005435125736	11543	18	8E
0005435125768	11543	19	9C
0005435105932	11543	20	9D
0005435125732	11543	21	9E
0005435125764	11543	22	9F
0005435125767	11543	23	10A
0005435125730	11543	24	10C
0005435125746	11543	25	10E
0005435125748	11543	26	10F
0005435125747	11543	27	11E
0005435125766	11543	28	11F
0005435105934	11543	29	12D
0005435125751	11543	30	12E
0005435125760	11543	31	12F
0005435125741	11543	32	13C
0005435125753	11543	33	13D
0005435125742	11543	34	14A
0005435125739	11543	35	15A
0005435125771	11543	36	15C
0005435125770	11543	37	15F
0005435125754	11543	38	16D
0005435125757	11543	39	16E
0005435105935	11543	40	17C
0005435105936	11543	41	17D
0005435125761	11543	42	18A
0005435125744	11543	43	18C
0005435125735	11543	44	18E
0005435125755	11543	45	18F
0005435125752	11543	46	19F
0005435125740	11543	47	20F
0005435558049	31880	1	1C
0005435105929	31880	2	4D
0005435558048	31880	3	7D
0005435558050	31880	4	15F
0005435105928	31880	5	18E
0005433397344	13505	1	1A
0005433397338	13505	2	1D
0005433397365	13505	3	1F
0005433397369	13505	4	2C
0005433397328	13505	5	2D
0005433397342	13505	6	2F
0005433397345	13505	7	3A
0005433397331	13505	8	3F
0005433397378	13505	9	4C
0005433397355	13505	10	4E
0005433397332	13505	11	6A
0005433397362	13505	12	6D
0005433397353	13505	13	6E
0005433397366	13505	14	7C
0005433397347	13505	15	7E
0005433397370	13505	16	8D
0005433397364	13505	17	8F
0005433397343	13505	18	9A
0005433397358	13505	19	9C
0005433397357	13505	20	9E
0005433397333	13505	21	9F
0005433397363	13505	22	10C
0005433397371	13505	23	10D
0005433397341	13505	24	10E
0005433397354	13505	25	10F
0005433397352	13505	26	11D
0005433397336	13505	27	11F
0005433397340	13505	28	12D
0005433397376	13505	29	12F
0005433397367	13505	30	13D
0005433397330	13505	31	13E
0005433397346	13505	32	14A
0005433397348	13505	33	14C
0005433397368	13505	34	14D
0005433397375	13505	35	14E
0005433397349	13505	36	14F
0005433397360	13505	37	15A
0005433397377	13505	38	15C
0005433397373	13505	39	16C
0005433397356	13505	40	16D
0005433397337	13505	41	16E
0005433397350	13505	42	17F
0005433397359	13505	43	18A
0005433397372	13505	44	18C
0005433397339	13505	45	18D
0005433397334	13505	46	18E
0005433397374	13505	47	18F
0005433397335	13505	48	19A
0005433397361	13505	49	19C
0005433397351	13505	50	19D
0005433397329	13505	51	20D
0005432297240	19393	1	1A
0005432297238	19393	2	5D
0005435732156	19393	3	6D
0005435732152	19393	4	6E
0005435732154	19393	5	8A
0005435732159	19393	6	8E
0005435732155	19393	7	10F
0005435732158	19393	8	12C
0005435732157	19393	9	13C
0005435732161	19393	10	13E
0005435732160	19393	11	14D
0005432297239	19393	12	15D
0005435732153	19393	13	18C
0005435068283	15515	1	1A
0005435068282	15515	2	1C
0005435068296	15515	3	2A
0005435068288	15515	4	2D
0005435068280	15515	5	3C
0005435068317	15515	6	4A
0005435068308	15515	7	4C
0005435068309	15515	8	4F
0005435068311	15515	9	5E
0005435068273	15515	10	6E
0005435068284	15515	11	6F
0005435068276	15515	12	7A
0005435068285	15515	13	7C
0005435068305	15515	14	8A
0005435068270	15515	15	8E
0005435068295	15515	16	8F
0005435068268	15515	17	9E
0005435068287	15515	18	9F
0005435068293	15515	19	10A
0005435068315	15515	20	10C
0005435068290	15515	21	10D
0005435068306	15515	22	10F
0005435068297	15515	23	11E
0005435068286	15515	24	11F
0005435068264	15515	25	12D
0005435068300	15515	26	12E
0005435068304	15515	27	13A
0005435068310	15515	28	13C
0005435068279	15515	29	13D
0005435068275	15515	30	13E
0005435068294	15515	31	13F
0005435068274	15515	32	14A
0005435068272	15515	33	14C
0005435068316	15515	34	14F
0005435068298	15515	35	15A
0005435068271	15515	36	15C
0005435068269	15515	37	15F
0005435068313	15515	38	16A
0005435068314	15515	39	16C
0005435068312	15515	40	16D
0005435068281	15515	41	17A
0005435068266	15515	42	17C
0005435068303	15515	43	17D
0005435068265	15515	44	17E
0005435068277	15515	45	17F
0005435068289	15515	46	18A
0005435068292	15515	47	18C
0005435068299	15515	48	18D
0005435068301	15515	49	18F
0005435068307	15515	50	19C
0005435068291	15515	51	19D
0005435068267	15515	52	19E
0005435068278	15515	53	20A
0005435068302	15515	54	20F
0005435808068	23192	1	1B
0005435808067	23192	2	1D
0005435808078	23192	3	2A
0005435808076	23192	4	2C
0005435808073	23192	5	3A
0005435808074	23192	6	3C
0005435808077	23192	7	5A
0005435808080	23192	8	6A
0005435808063	23192	9	6B
0005435808066	23192	10	7A
0005435808075	23192	11	7C
0005435808071	23192	12	18D
0005435808060	23192	13	19C
0005435808065	23192	14	19D
0005435808062	23192	15	20B
0005435808072	23192	16	20C
0005435808061	23192	17	20D
0005435808069	23192	18	21B
0005435808064	23192	19	22A
0005435808079	23192	20	22C
0005435808070	23192	21	22D
0005434213851	10735	1	2A
0005434213852	10735	2	2C
0005434213866	10735	3	3C
0005434213876	10735	4	3F
0005434213870	10735	5	4A
0005434213874	10735	6	4C
0005434213862	10735	7	4D
0005434213863	10735	8	4F
0005434213883	10735	9	5A
0005434213855	10735	10	5D
0005434213871	10735	11	6C
0005434213861	10735	12	6D
0005434213882	10735	13	6F
0005434213850	10735	14	7C
0005434213860	10735	15	8A
0005434213864	10735	16	8C
0005434213867	10735	17	9C
0005434213842	10735	18	9D
0005434213848	10735	19	9E
0005434213859	10735	20	10A
0005434213875	10735	21	10C
0005434213880	10735	22	10D
0005434213879	10735	23	11C
0005434213878	10735	24	11D
0005434213853	10735	25	11E
0005434213877	10735	26	11F
0005434213888	10735	27	12A
0005434213843	10735	28	12C
0005434213854	10735	29	12D
0005434213856	10735	30	12E
0005434213869	10735	31	12F
0005434213886	10735	32	13C
0005434213885	10735	33	13D
0005434213841	10735	34	13F
0005434213857	10735	35	14A
0005434213845	10735	36	14C
0005434213846	10735	37	14E
0005434213858	10735	38	15A
0005434213849	10735	39	15C
0005434213881	10735	40	15F
0005434213868	10735	41	16E
0005434213873	10735	42	17D
0005434213847	10735	43	17E
0005434213844	10735	44	18C
0005434213872	10735	45	19A
0005434213865	10735	46	19F
0005434213887	10735	47	20A
0005434213884	10735	48	20D
0005434755803	28690	1	2C
0005434755798	28690	2	3A
0005434755813	28690	3	4D
0005434755801	28690	4	4F
0005434755800	28690	5	5A
0005434755820	28690	6	5F
0005434755784	28690	7	6A
0005434755793	28690	8	6C
0005434755789	28690	9	6D
0005434755786	28690	10	6E
0005434755817	28690	11	8A
0005434755805	28690	12	8D
0005434755808	28690	13	8F
0005434755802	28690	14	9D
0005434755791	28690	15	9E
0005434755806	28690	16	10C
0005434755818	28690	17	10E
0005434755823	28690	18	10F
0005434755812	28690	19	11E
0005434755794	28690	20	11F
0005434755796	28690	21	12C
0005434755821	28690	22	13A
0005434755816	28690	23	13D
0005434755782	28690	24	13F
0005434755822	28690	25	14E
0005434755785	28690	26	14F
0005434755783	28690	27	15A
0005434755795	28690	28	15E
0005434755815	28690	29	15F
0005434755819	28690	30	16A
0005434755804	28690	31	16D
0005434755792	28690	32	17A
0005434755814	28690	33	17C
0005434755811	28690	34	17D
0005434755797	28690	35	17F
0005434755809	28690	36	18E
0005434755807	28690	37	18F
0005434755790	28690	38	19D
0005434755788	28690	39	19E
0005434755799	28690	40	19F
0005434755810	28690	41	20D
0005434755787	28690	42	20F
0005432125345	5435	1	1A
0005435038811	5435	2	1C
0005435038824	5435	3	1D
0005435038839	5435	4	2C
0005432125342	5435	5	2D
0005435006673	5435	6	2F
0005435038859	5435	7	3C
0005435038849	5435	8	3D
0005435038829	5435	9	3F
0005435038867	5435	10	4A
0005435038808	5435	11	4C
0005435006697	5435	12	4D
0005435006685	5435	13	4E
0005435038825	5435	14	5A
0005435038843	5435	15	4F
0005435038818	5435	16	5B
0005435006684	5435	17	5C
0005435006682	5435	18	5D
0005435038863	5435	19	5F
0005435038846	5435	20	5E
0005435038827	5435	21	6A
0005435038865	5435	22	6C
0005435006674	5435	23	6B
0005435006691	5435	24	6E
0005435006676	5435	25	7A
0005435038837	5435	26	6F
0005435038822	5435	27	7C
0005435006677	5435	28	7E
0005435038864	5435	29	7D
0005435006690	5435	30	7F
0005435038813	5435	31	8B
0005435038830	5435	32	8A
0005435038853	5435	33	8D
0005435038840	5435	34	8C
0005435038852	5435	35	8F
0005435006696	5435	36	9A
0005435006681	5435	37	9B
0005435038857	5435	38	9D
0005435038845	5435	39	9F
0005435038854	5435	40	9E
0005435038870	5435	41	10B
0005435038847	5435	42	10C
0005435006692	5435	43	10E
0005435006679	5435	44	10D
0005435006672	5435	45	11A
0005435006687	5435	46	11B
0005435038817	5435	47	11C
0005435038819	5435	48	11E
0005435038821	5435	49	11D
0005435038834	5435	50	11F
0005435038815	5435	51	12A
0005435038823	5435	52	12C
0005435038835	5435	53	12D
0005432125348	5435	54	12E
0005435038812	5435	55	12F
0005435006688	5435	56	13A
0005432125347	5435	57	13C
0005435038861	5435	58	13E
0005435038805	5435	59	14B
0005435006680	5435	60	14A
0005432125344	5435	61	14C
0005435038869	5435	62	15A
0005435038832	5435	63	14F
0005435006689	5435	64	15B
0005435038855	5435	65	15D
0005435006683	5435	66	15F
0005435038868	5435	67	16A
0005435038842	5435	68	16C
0005435038814	5435	69	16B
0005435006693	5435	70	16D
0005435038828	5435	71	16F
0005435038838	5435	72	17B
0005435038858	5435	73	17A
0005435038831	5435	74	17D
0005435038810	5435	75	17F
0005435038856	5435	76	17E
0005435006695	5435	77	18A
0005435006694	5435	78	18B
0005435038826	5435	79	18D
0005435038850	5435	80	18C
0005435038866	5435	81	18E
0005435006686	5435	82	19A
0005432125343	5435	83	19B
0005435038844	5435	84	19C
0005432125341	5435	85	19E
0005435038809	5435	86	19F
0005432125346	5435	87	20C
0005435038807	5435	88	20E
0005435038833	5435	89	21A
0005435038806	5435	90	20F
0005435038841	5435	91	21B
0005435038816	5435	92	21E
0005435038836	5435	93	21F
0005435038848	5435	94	22A
0005435038851	5435	95	22C
0005435038862	5435	96	22D
0005435038860	5435	97	22F
0005435006678	5435	98	23B
0005435038820	5435	99	23C
0005435006675	5435	100	23E
0005434229056	12985	1	2C
0005434229058	12985	2	3A
0005434229054	12985	3	4A
0005434229041	12985	4	4C
0005434229055	12985	5	5A
0005434229049	12985	6	6D
0005432304343	12985	7	7B
0005434229038	12985	8	7A
0005434229052	12985	9	7C
0005434229040	12985	10	8C
0005434229036	12985	11	9C
0005434229050	12985	12	12E
0005434229044	12985	13	13A
0005434229051	12985	14	13F
0005434229048	12985	15	14C
0005434229047	12985	16	14F
0005434229039	12985	17	15C
0005434229057	12985	18	15D
0005434229053	12985	19	15F
0005432304340	12985	20	16A
0005432304342	12985	21	16D
0005434229043	12985	22	16E
0005432304341	12985	23	17D
0005434229046	12985	24	18B
0005434229035	12985	25	19F
0005434229037	12985	26	21D
0005435377900	12985	27	21E
0005434229045	12985	28	22A
0005434229042	12985	29	22D
0005434426172	14901	1	1C
0005434411711	14901	2	1F
0005434426173	14901	3	2C
0005434426159	14901	4	3D
0005434426163	14901	5	4D
0005434426157	14901	6	5D
0005434426154	14901	7	6A
0005434426161	14901	8	6C
0005434426169	14901	9	7A
0005434426167	14901	10	7C
0005434426156	14901	11	7D
0005434426158	14901	12	8C
0005434426170	14901	13	8D
0005434426146	14901	14	8E
0005434426151	14901	15	8F
0005434426148	14901	16	10A
0005434411712	14901	17	10E
0005434411710	14901	18	10F
0005434426147	14901	19	11A
0005434426160	14901	20	11C
0005434426150	14901	21	11E
0005434426155	14901	22	12D
0005432188557	14901	23	13A
0005434426165	14901	24	13F
0005434426149	14901	25	14C
0005434426153	14901	26	14F
0005432188558	14901	27	15A
0005434426171	14901	28	15C
0005434426162	14901	29	15E
0005434426152	14901	30	15F
0005434426164	14901	31	17D
0005434411713	14901	32	18A
0005434411714	14901	33	19A
0005432188559	14901	34	19E
0005432188560	14901	35	20A
0005434426166	14901	36	20D
0005434426168	14901	37	20E
0005435902448	20188	1	1F
0005435902455	20188	2	2A
0005435902454	20188	3	2C
0005435902452	20188	4	4C
0005435902447	20188	5	6C
0005435902456	20188	6	6F
0005435554119	20188	7	7D
0005435902451	20188	8	7E
0005435902446	20188	9	8C
0005435902453	20188	10	8E
0005435902440	20188	11	8F
0005435902438	20188	12	9D
0005435902443	20188	13	9E
0005435902449	20188	14	11A
0005435902445	20188	15	11D
0005435902442	20188	16	12F
0005435554118	20188	17	13C
0005435902444	20188	18	13F
0005435554122	20188	19	15A
0005435554121	20188	20	15C
0005432059476	20188	21	15E
0005435902441	20188	22	15F
0005435902439	20188	23	16D
0005435554120	20188	24	17C
0005435902450	20188	25	18E
0005434523738	30883	1	2C
0005434523739	30883	2	5E
0005434523732	30883	3	6C
0005434523740	30883	4	9B
0005434523736	30883	5	9C
0005434523734	30883	6	11B
0005434523735	30883	7	14A
0005434523731	30883	8	21C
0005434523733	30883	9	22A
0005434523737	30883	10	22C
0005435981625	26540	1	1A
0005435981634	26540	2	1D
0005435981623	26540	3	1F
0005432300176	26540	4	2A
0005435981619	26540	5	2D
0005435981644	26540	6	2F
0005435981607	26540	7	3C
0005435981631	26540	8	4E
0005435981617	26540	9	4F
0005435981614	26540	10	5A
0005435981594	26540	11	5F
0005432300172	26540	12	6C
0005435981643	26540	13	6D
0005435981635	26540	14	7C
0005435981604	26540	15	7D
0005435981626	26540	16	8A
0005435981605	26540	17	8C
0005435981640	26540	18	8D
0005435981642	26540	19	8F
0005435981621	26540	20	9A
0005435981633	26540	21	9C
0005435981595	26540	22	9D
0005435981636	26540	23	9E
0005435981602	26540	24	9F
0005435981637	26540	25	10A
0005435981630	26540	26	10C
0005435981624	26540	27	10D
0005432300177	26540	28	10E
0005435981613	26540	29	11A
0005435981622	26540	30	11C
0005435981628	26540	31	11E
0005435981618	26540	32	12C
0005435981612	26540	33	12E
0005435981639	26540	34	12F
0005432300173	26540	35	13A
0005435981641	26540	36	13D
0005435981608	26540	37	14A
0005435981599	26540	38	14C
0005432300174	26540	39	14D
0005435981620	26540	40	14F
0005435981600	26540	41	15A
0005435981615	26540	42	15C
0005435981606	26540	43	15F
0005435981638	26540	44	16A
0005435981603	26540	45	16D
0005435981627	26540	46	16E
0005435981610	26540	47	17A
0005435981611	26540	48	17D
0005435981596	26540	49	18A
0005435981601	26540	50	18C
0005435981629	26540	51	18D
0005435981632	26540	52	18F
0005432300175	26540	53	19A
0005435981616	26540	54	19E
0005435981597	26540	55	20C
0005435981598	26540	56	20D
0005435981609	26540	57	20E
0005433434270	26696	1	1D
0005433434281	26696	2	2A
0005433434286	26696	3	2F
0005433434287	26696	4	3A
0005433434284	26696	5	3C
0005433434282	26696	6	4C
0005433434288	26696	7	4E
0005433434293	26696	8	5A
0005433434272	26696	9	5D
0005434269075	26696	10	5E
0005433434294	26696	11	6A
0005433434268	26696	12	6D
0005433434275	26696	13	7C
0005433434280	26696	14	9A
0005433434289	26696	15	9C
0005433434278	26696	16	9D
0005433434276	26696	17	9E
0005433434267	26696	18	9F
0005433434266	26696	19	10F
0005433434279	26696	20	11A
0005433434285	26696	21	11E
0005433434290	26696	22	12D
0005433434271	26696	23	12E
0005432051083	26696	24	12F
0005433434269	26696	25	13D
0005433434291	26696	26	14A
0005433434283	26696	27	14D
0005433434274	26696	28	15A
0005432051085	26696	29	15C
0005434271281	26696	30	15D
0005434271283	26696	31	15F
0005433434292	26696	32	16C
0005432051084	26696	33	17F
0005433434273	26696	34	18C
0005434269074	26696	35	19C
0005434271282	26696	36	19F
0005434270177	26696	37	20A
0005433434277	26696	38	20C
0005432583676	3137	1	1A
0005432583667	3137	2	1B
0005432583680	3137	3	3B
0005432583662	3137	4	3C
0005432583673	3137	5	4A
0005432583681	3137	6	3D
0005432583665	3137	7	4B
0005432216232	3137	8	4D
0005432583670	3137	9	5A
0005432583679	3137	10	5D
0005432583666	3137	11	6B
0005432583669	3137	12	6C
0005432583661	3137	13	6D
0005432216231	3137	14	7A
0005432583668	3137	15	7B
0005432583685	3137	16	7C
0005432583675	3137	17	18A
0005432583672	3137	18	19B
0005432583683	3137	19	19C
0005432583677	3137	20	19D
0005432583682	3137	21	20A
0005432216233	3137	22	20D
0005432583674	3137	23	21A
0005432583671	3137	24	21D
0005432583663	3137	25	22A
0005432583678	3137	26	22C
0005432583664	3137	27	23A
0005432583684	3137	28	23B
0005432857887	31479	1	2A
0005432857893	31479	2	2B
0005432857892	31479	3	4D
0005432857891	31479	4	5C
0005432857896	31479	5	5D
0005432857889	31479	6	6D
0005432857897	31479	7	7B
0005432857895	31479	8	18D
0005432857894	31479	9	20D
0005432857898	31479	10	21B
0005432857890	31479	11	21D
0005432857888	31479	12	23B
0005434943218	870	1	2D
0005434943217	870	2	3C
0005434943219	870	3	4D
0005434943213	870	4	6B
0005434943220	870	5	7A
0005433255024	870	6	18B
0005433255025	870	7	19C
0005434943215	870	8	20A
0005434943214	870	9	21A
0005434943216	870	10	22D
0005434943221	870	11	23B
0005433255038	16196	1	4B
0005433255041	16196	2	5B
0005433255042	16196	3	18D
0005433255039	16196	4	19A
0005433255037	16196	5	22A
0005433255040	16196	6	23B
0005435858495	27608	1	4A
0005435858487	27608	2	5F
0005435858497	27608	3	6B
0005435858491	27608	4	6F
0005435858484	27608	5	8C
0005435858493	27608	6	9D
0005435858485	27608	7	10A
0005435858483	27608	8	10C
0005435858496	27608	9	11E
0005435858498	27608	10	12A
0005435858492	27608	11	12C
0005435858489	27608	12	13D
0005435858488	27608	13	14E
0005435858494	27608	14	15A
0005435858482	27608	15	17A
0005435858486	27608	16	16F
0005435858490	27608	17	20C
0005435858499	27608	18	21C
0005435652380	21758	1	2A
0005435652366	21758	2	2C
0005435652376	21758	3	3A
0005435652342	21758	4	3F
0005435652345	21758	5	4A
0005435652347	21758	6	4C
0005435652368	21758	7	4E
0005435652360	21758	8	5C
0005435652381	21758	9	5E
0005435652378	21758	10	6A
0005435652371	21758	11	6E
0005435652365	21758	12	7C
0005435652340	21758	13	7E
0005435652370	21758	14	8D
0005435652359	21758	15	8E
0005435652355	21758	16	9E
0005435652361	21758	17	9F
0005435652341	21758	18	10A
0005435652356	21758	19	10D
0005435652377	21758	20	10F
0005435652373	21758	21	11C
0005435652362	21758	22	11F
0005435652354	21758	23	12A
0005435652346	21758	24	12C
0005435652349	21758	25	13E
0005435652352	21758	26	13F
0005435652350	21758	27	14A
0005435652379	21758	28	14E
0005435652375	21758	29	15D
0005435652369	21758	30	16A
0005435652348	21758	31	16C
0005435652374	21758	32	16D
0005435652372	21758	33	17A
0005435652364	21758	34	17C
0005435652357	21758	35	17D
0005435652383	21758	36	17E
0005435652367	21758	37	17F
0005435652363	21758	38	18C
0005435652353	21758	39	18D
0005435652358	21758	40	18E
0005435652343	21758	41	19D
0005435652382	21758	42	19F
0005435652344	21758	43	20E
0005435652351	21758	44	20F
0005433804868	9374	1	1B
0005432657404	9374	2	1A
0005433804860	9374	3	1C
0005433784435	9374	4	1H
0005432657406	9374	5	2B
0005433804889	9374	6	2F
0005432657403	9374	7	2H
0005433763000	9374	8	3B
0005433762993	9374	9	3C
0005433804887	9374	10	3G
0005433762990	9374	11	3H
0005432665245	9374	12	4A
0005433762996	9374	13	4F
0005433784409	9374	14	5B
0005433763001	9374	15	5C
0005433784438	9374	16	5G
0005433784437	9374	17	9H
0005432657405	9374	18	11B
0005433784424	9374	19	11D
0005433784418	9374	20	11F
0005434170803	9374	21	12B
0005433804863	9374	22	12E
0005433784408	9374	23	12F
0005433784419	9374	24	13B
0005433784439	9374	25	13D
0005433804867	9374	26	13F
0005433762991	9374	27	14G
0005433804888	9374	28	15F
0005433804862	9374	29	16B
0005432665244	9374	30	16E
0005433784414	9374	31	16D
0005433804882	9374	32	16G
0005433804861	9374	33	17D
0005433784428	9374	34	17H
0005433804869	9374	35	18B
0005433784427	9374	36	18A
0005433784421	9374	37	18E
0005433804877	9374	38	19A
0005433804884	9374	39	18H
0005433784430	9374	40	19E
0005433762995	9374	41	19G
0005433804865	9374	42	20B
0005432667424	9374	43	20E
0005433804892	9374	44	20G
0005433804872	9374	45	21B
0005433784423	9374	46	21D
0005433784407	9374	47	21F
0005433784434	9374	48	21G
0005433784436	9374	49	22A
0005433804881	9374	50	22E
0005432667425	9374	51	23B
0005433804876	9374	52	23A
0005433804890	9374	53	23D
0005433762999	9374	54	24B
0005433784420	9374	55	24D
0005433784402	9374	56	24E
0005433804870	9374	57	24H
0005433784412	9374	58	27B
0005433784404	9374	59	27E
0005432667423	9374	60	27D
0005433804875	9374	61	27F
0005433804878	9374	62	27H
0005433784413	9374	63	27G
0005432657402	9374	64	28A
0005433762998	9374	65	28B
0005433784417	9374	66	28E
0005434170797	9374	67	28H
0005433784416	9374	68	28G
0005433784422	9374	69	29A
0005433784405	9374	70	29B
0005433784429	9374	71	29D
0005433804886	9374	72	29G
0005433804873	9374	73	29H
0005433784432	9374	74	30A
0005433784411	9374	75	30E
0005432666358	9374	76	30D
0005433804874	9374	77	30F
0005433804880	9374	78	31H
0005433784426	9374	79	32B
0005433762987	9374	80	32D
0005433784403	9374	81	32E
0005433762992	9374	82	32G
0005433784410	9374	83	33A
0005433804871	9374	84	33G
0005433762994	9374	85	33F
0005433804879	9374	86	33H
0005433784433	9374	87	34A
0005433784406	9374	88	34D
0005433762988	9374	89	34F
0005433784431	9374	90	34H
0005433804859	9374	91	35E
0005433784425	9374	92	36B
0005433784415	9374	93	36F
0005433804891	9374	94	36H
0005433804885	9374	95	36G
0005433784401	9374	96	37D
0005433804866	9374	97	37B
0005433804864	9374	98	37G
0005434170802	9374	99	38A
0005433804883	9374	100	37H
0005433762989	9374	101	38B
0005433762997	9374	102	39F
0005434151662	26229	1	2G
0005434170843	26229	2	4H
0005435269652	26229	3	12E
0005434170845	26229	4	14E
0005434151661	26229	5	16B
0005434269073	26229	6	17A
0005434270176	26229	7	17F
0005435269648	26229	8	18E
0005434170850	26229	9	20A
0005434170849	26229	10	21A
0005434170853	26229	11	20H
0005434170844	26229	12	21E
0005434170841	26229	13	23E
0005433784296	26229	14	24G
0005434269072	26229	15	25E
0005435269650	26229	16	25D
0005434170851	26229	17	28B
0005434170847	26229	18	28H
0005434170852	26229	19	30G
0005434269071	26229	20	31G
00054342690