package com.javacodegeeks.android.androidlistviewexample;
 
import android.app.ListActivity;
import android.os.Bundle;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.Toast;
import android.widget.AdapterView.OnItemClickListener;
 
public class MainActivity extends ListActivity {
 
	static final String[] COUNTRIES = new String[] { "Greece", "Italy", "France",
			"Spain", "Germany", "Poland", "Romania", "Turkey",
			"Switzerland", "Netherlands", "Luxembourg", "Ukrain" };
 
	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
 
		// we don't need this
		// setContentView(R.layout.countries);
 
		setListAdapter(new ArrayAdapter<String>(this, R.layout.countries,COUNTRIES));
 
		ListView listView = getListView();
		listView.setTextFilterEnabled(true);
 
		listView.setOnItemClickListener(new OnItemClickListener() {
			public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
				
			    // When clicked, show a toast with the TextView text
			    Toast.makeText(getApplicationContext(),	((TextView) view).getText(), Toast.LENGTH_SHORT).show();
			}
		});
 
	}
 
}