package com.javacodegeeks.enterprise.hibernate;

import static javax.persistence.GenerationType.IDENTITY;

import java.util.HashSet;
import java.util.Set;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
 

@Entity
@Table(name = "class", catalog = "tutorials")
public class Class implements java.io.Serializable{
	

	private Integer classID;
	
	private String title;
	private String semester;
	
	private Set<StudentClass> studentClasses = new HashSet<StudentClass>(0);
	
	
	public Class(String title, String semester){
		this.title = title;
		this.semester = semester;
	}
	

	

	@Id
	@GeneratedValue(strategy = IDENTITY)
	@Column(name = "CLASS_ID", unique = true, nullable = false)
	public Integer getClassID() {
		return classID;
	}




	public void setClassID(Integer classID) {
		this.classID = classID;
	}




	@Column(name = "TITLE", nullable = false, length = 10, unique = true)
	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	@Column(name = "SEMESTER", nullable = false, length = 255)
	public String getSemester() {
		return semester;
	}

	public void setSemester(String semester) {
		this.semester = semester;
	}


	@OneToMany(fetch = FetchType.LAZY, mappedBy = "pk.cl")
	public Set<StudentClass> getStudentClasses() {
		return studentClasses;
	}




	public void setStudentClasses(Set<StudentClass> studentClasses) {
		this.studentClasses = studentClasses;
	}


	private static final long serialVersionUID = 1L;

	

}
