package com.javacodegeeks.enterprise.hibernate;

import java.util.Date;

import javax.persistence.AssociationOverride;
import javax.persistence.AssociationOverrides;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;

@Entity
@Table(name = "student_class", catalog = "tutorials")
@AssociationOverrides({
		@AssociationOverride(name = "pk.student", 
			joinColumns = @JoinColumn(name = "ID_STUDENT")),
		@AssociationOverride(name = "pk.cl", 
			joinColumns = @JoinColumn(name = "CLASS_ID")) })
public class StudentClass implements java.io.Serializable {

	
	private static final long serialVersionUID = 4050660680047579957L;
	
	private StudentClassID pk = new StudentClassID();
	private Date registered;
	
	@EmbeddedId
	public StudentClassID getPk() {
		return pk;
	}
	
	@Transient
	public Student getStudent() {
		return getPk().getStudent();
	}
 
	public void setStudent(Student student) {
		getPk().setStudent(student);
	}
 
	@Transient
	public Class getCl() {
		return getPk().getCl();
	}
 
	public void setCl(Class c) {
		getPk().setCl(c);
	}
 
	
	public void setPk(StudentClassID pk) {
		this.pk = pk;
	}
	
	@Temporal(TemporalType.DATE)
	@Column(name = "REGISTERED", nullable = false, length = 10)
	public Date getRegistered() {
		return registered;
	}
	
	public void setRegistered(Date registered) {
		this.registered = registered;
	}

	@Override
	public int hashCode() {
		return (getPk() != null ? getPk().hashCode() : 0);
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (!(obj instanceof StudentClass))
			return false;
		StudentClass other = (StudentClass) obj;
		if (pk == null) {
			if (other.pk != null)
				return false;
		} else if (!pk.equals(other.pk))
			return false;
		if (registered == null) {
			if (other.registered != null)
				return false;
		} else if (!registered.equals(other.registered))
			return false;
		return true;
	}

}
