package com.javacodegeeks.enterprise.hibernate;


import javax.persistence.Embeddable;
import javax.persistence.ManyToOne;


@Embeddable
public class StudentClassID implements java.io.Serializable {
	

	private static final long serialVersionUID = -9120607274421816301L;
	private Student student;
	private Class cl;
	
	@ManyToOne
	public Student getStudent() {
		return student;
	}
	
	
	public void setStudent(Student student) {
		this.student = student;
	}
	
	
	@ManyToOne
	public Class getCl() {
		return cl;
	}
	
	
	public void setCl(Class cl) {
		this.cl = cl;
	}


	@Override
	public int hashCode() {
		 int result;
	        result = (student != null ? student.hashCode() : 0);
	        result = 17 * result + (cl != null ? cl.hashCode() : 0);
	        return result;
	}


	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (!(obj instanceof StudentClassID))
			return false;
		StudentClassID other = (StudentClassID) obj;
		if (cl == null) {
			if (other.cl != null)
				return false;
		} else if (!cl.equals(other.cl))
			return false;
		if (student == null) {
			if (other.student != null)
				return false;
		} else if (!student.equals(other.student))
			return false;
		return true;
	}
	
	
	
	

}
