package com.javacodegeeks.snippets.enterprise;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

import org.springframework.oxm.Marshaller;
import org.springframework.oxm.Unmarshaller;

public class Converter {
	private static final String FILE_NAME = "info.xml";
	private CustomerInfo info = new CustomerInfo();
	private Marshaller marshaller;
	private Unmarshaller unmarshaller;

	public void setMarshaller(Marshaller marshaller) {
		this.marshaller = marshaller;
	}

	public void setUnmarshaller(Unmarshaller unmarshaller) {
		this.unmarshaller = unmarshaller;
	}

	public void saveCustomerInfo() throws IOException {
		FileOutputStream os = null;
		try {
			System.out.println("--- Marshaller ---");
			os = new FileOutputStream(FILE_NAME);
			info.setName("John");
			info.setId(234l);
			info.setValid(true);
			this.marshaller.marshal(info, new StreamResult(os));
			System.out.println("CustomerInfo " + info + " saved to info.xml file. ");
		} finally {
			if (os != null) {
				os.close();
			}
		}
	}

	public void loadCustomerInfo() throws IOException {
		FileInputStream is = null;
		try {
			System.out.println("--- Unmarshaller ---");
			is = new FileInputStream(FILE_NAME);
			this.info = (CustomerInfo) this.unmarshaller
					.unmarshal(new StreamSource(is));
			System.out.println("Info loaded from xml : " + info);
		} finally {
			if (is != null) {
				is.close();
			}
		}
	}

}
